/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.Tool;

public class DataRefreshTool
implements Tool {
    private static Map<Data, DataRefreshTool> tools = new HashMap<Data, DataRefreshTool>();
    private Data data;
    protected HashSet<Data> moreData = new HashSet();
    private HashMap<Integer, Dataset> ids = new HashMap();

    public static DataRefreshTool getTool(Data data) {
        DataRefreshTool tool = tools.get(data);
        if (tool == null) {
            tool = new DataRefreshTool(data);
            tools.put(data, tool);
        }
        return tool;
    }

    private DataRefreshTool(Data data) {
        this.data = data;
    }

    @Override
    public void send(Job job, Tool replyTo) {
        XMLControlElement control = new XMLControlElement(job.getXML());
        if (control.failedToRead() || replyTo == null || !Data.class.isAssignableFrom(control.getObjectClass())) {
            return;
        }
        Data request = (Data)control.loadObject(null, true, true);
        if (request.getID() == this.data.getID()) {
            Tool.reply(replyTo, job, this, this.data);
            return;
        }
        for (Data next : DataTool.getSelfContainedData(this.data)) {
            if (request.getID() != next.getID()) continue;
            Tool.reply(replyTo, job, this, next);
            return;
        }
        ArrayList<Dataset> localDatasets = DataTool.getDatasets(this.data);
        for (Dataset next : localDatasets) {
            if (request.getID() != next.getID()) continue;
            Tool.reply(replyTo, job, this, next);
            return;
        }
        DatasetManager reply = new DatasetManager();
        reply.setName(request.getName());
        this.ids.clear();
        ArrayList<Dataset> requestedDatasets = DataTool.getDatasets(request);
        this.findDatasets(requestedDatasets, localDatasets, reply, false);
        if (!this.moreData.isEmpty()) {
            for (Data more : this.moreData) {
                localDatasets = DataTool.getDatasets(more);
                this.findDatasets(requestedDatasets, localDatasets, reply, true);
            }
            this.padDatasets(reply);
        }
        if (!reply.getDatasetsRaw().isEmpty()) {
            Tool.reply(replyTo, job, this, reply);
        }
    }

    public void addData(Data data) {
        if (data == this.data) {
            return;
        }
        this.moreData.add(data);
    }

    public void removeData(Data data) {
        this.moreData.remove(data);
    }

    private void padDatasets(DatasetManager datasets) {
        TreeSet<Double> tSet = new TreeSet<Double>();
        for (Dataset dataset : datasets.getDatasetsRaw()) {
            int len = dataset.getIndex();
            double[] xp = dataset.getXPointsRaw();
            int i = 0;
            while (i < len) {
                tSet.add(xp[i]);
                ++i;
            }
        }
        Double[] temp = tSet.toArray(new Double[tSet.size()]);
        double[] array = new double[tSet.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = temp[i];
            ++i;
        }
        for (Dataset dataset : datasets.getDatasetsRaw()) {
            this.padDataset(dataset, array);
        }
    }

    private void findDatasets(ArrayList<Dataset> requestedDatasets, ArrayList<Dataset> datasetsToSearch, DatasetManager manager, boolean isMore) {
        for (Dataset next : requestedDatasets) {
            Dataset ds;
            if (next == null || (ds = Dataset.findDataSet(datasetsToSearch, next)) == null) continue;
            Dataset toSend = this.ids.get(ds.getID());
            if (toSend == null) {
                toSend = DataTool.copyDataset(ds, null, true);
                if (isMore) {
                    toSend.setXYColumnNames(ds.getXColumnName(), next.getYColumnName());
                }
                toSend.setXColumnVisible(toSend.getXColumnName().equals(next.getYColumnName()));
                toSend.setYColumnVisible(toSend.getYColumnName().equals(next.getYColumnName()));
                this.ids.put(ds.getID(), toSend);
            } else {
                if (toSend.getXColumnName().equals(next.getYColumnName())) {
                    toSend.setXColumnVisible(true);
                }
                if (toSend.getYColumnName().equals(next.getYColumnName())) {
                    toSend.setYColumnVisible(true);
                }
            }
            manager.addDataset(toSend);
        }
    }

    private void padDataset(Dataset dataset, double[] newXArray) {
        double[] xA = dataset.getXPointsRaw();
        double[] yA = dataset.getYPointsRaw();
        int len = dataset.getIndex();
        HashMap<Double, Double> valueMap = new HashMap<Double, Double>();
        int k = 0;
        while (k < len) {
            valueMap.put(xA[k], yA[k]);
            ++k;
        }
        double[] newYArray = new double[len];
        int k2 = 0;
        while (k2 < len) {
            double x = newXArray[k2];
            newYArray[k2] = valueMap.keySet().contains(x) ? (Double)valueMap.get(x) : Double.NaN;
            ++k2;
        }
        dataset.clear();
        dataset.append(newXArray, newYArray, len);
    }
}

