/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javajs.async.AsyncDialog;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLTree;
import org.opensourcephysics.controls.XMLTreeChooser;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.tools.DataBuilder;
import org.opensourcephysics.tools.DataColumn;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FitBuilder;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.SnapshotTool;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;
import org.opensourcephysics.tools.ToolsRes;

public class DataTool
extends OSPFrame
implements Tool,
PropertyChangeListener {
    boolean standAlone = false;
    public static boolean loadClass = false;
    protected static Dimension dim = new Dimension(800, 540);
    protected static final int defaultButtonHeight = 28;
    protected static int buttonHeight = 28;
    protected static final String SPACE = " ";
    protected static String[] delimiters = new String[]{"\t", ",", ";", " "};
    protected static TextFrame helpFrame;
    protected static String helpName;
    protected static String helpBase;
    private static ArrayList<Data> processedData;
    protected static boolean loadMultipleTracksInSingleTab;
    protected static boolean askToLoadMultipleTracksInSingleTab;
    protected JTabbedPane tabbedPane;
    protected boolean useChooser = true;
    protected JPanel contentPane = new JPanel(new BorderLayout());
    protected PropertyChangeSupport support;
    protected XMLControlElement control = new XMLControlElement();
    protected Data addableData = null;
    protected boolean controlContainsData;
    protected JMenuBar emptyMenubar;
    protected JMenu emptyFileMenu;
    protected JMenuItem emptyNewTabItem;
    protected JMenuItem emptyOpenItem;
    protected JMenuItem emptyExitItem;
    protected JMenu emptyEditMenu;
    protected JMenuItem emptyPasteMenu;
    protected JMenuItem emptyPasteTabItem;
    protected JMenuBar menubar;
    protected JMenu fileMenu;
    protected JMenuItem newTabItem;
    protected JMenuItem openItem;
    protected JMenuItem importItem;
    protected JMenuItem exportItem;
    protected JMenuItem saveItem;
    protected JMenuItem saveAsItem;
    protected JMenuItem closeItem;
    protected JMenuItem closeAllItem;
    protected JMenuItem printItem;
    protected JMenuItem exitItem;
    protected JMenu editMenu;
    protected JMenuItem undoItem;
    protected JMenuItem redoItem;
    protected JMenu copyMenu;
    protected JMenuItem copyImageItem;
    protected JMenuItem copyTabItem;
    protected JMenu copyDataMenu;
    protected JMenu setDelimiterMenu;
    protected JMenuItem copyDataAsFormattedItem;
    protected JMenuItem copyDataRawItem;
    protected JMenu pasteMenu;
    protected JMenuItem pasteTabItem;
    protected JMenuItem pasteColumnsItem;
    protected JMenu displayMenu;
    protected JMenu languageMenu;
    protected JMenuItem[] languageItems;
    protected JMenu fontSizeMenu;
    protected JMenuItem defaultFontSizeItem;
    protected ButtonGroup fontSizeGroup;
    protected JMenu helpMenu;
    protected JMenuItem helpItem;
    protected JMenuItem logItem;
    protected JMenuItem aboutItem;
    protected DataBuilder dataBuilder;
    protected boolean exitOnClose = false;
    protected boolean saveChangesOnClose = false;
    protected FitBuilder fitBuilder;
    protected boolean isLoading = false;
    protected JButton loadDataFunctionsButton;
    protected JButton saveDataFunctionsButton;
    protected boolean slopeExtended = false;
    protected int myPopupFontLevel;
    protected int myCopyMenuFontLevel;
    private MenuListener editMenuChecker = new MenuListener(){

        @Override
        public void menuSelected(MenuEvent e) {
            DataToolTab tab = DataTool.this.getSelectedTab();
            if (tab != null) {
                DataTool.this.undoItem.setEnabled(tab.undoManager.canUndo());
                DataTool.this.redoItem.setEnabled(tab.undoManager.canRedo());
            }
            boolean enabled = DataTool.this.hasPastableData();
            DataTool.this.emptyPasteMenu.setEnabled(enabled);
            DataTool.this.pasteMenu.setEnabled(enabled);
            DataTool.this.copyMenu.removeAll();
            if (tab != null) {
                boolean isEmpty = tab.dataManager.getDatasetsRaw().isEmpty();
                DataTool.this.copyDataMenu.setEnabled(!isEmpty);
                if (!isEmpty) {
                    boolean emptySelection;
                    DataTool.this.copyTabItem.setText(ToolsRes.getString("DataTool.MenuItem.CopyTab"));
                    DataTool.this.copyMenu.add(DataTool.this.copyTabItem);
                    DataTool.this.copyMenu.addSeparator();
                    String s = ToolsRes.getString("DataTool.MenuItem.CopyData");
                    int[] selectedRows = DataTool.this.getSelectedTab().dataTable.getSelectedRows();
                    int endRow = DataTool.this.getSelectedTab().dataTable.getRowCount() - 1;
                    boolean bl = emptySelection = selectedRows.length == 1 && selectedRows[0] == endRow && DataTool.this.getSelectedTab().dataTable.isEmptyRow(endRow);
                    if (selectedRows.length > 0 && !emptySelection) {
                        s = ToolsRes.getString("DataTool.MenuItem.CopySelectedData");
                    }
                    DataTool.this.copyDataMenu.setText(s);
                    DataTool.this.copyDataMenu.removeAll();
                    DataTool.this.copyDataRawItem.setText(ToolsRes.getString("DataTool.MenuItem.Unformatted"));
                    DataTool.this.copyDataAsFormattedItem.setText(ToolsRes.getString("DataTool.MenuItem.Formatted"));
                    DataTool.this.setDelimiterMenu.setText(ToolsRes.getString("DataTool.Menu.SetDelimiter"));
                    DataTool.this.copyDataMenu.add(DataTool.this.copyDataAsFormattedItem);
                    DataTool.this.copyDataMenu.add(DataTool.this.copyDataRawItem);
                    DataTool.this.copyDataMenu.addSeparator();
                    DataTool.this.copyDataMenu.add(DataTool.this.setDelimiterMenu);
                    DataTool.this.copyMenu.add(DataTool.this.copyDataMenu);
                    DataTool.this.copyMenu.addSeparator();
                }
            }
            DataTool.this.copyMenu.add(DataTool.this.copyImageItem);
            FontSizer.setFonts(DataTool.this.copyMenu);
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    };
    private JMenuItem editDataItem;
    private static DataTool tool;
    public static String NEW_LINE;

    static {
        helpName = "datatool/datatool_help.html";
        helpBase = "https://www.compadre.org/osp/online_help/tools/";
        processedData = new ArrayList();
        loadMultipleTracksInSingleTab = false;
        askToLoadMultipleTracksInSingleTab = true;
        NEW_LINE = System.getProperty("line.separator", "\n");
    }

    public static DataTool getTool() {
        return DataTool.getTool(true);
    }

    public static DataTool getTool(boolean forceNew) {
        return tool == null && forceNew ? (tool = new DataTool()) : tool;
    }

    public static void main(String[] args) {
        DataTool.getTool(true);
        if (OSPRuntime.isJS) {
            DataTool.tool.standAlone = true;
        }
        if (DataTool.tool.standAlone) {
            tool.setLocation(0, 0);
        }
        OSPRuntime.setAppClass(tool);
        DataTool.tool.exitOnClose = true;
        DataTool.tool.saveChangesOnClose = true;
        if (args != null && args.length > 0 && args[0] != null) {
            tool.setVisible(true);
            tool.open(new File(args[0]));
        } else {
            tool.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    if (tool.getTabCount() == 0) {
                        DataToolTab tab = tool.createTab(null);
                        tab.setUserEditable(true);
                        tool.addTab(tab);
                    }
                }
            });
            tool.setVisible(true);
        }
    }

    public DataTool() {
        this(ToolsRes.getString("DataTool.Frame.Title"), "DataTool");
    }

    public DataTool(String fileName) {
        this();
        this.open(new File(fileName));
    }

    public DataTool(XMLControl control) {
        this();
        this.addTabs(control, null);
    }

    public DataTool(Data data) {
        this();
        ArrayList<DataToolTab> tabs = this.createTabs(data);
        for (DataToolTab tab : tabs) {
            this.addTab(tab);
        }
    }

    public void loadDatasetURL(String path) {
        if (this.getTabCount() > 0) {
            this.removeAllTabs();
        }
        File f = new File(path);
        this.open(f);
    }

    public void loadDatasetURI(String relpath) {
        String baseURI;
        if (this.getTabCount() > 0) {
            this.removeAllTabs();
        }
        String rootpath = (baseURI = null) == null ? "" : baseURI.substring(0, baseURI.lastIndexOf(47) + 1);
        String path = String.valueOf(rootpath) + relpath;
        try {
            System.err.println("Debugging: reading path=" + path);
            URL url = new URL(path);
            Object content = url.getContent();
            if (content instanceof InputStream) {
                String line;
                InputStream is = (InputStream)content;
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)content));
                StringBuffer buffer = new StringBuffer(0);
                while ((line = reader.readLine()) != null) {
                    buffer.append(String.valueOf(line) + NEW_LINE);
                }
                String dataset = buffer.toString();
                System.out.print(dataset);
                System.err.println("Debugging: Close stream \n");
                this.loadDataset(dataset, path);
                is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public OSPFrame getMainFrame() {
        return this;
    }

    public int[] getMainFrameSize() {
        Dimension d = this.getSize();
        return new int[]{d.width, d.height};
    }

    public void setSaveChangesOnClose(boolean save) {
        this.saveChangesOnClose = save && !OSPRuntime.appletMode;
    }

    public void addTabs(XMLControl control, final Consumer<ArrayList<DataToolTab>> whenDone) {
        if (DataToolTab.class == control.getObjectClass()) {
            control.setValue("datatool", this);
            this.isLoading = true;
            DataToolTab tab = (DataToolTab)control.loadObject(null);
            this.addTab(tab);
            tab.refreshGUI();
            this.isLoading = false;
            ArrayList<DataToolTab> tabs = new ArrayList<DataToolTab>();
            tabs.add(tab);
            if (whenDone != null) {
                whenDone.accept(tabs);
            }
            return;
        }
        if (control.getObjectClassName().endsWith("FourierToolTab")) {
            XMLControl child = control.getChildControl("source_data");
            Data source = (Data)child.loadObject(null);
            DataToolTab tab = this.createTab(source);
            this.addTab(tab);
            tab.refreshGUI();
            ArrayList<DataToolTab> tabs = new ArrayList<DataToolTab>();
            tabs.add(tab);
            if (whenDone != null) {
                whenDone.accept(tabs);
            }
            return;
        }
        this.loadTabsFromXMLAsync(control, new Consumer<ArrayList<DataToolTab>>(){

            @Override
            public void accept(ArrayList<DataToolTab> tabs) {
                for (DataToolTab tab : tabs) {
                    DataTool.this.addTab(tab);
                    tab.refreshGUI();
                }
                if (whenDone != null) {
                    whenDone.accept(tabs);
                }
            }
        });
    }

    public ArrayList<DataToolTab> createTabs(Data source) {
        ArrayList<Data> dataList = DataTool.getSelfContainedData(source);
        ArrayList<DataToolTab> tabList = new ArrayList<DataToolTab>();
        for (Data next : dataList) {
            DataToolTab tab = this.createTab(next);
            if (tab == null) continue;
            tabList.add(tab);
        }
        return tabList;
    }

    protected DataToolTab createTab(Data data) {
        String name;
        this.fitBuilder = this.getFitBuilder();
        DataToolTab tab = new DataToolTab(data, this);
        if (data != null && (name = data.getName()) != null && !name.equals("")) {
            tab.setName(name);
        }
        return tab;
    }

    public DataToolTab removeTab(int index, boolean saveChanges) {
        if (index >= 0 && index < this.tabbedPane.getTabCount()) {
            if (saveChanges && !this.saveChangesAt(index)) {
                return null;
            }
            DataToolTab tab = this.getTab(index);
            this.getFitBuilder().curveFitters.remove(tab.getCurveFitter());
            tab.getCurveFitter().notifyTabRemoved();
            this.tabbedPane.removeTabAt(index);
            this.refreshTabTitles();
            this.refreshMenubar();
            this.refreshDataBuilder();
            return tab;
        }
        return null;
    }

    public DataToolTab removeTab(DataToolTab tab) {
        return this.removeTab(this.getTabIndex(tab), true);
    }

    public ArrayList<DataToolTab> loadData(Data data) {
        DataToolTab tab = null;
        ArrayList<DataToolTab> loadedTabs = new ArrayList<DataToolTab>();
        for (Data next : DataTool.getSelfContainedData(data)) {
            tab = this.getTab(next);
            if (tab != null) {
                tab.loadData(next, tab.replaceColumnsWithMatchingNames);
            } else {
                tab = this.createTab(next);
                this.addTab(tab);
            }
            loadedTabs.add(tab);
        }
        if (tab != null) {
            this.setSelectedTab(tab);
        }
        return loadedTabs;
    }

    public DataToolTab loadData(Data ... data) {
        if (data == null) {
            return null;
        }
        ArrayList<Data> selfContained = new ArrayList<Data>();
        Data[] dataArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Data next = dataArray[n2];
            selfContained.addAll(DataTool.getSelfContainedData(next));
            ++n2;
        }
        DataToolTab tab = null;
        for (Data next : selfContained) {
            if (tab == null) {
                tab = this.getTab(next);
                if (tab != null) {
                    tab.loadData(next, tab.replaceColumnsWithMatchingNames);
                    continue;
                }
                tab = this.createTab(next);
                this.addTab(tab);
                continue;
            }
            ArrayList<DataColumn> columns = DataTool.getDataColumns(next);
            columns.remove(0);
            tab.addColumns(columns, false, false, false);
        }
        if (tab != null) {
            this.setSelectedTab(tab);
        }
        return tab;
    }

    public DataToolTab getTab(Data data) {
        int i = this.getTabIndex(data);
        return i > -1 ? this.getTab(i) : null;
    }

    public DataToolTab getTab(int index) {
        return index > -1 && index < this.tabbedPane.getTabCount() ? (DataToolTab)this.tabbedPane.getComponentAt(index) : null;
    }

    public int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public List<DataToolTab> getTabs() {
        ArrayList<DataToolTab> tabs = new ArrayList<DataToolTab>();
        int i = 0;
        while (i < this.getTabCount()) {
            tabs.add(this.getTab(i));
            ++i;
        }
        return tabs;
    }

    public void open(final File file) {
        OSPLog.fine("opening " + file);
        Resource res = new Resource(file);
        final BufferedReader in = res.openReader();
        String firstLine = this.readFirstLine(in);
        if (firstLine.startsWith("<?xml")) {
            XMLControlElement control = new XMLControlElement(file);
            this.addTabs(control, new Consumer<ArrayList<DataToolTab>>(){

                @Override
                public void accept(ArrayList<DataToolTab> tabs) {
                    if (tabs.isEmpty()) {
                        OSPLog.finest("no data found");
                    } else {
                        for (DataToolTab tab : tabs) {
                            DataTool.this.refreshDataBuilder();
                            if (tabs.size() == 1) {
                                tab.fileName = file.toString();
                            }
                            tab.tabChanged(false);
                        }
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
            return;
        }
        if (res.getString() != null) {
            this.setMultipleTabPolicy(res.getString());
            DatasetManager[] data = DataTool.parseData(res.getString(), file.toString());
            if (data != null) {
                DataToolTab first = null;
                int i = 0;
                while (i < data.length) {
                    DataToolTab tab = this.createTab(data[i]);
                    first = first == null ? tab : first;
                    this.addTab(tab);
                    if (data.length == 1) {
                        tab.fileName = file.getAbsolutePath();
                    }
                    tab.tabChanged(false);
                    ++i;
                }
                this.setSelectedTab(first);
                this.refreshDataBuilder();
                return;
            }
        }
        OSPLog.finest("no data found");
    }

    public void loadDataset(String content, final String title) {
        if (content.startsWith("<?xml")) {
            XMLControlElement control = new XMLControlElement(content);
            this.addTabs(control, new Consumer<ArrayList<DataToolTab>>(){

                @Override
                public void accept(ArrayList<DataToolTab> tabs) {
                    if (tabs.isEmpty()) {
                        OSPLog.finest("no data found");
                    } else {
                        for (DataToolTab tab : tabs) {
                            DataTool.this.refreshDataBuilder();
                            if (tabs.size() == 1) {
                                tab.fileName = title;
                            }
                            tab.tabChanged(false);
                        }
                    }
                }
            });
            return;
        }
        this.setMultipleTabPolicy(content);
        DatasetManager[] data = DataTool.parseData(content, title);
        if (data != null) {
            DataToolTab first = null;
            int i = 0;
            while (i < data.length) {
                DataToolTab tab = this.createTab(data[i]);
                first = first == null ? tab : first;
                this.addTab(tab);
                if (data.length == 1) {
                    tab.fileName = title;
                }
                tab.tabChanged(false);
                ++i;
            }
            this.setSelectedTab(first);
            return;
        }
        OSPLog.finest("no data found");
    }

    void importFileIntoTab(final DataToolTab tab, File file) {
        DatasetManager[] data;
        OSPLog.fine("importing " + file);
        Resource res = new Resource(file);
        BufferedReader in = res.openReader();
        String firstLine = this.readFirstLine(in);
        if (firstLine.startsWith("<?xml")) {
            XMLControlElement control = new XMLControlElement(file);
            this.getSelfContainedDataAsync(control, false, new Consumer<ArrayList<Data>>(){

                @Override
                public void accept(ArrayList<Data> dataList) {
                    if (dataList.isEmpty()) {
                        OSPLog.finest("no data found");
                    } else {
                        DatasetManager manager = new DatasetManager();
                        for (Data next : dataList) {
                            for (DataColumn column : DataTool.getDataColumns(next)) {
                                manager.addDataset(column);
                            }
                        }
                        tab.addColumns(manager, true, true, true);
                    }
                }
            });
            return;
        }
        if (res.getString() != null && (data = DataTool.parseData(res.getString(), file.toString())) != null) {
            tab.addColumns(data[0], true, true, true);
            return;
        }
        OSPLog.finest("no data found");
    }

    @Override
    public void send(Job job, Tool replyTo) {
        XMLControlElement control = new XMLControlElement(job.getXML());
        if (control.failedToRead() || control.getObjectClass() == Object.class) {
            return;
        }
        if (Data.class.isAssignableFrom(control.getObjectClass())) {
            Data data = (Data)control.loadObject(null, true, true);
            if (DataTool.isSelfContained(data)) {
                DataToolTab tab = this.getTab(data);
                if (tab == null) {
                    tab = this.createTab(null);
                    String name = data.getName();
                    if (name != null && !name.equals("")) {
                        tab.setName(name);
                    }
                    this.addTab(tab);
                } else {
                    this.setSelectedTab(tab);
                }
                tab.receiveJobControl(job, replyTo, control);
            } else {
                for (Data next : DataTool.getSelfContainedData(data)) {
                    DataToolTab tab = this.getTab(next);
                    if (tab == null) {
                        tab = this.createTab(null);
                        String name = next.getName();
                        if (name != null && !name.equals("")) {
                            tab.setName(name);
                        }
                        this.addTab(tab);
                    }
                    tab.send(new LocalJob(next), replyTo);
                }
            }
        } else {
            this.addTabs(control, null);
        }
        this.toFront();
    }

    public void setUseChooser(boolean useChooser) {
        this.useChooser = useChooser;
    }

    public boolean isUseChooser() {
        return this.useChooser;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "function": {
                String funcName;
                DataToolTab tab = this.getSelectedTab();
                if (tab == null) {
                    return;
                }
                tab.tabChanged(true);
                tab.dataTable.refreshTable(0x820000);
                tab.statsTable.refreshStatistics();
                if (e.getNewValue() instanceof DataFunction) {
                    funcName = e.getNewValue().toString();
                    tab.dataTable.getWorkingData(funcName);
                }
                if (e.getOldValue() instanceof DataFunction) {
                    funcName = e.getOldValue().toString();
                    tab.dataTable.removeWorkingData(funcName);
                }
                if (e.getNewValue() instanceof String) {
                    funcName = e.getNewValue().toString();
                    if (e.getOldValue() instanceof String) {
                        String prevName = e.getOldValue().toString();
                        tab.columnNameChanged(prevName, funcName);
                    } else {
                        tab.dataTable.getWorkingData(funcName);
                    }
                }
                tab.refreshPlot();
                tab.varPopup = null;
            }
        }
    }

    protected static boolean containsDuplicateValues(double[] values) {
        int i = 0;
        while (i < values.length) {
            if (Double.isNaN(values[i])) {
                return true;
            }
            int n = DataTool.getIndex(values[i], values, i);
            if (n > -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static int getIndex(double value, double[] array, int ignoreIndex) {
        int i = 0;
        while (i < array.length) {
            if (i != ignoreIndex && array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected static double[] getRowArray(int rowCount) {
        double[] rows = new double[rowCount];
        int i = 0;
        while (i < rowCount) {
            rows[i] = i;
            ++i;
        }
        return rows;
    }

    protected static String[] parseStrings(String text, String delimiter) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (text != null) {
            String next = text;
            int i = text.indexOf(delimiter);
            if (i == -1) {
                tokens.add(DataTool.stripQuotes(next));
                text = null;
            } else {
                next = text.substring(0, i);
                text = text.substring(i + 1);
                while (SPACE.equals(delimiter) && (text.startsWith(SPACE) || text.startsWith("\t"))) {
                    text = text.substring(1);
                }
            }
            while (text != null) {
                tokens.add(DataTool.stripQuotes(next));
                i = text.indexOf(delimiter);
                if (i == -1) {
                    next = text;
                    tokens.add(DataTool.stripQuotes(next));
                    text = null;
                    continue;
                }
                next = text.substring(0, i).trim();
                text = text.substring(i + 1);
                while (SPACE.equals(delimiter) && (text.startsWith(SPACE) || text.startsWith("\t"))) {
                    text = text.substring(1);
                }
            }
        }
        return tokens.toArray(new String[0]);
    }

    private static String stripQuotes(String text) {
        String stripped;
        int n;
        if (text.startsWith("\"") && (n = (stripped = text.substring(1)).indexOf("\"")) > -1 && n == stripped.length() - 1) {
            return stripped.substring(0, n);
        }
        return text;
    }

    protected static double[] parseDoubles(String text, String delimiter) {
        return DataTool.parseDoubles(DataTool.parseStrings(text, delimiter), delimiter);
    }

    protected static double[] parseDoubles(String[] strings, String delimiter) {
        double[] doubles = new double[strings.length];
        boolean checkComma = delimiter != null && !delimiter.equals(",");
        int i = 0;
        while (i < strings.length) {
            block6: {
                String s = strings[i];
                doubles[i] = Double.NaN;
                if (s != "" && s.indexOf("\t") < 0) {
                    try {
                        doubles[i] = Double.parseDouble(s);
                    }
                    catch (NumberFormatException e) {
                        if (!checkComma || s.indexOf(",") < 0) break block6;
                        try {
                            doubles[i] = Double.parseDouble(s.replace(",", "."));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            ++i;
        }
        return doubles;
    }

    protected static String[][] parseStrings(String text, String rowDelimiter, String colDelimiter) {
        String[] rows = DataTool.parseStrings(text, rowDelimiter);
        String[][] tokens = new String[rows.length][0];
        int i = 0;
        while (i < rows.length) {
            tokens[i] = DataTool.parseStrings(rows[i], colDelimiter);
            ++i;
        }
        return tokens;
    }

    protected static double[][] parseDoubles(String text, String rowDelimiter, String colDelimiter) {
        String[][] strings = DataTool.parseStrings(text, rowDelimiter, colDelimiter);
        double[][] doubles = new double[strings.length][0];
        int i = 0;
        while (i < strings.length) {
            doubles[i] = DataTool.parseDoubles(strings[i], null);
            ++i;
        }
        return doubles;
    }

    private static boolean containsDelimeter(String s) {
        int i = 0;
        while (i < delimiters.length) {
            if (delimiters[i] != SPACE && s.contains(delimiters[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static DatasetManager[] parseData(String dataString, String fileName) {
        gnuPlotComment = "#";
        input = null;
        if (new File(dataString).exists()) {
            return null;
        }
        if (dataString.trim().startsWith("<?xml")) {
            return null;
        }
        if (dataString.trim().startsWith("<object class=")) {
            return null;
        }
        try {
            i = 0;
            while (i < DataTool.delimiters.length) {
                block51: {
                    block53: {
                        block52: {
                            input = new BufferedReader(new StringReader(dataString));
                            textLine = input.readLine();
                            rows = new ArrayList<double[]>();
                            columns = 0x7FFFFFFF;
                            columnNames = null;
                            title = null;
                            titles = new ArrayList<String>();
                            isMulti = false;
                            lineCount = 0;
                            columnStride = -1;
                            while (textLine != null) {
                                if (textLine.startsWith("//")) {
                                    textLine = input.readLine();
                                    continue;
                                }
                                if (textLine.contains("#")) {
                                    textLine = textLine.trim();
                                }
                                if (textLine.startsWith("#")) {
                                    k = textLine.indexOf("name:");
                                    if (k > -1) {
                                        title = textLine.substring(k + 5).trim();
                                    }
                                    if ((k = textLine.indexOf("columnNames:")) > -1) {
                                        textLine = textLine.substring(k + 12).trim();
                                    }
                                    if ((k = textLine.indexOf("multi:")) > -1) {
                                        textLine = textLine.substring(k + 6).trim();
                                        isMulti = true;
                                        if (textLine.length() == 0) {
                                            textLine = input.readLine();
                                            continue;
                                        }
                                    } else {
                                        textLine = input.readLine();
                                        continue;
                                    }
                                }
                                if (textLine.indexOf("Vernier Format") > -1 || textLine.indexOf(".cmbl") > -1) {
                                    textLine = input.readLine();
                                    continue;
                                }
                                strings = DataTool.parseStrings(textLine, DataTool.delimiters[i]);
                                rowData = DataTool.parseDoubles(strings, DataTool.delimiters[i]);
                                if (rows.isEmpty() && strings.length > 0 && title == null) {
                                    k = 0;
                                    while (k < strings.length) {
                                        if (Double.isNaN(rowData[k]) && !strings[k].equals("")) {
                                            titles.add(strings[k]);
                                            columnStride = columnStride == -1 ? k : k - columnStride;
                                        }
                                        ++k;
                                    }
                                    s = "";
                                    switch (titles.size()) {
                                        case 0: {
                                            break;
                                        }
                                        case 1: {
                                            s = (String)titles.get(0);
                                            break;
                                        }
                                        default: {
                                            if (!isMulti) break;
                                            s = String.valueOf((String)titles.get(0)) + "+" + (titles.size() - 1);
                                        }
                                    }
                                    if (!s.equals("") && !DataTool.containsDelimeter(s)) {
                                        title = s;
                                        textLine = input.readLine();
                                        continue;
                                    }
                                }
                                if (columnNames == null && rows.isEmpty() && strings.length > 0) {
                                    valid = true;
                                    k = 0;
                                    while (k < strings.length) {
                                        if (DataTool.containsDelimeter(strings[k]) || !Double.isNaN(rowData[k])) {
                                            valid = false;
                                            break;
                                        }
                                        ++k;
                                    }
                                    if (valid) {
                                        k = 0;
                                        while (k < strings.length) {
                                            if ("".equals(strings[k])) {
                                                strings[k] = "?";
                                            }
                                            ++k;
                                        }
                                        columnNames = strings;
                                        columns = strings.length;
                                        textLine = input.readLine();
                                        continue;
                                    }
                                }
                                v0 = singleColumn = columnNames != null && columnNames.length == 1;
                                if (strings.length > 0) {
                                    ++lineCount;
                                    validData = true;
                                    emptyData = true;
                                    k = 0;
                                    while (k < strings.length) {
                                        if (Double.isNaN(rowData[k]) && !strings[k].equals("")) {
                                            validData = false;
                                        }
                                        if (!strings[k].equals("")) {
                                            emptyData = false;
                                        }
                                        ++k;
                                    }
                                    if (!singleColumn && emptyData && title == null && rows.isEmpty()) {
                                        validData = false;
                                    }
                                    if (rowData.length == 1 && strings[0].contains(",") && !singleColumn) {
                                        validData = false;
                                    }
                                    if (validData) {
                                        rows.add(rowData);
                                        columns = columns == 0x7FFFFFFF ? rowData.length : Math.max(rowData.length, columns);
                                    }
                                }
                                if (rows.isEmpty() && lineCount > 10) break;
                                textLine = input.readLine();
                            }
                            if (columns <= 0 || columns >= 0x7FFFFFFF) break block51;
                            input.close();
                            dataArray = new double[columns][rows.size()];
                            row = 0;
                            while (row < rows.size()) {
                                rowData = (double[])rows.get(row);
                                j = 0;
                                while (j < columns) {
                                    dataArray[j][row] = rowData.length > j ? rowData[j] : NaN;
                                    ++j;
                                }
                                ++row;
                            }
                            data = null;
                            rowColumn = DataTool.getRowArray(rows.size());
                            if (isMulti && !DataTool.loadMultipleTracksInSingleTab) break block52;
                            data = new DatasetManager[]{new DatasetManager()};
                            data[0].setName(title == null ? XML.getName(fileName) : title);
                            droppedCols = 0;
                            j = 0;
                            while (j < columns) {
                                dataset = data[0].getDataset(j - droppedCols);
                                yColName = columnNames != null && columnNames.length > j ? columnNames[j] : (columns == 1 && title != null ? title : "?");
                                dataset.setXYColumnNames("row", yColName);
                                dataset.setXColumnVisible(false);
                                if (!yColName.equals("?")) ** GOTO lbl-1000
                                allNaN = true;
                                k = 0;
                                while (k < dataArray[j].length) {
                                    v1 = allNaN = allNaN != false && Double.isNaN(dataArray[j][k]) != false;
                                    if (!allNaN) break;
                                    ++k;
                                }
                                if (allNaN) {
                                    data[0].removeDataset(j - droppedCols);
                                    ++droppedCols;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    dataset.append(rowColumn, dataArray[j]);
                                }
                                ++j;
                            }
                            break block53;
                        }
                        data = new DatasetManager[titles.size()];
                        tab = 0;
                        while (tab < titles.size()) {
                            data[tab] = new DatasetManager();
                            data[tab].setName((String)titles.get(tab));
                            dataset = data[tab].getDataset(0);
                            yColName = columnNames != null && columnNames.length > 0 ? columnNames[0] : "?";
                            dataset.setXYColumnNames("row", yColName);
                            dataset.setXColumnVisible(false);
                            values = dataArray[1 + tab * columnStride];
                            rowNums = rowColumn;
                            startIndex = 0;
                            endIndex = values.length - 1;
                            k = 0;
                            while (k < values.length) {
                                if (!Double.isNaN(values[k])) break;
                                ++startIndex;
                                ++k;
                            }
                            k = values.length - 1;
                            while (k >= 0) {
                                if (!Double.isNaN(values[k])) break;
                                --endIndex;
                                --k;
                            }
                            if (startIndex > 0 || endIndex < values.length - 1) {
                                values = Arrays.copyOfRange(dataArray[0], startIndex, endIndex + 1);
                                rowNums = DataTool.getRowArray(endIndex - startIndex + 1);
                            }
                            dataset.append(rowNums, values);
                            j = 0;
                            while (j < columnStride) {
                                index = 1 + tab * columnStride + j;
                                dataset = data[tab].getDataset(1 + j);
                                yColName = columnNames != null && columnNames.length > index ? columnNames[index] : "?";
                                dataset.setXYColumnNames("row", yColName);
                                dataset.setXColumnVisible(false);
                                values = Arrays.copyOfRange(dataArray[index], startIndex, endIndex + 1);
                                dataset.append(rowNums, values);
                                ++j;
                            }
                            ++tab;
                        }
                    }
                    OSPLog.finest("data found using delimiter \"" + DataTool.delimiters[i] + "\"");
                    return data;
                }
                input.close();
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    protected String readFirstLine(Reader in) {
        String openingLine;
        BufferedReader input = null;
        input = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        try {
            openingLine = input.readLine();
            while (openingLine == null || openingLine.equals("")) {
                openingLine = input.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        try {
            input.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return openingLine;
    }

    protected void setupDelimiterMenu(JMenu menu) {
        AbstractAction setDelimiterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoIO.setDelimiter(e.getActionCommand());
                DataTool.this.refreshGUI();
            }
        };
        ButtonGroup delimiterButtonGroup = new ButtonGroup();
        menu.removeAll();
        String delimiter = VideoIO.getDelimiter();
        for (String key : VideoIO.getDelimiters().keySet()) {
            String nextDelimiter = VideoIO.getDelimiters().get(key);
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(key);
            item.setActionCommand(nextDelimiter);
            item.addActionListener(setDelimiterAction);
            delimiterButtonGroup.add(item);
            menu.add(item);
            if (!delimiter.equals(nextDelimiter)) continue;
            item.setSelected(true);
        }
    }

    protected String getUniqueTabName(String proposed) {
        if (proposed == null || proposed.equals("")) {
            proposed = ToolsRes.getString("DataToolTab.DefaultName");
        }
        ArrayList<String> taken = new ArrayList<String>();
        int i = 0;
        while (i < this.getTabCount()) {
            DataToolTab tab = this.getTab(i);
            taken.add(tab.getName());
            ++i;
        }
        if (!taken.contains(proposed)) {
            return proposed;
        }
        String subscript = TeXParser.getSubscript(proposed);
        try {
            Integer.parseInt(subscript);
            proposed = TeXParser.removeSubscript(proposed);
        }
        catch (Exception tab) {
            // empty catch block
        }
        proposed = String.valueOf(proposed) + "_";
        int i2 = 1;
        String name = String.valueOf(proposed) + i2;
        while (taken.contains(name)) {
            name = String.valueOf(proposed) + ++i2;
        }
        return name;
    }

    private void getSelfContainedDataAsync(XMLControl control, boolean useChooser, final Consumer<ArrayList<Data>> whenDone) {
        final HashSet IDs = new HashSet();
        final ArrayList dataList = new ArrayList();
        final Consumer<List<XMLProperty>> whenChosen = new Consumer<List<XMLProperty>>(){

            @Override
            public void accept(List<XMLProperty> xmlControls) {
                for (XMLProperty prop : xmlControls) {
                    XMLControl next = (XMLControl)prop;
                    Data data = null;
                    if (next instanceof XMLControlElement) {
                        XMLControlElement element = (XMLControlElement)next;
                        data = (Data)element.loadObject(null, true, true);
                    } else {
                        data = (Data)next.loadObject(null);
                    }
                    if (data == null) continue;
                    for (Data nextData : DataTool.getSelfContainedData(data)) {
                        Integer id = nextData.getID();
                        if (IDs.contains(id)) continue;
                        IDs.add(id);
                        dataList.add(nextData);
                        if (!(nextData instanceof DatasetManager)) continue;
                        for (Dataset dataset : ((DatasetManager)nextData).getDatasetsRaw()) {
                            dataList.remove(dataset);
                            id = dataset.getID();
                            IDs.add(id);
                        }
                    }
                }
                if (whenDone != null) {
                    whenDone.accept(dataList);
                }
            }
        };
        if (useChooser) {
            final XMLTreeChooser chooser = new XMLTreeChooser(ToolsRes.getString("Chooser.Title"), ToolsRes.getString("Chooser.Label"), null);
            chooser.chooseAsync(control, Data.class, new Runnable(){

                @Override
                public void run() {
                    whenChosen.accept(chooser.getList());
                }
            });
        } else {
            XMLTree tree = new XMLTree(control);
            tree.setHighlightedClass(Data.class);
            tree.selectHighlightedProperties();
            List<XMLProperty> xmlControls = tree.getSelectedProperties();
            if (xmlControls.isEmpty()) {
                JOptionPane.showMessageDialog(null, ToolsRes.getString("Dialog.NoDatasets.Message"));
            }
            whenChosen.accept(xmlControls);
        }
    }

    private void loadTabsFromXMLAsync(XMLControl control, final Consumer<ArrayList<DataToolTab>> whenLoaded) {
        this.getSelfContainedDataAsync(control, this.useChooser, new Consumer<ArrayList<Data>>(){

            @Override
            public void accept(ArrayList<Data> dataList) {
                ArrayList<DataToolTab> loadedTabs = new ArrayList<DataToolTab>();
                for (Data next : dataList) {
                    loadedTabs.add(DataTool.this.createTab(next));
                }
                whenLoaded.accept(loadedTabs);
            }
        });
    }

    public static Dataset createDatasetFromYPoints(Dataset xColumn, Dataset yColumn) {
        Dataset dataset = new Dataset();
        dataset.setXYColumnNames(xColumn.getYColumnName(), yColumn.getYColumnName());
        dataset.setLineColor(yColumn.getLineColor());
        dataset.setMarkerShape(yColumn.getMarkerShape());
        dataset.setMarkerColor(yColumn.getFillColor(), yColumn.getEdgeColor());
        double[] xPoints = xColumn.getYPoints();
        double[] yPoints = yColumn.getYPoints();
        if (xPoints.length != yPoints.length) {
            int len = Math.min(xPoints.length, yPoints.length);
            double[] newPoints = new double[len];
            int i = 0;
            while (i < len) {
                newPoints[i] = len < xPoints.length ? xPoints[i] : yPoints[i];
                ++i;
            }
            if (len < xPoints.length) {
                xPoints = newPoints;
            } else {
                yPoints = newPoints;
            }
        }
        dataset.append(xPoints, yPoints);
        return dataset;
    }

    public static ArrayList<Dataset> getDatasets(Data source) {
        int n;
        ArrayList<Dataset> datasets;
        ArrayList<Dataset> arrayList = datasets = source instanceof DatasetManager ? ((DatasetManager)source).getDatasetsRaw() : source.getDatasets();
        if (datasets != null) {
            return datasets;
        }
        datasets = new ArrayList();
        double[][] data2D = source.getData2D();
        if (data2D == null || data2D.length == 0 || data2D[0] == null) {
            return datasets;
        }
        String[] colNames = source.getColumnNames();
        if (colNames == null) {
            colNames = new String[2];
            if (data2D.length == 1) {
                colNames[0] = "n";
            }
        }
        if (colNames.length > (n = Math.max(2, data2D.length))) {
            ++n;
        }
        boolean xPointsAreRowNumbers = (colNames = DataTool.getColumnNames(colNames, n)).length > data2D.length;
        double[] xPoints = xPointsAreRowNumbers ? DataTool.getRowArray(data2D[0].length) : data2D[0];
        int i = 1;
        while (i < colNames.length) {
            double[] yPoints = xPointsAreRowNumbers ? data2D[i - 1] : data2D[i];
            Dataset dataset = DataTool.createDataset(xPoints, yPoints, colNames[0], colNames[i], i, source);
            if (dataset != null) {
                datasets.add(dataset);
            }
            ++i;
        }
        return datasets;
    }

    public static ArrayList<Dataset> getAllDatasets(Data source) {
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        for (Data next : DataTool.getSelfContainedData(source)) {
            datasets.addAll(DataTool.getDatasets(next));
        }
        return datasets;
    }

    protected static ArrayList<Data> getSelfContainedData(Data container) {
        processedData.clear();
        ArrayList<Data> list = DataTool.getSelfContainedDataWithTrap(container);
        return list;
    }

    protected static ArrayList<DataColumn> getDataColumns(Data source) {
        ArrayList<Dataset> datasetList;
        if (!DataTool.isSelfContained(source)) {
            return null;
        }
        ArrayList<DataColumn> columns = new ArrayList<DataColumn>();
        ArrayList<Dataset> arrayList = datasetList = source instanceof DatasetManager ? ((DatasetManager)source).getDatasetsRaw() : source.getDatasets();
        if (datasetList != null) {
            for (Dataset next : datasetList) {
                ArrayList<DataColumn> newColumns = DataTool.createDataColumns(next);
                for (DataColumn newCol : newColumns) {
                    boolean isDup = false;
                    for (DataColumn existing : columns) {
                        double[] nextPts;
                        double[] exPts;
                        if (!existing.getYColumnName().equals(newCol.getYColumnName()) || (exPts = existing.getYPoints()).length != (nextPts = newCol.getYPoints()).length) continue;
                        isDup = true;
                        int i = 0;
                        while (i < exPts.length) {
                            isDup = exPts[i] == nextPts[i] && isDup;
                            ++i;
                        }
                    }
                    if (isDup) continue;
                    columns.add(newCol);
                }
            }
        } else {
            int n;
            double[][] data2D = source.getData2D();
            if (data2D == null || data2D.length == 0 || data2D[0] == null) {
                return null;
            }
            String[] colNames = source.getColumnNames();
            if (colNames == null) {
                colNames = new String[2];
                if (data2D.length == 1) {
                    colNames[0] = "n";
                }
            }
            if (colNames.length > (n = Math.max(2, data2D.length))) {
                ++n;
            }
            boolean includeRows = (colNames = DataTool.getColumnNames(colNames, n)).length > data2D.length;
            int index = data2D[0].length;
            int i = 0;
            while (i < data2D.length) {
                if (data2D[i] != null) {
                    index = Math.max(index, data2D[i].length);
                }
                ++i;
            }
            i = 0;
            while (i < colNames.length) {
                double[] colData = includeRows ? (i == 0 ? DataTool.getRowArray(index) : data2D[i - 1]) : data2D[i];
                DataColumn dataset = DataTool.createDataColumn(colData, colNames[i], i, source);
                if (dataset != null) {
                    columns.add(dataset);
                }
                ++i;
            }
        }
        return columns;
    }

    protected static ArrayList<DataColumn> getAllDataColumns(Data source) {
        ArrayList<DataColumn> columns = new ArrayList<DataColumn>();
        for (Data next : DataTool.getSelfContainedData(source)) {
            columns.addAll(DataTool.getDataColumns(next));
        }
        return columns;
    }

    private static String[] getColumnNames(String[] proposed, int nameCount) {
        String[] colNames = proposed;
        if (colNames.length != nameCount) {
            colNames = new String[nameCount];
            int len = Math.min(proposed.length, colNames.length);
            System.arraycopy(proposed, 0, colNames, 0, len);
        }
        ArrayList<String> taken = new ArrayList<String>();
        char c = 'A';
        int i = 0;
        while (i < nameCount) {
            String next = colNames[i];
            if (next != null && !taken.contains(next)) {
                taken.add(next);
            } else if (next == null) {
                char c2 = c;
                c = (char)(c2 + 1);
                next = String.valueOf(c2);
                while (taken.contains(next)) {
                    char c3 = c;
                    c = (char)(c3 + '\u0001');
                    next = String.valueOf(c3);
                }
                colNames[i] = next;
                taken.add(next);
            }
            ++i;
        }
        return colNames;
    }

    private static ArrayList<Data> getSelfContainedDataWithTrap(Data source) {
        ArrayList<Data> list = new ArrayList<Data>();
        if (source == null || processedData.contains(source)) {
            return list;
        }
        processedData.add(source);
        if (DataTool.isSelfContained(source)) {
            list.add(source);
        } else {
            for (Data next : source.getDataList()) {
                ArrayList<Data> subList = DataTool.getSelfContainedDataWithTrap(next);
                list.addAll(subList);
            }
        }
        return list;
    }

    private static boolean isSelfContained(Data data) {
        return data.getDataList() == null;
    }

    private static ArrayList<DataColumn> createDataColumns(Dataset source) {
        ArrayList<DataColumn> columns = new ArrayList<DataColumn>();
        if (source instanceof DataColumn) {
            columns.add((DataColumn)source);
            return columns;
        }
        String[] colNames = source.getColumnNames();
        String rowName = "row";
        int i = 0;
        while (i < 2) {
            if ((i != 0 || source.isXColumnVisible()) && (i != 1 || source.isYColumnVisible())) {
                DataColumn column = new DataColumn();
                column.setName(source.getName());
                column.setXYColumnNames(rowName, colNames[i]);
                column.setConnected(source.isConnected());
                column.setLineColor(source.getLineColor());
                column.setMarkerSize(source.getMarkerSize());
                column.setMarkerShape(source.getMarkerShape());
                column.setMarkerColor(source.getFillColor(), source.getLineColor());
                column.setID(source.getID());
                column.setColumnID(i);
                column.setPoints(i == 0 ? source.getXPointsRaw() : (source.isShifted() ? source.getYPoints() : source.getYPointsRaw()), source.getIndex());
                column.setXColumnVisible(false);
                columns.add(column);
            }
            ++i;
        }
        return columns;
    }

    private static DataColumn createDataColumn(double[] data, String columnName, int columnID, Data source) {
        if (data == null) {
            return null;
        }
        DataColumn column = new DataColumn();
        column.setXYColumnNames("row", columnName);
        column.setConnected(true);
        Color[] lineColors = source.getLineColors();
        if (lineColors != null && lineColors[columnID] != null) {
            column.setLineColor(lineColors[columnID]);
        } else {
            column.setLineColor(DisplayColors.getLineColor(columnID));
        }
        column.setMarkerShape(2);
        Color[] fillColors = source.getFillColors();
        if (lineColors != null && lineColors[columnID] != null && fillColors != null && fillColors[columnID] != null) {
            column.setMarkerColor(fillColors[columnID], lineColors[columnID]);
        } else {
            column.setMarkerColor(DisplayColors.getMarkerColor(columnID), DisplayColors.getLineColor(columnID));
        }
        column.setID(source.getID());
        column.setColumnID(columnID);
        column.setPoints(data, data.length);
        return column;
    }

    private static Dataset createDataset(double[] xPoints, double[] yPoints, String xName, String yName, int columnID, Data source) {
        if (yPoints == null) {
            return null;
        }
        Dataset dataset = new Dataset();
        dataset.setXYColumnNames(xName, yName);
        dataset.setConnected(true);
        Color[] lineColors = source.getLineColors();
        if (lineColors != null && lineColors[columnID] != null) {
            dataset.setLineColor(lineColors[columnID]);
        } else {
            dataset.setLineColor(DisplayColors.getLineColor(columnID));
        }
        dataset.setMarkerShape(2);
        Color[] fillColors = source.getFillColors();
        if (lineColors != null && lineColors[columnID] != null && fillColors != null && fillColors[columnID] != null) {
            dataset.setMarkerColor(fillColors[columnID], lineColors[columnID]);
        } else {
            dataset.setMarkerColor(DisplayColors.getMarkerColor(columnID), DisplayColors.getLineColor(columnID));
        }
        dataset.setID(source.getID());
        dataset.append(xPoints, yPoints);
        return dataset;
    }

    public static Dataset copyDataset(Dataset source, Dataset target, boolean includeDataAndID) {
        if (target == null) {
            target = new Dataset();
        }
        if (includeDataAndID) {
            target.clear();
            double[] x = source.getXPointsRaw();
            double[] y = source.isShifted() ? source.getYPoints() : source.getYPointsRaw();
            target.append(x, y, source.getIndex());
            target.setID(source.getID());
        }
        target.setName(source.getName());
        target.setXYColumnNames(source.getXColumnName(), source.getYColumnName());
        target.setMarkerShape(source.getMarkerShape());
        target.setMarkerSize(source.getMarkerSize());
        Color fill = source.getFillColor();
        Color edge = source.getEdgeColor();
        target.setMarkerColor(fill, edge);
        target.setLineColor(source.getLineColor());
        target.setConnected(source.isConnected());
        target.setXColumnVisible(source.isXColumnVisible());
        target.setYColumnVisible(source.isYColumnVisible());
        return target;
    }

    protected static double[] insert(double input, double[] array, int trend) {
        int n = array.length;
        double[] newArray = new double[n + 1];
        if (trend == 0) {
            System.arraycopy(array, 0, newArray, 0, n);
            newArray[n] = input;
        } else if (trend > 0) {
            int i = 0;
            while (i < n) {
                if (input < array[i]) {
                    System.arraycopy(array, 0, newArray, 0, i);
                    System.arraycopy(array, i, newArray, i + 1, n - i);
                    newArray[i] = input;
                    return newArray;
                }
                ++i;
            }
            System.arraycopy(array, 0, newArray, 0, n);
            newArray[n] = input;
        } else {
            int i = 0;
            while (i < n) {
                if (input > array[i]) {
                    System.arraycopy(array, 0, newArray, 0, i);
                    System.arraycopy(array, i, newArray, i + 1, n - i);
                    newArray[i] = input;
                    return newArray;
                }
                ++i;
            }
            System.arraycopy(array, 0, newArray, 0, n);
            newArray[n] = input;
        }
        return newArray;
    }

    public void addTab(DataToolTab tab) {
        if (this.getTabCount() == 1) {
            DataToolTab prev = this.getTab(0);
            if (prev.originatorID == 0) {
                prev.tabChanged(false);
                this.removeTab(0, false);
            }
        }
        tab.dataTool = this;
        tab.setName(this.getUniqueTabName(tab.getName()));
        this.tabbedPane.addTab("", tab);
        tab.setFontLevel(FontSizer.getLevel());
        this.tabbedPane.setSelectedComponent(tab);
        this.refreshTabTitles();
        this.refreshMenubar();
    }

    protected boolean saveChangesAt(int i) {
        if (OSPRuntime.appletMode) {
            return true;
        }
        DataToolTab tab = this.getTab(i);
        if (!tab.tabChanged) {
            return true;
        }
        String name = tab.getName();
        if (ToolsRes.getString("DataToolTab.DefaultName").equals(name) && tab.originatorID == 0) {
            return true;
        }
        int selected = JOptionPane.showConfirmDialog(this, String.valueOf(ToolsRes.getString("DataTool.Dialog.SaveChanges.Message1")) + " \"" + name + "\" " + ToolsRes.getString("DataTool.Dialog.SaveChanges.Message2"), ToolsRes.getString("DataTool.Dialog.SaveChanges.Title"), 1);
        if (selected == 2) {
            return false;
        }
        return selected != 0 || this.save(tab, tab.fileName) != null;
    }

    public DataToolTab getSelectedTab() {
        return (DataToolTab)this.tabbedPane.getSelectedComponent();
    }

    public void setSelectedTab(DataToolTab tab) {
        this.tabbedPane.setSelectedComponent(tab);
    }

    @Override
    public void clearData() {
        this.removeAllTabs();
    }

    @Override
    public void setFontLevel(int level) {
        if (this.getJMenuBar() == null) {
            return;
        }
        super.setFontLevel(level);
        FontSizer.setFonts(this.emptyMenubar, level);
        FontSizer.setFonts(this.fileMenu, level);
        FontSizer.setFonts(this.editMenu, level);
        double factor = FontSizer.getFactor(level);
        buttonHeight = (int)(factor * 28.0);
        if (this.tabbedPane != null) {
            int i = 0;
            while (i < this.getTabCount()) {
                this.getTab(i).setFontLevel(level);
                ++i;
            }
        }
        if (this.dataBuilder != null) {
            this.dataBuilder.setFontLevel(level);
        }
        if (this.fontSizeGroup != null) {
            Enumeration<AbstractButton> e = this.fontSizeGroup.getElements();
            while (e.hasMoreElements()) {
                AbstractButton button = e.nextElement();
                int i = Integer.parseInt(button.getActionCommand());
                if (i != FontSizer.getLevel()) continue;
                button.setSelected(true);
            }
        }
        OSPLog.setFonts(level);
    }

    @Override
    public void setVisible(boolean vis) {
        if (this.contentPane.getPreferredSize().equals(dim)) {
            double f = 1.0 + 0.2 * (double)FontSizer.getLevel();
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            int w = Math.min(screen.width - 40, (int)((double)DataTool.dim.width * f));
            int h = Math.min(screen.height - 100, (int)((double)DataTool.dim.height * f));
            this.contentPane.setPreferredSize(new Dimension(w, h + 1));
            this.pack();
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.getBounds().width) / 2;
            int y = (dim.height - this.getBounds().height) / 2;
            if (!this.standAlone) {
                this.setLocation(x, y);
            }
        }
        super.setVisible(vis);
    }

    public FitBuilder getFitBuilder() {
        if (this.fitBuilder == null) {
            this.fitBuilder = new FitBuilder((Component)this, false);
            this.fitBuilder.setFontLevel(FontSizer.getLevel());
            this.fitBuilder.setHelpPath("fit_builder_help.html");
            this.fitBuilder.autoloadFits();
        }
        return this.fitBuilder;
    }

    protected static String write(String text, String fileName) {
        File file;
        block7: {
            block8: {
                String dir;
                File file2;
                int n = fileName.lastIndexOf("/");
                if (n < 0) {
                    n = fileName.lastIndexOf("\\");
                }
                if (n > 0 && !(file2 = new File(dir = fileName.substring(0, n + 1))).exists() && !file2.mkdir()) {
                    return null;
                }
                file = new File(fileName);
                if (!file.exists()) break block7;
                if (file.canWrite()) break block8;
                JOptionPane.showMessageDialog(null, ControlsRes.getString("Dialog.ReadOnly.Message"), ControlsRes.getString("Dialog.ReadOnly.Title"), -1);
                return null;
            }
            int selected = JOptionPane.showConfirmDialog(null, String.valueOf(ToolsRes.getString("Tool.Dialog.ReplaceFile.Message")) + SPACE + file.getName() + "?", ToolsRes.getString("Tool.Dialog.ReplaceFile.Title"), 1);
            if (selected == 0) break block7;
            return null;
        }
        try {
            FileOutputStream stream = new FileOutputStream(file);
            Charset charset = Charset.forName("UTF-8");
            DataTool.write(text, new OutputStreamWriter((OutputStream)stream, charset));
            if (file.exists()) {
                return file.getAbsolutePath();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    protected static void write(String text, Writer out) {
        try {
            BufferedWriter output = new BufferedWriter(out);
            output.write(text);
            ((Writer)output).flush();
            ((Writer)output).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void open() {
        OSPRuntime.getChooser().showOpenDialog(null, new Runnable(){

            @Override
            public void run() {
                OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
                DataTool.this.open(OSPRuntime.getChooser().getSelectedFile());
            }
        }, null);
    }

    void importFileIntoTab(final DataToolTab tab) {
        OSPRuntime.getChooser().showOpenDialog(tab, new Runnable(){

            @Override
            public void run() {
                OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
                DataTool.this.importFileIntoTab(tab, OSPRuntime.getChooser().getSelectedFile());
            }
        }, null);
    }

    protected String save(String fileName) {
        return this.save(this.getSelectedTab(), fileName);
    }

    protected String save(DataToolTab tab, String fileName) {
        if (fileName == null || fileName.equals("")) {
            return this.saveAs();
        }
        XMLControlElement control = new XMLControlElement(tab);
        if (control.write(fileName) == null) {
            return null;
        }
        tab.fileName = fileName;
        tab.tabChanged(false);
        return fileName;
    }

    protected String saveAs() {
        int result = OSPRuntime.getChooser().showSaveDialog(this);
        if (result == 0) {
            int selected;
            OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
            File file = OSPRuntime.getChooser().getSelectedFile();
            if (file.exists() && (selected = JOptionPane.showConfirmDialog(null, String.valueOf(ToolsRes.getString("Tool.Dialog.ReplaceFile.Message")) + SPACE + file.getName() + "?", ToolsRes.getString("Tool.Dialog.ReplaceFile.Title"), 1)) != 0) {
                return null;
            }
            String fileName = file.getAbsolutePath();
            if (fileName == null || fileName.trim().equals("")) {
                return null;
            }
            if (XML.getExtension(fileName) == null) {
                fileName = String.valueOf(fileName) + ".xml";
            }
            return this.save(XML.getRelativePath(fileName));
        }
        return null;
    }

    protected int getTabIndex(Data data) {
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            DataToolTab tab = (DataToolTab)this.tabbedPane.getComponentAt(i);
            if (tab.isOwnedBy(data)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int getTabIndex(DataToolTab tab) {
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            if (tab == this.tabbedPane.getComponentAt(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected DataTool(String title, String name) {
        super(title);
        this.setName(name);
        this.createGUI();
        Toolbox.addTool(name, this);
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                DataTool.this.refreshGUI();
            }
        });
        FileDropHandler fileDropHandler = new FileDropHandler();
        this.tabbedPane.setTransferHandler(fileDropHandler);
        this.setTransferHandler(fileDropHandler);
    }

    protected boolean removeAllButTab(int index) {
        int i = this.tabbedPane.getTabCount() - 1;
        while (i >= 0) {
            if (i != index) {
                if (!this.saveChangesAt(i)) {
                    return false;
                }
                DataToolTab tab = this.getTab(i);
                this.getFitBuilder().curveFitters.remove(tab.getCurveFitter());
                tab.getCurveFitter().notifyTabRemoved();
                this.tabbedPane.removeTabAt(i);
            }
            --i;
        }
        this.refreshTabTitles();
        this.refreshDataBuilder();
        return true;
    }

    protected boolean removeAllTabs() {
        int i = this.tabbedPane.getTabCount() - 1;
        while (i >= 0) {
            if (!this.saveChangesAt(i)) {
                return false;
            }
            DataToolTab tab = this.getTab(i);
            this.getFitBuilder().curveFitters.remove(tab.getCurveFitter());
            tab.getCurveFitter().notifyTabRemoved();
            this.tabbedPane.removeTabAt(i);
            --i;
        }
        this.refreshMenubar();
        this.refreshDataBuilder();
        return true;
    }

    protected void refreshTabTitles() {
        int i = 0;
        int n = this.tabbedPane.getTabCount();
        while (i < n) {
            this.tabbedPane.setTitleAt(i, ((DataToolTab)this.tabbedPane.getComponentAt(i)).getName());
            ++i;
        }
    }

    protected void refreshMenubar() {
        if (this.getTabCount() == 0) {
            this.emptyMenubar.add(this.displayMenu);
            this.emptyMenubar.add(this.helpMenu);
            this.setJMenuBar(this.emptyMenubar);
        } else {
            this.menubar.add(this.displayMenu);
            this.menubar.add(this.helpMenu);
            this.setJMenuBar(this.menubar);
        }
    }

    protected FunctionTool getDataBuilder() {
        if (this.dataBuilder == null) {
            this.dataBuilder = new DataBuilder(this);
            this.dataBuilder.setFontLevel(FontSizer.getLevel());
            this.dataBuilder.addPropertyChangeListener("function", this);
        }
        this.refreshDataBuilder();
        return this.dataBuilder;
    }

    protected void refreshDataBuilder() {
        if (this.dataBuilder != null) {
            this.dataBuilder.refreshPanels();
        }
    }

    protected static void showHelp() {
        String fileName = helpName;
        String helpPath = XML.getResolvedPath(fileName, helpBase);
        if (ResourceLoader.getResource(helpPath) != null) {
            OSPDesktop.displayURL(helpPath);
        } else {
            fileName = "data_tool_help.html";
            String classBase = "/org/opensourcephysics/resources/tools/html/";
            helpPath = XML.getResolvedPath(fileName, classBase);
            if (helpFrame == null || !helpPath.equals(helpFrame.getTitle())) {
                helpFrame = new TextFrame(helpPath);
                helpFrame.enableHyperlinks();
                helpFrame.setSize(800, 600);
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                int x = (dim.width - DataTool.helpFrame.getBounds().width) / 2;
                int y = (dim.height - DataTool.helpFrame.getBounds().height) / 2;
                helpFrame.setLocation(x, y);
            }
            helpFrame.setVisible(true);
        }
    }

    @Override
    public void setDefaultCloseOperation(int operation) {
        if (operation == 3) {
            this.exitOnClose = true;
            operation = 0;
        }
        if (operation != 0) {
            this.saveChangesOnClose = false;
        }
        super.setDefaultCloseOperation(operation);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    protected void createGUI() {
        double f = 1.0 + 0.25 * (double)FontSizer.getLevel();
        Dimension used = new Dimension((int)((double)DataTool.dim.width * f), (int)((double)DataTool.dim.height * f));
        this.contentPane.setPreferredSize(used);
        this.setContentPane(this.contentPane);
        JPanel centerPanel = new JPanel(new BorderLayout());
        this.contentPane.add((Component)centerPanel, "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DataTool.this.exitItem.doClick(0);
            }
        });
        this.tabbedPane = new JTabbedPane(1);
        centerPanel.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DataToolTab tab = DataTool.this.getSelectedTab();
                if (tab != null) {
                    tab.refreshData();
                    tab.dataTable.refreshTable(4);
                    tab.statsTable.refreshStatistics();
                    tab.propsTable.refreshTable();
                    tab.refreshPlot(true);
                    DataTool.this.refreshGUI();
                    tab.dataTable.requestFocusInWindow();
                    if (tab.dataTable.workingData != null) {
                        String var = tab.dataTable.workingData.getXColumnName();
                        var = TeXParser.removeSubscripting(var);
                        DataTool.this.getFitBuilder().setDefaultVariables(new String[]{var});
                    }
                }
            }
        });
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (OSPRuntime.isPopupTrigger(e)) {
                    final int index = DataTool.this.tabbedPane.getSelectedIndex();
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem item = new JMenuItem(ToolsRes.getString("DataTool.MenuItem.Name"));
                    popup.add(item);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DataToolTab tab = DataTool.this.getTab(index);
                            String name = tab.getName();
                            String input = GUIUtils.showInputDialog(DataTool.this, ToolsRes.getString("DataTool.Dialog.Name.Message"), ToolsRes.getString("DataTool.Dialog.Name.Title"), 3, name);
                            if (input == null) {
                                return;
                            }
                            tab.setName("");
                            tab.setName(DataTool.this.getUniqueTabName(input.toString()));
                            tab.tabChanged(true);
                            DataTool.this.refreshTabTitles();
                            DataTool.this.refreshDataBuilder();
                        }
                    });
                    if (!DataTool.this.getTab((int)index).dataManager.getDatasetsRaw().isEmpty()) {
                        popup.addSeparator();
                        item = new JMenuItem(ToolsRes.getString("DataTool.MenuItem.NewTab"));
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                (this).DataTool.this.newTabItem.doClick(0);
                            }
                        });
                        popup.add(item);
                        JMenu cloneMenu = new JMenu(ToolsRes.getString("DataTool.Menu.Clone"));
                        popup.add(cloneMenu);
                        JMenuItem cloneTabItem = new JMenuItem(ToolsRes.getString("DataTool.MenuItem.Editable"));
                        cloneMenu.add(cloneTabItem);
                        cloneTabItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DataTool.this.cloneTab(index, true);
                            }
                        });
                        item = new JMenuItem(ToolsRes.getString("DataTool.MenuItem.Noneditable"));
                        cloneMenu.add(item);
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DataTool.this.cloneTab(index, false);
                            }
                        });
                    }
                    popup.addSeparator();
                    item = new JMenuItem(ToolsRes.getString("MenuItem.Close"));
                    popup.add(item);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DataTool.this.removeTab(index, true);
                        }
                    });
                    item = new JMenuItem(ToolsRes.getString("MenuItem.CloseOthers"));
                    popup.add(item);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DataTool.this.removeAllButTab(index);
                        }
                    });
                    item = new JMenuItem(ToolsRes.getString("MenuItem.CloseAll"));
                    popup.add(item);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DataTool.this.removeAllTabs();
                        }
                    });
                    FontSizer.setFonts(popup);
                    popup.show(DataTool.this.tabbedPane, e.getX(), e.getY() + 8);
                }
            }
        });
        int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.menubar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.menubar.add(this.fileMenu);
        MouseAdapter fileMenuChecker = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                this.mousePressed(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                boolean empty;
                boolean bl = empty = DataTool.this.getSelectedTab().originatorID == 0;
                if (!OSPRuntime.appletMode) {
                    DataTool.this.exportItem.setEnabled(!empty);
                    DataTool.this.saveItem.setEnabled(!empty);
                    DataTool.this.saveAsItem.setEnabled(!empty);
                    int[] selectedRows = DataTool.this.getSelectedTab().dataTable.getSelectedRows();
                    int endRow = DataTool.this.getSelectedTab().dataTable.getRowCount() - 1;
                    if (selectedRows.length == 0 || selectedRows.length == 1 && selectedRows[0] == endRow && DataTool.this.getSelectedTab().dataTable.isEmptyRow(endRow)) {
                        DataTool.this.exportItem.setText(ToolsRes.getString("DataTool.MenuItem.Export"));
                    } else {
                        DataTool.this.exportItem.setText(ToolsRes.getString("DataTool.MenuItem.ExportSelection"));
                    }
                }
            }
        };
        this.fileMenu.addMouseListener(fileMenuChecker);
        this.newTabItem = new JMenuItem();
        this.newTabItem.setAccelerator(KeyStroke.getKeyStroke(78, keyMask));
        this.newTabItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTab tab = DataTool.this.createTab(null);
                tab.userEditable = true;
                DataTool.this.addTab(tab);
                tab.refreshGUI();
            }
        });
        this.fileMenu.add(this.newTabItem);
        if (!OSPRuntime.appletMode) {
            this.openItem = new JMenuItem();
            this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, keyMask));
            this.openItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataTool.this.open();
                }
            });
            this.fileMenu.add(this.openItem);
        }
        this.fileMenu.addSeparator();
        this.closeItem = new JMenuItem();
        this.closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = DataTool.this.tabbedPane.getSelectedIndex();
                DataTool.this.removeTab(index, true);
            }
        });
        this.fileMenu.add(this.closeItem);
        this.closeAllItem = new JMenuItem();
        this.closeAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTool.this.removeAllTabs();
            }
        });
        this.fileMenu.add(this.closeAllItem);
        this.fileMenu.addSeparator();
        if (!OSPRuntime.appletMode) {
            this.importItem = new JMenuItem();
            this.importItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataToolTab tab = DataTool.this.getSelectedTab();
                    DataTool.this.importFileIntoTab(tab);
                }
            });
            this.fileMenu.add(this.importItem);
            this.exportItem = new JMenuItem();
            this.exportItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataTool.this.getSelectedTab().saveTableDataToFile(false);
                }
            });
            this.fileMenu.add(this.exportItem);
            this.fileMenu.addSeparator();
            this.saveItem = new JMenuItem();
            this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, keyMask));
            this.saveItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataToolTab tab = DataTool.this.getSelectedTab();
                    DataTool.this.save(tab.fileName);
                }
            });
            this.fileMenu.add(this.saveItem);
            this.saveAsItem = new JMenuItem();
            this.saveAsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataTool.this.saveAs();
                }
            });
            this.fileMenu.add(this.saveAsItem);
            this.fileMenu.addSeparator();
        }
        this.printItem = new JMenuItem();
        this.printItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotTool.getTool().printImage(DataTool.this);
            }
        });
        if (!OSPRuntime.isJS) {
            this.printItem.setAccelerator(KeyStroke.getKeyStroke(80, keyMask));
        }
        if (!OSPRuntime.isJS) {
            this.fileMenu.add(this.printItem);
        }
        this.fileMenu.addSeparator();
        this.exitItem = new JMenuItem();
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, keyMask));
        this.exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DataTool.this.saveChangesOnClose || DataTool.this.removeAllTabs()) {
                    if (DataTool.this.exitOnClose) {
                        System.exit(0);
                    } else {
                        DataTool.this.setVisible(false);
                    }
                }
            }
        });
        this.fileMenu.add(this.exitItem);
        this.editMenu = new JMenu();
        this.editMenu.addMenuListener(this.editMenuChecker);
        this.menubar.add(this.editMenu);
        this.undoItem = new JMenuItem();
        this.undoItem.setEnabled(false);
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke(90, keyMask));
        this.undoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataTool.this.getSelectedTab().undoManager.canUndo()) {
                    DataTool.this.getSelectedTab().undoManager.undo();
                }
            }
        });
        this.editMenu.add(this.undoItem);
        this.redoItem = new JMenuItem();
        this.redoItem.setEnabled(false);
        this.redoItem.setAccelerator(KeyStroke.getKeyStroke(89, keyMask));
        this.redoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataTool.this.getSelectedTab().undoManager.canRedo()) {
                    DataTool.this.getSelectedTab().undoManager.redo();
                }
            }
        });
        this.editMenu.add(this.redoItem);
        this.editMenu.addSeparator();
        this.copyMenu = new JMenu();
        this.editMenu.add(this.copyMenu);
        this.copyTabItem = new JMenuItem();
        this.copyTabItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTool.this.copyTab();
            }
        });
        this.copyDataMenu = new JMenu();
        this.copyDataAsFormattedItem = new JMenuItem();
        this.copyDataAsFormattedItem.setAccelerator(KeyStroke.getKeyStroke(67, keyMask));
        this.copyDataAsFormattedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTool.this.getSelectedTab().copyTableDataToClipboard(true);
            }
        });
        this.copyDataRawItem = new JMenuItem();
        this.copyDataRawItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTool.this.getSelectedTab().copyTableDataToClipboard(false);
            }
        });
        this.setDelimiterMenu = new JMenu();
        this.setDelimiterMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                DataTool.this.setupDelimiterMenu(DataTool.this.setDelimiterMenu);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.copyImageItem = new JMenuItem();
        this.copyImageItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tabName = DataTool.this.getSelectedTab().getName();
                OSPLog.finest("copying image of " + tabName);
                SnapshotTool.getTool().copyImage(DataTool.this);
            }
        });
        MouseAdapter pasteMenuChecker = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!DataTool.this.pasteMenu.isEnabled() || DataTool.this.pasteMenu.isPopupMenuVisible()) {
                    return;
                }
                if (DataTool.this.hasPastableColumns(DataTool.this.getSelectedTab())) {
                    DataTool.this.pasteMenu.add(DataTool.this.pasteColumnsItem);
                } else {
                    DataTool.this.addableData = null;
                    DataTool.this.pasteMenu.remove(DataTool.this.pasteColumnsItem);
                }
                FontSizer.setFonts(DataTool.this.pasteMenu, FontSizer.getLevel());
            }
        };
        this.pasteMenu = new JMenu();
        this.pasteMenu.addMouseListener(pasteMenuChecker);
        this.editMenu.add(this.pasteMenu);
        this.pasteTabItem = new JMenuItem();
        this.pasteTabItem.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTool.this.pasteTab(DataTool.this.pasteTabItem);
            }
        });
        this.pasteMenu.add(this.pasteTabItem);
        this.pasteColumnsItem = new JMenuItem();
        this.pasteColumnsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataTool.this.controlContainsData) {
                    DataTool.this.getSelfContainedDataAsync(DataTool.this.control, DataTool.this.useChooser, new Consumer<ArrayList<Data>>(){

                        @Override
                        public void accept(ArrayList<Data> dataList) {
                            if (!dataList.isEmpty()) {
                                DatasetManager manager = new DatasetManager();
                                for (Data next : dataList) {
                                    for (DataColumn column : DataTool.getDataColumns(next)) {
                                        manager.addDataset(column);
                                    }
                                }
                                (this).DataTool.this.addableData = manager;
                                DataTool.this.addColumnsFromPaste();
                            }
                        }
                    });
                } else {
                    DataTool.this.addColumnsFromPaste();
                }
            }
        });
        this.pasteMenu.add(this.pasteColumnsItem);
        this.editMenu.addSeparator();
        this.editDataItem = new JMenuItem(String.valueOf(ToolsRes.getString("DataToolTab.Button.EditData.Text")) + "...");
        this.editDataItem.addActionListener(e -> this.editDataAction());
        this.editMenu.add(this.editDataItem);
        this.displayMenu = new JMenu();
        this.menubar.add(this.displayMenu);
        this.languageMenu = new JMenu();
        ResourceLoader.getImageIcon("resources/tools/images/open.gif");
        final Locale[] locales = OSPRuntime.getInstalledLocales();
        AbstractAction languageAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String language = e.getActionCommand();
                int i = 0;
                while (i < locales.length) {
                    if (language.equals(locales[i].toString())) {
                        ToolsRes.setLocale(locales[i]);
                        return;
                    }
                    ++i;
                }
            }
        };
        ButtonGroup languageGroup = new ButtonGroup();
        this.languageItems = new JMenuItem[locales.length];
        int i = 0;
        while (i < locales.length) {
            this.languageItems[i] = new JRadioButtonMenuItem(OSPRuntime.getDisplayLanguage(locales[i]));
            this.languageItems[i].setActionCommand(locales[i].toString());
            this.languageItems[i].addActionListener(languageAction);
            this.languageMenu.add(this.languageItems[i]);
            languageGroup.add(this.languageItems[i]);
            ++i;
        }
        this.displayMenu.add(this.languageMenu);
        this.fontSizeMenu = new JMenu();
        this.displayMenu.add(this.fontSizeMenu);
        this.fontSizeGroup = new ButtonGroup();
        AbstractAction fontSizeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = Integer.parseInt(e.getActionCommand());
                FontSizer.setLevel(i);
            }
        };
        int i2 = 0;
        while (i2 < 4) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem("+" + i2);
            if (i2 == 0) {
                this.defaultFontSizeItem = item;
                item.setText(ToolsRes.getString("Tool.MenuItem.DefaultFontSize"));
            }
            item.addActionListener(fontSizeAction);
            item.setActionCommand("" + i2);
            this.fontSizeMenu.add(item);
            this.fontSizeGroup.add(item);
            if (i2 == FontSizer.getLevel()) {
                item.setSelected(true);
            }
            ++i2;
        }
        this.helpMenu = new JMenu();
        this.menubar.add(this.helpMenu);
        this.helpItem = new JMenuItem();
        this.helpItem.setAccelerator(KeyStroke.getKeyStroke(72, keyMask));
        this.helpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTool.showHelp();
            }
        });
        this.helpMenu.add(this.helpItem);
        this.helpMenu.addSeparator();
        this.logItem = new JMenuItem();
        this.logItem.setAccelerator(KeyStroke.getKeyStroke(76, keyMask));
        this.logItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Point p0 = new Frame().getLocation();
                JFrame frame = OSPLog.getFrame();
                if (frame.getLocation().x == p0.x && frame.getLocation().y == p0.y) {
                    Point p = DataTool.this.getLocation();
                    frame.setLocation(p.x + 28, p.y + 28);
                }
                frame.setVisible(true);
            }
        });
        this.helpMenu.add(this.logItem);
        this.helpMenu.addSeparator();
        this.aboutItem = new JMenuItem();
        this.aboutItem.setAccelerator(KeyStroke.getKeyStroke(65, keyMask));
        this.aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTool.this.showAboutDialog();
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.setJMenuBar(this.menubar);
        this.emptyMenubar = new JMenuBar();
        this.emptyFileMenu = new JMenu();
        this.emptyMenubar.add(this.emptyFileMenu);
        this.emptyNewTabItem = new JMenuItem();
        this.emptyNewTabItem.setAccelerator(KeyStroke.getKeyStroke(78, keyMask));
        this.emptyNewTabItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTab tab = DataTool.this.createTab(null);
                tab.userEditable = true;
                DataTool.this.addTab(tab);
                tab.refreshGUI();
            }
        });
        this.emptyFileMenu.add(this.emptyNewTabItem);
        this.emptyOpenItem = new JMenuItem();
        this.emptyOpenItem.setAccelerator(KeyStroke.getKeyStroke(79, keyMask));
        this.emptyOpenItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTool.this.open();
            }
        });
        this.emptyFileMenu.add(this.emptyOpenItem);
        this.emptyFileMenu.addSeparator();
        this.emptyExitItem = new JMenuItem();
        this.emptyExitItem.setAccelerator(KeyStroke.getKeyStroke(81, keyMask));
        this.emptyExitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataTool.this.exitOnClose) {
                    System.exit(0);
                } else {
                    DataTool.this.setVisible(false);
                }
            }
        });
        this.emptyFileMenu.add(this.emptyExitItem);
        this.emptyEditMenu = new JMenu();
        this.emptyEditMenu.addMenuListener(this.editMenuChecker);
        this.emptyMenubar.add(this.emptyEditMenu);
        this.emptyPasteMenu = new JMenu();
        this.emptyEditMenu.add(this.emptyPasteMenu);
        this.emptyPasteTabItem = new JMenuItem();
        this.emptyPasteTabItem.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTool.this.pasteTab(DataTool.this.emptyPasteTabItem);
            }
        });
        this.emptyPasteMenu.add(this.emptyPasteTabItem);
        this.refreshGUI();
        this.refreshMenubar();
        int level = FontSizer.getLevel();
        if (level != 0) {
            this.setFontLevel(level);
        }
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        if (!this.standAlone) {
            this.setLocation(x, y);
        }
    }

    protected void pasteTab(Object source) {
        OSPRuntime.paste(s -> this.pasteAction((String)s, source));
    }

    protected void copyTab() {
        int i = this.tabbedPane.getSelectedIndex();
        String title = this.tabbedPane.getTitleAt(i);
        OSPLog.finest("copying tab " + title);
        OSPRuntime.copy(this.getTabXML(), null);
    }

    private String getTabXML() {
        return new XMLControlElement(this.getSelectedTab()).toXML();
    }

    protected void cloneTab(int index, boolean editable) {
        this.pasteAction(this.getTabXML(), this.pasteTabItem);
        String name = this.getTab(index).getName();
        String postfix = "_" + ToolsRes.getString("DataTool.Clone.Subscript");
        int pt = name.indexOf(postfix);
        if (pt >= 0) {
            name = name.substring(0, pt);
        }
        DataToolTab tab = this.getTab(this.getTabCount() - 1);
        tab.setName(this.getUniqueTabName(String.valueOf(name) + postfix));
        if (!editable) {
            tab.setUserEditable(false);
            for (Dataset next : tab.dataManager.getDatasetsRaw()) {
                if (!(next instanceof DataColumn)) continue;
                ((DataColumn)next).deletable = false;
            }
        }
        this.refreshTabTitles();
    }

    protected void pasteAction(String dataString, Object source) {
        boolean failed = false;
        try {
            if (dataString == null) {
                return;
            }
            if (dataString.startsWith("<?xml")) {
                this.control = new XMLControlElement();
                this.control.readXML(dataString);
                if (this.control.failedToRead()) {
                    failed = true;
                    return;
                }
                if (Data.class.isAssignableFrom(this.control.getObjectClass())) {
                    Data data = (Data)this.control.loadObject(null, true, true);
                    if (data == null) {
                        failed = true;
                        return;
                    }
                    for (Data next : DataTool.getSelfContainedData(data)) {
                        DataToolTab tab = this.createTab(next);
                        this.addTab(tab);
                    }
                    int i = this.getTabCount() - 1;
                    this.tabbedPane.setSelectedIndex(i);
                    return;
                }
                this.addTabs(this.control, new Consumer<ArrayList<DataToolTab>>(){

                    @Override
                    public void accept(ArrayList<DataToolTab> tabs) {
                        for (DataToolTab tab : tabs) {
                            tab.setUserEditable(true);
                        }
                        DataTool.this.tabbedPane.setSelectedIndex(DataTool.this.getTabCount() - 1);
                        DataTool.this.refreshDataBuilder();
                    }
                });
            } else {
                this.setMultipleTabPolicy(dataString);
                DatasetManager[] importedData = DataTool.parseData(dataString, null);
                if (importedData == null) {
                    failed = true;
                    return;
                }
                if (source != null) {
                    DataToolTab first = null;
                    int i = 0;
                    while (i < importedData.length) {
                        DataToolTab tab = this.createTab(importedData[i]);
                        if (first == null) {
                            first = tab;
                        }
                        this.addTab(tab);
                        tab.userEditable = true;
                        tab.refreshGUI();
                        tab.tabChanged(false);
                        ++i;
                    }
                    this.setSelectedTab(first);
                }
            }
        }
        finally {
            if (failed) {
                JOptionPane.showMessageDialog(this, ToolsRes.getString("Tool.Dialog.NoData.Message"), ToolsRes.getString("Tool.Dialog.NoData.Title"), 2);
            } else {
                this.refreshDataBuilder();
            }
        }
    }

    protected void addColumnsFromPaste() {
        if (this.addableData != null) {
            DataToolTab tab = this.getSelectedTab();
            tab.addColumns(this.addableData, true, true, true);
        }
    }

    void editDataAction() {
        new EditDataDialog();
    }

    @Override
    protected void refreshGUI() {
        this.setTitle(ToolsRes.getString("DataTool.Frame.Title"));
        this.emptyFileMenu.setText(ToolsRes.getString("Menu.File"));
        this.emptyNewTabItem.setText(ToolsRes.getString("DataTool.MenuItem.NewTab"));
        this.emptyOpenItem.setText(ToolsRes.getString("MenuItem.Open"));
        this.emptyExitItem.setText(ToolsRes.getString("MenuItem.Exit"));
        this.emptyEditMenu.setText(ToolsRes.getString("Menu.Edit"));
        this.emptyPasteMenu.setText(ToolsRes.getString("MenuItem.Paste"));
        this.emptyPasteTabItem.setText(ToolsRes.getString("DataTool.MenuItem.PasteNewTab"));
        this.fileMenu.setText(ToolsRes.getString("Menu.File"));
        this.newTabItem.setText(ToolsRes.getString("DataTool.MenuItem.NewTab"));
        if (!OSPRuntime.appletMode) {
            this.openItem.setText(ToolsRes.getString("MenuItem.Open"));
            this.importItem.setText(ToolsRes.getString("DataTool.MenuItem.Import"));
            this.saveItem.setText(ToolsRes.getString("DataTool.MenuItem.Save"));
            this.saveAsItem.setText(ToolsRes.getString("DataTool.MenuItem.SaveAs"));
        }
        this.closeItem.setText(ToolsRes.getString("MenuItem.Close"));
        this.closeAllItem.setText(ToolsRes.getString("MenuItem.CloseAll"));
        this.printItem.setText(ToolsRes.getString("DataTool.MenuItem.Print"));
        this.exitItem.setText(ToolsRes.getString("MenuItem.Exit"));
        this.editMenu.setText(ToolsRes.getString("Menu.Edit"));
        this.undoItem.setText(ToolsRes.getString("DataTool.MenuItem.Undo"));
        this.redoItem.setText(ToolsRes.getString("DataTool.MenuItem.Redo"));
        this.copyMenu.setText(ToolsRes.getString("DataTool.Menu.Copy"));
        this.copyImageItem.setText(ToolsRes.getString("DataTool.MenuItem.CopyImage"));
        this.pasteMenu.setText(ToolsRes.getString("MenuItem.Paste"));
        this.pasteTabItem.setText(ToolsRes.getString("DataTool.MenuItem.PasteNewTab"));
        this.pasteColumnsItem.setText(ToolsRes.getString("DataTool.MenuItem.PasteNewColumns"));
        this.displayMenu.setText(ToolsRes.getString("Tool.Menu.Display"));
        this.languageMenu.setText(ToolsRes.getString("Tool.Menu.Language"));
        this.fontSizeMenu.setText(ToolsRes.getString("Tool.Menu.FontSize"));
        this.defaultFontSizeItem.setText(ToolsRes.getString("Tool.MenuItem.DefaultFontSize"));
        this.editDataItem.setText(String.valueOf(ToolsRes.getString("DataToolTab.Button.EditData.Text")) + "...");
        this.editDataItem.setEnabled(this.getSelectedTab() != null && this.getSelectedTab().isUserEditable());
        this.helpMenu.setText(ToolsRes.getString("Menu.Help"));
        this.helpItem.setText(ToolsRes.getString("DataTool.MenuItem.Help"));
        this.logItem.setText(ToolsRes.getString("MenuItem.Log"));
        this.aboutItem.setText(ToolsRes.getString("MenuItem.About"));
        Locale[] locales = OSPRuntime.getInstalledLocales();
        int i = 0;
        while (i < locales.length) {
            if (locales[i].getLanguage().equals(ToolsRes.getLanguage())) {
                this.languageItems[i].setSelected(true);
            }
            ++i;
        }
    }

    public void refreshDecimalSeparators() {
        int i = 0;
        while (i < this.getTabCount()) {
            this.getTab(i).refreshDecimalSeparators();
            ++i;
        }
    }

    protected boolean hasPastableData() {
        if (OSPRuntime.isJS) {
            return true;
        }
        return this.isPastableData(OSPRuntime.paste(null));
    }

    private boolean isPastableData(String dataString) {
        this.controlContainsData = false;
        if (dataString == null) {
            return false;
        }
        if (!dataString.startsWith("<?xml")) {
            DatasetManager[] temp = DataTool.parseData(dataString, null);
            Data data = this.addableData = temp == null ? null : temp[0];
            return this.addableData != null;
        }
        this.control = new XMLControlElement();
        this.control.readXML(dataString);
        Class<?> type = this.control.getObjectClass();
        if (Data.class.isAssignableFrom(type)) {
            this.addableData = (Data)this.control.loadObject(null);
        } else if (!DataToolTab.class.isAssignableFrom(type)) {
            XMLTree tree = new XMLTree(this.control);
            tree.setHighlightedClass(Data.class);
            tree.selectHighlightedProperties();
            if (!tree.getSelectedProperties().isEmpty()) {
                this.controlContainsData = true;
            }
        }
        return this.addableData != null || DataToolTab.class.isAssignableFrom(type) || this.controlContainsData;
    }

    protected boolean hasPastableColumns(DataToolTab tab) {
        boolean pastable = false;
        if (this.addableData != null) {
            String dataName = this.addableData.getName();
            if (tab.dataManager.getDatasetsRaw().isEmpty() || dataName != null && !dataName.equals(tab.getName())) {
                pastable = true;
            }
        }
        return pastable || this.controlContainsData;
    }

    protected void showAboutDialog() {
        String date = OSPRuntime.getLaunchJarBuildDate();
        if ("".equals(date)) {
            date = "27 Oct 2025";
        }
        String toolname = ToolsRes.getString("DataTool.Frame.Title");
        String aboutString = String.valueOf(ToolsRes.getString("LibraryBrowser.Version")) + SPACE + "6.3.3" + "\nRelease date " + date + "\n" + "Open Source Physics\n" + "www.opensourcephysics.org";
        JOptionPane.showMessageDialog(this, aboutString, String.valueOf(ToolsRes.getString("Dialog.About.Title")) + SPACE + toolname, 1);
    }

    protected void setMultipleTabPolicy(String dataString) {
        if (askToLoadMultipleTracksInSingleTab && dataString.startsWith("#multi:")) {
            JPanel panel = new JPanel(new BorderLayout());
            JLabel label1 = new JLabel(ToolsRes.getString("DataTool.Dialog.Multitab.Message1"));
            JLabel label2 = new JLabel(ToolsRes.getString("DataTool.Dialog.Multitab.Message2"));
            JCheckBox checkbox = new JCheckBox(ToolsRes.getString("DataTool.Dialog.Multitab.Checkbox.Text"));
            checkbox.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
            Box box = Box.createVerticalBox();
            box.add(label1);
            box.add(label2);
            panel.add((Component)box, "North");
            panel.add((Component)checkbox, "South");
            boolean[] multipleTabs = new boolean[]{true};
            new AsyncDialog().showConfirmDialog(null, panel, ToolsRes.getString("DataTool.Dialog.Multitab.Title"), 0, ev -> {
                if (ev.getID() == 1) {
                    blArray[0] = false;
                }
            });
            loadMultipleTracksInSingleTab = !multipleTabs[0];
            askToLoadMultipleTracksInSingleTab = !checkbox.isSelected();
        }
    }

    protected static JButton createButton(String text) {
        return DataTool.createButton(text, true);
    }

    protected static JButton createButton(String text, final boolean allowBorder) {
        JButton button = new JButton(text){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                dim.height = buttonHeight;
                return dim;
            }

            @Override
            public void setBorder(Border b) {
                if (allowBorder || b instanceof EmptyBorder) {
                    super.setBorder(b);
                }
            }
        };
        return button;
    }

    public class EditDataDialog
    extends JDialog {
        JButton okButton;
        JButton cancelButton;
        JButton applyButton;
        JTextArea dataArea;
        JTextArea helpArea;
        boolean canceled;
        private String currentData;
        private JButton undoButton;
        private JButton redoButton;
        private String defaultColumnNameText;
        private int undoCount;

        EditDataDialog() {
            super(JOptionPane.getFrameForComponent(DataTool.this), true);
            this.defaultColumnNameText = "x, y\n";
            this.undoCount = 0;
            this.setLayout(new BorderLayout());
            this.setTitle(ToolsRes.getString("DataToolTab.Button.EditData.Text"));
            this.okButton = new JButton(DisplayRes.getString("Dialog.Button.Close.Text"));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditDataDialog.this.setVisible(false);
                }
            });
            this.applyButton = new JButton(DisplayRes.getString("Dialog.Button.Apply.Text"));
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditDataDialog.this.setData(null);
                    EditDataDialog.this.refreshUndoButtons();
                }
            });
            this.undoButton = new JButton(ToolsRes.getString("DataTool.MenuItem.Undo"));
            this.undoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((EditDataDialog)EditDataDialog.this).DataTool.this.undoItem.doClick(0);
                    EditDataDialog.this.refreshUndoButtons();
                    EditDataDialog editDataDialog = EditDataDialog.this;
                    editDataDialog.undoCount = editDataDialog.undoCount - 1;
                    EditDataDialog.this.refreshDataTextFromTable(false);
                }
            });
            this.redoButton = new JButton(ToolsRes.getString("DataTool.MenuItem.Redo"));
            this.redoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((EditDataDialog)EditDataDialog.this).DataTool.this.redoItem.doClick(0);
                    EditDataDialog.this.refreshUndoButtons();
                    EditDataDialog editDataDialog = EditDataDialog.this;
                    editDataDialog.undoCount = editDataDialog.undoCount + 1;
                    EditDataDialog.this.refreshDataTextFromTable(false);
                }
            });
            this.cancelButton = new JButton(DisplayRes.getString("GUIUtils.Cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditDataDialog.this.canceled = true;
                    EditDataDialog.this.setVisible(false);
                }
            });
            this.dataArea = new JTextArea(20, 30);
            this.dataArea.setCaretColor(Color.red);
            this.dataArea.setMargin(new Insets(1, 1, 1, 1));
            this.add((Component)new JScrollPane(this.dataArea), "Center");
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this.applyButton);
            buttonPanel.add(this.undoButton);
            buttonPanel.add(this.redoButton);
            buttonPanel.add(this.okButton);
            buttonPanel.add(this.cancelButton);
            this.add((Component)buttonPanel, "South");
            this.helpArea = new JTextArea(2, 30);
            this.helpArea.setEditable(false);
            this.helpArea.setLineWrap(true);
            this.helpArea.setForeground(Color.green.darker());
            this.helpArea.setText(String.valueOf(ToolsRes.getString("DataTool.Dialog.EditData.Help1")) + "\n" + ToolsRes.getString("DataTool.Dialog.EditData.Help2"));
            Border line = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
            Border space = BorderFactory.createEmptyBorder(4, 6, 4, 6);
            this.helpArea.setBorder(BorderFactory.createCompoundBorder(line, space));
            this.add((Component)this.helpArea, "North");
            this.refreshUndoButtons();
            FontSizer.setFont(this.dataArea);
            FontSizer.setFont(this.helpArea);
            this.setLocation(15, 30);
            this.pack();
            this.setVisible(true);
        }

        private void refreshUndoButtons() {
            this.undoButton.setEnabled(DataTool.this.getSelectedTab().undoManager.canUndo());
            this.redoButton.setEnabled(DataTool.this.getSelectedTab().undoManager.canRedo());
        }

        @Override
        public void setVisible(boolean vis) {
            if (vis) {
                this.canceled = false;
                this.refreshDataTextFromTable(true);
            } else {
                if (this.canceled) {
                    this.resetData();
                } else if (!this.dataArea.getText().equals(this.defaultColumnNameText)) {
                    this.setData(null);
                }
                DataTool.this.getSelectedTab().dataTable.refreshTable();
            }
            super.setVisible(vis);
        }

        void refreshDataTextFromTable(boolean init) {
            DataTool.this.getSelectedTab().dataTable.selectAll();
            String data = DataTool.this.getSelectedTab().getSelectedTableData(false, ",");
            DataTool.this.getSelectedTab().dataTable.clearSelection();
            data = data.substring(data.indexOf("\n") + 1);
            if (data.length() == 0) {
                this.currentData = "";
                this.dataArea.setText(init ? this.defaultColumnNameText : "");
            } else {
                data = data.replace('\t', ',');
                this.currentData = this.cleanData(data);
                this.dataArea.setText(this.currentData);
            }
        }

        private String cleanData(String data) {
            String newData = "";
            if (data == null || data.trim().equals("")) {
                return "";
            }
            String[] lines = data.trim().split("\\r?\\n");
            String[] colNames = lines[0].split(",");
            int j = 0;
            j = 0;
            while (j < colNames.length) {
                newData = String.valueOf(newData) + colNames[j].trim() + ", ";
                ++j;
            }
            newData = String.valueOf(newData.substring(0, newData.lastIndexOf(44))) + '\n';
            int i = 1;
            while (i < lines.length) {
                String[] line = lines[i].split(",");
                j = 0;
                while (j < line.length) {
                    newData = String.valueOf(newData) + line[j].trim() + ", ";
                    ++j;
                }
                int k = j;
                while (k < colNames.length) {
                    newData = String.valueOf(newData) + ", ";
                    ++k;
                }
                newData = String.valueOf(newData.substring(0, newData.lastIndexOf(44))) + '\n';
                ++i;
            }
            return newData;
        }

        void setData(String dataString) {
            if (dataString == null) {
                dataString = String.valueOf(this.dataArea.getText().trim()) + "\n";
            }
            if ((dataString = this.cleanData(dataString)).equals(this.currentData)) {
                return;
            }
            DataToolTab tab = DataTool.this.getSelectedTab();
            try {
                if (tab.setDelimitedData(dataString, this.currentData)) {
                    ++this.undoCount;
                }
                this.currentData = dataString;
                this.refreshDataTextFromTable(false);
            }
            catch (Exception e) {
                this.resetData();
            }
        }

        void resetData() {
            int i = 0;
            while (i < this.undoCount) {
                DataTool.this.undoItem.doClick(0);
                ++i;
            }
            i = 0;
            while (i < -this.undoCount) {
                DataTool.this.redoItem.doClick(0);
                ++i;
            }
        }
    }

    public static class ExpMovingAvg {
        private double alpha;
        private Double oldValue;

        public ExpMovingAvg(double alpha) {
            this.alpha = alpha;
        }

        public double average(double value) {
            if (this.oldValue == null) {
                this.oldValue = value;
                return value;
            }
            double newValue = this.oldValue + this.alpha * (value - this.oldValue);
            this.oldValue = newValue;
            return newValue;
        }
    }

    public class FileDropHandler
    extends TransferHandler {
        Boolean isDropOK = null;

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            for (File f : this.getFileList(support.getTransferable())) {
                DataTool.this.open(f);
            }
            return true;
        }

        private List<File> getFileList(Transferable t) {
            try {
                return (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

