/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.opensourcephysics.display.CellBorder;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.DataToolTable;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ToolsRes;

public final class DataToolPropsTable
extends JTable {
    public static final String PROPERTY_PROPTABLE_DISPLAY = "display";
    static final Color LIGHT_RED = new Color(255, 153, 153);
    DataToolTable dataTable;
    PropsTableModel propsModel;
    DataToolTable.LabelRenderer labelRenderer;
    MarkerEditor markerEditor = new MarkerEditor();
    JDialog styleDialog;
    Dataset markerDataset = new Dataset();
    Dataset lineDataset = new Dataset();
    JButton closeButton;
    String[] shapeNames;
    int[] shapeNumbers;
    JLabel shapeLabel;
    JLabel sizeLabel;
    JCheckBox markerVisCheckbox;
    JCheckBox lineVisCheckbox;
    JButton markerColorButton;
    JButton lineColorButton;
    JDialog colorPopup;
    JSpinner shapeSpinner;
    JSpinner sizeSpinner;
    int markerRow = 0;
    int lineRow = 1;
    int styleRow = 2;
    int axisRow = 3;
    boolean labelDrawn;
    private HashMap<String, PropsRenderer> htCellRenderers = new HashMap();

    public DataToolPropsTable(DataToolTable table) {
        this.dataTable = table;
        this.propsModel = new PropsTableModel();
        this.addMouseMotionListener(new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int col = DataToolPropsTable.this.columnAtPoint(e.getPoint());
                int labelCol = DataToolPropsTable.this.convertColumnIndexToView(0);
                int xCol = labelCol == 0 ? 1 : 0;
                int row = DataToolPropsTable.this.rowAtPoint(e.getPoint());
                if (col == labelCol || col == xCol || row == DataToolPropsTable.this.axisRow) {
                    DataToolPropsTable.this.setToolTipText(null);
                } else if (row == DataToolPropsTable.this.markerRow) {
                    DataToolPropsTable.this.setToolTipText(ToolsRes.getString("DataToolPropsTable.Markers.Tooltip"));
                } else if (row == DataToolPropsTable.this.lineRow) {
                    DataToolPropsTable.this.setToolTipText(ToolsRes.getString("DataToolPropsTable.Lines.Tooltip"));
                } else if (row == DataToolPropsTable.this.styleRow) {
                    DataToolPropsTable.this.setToolTipText(ToolsRes.getString("DataToolPropsTable.Style.Tooltip"));
                }
            }
        });
        this.init();
    }

    protected void init() {
        this.dataTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                DataToolPropsTable.this.refreshTable();
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                DataToolPropsTable.this.refreshTable();
            }
        });
        this.setModel(this.propsModel);
        this.setGridColor(Color.blue);
        this.setTableHeader(null);
        this.labelRenderer = this.dataTable.labelRenderer;
        this.setAutoResizeMode(0);
        this.refreshCellWidths();
    }

    private String[] getPropLabels() {
        return new String[]{ToolsRes.getString("DataToolPropsTable.Label.Markers"), ToolsRes.getString("DataToolPropsTable.Label.Lines"), ToolsRes.getString("DataToolPropsTable.Label.Style"), ToolsRes.getString("DataToolPropsTable.Label.Axis")};
    }

    public void refreshTable() {
        SwingUtilities.invokeLater(() -> {
            this.tableChanged(new TableModelEvent(this.propsModel, -1));
            this.refreshCellWidths();
        });
    }

    @Override
    public void addColumn(TableColumn aColumn) {
        int modelColumn = aColumn.getModelIndex();
        if (aColumn.getHeaderValue() == null) {
            String columnName = this.getModel().getColumnName(modelColumn);
            aColumn.setHeaderValue(columnName);
        }
        TableColumnModel m = this.getColumnModel();
        int i = m.getColumnCount();
        while (--i >= 0) {
            if (m.getColumn(i).getModelIndex() != modelColumn) continue;
            return;
        }
        m.addColumn(aColumn);
    }

    public void refreshCellWidths() {
        if (this.getColumnCount() != this.dataTable.getColumnCount()) {
            return;
        }
        this.refreshLabelColumnWidth();
        this.htCellRenderers.clear();
        int i = 0;
        while (i < this.getColumnCount()) {
            TableColumn propColumn = this.getColumnModel().getColumn(i);
            int w = this.dataTable.getColumnModel().getColumn(i).getWidth();
            propColumn.setMaxWidth(w);
            propColumn.setMinWidth(w);
            propColumn.setWidth(w);
            ++i;
        }
    }

    public void refreshGUI() {
        this.refreshLabelColumnWidth();
        this.tableChanged(null);
        this.refreshTable();
    }

    public void refreshLabelColumnWidth() {
        int w = 40;
        String[] labels = this.getPropLabels();
        int i = 0;
        while (i < labels.length) {
            JLabel label = new JLabel(labels[i]);
            label.setFont(this.labelRenderer.getFont());
            int lw = label.getMinimumSize().width;
            w = Math.max(w, lw);
            ++i;
        }
        this.dataTable.setLabelColumnWidth(w + 5);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        int i = this.dataTable.convertColumnIndexToModel(column);
        if (i == 0) {
            return this.labelRenderer;
        }
        TableColumn c = this.dataTable.getColumnModel().getColumn(column);
        String name = String.valueOf(row) + " " + c.getHeaderValue().toString();
        PropsRenderer pr = this.htCellRenderers.get(name);
        if (pr == null || pr.width != c.getWidth()) {
            pr = new PropsRenderer();
            this.htCellRenderers.put(name, pr);
        }
        return row < 2 && column > 1 ? this.getDefaultRenderer(Boolean.class) : pr;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (row == this.styleRow) {
            return this.markerEditor;
        }
        return this.getDefaultEditor(Boolean.class);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.setRowHeight(font.getSize() + 4);
        if (this.dataTable != null) {
            this.refreshLabelColumnWidth();
        }
    }

    protected JDialog getStyleDialog() {
        if (this.styleDialog != null) {
            return this.styleDialog;
        }
        final Frame frame = JOptionPane.getFrameForComponent(this.dataTable);
        this.styleDialog = new JDialog(frame, true);
        this.closeButton = new JButton();
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolPropsTable.this.styleDialog.setVisible(false);
                DataToolPropsTable.this.markerEditor.stopCellEditing();
            }
        });
        this.shapeNames = new String[]{ToolsRes.getString("Shape.Circle"), ToolsRes.getString("Shape.Square"), ToolsRes.getString("Shape.Pixel"), ToolsRes.getString("Shape.Bar"), ToolsRes.getString("Shape.Post")};
        this.shapeNumbers = new int[]{1, 2, 6, 7, 8};
        SpinnerListModel model = new SpinnerListModel(this.shapeNames);
        this.shapeSpinner = new JSpinner(model){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.height = DataToolPropsTable.this.markerColorButton.getPreferredSize().height;
                dim.width += 2;
                return dim;
            }
        };
        this.shapeSpinner.setToolTipText(ToolsRes.getString("Spinner.MarkerShape.ToolTip"));
        this.shapeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String shape = DataToolPropsTable.this.shapeSpinner.getValue().toString();
                int i = 0;
                while (i < DataToolPropsTable.this.shapeNames.length) {
                    DataToolTable.WorkingDataset working;
                    if (DataToolPropsTable.this.shapeNames[i].equals(shape) && (working = DataToolPropsTable.this.dataTable.workingMap.get(DataToolPropsTable.this.styleDialog.getName())) != null) {
                        DataToolPropsTable.this.dataTable.dataToolTab.tabChanged = true;
                        working.setMarkerShape(DataToolPropsTable.this.shapeNumbers[i]);
                        DataToolPropsTable.this.markerDataset.setMarkerShape(DataToolPropsTable.this.shapeNumbers[i]);
                        DataToolPropsTable.this.styleDialog.repaint();
                        frame.repaint();
                    }
                    ++i;
                }
            }
        });
        this.sizeSpinner = new JSpinner(new SpinnerNumberModel(2, 1, 6, 1)){

            @Override
            public Dimension getPreferredSize() {
                return DataToolPropsTable.this.shapeSpinner.getPreferredSize();
            }
        };
        this.sizeSpinner.setToolTipText(ToolsRes.getString("Spinner.MarkerSize.ToolTip"));
        this.sizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int size = (Integer)DataToolPropsTable.this.sizeSpinner.getValue();
                DataToolTable.WorkingDataset working = DataToolPropsTable.this.dataTable.workingMap.get(DataToolPropsTable.this.styleDialog.getName());
                if (working != null) {
                    DataToolPropsTable.this.dataTable.dataToolTab.tabChanged = true;
                    working.setMarkerSize(size);
                    DataToolPropsTable.this.markerDataset.setMarkerSize(size);
                    DataToolPropsTable.this.styleDialog.repaint();
                    frame.repaint();
                }
            }
        });
        this.markerVisCheckbox = new JCheckBox(ToolsRes.getString("DataToolPropsTable.Dialog.Checkbox.Visible"));
        this.markerVisCheckbox.setHorizontalAlignment(0);
        this.markerVisCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTable.WorkingDataset working = DataToolPropsTable.this.dataTable.workingMap.get(DataToolPropsTable.this.styleDialog.getName());
                if (working != null) {
                    DataToolPropsTable.this.dataTable.dataToolTab.tabChanged(true);
                    working.setMarkersVisible(DataToolPropsTable.this.markerVisCheckbox.isSelected());
                    DataToolPropsTable.this.styleDialog.repaint();
                    frame.repaint();
                }
                DataToolPropsTable.this.repaint();
            }
        });
        this.lineVisCheckbox = new JCheckBox(ToolsRes.getString("DataToolPropsTable.Dialog.Checkbox.Visible"));
        this.lineVisCheckbox.setHorizontalAlignment(0);
        this.lineVisCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTable.WorkingDataset working = DataToolPropsTable.this.dataTable.workingMap.get(DataToolPropsTable.this.styleDialog.getName());
                if (working != null) {
                    DataToolPropsTable.this.dataTable.dataToolTab.tabChanged(true);
                    working.setConnected(DataToolPropsTable.this.lineVisCheckbox.isSelected());
                    DataToolPropsTable.this.styleDialog.repaint();
                    frame.repaint();
                }
                DataToolPropsTable.this.repaint();
            }
        });
        final DrawingPanel markerPlot = new DrawingPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = DataToolPropsTable.this.markerColorButton.getPreferredSize();
                dim.width -= 20;
                return dim;
            }
        };
        markerPlot.setShowCoordinates(false);
        markerPlot.setBorder(BorderFactory.createEtchedBorder());
        markerPlot.setBackground(Color.white);
        markerPlot.setAntialiasShapeOn(true);
        this.markerDataset.append(0.0, 0.0);
        this.markerDataset.setName("marker");
        markerPlot.addDrawable(this.markerDataset);
        DrawingPanel linePlot = new DrawingPanel(){

            @Override
            public Dimension getPreferredSize() {
                return markerPlot.getPreferredSize();
            }
        };
        linePlot.setShowCoordinates(false);
        linePlot.setBorder(BorderFactory.createEtchedBorder());
        linePlot.setBackground(Color.white);
        linePlot.setAntialiasShapeOn(true);
        this.lineDataset.append(-1.0, 1.0);
        this.lineDataset.append(1.0, -1.0);
        this.lineDataset.setMarkerShape(0);
        this.lineDataset.setConnected(true);
        linePlot.addDrawable(this.lineDataset);
        this.shapeLabel = new JLabel(ToolsRes.getString("DataToolPropsTable.Dialog.Label.Shape"));
        this.sizeLabel = new JLabel(ToolsRes.getString("DataToolPropsTable.Dialog.Label.Size"));
        final JColorChooser cc = new JColorChooser();
        cc.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Color color = cc.getColor();
                DataToolTable.WorkingDataset working = DataToolPropsTable.this.dataTable.workingMap.get(DataToolPropsTable.this.styleDialog.getName());
                if (working != null) {
                    DataToolPropsTable.this.dataTable.dataToolTab.tabChanged = true;
                    if (DataToolPropsTable.this.colorPopup.getName().equals("marker")) {
                        working.setColor(color, working.getLineColor());
                    } else {
                        working.setColor(working.getEdgeColor(), color);
                    }
                    DataToolPropsTable.this.markerDataset.setMarkerColor(working.getFillColor(), working.getEdgeColor());
                    DataToolPropsTable.this.lineDataset.setLineColor(working.getLineColor());
                    DataToolPropsTable.this.colorPopup.setVisible(false);
                    DataToolPropsTable.this.styleDialog.repaint();
                    frame.repaint();
                }
            }
        });
        this.colorPopup = new JDialog((Dialog)this.styleDialog, true);
        this.colorPopup.setUndecorated(true);
        this.colorPopup.getContentPane().add(cc.getChooserPanels()[0]);
        this.colorPopup.pack();
        ActionListener colorAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton b = (JButton)e.getSource();
                DataToolPropsTable.this.colorPopup.setName(b == DataToolPropsTable.this.markerColorButton ? "marker" : "line");
                Point loc = b.getLocationOnScreen();
                DataToolPropsTable.this.colorPopup.setLocation(loc.x, loc.y + b.getSize().height);
                DataToolPropsTable.this.colorPopup.setVisible(true);
            }
        };
        this.markerColorButton = new JButton(ToolsRes.getString("DataToolPropsTable.Dialog.Button.Color"));
        this.markerColorButton.addActionListener(colorAction);
        this.lineColorButton = new JButton(ToolsRes.getString("DataToolPropsTable.Dialog.Button.Color"));
        this.lineColorButton.addActionListener(colorAction);
        JPanel contentPane = new JPanel(new BorderLayout());
        Box box = Box.createVerticalBox();
        contentPane.add(box);
        Box markerBox = Box.createVerticalBox();
        box.add(markerBox);
        markerBox.setBorder(BorderFactory.createTitledBorder(ToolsRes.getString("DataToolPropsTable.Dialog.Label.Markers")));
        JPanel markerNorth = new JPanel(new GridLayout());
        markerBox.add(markerNorth);
        JPanel markerPlotPanel = new JPanel();
        markerPlotPanel.add(markerPlot);
        markerNorth.add(markerPlotPanel);
        JPanel markerButtonPanel = new JPanel();
        markerButtonPanel.add(this.markerColorButton);
        markerNorth.add(markerButtonPanel);
        markerNorth.add(this.markerVisCheckbox);
        JPanel markerCenter = new JPanel(new GridLayout());
        markerBox.add(markerCenter);
        JPanel sizePanel = new JPanel();
        sizePanel.add(this.sizeLabel);
        sizePanel.add(this.sizeSpinner);
        markerCenter.add(sizePanel);
        JPanel shapePanel = new JPanel();
        shapePanel.add(this.shapeLabel);
        shapePanel.add(this.shapeSpinner);
        markerCenter.add(shapePanel);
        Box lineBox = Box.createVerticalBox();
        box.add(lineBox);
        lineBox.setBorder(BorderFactory.createTitledBorder(ToolsRes.getString("DataToolPropsTable.Dialog.Label.Lines")));
        JPanel lineNorth = new JPanel(new GridLayout());
        lineBox.add(lineNorth);
        JPanel linePlotPanel = new JPanel();
        linePlotPanel.add(linePlot);
        lineNorth.add(linePlotPanel);
        JPanel lineButtonPanel = new JPanel();
        lineButtonPanel.add(this.lineColorButton);
        lineNorth.add(lineButtonPanel);
        lineNorth.add(this.lineVisCheckbox);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.closeButton);
        box.add(buttonPanel);
        this.styleDialog.setContentPane(contentPane);
        FontSizer.setFonts(this.styleDialog, FontSizer.getLevel());
        this.styleDialog.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.styleDialog.getWidth()) / 2;
        Point p = this.getLocationOnScreen();
        int y = Math.max(0, p.y - this.styleDialog.getHeight());
        this.styleDialog.setLocation(x, y);
        return this.styleDialog;
    }

    public void dispose() {
        for (PropsRenderer r : this.htCellRenderers.values()) {
            if (r == null) continue;
            r.dispose();
        }
    }

    class MarkerEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        MarkerEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            JDialog dialog = DataToolPropsTable.this.getStyleDialog();
            String name = DataToolPropsTable.this.getColumnName(col);
            DataToolTable.WorkingDataset working = DataToolPropsTable.this.dataTable.workingMap.get(name);
            DataToolPropsTable.this.markerDataset.setMarkerColor(working.getFillColor(), working.getEdgeColor());
            DataToolPropsTable.this.markerDataset.setMarkerSize(working.getMarkerSize());
            DataToolPropsTable.this.markerDataset.setMarkerShape(working.markerType);
            DataToolPropsTable.this.lineDataset.setLineColor(working.getLineColor());
            DataToolPropsTable.this.closeButton.setText(ToolsRes.getString("Button.OK"));
            dialog.setName(null);
            DataToolPropsTable.this.sizeSpinner.setToolTipText(ToolsRes.getString("Spinner.MarkerSize.ToolTip"));
            DataToolPropsTable.this.sizeSpinner.setValue(working.getMarkerSize());
            DataToolPropsTable.this.shapeSpinner.setToolTipText(ToolsRes.getString("Spinner.MarkerShape.ToolTip"));
            DataToolPropsTable.this.shapeNames = new String[]{ToolsRes.getString("Shape.Circle"), ToolsRes.getString("Shape.Square"), ToolsRes.getString("Shape.Pixel"), ToolsRes.getString("Shape.Bar"), ToolsRes.getString("Shape.Post")};
            SpinnerListModel model = new SpinnerListModel(DataToolPropsTable.this.shapeNames){

                @Override
                public Object getNextValue() {
                    Object value = super.getNextValue();
                    if (value == null && this.getList().size() > 0) {
                        value = this.getList().get(0);
                    }
                    return value;
                }

                @Override
                public Object getPreviousValue() {
                    Object value = super.getPreviousValue();
                    int n = this.getList().size();
                    if (value == null && n > 0) {
                        value = this.getList().get(n - 1);
                    }
                    return value;
                }
            };
            DataToolPropsTable.this.shapeSpinner.setModel(model);
            int i = 0;
            while (i < DataToolPropsTable.this.shapeNumbers.length) {
                if (DataToolPropsTable.this.shapeNumbers[i] == working.markerType) {
                    DataToolPropsTable.this.shapeSpinner.setValue(DataToolPropsTable.this.shapeNames[i]);
                }
                ++i;
            }
            DataToolPropsTable.this.markerVisCheckbox.setSelected(working.isMarkersVisible());
            DataToolPropsTable.this.markerVisCheckbox.setEnabled(!working.isWorkingYColumn());
            DataToolPropsTable.this.lineVisCheckbox.setSelected(working.isConnected());
            dialog.setName(name);
            String var = TeXParser.removeSubscripting(name);
            String title = ToolsRes.getString("DataToolPropsTable.Dialog.Title");
            dialog.setTitle(String.valueOf(title) + " \"" + var + "\"");
            dialog.pack();
            Dimension dim = dialog.getSize();
            dim.width += 6;
            dialog.setSize(dim);
            dialog.setVisible(true);
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }

    class PropsRenderer
    implements TableCellRenderer {
        public int width;
        private JPanel panel;
        private DrawingPanel plot;
        private Dataset markerset;
        private Dataset lineset;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Color color;
            int yCol;
            int labelCol = DataToolPropsTable.this.dataTable.convertColumnIndexToView(0);
            int xCol = labelCol == 0 ? 1 : 0;
            int n = yCol = labelCol < 2 ? 2 : 1;
            Color color2 = col == xCol ? DataToolTable.xAxisColor : (color = col == yCol ? DataToolTable.yAxisColor : Color.white);
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                Component c = DataToolPropsTable.this.getDefaultRenderer(String.class).getTableCellRendererComponent(DataToolPropsTable.this, value, false, false, 0, 0);
                JLabel label = (JLabel)c;
                label.setHorizontalAlignment(0);
                label.setBackground(color);
                label.setBorder(new CellBorder(new Color(240, 240, 240)));
                return label;
            }
            if (value instanceof DataToolTable.WorkingDataset) {
                if (this.panel == null) {
                    this.width = DataToolPropsTable.this.getColumnModel().getColumn(col).getWidth();
                    this.panel = new JPanel(new GridLayout());
                    this.panel.setBorder(new CellBorder(new Color(240, 240, 240)));
                    this.panel.setBackground(row != DataToolPropsTable.this.axisRow ? Color.white : color);
                    this.plot = new DrawingPanel().dref(this);
                    this.plot.setBackground(Color.white);
                    this.plot.setAntialiasShapeOn(true);
                    this.plot.setPreferredMinMax(-1.0, 1.0, 0.0, 2.0);
                    this.markerset = new Dataset();
                    this.markerset.append(0.0, 1.0);
                    this.lineset = new Dataset();
                    this.lineset.setMarkerShape(0);
                    this.lineset.setConnected(true);
                    this.lineset.append(-1.0, 2.0);
                    this.lineset.append(1.0, 0.0);
                    this.plot.addDrawable(this.markerset);
                    this.plot.addDrawable(this.lineset);
                    this.panel.add(this.plot);
                }
                DataToolTable.WorkingDataset working = (DataToolTable.WorkingDataset)value;
                this.markerset.setMarkerColor(working.getFillColor(), working.getEdgeColor());
                this.markerset.setMarkerSize(working.getMarkerSize());
                this.markerset.setMarkerShape(working.markerType);
                this.lineset.setLineColor(working.getLineColor());
                Boolean markerVis = (Boolean)DataToolPropsTable.this.propsModel.getValueAt(DataToolPropsTable.this.markerRow, col);
                Boolean lineVis = (Boolean)DataToolPropsTable.this.propsModel.getValueAt(DataToolPropsTable.this.lineRow, col);
                this.plot.clear();
                if (markerVis.booleanValue()) {
                    this.plot.addDrawable(this.markerset);
                }
                if (lineVis.booleanValue()) {
                    this.plot.addDrawable(this.lineset);
                }
                return this.panel;
            }
            return null;
        }

        public void dispose() {
            if (this.plot != null) {
                this.plot.dispose();
            }
            this.plot = null;
        }
    }

    class PropsTableModel
    extends AbstractTableModel {
        PropsTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return DataTable.unshiftName(DataToolPropsTable.this.dataTable.getColumnName(col));
        }

        @Override
        public int getRowCount() {
            return 4;
        }

        @Override
        public int getColumnCount() {
            return DataToolPropsTable.this.dataTable.getModel().getColumnCount();
        }

        @Override
        public Object getValueAt(int row, int col) {
            int yCol;
            int labelCol = DataToolPropsTable.this.dataTable.convertColumnIndexToView(0);
            if (col == labelCol) {
                return DataToolPropsTable.this.getPropLabels()[row];
            }
            int xCol = labelCol == 0 ? 1 : 0;
            int n = yCol = labelCol < 2 ? 2 : 1;
            if (row == DataToolPropsTable.this.axisRow) {
                if (col == xCol) {
                    return ToolsRes.getString("DataToolPropsTable.Axis.Horizontal");
                }
                return ToolsRes.getString("DataToolPropsTable.Axis.Vertical");
            }
            String name = this.getColumnName(col);
            DataToolTable.WorkingDataset data = DataToolPropsTable.this.dataTable.workingMap.get(name);
            if (data == null) {
                data = DataToolPropsTable.this.dataTable.getWorkingData(name);
            }
            if (row == DataToolPropsTable.this.markerRow) {
                if (col == yCol && data != null) {
                    return Boolean.TRUE;
                }
                if (col == 0) {
                    return Boolean.FALSE;
                }
                return data != null && data.isMarkersVisible();
            }
            if (row == DataToolPropsTable.this.lineRow) {
                if (col == 0) {
                    return Boolean.FALSE;
                }
                return data != null && data.isConnected();
            }
            if (col == xCol) {
                return null;
            }
            return data;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            int yCol;
            if (row == DataToolPropsTable.this.axisRow) {
                return false;
            }
            int labelCol = DataToolPropsTable.this.dataTable.convertColumnIndexToView(0);
            int xCol = labelCol == 0 ? 1 : 0;
            int n = yCol = labelCol < 2 ? 2 : 1;
            if (col == labelCol || col == xCol) {
                return false;
            }
            return col != yCol || row != DataToolPropsTable.this.markerRow;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (value instanceof Boolean) {
                DataToolPropsTable.this.dataTable.dataToolTab.tabChanged(true);
                boolean selected = (Boolean)value;
                String name = this.getColumnName(col);
                DataToolTable.WorkingDataset working = DataToolPropsTable.this.dataTable.workingMap.get(name);
                if (row == DataToolPropsTable.this.markerRow) {
                    working.setMarkersVisible(selected);
                } else if (row == DataToolPropsTable.this.lineRow) {
                    working.setConnected(selected);
                }
                int labelCol = DataToolPropsTable.this.dataTable.convertColumnIndexToView(0);
                int xCol = labelCol == 0 ? 1 : 0;
                String xName = this.getColumnName(xCol);
                if (working.getXSource() == null || !working.getXSource().getYColumnName().equals(xName)) {
                    working.setXSource(DataToolPropsTable.this.dataTable.workingMap.get(xName).getYSource());
                }
                DataToolPropsTable.this.repaint();
                DataToolPropsTable.this.firePropertyChange(DataToolPropsTable.PROPERTY_PROPTABLE_DISPLAY, null, name);
            }
        }
    }
}

