/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.BitSet;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.opensourcephysics.display.CellBorder;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.DataToolTable;
import org.opensourcephysics.tools.ToolsRes;

public class DataToolStatsTable
extends JTable {
    DataToolTable dataTable;
    StatsTableModel statsModel;
    DataToolTable.LabelRenderer labelRenderer;
    NumberRenderer numberRenderer = new NumberRenderer(3);
    Object[][] statsData;

    public DataToolStatsTable(DataToolTable table) {
        this.dataTable = table;
        this.statsModel = new StatsTableModel();
        this.addMouseMotionListener(new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int labelCol;
                int col = DataToolStatsTable.this.columnAtPoint(e.getPoint());
                if (col == (labelCol = DataToolStatsTable.this.convertColumnIndexToView(0))) {
                    DataToolStatsTable.this.setToolTipText(null);
                } else {
                    int row = DataToolStatsTable.this.rowAtPoint(e.getPoint());
                    Object val = DataToolStatsTable.this.getValueAt(row, col);
                    Object stat = DataToolStatsTable.this.getValueAt(row, labelCol);
                    String name = DataToolStatsTable.this.dataTable.getColumnName(col);
                    DataToolStatsTable.this.setToolTipText(stat + "_" + name + " = " + val);
                }
            }
        });
        this.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                DataToolStatsTable.this.dataTable.dataToolTab.refreshStatusBar(DataToolStatsTable.this.dataTable.dataToolTab.getCorrelationString());
            }
        });
        this.init();
    }

    protected void init() {
        this.dataTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                DataToolStatsTable.this.refreshTable();
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                DataToolStatsTable.this.refreshTable();
            }
        });
        this.refreshStatistics();
        this.setModel(this.statsModel);
        this.setGridColor(Color.blue);
        this.setTableHeader(null);
        this.labelRenderer = this.dataTable.labelRenderer;
        this.setAutoResizeMode(0);
        ListSelectionModel selectionModel = this.dataTable.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getFirstIndex() > -1) {
                    DataToolStatsTable.this.refreshStatistics();
                }
            }
        });
        this.refreshCellWidths();
    }

    private String[] getStatLabels() {
        return new String[]{ToolsRes.getString("Table.Entry.Max"), ToolsRes.getString("Table.Entry.Min"), ToolsRes.getString("Table.Entry.Mean"), ToolsRes.getString("Table.Entry.StandardDev"), ToolsRes.getString("Table.Entry.StandardError"), ToolsRes.getString("Table.Entry.Count")};
    }

    private Object[] getStatistics(double[] data) {
        double sd;
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        double sum = 0.0;
        double squareSum = 0.0;
        int count = 0;
        int i = data.length;
        while (--i >= 0) {
            double d = data[i];
            if (Double.isNaN(d)) continue;
            ++count;
            max = Math.max(max, d);
            min = Math.min(min, d);
            sum += d;
            squareSum += d * d;
        }
        double mean = sum / (double)count;
        double d = sd = count < 2 ? Double.NaN : Math.sqrt((squareSum - (double)count * mean * mean) / (double)(count - 1));
        if (max == -1.7976931348623157E308) {
            max = Double.NaN;
        }
        if (min == Double.MAX_VALUE) {
            min = Double.NaN;
        }
        return new Object[]{max, min, mean, sd, sd / Math.sqrt(count), count};
    }

    public void refreshTable() {
        SwingUtilities.invokeLater(() -> {
            this.tableChanged(new TableModelEvent(this.statsModel, -1));
            this.refreshCellWidths();
        });
    }

    public void refreshStatistics() {
        TableModel model = this.dataTable.getModel();
        int[] data = this.dataTable.getSelectedColumns();
        BitSet selcols = DataToolStatsTable.getBS(data);
        data = this.dataTable.getSelectedRows();
        int nselrows = data.length;
        int nrows = model.getRowCount();
        int ncols = model.getColumnCount();
        this.statsData = new Object[ncols][0];
        this.statsData[0] = this.getStatLabels();
        int j = 1;
        while (j < ncols) {
            Double d;
            int i;
            double[] selected = null;
            if (nselrows > 0 && selcols.get(this.dataTable.convertColumnIndexToView(j))) {
                selected = new double[nselrows];
                i = 0;
                while (i < nselrows) {
                    d = (Double)model.getValueAt(data[i], j);
                    selected[i] = d == null ? Double.NaN : d;
                    ++i;
                }
            }
            if (selected == null) {
                selected = new double[nrows];
                i = 0;
                while (i < nrows) {
                    d = (Double)model.getValueAt(i, j);
                    selected[i] = d == null ? Double.NaN : d;
                    ++i;
                }
            }
            this.statsData[j] = this.getStatistics(selected);
            ++j;
        }
        this.refreshTable();
    }

    private static BitSet getBS(int[] selectedRows) {
        BitSet bs = new BitSet();
        int i = 0;
        while (i < selectedRows.length) {
            bs.set(selectedRows[i]);
            ++i;
        }
        return bs;
    }

    public void refreshCellWidths() {
        if (this.getColumnCount() != this.dataTable.getColumnCount()) {
            return;
        }
        int i = 0;
        while (i < this.getColumnCount()) {
            TableColumn propColumn = this.getColumnModel().getColumn(i);
            TableColumn dataColumn = this.dataTable.getColumnModel().getColumn(i);
            propColumn.setMaxWidth(dataColumn.getWidth());
            propColumn.setMinWidth(dataColumn.getWidth());
            propColumn.setWidth(dataColumn.getWidth());
            ++i;
        }
    }

    public void refreshGUI() {
        this.numberRenderer.format.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
        this.refreshStatistics();
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        int i = this.dataTable.convertColumnIndexToModel(column);
        if (i == 0) {
            return this.labelRenderer;
        }
        return this.numberRenderer;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.numberRenderer != null) {
            this.numberRenderer.font = font;
        }
        this.setRowHeight(font.getSize() + 4);
    }

    class NumberRenderer
    extends JLabel
    implements TableCellRenderer {
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance();
        Font font;

        public NumberRenderer(int sigfigs) {
            sigfigs = Math.min(sigfigs, 6);
            if (this.format instanceof DecimalFormat) {
                String pattern = "0.0";
                int i = 0;
                while (i < sigfigs - 1) {
                    pattern = String.valueOf(pattern) + "0";
                    ++i;
                }
                pattern = String.valueOf(pattern) + "E0";
                this.format.applyPattern(pattern);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.font == null) {
                this.font = DataToolStatsTable.this.getDefaultRenderer(String.class).getTableCellRendererComponent(DataToolStatsTable.this, "", false, false, 0, 0).getFont();
            }
            this.setFont(this.font);
            this.setHorizontalAlignment(11);
            this.setBorder(new CellBorder(new Color(240, 240, 240)));
            if (value instanceof Integer) {
                this.setText(String.valueOf(value));
            } else {
                this.setText(this.format.format(value));
            }
            return this;
        }
    }

    class StatsTableModel
    extends AbstractTableModel {
        StatsTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return DataToolStatsTable.this.dataTable.getColumnName(col);
        }

        @Override
        public int getRowCount() {
            return DataToolStatsTable.this.statsData[0].length;
        }

        @Override
        public int getColumnCount() {
            return DataToolStatsTable.this.dataTable.getModel().getColumnCount();
        }

        @Override
        public Object getValueAt(int row, int col) {
            int i = DataToolStatsTable.this.dataTable.convertColumnIndexToModel(col);
            return DataToolStatsTable.this.statsData[i][row];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

