/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawableTextLine;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.tools.DataColumn;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.ToolsRes;

public class DataToolTable
extends DataTable {
    protected static final int RENAME_COLUMN_EDIT = 0;
    protected static final int INSERT_COLUMN_EDIT = 1;
    protected static final int DELETE_COLUMN_EDIT = 2;
    protected static final int INSERT_CELLS_EDIT = 3;
    protected static final int DELETE_CELLS_EDIT = 4;
    protected static final int REPLACE_CELLS_EDIT = 5;
    protected static final int INSERT_ROWS_EDIT = 6;
    protected static final int DELETE_ROWS_EDIT = 7;
    protected static final int DELIMITED_TEXT_EDIT = 8;
    protected static String[] editTypes = new String[]{"rename column", "insert column", "delete column", "insert cells", "delete cells", "replace cells", "insert rows", "delete rows", "delimited text"};
    protected static Color xAxisColor = new Color(255, 255, 153);
    protected static Color yAxisColor = new Color(204, 255, 204);
    DataToolTab dataToolTab;
    DatasetManager dataManager;
    WorkingDataset workingData;
    HashMap<String, WorkingDataset> workingMap = new HashMap();
    HighlightableDataset selectedData = new HighlightableDataset();
    HeaderRenderer headerRenderer;
    LabelRenderer labelRenderer = new LabelRenderer();
    DataCellRenderer dataRenderer = new DataCellRenderer();
    DataEditor editor = new DataEditor();
    JPopupMenu popup;
    JMenuItem renameColumnItem;
    JMenuItem copyColumnsItem;
    JMenuItem cutColumnsItem;
    JMenuItem pasteColumnsItem;
    JMenuItem cloneColumnsItem;
    JMenuItem numberFormatItem;
    JMenuItem insertRowItem;
    JMenuItem pasteRowsItem;
    JMenuItem copyRowsItem;
    JMenuItem cutRowsItem;
    JMenuItem insertCellsItem;
    JMenuItem deleteCellsItem;
    JMenu copyCellsMenu;
    JMenu setDelimiterMenu;
    JMenuItem copyCellsAsFormattedItem;
    JMenuItem copyCellsRawItem;
    JMenuItem cutCellsItem;
    JMenuItem pasteInsertCellsItem;
    JMenuItem pasteCellsItem;
    JMenuItem addEndRowItem;
    JMenuItem trimRowsItem;
    JMenuItem selectAllItem;
    JMenuItem selectNoneItem;
    JMenuItem clearContentsItem;
    Action clearCellsAction;
    Action pasteCellsAction;
    Action pasteInsertCellsAction;
    Action cantPasteCellsAction;
    Action cantPasteRowsAction;
    Action getPasteDataAction;
    MouseAdapter tableMouseListener;
    Color selectedBG;
    Color selectedFG;
    Color unselectedBG;
    Color selectedHeaderFG;
    Color selectedHeaderBG;
    Color rowBG;
    int focusRow;
    int focusCol;
    int mouseRow;
    int mouseCol;
    int leadCol = 0;
    int leadRow = 0;
    int prevSortedColumn;
    int pasteW;
    int pasteH;
    HashMap<String, double[]> pasteValues = new HashMap();
    DatasetManager pasteData = null;
    HashMap<Integer, Integer> workingRowToModelRow = new HashMap();
    private Rectangle rect = new Rectangle();
    boolean clearing = false;

    JPopupMenu getPopup() {
        return this.popup == null ? (this.popup = new JPopupMenu()) : this.popup;
    }

    @Override
    protected DataTable.OSPDataTableModel createTableModel() {
        return new DataToolTableModel();
    }

    public DataToolTable(DataToolTab tab) {
        this.init();
        ((DataToolTableModel)this.getModel()).tab = tab;
        this.dataToolTab = tab;
        this.dataManager = tab.dataManager;
        this.add(this.dataManager.model);
        this.setRowNumberVisible(true);
        this.setSelectionMode(2);
        this.headerRenderer = new HeaderRenderer(this.getTableHeader().getDefaultRenderer());
        this.getTableHeader().setDefaultRenderer(this.headerRenderer);
        ListSelectionModel selectionModel = this.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getFirstIndex() == -1) {
                    return;
                }
                if (!e.getValueIsAdjusting()) {
                    int labelCol = DataToolTable.this.convertColumnIndexToView(0);
                    DataToolTable.this.addColumnSelectionInterval(labelCol, labelCol);
                    DataToolTable.this.dataToolTab.setSelectedData(DataToolTable.this.getSelectedData(), true);
                }
            }
        });
        selectionModel = this.getTableHeader().getColumnModel().getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                DataToolTable.this.getTableHeader().repaint();
            }
        });
        this.installActions();
    }

    private void installActions() {
        this.clearCellsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DataToolTable.this.dataToolTab.isUserEditable()) {
                    return;
                }
                HashMap<String, double[]> values = new HashMap<String, double[]>();
                Iterator<String> it = DataToolTable.this.getSelectedColumnNames().iterator();
                while (it.hasNext()) {
                    values.put(it.next(), null);
                }
                int[] rows = DataToolTable.this.getSelectedModelRows();
                HashMap<String, double[]> prev = DataToolTable.this.replaceCells(rows, values);
                TableEdit edit = new TableEdit(5, null, rows, new HashMap[]{prev, values});
                DataToolTable.this.dataToolTab.undoSupport.postEdit(edit);
                DataToolTable.this.refreshUndoItems();
            }
        };
        this.pasteCellsAction = new AbstractAction(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                block5: {
                    block2: {
                        block4: {
                            block3: {
                                rows = DataToolTable.access$3(DataToolTable.this);
                                if (DataToolTable.this.pasteValues.isEmpty() || rows.length != 1 && DataToolTable.this.pasteH != rows.length) break block2;
                                pasteRows = new int[DataToolTable.this.pasteH];
                                if (DataToolTable.this.pasteH != rows.length) break block3;
                                pasteRows = rows;
                                break block4;
                            }
                            pasteRows[0] = rows[0];
                            vRow = DataToolTable.access$2(DataToolTable.this, rows[0]);
                            i = 1;
                            ** GOTO lbl19
                            {
                                row = new int[]{DataToolTable.this.getRowCount()};
                                DataToolTable.this.insertRows(row, null);
                                do {
                                    if (vRow + i >= DataToolTable.this.getRowCount()) continue block0;
                                    pasteRows[i] = DataToolTable.access$1(DataToolTable.this, vRow + i);
                                    ++i;
lbl19:
                                    // 2 sources

                                } while (i < DataToolTable.this.pasteH);
                            }
                        }
                        prev = DataToolTable.this.replaceCells(pasteRows, DataToolTable.this.pasteValues);
                        edit = new TableEdit(5, null, pasteRows, new HashMap[]{prev, DataToolTable.this.pasteValues});
                        DataToolTable.this.dataToolTab.undoSupport.postEdit(edit);
                        DataToolTable.this.refreshUndoItems();
                        break block5;
                    }
                    DataToolTable.this.cantPasteCellsAction.actionPerformed(e);
                }
            }
        };
        this.pasteInsertCellsAction = new AbstractAction(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                block5: {
                    block2: {
                        block4: {
                            block3: {
                                rows = DataToolTable.access$3(DataToolTable.this);
                                if (DataToolTable.this.pasteValues.isEmpty() || rows.length != 1 && DataToolTable.this.pasteH != rows.length) break block2;
                                pasteRows = new int[DataToolTable.this.pasteH];
                                if (DataToolTable.this.pasteH != rows.length) break block3;
                                pasteRows = rows;
                                break block4;
                            }
                            pasteRows[0] = rows[0];
                            vRow = DataToolTable.access$2(DataToolTable.this, rows[0]);
                            i = 1;
                            ** GOTO lbl19
                            {
                                row = new int[]{DataToolTable.this.getRowCount()};
                                DataToolTable.this.insertRows(row, null);
                                do {
                                    if (vRow + i >= DataToolTable.this.getRowCount()) continue block0;
                                    pasteRows[i] = DataToolTable.access$1(DataToolTable.this, vRow + i);
                                    ++i;
lbl19:
                                    // 2 sources

                                } while (i < DataToolTable.this.pasteH);
                            }
                        }
                        DataToolTable.this.insertCells(pasteRows, DataToolTable.this.pasteValues);
                        edit = new TableEdit(3, null, pasteRows, DataToolTable.this.pasteValues);
                        DataToolTable.this.dataToolTab.undoSupport.postEdit(edit);
                        DataToolTable.this.refreshUndoItems();
                        break block5;
                    }
                    DataToolTable.this.cantPasteCellsAction.actionPerformed(e);
                }
            }
        };
        this.cantPasteCellsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(DataToolTable.this.dataToolTab, String.valueOf(ToolsRes.getString("DataToolTable.Dialog.CantPasteCells.Message1")) + " " + DataToolTable.this.pasteW + " x " + DataToolTable.this.pasteH + "\n" + ToolsRes.getString("DataToolTable.Dialog.CantPasteCells.Message2"), ToolsRes.getString("DataToolTable.Dialog.CantPaste.Title"), 2);
            }
        };
        this.cantPasteRowsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(DataToolTable.this.dataToolTab, String.valueOf(ToolsRes.getString("DataToolTable.Dialog.CantPasteRows.Message1")) + " " + DataToolTable.this.pasteH + "\n" + ToolsRes.getString("DataToolTable.Dialog.CantPasteRows.Message2"), ToolsRes.getString("DataToolTable.Dialog.CantPaste.Title"), 2);
            }
        };
        this.getPasteDataAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTable.this.pasteValues.clear();
                DataToolTable.this.pasteData = null;
                OSPRuntime.paste(dataString -> {
                    if (dataString != null) {
                        ArrayList<String> colNames = DataToolTable.this.getSelectedColumnNames();
                        DatasetManager[] temp = DataTool.parseData(dataString, null);
                        DatasetManager datasetManager = DataToolTable.this.pasteData = temp == null ? null : temp[0];
                        if (DataToolTable.this.pasteData != null) {
                            DataToolTable.this.pasteW = DataToolTable.this.pasteData.getDatasetsRaw().size();
                            if (DataToolTable.this.pasteW > 0 && DataToolTable.this.pasteW == colNames.size()) {
                                DataToolTable.this.pasteH = DataToolTable.this.pasteData.getDataset(0).getIndex();
                                if (DataToolTable.this.pasteH > 0) {
                                    int i = 0;
                                    while (i < DataToolTable.this.pasteW) {
                                        double[] vals = DataToolTable.this.pasteData.getDataset(i).getYPoints();
                                        DataToolTable.this.pasteValues.put(colNames.get(i), vals);
                                        ++i;
                                    }
                                }
                            }
                        }
                    }
                });
            }
        };
        this.getTableHeader().addMouseMotionListener(new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int n = DataToolTable.this.getTableHeader().columnAtPoint(e.getPoint());
                if ((n = DataToolTable.this.convertColumnIndexToModel(n)) == 0) {
                    DataToolTable.this.getTableHeader().setToolTipText(ToolsRes.getString("DataToolTable.Header.Deselect.Tooltip"));
                } else {
                    DataToolTable.this.getTableHeader().setToolTipText(ToolsRes.getString("DataToolTable.Header.Tooltip"));
                }
            }
        });
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DataToolTable.this.doHeaderMouseClicked(e);
            }
        });
        this.addMouseMotionListener(new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (DataToolTable.this.popup == null || !DataToolTable.this.popup.isVisible()) {
                    int row = DataToolTable.this.rowAtPoint(e.getPoint());
                    int col = DataToolTable.this.columnAtPoint(e.getPoint());
                    int labelCol = DataToolTable.this.convertColumnIndexToView(0);
                    DataToolTable.this.mouseRow = row;
                    DataToolTable.this.mouseCol = col;
                    DataToolTable.this.dataRenderer.showFocus = col == labelCol;
                    DataToolTable.this.dorepaint(2);
                    if (col == labelCol) {
                        DataToolTable.this.dataRenderer.showFocus = true;
                        DataToolTable.this.setToolTipText(ToolsRes.getString("DataToolTable.Deselect.Tooltip"));
                    } else {
                        Object obj = DataToolTable.this.getValueAt(row, col);
                        String name = DataToolTable.this.getColumnName(col);
                        DataToolTable.this.setToolTipText(String.valueOf(name) + " = " + obj);
                        defaultDoubleRenderer.setToolTipText(String.valueOf(name) + " = " + obj);
                    }
                }
                DataToolTable.this.requestFocusInWindow();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int col = DataToolTable.this.columnAtPoint(e.getPoint());
                int row = DataToolTable.this.rowAtPoint(e.getPoint());
                if (DataToolTable.this.mouseRow == row && DataToolTable.this.mouseCol == col) {
                    return;
                }
                DataToolTable.this.mouseRow = row;
                DataToolTable.this.mouseCol = col;
                int labelCol = DataToolTable.this.convertColumnIndexToView(0);
                if (col == labelCol) {
                    if (DataToolTable.this.leadRow < DataToolTable.this.getRowCount()) {
                        DataToolTable.this.setRowSelectionInterval(DataToolTable.this.leadRow, row);
                    }
                    DataToolTable.this.setColumnSelectionInterval(DataToolTable.this.getColumnCount() - 1, 0);
                }
                DataToolTable.this.dataRenderer.showFocus = false;
                DataToolTable.this.dataToolTab.setSelectedData(DataToolTable.this.getSelectedData(), false);
                DataToolTable.this.dataToolTab.refreshFit();
            }
        });
        this.tableMouseListener = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (DataToolTable.this.popup == null || !DataToolTable.this.popup.isVisible()) {
                    DataToolTable.this.mouseRow = -1;
                    DataToolTable.this.dataRenderer.showFocus = true;
                    DataToolTable.this.dorepaint(1);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                DataToolTable.this.doTableMousePressed(e);
            }
        };
        this.addMouseListener(this.tableMouseListener);
        InputMap im = this.getInputMap(1);
        ActionMap am = this.getActionMap();
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        OSPRuntime.setOSPAction(im, enter, "enter", am, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTable.this.editor.editAction(e, false);
            }
        });
        KeyStroke copy = KeyStroke.getKeyStroke(67, mask);
        OSPRuntime.setOSPAction(im, copy, "copy", am, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTable.this.dataToolTab.copyTableDataToClipboard(true);
            }
        });
        KeyStroke paste = KeyStroke.getKeyStroke(86, mask);
        OSPRuntime.setOSPAction(im, paste, "paste", this.getActionMap(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTable.this.getPasteDataAction.actionPerformed(e);
                DataToolTable.this.pasteCellsAction.actionPerformed(e);
            }
        });
        KeyStroke delete = KeyStroke.getKeyStroke(127, 0);
        OSPRuntime.setOSPAction(im, delete, "delete", this.getActionMap(), this.clearCellsAction);
    }

    @Override
    protected void updateRowSelection(int firstIndex, boolean isAdjusting) {
        if (firstIndex == -1) {
            return;
        }
        this.dataTableModel.setSelectedRowsFromJTable();
        if (!isAdjusting) {
            int labelCol = this.convertColumnIndexToView(0);
            this.addColumnSelectionInterval(labelCol, labelCol);
            this.dataToolTab.setSelectedData(this.getSelectedData(), true);
        }
    }

    protected void doTableMousePressed(MouseEvent e) {
        int col = this.columnAtPoint(e.getPoint());
        int row = this.rowAtPoint(e.getPoint());
        int labelCol = this.convertColumnIndexToView(0);
        if (OSPRuntime.isPopupTrigger(e)) {
            this.getTablePopup(row, col, labelCol);
            this.popup.show(this, e.getX(), e.getY() + 8);
            return;
        }
        this.dataRenderer.showFocus = true;
        if (col == labelCol) {
            if (e.getClickCount() == 2) {
                this.leadRow = row;
                this.setRowSelectionInterval(row, row);
                this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
            } else if (e.isShiftDown() && this.leadRow < this.getRowCount()) {
                this.setRowSelectionInterval(this.leadRow, row);
                this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
            } else if (!e.isControlDown() && !e.isShiftDown()) {
                this.leadRow = row;
                this.leadCol = 1;
            }
        } else if (!e.isControlDown() && !e.isShiftDown()) {
            this.leadRow = row;
            this.leadCol = col;
        }
        this.addColumnSelectionInterval(labelCol, labelCol);
        this.dataTableModel.setColumnSelectionFromJTable();
        this.getSelectedData();
        this.dataToolTab.plot.repaint();
    }

    private void getTablePopup(int row, int col, int labelCol) {
        this.getPopup();
        this.editor.stopCellEditing();
        if (col == labelCol) {
            if (!this.isRowSelected(row)) {
                this.setRowSelectionInterval(row, row);
            }
            this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
        } else if (!this.isCellSelected(row, col)) {
            this.setRowSelectionInterval(row, row);
            this.setColumnSelectionInterval(col, col);
            this.leadCol = col;
            this.leadRow = row;
        }
        this.dorepaint(3);
        if (!OSPRuntime.isJS) {
            this.getPasteDataAction.actionPerformed(null);
        }
        final int[] rows = this.getSelectedModelRows();
        boolean isEmptyCells = true;
        int[] selectedRows = this.getSelectedRows();
        ArrayList<String> selectedColumns = this.getSelectedColumnNames();
        int i = 0;
        while (i < selectedRows.length) {
            if (!this.isEmptyCells(selectedRows[i], selectedColumns)) {
                isEmptyCells = false;
                break;
            }
            ++i;
        }
        this.popup.removeAll();
        if (col != labelCol) {
            int index = this.convertColumnIndexToModel(col) - 1;
            Dataset data = this.dataManager.getDataset(index);
            this.mouseRow = row;
            this.mouseCol = col;
            this.dorepaint(4);
            String text = ToolsRes.getString("DataToolTable.Popup.MenuItem.SelectAll");
            this.selectAllItem = new JMenuItem(text);
            this.selectAllItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataToolTable.this.selectAllCells();
                }
            });
            this.popup.add(this.selectAllItem);
            text = ToolsRes.getString("DataToolTable.Popup.MenuItem.SelectNone");
            this.selectNoneItem = new JMenuItem(text);
            this.selectNoneItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataToolTable.this.clearSelection();
                }
            });
            this.popup.add(this.selectNoneItem);
            if (this.dataToolTab.isUserEditable() && !(data instanceof DataFunction)) {
                this.popup.addSeparator();
                text = ToolsRes.getString("DataToolTable.Popup.MenuItem.InsertCells");
                this.insertCellsItem = new JMenuItem(text);
                this.insertCellsItem.setActionCommand(String.valueOf(col));
                this.insertCellsItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HashMap<String, double[]> emptyRow = new HashMap<String, double[]>();
                        Iterator<String> it = DataToolTable.this.getSelectedColumnNames().iterator();
                        while (it.hasNext()) {
                            emptyRow.put(it.next(), null);
                        }
                        DataToolTable.this.insertCells(rows, emptyRow);
                        TableEdit edit = new TableEdit(3, null, rows, emptyRow);
                        DataToolTable.this.dataToolTab.undoSupport.postEdit(edit);
                        DataToolTable.this.refreshUndoItems();
                    }
                });
                this.popup.add(this.insertCellsItem);
                if (this.pasteData != null) {
                    text = ToolsRes.getString("DataToolTable.Popup.MenuItem.PasteInsertCells");
                    this.pasteInsertCellsItem = new JMenuItem(text);
                    this.pasteInsertCellsItem.setActionCommand(String.valueOf(col));
                    this.pasteInsertCellsItem.addActionListener(this.pasteInsertCellsAction);
                    this.popup.add(this.pasteInsertCellsItem);
                }
                text = ToolsRes.getString("DataToolTable.Popup.MenuItem.DeleteCells");
                this.deleteCellsItem = new JMenuItem(text);
                this.deleteCellsItem.setActionCommand(String.valueOf(col));
                this.deleteCellsItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Iterator<String> it = DataToolTable.this.getSelectedColumnNames().iterator();
                        while (it.hasNext()) {
                            DataToolTable.this.pasteValues.put(it.next(), null);
                        }
                        HashMap<String, double[]> prev = DataToolTable.this.deleteCells(rows, DataToolTable.this.pasteValues);
                        TableEdit edit = new TableEdit(4, null, rows, prev);
                        DataToolTable.this.dataToolTab.undoSupport.postEdit(edit);
                        DataToolTable.this.refreshUndoItems();
                    }
                });
                this.popup.add(this.deleteCellsItem);
            }
            if (!isEmptyCells || this.pasteData != null) {
                if (this.popup.getComponentCount() > 0 && !this.dataToolTab.originShiftEnabled) {
                    this.popup.addSeparator();
                }
                if (!isEmptyCells) {
                    text = ToolsRes.getString("DataToolTable.Popup.MenuItem.CopyCells");
                    this.copyCellsMenu = new JMenu(text);
                    this.popup.add(this.copyCellsMenu);
                    this.copyCellsAsFormattedItem = new JMenuItem(ToolsRes.getString("DataTool.MenuItem.Formatted"));
                    this.copyCellsAsFormattedItem.setActionCommand(String.valueOf(col));
                    this.copyCellsAsFormattedItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DataToolTable.this.dataToolTab.copyTableDataToClipboard(true);
                        }
                    });
                    this.copyCellsMenu.add(this.copyCellsAsFormattedItem);
                    this.copyCellsRawItem = new JMenuItem(ToolsRes.getString("DataTool.MenuItem.Unformatted"));
                    this.copyCellsRawItem.setActionCommand(String.valueOf(col));
                    this.copyCellsRawItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DataToolTable.this.dataToolTab.copyTableDataToClipboard(false);
                        }
                    });
                    this.copyCellsMenu.add(this.copyCellsRawItem);
                    this.setDelimiterMenu = new JMenu(ToolsRes.getString("DataTool.Menu.SetDelimiter"));
                    this.setDelimiterMenu.addMenuListener(new MenuListener(){

                        @Override
                        public void menuSelected(MenuEvent e) {
                            if (DataToolTable.this.dataToolTab.dataTool != null) {
                                DataToolTable.this.dataToolTab.dataTool.setupDelimiterMenu(DataToolTable.this.setDelimiterMenu);
                            }
                        }

                        @Override
                        public void menuDeselected(MenuEvent e) {
                        }

                        @Override
                        public void menuCanceled(MenuEvent e) {
                        }
                    });
                    this.copyCellsMenu.addSeparator();
                    this.copyCellsMenu.add(this.setDelimiterMenu);
                    if (this.dataToolTab.isUserEditable() && !(data instanceof DataFunction)) {
                        text = ToolsRes.getString("DataToolTable.Popup.MenuItem.CutCells");
                        this.cutCellsItem = new JMenuItem(text);
                        this.cutCellsItem.setActionCommand(String.valueOf(col));
                        this.cutCellsItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DataToolTable.this.copyCellsAsFormattedItem.doClick();
                                DataToolTable.this.clearCellsAction.actionPerformed(e);
                            }
                        });
                        this.popup.add(this.cutCellsItem);
                        text = ToolsRes.getString("DataToolTable.Popup.MenuItem.DeleteContents");
                        this.clearContentsItem = new JMenuItem(text);
                        this.clearContentsItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DataToolTable.this.clearCellsAction.actionPerformed(null);
                            }
                        });
                        this.popup.add(this.clearContentsItem);
                    }
                }
                if (this.dataToolTab.isUserEditable() && this.pasteData != null) {
                    text = ToolsRes.getString("DataToolTable.Popup.MenuItem.PasteCells");
                    this.pasteCellsItem = new JMenuItem(text);
                    this.pasteCellsItem.setActionCommand(String.valueOf(col));
                    this.pasteCellsItem.addActionListener(this.pasteCellsAction);
                    this.popup.add(this.pasteCellsItem);
                }
            }
        } else {
            this.leadRow = row;
            if (this.dataToolTab.isUserEditable()) {
                boolean hasRows;
                String text = ToolsRes.getString("DataToolTable.Popup.MenuItem.InsertRows");
                this.insertRowItem = new JMenuItem(text);
                this.insertRowItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HashMap<String, double[]> prev = DataToolTable.this.insertRows(rows, null);
                        TableEdit edit = new TableEdit(6, null, rows, prev);
                        DataToolTable.this.dataToolTab.undoSupport.postEdit(edit);
                        DataToolTable.this.refreshUndoItems();
                    }
                });
                this.popup.add(this.insertRowItem);
                boolean bl = hasRows = !this.pasteValues.isEmpty();
                if (hasRows) {
                    for (String next : this.pasteValues.keySet()) {
                        boolean bl2 = hasRows = hasRows && this.pasteData.getDatasetIndex(next) > -1;
                    }
                }
                if (hasRows) {
                    text = ToolsRes.getString("DataToolTable.Popup.MenuItem.PasteInsertRows");
                    this.pasteRowsItem = new JMenuItem(text);
                    this.pasteRowsItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (rows.length != 1 && DataToolTable.this.pasteH != rows.length) {
                                DataToolTable.this.cantPasteRowsAction.actionPerformed(e);
                                return;
                            }
                            int[] pasteRows = new int[DataToolTable.this.pasteH];
                            if (DataToolTable.this.pasteH == rows.length) {
                                pasteRows = rows;
                            } else if (rows.length == 1) {
                                pasteRows[0] = rows[0];
                                int i = 1;
                                while (i < DataToolTable.this.pasteH) {
                                    pasteRows[i] = rows[0] + i;
                                    ++i;
                                }
                            }
                            DataToolTable.this.insertRows(pasteRows, DataToolTable.this.pasteValues);
                            TableEdit edit = new TableEdit(6, null, pasteRows, DataToolTable.this.pasteValues);
                            DataToolTable.this.dataToolTab.undoSupport.postEdit(edit);
                            DataToolTable.this.refreshUndoItems();
                        }
                    });
                    this.popup.add(this.pasteRowsItem);
                }
                this.popup.addSeparator();
            }
            String text = ToolsRes.getString("DataToolTable.Popup.MenuItem.CopyRows");
            this.copyRowsItem = new JMenuItem(text);
            this.copyRowsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OSPLog.finest("copying rows");
                    OSPRuntime.copy(DataToolTable.this.dataToolTab.getSelectedTableData(false, VideoIO.getDelimiter()), null);
                }
            });
            this.popup.add(this.copyRowsItem);
            if (this.dataToolTab.isUserEditable()) {
                text = ToolsRes.getString("DataToolTable.Popup.MenuItem.CutRows");
                this.cutRowsItem = new JMenuItem(text);
                this.cutRowsItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DataToolTable.this.copyRowsItem.doClick();
                        int[] rows = DataToolTable.this.getSelectedModelRows();
                        HashMap<String, double[]> removed = DataToolTable.this.deleteRows(rows);
                        TableEdit edit = new TableEdit(7, null, rows, removed);
                        DataToolTable.this.dataToolTab.undoSupport.postEdit(edit);
                        DataToolTable.this.refreshUndoItems();
                    }
                });
                this.popup.add(this.cutRowsItem);
                this.popup.addSeparator();
                text = ToolsRes.getString("DataToolTable.Popup.MenuItem.AddEndRow");
                this.addEndRowItem = new JMenuItem(text);
                this.addEndRowItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DataToolTable.this.insertRows(new int[]{DataToolTable.this.getRowCount()}, null);
                    }
                });
                this.popup.add(this.addEndRowItem);
                if (this.isEmptyRow(this.getRowCount() - 1)) {
                    text = ToolsRes.getString("DataToolTable.Popup.MenuItem.TrimRows");
                    this.trimRowsItem = new JMenuItem(text);
                    this.trimRowsItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (DataToolTable.this.trimEmptyRows(0)) {
                                DataToolTable.this.refreshTable(16896);
                            }
                        }
                    });
                    this.popup.add(this.trimRowsItem);
                }
            }
        }
        FontSizer.setFonts(this.popup, FontSizer.getLevel());
    }

    protected void doHeaderMouseClicked(MouseEvent e) {
        if (this.getRowCount() == 0) {
            return;
        }
        Point mousePt = e.getPoint();
        int col = this.columnAtPoint(mousePt);
        if (col == -1) {
            return;
        }
        int labelCol = this.convertColumnIndexToView(0);
        ArrayList<String> cols = this.getSelectedColumnNames();
        if (OSPRuntime.isPopupTrigger(e)) {
            if (col == labelCol) {
                return;
            }
            String colName = this.getColumnName(col);
            if (!cols.contains(colName)) {
                this.setColumnSelectionInterval(col, col);
                this.leadCol = col;
            }
            this.createHeaderPopup(col);
            this.popup.show(this.getTableHeader(), e.getX(), e.getY() + 8);
        } else if (e.getClickCount() == 2) {
            if (col == labelCol) {
                this.selectAllCells();
            } else {
                this.setRowSelectionInterval(0, this.getRowCount() - 1);
                this.setColumnSelectionInterval(col, col);
                this.leadCol = col;
            }
            this.sort(0);
        } else if (col == labelCol && this.dataTableModel.getSortedColumn() == col) {
            if (col != this.prevSortedColumn) {
                int[] rows = this.getSelectedModelRows();
                this.selectModelRows(rows);
                this.prevSortedColumn = col;
            }
        } else if (e.isControlDown()) {
            if (col != labelCol && this.isColumnSelected(col)) {
                this.removeColumnSelectionInterval(col, col);
            } else {
                if (this.haveSelectedRows()) {
                    this.addColumnSelectionInterval(col, col);
                }
                if (this.getSelectedColumns().length == 1) {
                    this.leadCol = col;
                }
            }
        } else if (e.isShiftDown() && this.haveSelectedRows()) {
            if (this.leadCol < this.getColumnCount()) {
                this.setColumnSelectionInterval(col, this.leadCol);
            }
        } else if (col != this.prevSortedColumn) {
            int[] rows = this.getSelectedModelRows();
            this.selectModelRows(rows);
            this.prevSortedColumn = col;
        }
        this.getSelectedData();
        this.addColumnSelectionInterval(labelCol, labelCol);
    }

    protected void createHeaderPopup(int col) {
        String text;
        this.getPopup();
        this.setRowSelectionInterval(0, this.getRowCount() - 1);
        this.popup.removeAll();
        ArrayList<String> cols = this.getSelectedColumnNames();
        if (cols.size() == 1 && this.dataToolTab.isUserEditable()) {
            int index = this.convertColumnIndexToModel(col) - 1;
            final Dataset data = this.dataManager.getDataset(index);
            text = ToolsRes.getString("DataToolTable.Popup.MenuItem.RenameColumn");
            this.renameColumnItem = new JMenuItem(text);
            this.renameColumnItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (data instanceof DataFunction) {
                        DataToolTable.this.showDataBuilder();
                        return;
                    }
                    String prevName = data.getYColumnName();
                    String newName = DataToolTable.this.dataManager.getUniqueYColumnName(DataToolTable.this, data, prevName);
                    if (newName == null) {
                        return;
                    }
                    int n = newName.indexOf("}");
                    if (n == 0) {
                        return;
                    }
                    if (n > -1) {
                        newName = newName.substring(0, n + 1);
                    }
                    DataToolTable.this.renameColumn(prevName, newName);
                    TableEdit edit = new TableEdit(0, newName, null, prevName);
                    DataToolTable.this.dataToolTab.undoSupport.postEdit(edit);
                }
            });
            this.popup.add(this.renameColumnItem);
            this.popup.addSeparator();
        }
        text = ToolsRes.getString("DataToolTable.Popup.MenuItem.CopyColumns");
        this.copyColumnsItem = new JMenuItem(text);
        this.copyColumnsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTable.this.dataToolTab.copyTableDataToClipboard(false);
            }
        });
        this.popup.add(this.copyColumnsItem);
        boolean addCutItem = true;
        for (String name : cols) {
            if (this.dataToolTab.isDeletable(this.getDataset(name))) continue;
            addCutItem = false;
        }
        if (addCutItem) {
            text = ToolsRes.getString("DataToolTable.Popup.MenuItem.CutColumns");
            this.cutColumnsItem = new JMenuItem(text);
            this.cutColumnsItem.setActionCommand(String.valueOf(col));
            this.cutColumnsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataToolTable.this.copyColumnsItem.doClick();
                    DataToolTable.this.deleteSelectedColumns(true);
                }
            });
            this.popup.add(this.cutColumnsItem);
        }
        if (this.dataToolTab != null && this.dataToolTab.dataTool != null && this.dataToolTab.dataTool.hasPastableData() && this.dataToolTab.dataTool.hasPastableColumns(this.dataToolTab)) {
            text = ToolsRes.getString("DataToolTable.Popup.MenuItem.PasteColumns");
            this.pasteColumnsItem = new JMenuItem(text);
            this.pasteColumnsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataToolTable.this.dataToolTab.dataTool.pasteColumnsItem.doClick(0);
                }
            });
            this.popup.add(this.pasteColumnsItem);
        }
        this.popup.addSeparator();
        text = ToolsRes.getString("DataToolTable.Popup.MenuItem.CloneColumns");
        this.cloneColumnsItem = new JMenuItem(text);
        this.cloneColumnsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<String> colNames = DataToolTable.this.getSelectedColumnNames();
                int i = 0;
                while (i < colNames.size()) {
                    Dataset data = DataToolTable.this.getDataset(colNames.get(i));
                    if (data != null) {
                        Dataset clone = DataTool.copyDataset(data, null, false);
                        double[] x = data.getXPoints();
                        double[] y = data.getYPoints();
                        clone.append(x, y);
                        String name = data.getYColumnName();
                        String postfix = "_" + ToolsRes.getString("DataTool.Clone.Subscript");
                        int n = name.indexOf(postfix);
                        if (n > -1) {
                            name = name.substring(0, n);
                        }
                        name = String.valueOf(name) + postfix;
                        name = DataToolTable.this.dataManager.uniquifyColumnName(clone, name);
                        clone.setXYColumnNames(data.getXColumnName(), name);
                        ArrayList<DataColumn> loadedColumns = DataToolTable.this.dataToolTab.loadData(clone, false);
                        if (!loadedColumns.isEmpty()) {
                            for (DataColumn next : loadedColumns) {
                                next.deletable = true;
                            }
                        }
                    }
                    ++i;
                }
            }
        });
        this.popup.add(this.cloneColumnsItem);
        this.popup.addSeparator();
        text = ToolsRes.getString("DataToolTable.Popup.MenuItem.NumberFormat");
        this.numberFormatItem = new JMenuItem(text);
        this.numberFormatItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTable.this.numberFormatAction();
            }
        });
        this.popup.add(this.numberFormatItem);
        FontSizer.setFonts(this.popup, FontSizer.getLevel());
    }

    private void numberFormatAction() {
        int colCount = this.getColumnCount();
        String[] names = new String[colCount - 1];
        int labelCol = this.convertColumnIndexToView(0);
        int index = 0;
        int i = 0;
        while (i < colCount) {
            if (i != labelCol) {
                String name;
                names[index] = name = this.getColumnName(i);
                ++index;
            }
            ++i;
        }
        ArrayList<String> selected = this.getSelectedColumnNames();
        String[] selectedNames = new String[selected.size()];
        int i2 = 0;
        while (i2 < selectedNames.length) {
            selectedNames[i2] = selected.get(i2);
            ++i2;
        }
        DataTable.NumberFormatDialog dialog = this.getFormatDialog(names, selectedNames);
        dialog.setVisible(true);
        this.dataToolTab.refreshPlot();
    }

    protected void dorepaint(int i) {
        switch (i) {
            default: 
        }
        if (!OSPRuntime.isJS) {
            this.repaint();
        }
    }

    protected WorkingDataset getWorkingData(String colName) {
        int labelCol;
        int col;
        Dataset xSource;
        String unshifted;
        if (colName == null) {
            return null;
        }
        WorkingDataset working = this.workingMap.get(colName);
        if (working == null && this.dataToolTab.originShiftEnabled && (unshifted = DataToolTable.unshiftName(colName)) != colName) {
            working = this.workingMap.get(unshifted);
        }
        if (working == null) {
            Dataset ySource = this.getDataset(colName);
            if (ySource == null) {
                return null;
            }
            working = new WorkingDataset(ySource);
            if (ySource.getMarkerShape() == 0) {
                ySource.setMarkerShape(2);
                working.setMarkersVisible(false);
            }
            this.workingMap.put(colName, working);
        }
        if ((xSource = this.getDataset((col = (labelCol = this.convertColumnIndexToView(0)) == 0 ? 1 : 0) < this.getColumnCount() ? this.getColumnName(col) : null)) == null) {
            return null;
        }
        if (!working.isUpToDate(xSource)) {
            working.setXSource(xSource);
        }
        Dataset ySource = working.getYSource();
        working.setMarkerColor(ySource.getFillColor(), ySource.getEdgeColor());
        working.setMarkerSize(ySource.getMarkerSize());
        working.markerType = ySource.getMarkerShape();
        working.setLineColor(ySource.getLineColor());
        working.setConnected(ySource.isConnected());
        return working;
    }

    protected WorkingDataset getWorkingData() {
        if (this.dataManager.getDatasetsRaw().size() < 2) {
            this.workingData = null;
        } else {
            int labelCol = this.convertColumnIndexToView(0);
            int yCol = labelCol < 2 ? 2 : 1;
            String yName = this.getColumnName(yCol);
            this.workingData = this.getWorkingData(yName);
        }
        return this.workingData;
    }

    protected void removeWorkingData(String colName) {
        if (colName == null) {
            return;
        }
        this.workingMap.remove(colName);
        this.setFormatPattern(colName, null);
        this.refreshTable(16640);
    }

    protected void deleteSelectedColumns(boolean postEdit) {
        ArrayList<String> colNames = this.getSelectedColumnNames();
        int[] cols = this.getSelectedColumns();
        int i = colNames.size() - 1;
        while (i > -1) {
            Dataset deleted;
            String name = colNames.get(i);
            Dataset target = this.getDataset(name);
            if (this.dataToolTab.isDeletable(target) && (deleted = this.deleteColumn(name)) != null && postEdit) {
                Integer colInt = cols[i];
                TableEdit edit = new TableEdit(2, name, colInt, deleted);
                this.dataToolTab.undoSupport.postEdit(edit);
            }
            --i;
        }
        this.refreshUndoItems();
    }

    protected void clearWorkingData() {
        Iterator<String> it = this.workingMap.keySet().iterator();
        while (it.hasNext()) {
            String colName = it.next().toString();
            this.setFormatPattern(colName, null);
        }
        this.workingMap.clear();
        this.refreshTable(2);
    }

    protected Dataset getDataset(String colName) {
        String unshifted;
        if (colName == null) {
            return null;
        }
        int index = this.dataManager.getDatasetIndex(colName);
        if (index >= 0 || (unshifted = DataToolTable.unshiftName(colName)) != colName && (index = this.dataManager.getDatasetIndex(unshifted)) >= 0) {
            return this.dataManager.getDataset(index);
        }
        ArrayList<Dataset> datasets = this.dataManager.getDatasetsRaw();
        int i = 0;
        int n = datasets.size();
        while (i < n) {
            Dataset next = datasets.get(i);
            if (next.getYColumnName().equals(colName) || unshifted != colName && next.getYColumnName().equals(unshifted)) {
                return next;
            }
            ++i;
        }
        return null;
    }

    protected HighlightableDataset getSelectedData() {
        double[] yValues;
        double[] xValues;
        if (this.getWorkingData() == null) {
            return null;
        }
        double[] x = this.workingData.getXSource().getYPoints();
        double[] y = this.workingData.getYSource().getYPoints();
        int workingIndex = 0;
        this.workingData.clearHighlights();
        int i = 0;
        while (i < x.length) {
            if (!Double.isNaN(x[i])) {
                this.workingRowToModelRow.put(workingIndex++, i);
            }
            ++i;
        }
        int labelCol = this.convertColumnIndexToView(0);
        int xCol = labelCol == 0 ? 1 : 0;
        int yCol = labelCol < 2 ? 2 : 1;
        int[] cols = this.getSelectedColumns();
        boolean colSelected = false;
        int k = 0;
        while (k < cols.length) {
            colSelected = colSelected || cols[k] == xCol || cols[k] == yCol;
            ++k;
        }
        BitSet bs = (BitSet)this.getSelectedModelRowsBS().clone();
        int nsel = bs.cardinality();
        if (!colSelected || nsel == 0) {
            xValues = x;
            yValues = new double[x.length];
            int i2 = 0;
            while (i2 < yValues.length) {
                yValues[i2] = i2 < y.length ? y[i2] : Double.NaN;
                ++i2;
            }
            bs.clear();
        } else {
            xValues = new double[nsel];
            yValues = new double[nsel];
            BitSet bsNew = new BitSet();
            bsNew.set(0, nsel);
            int i3 = 0;
            int row = bs.nextSetBit(0);
            while (row >= 0) {
                xValues[i3] = row >= x.length ? Double.NaN : x[row];
                yValues[i3] = row >= y.length ? Double.NaN : y[row];
                boolean ignore = Double.isNaN(xValues[i3]);
                if (ignore) {
                    bsNew.clear(i3);
                } else {
                    this.workingData.setHighlighted(row, true);
                    if (Double.isNaN(yValues[i3])) {
                        bsNew.clear(i3);
                    }
                }
                row = bs.nextSetBit(row + 1);
                ++i3;
            }
            bs = bsNew;
        }
        DataTool.copyDataset(this.workingData, this.selectedData, false);
        this.selectedData.clear();
        this.selectedData.setHighlights(bs);
        this.selectedData.append(xValues, yValues);
        return this.selectedData;
    }

    protected ArrayList<String> getSelectedColumnNames() {
        int[] columns = this.getSelectedColumns();
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < columns.length) {
            int index = this.convertColumnIndexToModel(columns[i]) - 1;
            if (index >= 0) {
                String name = this.dataManager.getDataset(index).getYColumnName();
                names.add(name);
            }
            ++i;
        }
        return names;
    }

    protected void setSelectedColumnNames(Collection<String> names) {
        if (this.getColumnCount() < 1) {
            return;
        }
        this.removeColumnSelectionInterval(0, this.getColumnCount() - 1);
        for (String colName : names) {
            int index = this.dataManager.getDatasetIndex(colName);
            if (index == -1) continue;
            int col = this.convertColumnIndexToView(index + 1);
            this.addColumnSelectionInterval(col, col);
        }
    }

    protected void insertColumn(Dataset data, int col) {
        BitSet rows = this.getSelectedModelRowsBS();
        ArrayList<String> cols = this.getSelectedColumnNames();
        this.clearSelection();
        data.setXColumnVisible(false);
        int index = this.dataManager.getDatasetsRaw().size();
        if (index == 0) {
            this.dataToolTab.originatorID = data.getID();
        }
        if (data instanceof DataFunction) {
            FunctionTool tool = this.dataToolTab.getDataBuilder();
            FunctionPanel panel = tool.getPanel(this.dataToolTab.getName());
            String presentation = panel.undoManager.getPresentationName();
            if (panel.undoManager.canUndo() && presentation.equals("Deletion")) {
                panel.undoManager.undo();
            }
        } else {
            this.dataManager.addDataset(data);
            this.getWorkingData(data.getYColumnName());
        }
        this.updateColumnModel();
        if (rows.cardinality() == 0) {
            this.setRowSelectionInterval(0, this.getRowCount() - 1);
        } else {
            this.setSelectedModelRowsBS(rows);
        }
        cols.add(data.getYColumnName());
        this.setSelectedColumnNames(cols);
        this.refreshTable(16640);
        this.refreshDataFunctions();
        this.dataToolTab.statsTable.refreshStatistics();
        this.dataToolTab.propsTable.refreshTable();
        this.dataToolTab.refreshGUI();
        this.dataToolTab.refreshPlot();
        this.dataToolTab.tabChanged(true);
        this.refreshUndoItems();
    }

    protected Dataset deleteColumn(String colName) {
        boolean sortColDeleted;
        int index = this.dataManager.getDatasetIndex(colName);
        int deletedCol = this.convertColumnIndexToView(index + 1);
        Dataset data = this.dataManager.getDataset(index);
        boolean bl = sortColDeleted = this.dataTableModel.getSortedColumn() == index + 1;
        if (sortColDeleted) {
            this.sort(0);
        }
        BitSet rows = this.getSelectedModelRowsBS();
        ArrayList<String> cols = this.getSelectedColumnNames();
        this.clearSelection();
        TableModel model = this.getModel();
        int[] modelColumns = new int[model.getColumnCount() - 1];
        int viewCol = -1;
        int j = 0;
        while (j < model.getColumnCount()) {
            if (j != deletedCol) {
                ++viewCol;
                int modelCol = this.convertColumnIndexToModel(j);
                if (modelCol > index + 1) {
                    // empty if block
                }
                modelColumns[viewCol] = --modelCol;
            }
            ++j;
        }
        if (data instanceof DataFunction) {
            FunctionTool tool = this.dataToolTab.getDataBuilder();
            FunctionPanel panel = tool.getPanel(this.dataToolTab.getName());
            panel.functionEditor.removeObject((DataFunction)data, true);
        } else {
            this.dataManager.removeDataset(index);
            this.workingMap.remove(colName);
        }
        if (this.dataManager.getDatasetsRaw().isEmpty()) {
            this.dataToolTab.originatorID = 0;
            this.tableChanged(new TableModelEvent(this.getModel(), -1));
            this.dataToolTab.refreshGUI();
        } else {
            this.updateColumnModel();
            if (cols.size() != 1 || !cols.contains(colName)) {
                this.setSelectedModelRowsBS(rows);
                this.setSelectedColumnNames(cols);
            }
        }
        this.refreshTable(16640);
        this.refreshDataFunctions();
        this.dataToolTab.refreshPlot();
        this.dataToolTab.propsTable.refreshTable();
        this.dataToolTab.refreshGUI();
        this.dataToolTab.tabChanged(true);
        this.refreshUndoItems();
        this.dataToolTab.varPopup = null;
        return data;
    }

    protected HashMap<String, double[]> insertCells(int[] rows, HashMap<String, double[]> values) {
        int count = this.getRowCount();
        int[] fillRows = new int[rows.length];
        int i = 0;
        while (i < rows.length) {
            fillRows[i] = count + i;
            ++i;
        }
        int[] cols = new int[values.keySet().size()];
        int k = 0;
        HashMap<String, double[]> inserted = new HashMap<String, double[]>();
        ArrayList<Dataset> datasets = this.dataManager.getDatasetsRaw();
        int i2 = 0;
        int n = datasets.size();
        while (i2 < n) {
            Dataset next = datasets.get(i2);
            String colName = next.getYColumnName();
            if (values.keySet().contains(colName)) {
                double[] vals = values.get(colName);
                vals = this.insertPoints(next, rows, vals);
                inserted.put(colName, vals);
                int index = this.dataManager.getDatasetIndex(colName);
                cols[k++] = this.convertColumnIndexToView(index + 1);
            } else {
                this.insertPoints(next, fillRows, null);
            }
            ++i2;
        }
        this.refreshDataFunctions();
        this.refreshTable(16896);
        this.selectModelRows(rows);
        this.setSelectedColumnNames(values.keySet());
        this.dataToolTab.refreshPlot();
        this.refreshUndoItems();
        return inserted;
    }

    protected HashMap<String, double[]> deleteCells(int[] rows, HashMap<String, double[]> values) {
        int startFillRow = this.getRowCount() - rows.length;
        HashMap<String, double[]> deleted = new HashMap<String, double[]>();
        for (String colName : values.keySet()) {
            int index = this.dataManager.getDatasetIndex(colName);
            Dataset dataset = this.dataManager.getDataset(index);
            double[] removed = this.deletePoints(dataset, rows);
            deleted.put(colName, removed);
            int[] fillRows = new int[rows.length];
            int i = 0;
            while (i < rows.length) {
                fillRows[i] = startFillRow + i;
                ++i;
            }
            this.insertPoints(dataset, fillRows, null);
        }
        this.trimEmptyRows(startFillRow - 1);
        this.refreshDataFunctions();
        this.refreshTable(16896);
        this.setSelectedColumnNames(values.keySet());
        this.selectModelRows(rows);
        this.dataToolTab.refreshPlot();
        this.refreshUndoItems();
        return deleted;
    }

    protected HashMap<String, double[]> replaceCells(int[] rows, HashMap<String, double[]> values) {
        int[] cols = new int[values.keySet().size()];
        HashMap<String, double[]> replaced = new HashMap<String, double[]>();
        Iterator<String> it = values.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String colName = it.next();
            double[] vals = values.get(colName);
            int index = this.dataManager.getDatasetIndex(colName);
            Dataset data = this.dataManager.getDataset(index);
            double[] pts = this.replacePoints(data, rows, vals);
            replaced.put(colName, pts);
            cols[i++] = this.convertColumnIndexToView(index + 1);
        }
        this.refreshDataFunctions();
        this.refreshTable(32768);
        this.selectModelRows(rows);
        this.setSelectedColumnNames(values.keySet());
        this.refreshUndoItems();
        this.dataToolTab.refreshPlot();
        return replaced;
    }

    protected HashMap<String, double[]> insertRows(int[] rows, HashMap<String, double[]> values) {
        if (values == null) {
            values = new HashMap();
        }
        ArrayList<Dataset> datasets = this.dataManager.getDatasetsRaw();
        int i = 0;
        int n = datasets.size();
        while (i < n) {
            Dataset next = datasets.get(i);
            String name = next.getYColumnName();
            if (!values.keySet().contains(name)) {
                values.put(name, null);
            }
            ++i;
        }
        values = this.insertCells(rows, values);
        int endRow = this.getModelRow(this.getRowCount() - 1);
        int i2 = 0;
        while (i2 < rows.length) {
            if (endRow == rows[i2]) {
                this.computeVisibleRect(this.rect);
                this.rect.y = this.getSize().height - this.rect.height + this.getRowHeight();
                this.scrollRectToVisible(this.rect);
                break;
            }
            ++i2;
        }
        return values;
    }

    protected HashMap<String, double[]> deleteRows(int[] rows) {
        HashMap<String, double[]> removed = new HashMap<String, double[]>();
        ArrayList<Dataset> dataSets = this.dataManager.getDatasetsRaw();
        int i = dataSets.size();
        while (--i >= 0) {
            Dataset ds = dataSets.get(i);
            removed.put(ds.getYColumnName(), this.deletePoints(ds, rows));
        }
        this.refreshTable(8960);
        this.refreshDataFunctions();
        this.clearSelection();
        this.setSelectedColumnNames(removed.keySet());
        this.selectModelRows(rows);
        this.refreshUndoItems();
        this.dataToolTab.refreshPlot();
        return removed;
    }

    protected boolean isEmptyRow(int row) {
        boolean empty = true;
        ArrayList<Dataset> datasets = this.dataManager.getDatasetsRaw();
        int i = 0;
        int n = datasets.size();
        while (i < n) {
            Dataset data = datasets.get(i);
            if (!(data instanceof DataFunction)) {
                double[] y = data.getYPoints();
                if (row >= y.length) {
                    return false;
                }
                empty = empty && Double.isNaN(y[row]);
            }
            ++i;
        }
        return empty;
    }

    protected boolean isEmptyCells(int row, ArrayList<String> columnNames) {
        ArrayList<Dataset> datasets = this.dataManager.getDatasetsRaw();
        int i = 0;
        int n = datasets.size();
        while (i < n) {
            Dataset data = datasets.get(i);
            if (!(data instanceof DataFunction) && columnNames.contains(data.getYColumnName())) {
                if (row >= data.getIndex()) {
                    return false;
                }
                if (Double.isNaN(data.getYShifted(row))) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    protected int getXColumn() {
        if (this.getColumnCount() < 2) {
            return -1;
        }
        int labelCol = this.convertColumnIndexToView(0);
        return labelCol == 0 ? 1 : 0;
    }

    protected int getYColumn() {
        if (this.getColumnCount() < 3) {
            return -1;
        }
        int labelCol = this.convertColumnIndexToView(0);
        return labelCol < 2 ? 2 : 1;
    }

    protected double[] replacePoints(Dataset dataset, int[] rows, double[] vals) {
        double[] replaced = new double[rows.length];
        DataColumn column = null;
        boolean shifted = false;
        if (dataset instanceof DataColumn) {
            column = (DataColumn)dataset;
            shifted = column.isShifted();
            column.setShifted(false);
        }
        int count = dataset.getIndex();
        int i = 0;
        while (i < rows.length) {
            count = Math.max(count, rows[i] + 1);
            ++i;
        }
        int len = dataset.getIndex();
        while (count > len) {
            int[] row = new int[]{len};
            this.insertRows(row, null);
            len = dataset.getIndex();
        }
        double[] x = dataset.getXPoints();
        double[] y = dataset.getYPoints();
        int i2 = 0;
        while (i2 < rows.length) {
            replaced[i2] = y[rows[i2]];
            y[rows[i2]] = vals == null ? Double.NaN : vals[i2];
            ++i2;
        }
        dataset.clear();
        dataset.append(x, y);
        if (column != null) {
            column.setShifted(shifted);
        }
        this.dataToolTab.tabChanged(true);
        return replaced;
    }

    protected double[] insertPoints(Dataset dataset, int[] rows, double[] vals) {
        if (vals == null) {
            vals = new double[rows.length];
            int i = 0;
            while (i < vals.length) {
                vals[i] = Double.NaN;
                ++i;
            }
        }
        if (dataset instanceof DataFunction) {
            return vals;
        }
        double[] y = dataset.getYPoints();
        int i = 0;
        while (i < rows.length) {
            int n = y.length;
            double[] newy = new double[n + 1];
            System.arraycopy(y, 0, newy, 0, rows[i]);
            System.arraycopy(y, rows[i], newy, rows[i] + 1, n - rows[i]);
            newy[rows[i]] = vals[i];
            y = newy;
            ++i;
        }
        double[] x = DataTool.getRowArray(y.length);
        dataset.clear();
        dataset.append(x, y);
        this.dataToolTab.tabChanged(true);
        return vals;
    }

    protected double[] deletePoints(Dataset dataset, int[] rows) {
        double[] removed = new double[rows.length];
        if (dataset instanceof DataFunction) {
            return removed;
        }
        double[] y = dataset.getYPoints();
        int i = rows.length - 1;
        while (i > -1) {
            int n = y.length;
            double[] newy = new double[n - 1];
            System.arraycopy(y, rows[i], removed, i, 1);
            if (rows[i] > 0) {
                System.arraycopy(y, 0, newy, 0, rows[i]);
            }
            if (rows[i] < n - 1) {
                System.arraycopy(y, rows[i] + 1, newy, rows[i], n - rows[i] - 1);
            }
            y = newy;
            --i;
        }
        double[] x = DataTool.getRowArray(y.length);
        dataset.clear();
        dataset.append(x, y);
        this.dataToolTab.tabChanged(true);
        return removed;
    }

    protected boolean trimEmptyRows(int minSize) {
        boolean trimmed = false;
        this.clearSelection();
        int endRow = this.getRowCount() - 1;
        boolean empty = true;
        int[] rows = new int[1];
        while (empty && endRow > minSize) {
            empty = this.isEmptyRow(endRow);
            if (!empty) continue;
            rows[0] = endRow--;
            this.deleteRows(rows);
            trimmed = true;
        }
        if (this.getSelectedRows().length == 0) {
            this.removeColumnSelectionInterval(0, this.getColumnCount() - 1);
        }
        return trimmed;
    }

    protected void clearSelectionIfEmptyEndRow() {
        int n = this.getRowCount();
        if (n < 2) {
            return;
        }
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows.length == 1 && selectedRows[0] == n - 1 && this.isEmptyRow(n - 1)) {
            this.clearSelection();
        }
    }

    protected void showDataBuilder() {
        FunctionTool tool = this.dataToolTab.getDataBuilder();
        tool.setSelectedPanel(this.dataToolTab.getName());
        tool.setVisible(true);
    }

    protected void renameColumn(String oldName, String newName) {
        int index = this.dataManager.getDatasetIndex(oldName);
        Dataset data = this.dataManager.getDataset(index);
        data.setXYColumnNames(data.getXColumnName(), newName);
        this.refreshDataFunctions();
        this.dataToolTab.columnNameChanged(oldName, newName);
        this.refreshTable(0x2000000);
        this.refreshUndoItems();
    }

    protected void refreshUndoItems() {
        if (this.dataToolTab != null) {
            this.dataToolTab.refreshUndoItems();
        }
    }

    public void refreshDataFunctions() {
        ArrayList<Dataset> datasets = this.dataManager.getDatasetsRaw();
        int i = 0;
        int n = datasets.size();
        while (i < n) {
            Dataset next = datasets.get(i);
            if (next instanceof DataFunction) {
                ((DataFunction)next).refreshFunctionData();
            }
            ++i;
        }
    }

    public void selectAllCells() {
        this.selectAll();
        if (this.getSelectedRows().length == 0) {
            this.selectAll();
        }
        this.requestFocusInWindow();
    }

    @Override
    public void clearSelection() {
        if (this.clearing) {
            return;
        }
        this.clearing = true;
        if (this.workingData != null) {
            this.workingData.clearHighlights();
        }
        if (this.selectedData != null) {
            this.selectedData.clearHighlights();
        }
        super.clearSelection();
        this.leadCol = 0;
        this.repaint();
        this.clearing = false;
    }

    @Override
    public void refreshTable(int mode) {
        boolean noView;
        if (mode == 16896) {
            super.refreshTable(mode);
            this.updateColumnModel();
            return;
        }
        boolean bl = noView = this.convertColumnIndexToView(0) == -1;
        if (noView) {
            this.updateColumnModel();
            return;
        }
        int[] rows = this.getSelectedModelRows();
        ArrayList<String> cols = this.getSelectedColumnNames();
        this.updateColumnModel();
        boolean changed = this.dataToolTab.tabChanged;
        this.dataToolTab.tabChanged(changed);
        this.sort(this.dataTableModel.getSortedColumn());
        if (!cols.isEmpty()) {
            this.setSelectedColumnNames(cols);
        }
        if (rows.length > 0) {
            this.selectModelRows(rows);
        }
        super.refreshTable(mode);
    }

    @Override
    public DataTable.NumberFormatDialog getFormatDialog(String[] names, String[] selected) {
        int i = 0;
        while (i < names.length) {
            names[i] = DataToolTable.unshiftName(names[i]);
            ++i;
        }
        return super.getFormatDialog(names, selected);
    }

    public String[] getHiddenMarkers() {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < this.getColumnCount()) {
            String name = this.getColumnName(i);
            WorkingDataset next = this.getWorkingData(name);
            if (next != null && !next.isMarkersVisible()) {
                list.add(name);
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public void hideMarkers(String[] hiddenColumns) {
        if (hiddenColumns == null) {
            return;
        }
        int i = 0;
        while (i < hiddenColumns.length) {
            String name = hiddenColumns[i];
            WorkingDataset next = this.getWorkingData(name);
            if (next != null) {
                next.setMarkersVisible(false);
            }
            ++i;
        }
    }

    public void setWorkingColumns(String xColName, String yColName) {
        int labelCol = this.convertColumnIndexToView(0);
        this.getColumnModel().moveColumn(labelCol, 0);
        TableModel model = this.getModel();
        int i = 1;
        while (i < model.getColumnCount()) {
            if (xColName.equals(this.getColumnName(i))) {
                this.getColumnModel().moveColumn(i, 1);
                break;
            }
            ++i;
        }
        i = 2;
        while (i < model.getColumnCount()) {
            if (yColName.equals(this.getColumnName(i))) {
                this.getColumnModel().moveColumn(i, 2);
                break;
            }
            ++i;
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.labelRenderer != null) {
            Font labelFont = this.labelRenderer.getFont();
            labelFont = labelFont.deriveFont(font.getSize2D());
            this.labelRenderer.setFont(labelFont);
            this.headerRenderer.headerFont = labelFont;
            this.rowNumberRenderer.setFont(labelFont);
        }
        this.setRowHeight(font.getSize() + 4);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int col) {
        TableCellRenderer renderer = super.getCellRenderer(row, col);
        if (renderer == this.rowNumberRenderer) {
            return this.labelRenderer;
        }
        this.dataRenderer.renderer = renderer;
        return this.dataRenderer;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        this.editor.setColumn(col);
        return this.editor;
    }

    public boolean isFitFittable(KnownFunction fit, boolean allowNone) {
        int n = this.selectedData.getHighlightCount();
        return n == 0 ? allowNone : n >= fit.getParameterCount();
    }

    public void moveColumn(String var, int col) {
        int i = 0;
        int n = this.dataTableModel.getColumnCount();
        while (i < n) {
            if (var.equals(this.getColumnName(i))) {
                if (i != col) {
                    this.getColumnModel().moveColumn(i, col);
                }
                return;
            }
            ++i;
        }
    }

    class DataCellRenderer
    implements TableCellRenderer {
        TableCellRenderer renderer;
        boolean showFocus = false;
        Color unlockedBG = Color.WHITE;
        Color lockedBG = new Color(255, 220, 0, 30);
        private final float[] hsb = new float[3];

        DataCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component c;
            int modelCol = DataToolTable.this.convertColumnIndexToModel(col);
            if ((hasFocus || isSelected) && modelCol > 0) {
                DataToolTable.this.focusRow = row;
                DataToolTable.this.focusCol = col;
            }
            if (DataToolTable.this.selectedBG == null) {
                c = this.renderer.getTableCellRendererComponent(table, value, true, false, row, col);
                DataToolTable.this.selectedBG = c.getBackground();
                DataToolTable.this.selectedFG = c.getForeground();
                DataToolTable.this.selectedHeaderFG = DataToolTable.this.selectedFG.darker();
                Color.RGBtoHSB(DataToolTable.this.selectedBG.getRed(), DataToolTable.this.selectedBG.getGreen(), DataToolTable.this.selectedBG.getBlue(), this.hsb);
                int darker = Color.HSBtoRGB(this.hsb[0], this.hsb[1], this.hsb[2] * 0.85f);
                DataToolTable.this.selectedHeaderBG = new Color(darker);
            }
            if (!this.showFocus) {
                hasFocus = col == DataToolTable.this.mouseCol && row == DataToolTable.this.mouseRow;
            }
            c = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            Dataset data = DataToolTable.this.dataManager.getDataset(modelCol - 1);
            if (!isSelected) {
                c.setBackground(DataToolTable.this.dataToolTab.isDeletable(data) ? this.unlockedBG : this.lockedBG);
            }
            return c;
        }
    }

    class DataEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JTextField field = new JTextField();
        int column;
        boolean isFunction;

        DataEditor() {
            this.field.setHorizontalAlignment(4);
            this.field.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 0));
            this.field.setSelectionColor(new Color(204, 255, 255));
            this.field.setCaretColor(Color.red);
            this.field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() != 10 && DataEditor.this.field.isEnabled()) {
                        DataEditor.this.field.setBackground(Color.yellow);
                    }
                }
            });
            this.field.addActionListener(e -> SwingUtilities.invokeLater(() -> this.editAction(e, true)));
            this.field.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (DataEditor.this.field.getBackground() != Color.white) {
                        DataEditor.this.stopCellEditing();
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                    DataEditor.this.field.selectAll();
                }
            });
            this.field.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (OSPRuntime.isPopupTrigger(e)) {
                        DataEditor.this.stopCellEditing();
                        ((DataEditor)DataEditor.this).DataToolTable.this.tableMouseListener.mousePressed(e);
                    }
                }
            });
        }

        protected void editAction(EventObject e, boolean isEnd) {
            int row;
            int n = row = isEnd ? DataToolTable.this.getModelRow(DataToolTable.this.focusRow) + 1 : DataToolTable.this.focusRow;
            if (isEnd) {
                this.stopCellEditing();
                if (row == DataToolTable.this.getRowCount()) {
                    DataToolTable.this.insertRows(new int[]{row}, null);
                }
                row = DataToolTable.this.getViewRow(row);
                DataToolTable.this.changeSelection(row, this.column, false, false);
            }
            int r = row;
            SwingUtilities.invokeLater(() -> {
                DataToolTable.this.editCellAt(r, this.column, e);
                this.field.requestFocus();
            });
        }

        void setColumn(int col) {
            this.column = col;
            int modelCol = DataToolTable.this.convertColumnIndexToModel(col);
            Dataset data = DataToolTable.this.dataManager.getDataset(modelCol - 1);
            this.isFunction = data instanceof DataFunction;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            if (this.isFunction) {
                DataToolTable.this.showDataBuilder();
                return null;
            }
            DataToolTable.this.focusRow = row;
            DataToolTable.this.focusCol = col;
            if (value instanceof Double && Double.isNaN((Double)value)) {
                value = null;
            }
            this.field.setText(value == null ? "" : String.valueOf(value));
            this.field.setFont(DataToolTable.this.getFont());
            return this.field;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent && ((MouseEvent)e).getClickCount() == 2) {
                return true;
            }
            if (e instanceof ActionEvent) {
                return true;
            }
            return e instanceof KeyEvent;
        }

        @Override
        public Object getCellEditorValue() {
            DataToolTable.this.requestFocusInWindow();
            this.field.setBackground(Color.white);
            return this.field.getText();
        }
    }

    protected class DataToolTableModel
    extends DataTable.OSPDataTableModel {
        DataToolTab tab;

        DataToolTableModel() {
        }

        @Override
        public synchronized int getColumnCount() {
            return this.columnCount >= 0 ? this.columnCount : (this.columnCount = 1 + DataToolTable.this.dataManager.getColumnCount());
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return col == 0 ? Integer.class : Double.class;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return column >= this.getColumnCount() ? null : (column == 0 ? Integer.valueOf(this.getModelRow(row)) : super.getValueAt(row, column));
        }

        @Override
        public String getColumnName(int col) {
            if (col >= this.getColumnCount()) {
                return "unknown";
            }
            if (col == 0) {
                return rowName;
            }
            String name = this.tab.dataManager.getColumnName(col - 1);
            if (this.tab.originShiftEnabled && this.tab.plot != null) {
                name = String.valueOf(name) + '`';
            }
            return name;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (value == null) {
                return;
            }
            Dataset data = DataToolTable.this.dataManager.getDataset(col - 1);
            double[] y = data.getYPoints();
            double val = Double.NaN;
            if (value != "") {
                try {
                    val = Double.parseDouble(value.toString());
                    if (y[row] == val) {
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (Double.isNaN(val) && Double.isNaN(y[row])) {
                return;
            }
            String name = data.getYColumnName();
            int[] rows = new int[]{row};
            HashMap<String, double[]> map = new HashMap<String, double[]>();
            map.put(name, new double[]{val});
            HashMap<String, double[]> old = DataToolTable.this.replaceCells(rows, map);
            TableEdit edit = new TableEdit(5, name, rows, new HashMap[]{old, map});
            this.tab.undoSupport.postEdit(edit);
        }

        @Override
        public boolean isElementEditable(int row, int col) {
            return col > 0 && this.tab.isUserEditable();
        }
    }

    class HeaderRenderer
    implements TableCellRenderer {
        TableCellRenderer renderer;
        Font headerFont;
        DrawingPanel panel = new DrawingPanel();
        DrawableTextLine textLine = new DrawableTextLine("", 0.0, -6.0);

        public HeaderRenderer(TableCellRenderer renderer) {
            this.renderer = renderer;
            this.textLine.setJustification(0);
            this.panel.addDrawable(this.textLine);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Color bgColor;
            int yCol;
            int labelCol;
            String realname;
            String name = realname = value == null ? "" : value.toString();
            if (OSPRuntime.isMac()) {
                name = TeXParser.removeSubscripting(name);
            }
            Component c = this.renderer.getTableCellRendererComponent(table, name, isSelected, hasFocus, row, col);
            if (this.headerFont == null) {
                this.headerFont = c.getFont();
            }
            int xCol = (labelCol = DataToolTable.this.convertColumnIndexToView(0)) == 0 ? 1 : 0;
            int n = yCol = labelCol < 2 ? 2 : 1;
            if (DataToolTable.this.unselectedBG == null) {
                DataToolTable.this.unselectedBG = c.getBackground();
            }
            if (DataToolTable.this.unselectedBG == null) {
                DataToolTable.this.unselectedBG = UIManager.getColor("Panel.background");
            }
            DataToolTable.this.rowBG = DataToolTable.this.dataToolTab.plot.getBackground();
            Color color = col == xCol ? xAxisColor : (bgColor = col == yCol ? yAxisColor : DataToolTable.this.rowBG);
            if (!(c instanceof JComponent)) {
                return c;
            }
            JComponent comp = (JComponent)c;
            Dimension dim = comp.getPreferredSize();
            ++dim.height;
            dim.height = Math.max(DataToolTable.this.getRowHeight() + 2, dim.height);
            this.panel.setPreferredSize(dim);
            Border border = comp.getBorder();
            if (border instanceof EmptyBorder) {
                border = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
            }
            this.panel.setBorder(border);
            Dataset data = DataToolTable.this.getDataset(realname);
            Font font = !DataToolTable.this.dataToolTab.isDeletable(data) ? (DataToolTable.this.dataTableModel.getSortedColumn() != DataToolTable.this.convertColumnIndexToModel(col) ? this.headerFont.deriveFont(2) : this.headerFont.deriveFont(3)) : (DataToolTable.this.dataTableModel.getSortedColumn() != DataToolTable.this.convertColumnIndexToModel(col) ? this.headerFont.deriveFont(0) : this.headerFont.deriveFont(1));
            int[] cols = DataToolTable.this.getSelectedColumns();
            boolean selected = false;
            int i = 0;
            while (i < cols.length) {
                if (cols[i] == col) {
                    selected = true;
                    break;
                }
                ++i;
            }
            Color color2 = bgColor = (selected &= DataToolTable.this.convertColumnIndexToModel(col) > 0) ? DataToolTable.this.selectedHeaderBG : bgColor;
            if (OSPRuntime.isMac()) {
                comp.setFont(font);
                comp.setBackground(bgColor);
                comp.setForeground(selected ? DataToolTable.this.selectedHeaderFG : comp.getForeground());
                if (comp instanceof JLabel) {
                    ((JLabel)comp).setHorizontalAlignment(0);
                }
                return comp;
            }
            this.textLine.setText(name);
            this.textLine.setFont(font);
            this.textLine.setColor(selected ? DataToolTable.this.selectedHeaderFG : comp.getForeground());
            this.textLine.setBackground(bgColor);
            this.panel.setBackground(bgColor);
            return this.panel;
        }
    }

    class LabelRenderer
    extends JLabel
    implements TableCellRenderer {
        public LabelRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setText(value == null ? null : value.toString());
            this.setEnabled(true);
            boolean selected = false;
            if (table == DataToolTable.this) {
                this.setEnabled(row < DataToolTable.this.getRowCount() - 1 || !DataToolTable.this.isEmptyRow(row));
                int[] rows = DataToolTable.this.getSelectedRows();
                int i = 0;
                while (i < rows.length) {
                    if (rows[i] == row) {
                        selected = true;
                        break;
                    }
                    ++i;
                }
            }
            this.setForeground(selected ? DataToolTable.this.selectedHeaderFG : Color.black);
            this.setBackground(selected ? DataToolTable.this.selectedHeaderBG : DataToolTable.this.unselectedBG);
            return this;
        }
    }

    protected class TableEdit
    extends AbstractUndoableEdit {
        Object target;
        Object value;
        int editType;
        String columnName;
        HashMap<String, double[]> map;

        public TableEdit(int type, String colName, Object target, Object value) {
            this.editType = type;
            this.columnName = colName;
            this.target = target;
            this.value = value;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            switch (this.editType) {
                case 8: {
                    try {
                        DataToolTable.this.dataToolTab.setDelimitedData(this.target.toString(), null);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 0: {
                    DataToolTable.this.renameColumn(this.columnName, this.value.toString());
                    break;
                }
                case 1: {
                    DataToolTable.this.deleteColumn(this.columnName);
                    break;
                }
                case 2: {
                    Dataset data = (Dataset)this.value;
                    int col = (Integer)this.target;
                    DataToolTable.this.insertColumn(data, col);
                    break;
                }
                case 3: {
                    int[] rows = (int[])this.target;
                    HashMap values = (HashMap)this.value;
                    DataToolTable.this.deleteCells(rows, values);
                    break;
                }
                case 4: {
                    int[] rows = (int[])this.target;
                    HashMap values = (HashMap)this.value;
                    DataToolTable.this.insertCells(rows, values);
                    break;
                }
                case 6: {
                    int[] rows = (int[])this.target;
                    DataToolTable.this.deleteRows(rows);
                    break;
                }
                case 7: {
                    int[] rows = (int[])this.target;
                    HashMap values = (HashMap)this.value;
                    DataToolTable.this.insertRows(rows, values);
                    break;
                }
                case 5: {
                    int[] rows = (int[])this.target;
                    HashMap[] values = (HashMap[])this.value;
                    DataToolTable.this.replaceCells(rows, values[0]);
                }
            }
            if (DataToolTable.this.trimEmptyRows(0)) {
                DataToolTable.this.refreshTable(16896);
            }
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            switch (this.editType) {
                case 8: {
                    try {
                        DataToolTable.this.dataToolTab.setDelimitedData(this.value.toString(), null);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 0: {
                    DataToolTable.this.renameColumn(this.value.toString(), this.columnName);
                    break;
                }
                case 1: {
                    Dataset data = (Dataset)this.value;
                    int col = (Integer)this.target;
                    DataToolTable.this.insertColumn(data, col);
                    break;
                }
                case 2: {
                    DataToolTable.this.deleteColumn(this.columnName);
                    break;
                }
                case 3: {
                    int[] rows = (int[])this.target;
                    HashMap values = (HashMap)this.value;
                    DataToolTable.this.insertCells(rows, values);
                    break;
                }
                case 4: {
                    int[] rows = (int[])this.target;
                    HashMap values = (HashMap)this.value;
                    DataToolTable.this.deleteCells(rows, values);
                    break;
                }
                case 6: {
                    int[] rows = (int[])this.target;
                    HashMap values = (HashMap)this.value;
                    DataToolTable.this.insertRows(rows, values);
                    break;
                }
                case 7: {
                    int[] rows = (int[])this.target;
                    DataToolTable.this.deleteRows(rows);
                    break;
                }
                case 5: {
                    int[] rows = (int[])this.target;
                    HashMap[] values = (HashMap[])this.value;
                    DataToolTable.this.replaceCells(rows, values[1]);
                }
            }
            if (DataToolTable.this.trimEmptyRows(0)) {
                DataToolTable.this.refreshTable(16896);
            }
        }

        @Override
        public String getPresentationName() {
            return "Edit";
        }
    }

    class WorkingDataset
    extends HighlightableDataset {
        private final Dataset yData;
        private Dataset xData;
        boolean markersVisible;
        int markerType;

        public WorkingDataset(Dataset yDataset) {
            this.yData = yDataset;
            this.setColor(this.yData.getFillColor(), this.yData.getLineColor());
            this.markerType = this.yData.getMarkerShape();
            this.setMarkerShape(this.markerType);
            boolean bl = this.markersVisible = this.markerType != 0;
            if (this.markerType == 0) {
                this.markerType = 1;
            }
            this.setMarkerSize(this.yData.getMarkerSize());
            this.setConnected(this.yData.isConnected());
        }

        public boolean isUpToDate(Dataset xSource) {
            return this.xData != null && xSource.update == this.xData.update;
        }

        protected boolean isWorkingYColumn() {
            return this.getYColumnName().equals(DataToolTable.this.dataToolTab.plot.yVar);
        }

        @Override
        public void draw(DrawingPanel drawingPanel, Graphics g) {
            boolean workingY = this.isWorkingYColumn();
            if (workingY) {
                this.drawSurrounds(drawingPanel, (Graphics2D)g);
            }
            boolean vis = this.markersVisible;
            if (workingY && !vis) {
                this.setMarkersVisible(true);
            }
            super.draw(drawingPanel, g);
            if (workingY && !vis) {
                this.setMarkersVisible(false);
            }
        }

        protected void drawSurrounds(DrawingPanel drawingPanel, Graphics2D g2) {
            Color c = g2.getColor();
            Stroke s = g2.getStroke();
            g2.setColor(new Color(51, 255, 51, 153));
            g2.setStroke(new BasicStroke(2.0f));
            RectangularShape shape = null;
            int radius = this.getMarkerSize() + 2;
            int marker = this.getMarkerShape();
            if (marker == 0 || marker == 6) {
                radius = 3;
            }
            int size = radius * 2 + 1;
            double[] xpoints = this.getXPointsRaw();
            double[] ypoints = this.getYPointsRaw();
            int i = 0;
            while (i < this.index) {
                double yp = ypoints[i];
                if (!Double.isNaN(yp)) {
                    double xp = xpoints[i];
                    if (!(drawingPanel.isLogScaleX() && xp <= 0.0 || drawingPanel.isLogScaleY() && yp <= 0.0)) {
                        xp = drawingPanel.xToPix(xp);
                        yp = drawingPanel.yToPix(yp);
                        shape = marker == 2 || marker == 8 || marker == 7 ? new Rectangle2D.Double(xp - (double)radius, yp - (double)radius, size, size) : new Ellipse2D.Double(xp - (double)radius, yp - (double)radius, size, size);
                        g2.draw(shape);
                    }
                }
                ++i;
            }
            g2.setColor(c);
            g2.setStroke(s);
        }

        public boolean isMarkersVisible() {
            return this.markersVisible || this.isWorkingYColumn();
        }

        public void setMarkersVisible(boolean visible) {
            if (!visible && this.markersVisible) {
                this.markerType = this.getMarkerShape();
                this.setMarkerShape(0);
            } else if (visible) {
                this.setMarkerShape(this.markerType);
            }
            this.markersVisible = visible;
        }

        public void setColor(Color edgeColor, Color lineColor) {
            Color fill = new Color(edgeColor.getRed(), edgeColor.getGreen(), edgeColor.getBlue(), 100);
            this.setMarkerColor(fill, edgeColor);
            this.setLineColor(lineColor);
            this.yData.setMarkerColor(fill, edgeColor);
            this.yData.setLineColor(lineColor);
        }

        @Override
        public void setConnected(boolean connected) {
            super.setConnected(connected);
            this.yData.setConnected(connected);
        }

        @Override
        public void setMarkerSize(int size) {
            super.setMarkerSize(size);
            this.yData.setMarkerSize(size);
        }

        @Override
        public void setMarkerShape(int shape) {
            super.setMarkerShape(shape);
            if (shape != 0) {
                this.yData.setMarkerShape(shape);
                this.markerType = shape;
            }
        }

        Dataset getYSource() {
            return this.yData;
        }

        Dataset getXSource() {
            return this.xData;
        }

        void setXSource(Dataset xDataset) {
            this.xData = xDataset;
            this.clear();
            double[] x = this.xData.isShifted() ? this.xData.getYPoints() : this.xData.getYPointsRaw();
            double[] y = this.yData.isShifted() ? this.yData.getYPoints() : this.yData.getYPointsRaw();
            this.append(x, y, Math.min(this.xData.getIndex(), this.yData.getIndex()));
            this.setXYColumnNames(this.xData.getYColumnName(), this.yData.getYColumnName());
        }
    }
}

