/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractCellEditor;
import javax.swing.AbstractSpinnerModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.opensourcephysics.display.CellBorder;
import org.opensourcephysics.display.ColorIcon;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.UncertainFunctionDrawer;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.HessianMinimize;
import org.opensourcephysics.numerics.LUPDecomposition;
import org.opensourcephysics.numerics.LevenbergMarquardt;
import org.opensourcephysics.numerics.MultiVarFunction;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FitBuilder;
import org.opensourcephysics.tools.FitFunctionPanel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.KnownPolynomial;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class DatasetCurveFitter
extends JPanel {
    public static final String PROPERTY_DATASETCURVEFITTER_CHANGED = "changed";
    public static final String PROPERTY_DATASETCURVEFITTER_DRAWER = "drawer";
    public static final String PROPERTY_DATASETCURVEFITTER_FIT = "fit";
    public static boolean isFixedDecimalFormat = false;
    static final String FIT_EXP = "Exponential";
    static final String FIT_LOG = "Log";
    static final String FIT_SIN = "Sinusoid";
    static final String FIT_DAMPED = "DampedSine";
    static final String FIT_GAUSS = "Gaussian";
    static final String FIT_POWER = "Power";
    static final String FIT_TEST = "TestFunction";
    static ArrayList<KnownFunction> defaultFits = new ArrayList();
    private static final Border labelBorder = BorderFactory.createEmptyBorder(0, 2, 0, 2);
    private FitBuilder fitBuilder;
    private PropertyChangeListener fitListener;
    private DataToolTab tab;
    KnownFunction fit;
    double sigma_y_squared = 1.0;
    ArrayList<UserFunction> testFunctions = new ArrayList();
    Color color = Color.MAGENTA;
    ParamTableModel paramModel;
    private ArrayList<KnownFunction> localFits = new ArrayList();
    private Dataset dataset;
    private HessianMinimize hessian = new HessianMinimize();
    private LevenbergMarquardt levmar = new LevenbergMarquardt();
    private UncertainFunctionDrawer drawer;
    private Map<String, KnownFunction> fitMap = new TreeMap<String, KnownFunction>();
    private Map<KnownFunction, boolean[]> fixedParams = new HashMap<KnownFunction, boolean[]>();
    private Map<KnownFunction, double[]> initialParams = new HashMap<KnownFunction, double[]>();
    int fitNumber = 1;
    boolean refreshing = false;
    private boolean isActive;
    boolean neverBeenActive = true;
    int fontLevel;
    double correlation = Double.NaN;
    double[] uncertainties = new double[2];
    boolean fitEvaluatedToNaN = false;
    private boolean autofit;
    private JButton colorButton;
    private JButton closeButton;
    private JCheckBox autofitCheckBox;
    private JLabel fitLabel;
    private JLabel eqnLabel;
    private JLabel rmsLabel;
    private JToolBar fitBar;
    private JToolBar eqnBar;
    private JToolBar rmsBar;
    private JComboBox<String> fitDropDown;
    private JTextField eqnField;
    private NumberField rmsField;
    private ParamTable paramTable;
    private ParamCellRenderer cellRenderer;
    private SpinCellEditor spinCellEditor;
    private JButton fitBuilderButton;
    protected JSplitPane splitPane;
    private JDialog colorDialog;

    static {
        defaultFits.add(new KnownPolynomial(new double[2]));
        defaultFits.add(new KnownPolynomial(new double[3]));
        defaultFits.add(new KnownPolynomial(new double[4]));
        UserFunction f = new UserFunction(FIT_GAUSS);
        f.setParameters(new String[]{"A", "B", "C"}, new double[]{1.0, 0.0, 1.0}, new String[]{ToolsRes.getString("Function.Parameter.PeakHeight.Description"), ToolsRes.getString("Function.Parameter.PeakPosition.Description"), ToolsRes.getString("Function.Parameter.GaussianRMSWidth.Description")});
        f.setExpression("A * exp(-(x-B)^2 / (2*C^2))", new String[]{"x"});
        f.setDescription(ToolsRes.getString("Function.Gaussian.Description"));
        defaultFits.add(f);
        f = new UserFunction(FIT_EXP);
        f.setParameters(new String[]{"A", "B", "C"}, new double[]{1.0, -1.0, 0.0}, new String[]{ToolsRes.getString("Function.Parameter.Magnitude.Description"), ToolsRes.getString("Function.Parameter.ExponentialMultiplier.Description"), ToolsRes.getString("Function.Parameter.Offset.Description")});
        f.setExpression("A * exp(B*x) + C", new String[]{"x"});
        f.setDescription(ToolsRes.getString("Function.Exponential.Description"));
        defaultFits.add(f);
        f = new UserFunction(FIT_SIN);
        f.setParameters(new String[]{"A", "B", "C", "D"}, new double[]{1.0, 1.0, 0.0, 0.0}, new String[]{ToolsRes.getString("Function.Parameter.Amplitude.Description"), ToolsRes.getString("Function.Parameter.Omega.Description"), ToolsRes.getString("Function.Parameter.Phase.Description"), ToolsRes.getString("Function.Parameter.Offset.Description")});
        f.setExpression("A * sin(B*x+C) + D", new String[]{"x"});
        f.setDescription(ToolsRes.getString("Function.Sinusoid.Description"));
        defaultFits.add(f);
        f = new UserFunction(FIT_DAMPED);
        f.setParameters(new String[]{"A", "B", "C", "D", "E"}, new double[]{1.0, 1.0, 0.0, 0.0, 0.0}, new String[]{ToolsRes.getString("Function.Parameter.Intercept.Description"), ToolsRes.getString("Function.Parameter.Omega.Description"), ToolsRes.getString("Function.Parameter.Phase.Description"), ToolsRes.getString("Function.Parameter.Offset.Description"), ToolsRes.getString("Function.Parameter.ExponentialMultiplier.Description")});
        f.setExpression("A * exp(E*x) * sin(B*x + C) + D", new String[]{"x"});
        f.setDescription(ToolsRes.getString("Function.DampedSine.Description"));
        defaultFits.add(f);
        f = new UserFunction(FIT_POWER);
        f.setParameters(new String[]{"A", "B"}, new double[]{1.0, 1.0}, new String[]{ToolsRes.getString("Function.Parameter.Coeff.Description"), ToolsRes.getString("Function.Parameter.Power.Description")});
        f.setExpression("A * x ^ B", new String[]{"x"});
        f.setDescription(ToolsRes.getString("Function.Power.Description"));
        defaultFits.add(f);
        f = new UserFunction(FIT_LOG);
        f.setParameters(new String[]{"A", "B"}, new double[]{1.0, 0.0}, new String[]{ToolsRes.getString("Function.Parameter.Scale.Description"), ToolsRes.getString("Function.Parameter.Offset.Description")});
        f.setExpression("A * ln(x) + B", new String[]{"x"});
        f.setDescription(ToolsRes.getString("Function.Log.Description"));
        defaultFits.add(f);
    }

    public void setActiveNoFit(boolean b) {
        this.isActive = b;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setAutofit(boolean auto) {
        this.autofit = auto;
        if (auto != this.autofitCheckBox.isSelected()) {
            this.autofitCheckBox.doClick(0);
        }
    }

    boolean isAutoFit() {
        return this.autofit;
    }

    public void setAutoFit(boolean autofit) {
        this.autofit = autofit;
        this.autofitCheckBox.setSelected(autofit);
        if (!autofit) {
            this.drawer.setUncertainties(null);
        }
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public DatasetCurveFitter(Dataset data, FitBuilder builder) {
        this.dataset = data;
        this.fitBuilder = builder;
        this.createGUI();
        this.fitBuilder.removePropertyChangeListener(this.fitListener);
        this.fitBuilder.addPropertyChangeListener(this.fitListener);
    }

    public UncertainFunctionDrawer getDrawer() {
        return this.drawer;
    }

    public Dataset getData() {
        return this.dataset;
    }

    public void setData(Dataset data, boolean doFit) {
        this.dataset = data;
        if (!this.isActive) {
            return;
        }
        if (doFit) {
            this.fit(this.fit);
        }
        if (this.dataset != null) {
            this.fitBuilder.setDefaultVariables(new String[]{TeXParser.removeSubscripting(this.dataset.getXColumnName())});
            if (!this.isActive) {
                double[] x = this.dataset.getValidXPoints();
                double[] y = this.dataset.getValidYPoints();
                this.doLinearRegression(x, y);
                this.refreshStatusBar();
            }
        }
    }

    public void setColor(Color newColor) {
        this.color = newColor;
        if (this.drawer != null) {
            this.drawer.setColor(newColor);
            this.updateColorButton();
            this.firePropertyChange(PROPERTY_DATASETCURVEFITTER_CHANGED, null, null);
        }
    }

    private void updateColorButton() {
        boolean nimbus;
        LookAndFeel currentLF = UIManager.getLookAndFeel();
        boolean bl = nimbus = currentLF.getClass().getName().indexOf("Nimbus") > -1;
        if (nimbus) {
            this.colorButton.setIcon(new ColorIcon(this.color, 12, DataTool.buttonHeight - 8));
        } else {
            this.colorButton.setBackground(this.color);
        }
    }

    public void setActiveAndFit(boolean active) {
        if (this.isActive == active) {
            return;
        }
        this.isActive = active;
        if (active) {
            if (this.neverBeenActive) {
                this.neverBeenActive = false;
                this.setAutoFit(true);
            }
            this.fit(this.fit);
        }
    }

    public double fit(KnownFunction fit) {
        return this.fit(fit, false);
    }

    public double fit(KnownFunction fit, boolean fromScratch) {
        boolean nothingToTest;
        if (this.drawer == null) {
            this.selectFit((String)this.fitDropDown.getSelectedItem());
        }
        if (fit == null) {
            return Double.NaN;
        }
        if (this.dataset == null) {
            if (fit instanceof UserFunction) {
                this.eqnField.setText("y = " + ((UserFunction)fit).getFullExpression(new String[]{"x"}));
            } else {
                this.eqnField.setText("y = " + fit.getExpression("x").replace(" ", ""));
            }
            this.setAutoFit(false);
            this.autofitCheckBox.setEnabled(false);
            this.spinCellEditor.stopCellEditing();
            this.paramTable.setEnabled(false);
            this.rmsField.setText(ToolsRes.getString("DatasetCurveFitter.RMSField.NoData"));
            this.rmsField.setForeground(Color.RED);
            return Double.NaN;
        }
        double devSq = 0.0;
        double[] x = this.dataset.getValidXPoints();
        double[] y = this.dataset.getValidYPoints();
        this.autofitCheckBox.setEnabled(true);
        this.paramTable.setEnabled(true);
        boolean bl = fromScratch = !fit.getName().equals(FIT_TEST) && (fromScratch || this.fixedParams.get(fit) == null);
        if (fromScratch) {
            double[] scratchParams;
            if (this.initialParams.get(fit) == null) {
                double[] p = new double[fit.getParameterCount()];
                int i = 0;
                while (i < fit.getParameterCount()) {
                    p[i] = fit.getParameterValue(i);
                    ++i;
                }
                this.initialParams.put(fit, p);
            }
            if (this.fixedParams.get(fit) == null) {
                this.fixedParams.put(fit, new boolean[fit.getParameterCount()]);
            }
            if ((scratchParams = this.getScratchParams(fit, x, y)) != null) {
                boolean[] fix = this.fixedParams.get(fit);
                int i = 0;
                while (i < scratchParams.length) {
                    if (!fix[i]) {
                        fit.setParameterValue(i, scratchParams[i]);
                    }
                    ++i;
                }
            }
        }
        boolean[] fix = this.fixedParams.get(fit);
        KnownFunction testFit = this.getTestFunction(fit, fix);
        boolean bl2 = nothingToTest = fix != null;
        if (fix != null) {
            int i = 0;
            while (i < fix.length) {
                nothingToTest = nothingToTest && fix[i];
                ++i;
            }
        }
        if (nothingToTest) {
            this.setUncertainties(null);
            this.tab.refreshPlot();
            this.drawer.functionChanged = true;
            this.paramTable.repaint();
        } else {
            double[] prevParams = null;
            double prevDevSq = this.getDevSquared(fit, x, y);
            if (this.autofit && !Double.isNaN(prevDevSq)) {
                UserFunction f;
                double[] params;
                if (testFit instanceof KnownPolynomial) {
                    KnownPolynomial poly = (KnownPolynomial)testFit;
                    poly.fitData(x, y);
                } else if (testFit instanceof UserFunction && (params = new double[(f = (UserFunction)testFit).getParameterCount()]).length > 0 && params.length <= x.length && params.length <= y.length) {
                    int i;
                    MinimizeUserFunction minFunc = new MinimizeUserFunction(f, x, y);
                    prevParams = new double[params.length];
                    int i2 = 0;
                    while (i2 < params.length) {
                        params[i2] = prevParams[i2] = f.getParameterValue(i2);
                        ++i2;
                    }
                    double tol = 1.0E-6;
                    int iterations = 20;
                    this.hessian.minimize(minFunc, params, iterations, tol);
                    devSq = this.getDevSquared(testFit, x, y);
                    boolean success = true;
                    if (devSq > prevDevSq) {
                        i = 0;
                        while (i < prevParams.length) {
                            f.setParameterValue(i, prevParams[i]);
                            ++i;
                        }
                        success = this.levmar.minimize(minFunc, params, iterations, tol);
                        devSq = this.getDevSquared(testFit, x, y);
                    }
                    if (!success || devSq > prevDevSq) {
                        i = 0;
                        while (i < prevParams.length) {
                            f.setParameterValue(i, prevParams[i]);
                            ++i;
                        }
                        devSq = prevDevSq;
                    }
                }
                if (!this.testFunctions.contains(fit)) {
                    if (this.autofit) {
                        double[][] sigmas = this.getUncertainties(fit, testFit, x, y);
                        this.setUncertainties(sigmas);
                    } else {
                        this.setUncertainties(null);
                    }
                    if (this.tab != null) {
                        this.tab.refreshPlot();
                    }
                }
                this.drawer.functionChanged = true;
                this.paramTable.repaint();
            }
            if (fit != testFit) {
                int i = 0;
                while (i < fit.getParameterCount()) {
                    String next = fit.getParameterName(i);
                    int j = 0;
                    while (j < testFit.getParameterCount()) {
                        if (testFit.getParameterName(j).equals(next)) {
                            fit.setParameterValue(i, testFit.getParameterValue(j));
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        this.doLinearRegression(x, y);
        if (devSq == 0.0) {
            devSq = this.getDevSquared(fit, x, y);
        }
        double rmsDev = fit.getParameterCount() > x.length && this.autofit ? Double.NaN : Math.sqrt(devSq / (double)x.length);
        this.rmsField.setForeground(this.eqnField.getForeground());
        if (x.length == 0 || y.length == 0 || Double.isNaN(rmsDev)) {
            this.rmsField.setValue(Double.NaN);
            this.rmsField.setToolTipText(ToolsRes.getString("DatasetCurveFitter.InsufficientData.ToolTip"));
        } else {
            this.rmsField.applyPattern("0.000E0");
            this.rmsField.setValue(rmsDev);
            this.rmsField.setToolTipText(null);
        }
        this.refreshStatusBar();
        this.firePropertyChange(PROPERTY_DATASETCURVEFITTER_FIT, null, null);
        if (this.tab != null && this.tab.areaVisible && this.tab.measureFit) {
            this.tab.plot.refreshArea();
        }
        return rmsDev;
    }

    public void addFitFunction(KnownFunction f, boolean addToFitBuilder) {
        KnownFunction existing = this.fitMap.get(f.getName());
        if (existing != null) {
            if (existing.getExpression("x").equals(f.getExpression("x"))) {
                return;
            }
            f.setName(this.fitBuilder.getUniqueName(f.getName()));
        }
        String selectedFitName = this.fit == null ? this.getPolyFitNameOfDegree(1) : this.fit.getName();
        this.fitBuilder.addFitFunction(f);
        this.fitDropDown.setSelectedItem(selectedFitName);
    }

    public void refreshStatusBar() {
        if (this.tab != null && this.tab.statsCheckbox.isSelected()) {
            this.tab.refreshStatusBar(this.tab.getCorrelationString());
        }
    }

    public double getUncertainty(int paramIndex) {
        if (this.uncertainties != null && paramIndex < this.uncertainties.length && this.autofit) {
            return this.uncertainties[paramIndex];
        }
        return Double.NaN;
    }

    public String[] formatUncertainParameter(double value, double sigma, int extraPlaces, NumberFormat format) {
        int expSig;
        if (Double.isNaN(sigma) || sigma <= 0.0) {
            return null;
        }
        int exp = value == 0.0 ? 0 : (int)Math.floor(Math.log10(Math.abs(value)));
        int n = expSig = sigma == 0.0 ? 0 : (int)Math.floor(Math.log10(Math.abs(sigma)));
        if (expSig > exp) {
            exp = expSig;
        }
        int shift = exp - expSig;
        double multiplier = Math.pow(10.0, -exp);
        int places = Math.max(0, shift) + extraPlaces;
        String val = String.format("%." + places + "f", value * multiplier);
        String sig = String.format("%." + places + "f", sigma * multiplier);
        String formatted = String.valueOf(val) + " \u00b1 " + sig;
        String separator = String.valueOf(OSPRuntime.getCurrentDecimalSeparator());
        formatted = formatted.replace(".", separator);
        if (exp != 0) {
            formatted = "(" + formatted + ") " + String.format("E%d", exp);
        }
        val = format.format(value);
        sig = format.format(sigma);
        String tooltip = String.valueOf(val) + " \u00b1 " + sig;
        return new String[]{formatted, tooltip};
    }

    public KnownFunction getFitFunction(String name) {
        int i = this.localFits.size();
        while (--i >= 0) {
            if (!this.localFits.get(i).getName().equals(name)) continue;
            return this.localFits.get(i);
        }
        return null;
    }

    public Map<String, Double> getSelectedFitParameters() {
        return null;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = this.fitBar.getPreferredSize();
        dim.height += this.eqnBar.getPreferredSize().height;
        dim.height += this.rmsBar.getPreferredSize().height + 1;
        return dim;
    }

    protected void createGUI() {
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane(1);
        this.splitPane.setResizeWeight(0.7);
        this.splitPane.setDividerSize(6);
        this.autofit = true;
        this.autofitCheckBox = new JCheckBox("", true);
        this.autofitCheckBox.setOpaque(false);
        this.autofitCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetCurveFitter.this.autofit = DatasetCurveFitter.this.autofitCheckBox.isSelected();
                DatasetCurveFitter.this.spinCellEditor.stopCellEditing();
                DatasetCurveFitter.this.paramTable.clearSelection();
                if (DatasetCurveFitter.this.autofit) {
                    DatasetCurveFitter.this.fit(DatasetCurveFitter.this.fit, true);
                } else {
                    DatasetCurveFitter.this.fit(DatasetCurveFitter.this.fit);
                }
                DatasetCurveFitter.this.firePropertyChange(DatasetCurveFitter.PROPERTY_DATASETCURVEFITTER_CHANGED, null, null);
                DatasetCurveFitter.this.paramTable.repaint();
                DatasetCurveFitter.this.tab.repaint();
                if (!DatasetCurveFitter.this.autofit) {
                    DatasetCurveFitter.this.drawer.setUncertainties(null);
                }
            }
        });
        this.fitLabel = new JLabel(ToolsRes.getString("DatasetCurveFitter.Label.FitName"));
        this.fitLabel.setBorder(labelBorder);
        this.eqnLabel = new JLabel(ToolsRes.getString("DatasetCurveFitter.Label.Equation"));
        this.eqnLabel.setBorder(labelBorder);
        this.rmsLabel = new JLabel();
        this.rmsLabel.setBorder(labelBorder);
        this.fitDropDown = new JComboBox<String>(){

            @Override
            public Dimension getPreferredSize() {
                return DatasetCurveFitter.this.fixSize(super.getPreferredSize());
            }

            @Override
            public void addItem(String obj) {
                if (obj == null) {
                    return;
                }
                String line = DatasetCurveFitter.this.getPolyFitNameOfDegree(1);
                String parabola = DatasetCurveFitter.this.getPolyFitNameOfDegree(2);
                String name = FitBuilder.localize(obj);
                int count = this.getItemCount();
                boolean added = false;
                int i = 0;
                while (i < count) {
                    String next = FitBuilder.localize((String)this.getItemAt(i));
                    if (next != null && name.compareToIgnoreCase(next) < 0) {
                        this.insertItemAt(obj, i);
                        added = true;
                        break;
                    }
                    ++i;
                }
                if (!added) {
                    super.addItem(obj);
                }
                if (obj.equals(line)) {
                    this.removeItem(obj);
                    this.insertItemAt(obj, 0);
                } else if (obj.equals(parabola)) {
                    this.removeItem(obj);
                    this.insertItemAt(obj, 0);
                }
            }
        };
        for (KnownFunction f : defaultFits) {
            this.localFits.add(f.clone());
        }
        this.refreshFitMap();
        for (String next : this.fitMap.keySet()) {
            this.fitDropDown.addItem(next);
        }
        this.fitDropDown.setSelectedItem(this.getPolyFitNameOfDegree(1));
        this.fitDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetCurveFitter f;
                if (DatasetCurveFitter.this.refreshing || (f = DatasetCurveFitter.this.fitBuilder.getSelectedCurveFitter()) == null || f != DatasetCurveFitter.this) {
                    return;
                }
                String selection = (String)DatasetCurveFitter.this.fitDropDown.getSelectedItem();
                if (selection != null && DatasetCurveFitter.this.fit != null && !selection.equals(DatasetCurveFitter.this.fit.getName())) {
                    DatasetCurveFitter.this.firePropertyChange(DatasetCurveFitter.PROPERTY_DATASETCURVEFITTER_CHANGED, null, null);
                }
                DatasetCurveFitter.this.selectFit(selection);
                DatasetCurveFitter.this.fitDropDown.setToolTipText(DatasetCurveFitter.this.fit == null ? null : DatasetCurveFitter.this.fit.getDescription());
            }
        });
        class FitDropDownRenderer
        extends JLabel
        implements ListCellRenderer<String> {
            public FitDropDownRenderer() {
                this.setOpaque(true);
                this.setBorder(new EmptyBorder(1, 1, 1, 1));
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension size;
                if (this.getText() == null || this.getText().equals("")) {
                    this.setText(" ");
                    size = super.getPreferredSize();
                    this.setText("");
                } else {
                    size = super.getPreferredSize();
                }
                return size;
            }

            @Override
            public Component getListCellRendererComponent(JList list, String value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                    int length = DatasetCurveFitter.this.fitDropDown.getItemCount();
                    if (index >= 0 && index < length) {
                        KnownFunction func = DatasetCurveFitter.this.getFitFunction((String)DatasetCurveFitter.this.fitDropDown.getItemAt(index));
                        list.setToolTipText(func == null ? null : func.getDescription());
                    }
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setFont(list.getFont());
                this.setText(value == null ? "" : FitBuilder.localize(value.toString()));
                return this;
            }
        }
        this.fitDropDown.setRenderer(new FitDropDownRenderer());
        this.eqnField = new JTextField(){

            @Override
            public Dimension getPreferredSize() {
                return DatasetCurveFitter.this.fixSize(super.getPreferredSize());
            }
        };
        this.eqnField.setEditable(false);
        this.eqnField.setEnabled(true);
        this.eqnField.setBackground(Color.white);
        this.eqnField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    String name = DatasetCurveFitter.this.fitDropDown.getSelectedItem().toString();
                    if (DatasetCurveFitter.this.fitBuilder.getPanelNames().contains(name)) {
                        DatasetCurveFitter.this.fitBuilder.setSelectedPanel(name);
                    } else {
                        UserFunction uf = DatasetCurveFitter.this.createClone(DatasetCurveFitter.this.fit, name);
                        UserFunctionEditor editor = new UserFunctionEditor();
                        editor.setMainFunctions(new UserFunction[]{uf});
                        FitFunctionPanel panel = new FitFunctionPanel(editor);
                        DatasetCurveFitter.this.fitBuilder.addPanel(uf.getName(), panel);
                        DatasetCurveFitter.this.fitDropDown.setSelectedItem(uf.getName());
                    }
                    DatasetCurveFitter.this.fitBuilder.setVisible(true);
                }
            }
        });
        this.colorButton = DataTool.createButton("    ", false);
        this.colorButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.Color.Tooltip"));
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog dialog = DatasetCurveFitter.this.getColorDialog();
                DatasetCurveFitter.this.closeButton.setText(ToolsRes.getString("Button.OK"));
                dialog.setTitle(ToolsRes.getString("DatasetCurveFitter.Dialog.Color.Title"));
                dialog.setVisible(true);
            }
        });
        this.colorButton.setBorder(new EmptyBorder(7, 1, 5, 3));
        this.rmsField = new NumberField(6){

            @Override
            public Dimension getPreferredSize() {
                return DatasetCurveFitter.this.fixSize(super.getPreferredSize());
            }
        };
        this.rmsField.setEditable(false);
        this.rmsField.setEnabled(true);
        this.rmsField.setBackground(Color.white);
        this.cellRenderer = new ParamCellRenderer();
        this.spinCellEditor = new SpinCellEditor();
        this.paramModel = new ParamTableModel();
        this.paramTable = new ParamTable(this.paramModel);
        this.paramTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (DatasetCurveFitter.this.paramTable.getSelectedColumn() == 0) {
                    DatasetCurveFitter.this.paramTable.clearSelection();
                }
            }
        });
        JScrollPane scroller = new JScrollPane(this.paramTable){

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = ((DatasetCurveFitter)DatasetCurveFitter.this).spinCellEditor.spinner.getPreferredSize();
                dim.width += ((DatasetCurveFitter)DatasetCurveFitter.this).cellRenderer.fieldFont.getSize() * 7;
                return dim;
            }
        };
        scroller.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (OSPRuntime.isPopupTrigger(e)) {
                    DatasetCurveFitter.this.paramTable.showPopup(e);
                }
            }
        });
        this.splitPane.setRightComponent(scroller);
        this.add((Component)this.getSplitPane(), "Center");
        this.fitBuilderButton = DataTool.createButton(ToolsRes.getString("DatasetCurveFitter.Button.Define.Text"));
        this.fitBuilderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fitName = DatasetCurveFitter.this.fit.getName();
                DatasetCurveFitter.this.fitBuilder.refreshDropdown(fitName);
                if (fitName != null && DatasetCurveFitter.this.fitBuilder.getPanelNames().contains(fitName)) {
                    DatasetCurveFitter.this.fitBuilder.setSelectedPanel(fitName);
                } else if (DatasetCurveFitter.this.fitBuilder.getSelectedName() != null) {
                    DatasetCurveFitter.this.fitDropDown.setSelectedItem(DatasetCurveFitter.this.fitBuilder.getSelectedName());
                }
                DatasetCurveFitter.this.fitBuilder.refreshGUI();
                DatasetCurveFitter.this.fitBuilder.setVisible(true);
            }
        });
        this.fitListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                DatasetCurveFitter.this.processPropertyChange(e);
            }
        };
        ArrayList<KnownFunction> fits = new ArrayList<KnownFunction>(this.localFits);
        for (KnownFunction f : fits) {
            if (this.fitBuilder.addFitFunction(f)) continue;
            this.localFits.remove(f);
        }
        for (String next : this.fitBuilder.getPanelNames()) {
            FitFunctionPanel panel = (FitFunctionPanel)this.fitBuilder.getPanel(next);
            KnownFunction f = this.getFitFunction(panel);
            if (this.localFits.contains(f)) continue;
            this.localFits.add(f);
        }
        JPanel fitPanel = new JPanel(new BorderLayout());
        this.splitPane.setLeftComponent(fitPanel);
        this.fitBar = new JToolBar();
        this.fitBar.setFloatable(false);
        this.fitBar.setBorder(BorderFactory.createEtchedBorder());
        this.fitBar.add(this.fitLabel);
        this.fitBar.add(this.fitDropDown);
        this.fitBar.addSeparator();
        this.fitBar.add(this.fitBuilderButton);
        fitPanel.add((Component)this.fitBar, "North");
        JPanel eqnPanel = new JPanel(new BorderLayout());
        fitPanel.add((Component)eqnPanel, "Center");
        this.eqnBar = new JToolBar();
        this.eqnBar.setFloatable(false);
        this.eqnBar.setBorder(BorderFactory.createEtchedBorder());
        this.eqnBar.add(this.eqnLabel);
        this.eqnBar.add(this.eqnField);
        this.eqnBar.add(this.colorButton);
        eqnPanel.add((Component)this.eqnBar, "North");
        JPanel rmsPanel = new JPanel(new BorderLayout());
        eqnPanel.add((Component)rmsPanel, "Center");
        this.rmsBar = new JToolBar();
        this.rmsBar.setLayout(new BoxLayout(this.rmsBar, 0){

            @Override
            public void layoutContainer(Container target) {
                super.layoutContainer(target);
            }
        });
        this.rmsBar.setFloatable(false);
        this.rmsBar.setBorder(BorderFactory.createEtchedBorder());
        this.rmsBar.add(this.autofitCheckBox);
        this.rmsBar.addSeparator();
        this.rmsBar.add(this.rmsLabel);
        this.rmsBar.add(this.rmsField);
        rmsPanel.add((Component)this.rmsBar, "North");
        this.refreshGUI();
    }

    protected Dimension fixSize(Dimension dim) {
        dim.height = DataTool.buttonHeight - 2;
        return dim;
    }

    protected void processPropertyChange(PropertyChangeEvent e) {
        String prop;
        if (this.refreshing) {
            return;
        }
        boolean isSelectedCurveFitter = this.fitBuilder.getSelectedCurveFitter() == this;
        switch (prop = e.getPropertyName()) {
            case "function": {
                String fitName;
                String name = (String)e.getNewValue();
                FitFunctionPanel panel = (FitFunctionPanel)this.fitBuilder.getSelectedPanel();
                String oldFitName = fitName = panel.getName();
                if (name.equals(fitName) && e.getOldValue() != null && e.getOldValue() instanceof String) {
                    oldFitName = (String)e.getOldValue();
                }
                KnownFunction f = this.getFitFunction(panel);
                this.replaceFit(oldFitName, fitName, f);
                if (!fitName.equals(oldFitName)) {
                    this.fitDropDown.addItem(fitName);
                }
                if (!isSelectedCurveFitter || this.tab == null || this.tab.dataTool == null || this.tab.dataTool.isLoading) break;
                this.fitDropDown.setSelectedItem(fitName);
                break;
            }
            case "panel": {
                KnownFunction f;
                if (e.getNewValue() != null) {
                    f = this.getFitFunction((FitFunctionPanel)e.getNewValue());
                    String name = f.getName();
                    if (!this.fitMap.keySet().contains(name)) {
                        this.localFits.add(f);
                        this.fitMap.put(name, f);
                        this.fitDropDown.addItem(name);
                    }
                    if (this.fitBuilder.isVisible() && isSelectedCurveFitter && this.tab != null && this.tab.dataTool != null && !this.tab.dataTool.isLoading) {
                        this.fitDropDown.setSelectedItem(name);
                    }
                }
                if (e.getOldValue() == null) break;
                f = this.getFitFunction((FitFunctionPanel)e.getOldValue());
                if (this.fitBuilder.getPanelNames().contains(f.getName())) break;
                this.localFits.remove(f);
                break;
            }
            default: {
                return;
            }
        }
        this.firePropertyChange(PROPERTY_DATASETCURVEFITTER_CHANGED, null, null);
        this.refreshGUI();
    }

    protected void refreshGUI() {
        this.autofitCheckBox.setText(ToolsRes.getString("Checkbox.Autofit.Label"));
        this.rmsLabel.setText(ToolsRes.getString("DatasetCurveFitter.Label.RMSDeviation"));
        this.fitBuilderButton.setText(ToolsRes.getString("DatasetCurveFitter.Button.Define.Text"));
        this.fitBuilderButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.Define.Tooltip"));
        this.fitLabel.setText(ToolsRes.getString("DatasetCurveFitter.Label.FitName"));
        this.eqnLabel.setText(ToolsRes.getString("DatasetCurveFitter.Label.Equation"));
        this.updateColorButton();
        this.refreshFitDropDown();
    }

    protected void refreshDecimalSeparators() {
        this.repaint();
        this.spinCellEditor.field.setValue(this.spinCellEditor.field.getValue());
    }

    protected void refreshFitDropDown() {
        Runnable runner = new Runnable(){

            @Override
            public synchronized void run() {
                DatasetCurveFitter.this.refreshFitMap();
                String line = DatasetCurveFitter.this.getPolyFitNameOfDegree(1);
                String parabola = DatasetCurveFitter.this.getPolyFitNameOfDegree(2);
                String toSelect = ((DatasetCurveFitter)DatasetCurveFitter.this).fitBuilder.defaultFitName = line;
                DatasetCurveFitter.this.refreshing = true;
                DatasetCurveFitter.this.fitDropDown.removeAllItems();
                for (String name : DatasetCurveFitter.this.fitMap.keySet()) {
                    String localized;
                    if (DatasetCurveFitter.this.fit != null && name.equals(DatasetCurveFitter.this.fit.getName())) {
                        toSelect = name;
                    }
                    if (name.equals(line) || name.equals(parabola)) continue;
                    if (toSelect == name && !(localized = ToolsRes.getString("Function." + name + ".Name")).startsWith("!")) {
                        toSelect = name = localized;
                    }
                    DatasetCurveFitter.this.fitDropDown.addItem(name);
                }
                DatasetCurveFitter.this.fitDropDown.addItem(parabola);
                DatasetCurveFitter.this.fitDropDown.addItem(line);
                DatasetCurveFitter.this.fitDropDown.setSelectedItem(toSelect);
                DatasetCurveFitter.this.refreshing = false;
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    protected void refreshFitMap() {
        this.fitMap.clear();
        for (KnownFunction f : this.localFits) {
            this.fitMap.put(f.getName(), f);
        }
    }

    public String getPolyFitNameOfDegree(int degree) {
        for (String key : this.fitMap.keySet()) {
            KnownPolynomial poly;
            KnownFunction f = this.fitMap.get(key);
            if (!(f instanceof KnownPolynomial) || (poly = (KnownPolynomial)f).getParameterCount() != degree + 1) continue;
            return key;
        }
        return null;
    }

    protected void setDataToolTab(DataToolTab tab) {
        this.tab = tab;
    }

    protected void setFontLevel(int level) {
        this.fontLevel = level;
        FontSizer.setFonts(this, this.fontLevel);
        this.fitBuilder.setFontLevel(level);
        this.splitPane.setDividerLocation(this.splitPane.getMaximumDividerLocation());
    }

    protected void setParameterValue(int row, double value) {
        if (row < this.fit.getParameterCount()) {
            this.fit.setParameterValue(row, value);
        }
    }

    protected void selectFit(String name) {
        if (this.refreshing) {
            return;
        }
        if (name == null) {
            name = this.getPolyFitNameOfDegree(1);
        }
        this.fit = this.fitMap.get(name);
        if (this.fit != null) {
            String indepVar;
            UncertainFunctionDrawer prev = this.drawer;
            this.drawer = new UncertainFunctionDrawer(this.fit);
            this.drawer.setColor(this.color);
            this.paramTable.tableChanged(null);
            String depVar = this.dataset == null ? "y" : TeXParser.removeSubscripting(this.dataset.getColumnName(1));
            String string = indepVar = this.dataset == null ? "x" : TeXParser.removeSubscripting(this.dataset.getColumnName(0));
            if (this.fit instanceof UserFunction) {
                this.eqnField.setText(String.valueOf(depVar) + " = " + ((UserFunction)this.fit).getFullExpression(new String[]{indepVar}));
            } else {
                this.eqnField.setText(String.valueOf(depVar) + " = " + this.fit.getExpression(indepVar).replace(" ", ""));
            }
            this.firePropertyChange(PROPERTY_DATASETCURVEFITTER_DRAWER, prev, this.drawer);
            if (this.isActive) {
                this.fit(this.fit);
            }
            if (this.fitBuilder.isVisible()) {
                this.fitBuilder.setSelectedPanel(this.fit.getName());
            }
            this.paramTable.getColumnModel().getColumn(1).setMaxWidth(this.getMinCheckboxColumnWidth() + 10);
            this.revalidate();
        }
        this.setActiveAndFit(true);
    }

    private int getMinCheckboxColumnWidth() {
        String s = ToolsRes.getString("DatasetCurveFitter.Table.Heading.FixedParam");
        Font font = this.paramTable.getTableHeader().getFont();
        FontMetrics fm = this.paramTable.getTableHeader().getFontMetrics(font);
        return fm.stringWidth(s);
    }

    protected UserFunction createClone(KnownFunction f, String name) {
        String var = this.dataset == null ? "x" : TeXParser.removeSubscripting(this.dataset.getColumnName(0));
        UserFunction uf = f.newUserFunction(var);
        int n = 1;
        try {
            int len = name.length() - 1;
            String number = name.substring(len);
            n = Integer.parseInt(number) + 1;
            name = name.substring(0, len);
        }
        catch (Exception len) {
            // empty catch block
        }
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < this.fitDropDown.getItemCount()) {
            names.add(this.fitDropDown.getItemAt(i).toString());
            ++i;
        }
        try {
            while (names.contains(String.valueOf(name) + n)) {
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        uf.setName(String.valueOf(name) + n);
        return uf;
    }

    private double getDevSquared(Function f, double[] x, double[] y) {
        this.fitEvaluatedToNaN = false;
        double total = 0.0;
        int i = 0;
        while (i < x.length) {
            double next = f.evaluate(x[i]);
            if (f instanceof UserFunction && this.tab != null) {
                this.fitEvaluatedToNaN = this.fitEvaluatedToNaN || ((UserFunction)f).evaluatedToNaN();
            }
            double dev = next - y[i];
            total += dev * dev;
            ++i;
        }
        if (this.tab != null) {
            this.tab.plot.setMessage(this.fitEvaluatedToNaN ? ToolsRes.getString("DatasetCurveFitter.Warning.FunctionError") : "", 2);
        }
        return this.fitEvaluatedToNaN ? Double.NaN : total;
    }

    private double calibrateChiSquared(KnownFunction f, double[] x, double[] y) {
        int paramCount = f.getParameterCount();
        this.sigma_y_squared = this.getDevSquared(f, x, y) / (double)(x.length - paramCount);
        return x.length - paramCount;
    }

    private double getChiSquared(Function f, double[] x, double[] y) {
        return this.getDevSquared(f, x, y) / this.sigma_y_squared;
    }

    private double[][] getUncertainties(KnownFunction original, KnownFunction fitted, double[] x, double[] y) {
        int fitCount = fitted.getParameterCount();
        if (fitCount == 0 || x.length - fitCount <= 0) {
            return null;
        }
        double minChiSquared = this.calibrateChiSquared(fitted, x, y);
        int paramCount = original.getParameterCount();
        double[] params = new double[paramCount];
        String[] paramNames = new String[paramCount];
        int i = 0;
        while (i < paramCount) {
            params[i] = original.getParameterValue(i);
            paramNames[i] = original.getParameterName(i);
            ++i;
        }
        int[] fittedParamIndex = new int[paramCount];
        int i2 = 0;
        while (i2 < paramCount) {
            fittedParamIndex[i2] = -1;
            String name = original.getParameterName(i2);
            int k = 0;
            while (k < fitCount) {
                if (fitted.getParameterName(k).equals(name)) {
                    fittedParamIndex[i2] = k;
                }
                ++k;
            }
            ++i2;
        }
        ArrayList<double[]> results = new ArrayList<double[]>();
        double[] sigmas = new double[paramCount];
        int i3 = 0;
        while (i3 < paramCount) {
            if (fittedParamIndex[i3] < 0) {
                sigmas[i3] = Double.NaN;
            } else {
                UserFunction test;
                double paramVal;
                int j;
                String paramName = fitted.getParameterName(fittedParamIndex[i3]);
                double val = fitted.getParameterValue(fittedParamIndex[i3]);
                double delta = (Math.abs(val) + 1.0) / 100000.0;
                double chiSq = 0.0;
                double twiceDeltaChiSq = 0.0;
                double[][] testParams = new double[2][];
                int tries = 0;
                while ((twiceDeltaChiSq < 0.001 || twiceDeltaChiSq > 2.0) && tries < 10) {
                    if (twiceDeltaChiSq < 0.001 && twiceDeltaChiSq != 0.0) {
                        delta *= 10.0;
                    } else if (twiceDeltaChiSq > 2.0) {
                        delta /= 10.0;
                    }
                    chiSq = 0.0;
                    j = 0;
                    while (j < 2) {
                        paramVal = j == 0 ? val - delta : val + delta;
                        test = this.getTestFunction(fitted, paramName, paramVal);
                        if (test == null) break;
                        this.fit(test);
                        chiSq += this.getChiSquared(test, x, y);
                        ++j;
                    }
                    twiceDeltaChiSq = chiSq - 2.0 * minChiSquared;
                    ++tries;
                }
                if (twiceDeltaChiSq > 0.0) {
                    sigmas[i3] = delta * Math.sqrt(2.0 / twiceDeltaChiSq);
                    j = 0;
                    while (j < 2) {
                        paramVal = j == 0 ? val - sigmas[i3] : val + sigmas[i3];
                        test = this.getTestFunction(fitted, paramName, paramVal);
                        this.fit(test);
                        testParams[j] = new double[paramCount];
                        int k = 0;
                        while (k < paramCount) {
                            String next = original.getParameterName(k);
                            if (next.equals(paramName)) {
                                testParams[j][k] = paramVal;
                            } else {
                                int m = 0;
                                while (m < test.getParameterCount()) {
                                    String testName = test.getParameterName(m);
                                    if (next.equals(testName)) {
                                        testParams[j][k] = test.getParameterValue(m);
                                    }
                                    ++m;
                                }
                                testParams[j][k] = original.getParameterValue(k);
                            }
                            ++k;
                        }
                        results.add(testParams[j]);
                        ++j;
                    }
                }
            }
            ++i3;
        }
        results.add(0, sigmas);
        return (double[][])results.toArray((T[])new double[results.size()][]);
    }

    private double[] getScratchParams(KnownFunction f, double[] x, double[] y) {
        String name;
        double d;
        if (f instanceof KnownPolynomial) {
            return null;
        }
        double[] params = new double[f.getParameterCount()];
        if (params.length == 0 || x == null || x.length < params.length) {
            return null;
        }
        double[] initParams = this.initialParams.get(f);
        if (initParams != null) {
            params = initParams;
        }
        int dataLen = x.length;
        double ymax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double[] sortedX = new double[dataLen];
        double[] sortedY = new double[dataLen];
        TreeMap<Double, Double> sorted = new TreeMap<Double, Double>();
        int i = 0;
        while (i < dataLen) {
            sorted.put(x[i], y[i]);
            ++i;
        }
        int index = 0;
        Iterator<Object> iterator = sorted.keySet().iterator();
        while (iterator.hasNext()) {
            sortedX[index] = d = ((Double)iterator.next()).doubleValue();
            ++index;
        }
        index = 0;
        iterator = sorted.values().iterator();
        while (iterator.hasNext()) {
            sortedY[index] = d = ((Double)iterator.next()).doubleValue();
            ymax = Math.max(d, ymax);
            ymin = Math.min(d, ymin);
            ++index;
        }
        double xmax = sortedX[dataLen - 1];
        double xmin = sortedX[0];
        KnownPolynomial line = (KnownPolynomial)this.getFitFunction(this.getPolyFitNameOfDegree(1));
        String exp = f.getExpression("x");
        switch (name = f.getName()) {
            case "Sinusoid": 
            case "DampedSine": {
                if (exp.contains("+D")) {
                    params[3] = (ymin + ymax) / 2.0;
                }
                params[0] = (ymax - ymin) / 2.0;
                int crossings = 0;
                double firstCrossing = Double.MAX_VALUE;
                double lastCrossing = Double.MAX_VALUE;
                double prevX = Double.MAX_VALUE;
                double prevY = Double.MAX_VALUE;
                boolean posSlope = true;
                int i2 = 0;
                while (i2 < sortedX.length) {
                    boolean crossed;
                    double yshifted = sortedY[i2] - (params.length > 3 ? params[3] : 0.0);
                    if (i2 == 0) {
                        prevX = sortedX[i2];
                        prevY = yshifted;
                    }
                    boolean bl = prevY > 0.0 ? yshifted <= 0.0 : (crossed = yshifted > 0.0);
                    if (crossed) {
                        lastCrossing = sortedX[i2] - yshifted / (yshifted - prevY) * (sortedX[i2] - prevX);
                        if (++crossings == 1) {
                            firstCrossing = lastCrossing;
                            posSlope = yshifted > 0.0;
                        }
                    }
                    prevX = sortedX[i2];
                    prevY = yshifted;
                    ++i2;
                }
                boolean success = firstCrossing != Double.MAX_VALUE;
                params[1] = crossings > 1 ? Math.PI * (double)(crossings - 1) / (lastCrossing - firstCrossing) : Math.PI * (double)Math.max(1, crossings) / (xmax - xmin);
                double phaseToFirstCrossing = success ? params[1] * firstCrossing : 0.0;
                params[2] = posSlope ? -phaseToFirstCrossing : Math.PI - phaseToFirstCrossing;
                return params;
            }
            case "Exponential": {
                double range = sortedX[dataLen - 1] - sortedX[0];
                int mid = (dataLen - 1) / 2;
                while (sortedX[mid] - sortedX[0] < range / 2.0 && mid < dataLen - 1) {
                    ++mid;
                }
                while (sortedX[mid] - sortedX[0] > range / 2.0 && mid > 0) {
                    --mid;
                }
                int tail = Math.min(dataLen - 1, 2 * mid);
                while (sortedX[tail] - sortedX[0] < 2.0 * (sortedX[mid] - sortedX[0]) && tail < dataLen - 1) {
                    ++tail;
                }
                while (sortedX[tail] - sortedX[0] > 2.0 * (sortedX[mid] - sortedX[0]) && tail > 0) {
                    --tail;
                }
                if (exp.contains("+C")) {
                    params[2] = (sortedY[mid] * sortedY[mid] - sortedY[0] * sortedY[tail]) / (2.0 * sortedY[mid] - sortedY[0] - sortedY[tail]);
                    params[2] = Math.min(ymin - 0.001 * range, params[2]);
                }
                double offset = params.length > 2 ? params[2] : 0.0;
                params[1] = Math.log((sortedY[tail] - offset) / (sortedY[0] - offset)) / (sortedX[tail] - sortedX[0]);
                params[0] = (sortedY[mid] - offset) / Math.exp(params[1] * sortedX[mid]);
                return params;
            }
            case "Gaussian": {
                double[] S = new double[dataLen];
                double[] T = new double[dataLen];
                double sumSSq = 0.0;
                double sumTSq = 0.0;
                double sumST = 0.0;
                double sumSy = 0.0;
                double sumTy = 0.0;
                double sumy = sortedY[0];
                T[0] = 0.0;
                S[0] = 0.0;
                int i3 = 1;
                while (i3 < dataLen) {
                    S[i3] = S[i3 - 1] + 0.5 * (sortedY[i3] + sortedY[i3 - 1]) * (sortedX[i3] - sortedX[i3 - 1]);
                    T[i3] = T[i3 - 1] + 0.5 * (sortedX[i3] * sortedY[i3] + sortedX[i3 - 1] * sortedY[i3 - 1]) * (sortedX[i3] - sortedX[i3 - 1]);
                    sumSSq += S[i3] * S[i3];
                    sumST += S[i3] * T[i3];
                    sumTSq += T[i3] * T[i3];
                    sumSy += S[i3] * (sortedY[i3] - sortedY[0]);
                    sumTy += T[i3] * (sortedY[i3] - sortedY[0]);
                    sumy += sortedY[i3];
                    ++i3;
                }
                double[][] matrix = new double[][]{{sumSSq, sumST}, {sumST, sumTSq}};
                LUPDecomposition lupSystem = new LUPDecomposition(matrix);
                double[][] inverse = lupSystem.inverseMatrixComponents();
                if (inverse == null) {
                    return null;
                }
                double[] constants = new double[]{sumSy, sumTy};
                double[] results = lupSystem.solve(constants);
                double a = -results[0] / results[1];
                double b = -2.0 / results[1];
                double sumExp = 0.0;
                int i4 = 1;
                while (i4 < dataLen) {
                    sumExp += Math.exp(-((sortedX[i4] - a) * (sortedX[i4] - a)) / b);
                    ++i4;
                }
                params[0] = sumy / sumExp;
                params[1] = a;
                params[2] = Math.sqrt(b / 2.0);
                return params;
            }
            case "Log": {
                if (xmin <= 0.0) {
                    return null;
                }
                double[] ln = new double[dataLen];
                int i5 = 0;
                while (i5 < dataLen) {
                    ln[i5] = Math.log(sortedX[i5]);
                    ++i5;
                }
                line.fitData(ln, sortedY);
                params[0] = line.getParameterValue(0);
                params[1] = line.getParameterValue(1);
                return params;
            }
            case "Power": {
                if (xmin <= 0.0 || ymin <= 0.0) {
                    return null;
                }
                double[] lnx = new double[dataLen];
                double[] lny = new double[dataLen];
                int i6 = 0;
                while (i6 < dataLen) {
                    lnx[i6] = Math.log(sortedX[i6]);
                    lny[i6] = Math.log(sortedY[i6]);
                    ++i6;
                }
                line.fitData(lnx, lny);
                params[0] = Math.exp(line.getParameterValue(1));
                params[1] = line.getParameterValue(0);
                return params;
            }
        }
        return null;
    }

    private UserFunction getTestFunction(int level) {
        while (this.testFunctions.size() <= level) {
            UserFunction test = new UserFunction(FIT_TEST);
            this.testFunctions.add(test);
        }
        return this.testFunctions.get(level);
    }

    private UserFunction getTestFunction(KnownFunction f, String paramName, double paramVal) {
        int level = 0;
        int i = 0;
        while (i < this.testFunctions.size()) {
            if (this.testFunctions.get(i) == f) {
                level = i + 1;
                break;
            }
            ++i;
        }
        UserFunction testFunction = this.getTestFunction(level);
        int len = f.getParameterCount();
        if (len < 1) {
            return null;
        }
        String[] paramNames = new String[len - 1];
        double[] paramValues = new double[len - 1];
        String[] desc = new String[len - 1];
        int j = 0;
        int i2 = 0;
        while (i2 < len) {
            if (!f.getParameterName(i2).equals(paramName)) {
                paramNames[j] = f.getParameterName(i2);
                paramValues[j] = f.getParameterValue(i2);
                desc[j] = f.getParameterDescription(i2);
                ++j;
            }
            ++i2;
        }
        String expression = f.getExpression("x");
        expression = expression.replace(paramName, "(" + String.valueOf(paramVal) + ")");
        testFunction.setParameters(paramNames, paramValues, desc);
        testFunction.setExpression(expression, new String[]{"x"});
        return testFunction;
    }

    private KnownFunction getTestFunction(KnownFunction f, boolean[] fixedParams) {
        if (fixedParams == null) {
            return f;
        }
        KnownFunction test = f;
        int i = 0;
        while (i < fixedParams.length) {
            if (fixedParams[i]) {
                String paramName = f.getParameterName(i);
                double paramVal = f.getParameterValue(i);
                test = this.getTestFunction(test, paramName, paramVal);
            }
            ++i;
        }
        return test;
    }

    public void doLinearRegression(double[] xd, double[] yd) {
        int n = xd.length;
        this.correlation = Double.NaN;
        if (n < 3) {
            return;
        }
        double mean_x = xd[0];
        double mean_y = yd[0];
        int i = 1;
        while (i < n) {
            mean_x += xd[i];
            mean_y += yd[i];
            ++i;
        }
        mean_x /= (double)n;
        mean_y /= (double)n;
        double sum_sq_x = 0.0;
        double sum_sq_y = 0.0;
        double sum_coproduct = 0.0;
        int i2 = 0;
        while (i2 < n) {
            double delta_x = xd[i2] - mean_x;
            double delta_y = yd[i2] - mean_y;
            sum_sq_x += delta_x * delta_x;
            sum_sq_y += delta_y * delta_y;
            sum_coproduct += delta_x * delta_y;
            ++i2;
        }
        if (sum_sq_x == 0.0 || sum_sq_y == 0.0) {
            this.correlation = Double.NaN;
            this.uncertainties = null;
            return;
        }
        double pop_sd_x = sum_sq_x / (double)n;
        double pop_sd_y = sum_sq_y / (double)n;
        double cov_x_y = sum_coproduct / (double)n;
        this.correlation = cov_x_y * cov_x_y / (pop_sd_x * pop_sd_y);
    }

    private void setUncertainties(double[][] sigmas) {
        this.uncertainties = sigmas == null ? null : sigmas[0];
        this.drawer.setUncertainties(sigmas);
    }

    private KnownFunction getFitFunction(FitFunctionPanel panel) {
        UserFunction f = panel.getFitFunction();
        if (f.polynomial != null) {
            f.updatePolynomial();
            return f.polynomial.clone();
        }
        return f.clone();
    }

    protected void replaceFit(String oldName, String newName, KnownFunction newFit) {
        KnownFunction oldFit = this.fitMap.get(oldName);
        if (oldFit != null) {
            if (this.localFits.contains(oldFit)) {
                this.localFits.remove(oldFit);
                this.localFits.add(newFit);
            }
            this.refreshFitDropDown();
        }
        this.refreshFitMap();
    }

    protected JDialog getColorDialog() {
        if (this.colorDialog == null) {
            final Frame frame = JOptionPane.getFrameForComponent(this);
            final JColorChooser cc = new JColorChooser();
            cc.getSelectionModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DatasetCurveFitter.this.color = cc.getColor();
                    DatasetCurveFitter.this.setColor(DatasetCurveFitter.this.color);
                    frame.repaint();
                }
            });
            this.colorDialog = new JDialog(frame, false);
            this.closeButton = new JButton();
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatasetCurveFitter.this.colorDialog.setVisible(false);
                }
            });
            JPanel contentPane = new JPanel(new BorderLayout());
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this.closeButton);
            AbstractColorChooserPanel chooser = cc.getChooserPanels()[0];
            chooser.setBorder(BorderFactory.createEmptyBorder(2, 2, 12, 2));
            contentPane.add((Component)chooser, "Center");
            contentPane.add((Component)buttonPanel, "South");
            this.colorDialog.setContentPane(contentPane);
            this.colorDialog.pack();
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.colorDialog.getWidth()) / 2;
            Point p = this.getLocationOnScreen();
            int y = Math.max(0, p.y - this.colorDialog.getHeight());
            this.colorDialog.setLocation(x, y);
        }
        return this.colorDialog;
    }

    public static void setDefaultFitFunctions(ArrayList<KnownFunction> functions) {
        if (functions != null) {
            defaultFits = functions;
        }
    }

    public void getFits(Map<String, KnownFunction> fits, ArrayList<String> fitnames) {
        int i = 0;
        while (i < this.fitDropDown.getItemCount()) {
            String name = this.fitDropDown.getItemAt(i).toString();
            if (!fitnames.contains(name)) {
                fitnames.add(name);
                fits.put(name, this.fitMap.get(name));
            }
            ++i;
        }
    }

    public String[] getFitNames() {
        int n = this.fitDropDown.getItemCount();
        String[] names = new String[n];
        int i = 0;
        while (i < n) {
            names[i] = this.fitDropDown.getItemAt(i).toString();
            ++i;
        }
        return names;
    }

    public void setSelectedItem(String fitName) {
        this.fitDropDown.setSelectedItem(fitName);
    }

    public void setText(String text) {
        this.eqnField.setText(text);
    }

    boolean hasFit(String name) {
        return this.fitMap.containsKey(name);
    }

    void notifyTabRemoved() {
        this.fitBuilder.removePropertyChangeListener(this.fitListener);
    }

    public void setFitVisible(boolean vis) {
        this.getDrawer().setEnabled(vis);
    }

    public class MinimizeMultiVarFunction
    implements MultiVarFunction {
        MultiVarFunction f;
        double[] x;
        double[] y;
        double[] vars = new double[5];

        MinimizeMultiVarFunction(MultiVarFunction f, double[] x, double[] y) {
            this.f = f;
            this.x = x;
            this.y = y;
        }

        @Override
        public double evaluate(double[] params) {
            System.arraycopy(params, 0, this.vars, 1, 4);
            double sum = 0.0;
            int i = 0;
            int n = this.x.length;
            while (i < n) {
                this.vars[0] = this.x[i];
                double dev = this.y[i] - this.f.evaluate(this.vars);
                sum += dev * dev;
                ++i;
            }
            return sum;
        }
    }

    public class MinimizeUserFunction
    implements MultiVarFunction {
        UserFunction f;
        double[] x;
        double[] y;

        MinimizeUserFunction(UserFunction f, double[] x, double[] y) {
            this.f = f;
            this.x = x;
            this.y = y;
        }

        @Override
        public double evaluate(double[] params) {
            int i = 0;
            while (i < params.length) {
                this.f.setParameterValue(i, params[i]);
                ++i;
            }
            double sum = 0.0;
            int i2 = 0;
            while (i2 < this.x.length) {
                double dev = this.y[i2] - this.f.evaluate(this.x[i2]);
                sum += dev * dev;
                ++i2;
            }
            return sum;
        }
    }

    static class NumberField
    extends JTextField {
        protected DecimalFormat format = (DecimalFormat)NumberFormat.getInstance();
        protected double prevValue;
        protected String pattern = "0";
        protected int preferredWidth;

        public NumberField(int columns) {
            super(columns);
            this.setForeground(Color.black);
        }

        public double getValue() {
            double retValue;
            if (this.getText().equals(this.format.format(this.prevValue))) {
                return this.prevValue;
            }
            try {
                retValue = this.format.parse(this.getText()).doubleValue();
            }
            catch (ParseException e) {
                Toolkit.getDefaultToolkit().beep();
                this.setValue(this.prevValue);
                return this.prevValue;
            }
            return retValue;
        }

        public void setValue(double value) {
            if (!this.isVisible()) {
                return;
            }
            this.format.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
            this.setText(this.format.format(value));
            this.prevValue = value;
        }

        public void applyPattern(String pattern) {
            if (this.format instanceof DecimalFormat) {
                try {
                    this.format.applyPattern(pattern);
                    this.pattern = pattern;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void applyDefaultPattern(boolean sciNotation) {
            if (sciNotation) {
                this.applyPattern("0.000E0");
            } else {
                this.applyPattern("0.###");
            }
        }

        public String getPattern() {
            return this.pattern;
        }

        public NumberFormat getFormat() {
            return this.format;
        }

        protected void refreshPreferredWidth() {
            Rectangle2D rect = this.getFont().getStringBounds(this.getText(), OSPRuntime.frc);
            this.preferredWidth = (int)rect.getWidth() + 8;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.width = Math.max(dim.width, this.preferredWidth);
            return dim;
        }
    }

    class ParamCellRenderer
    extends JLabel
    implements TableCellRenderer {
        Color lightBlue = new Color(204, 204, 255);
        Color lightGray = UIManager.getColor("Panel.background");
        Font fieldFont = new JTextField().getFont();
        Font labelFont = this.getFont();
        private boolean notApplicable;

        public ParamCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 2));
        }

        private boolean isApplicable() {
            return !DatasetCurveFitter.this.autofit || !this.notApplicable;
        }

        public void setNotApplicable(boolean b) {
            this.notApplicable = b;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setHorizontalAlignment(2);
            this.setBorder(new CellBorder(new Color(240, 240, 240)));
            String tooltip = "";
            if (value instanceof String) {
                this.setFont(this.labelFont);
                this.setBackground(isSelected ? Color.LIGHT_GRAY : this.lightGray);
                this.setForeground(Color.black);
                this.setText(value.toString());
                if (col == 0) {
                    tooltip = DatasetCurveFitter.this.fit.getParameterDescription(row);
                }
            } else if (value instanceof Double) {
                this.setFont(this.fieldFont);
                this.setBackground(!this.isApplicable() ? Color.YELLOW : (isSelected ? this.lightBlue : Color.white));
                this.setForeground(isSelected ? Color.red : (table.isEnabled() ? Color.black : Color.gray));
                DecimalFormat format = ((DatasetCurveFitter)DatasetCurveFitter.this).spinCellEditor.field.format;
                format.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
                double uncertainty = DatasetCurveFitter.this.getUncertainty(row);
                String[] uncert = DatasetCurveFitter.this.formatUncertainParameter((Double)value, uncertainty, 0, format);
                if (Double.isNaN((Double)value)) {
                    tooltip = ToolsRes.getString("DatasetCurveFitter.InsufficientData.ToolTip");
                } else if (!DatasetCurveFitter.this.autofit) {
                    tooltip = String.valueOf(ToolsRes.getString("DatasetCurveFitter.SE.Name")) + " " + ToolsRes.getString("DatasetCurveFitter.SE.Autofit");
                } else if (uncert != null) {
                    String desc = DatasetCurveFitter.this.fit.getParameterDescription(row);
                    String val = String.valueOf(DatasetCurveFitter.this.fit.getParameterName(row)) + " = " + uncert[1];
                    tooltip = desc == null ? val : String.valueOf(desc) + " " + val;
                } else {
                    tooltip = String.valueOf(ToolsRes.getString("DatasetCurveFitter.SE.Name")) + " " + ToolsRes.getString("DatasetCurveFitter.SE.Unknown");
                }
                this.setText(this.isApplicable() ? (uncert != null ? uncert[0] : format.format(value)) : "     ---------------");
            }
            this.setToolTipText(tooltip);
            return this;
        }
    }

    class ParamTable
    extends JTable {
        public ParamTable(ParamTableModel model) {
            super(model);
            this.setGridColor(Color.blue);
            JTableHeader header = this.getTableHeader();
            header.setForeground(Color.blue);
            MouseAdapter listener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (OSPRuntime.isPopupTrigger(e)) {
                        ParamTable.this.showPopup(e);
                    }
                }
            };
            this.addMouseListener(listener);
            header.addMouseListener(listener);
        }

        public void showPopup(MouseEvent e) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem item = new JMenuItem(ToolsRes.getString("DatasetCurveFitter.Menuitem.CopyParameters"));
            item.addActionListener(ev -> {
                this.selectAll();
                ActionEvent event = new ActionEvent(DatasetCurveFitter.this.paramTable, 1001, null);
                this.getActionMap().get("copy").actionPerformed(event);
            });
            popup.add(item);
            popup.addSeparator();
            JCheckBoxMenuItem scientificNotationItem = new JCheckBoxMenuItem("Scientific notation");
            scientificNotationItem.setSelected(!isFixedDecimalFormat);
            ((DatasetCurveFitter)DatasetCurveFitter.this).spinCellEditor.field.applyDefaultPattern(!isFixedDecimalFormat);
            scientificNotationItem.addActionListener(ev -> {
                isFixedDecimalFormat = !scientificNotationItem.isSelected();
                ((DatasetCurveFitter)DatasetCurveFitter.this).spinCellEditor.field.applyDefaultPattern(!isFixedDecimalFormat);
                this.repaint();
            });
            popup.add(scientificNotationItem);
            FontSizer.setFonts(popup);
            popup.show(e.getComponent(), e.getX(), e.getY() - popup.getPreferredSize().height);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 1) {
                return this.getDefaultRenderer(this.getColumnClass(column));
            }
            return DatasetCurveFitter.this.cellRenderer;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 1) {
                return this.getDefaultEditor(this.getColumnClass(column));
            }
            if (Double.isNaN((Double)this.getValueAt(row, 2))) {
                return null;
            }
            ((DatasetCurveFitter)DatasetCurveFitter.this).spinCellEditor.rowNumber = row;
            Timer timer = new Timer(10, e -> ((DatasetCurveFitter)DatasetCurveFitter.this).spinCellEditor.field.selectAll());
            timer.setRepeats(false);
            timer.start();
            return DatasetCurveFitter.this.spinCellEditor;
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (DatasetCurveFitter.this.cellRenderer != null) {
                Font aFont = ((DatasetCurveFitter)DatasetCurveFitter.this).cellRenderer.labelFont;
                ((DatasetCurveFitter)DatasetCurveFitter.this).cellRenderer.labelFont = aFont = aFont.deriveFont(font.getSize2D());
                ((DatasetCurveFitter)DatasetCurveFitter.this).spinCellEditor.stepSizeLabel.setFont(aFont);
                aFont = ((DatasetCurveFitter)DatasetCurveFitter.this).cellRenderer.fieldFont;
                ((DatasetCurveFitter)DatasetCurveFitter.this).cellRenderer.fieldFont = aFont = aFont.deriveFont(font.getSize2D());
                ((DatasetCurveFitter)DatasetCurveFitter.this).spinCellEditor.field.setFont(aFont);
            }
            this.getTableHeader().setFont(font);
            this.setRowHeight(font.getSize() + 4);
            TableModel model = this.getModel();
            if (model instanceof DefaultTableModel) {
                DefaultTableModel tm = (DefaultTableModel)model;
                tm.fireTableDataChanged();
            }
        }
    }

    class ParamTableModel
    extends AbstractTableModel {
        ParamTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return col == 0 ? ToolsRes.getString("Table.Heading.Parameter") : (col == 1 ? ToolsRes.getString("DatasetCurveFitter.Table.Heading.FixedParam") : ToolsRes.getString("Table.Heading.Value"));
        }

        @Override
        public int getRowCount() {
            return DatasetCurveFitter.this.fit == null ? 0 : DatasetCurveFitter.this.fit.getParameterCount();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return DatasetCurveFitter.this.fit.getParameterName(row);
            }
            if (col == 1) {
                boolean[] fixed = (boolean[])DatasetCurveFitter.this.fixedParams.get(DatasetCurveFitter.this.fit);
                return fixed == null || fixed.length < row + 1 ? false : fixed[row];
            }
            if (DatasetCurveFitter.this.dataset == null || DatasetCurveFitter.this.autofit && DatasetCurveFitter.this.fit.getParameterCount() > DatasetCurveFitter.this.dataset.getValidXPoints().length) {
                return Double.NaN;
            }
            return DatasetCurveFitter.this.fit.getParameterValue(row);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            boolean[] fixed;
            if (col == 1 && (fixed = (boolean[])DatasetCurveFitter.this.fixedParams.get(DatasetCurveFitter.this.fit)) != null && fixed.length > row) {
                fixed[row] = (Boolean)value;
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Boolean.class;
                }
            }
            return Double.class;
        }
    }

    class SpinCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JPanel panel = new JPanel(new BorderLayout());
        SpinnerNumberCrawlerModel crawlerModel;
        JSpinner spinner;
        NumberField field;
        int rowNumber;
        JLabel stepSizeLabel;

        SpinCellEditor() {
            this.crawlerModel = new SpinnerNumberCrawlerModel(1.0);
            this.stepSizeLabel = new JLabel("10%");
            this.panel.setOpaque(false);
            this.spinner = new JSpinner(this.crawlerModel);
            this.spinner.setToolTipText(ToolsRes.getString("Table.Spinner.ToolTip"));
            this.spinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean[] fixed = (boolean[])DatasetCurveFitter.this.fixedParams.get(((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit);
                    if (!fixed[SpinCellEditor.this.rowNumber]) {
                        DatasetCurveFitter.this.setAutoFit(false);
                    }
                    double val = (Double)SpinCellEditor.this.spinner.getValue();
                    SpinCellEditor.this.field.setValue(val);
                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit.setParameterValue(SpinCellEditor.this.rowNumber, val);
                    if (((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit instanceof UserFunction) {
                        UserFunction f = (UserFunction)((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit;
                        String name = f.getName();
                        FitFunctionPanel panel = (FitFunctionPanel)DatasetCurveFitter.this.fitBuilder.getPanel(name);
                        if (panel != null) {
                            name = f.getParameterName(SpinCellEditor.this.rowNumber);
                            Parameter seed = new Parameter(name, SpinCellEditor.this.field.getText());
                            block0: for (Parameter p : panel.getParamEditor().evaluateDependents(seed)) {
                                int i = 0;
                                while (i < f.getParameterCount()) {
                                    if (f.getParameterName(i).equals(p.getName())) {
                                        f.setParameterValue(i, p.getValue());
                                        ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.paramModel.fireTableCellUpdated(i, 1);
                                        continue block0;
                                    }
                                    ++i;
                                }
                            }
                            panel.getFitFunctionEditor().parametersValid = false;
                            f.updateReferenceParameters();
                        }
                    }
                    ((DatasetCurveFitter)((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this).drawer.functionChanged = true;
                    DatasetCurveFitter.this.fit(((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit);
                    DatasetCurveFitter.this.firePropertyChange(DatasetCurveFitter.PROPERTY_DATASETCURVEFITTER_CHANGED, null, null);
                }
            });
            this.field = new NumberField(10);
            this.field.applyDefaultPattern(!isFixedDecimalFormat);
            this.field.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, 0));
            this.spinner.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 0));
            this.spinner.setEditor(this.field);
            this.stepSizeLabel.addMouseListener(new MouseInputAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    JPopupMenu popup = new JPopupMenu();
                    ActionListener listener = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            double percent = Double.parseDouble(e.getActionCommand());
                            (this).SpinCellEditor.this.crawlerModel.setPercentDelta(percent);
                            (this).SpinCellEditor.this.crawlerModel.refreshDelta();
                            (this).SpinCellEditor.this.stepSizeLabel.setText(String.valueOf(e.getActionCommand()) + "%");
                        }
                    };
                    int i = 0;
                    while (i < 3) {
                        String val = i == 0 ? "10" : (i == 1 ? "1.0" : "0.1");
                        JMenuItem item = new JMenuItem(String.valueOf(val) + "%");
                        item.setActionCommand(val);
                        item.addActionListener(listener);
                        popup.add(item);
                        ++i;
                    }
                    popup.show(SpinCellEditor.this.stepSizeLabel, 0, SpinCellEditor.this.stepSizeLabel.getHeight());
                }
            });
            this.field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    JComponent comp = (JComponent)e.getSource();
                    if (e.getKeyCode() == 10) {
                        SpinCellEditor.this.spinner.setValue(SpinCellEditor.this.field.getValue());
                        comp.setBackground(Color.white);
                        SpinCellEditor.this.crawlerModel.refreshDelta();
                    } else {
                        comp.setBackground(Color.yellow);
                    }
                }
            });
            this.panel.add((Component)this.spinner, "Center");
            this.panel.add((Component)this.stepSizeLabel, "East");
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.spinner.setValue(value);
            this.crawlerModel.refreshDelta();
            return this.panel;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            return e instanceof MouseEvent || e instanceof ActionEvent;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.field.getBackground() == Color.yellow) {
                DatasetCurveFitter.this.fit.setParameterValue(this.rowNumber, this.field.getValue());
                ((DatasetCurveFitter)DatasetCurveFitter.this).drawer.functionChanged = true;
                DatasetCurveFitter.this.firePropertyChange(DatasetCurveFitter.PROPERTY_DATASETCURVEFITTER_FIT, null, null);
                this.field.setBackground(Color.white);
                DatasetCurveFitter.this.firePropertyChange(DatasetCurveFitter.PROPERTY_DATASETCURVEFITTER_CHANGED, null, null);
            }
            return null;
        }
    }

    class SpinnerNumberCrawlerModel
    extends AbstractSpinnerModel {
        double val = 0.0;
        double delta;
        double percentDelta = 10.0;

        public SpinnerNumberCrawlerModel(double initialDelta) {
            this.delta = initialDelta;
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public Object getNextValue() {
            return this.val + this.delta;
        }

        @Override
        public Object getPreviousValue() {
            return this.val - this.delta;
        }

        @Override
        public void setValue(Object value) {
            if (value != null) {
                this.val = (Double)value;
                this.fireStateChanged();
            }
        }

        public void setPercentDelta(double percent) {
            this.percentDelta = percent;
        }

        public double getPercentDelta() {
            return this.percentDelta;
        }

        public void refreshDelta() {
            if (this.val != 0.0) {
                this.delta = Math.abs(this.val * this.percentDelta / 100.0);
            }
        }
    }
}

