/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.FontSizer;

public class DiagnosticsForThreads
extends JPanel {
    private ThreadViewerTableModel tableModel = new ThreadViewerTableModel();

    public DiagnosticsForThreads() {
        JTable table = new JTable(this.tableModel);
        table.setAutoResizeMode(3);
        FontSizer.setFonts(table, FontSizer.getLevel());
        Font font = table.getFont();
        table.setRowHeight(font.getSize() + 4);
        table.getTableHeader().setFont(font);
        TableColumnModel colModel = table.getColumnModel();
        int numColumns = colModel.getColumnCount();
        int i = 0;
        while (i < numColumns - 1) {
            TableColumn col = colModel.getColumn(i);
            col.sizeWidthToFit();
            col.setPreferredWidth(col.getWidth() + 5);
            col.setMaxWidth(col.getWidth() + 5);
            ++i;
        }
        JScrollPane sp = new JScrollPane(table);
        this.setLayout(new BorderLayout());
        this.add((Component)sp, "Center");
    }

    public void dispose() {
        this.tableModel.stopRequest();
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public static void aboutThreads() {
        JDialog dialog = new JDialog();
        DiagnosticsForThreads viewer = new DiagnosticsForThreads();
        dialog.setContentPane(viewer);
        int level = FontSizer.getLevel();
        int w = (int)(600.0 * (1.0 + (double)level * 0.2));
        int h = (int)(300.0 * (1.0 + (double)level * 0.2));
        dialog.setSize(w, h);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - dialog.getBounds().width) / 2;
        int y = (dim.height - dialog.getBounds().height) / 2;
        dialog.setLocation(x, y);
        dialog.setTitle("Threads");
        dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Object lock;
        JFrame f = new JFrame();
        DiagnosticsForThreads viewer = new DiagnosticsForThreads();
        f.setContentPane(viewer);
        f.setSize(500, 300);
        f.setVisible(true);
        f.setDefaultCloseOperation(1);
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static class ThreadViewerTableModel
    extends AbstractTableModel {
        private Object dataLock;
        private int rowCount = 0;
        private Object[][] cellData = new Object[0][0];
        private Object[][] pendingCellData;
        private final int columnCount;
        private final String[] columnName;
        private final Class[] columnClass;
        private Thread internalThread;
        private volatile boolean noStopRequested;

        public ThreadViewerTableModel() {
            String[] names = new String[]{"Priority", "Alive", "Daemon", "Interrupted", "ThreadGroup", "Thread Name"};
            this.columnName = names;
            Class[] classes = new Class[]{Integer.class, Boolean.class, Boolean.class, Boolean.class, String.class, String.class};
            this.columnClass = classes;
            this.columnCount = this.columnName.length;
            this.dataLock = new Object();
            this.noStopRequested = true;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        this.runWork();
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
            };
            if (OSPRuntime.isJS) {
                System.err.println("Warning:  Diagnostics for Threads are not supported in JavaScript.");
            } else {
                this.internalThread = new Thread(r, "ThreadViewer");
                this.internalThread.setPriority(8);
                this.internalThread.setDaemon(true);
                this.internalThread.start();
            }
        }

        private void runWork() {
            Runnable transferPending = new Runnable(){

                @Override
                public void run() {
                    this.transferPendingCellData();
                    this.fireTableDataChanged();
                }
            };
            while (this.noStopRequested) {
                try {
                    this.createPendingCellData();
                    SwingUtilities.invokeAndWait(transferPending);
                    Thread.sleep(5000L);
                }
                catch (InvocationTargetException tx) {
                    tx.printStackTrace();
                    this.stopRequest();
                }
                catch (InterruptedException x) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public void stopRequest() {
            this.noStopRequested = false;
            this.internalThread.interrupt();
        }

        public boolean isAlive() {
            return this.internalThread.isAlive();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createPendingCellData() {
            Thread[] thread = ThreadViewerTableModel.findAllThreads();
            Object[][] cell = new Object[thread.length][this.columnCount];
            int i = 0;
            while (i < thread.length) {
                Thread t = thread[i];
                Object[] rowCell = cell[i];
                rowCell[0] = t.getPriority();
                rowCell[1] = t.isAlive();
                rowCell[2] = t.isDaemon();
                rowCell[3] = t.isInterrupted();
                rowCell[4] = t.getThreadGroup().getName();
                rowCell[5] = t.getName();
                ++i;
            }
            Object object = this.dataLock;
            synchronized (object) {
                this.pendingCellData = cell;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transferPendingCellData() {
            Object object = this.dataLock;
            synchronized (object) {
                this.cellData = this.pendingCellData;
                this.rowCount = this.cellData.length;
            }
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.cellData[row][col];
        }

        @Override
        public int getColumnCount() {
            return this.columnCount;
        }

        @Override
        public Class<?> getColumnClass(int columnIdx) {
            return this.columnClass[columnIdx];
        }

        @Override
        public String getColumnName(int columnIdx) {
            return this.columnName[columnIdx];
        }

        public static Thread[] findAllThreads() {
            ThreadGroup group;
            ThreadGroup topGroup = group = Thread.currentThread().getThreadGroup();
            while (group != null) {
                topGroup = group;
                group = group.getParent();
            }
            int estimatedSize = topGroup.activeCount() * 2;
            Thread[] slackList = new Thread[estimatedSize];
            int actualSize = topGroup.enumerate(slackList);
            Thread[] list = new Thread[actualSize];
            System.arraycopy(slackList, 0, list, 0, actualSize);
            return list;
        }
    }
}

