/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.LineNumberReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Vector;
import javajs.async.AsyncFileChooser;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;

public class EjsTool {
    private static final String INFO_FILE = ".Ejs.txt";
    public static final String GET_MODEL_METHOD = "_getEjsModel";
    public static final String GET_RESOURCES_METHOD = "_getEjsResources";
    public static final String GET_APPLET_DIMENSION_METHOD = "_getEjsAppletDimension";
    private static ResourceLoader.Bundle res;

    static {
        EjsTool.setLocale(null);
    }

    public static void setLocale(Locale locale) {
        res = ResourceLoader.getBundle(null, locale);
    }

    public static String getString(String key) {
        try {
            return res.getString(key);
        }
        catch (MissingResourceException e) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static boolean hasEjsModel(Class<?> _ejsClass) {
        try {
            Class[] c = new Class[]{};
            Method getModelMethod = _ejsClass.getMethod(GET_MODEL_METHOD, c);
            return getModelMethod != null;
        }
        catch (Exception _exc) {
            return false;
        }
    }

    public static Dimension getEjsAppletDimension(Class<?> _ejsClass) {
        Method getDimensionMethod;
        block3: {
            try {
                Class[] c = new Class[]{};
                getDimensionMethod = _ejsClass.getMethod(GET_APPLET_DIMENSION_METHOD, c);
                if (getDimensionMethod != null) break block3;
                return null;
            }
            catch (Exception _exc) {
                return null;
            }
        }
        Object[] o = new Object[]{};
        return (Dimension)getDimensionMethod.invoke(null, o);
    }

    public static boolean runEjs(Class<?> _ejsClass) {
        return EjsTool.runEjs(_ejsClass, null);
    }

    public static boolean runEjs(Class<?> _ejsClass, String _password) {
        try {
            Class[] c = new Class[]{};
            Method getModelMethod = _ejsClass.getMethod(GET_MODEL_METHOD, c);
            Method getResourcesMethod = _ejsClass.getMethod(GET_RESOURCES_METHOD, c);
            Object[] o = new Object[]{};
            String model = (String)getModelMethod.invoke(null, o);
            Set list = getResourcesMethod != null ? (Set)getResourcesMethod.invoke(null, o) : new HashSet();
            return EjsTool.doRunEjs(model, list, _ejsClass, _password);
        }
        catch (Exception _exc) {
            _exc.printStackTrace();
            String[] message = new String[]{res.getString("EjsTool.EjsNotRunning"), String.valueOf(res.getString("EjsTool.NoModel")) + " " + _ejsClass.getName()};
            JOptionPane.showMessageDialog(null, message, res.getString("EjsTool.Error"), 2);
            return false;
        }
    }

    public static void saveInformation(String _home, String _release) {
        try {
            String filename = System.getProperty("user.home").replace('\\', '/');
            if (!filename.endsWith("/")) {
                filename = String.valueOf(filename) + "/";
            }
            filename = String.valueOf(filename) + INFO_FILE;
            String dir = System.getProperty("user.dir");
            FileWriter fout = new FileWriter(filename);
            fout.write("directory = " + dir + "\n");
            fout.write("home = " + _home + "\n");
            fout.write("version = " + _release + "\n");
            fout.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public static void saveInformation(String _binDirectoryPath, String _sourceDirectoryPath, String _release) {
        try {
            String filename = System.getProperty("user.home").replace('\\', '/');
            if (!filename.endsWith("/")) {
                filename = String.valueOf(filename) + "/";
            }
            FileWriter fout = new FileWriter(String.valueOf(filename) + INFO_FILE);
            fout.write("ejs_root_directory = " + _binDirectoryPath + "\n");
            fout.write("source_directory = " + _sourceDirectoryPath + "\n");
            fout.write("version = " + _release + "\n");
            fout.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public static String getPath(File _file) {
        int a;
        String path;
        try {
            path = _file.getCanonicalPath();
        }
        catch (Exception exc) {
            path = _file.getAbsolutePath();
        }
        if (OSPRuntime.isWindows() && (a = (path = path.replace('\\', '/')).indexOf(58)) > 0) {
            path = String.valueOf(path.substring(0, a).toUpperCase()) + path.substring(a);
        }
        if (_file.isDirectory() && !path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        return path;
    }

    private static boolean doRunEjs(String _model, Set<String> _resources, Class<?> _ejsClass, final String _password) {
        File sourceDir;
        Component parentComponent;
        File ejsRootDirectory;
        String sourceDirPath;
        String ejsRootDirPath;
        block33: {
            int index;
            ejsRootDirPath = null;
            sourceDirPath = null;
            String version = null;
            ejsRootDirectory = null;
            parentComponent = null;
            String filename = System.getProperty("user.home").replace('\\', '/');
            if (!filename.endsWith("/")) {
                filename = String.valueOf(filename) + "/";
            }
            FileReader reader = new FileReader(String.valueOf(filename) + INFO_FILE);
            LineNumberReader l = new LineNumberReader(reader);
            String sl = l.readLine();
            while (sl != null) {
                if (sl.startsWith("ejs_root_directory = ")) {
                    ejsRootDirPath = sl.substring("ejs_root_directory = ".length()).trim();
                } else if (sl.startsWith("source_directory = ")) {
                    sourceDirPath = sl.substring("source_directory = ".length()).trim();
                } else if (sl.startsWith("version = ")) {
                    version = sl.substring("version = ".length()).trim();
                }
                sl = l.readLine();
            }
            ((Reader)reader).close();
            int major = 3;
            if (version != null && (index = version.indexOf(46)) >= 0) {
                major = Integer.parseInt(version.substring(0, index));
            }
            if (major >= 4) break block33;
            JOptionPane.showMessageDialog(parentComponent, String.valueOf(version) + " " + res.getString("EjsTool.IncorrectVersion"), res.getString("EjsTool.Error"), 0);
            return false;
        }
        try {
            ejsRootDirectory = new File(ejsRootDirPath);
            if (!new File(ejsRootDirectory, "EjsConsole.jar").exists()) {
                ejsRootDirectory = null;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            ejsRootDirectory = null;
        }
        if (ejsRootDirectory == null) {
            AsyncFileChooser chooser = OSPRuntime.createChooser("", new String[0]);
            chooser.setDialogTitle(res.getString("EjsTool.EjsNotFound"));
            chooser.setFileSelectionMode(1);
            chooser.setMultiSelectionEnabled(false);
            JTextArea textArea = new JTextArea(res.getString("EjsTool.IndicateRootDir"));
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            textArea.setEditable(false);
            textArea.setFont(textArea.getFont().deriveFont(1));
            textArea.setPreferredSize(new Dimension(150, 60));
            textArea.setBackground(chooser.getBackground());
            textArea.setBorder(new EmptyBorder(5, 10, 0, 0));
            chooser.setAccessory(textArea);
            while (ejsRootDirectory == null) {
                if (((JFileChooser)chooser).showOpenDialog(null) != 0) {
                    return false;
                }
                ejsRootDirectory = chooser.getSelectedFile();
                if (ejsRootDirectory == null) {
                    return false;
                }
                if (new File(ejsRootDirectory, "EjsConsole.jar").exists()) continue;
                ejsRootDirectory = null;
            }
        }
        if (!(sourceDir = new File(sourceDirPath)).exists()) {
            sourceDir.mkdirs();
        }
        ArrayList<String> extractList = new ArrayList<String>();
        String modelPath = _model;
        int modelPathLength = 0;
        int index = modelPath.lastIndexOf(47);
        if (index >= 0) {
            _model = "./" + modelPath.substring(index + 1);
            modelPath = modelPath.substring(0, index + 1);
            modelPathLength = modelPath.length();
        }
        if (!_resources.contains(_model)) {
            _resources.add(_model);
        }
        if (modelPathLength > 0) {
            for (String res : _resources) {
                extractList.add(res.startsWith(modelPath) ? "./" + res.substring(modelPathLength) : res);
            }
        } else {
            extractList.addAll(_resources);
        }
        Collections.sort(extractList);
        JPanel auxPanel = new JPanel(new BorderLayout());
        JCheckBox originalPathBox = new JCheckBox(res.getString("EjsTool.KeepOriginalPath"), false);
        JTextField originalPathField = new JTextField(modelPath);
        originalPathField.setEditable(false);
        JPanel originalPathPanel = new JPanel(new BorderLayout());
        originalPathPanel.add((Component)originalPathBox, "West");
        originalPathPanel.add((Component)originalPathField, "Center");
        JCheckBox quitCheckBox = null;
        if (!OSPRuntime.appletMode) {
            quitCheckBox = new JCheckBox(res.getString("EjsTool.QuitSimulation"), true);
            auxPanel.add((Component)quitCheckBox, "North");
        }
        auxPanel.add((Component)originalPathPanel, "Center");
        List<Object> finalList = EjsTool.ejsConfirmList(parentComponent, new Dimension(400, 400), res.getString("EjsTool.ExtractingFiles"), res.getString("EjsTool.Message"), extractList, auxPanel);
        if (finalList == null) {
            return false;
        }
        File destinationDirectory = null;
        String relativeDir = "";
        if (originalPathBox.isSelected()) {
            destinationDirectory = new File(sourceDir, modelPath);
            relativeDir = modelPath;
        } else {
            AsyncFileChooser chooser = OSPRuntime.createChooser("", new String[0]);
            chooser.setDialogTitle(res.getString("EjsTool.ChooseDestinationDirectory"));
            chooser.setFileSelectionMode(1);
            chooser.setMultiSelectionEnabled(false);
            chooser.setCurrentDirectory(sourceDir);
            sourceDirPath = EjsTool.getPath(sourceDir);
            while (destinationDirectory == null) {
                if (((JFileChooser)chooser).showOpenDialog(null) != 0) {
                    return false;
                }
                destinationDirectory = chooser.getSelectedFile();
                if (destinationDirectory == null) {
                    return false;
                }
                String destDirPath = EjsTool.getPath(destinationDirectory);
                if (!destDirPath.startsWith(sourceDirPath)) {
                    JOptionPane.showMessageDialog(parentComponent, res.getString("EjsTool.MustBeUnderSource"), res.getString("EjsTool.Error"), 0);
                    destinationDirectory = null;
                    continue;
                }
                relativeDir = destDirPath.substring(sourceDirPath.length());
            }
        }
        String err = ResourceLoader.extractFiles(modelPath, sourceDir, finalList, destinationDirectory);
        if (err != null) {
            String[] message = new String[]{res.getString("JarTool.FileNotExtracted"), String.valueOf(err) + " " + res.getString("JarTool.FileNotExtractedFrom") + " " + _ejsClass.toString()};
            JOptionPane.showMessageDialog(null, message, res.getString("JarTool.Error"), 2);
            return false;
        }
        final String theModel = String.valueOf(relativeDir) + (_model.startsWith("./") ? _model.substring(2) : _model);
        final File theDir = ejsRootDirectory;
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    Vector<String> cmd = new Vector<String>();
                    String javaHome = System.getProperty("java.home");
                    if (javaHome != null) {
                        cmd.add(String.valueOf(javaHome) + File.separator + "bin" + File.separator + "java");
                    } else {
                        cmd.add("java");
                    }
                    cmd.add("-jar");
                    cmd.add("EjsConsole.jar");
                    if (_password != null && _password.length() > 0) {
                        cmd.add("-launcher.password");
                        cmd.add("\"" + _password + "\"");
                    }
                    cmd.add("-file");
                    cmd.add(theModel);
                    String[] cmdarray = cmd.toArray(new String[0]);
                    Process proc = Runtime.getRuntime().exec(cmdarray, null, theDir);
                    proc.waitFor();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        };
        if (OSPRuntime.isJS) {
            System.err.println("Warning:  EJSTool not supported in JavaScript.");
        } else {
            Thread thread = new Thread(runner);
            thread.setPriority(5);
            thread.start();
        }
        return quitCheckBox == null ? false : quitCheckBox.isSelected();
    }

    public static List<Object> ejsConfirmList(Component _target, Dimension _size, String _message, String _title, List<?> _list) {
        return EjsTool.ejsConfirmList(_target, _size, _message, _title, _list, null);
    }

    public static List<Object> ejsConfirmList(Component _target, Dimension _size, String _message, String _title, List<?> _list, JComponent _bottomComponent) {
        class ReturnValue {
            boolean value = false;

            ReturnValue() {
            }
        }
        final ReturnValue returnValue = new ReturnValue();
        final DefaultListModel listModel = new DefaultListModel();
        int i = 0;
        int n = _list.size();
        while (i < n) {
            listModel.addElement(_list.get(i));
            ++i;
        }
        final JList list = new JList(listModel);
        list.setEnabled(true);
        list.setSelectionMode(2);
        list.setSelectionInterval(0, listModel.getSize() - 1);
        JScrollPane scrollPane = new JScrollPane(list);
        scrollPane.setPreferredSize(_size);
        final JDialog dialog = new JDialog();
        MouseAdapter mouseListener = new MouseAdapter(){
            {
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                AbstractButton button = (AbstractButton)evt.getSource();
                String aCmd = button.getActionCommand();
                if (aCmd.equals("ok")) {
                    returnValue.value = true;
                    dialog.setVisible(false);
                } else if (aCmd.equals("cancel")) {
                    returnValue.value = false;
                    dialog.setVisible(false);
                } else if (aCmd.equals("selectall")) {
                    list.setSelectionInterval(0, listModel.getSize() - 1);
                } else if (aCmd.equals("selectnone")) {
                    list.removeSelectionInterval(0, listModel.getSize() - 1);
                }
            }
        };
        JButton okButton = new JButton(DisplayRes.getString("GUIUtils.Ok"));
        okButton.setActionCommand("ok");
        okButton.addMouseListener(mouseListener);
        JButton cancelButton = new JButton(DisplayRes.getString("GUIUtils.Cancel"));
        cancelButton.setActionCommand("cancel");
        cancelButton.addMouseListener(mouseListener);
        JButton excludeButton = new JButton(DisplayRes.getString("GUIUtils.SelectAll"));
        excludeButton.setActionCommand("selectall");
        excludeButton.addMouseListener(mouseListener);
        JButton includeButton = new JButton(DisplayRes.getString("GUIUtils.SelectNone"));
        includeButton.setActionCommand("selectnone");
        includeButton.addMouseListener(mouseListener);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(okButton);
        buttonPanel.add(excludeButton);
        buttonPanel.add(includeButton);
        buttonPanel.add(cancelButton);
        JPanel topPanel = new JPanel(new BorderLayout());
        JTextArea textArea = new JTextArea(_message);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        textArea.setFont(textArea.getFont().deriveFont(1));
        textArea.setBackground(topPanel.getBackground());
        textArea.setBorder(new EmptyBorder(5, 5, 10, 5));
        topPanel.setBorder(new EmptyBorder(5, 10, 5, 10));
        topPanel.add((Component)textArea, "North");
        topPanel.add((Component)scrollPane, "Center");
        if (_bottomComponent != null) {
            topPanel.add((Component)_bottomComponent, "South");
        }
        JSeparator sep1 = new JSeparator(0);
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)sep1, "North");
        southPanel.add((Component)buttonPanel, "South");
        dialog.getContentPane().setLayout(new BorderLayout(5, 0));
        dialog.getContentPane().add((Component)topPanel, "Center");
        dialog.getContentPane().add((Component)southPanel, "South");
        dialog.addWindowListener(new WindowAdapter(){
            {
            }

            @Override
            public void windowClosing(WindowEvent event) {
                returnValue.value = false;
            }
        });
        dialog.validate();
        dialog.pack();
        dialog.setTitle(_title);
        dialog.setLocationRelativeTo(_target);
        dialog.setModal(true);
        dialog.setVisible(true);
        if (!returnValue.value) {
            return null;
        }
        Object[] selection = list.getSelectedValues();
        ArrayList<Object> newList = new ArrayList<Object>();
        int i2 = 0;
        int n2 = selection.length;
        while (i2 < n2) {
            newList.add(selection[i2]);
            ++i2;
        }
        return newList;
    }
}

