/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.tools.ExportFormat;
import org.opensourcephysics.tools.ToolsRes;

public class ExportGnuplotFormat
implements ExportFormat {
    @Override
    public String description() {
        return "Text";
    }

    @Override
    public String extension() {
        return "txt";
    }

    void exportDataset(PrintWriter pw, Dataset data, int index) throws IOException {
        double[] x = data.getXPointsRaw();
        double[] y = data.getYPointsRaw();
        int n = data.getIndex();
        pw.print("\n# name: data" + index + "\n" + "# type: matrix\n" + "# rows: " + x.length + "\n" + "# columns: " + 2 + "\n");
        int j = 0;
        while (j < n) {
            pw.println(String.valueOf(x[j]) + " " + y[j]);
            ++j;
        }
    }

    void exportGridData(PrintWriter pw, GridData gridData, int index) throws IOException {
        int nx = gridData.getNx();
        int ny = gridData.getNy();
        double x0 = gridData.getLeft();
        double dx = gridData.getDx();
        pw.println("\n# name: col_range" + index + "\n" + "# type: matrix\n" + "# rows: 1\n" + "# columns: " + nx);
        int i = 0;
        while (i < nx) {
            pw.print(String.valueOf(x0 + (double)i * dx) + " ");
            ++i;
        }
        pw.println("\n");
        double y0 = gridData.getTop();
        double dy = gridData.getDy();
        pw.println("# name: row_range" + index + "\n" + "# type: matrix\n" + "# rows: 1\n" + "# columns: " + ny);
        int i2 = 0;
        while (i2 < ny) {
            pw.print(String.valueOf(y0 + (double)i2 * dy) + " ");
            ++i2;
        }
        pw.println("\n");
        int nc = gridData.getComponentCount();
        int c = 0;
        while (c < nc) {
            String cname = gridData.getComponentName(c);
            pw.println("# name: grid_" + index + '_' + cname + '\n' + "# type: matrix\n" + "# rows: " + ny + '\n' + "# columns: " + nx);
            int i3 = 0;
            while (i3 < ny) {
                int j = 0;
                while (j < nx) {
                    pw.print(String.valueOf(gridData.getValue(j, i3, c)) + " ");
                    ++j;
                }
                pw.println();
                ++i3;
            }
            ++c;
        }
    }

    @Override
    public void export(File file, List<Object> data) {
        try {
            FileWriter fw = new FileWriter(file);
            PrintWriter pw = new PrintWriter(fw);
            pw.println("# Created by the Open Source Physics library");
            Iterator<Object> it = data.iterator();
            int i = 0;
            while (it.hasNext()) {
                Object o = it.next();
                if (o instanceof Dataset) {
                    this.exportDataset(pw, (Dataset)o, i);
                } else if (o instanceof GridData) {
                    this.exportGridData(pw, (GridData)o, i);
                }
                ++i;
            }
            pw.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, ToolsRes.getString("ExportFormat.Dialog.WriteError.Message"), ToolsRes.getString("ExportFormat.Dialog.WriteError.Title"), 0);
        }
    }
}

