/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javajs.async.AsyncFileChooser;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.tools.ExportFormat;
import org.opensourcephysics.tools.ExportGnuplotFormat;
import org.opensourcephysics.tools.ExportXMLFormat;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;
import org.opensourcephysics.tools.ToolsRes;

public class ExportTool
implements Tool,
PropertyChangeListener {
    static ExportTool TOOL;
    AsyncFileChooser fc;
    static String exportExtension;
    static Hashtable<String, ExportFormat> formats;
    JCheckBox[] checkBoxes;
    String exportName = "default";

    static {
        exportExtension = "txt";
    }

    public ExportTool() {
        this.createFileChooser();
        this.fc.addPropertyChangeListener(this);
    }

    void createFileChooser() {
        formats = new Hashtable();
        ExportTool.registerFormat(new ExportGnuplotFormat());
        ExportTool.registerFormat(new ExportXMLFormat());
        Object oldFilesOfTypeLabelText = UIManager.put("FileChooser.filesOfTypeLabelText", ToolsRes.getString("ExportTool.FileChooser.Label.FileFormat"));
        this.fc = OSPRuntime.getChooser();
        UIManager.put("FileChooser.filesOfTypeLabelText", oldFilesOfTypeLabelText);
        this.fc.setDialogType(1);
        this.fc.setDialogTitle(ToolsRes.getString("ExportTool.FileChooser.Title"));
        this.fc.setApproveButtonText(ToolsRes.getString("ExportTool.FileChooser.Button.Export"));
        this.setChooserFormats();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        FileFilter filter = this.fc.getFileFilter();
        if (filter == null) {
            return;
        }
        ExportFormat ef = formats.get(filter.getDescription());
        if (ef == null || exportExtension.equals(ef.extension())) {
            return;
        }
        exportExtension = ef.extension();
        this.fc.setSelectedFile(new File(String.valueOf(this.exportName) + '.' + exportExtension));
    }

    void buildAccessory(List<Object> data) {
        this.checkBoxes = new JCheckBox[data.size()];
        JPanel checkPanel = new JPanel(new GridLayout(0, 1));
        int i = 0;
        while (i < data.size()) {
            String s = String.valueOf(ToolsRes.getString("ExportTool.FileChooser.DataType.Unknown")) + i;
            Color c = Color.BLACK;
            Object o = data.get(i);
            if (o instanceof Dataset) {
                Dataset d = (Dataset)o;
                s = String.valueOf(ToolsRes.getString("ExportTool.FileChooser.DataType.Dataset")) + i;
                c = d.getFillColor();
            } else if (o instanceof GridData) {
                s = String.valueOf(ToolsRes.getString("ExportTool.FileChooser.DataType.GridData")) + i;
            }
            this.checkBoxes[i] = new JCheckBox(s);
            this.checkBoxes[i].setSelected(true);
            this.checkBoxes[i].setForeground(c);
            this.checkBoxes[i].setBackground(Color.WHITE);
            checkPanel.add(this.checkBoxes[i]);
            ++i;
        }
        JScrollPane scrollPane = new JScrollPane(checkPanel);
        scrollPane.getViewport().setBackground(Color.WHITE);
        JPanel p = new JPanel(new BorderLayout());
        if (data.size() == 0) {
            p.add((Component)new JLabel(ToolsRes.getString("ExportTool.FileChooser.Heading.NoData")), "North");
        } else {
            p.add((Component)new JLabel(ToolsRes.getString("ExportTool.FileChooser.Heading.ExportableData")), "North");
        }
        p.add((Component)scrollPane, "Center");
        p.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.fc.setAccessory(p);
    }

    void setChooserFormats() {
        this.fc.resetChoosableFileFilters();
        this.fc.setAcceptAllFileFilterUsed(false);
        Enumeration<String> e = formats.keys();
        while (e.hasMoreElements()) {
            final String desc = e.nextElement();
            this.fc.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f != null;
                }

                @Override
                public String getDescription() {
                    return desc;
                }
            });
        }
    }

    List<Object> getDataObjects(XMLControlElement control) {
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.addAll(control.getObjects(Dataset.class));
        ret.addAll(control.getObjects(GridData.class));
        return ret;
    }

    List<Object> filterDataObjects(List<Object> data) {
        Vector<Object> ret = new Vector<Object>();
        int i = 0;
        while (i < data.size()) {
            if (this.checkBoxes[i].isSelected()) {
                ret.add(data.get(i));
            }
            ++i;
        }
        return ret;
    }

    public static void registerFormat(ExportFormat format) {
        formats.put(format.description(), format);
    }

    public void exportJS(Job job) {
        XMLControlElement control = new XMLControlElement();
        try {
            control.readXML(job.getXML());
        }
        catch (Exception ex) {
            System.err.println("Error reading XML for export.");
        }
        OSPLog.fine("Exporting XML");
        OSPLog.finer("XML=" + control.toXML());
        AsyncFileChooser chooser = OSPRuntime.getChooser();
        if (chooser == null) {
            return;
        }
        String oldTitle = chooser.getDialogTitle();
        chooser.setDialogTitle("Export");
        int result = -1;
        try {
            result = chooser.showSaveDialog(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        chooser.setDialogTitle(oldTitle);
        if (result == 0) {
            int selected;
            File file = chooser.getSelectedFile();
            OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
            String fileName = file.getAbsolutePath();
            if (fileName == null || fileName.trim().equals("")) {
                return;
            }
            int i = fileName.toLowerCase().lastIndexOf(".xml");
            if (i != fileName.length() - 4) {
                fileName = String.valueOf(fileName) + ".xml";
                file = new File(fileName);
            }
            if (file.exists() && (selected = JOptionPane.showConfirmDialog(null, "Replace existing " + file.getName() + "?", "Replace File", 1)) != 0) {
                return;
            }
            control.write(fileName);
        }
        OSPLog.fine("Done Exporting");
    }

    @Override
    public void send(Job job, Tool noReply) {
        if (OSPRuntime.isJS) {
            this.exportJS(job);
            return;
        }
        XMLControlElement control = new XMLControlElement();
        control.readXML(job.getXML());
        List<Object> data = this.getDataObjects(control);
        this.buildAccessory(data);
        this.fc.setSelectedFile(new File(String.valueOf(this.exportName) + '.' + exportExtension));
        int returnVal = this.fc.showSaveDialog(null);
        if (returnVal == 0) {
            int selected;
            File file = this.fc.getSelectedFile();
            if (file.exists() && (selected = JOptionPane.showConfirmDialog(null, String.valueOf(ToolsRes.getString("Tool.Dialog.ReplaceFile.Message")) + " " + file.getName() + "?", ToolsRes.getString("Tool.Dialog.ReplaceFile.Title"), 1)) != 0) {
                return;
            }
            String description = this.fc.getFileFilter().getDescription();
            if (!description.trim().equals("not implemented")) {
                formats.get(description).export(file, this.filterDataObjects(data));
            }
            if (file.getName().endsWith(exportExtension)) {
                this.exportName = file.getName().substring(0, file.getName().length() - 1 - exportExtension.length());
            }
        }
    }

    public static ExportTool getTool() {
        if (TOOL == null) {
            TOOL = new ExportTool();
            Toolbox.addTool("ExportTool", TOOL);
        }
        return TOOL;
    }
}

