/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.tools.ExportFormat;
import org.opensourcephysics.tools.ToolsRes;

public class ExportXMLFormat
implements ExportFormat {
    @Override
    public String description() {
        return "XML";
    }

    @Override
    public String extension() {
        return "xml";
    }

    @Override
    public void export(File file, List<Object> data) {
        OSPLog.finer("Exporting XML data to file=" + file);
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, ToolsRes.getString("ExportFormat.Dialog.WriteError.Message"), ToolsRes.getString("ExportFormat.Dialog.WriteError.Title"), 0);
            return;
        }
        PrintWriter pw = new PrintWriter(fw);
        Iterator<Object> it = data.iterator();
        while (it.hasNext()) {
            XMLControlElement control = new XMLControlElement(it.next());
            pw.print(control.toXML());
            pw.println();
        }
        pw.close();
    }
}

