/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.List;
import javax.swing.TransferHandler;
import org.opensourcephysics.tools.ResourceLoader;

public class FileDropHandler
extends TransferHandler {
    FileImporter frame;
    DataFlavor uriListFlavor;
    Boolean isDropOK = null;

    public FileDropHandler(FileImporter frame) {
        this.frame = frame;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        List<File> fileList = this.getFileList(support.getTransferable());
        Object ret = fileList;
        try {
            if (fileList != null) {
                File f = fileList.get(0);
                if (f.getName().endsWith(".url")) {
                    String s = ResourceLoader.readAllAsString(new FileInputStream(f));
                    s = s.substring(s.indexOf("URL=") + 4);
                    ret = new URL(s.substring(0, s.indexOf("\n")).trim());
                }
                return this.frame.importData(ret, support.getComponent());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private List<File> getFileList(Transferable t) {
        try {
            return (List)t.getTransferData(DataFlavor.javaFileListFlavor);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static interface FileImporter {
        public boolean importData(Object var1, Component var2);
    }
}

