/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javajs.async.AsyncFileChooser;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.AbstractAutoloadManager;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FitFunctionPanel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.KnownPolynomial;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class FitBuilder
extends FunctionTool {
    private static final FileFilter xmlFilter;
    private static final Collection<String> initialAutoloadSearchPaths;
    private static final Map<String, String[]> autoloadExclusionsMap;
    private static String[] preferredAutoloadSearchPaths;
    private static AsyncFileChooser chooser;
    protected JButton newFitButton;
    protected JButton deleteFitButton;
    protected JButton cloneFitButton;
    protected JButton loadButton;
    protected JButton saveButton;
    protected JButton autoloadButton;
    protected Component myParent;
    protected TreeSet<String> addedFits = new TreeSet();
    protected String defaultFitName;
    protected AutoloadManager autoloadManager;

    static {
        initialAutoloadSearchPaths = new TreeSet<String>();
        autoloadExclusionsMap = new TreeMap<String, String[]>();
        xmlFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null || f.isDirectory()) {
                    return false;
                }
                String ext = XML.getExtension(f.getName());
                return ext != null && "xml".equals(ext.toLowerCase());
            }
        };
        preferredAutoloadSearchPaths = (String[])OSPRuntime.getPreference("autoload_search_paths");
        String[][] autoloadData = (String[][])OSPRuntime.getPreference("autoload_exclusions");
        if (autoloadData != null) {
            String[][] stringArray = autoloadData;
            int n = autoloadData.length;
            int n2 = 0;
            while (n2 < n) {
                String[] next = stringArray[n2];
                String filePath = XML.forwardSlash(next[0]);
                String[] functions = new String[next.length - 1];
                System.arraycopy(next, 1, functions, 0, functions.length);
                autoloadExclusionsMap.put(filePath, functions);
                ++n2;
            }
        }
    }

    public FitBuilder(Component c) {
        this(c, false);
    }

    public FitBuilder(Component c, boolean lazyGUI) {
        super(c, true, lazyGUI);
        this.myParent = c;
        if (!lazyGUI) {
            this.createGUI();
        }
    }

    @Override
    protected void createGUI() {
        if (this.haveGUI()) {
            return;
        }
        super.createGUI();
        this.newFitButton = new JButton(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Text"));
        this.newFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Tooltip"));
        this.newFitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = FitBuilder.this.getUniqueName(ToolsRes.getString("DatasetCurveFitter.NewFit.Name"));
                UserFunction f = new UserFunction(name);
                Dataset dataset = null;
                DatasetCurveFitter fitter = FitBuilder.this.getSelectedCurveFitter();
                if (fitter != null) {
                    dataset = fitter.getData();
                }
                String var = dataset == null ? "x" : TeXParser.removeSubscripting(dataset.getColumnName(0));
                f.setExpression("0", new String[]{var});
                FitBuilder.this.addFitFunctionPanel(f);
            }
        });
        this.deleteFitButton = new JButton(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Text"));
        this.deleteFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Tooltip"));
        this.deleteFitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = FitBuilder.this.getSelectedName();
                FitBuilder.this.removePanel(name);
            }
        });
        this.cloneFitButton = new JButton(ToolsRes.getString("DatasetCurveFitter.Button.Clone.Text"));
        this.cloneFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.Clone.Tooltip"));
        this.cloneFitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final HashMap<String, KnownFunction> fits = new HashMap<String, KnownFunction>();
                final ArrayList<String> fitnames = new ArrayList<String>();
                for (DatasetCurveFitter fitter : FitBuilder.this.curveFitters) {
                    fitter.getFits(fits, fitnames);
                }
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (String name : fitnames) {
                            DatasetCurveFitter fitter;
                            if (!name.equals(e.getActionCommand()) || (fitter = FitBuilder.this.getSelectedCurveFitter()) == null) continue;
                            KnownFunction f = (KnownFunction)fits.get(name);
                            UserFunction uf = fitter.createClone(f, name);
                            UserFunctionEditor editor = new UserFunctionEditor();
                            editor.setMainFunctions(new UserFunction[]{uf});
                            FitFunctionPanel panel = new FitFunctionPanel(editor);
                            FitBuilder.this.addPanel(uf.getName(), panel);
                        }
                    }
                };
                JPopupMenu popup = new JPopupMenu();
                for (String name : fitnames) {
                    JMenuItem item = new JMenuItem(name);
                    item.setActionCommand(name);
                    item.addActionListener(listener);
                    popup.add(item);
                }
                popup.show(FitBuilder.this.cloneFitButton, 0, FitBuilder.this.cloneFitButton.getHeight());
            }
        });
        String imageFile = "/org/opensourcephysics/resources/tools/images/open.gif";
        ImageIcon openIcon = ResourceLoader.getImageIcon(imageFile);
        this.loadButton = new JButton(openIcon);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FitBuilder.this.loadFits();
            }
        });
        imageFile = "/org/opensourcephysics/resources/tools/images/save.gif";
        ImageIcon saveIcon = ResourceLoader.getImageIcon(imageFile);
        this.saveButton = new JButton(saveIcon);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FitBuilder.this.saveFits();
            }
        });
        this.autoloadButton = new JButton();
        this.autoloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoloadManager manager = FitBuilder.this.getAutoloadManager();
                manager.refreshAutoloadData();
                manager.setVisible(true);
            }
        });
        this.setToolbarComponents(new Component[]{this.loadButton, this.saveButton, new JToolBar.Separator(), this.newFitButton, this.cloneFitButton, this.deleteFitButton, Box.createHorizontalGlue(), this.autoloadButton});
    }

    public DatasetCurveFitter getSelectedCurveFitter() {
        DataTool dataTool;
        DataToolTab tab;
        Window win = this.getOwner();
        if (win != null && win instanceof DataTool && (tab = (dataTool = (DataTool)win).getSelectedTab()) != null) {
            return tab.getCurveFitter();
        }
        return null;
    }

    @Override
    public void refreshDropdown(String name) {
        if (name == null) {
            name = this.defaultFitName;
        }
        this.deleteFitButton.setEnabled(!this.getPanelNames().isEmpty());
        if (this.getPanelNames().isEmpty()) {
            String label = ToolsRes.getString("FitFunctionPanel.Label");
            this.dropdownLabelText = String.valueOf(label) + ":";
        } else {
            this.dropdownLabelText = null;
        }
        super.refreshDropdown(name);
    }

    public boolean addFitFunction(KnownFunction f) {
        if (f instanceof UserFunction) {
            String name = f.getName();
            if (this.addedFits.contains(name)) {
                return true;
            }
            for (String next : this.getPanelNames()) {
                FitFunctionPanel panel = (FitFunctionPanel)this.getPanel(next);
                if (!name.equals(panel.originalName)) continue;
                return false;
            }
            FitFunctionPanel panel = this.addFitFunctionPanel((UserFunction)f);
            panel.originalName = name;
            this.addedFits.add(name);
        } else if (f instanceof KnownPolynomial) {
            UserFunction uf = new UserFunction((KnownPolynomial)f);
            return this.addFitFunction(uf);
        }
        return true;
    }

    private File loadFits() {
        if (chooser == null) {
            chooser = OSPRuntime.getChooser();
            javax.swing.filechooser.FileFilter[] fileFilterArray = chooser.getChoosableFileFilters();
            int n = fileFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                javax.swing.filechooser.FileFilter filter = fileFilterArray[n2];
                if (filter.getDescription().toLowerCase().indexOf("xml") > -1) {
                    chooser.setFileFilter(filter);
                    break;
                }
                ++n2;
            }
        }
        chooser.showOpenDialog(this, new Runnable(){

            @Override
            public void run() {
                OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
                FitBuilder.this.loadFits(chooser.getSelectedFile(), false);
            }
        }, null);
        return null;
    }

    private void loadFits(File path, boolean loadAll) {
        if (path == null) {
            this.loadFits();
            return;
        }
        final XMLControlElement control = new XMLControlElement(path);
        if (control.failedToRead()) {
            JOptionPane.showMessageDialog(this, ToolsRes.getString("Dialog.Invalid.Message"), ToolsRes.getString("Dialog.Invalid.Title"), 0);
            return;
        }
        Class<?> type = control.getObjectClass();
        if (type != null && FitBuilder.class.isAssignableFrom(type)) {
            if (loadAll) {
                control.loadObject(this);
            } else {
                this.chooseFitFunctions(control, "Load", new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        control.loadObject(FitBuilder.this);
                    }
                });
            }
        } else {
            JOptionPane.showMessageDialog(this, ToolsRes.getString("DatasetCurveFitter.FitBuilder.Dialog.WrongType.Message"), ToolsRes.getString("DatasetCurveFitter.FitBuilder.Dialog.WrongType.Title"), 0);
        }
    }

    private void saveFits() {
        final XMLControlElement control = new XMLControlElement(this);
        this.chooseFitFunctions(control, "Save", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (chooser == null) {
                    chooser = OSPRuntime.getChooser();
                    javax.swing.filechooser.FileFilter[] fileFilterArray = chooser.getChoosableFileFilters();
                    int n = fileFilterArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        javax.swing.filechooser.FileFilter filter = fileFilterArray[n2];
                        if (filter.getDescription().toLowerCase().indexOf("xml") > -1) {
                            chooser.setFileFilter(filter);
                            break;
                        }
                        ++n2;
                    }
                }
                FontSizer.setFonts(chooser, FontSizer.getLevel());
                int result = chooser.showSaveDialog(FitBuilder.this);
                if (result == 0) {
                    int isSelected;
                    OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
                    File file = chooser.getSelectedFile();
                    if (file.exists() && (isSelected = JOptionPane.showConfirmDialog(FitBuilder.this, String.valueOf(ToolsRes.getString("Tool.Dialog.ReplaceFile.Message")) + " " + file.getName() + "?", ToolsRes.getString("Tool.Dialog.ReplaceFile.Title"), 1)) != 0) {
                        return;
                    }
                    FitBuilder.this.saveFits(file.getAbsolutePath(), control);
                }
            }
        });
    }

    private void saveFits(String path, XMLControl control) {
        if (path == null) {
            this.saveFits();
            return;
        }
        if (XML.getExtension(path) == null) {
            path = String.valueOf(path) + ".xml";
        }
        if (control == null || control.getObjectClass() != this.getClass()) {
            control = new XMLControlElement(this);
        }
        control.write(path);
    }

    protected void autoloadFits() {
        if (this.myParent != null && this.myParent instanceof DataTool) {
            for (String dir : FitBuilder.getInitialSearchPaths()) {
                this.autoloadFits(dir);
            }
        }
    }

    private void autoloadFits(String dirPath) {
        if (dirPath == null) {
            return;
        }
        File dir = new File(dirPath);
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles(xmlFilter);
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> type;
                File file = fileArray[n2];
                XMLControlElement control = new XMLControlElement(file);
                if (!control.failedToRead() && (type = control.getObjectClass()) != null && FitBuilder.class.isAssignableFrom(type)) {
                    XMLControlElement copyControl = new XMLControlElement(control);
                    String filePath = XML.forwardSlash(file.getAbsolutePath());
                    this.eliminateExcludedFunctions(copyControl, filePath);
                    copyControl.loadObject(this);
                }
                ++n2;
            }
        }
    }

    private Map<String, ArrayList<String[]>> findFitFunctions(String dirPath) {
        TreeMap<String, ArrayList<String[]>> results = new TreeMap<String, ArrayList<String[]>>();
        if (dirPath == null) {
            return results;
        }
        File dir = new File(dirPath);
        if (!dir.exists()) {
            return results;
        }
        File[] files = dir.listFiles(xmlFilter);
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> type;
                File file = fileArray[n2];
                XMLControlElement control = new XMLControlElement(file);
                if (!control.failedToRead() && (type = control.getObjectClass()) != null && FitBuilder.class.isAssignableFrom(type)) {
                    ArrayList<String[]> functions = new ArrayList<String[]>();
                    for (XMLProperty next : control.getPropsRaw()) {
                        XMLControl[] panels;
                        if (!next.getPropertyName().equals("functions")) continue;
                        XMLControl[] xMLControlArray = panels = next.getChildControls();
                        int n3 = panels.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            XMLControl panelControl = xMLControlArray[n4];
                            String name = panelControl.getString("name");
                            String expression = panelControl.getString("description");
                            String[] data = new String[]{name, expression};
                            functions.add(data);
                            ++n4;
                        }
                        break block1;
                    }
                    results.put(file.getName(), functions);
                }
                ++n2;
            }
        }
        return results;
    }

    /*
     * Could not resolve type clashes
     */
    protected void eliminateExcludedFunctions(XMLControl fitBuilderControl, String filePath) {
        for (XMLProperty obj : fitBuilderControl.getPropsRaw()) {
            if (!obj.getPropertyName().equals("functions")) continue;
            XMLProperty prop = obj;
            List<Object> items = prop.getPropertyContent();
            ArrayList<Object> toRemove = new ArrayList<Object>();
            XMLControl[] panels = prop.getChildControls();
            int i = 0;
            while (i < panels.length) {
                XMLControl panelControl = panels[i];
                String name = panelControl.getString("name");
                if (this.isFunctionExcluded(filePath, name)) {
                    toRemove.add(items.get(i));
                }
                ++i;
            }
            for (Object next : toRemove) {
                items.remove(next);
            }
        }
    }

    private boolean isFunctionExcluded(String filePath, String functionName) {
        String[] functions = autoloadExclusionsMap.get(filePath);
        if (functions == null) {
            return false;
        }
        String[] stringArray = functions;
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals("*")) {
                return true;
            }
            if (name.equals(functionName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void setTitles() {
        if (this.getPanelNames().isEmpty()) {
            String label = ToolsRes.getString("FitFunctionPanel.Label");
            this.dropdownLabelText = String.valueOf(label) + ":";
        } else {
            this.dropdownLabelText = null;
        }
        this.titleText = ToolsRes.getString("DatasetCurveFitter.FitBuilder.Title");
    }

    @Override
    protected void refreshGUI() {
        if (!this.haveGUI()) {
            return;
        }
        super.refreshGUI();
        if (this.deleteFitButton != null) {
            this.saveButton.setEnabled(!this.getPanelNames().isEmpty());
            this.loadButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.FitBuilder.Button.Load.Tooltip"));
            this.saveButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.FitBuilder.Button.Save.Tooltip"));
            FitFunctionPanel panel = (FitFunctionPanel)this.getSelectedPanel();
            this.deleteFitButton.setEnabled(panel != null && !this.getPanelNames().isEmpty() && panel.originalName == null);
            this.newFitButton.setText(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Text"));
            this.newFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Tooltip"));
            this.deleteFitButton.setText(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Text"));
            this.deleteFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Tooltip"));
            DatasetCurveFitter fitter = this.getSelectedCurveFitter();
            this.cloneFitButton.setEnabled(fitter != null);
            this.autoloadButton.setText(String.valueOf(ToolsRes.getString("FitBuilder.Button.Autoload")) + "...");
            this.autoloadButton.setToolTipText(ToolsRes.getString("FitBuilder.Button.Autoload.Tooltip"));
        }
    }

    protected void chooseFitFunctions(XMLControl control, String description, final ActionListener listener) {
        final ArrayList<XMLControl> originals = new ArrayList<XMLControl>();
        final ArrayList<XMLControl> choices = new ArrayList<XMLControl>();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> expressions = new ArrayList<String>();
        for (XMLProperty prop : control.getPropsRaw()) {
            for (Object obj : prop.getPropertyContent()) {
                if (!(obj instanceof XMLProperty)) continue;
                XMLProperty f = (XMLProperty)obj;
                XMLControl function = f.getChildControls()[0];
                originals.add(function);
                choices.add(function);
                names.add(function.getString("name"));
                String desc = function.getString("description");
                expressions.add(desc);
            }
        }
        boolean[] selected = new boolean[choices.size()];
        int i = 0;
        while (i < selected.length) {
            selected[i] = true;
            ++i;
        }
        ListChooser listChooser = new ListChooser(ToolsRes.getString("DatasetCurveFitter.FitBuilder." + description + ".Title"), ToolsRes.getString("DatasetCurveFitter.FitBuilder." + description + ".Message"), this, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    for (XMLControl next : originals) {
                        if (choices.contains(next)) continue;
                        XMLProperty prop = next.getParentProperty();
                        XMLProperty parent = prop.getParentProperty();
                        parent.getPropertyContent().remove(prop);
                    }
                }
                listener.actionPerformed(e);
            }
        });
        listChooser.choose(choices, names, expressions, null, selected, null);
    }

    protected FitFunctionPanel addFitFunctionPanel(UserFunction f) {
        UserFunctionEditor editor = new UserFunctionEditor();
        editor.setMainFunctions(new UserFunction[]{f});
        FitFunctionPanel panel = new FitFunctionPanel(editor);
        this.addPanel(f.getName(), panel);
        return panel;
    }

    protected AutoloadManager getAutoloadManager() {
        if (this.autoloadManager == null) {
            this.autoloadManager = new AutoloadManager(this);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.autoloadManager.getBounds().width) / 2;
            int y = (dim.height - this.autoloadManager.getBounds().height) / 2;
            this.autoloadManager.setLocation(x, y);
        }
        this.autoloadManager.setFontLevel(FontSizer.getLevel());
        return this.autoloadManager;
    }

    public static String localize(String functionName) {
        String s = ToolsRes.getString("Function." + functionName + ".Name");
        return s.startsWith("!") ? functionName : s;
    }

    protected static Collection<String> getInitialSearchPaths() {
        block4: {
            if (!initialAutoloadSearchPaths.isEmpty()) break block4;
            if (preferredAutoloadSearchPaths != null) {
                String[] stringArray = preferredAutoloadSearchPaths;
                int n = preferredAutoloadSearchPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String next = stringArray[n2];
                    initialAutoloadSearchPaths.add(next);
                    ++n2;
                }
            } else {
                for (String next : OSPRuntime.getDefaultSearchPaths()) {
                    initialAutoloadSearchPaths.add(next);
                }
            }
        }
        return initialAutoloadSearchPaths;
    }

    class AutoloadManager
    extends AbstractAutoloadManager {
        public AutoloadManager(JDialog dialog) {
            super(dialog);
        }

        @Override
        public void setVisible(boolean vis) {
            super.setVisible(vis);
            if (!vis) {
                String name = FitBuilder.this.getSelectedDropdownName();
                for (String dir : this.getSearchPaths()) {
                    FitBuilder.this.autoloadFits(dir);
                }
                FitBuilder.this.refreshDropdown(name);
                Collection<String> searchPaths = this.getSearchPaths();
                ArrayList<String> defaultPaths = OSPRuntime.getDefaultSearchPaths();
                boolean isDefault = searchPaths.size() == defaultPaths.size();
                for (String next : searchPaths) {
                    boolean bl = isDefault = isDefault && defaultPaths.contains(next);
                }
                if (isDefault) {
                    preferredAutoloadSearchPaths = null;
                } else {
                    preferredAutoloadSearchPaths = searchPaths.toArray(new String[searchPaths.size()]);
                }
                OSPRuntime.setPreference("autoload_search_paths", preferredAutoloadSearchPaths);
                Iterator<String> it = this.getExclusionsMap().keySet().iterator();
                while (it.hasNext()) {
                    String filePath = it.next();
                    String parentPath = XML.getDirectoryPath(filePath);
                    boolean keep = false;
                    for (String dir : searchPaths) {
                        boolean bl = keep = keep || parentPath.equals(dir);
                    }
                    if (keep && new File(filePath).exists()) continue;
                    it.remove();
                }
                if (this.getExclusionsMap().isEmpty()) {
                    OSPRuntime.setPreference("autoload_exclusions", null);
                } else {
                    String[][] autoloadData = new String[this.getExclusionsMap().size()][];
                    int i = 0;
                    for (String filePath : this.getExclusionsMap().keySet()) {
                        String[] functions = this.getExclusionsMap().get(filePath);
                        String[] fileAndFunctions = new String[functions.length + 1];
                        fileAndFunctions[0] = filePath;
                        System.arraycopy(functions, 0, fileAndFunctions, 1, functions.length);
                        autoloadData[i] = fileAndFunctions;
                        ++i;
                    }
                    OSPRuntime.setPreference("autoload_exclusions", autoloadData);
                }
                OSPRuntime.savePreferences();
            }
        }

        @Override
        public Collection<String> getSearchPaths() {
            Collection<String> paths = super.getSearchPaths();
            if (paths.isEmpty() && !this.initialized) {
                this.initialized = true;
                for (String next : FitBuilder.getInitialSearchPaths()) {
                    paths.add(next);
                    this.addSearchPath(next);
                }
            }
            return paths;
        }

        @Override
        protected void refreshAutoloadData() {
            TreeMap<String, Map<String, ArrayList<String[]>>> data = new TreeMap<String, Map<String, ArrayList<String[]>>>();
            for (String path : this.getSearchPaths()) {
                Map functionMap = FitBuilder.this.findFitFunctions(path);
                data.put(path, functionMap);
            }
            this.setAutoloadData(data);
        }

        @Override
        protected void refreshGUI() {
            this.refreshAutoloadData();
            super.refreshGUI();
            String title = String.valueOf(FitBuilder.this.getTitle()) + " " + this.getTitle();
            this.setTitle(title);
            this.setInstructions(String.valueOf(ToolsRes.getString("FitBuilder.Instructions.SelectToAutoload")) + "\n\n" + ToolsRes.getString("FitBuilder.Instructions.WhereDefined") + " " + ToolsRes.getString("FitBuilder.Instructions.HowToAddFunction") + " " + ToolsRes.getString("FitBuilder.Instructions.HowToAddDirectory"));
        }

        @Override
        protected Map<String, String[]> getExclusionsMap() {
            return autoloadExclusionsMap;
        }
    }
}

