/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.beans.PropertyChangeEvent;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class FitFunctionPanel
extends FunctionPanel {
    protected String originalName;

    public FitFunctionPanel(UserFunctionEditor editor) {
        super(editor);
        UserFunction[] functions = editor.getMainFunctions();
        int n = 0;
        int j = 0;
        while (j < functions.length) {
            int i = 0;
            while (i < functions[j].getParameterCount()) {
                if (this.paramEditor.getObject(functions[j].getParameterName(i)) == null) {
                    Parameter param = new Parameter(functions[j].getParameterName(i), String.valueOf(functions[j].getParameterValue(i)), functions[j].getParameterDescription(i));
                    this.paramEditor.addObject(param, n++, false, false);
                }
                ++i;
            }
            ++j;
        }
        this.refreshFunctions();
        this.addForbiddenNames(new String[]{this.getFitFunction().getIndependentVariable()});
        this.setName(this.getFitFunction().getName());
    }

    public UserFunctionEditor getFitFunctionEditor() {
        return (UserFunctionEditor)this.functionEditor;
    }

    public UserFunction getFitFunction() {
        return ((UserFunctionEditor)this.functionEditor).getMainFunctions()[0];
    }

    public UserFunction[] getSupportFunctions() {
        return ((UserFunctionEditor)this.functionEditor).getSupportFunctions();
    }

    @Override
    public String getLabel() {
        return ToolsRes.getString("FitFunctionPanel.Label");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("edit") && this.functionTool != null) {
            UserFunctionEditor ufe = (UserFunctionEditor)this.functionEditor;
            UserFunction[] functions = ufe.getMainFunctions();
            if (functions != null && functions.length > 0) {
                if (e.getSource() == this.functionEditor && functions[0].getName().equals(e.getOldValue())) {
                    this.functionTool.renamePanel(this.getName(), this.getFitFunction().getName());
                    if (e.getNewValue() instanceof FunctionEditor.DefaultEdit) {
                        FunctionEditor.DefaultEdit edit = (FunctionEditor.DefaultEdit)e.getNewValue();
                        this.functionEditor.getTable().selectCell(edit.undoRow, edit.undoCol);
                    }
                    this.functionTool.refreshGUI();
                }
                super.propertyChange(e);
                if (functions[0].polynomial != null) {
                    this.functionTool.firePropertyChange("function", null, functions[0].getName());
                }
                return;
            }
        } else if (e.getPropertyName().equals("description") && this.functionTool != null) {
            super.propertyChange(e);
            this.functionTool.firePropertyChange("function", null, this.getFitFunction().getName());
            return;
        }
        super.propertyChange(e);
    }

    @Override
    protected void refreshFunctions() {
        if (this.paramEditor != null) {
            ((UserFunctionEditor)this.functionEditor).updateAllFunctions(this.paramEditor);
        }
        this.functionEditor.evaluateAll();
    }

    protected void refreshParameters() {
        if (this.paramEditor != null) {
            UserFunction f = this.getFitFunction();
            this.paramEditor.refreshParametersFromFunction(f);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            FitFunctionPanel panel = (FitFunctionPanel)obj;
            control.setValue("name", panel.getName());
            panel.setDescription("y = " + panel.getFitFunction().getExpression("x"));
            control.setValue("description", panel.getDescription());
            Parameter[] params = panel.getParamEditor().getParameters();
            control.setValue("user_parameters", params);
            control.setValue("function_editor", panel.getFitFunctionEditor());
            control.setValue("original_name", panel.originalName);
        }

        @Override
        public Object createObject(XMLControl control) {
            UserFunctionEditor editor = (UserFunctionEditor)control.getObject("function_editor");
            return new FitFunctionPanel(editor);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            FitFunctionPanel panel = (FitFunctionPanel)obj;
            Parameter[] params = (Parameter[])control.getObject("user_parameters");
            panel.getParamEditor().setParameters(params);
            panel.getFitFunctionEditor().parametersValid = false;
            panel.getFitFunctionEditor().evaluateAll();
            panel.originalName = control.getString("original_name");
            return obj;
        }
    }
}

