/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;

public class FontSizer
extends OSPRuntime.Supported {
    public static final String PROPERTY_LEVEL = "level";
    public static final Font TEXT_FONT = new JTextField().getFont();
    public static final Font BUTTON_FONT = new JButton().getFont();
    public static final Font ACCELERATOR_FONT = (Font)UIManager.get("MenuItem.acceleratorFont");
    public static final ResizableIcon CHECKBOXMENUITEM_ICON;
    public static final ResizableIcon RADIOBUTTONMENUITEM_ICON;
    public static final ResizableIcon CHECKBOX_ICON;
    public static final ResizableIcon RADIOBUTTON_ICON;
    public static final ResizableIcon ARROW_ICON;
    public static final int MIN_LEVEL = 0;
    public static final int MAX_LEVEL = 9;
    static FontSizer levelObj;
    static int level;
    static int integerFactor;
    static double levelFactor;
    static double factor;
    static Map<Font, Font> fontMap;

    static {
        levelObj = new FontSizer();
        level = 0;
        integerFactor = 1;
        levelFactor = 1.25;
        factor = 1.0;
        fontMap = new HashMap<Font, Font>();
        Icon baseIcon = (Icon)UIManager.get("CheckBoxMenuItem.checkIcon");
        CHECKBOXMENUITEM_ICON = new ResizableIcon(baseIcon);
        UIManager.put("CheckBoxMenuItem.checkIcon", CHECKBOXMENUITEM_ICON);
        baseIcon = (Icon)UIManager.get("CheckBox.icon");
        CHECKBOX_ICON = new ResizableIcon(baseIcon);
        UIManager.put("CheckBox.icon", CHECKBOX_ICON);
        baseIcon = (Icon)UIManager.get("RadioButtonMenuItem.checkIcon");
        RADIOBUTTONMENUITEM_ICON = new ResizableIcon(baseIcon);
        UIManager.put("RadioButtonMenuItem.checkIcon", RADIOBUTTONMENUITEM_ICON);
        baseIcon = (Icon)UIManager.get("RadioButton.icon");
        RADIOBUTTON_ICON = new ResizableIcon(baseIcon);
        UIManager.put("RadioButton.icon", RADIOBUTTON_ICON);
        baseIcon = (Icon)UIManager.get("Menu.arrowIcon");
        ARROW_ICON = new ResizableIcon(baseIcon);
        UIManager.put("Menu.arrowIcon", ARROW_ICON);
    }

    private FontSizer() {
    }

    public static int setFontsIfNot(int oldLevel, Object c) {
        if (level != oldLevel) {
            FontSizer.setFonts(c, level);
        }
        return level;
    }

    public static int setMenuFonts(JMenu c) {
        if (c.getMenuComponentCount() > 0) {
            Font newFont;
            Font f = c.getMenuComponent(0).getFont();
            Font font = newFont = f == null ? null : FontSizer.getResizedFont(f, level);
            if (newFont != null) {
                int i = 0;
                while (i < c.getMenuComponentCount()) {
                    if (newFont.getSize() != c.getMenuComponent(i).getFont().getSize()) {
                        FontSizer.setFonts(c, level);
                        break;
                    }
                    ++i;
                }
            }
        }
        return level;
    }

    public static int setFonts(Object[] objectsToSize) {
        Font newFont;
        Font f = ((Component)objectsToSize[0]).getFont();
        Font font = newFont = f == null ? null : FontSizer.getResizedFont(f, level);
        if (newFont != null && newFont != f && !newFont.equals(f)) {
            FontSizer.setFonts(objectsToSize, level);
        }
        return level;
    }

    public static int setFonts(Container c) {
        Font newFont;
        if (c == null) {
            return 12;
        }
        Font f = c.getFont();
        Font font = newFont = f == null ? null : FontSizer.getResizedFont(f, level);
        if (newFont != null && newFont != f && !newFont.equals(f)) {
            FontSizer.setFonts(c, level);
        } else {
            int i = 0;
            while (i < c.getComponentCount()) {
                Component comp = c.getComponent(i);
                if (comp instanceof Container) {
                    FontSizer.setFonts((Container)comp);
                }
                ++i;
            }
        }
        return level;
    }

    public static int setFont(Component c) {
        Font newFont;
        Font f = c.getFont();
        Font font = newFont = f == null ? null : FontSizer.getResizedFont(f, level);
        if (newFont != null && newFont != f && !newFont.equals(f)) {
            c.setFont(newFont);
        }
        return level;
    }

    public static int setFont(AbstractButton button) {
        Font newFont;
        Font f = button.getFont();
        Font font = newFont = f == null ? null : FontSizer.getResizedFont(f, level);
        if (newFont != null && newFont != f && !newFont.equals(f)) {
            button.setFont(newFont);
        }
        return level;
    }

    public static void setLevel(int n) {
        if (level == (n = Math.max(0, Math.min(n, 9)))) {
            return;
        }
        level = n;
        factor = FontSizer.getFactor(level);
        integerFactor = FontSizer.getIntegerFactor(level);
        Font font = FontSizer.getResizedFont(TEXT_FONT, level);
        UIManager.put("OptionPane.messageFont", font);
        UIManager.put("TextField.font", font);
        UIManager.put("ToolTip.font", font);
        UIManager.put("TabbedPane.font", font);
        font = FontSizer.getResizedFont(ACCELERATOR_FONT, level);
        UIManager.put("MenuItem.acceleratorFont", font);
        font = FontSizer.getResizedFont(BUTTON_FONT, level);
        UIManager.put("OptionPane.buttonFont", font);
        levelObj.firePropertyChange(PROPERTY_LEVEL, null, level);
    }

    public static int getLevel() {
        return level;
    }

    public static void levelUp() {
        FontSizer.setLevel(level + 1);
    }

    public static void levelDown() {
        FontSizer.setLevel(level - 1);
    }

    public static double getFactor() {
        return factor;
    }

    public static int getIntegerFactor() {
        return integerFactor;
    }

    public static int setFonts(Object obj, int level) {
        if (obj == null || !OSPRuntime.allowSetFonts) {
            return level;
        }
        if (obj instanceof Object[]) {
            Object[] objectArray = (Object[])obj;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object next = objectArray[n2];
                FontSizer.setFonts(next, level);
                ++n2;
            }
            return level;
        }
        if (obj instanceof Collection) {
            for (Object next : (Collection)obj) {
                FontSizer.setFonts(next, level);
            }
            return level;
        }
        double factor = FontSizer.getFactor(level);
        if (obj instanceof Container) {
            FontSizer.setFontFactor((Container)obj, factor);
        } else if (obj instanceof TitledBorder) {
            FontSizer.setFontFactor((TitledBorder)obj, factor);
        } else if (obj instanceof Component) {
            FontSizer.setFontFactor((Component)obj, factor);
        }
        return level;
    }

    public static Font getResizedFont(Font font, int level) {
        return FontSizer.getResizedFont(font, FontSizer.getFactor(level));
    }

    public static Font getResizedFont(Font font, double factor) {
        if (font == null) {
            return font;
        }
        Font base = fontMap.get(font);
        if (base == null) {
            base = font;
            fontMap.put(font, base);
        }
        float size = (float)((double)base.getSize() * factor);
        font = base.deriveFont(size);
        fontMap.put(font, base);
        return font;
    }

    public static double getFactor(int level) {
        double factor = 1.0;
        int i = 0;
        while (i < level) {
            factor *= levelFactor;
            ++i;
        }
        return factor;
    }

    public static int getIntegerFactor(int level) {
        return Math.round(Math.round(FontSizer.getFactor(level)));
    }

    public static void addListener(String property, PropertyChangeListener listener) {
        levelObj.addPropertyChangeListener(property, listener);
    }

    public static void removeListener(String property, PropertyChangeListener listener) {
        levelObj.removePropertyChangeListener(property, listener);
    }

    private static void setFontFactor(Container c, double factor) {
        if (c == null) {
            return;
        }
        try {
            Font font = FontSizer.getResizedFont(c.getFont(), factor);
            if (c instanceof JComponent) {
                if (c instanceof JPopupMenu.Separator) {
                    return;
                }
                JComponent jc = (JComponent)c;
                Border border = jc.getBorder();
                if (border instanceof TitledBorder) {
                    FontSizer.setFontFactor((TitledBorder)border, factor);
                }
                if (c instanceof JMenu) {
                    JMenu m = (JMenu)c;
                    FontSizer.setFontFactor(m.getPopupMenu(), factor);
                }
            }
            int i = 0;
            int n = c.getComponentCount();
            while (i < n) {
                Component co = c.getComponent(i);
                if (co instanceof Container) {
                    FontSizer.setFontFactor((Container)co, factor);
                } else {
                    FontSizer.setFontFactor(co, factor);
                }
                ++i;
            }
            if (font != null && !font.equals(c.getFont())) {
                c.setFont(font);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setFontFactor(Component c, double factor) {
        Border border;
        Font font = FontSizer.getResizedFont(c.getFont(), factor);
        c.setFont(font);
        if (c instanceof JComponent && (border = ((JComponent)c).getBorder()) instanceof TitledBorder) {
            FontSizer.setFontFactor((TitledBorder)border, factor);
        }
    }

    private static void setFontFactor(TitledBorder b, double factor) {
        Font font = b.getTitleFont();
        if (font == null) {
            font = UIManager.getFont("TitledBorder.font");
        }
        b.setTitleFont(FontSizer.getResizedFont(font, factor));
    }
}

