/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.numerics.Util;
import org.opensourcephysics.tools.FitBuilder;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.ParamEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public abstract class FunctionEditor
extends JPanel
implements PropertyChangeListener {
    public static final String PROPERTY_FUNCTIONEDITOR_EDIT = "edit";
    public static final String PROPERTY_FUNCTIONEDITOR_CLIPBOARD = "clipboard";
    public static final String PROPERTY_FUNCTIONEDITOR_PARAM_DESCRIPTION = "param_description";
    public static final String PROPERTY_FUNCTIONEDITOR_DESCRIPTION = "description";
    public static final String PROPERTY_FUNCTIONEDITOR_FOCUS = "focus";
    public static final String PROPERTY_FUNCTIONEDITOR_ANGLESINRADIANS = "angles_in_radians";
    public static final String THETA = TeXParser.parseTeX("$\\theta$");
    public static final String OMEGA = TeXParser.parseTeX("$\\omega$");
    public static final String DEGREES = "\u00b0";
    public static final int ADD_EDIT = 0;
    public static final int REMOVE_EDIT = 1;
    public static final int NAME_EDIT = 2;
    public static final int EXPRESSION_EDIT = 3;
    static final Color LIGHT_BLUE = new Color(204, 204, 255);
    static final Color MEDIUM_RED = new Color(255, 160, 180);
    static final Color LIGHT_RED = new Color(255, 180, 200);
    static final Color LIGHT_GRAY = UIManager.getColor("Panel.background");
    static final Color DARK_RED = new Color(220, 0, 0);
    public static final boolean allowPopopFieldTooltip = !OSPRuntime.isJS;
    static DecimalFormat decimalFormat = new DecimalFormat();
    static DecimalFormat sciFormat0000;
    protected static boolean undoEditsEnabled;
    protected static String[] editTypes;
    protected ParamEditor paramEditor;
    protected FunctionPanel functionPanel;
    protected ArrayList<FObject> objects = new ArrayList();
    protected String[] names = new String[0];
    protected HashSet<String> forbiddenNames = new HashSet();
    protected boolean removablesAtTop = false;
    protected BitSet circularErrors = new BitSet();
    protected BitSet errors = new BitSet();
    protected List<FObject> evaluate = new ArrayList<FObject>();
    protected HashSet<String> referencesChecked = new HashSet();
    protected boolean anglesInDegrees;
    protected boolean confirmChanges = true;
    static final int[] tempRange;
    protected String skipAllName;
    protected Table table;
    protected TableModel tableModel = new TableModel();
    protected CellEditor tableCellEditor = new CellEditor();
    protected CellRenderer tableCellRenderer = new CellRenderer();
    private JButton newButton;
    private JButton cutButton;
    private JButton copyButton;
    private JButton pasteButton;
    private JPanel buttonPanel;
    private JLabel dragLabel;
    private TitledBorder titledBorder;
    private AbstractButton[] customButtons;
    private int selectedRow;
    private int selectedCol;
    protected boolean addButtonPanel = true;
    MouseListener tableFocuser = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            FunctionEditor.this.table.requestFocusInWindow();
            FunctionEditor.this.functionPanel.clearSelection();
        }
    };
    protected String newButtonTipText;
    protected String titledBorderText;
    private boolean haveGUI;
    String lang;
    JDialog popupEditor;

    static {
        decimalFormat.setMaximumFractionDigits(4);
        decimalFormat.setMinimumFractionDigits(0);
        decimalFormat.setMaximumIntegerDigits(3);
        decimalFormat.setMinimumIntegerDigits(1);
        sciFormat0000 = Util.newDecimalFormat("0.0000E0");
        undoEditsEnabled = true;
        editTypes = new String[]{"add row", "delete row", "edit name", "edit expression"};
        tempRange = new int[2];
    }

    public FunctionEditor() {
        super(new BorderLayout());
    }

    public void checkGUI() {
        if (!this.haveGUI) {
            this.createGUI();
            this.refreshGUI();
            if (this.functionPanel != null) {
                this.functionPanel.checkGUI();
            }
            if (this.paramEditor != null) {
                this.paramEditor.checkGUI();
            }
        }
    }

    public Table getTable() {
        this.checkGUI();
        return this.table;
    }

    @Override
    public Dimension getPreferredSize() {
        this.checkGUI();
        Dimension dim = this.table.getPreferredSize();
        dim.height += this.table.getTableHeader().getHeight();
        if (this.buttonPanel != null && this.buttonPanel.getParent() == this) {
            dim.height += this.buttonPanel.getPreferredSize().height;
        }
        dim.height = (int)((double)dim.height + (1.25 * (double)this.table.getRowHeight() + 14.0));
        return dim;
    }

    public void setObjects(List<FObject> newObjects) {
        this.objects.clear();
        this.objects.addAll(newObjects);
        this.evaluateAll();
    }

    protected void updateTable() {
        this.selectedRow = this.table.getSelectedRow();
        this.selectedCol = this.table.getSelectedColumn();
        this.tableModel.fireTableStructureChanged();
        if (this.selectedRow < this.table.getRowCount()) {
            this.table.rowToSelect = this.selectedRow;
            this.table.columnToSelect = this.selectedCol;
        }
        this.table.requestFocusInWindow();
        this.refreshGUI();
    }

    public List<FObject> getObjects() {
        return new ArrayList<FObject>(this.objects);
    }

    public String[] getNames() {
        return this.names;
    }

    public abstract String getName(FObject var1);

    public abstract String getExpression(FObject var1);

    public abstract String getDescription(FObject var1);

    public void setDescription(FObject obj, String desc) {
        if (obj instanceof Parameter) {
            this.firePropertyChange(PROPERTY_FUNCTIONEDITOR_PARAM_DESCRIPTION, null, null);
        }
        this.firePropertyChange(PROPERTY_FUNCTIONEDITOR_DESCRIPTION, null, null);
    }

    public abstract String getTooltip(FObject var1);

    public FObject getObject(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        int i = this.objects.size();
        while (--i >= 0) {
            if (!name.equals(this.getName(this.objects.get(i)))) continue;
            return this.objects.get(i);
        }
        return null;
    }

    public void setExpression(String name, String expression, boolean postEdit) {
        if (name == null || name.equals("")) {
            return;
        }
        int row = 0;
        while (row < this.objects.size()) {
            String prev;
            FObject obj = this.objects.get(row);
            if (name.equals(this.getName(obj)) && !(prev = this.getExpression(obj)).equals(expression)) {
                obj = this.createObject(name, expression, obj);
                this.objects.remove(row);
                this.objects.add(row, obj);
                this.evaluateAll();
                this.tableModel.fireTableStructureChanged();
                if (this.table != null && row >= 0) {
                    this.table.changeSelection(row, 1, false, false);
                }
                UndoableEdit edit = null;
                if (postEdit && undoEditsEnabled) {
                    edit = this.getUndoableEdit(3, expression, row, 1, prev, row, 1, this.getName(obj));
                }
                this.firePropertyChange(PROPERTY_FUNCTIONEDITOR_EDIT, this.getName(obj), edit);
                break;
            }
            ++row;
        }
    }

    public boolean getConfirmChanges() {
        return this.confirmChanges;
    }

    public void setConfirmChanges(boolean confirm) {
        this.confirmChanges = confirm;
    }

    public FObject addObject(FObject obj, boolean postEdit) {
        if (obj == null) {
            return null;
        }
        int row = this.objects.size();
        if (this.isRemovable(obj)) {
            if (this.removablesAtTop) {
                row = this.getRemovableRowCount();
            }
        } else if (!this.removablesAtTop) {
            row -= this.getRemovableRowCount();
        }
        return this.addObject(obj, row, postEdit, true);
    }

    public FObject addObject(FObject obj, int row, boolean postEdit, boolean firePropertyChange) {
        if ((obj = this.createUniqueObject(obj, this.getName(obj), this.confirmChanges)) == null) {
            return null;
        }
        ArrayList<FObject> newObjects = new ArrayList<FObject>(this.objects);
        newObjects.add(row, obj);
        this.setObjects(newObjects);
        if (!this.haveGUI) {
            return obj;
        }
        this.updateTable();
        this.table.columnToSelect = 0;
        this.table.rowToSelect = row;
        this.table.selectOnFocus = true;
        this.table.requestFocusInWindow();
        UndoableEdit edit = null;
        if (postEdit && undoEditsEnabled) {
            edit = this.getUndoableEdit(0, obj, row, 0, obj, this.selectedRow, this.selectedCol, this.getName(obj));
        }
        if (firePropertyChange) {
            this.firePropertyChange(PROPERTY_FUNCTIONEDITOR_EDIT, this.getName(obj), edit);
        }
        this.refreshGUI();
        return obj;
    }

    public FObject removeObject(FObject obj, boolean postEdit) {
        if (obj == null || !this.isRemovable(obj)) {
            return null;
        }
        int undoCol = this.table.getSelectedColumn();
        int undoRow = 0;
        while (undoRow < this.objects.size()) {
            FObject next = this.objects.get(undoRow);
            if (next.equals(obj)) {
                int row;
                this.objects.remove(obj);
                this.tableModel.fireTableStructureChanged();
                int n = row = undoRow == this.objects.size() ? undoRow - 1 : undoRow;
                if (row >= 0) {
                    this.table.changeSelection(row, 0, false, false);
                }
                UndoableEdit edit = null;
                if (postEdit) {
                    edit = this.getUndoableEdit(1, obj, row, 0, obj, undoRow, undoCol, this.getName(obj));
                }
                this.evaluateAll();
                this.firePropertyChange(PROPERTY_FUNCTIONEDITOR_EDIT, this.getName(obj), edit);
                this.refreshGUI();
                return obj;
            }
            ++undoRow;
        }
        return null;
    }

    public void refreshStrings() {
        this.refreshGUI();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "edit": 
            case "focus": {
                if (this.haveGUI) {
                    this.table.clearSelection();
                    this.table.rowToSelect = 0;
                    this.table.columnToSelect = 0;
                    this.table.selectOnFocus = false;
                }
                this.enableMenuButtons();
                break;
            }
            case "clipboard": {
                this.enableMenuButtons();
            }
        }
    }

    public void setCustomButtons(AbstractButton[] buttons) {
        this.customButtons = buttons;
        if (buttons == null || buttons.length == 0) {
            this.remove(this.buttonPanel);
            return;
        }
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout());
        } else {
            this.buttonPanel.removeAll();
        }
        int i = 0;
        while (i < buttons.length) {
            this.buttonPanel.add(buttons[i]);
            ++i;
        }
        this.add((Component)this.buttonPanel, "North");
    }

    JPanel getButtonPanel() {
        this.checkGUI();
        return this.buttonPanel;
    }

    protected UndoableEdit getUndoableEdit(int type, Object redo, int redoRow, int redoCol, Object undo, int undoRow, int undoCol, String name) {
        if (type == 3) {
            ArrayList<AbstractButton> selectedButtons = new ArrayList<AbstractButton>();
            undo = new Object[]{undo, selectedButtons};
            redo = new Object[]{redo, selectedButtons};
            if (this.customButtons != null) {
                AbstractButton[] abstractButtonArray = this.customButtons;
                int n = this.customButtons.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractButton b = abstractButtonArray[n2];
                    if (b.isSelected()) {
                        selectedButtons.add(b);
                    }
                    ++n2;
                }
            }
        }
        return new DefaultEdit(type, redo, redoRow, redoCol, undo, undoRow, undoCol, name);
    }

    public boolean isNameEditable(FObject obj) {
        return true;
    }

    public boolean isExpressionEditable(FObject obj) {
        return true;
    }

    protected boolean isRemovable(FObject obj) {
        return !this.isImportant(obj) && this.isNameEditable(obj) && this.isExpressionEditable(obj);
    }

    protected abstract boolean isImportant(FObject var1);

    public void setAnglesInDegrees(boolean degrees) {
        this.anglesInDegrees = degrees;
        if (!this.haveGUI()) {
            return;
        }
        this.table.repaint();
    }

    public abstract void evaluateAll();

    protected void setArrays() {
        this.evaluate.clear();
        this.circularErrors.clear();
        this.errors.clear();
        int nObj = this.objects.size();
        if (this.names.length != nObj) {
            this.names = new String[nObj];
        }
        int i = 0;
        while (i < this.names.length) {
            this.names[i] = this.getName(this.objects.get(i));
            ++i;
        }
        if (nObj == 0) {
            return;
        }
        i = 0;
        while (i < nObj) {
            if (this.hasReference(i, i)) {
                this.circularErrors.set(i);
            }
            ++i;
        }
        if (!this.circularErrors.isEmpty()) {
            int j = this.circularErrors.nextSetBit(0);
            while (j >= 0) {
                int i2 = 0;
                while (i2 < nObj) {
                    if (this.hasReference(i2, j)) {
                        this.errors.set(i2);
                    }
                    ++i2;
                }
                j = this.circularErrors.nextSetBit(j + 1);
            }
        }
        BitSet temp = new BitSet(nObj);
        temp.set(0, nObj);
        temp.andNot(this.errors);
        BitSet names = new BitSet(nObj);
        while (!temp.isEmpty()) {
            int i3 = temp.nextSetBit(0);
            while (i3 >= 0) {
                FObject next = this.objects.get(i3);
                BitSet references = this.getReferences(i3, null);
                int n = references.cardinality();
                if (n > 0) {
                    references.or(names);
                }
                if (n == 0 || references.cardinality() == names.cardinality()) {
                    this.evaluate.add(next);
                    names.set(i3);
                    temp.clear(i3);
                }
                i3 = temp.nextSetBit(i3 + 1);
            }
        }
    }

    public boolean hasReference(int i1, int i2) {
        return this.getReferences(i1, null).get(i2);
    }

    private BitSet getReferences(int iObj, BitSet references) {
        FObject obj = this.objects.get(iObj);
        int nObj = this.objects.size();
        if (references == null) {
            references = new BitSet(nObj);
        }
        String eqn = UserFunction.padNames(this.getExpression(obj));
        BitSet directReferences = new BitSet();
        int i = 0;
        while (i < nObj) {
            if (i != iObj && UserFunction.containsWord(eqn, this.getName(this.objects.get(i)))) {
                directReferences.set(i);
                if (!references.get(i)) {
                    references.set(i);
                    references.or(this.getReferences(i, references));
                }
            }
            ++i;
        }
        this.setReferences(obj, directReferences);
        return references;
    }

    protected boolean isValidExpression(String expression) {
        String start;
        Parameter p = new Parameter("xxzz", expression);
        String s = this.getVariablesString("");
        if (!s.startsWith(start = ToolsRes.getString("FunctionPanel.Instructions.ValueCell"))) {
            return !Double.isNaN(p.evaluate(new Parameter[0]));
        }
        String[] names = s.substring(start.length()).split(" ");
        ArrayList<Parameter> temp = new ArrayList<Parameter>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Parameter next = new Parameter(name, "1");
            temp.add(next);
            ++n2;
        }
        double result = p.evaluate(temp);
        return !Double.isNaN(result);
    }

    protected boolean references(String name, HashSet<String> checked) {
        if (checked.contains(name)) {
            return false;
        }
        FObject obj = this.getObject(name);
        if (obj == null) {
            return false;
        }
        checked.add(name);
        String eqn = UserFunction.padNames(this.getExpression(obj));
        int i = 0;
        int n = this.objects.size();
        while (i < n) {
            FObject next = this.objects.get(i);
            if (next != obj && (UserFunction.containsWord(eqn, name = this.getName(next)) || this.references(name, checked))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected abstract void setReferences(FObject var1, BitSet var2);

    protected boolean haveGUI() {
        return this.haveGUI;
    }

    protected abstract void setTitles();

    protected void createGUI() {
        this.titledBorder = BorderFactory.createTitledBorder("");
        this.setBorder(this.titledBorder);
        this.table = new Table(this.tableModel);
        JScrollPane tableScroller = new JScrollPane(this.table);
        tableScroller.createHorizontalScrollBar();
        this.add((Component)tableScroller, "Center");
        if (this.addButtonPanel) {
            this.buttonPanel = new JPanel(new FlowLayout());
            this.newButton = new JButton();
            this.newButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String name = FunctionEditor.this.getDefaultName();
                    FObject obj = FunctionEditor.this.createUniqueObject(null, name, false);
                    FunctionEditor.this.addObject(obj, true);
                }
            });
            this.cutButton = new JButton();
            this.cutButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object[] array = FunctionEditor.this.getSelectedObjects();
                    FunctionEditor.this.copy(array);
                    int i = array.length;
                    while (i > 0) {
                        FunctionEditor.this.removeObject((FObject)array[i - 1], true);
                        --i;
                    }
                    FunctionEditor.this.evaluateAll();
                }
            });
            this.copyButton = new JButton();
            this.copyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FunctionEditor.this.copy(FunctionEditor.this.getSelectedObjects());
                }
            });
            this.pasteButton = new JButton();
            this.pasteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FunctionEditor.this.pasteAction();
                }
            });
            this.buttonPanel.add(this.newButton);
            this.buttonPanel.add(this.copyButton);
            this.buttonPanel.add(this.cutButton);
            this.buttonPanel.add(this.pasteButton);
            this.add((Component)this.buttonPanel, "North");
            this.buttonPanel.addMouseListener(this.tableFocuser);
        }
        this.table.getTableHeader().addMouseListener(this.tableFocuser);
        tableScroller.addMouseListener(this.tableFocuser);
        this.addMouseListener(this.tableFocuser);
        this.haveGUI = true;
    }

    public void refreshGUI() {
        if (!this.haveGUI) {
            return;
        }
        if (this.lang == ToolsRes.getLanguage()) {
            return;
        }
        this.lang = ToolsRes.getLanguage();
        this.setTitles();
        this.titledBorder.setTitle(this.titledBorderText == null ? ToolsRes.getString("FunctionEditor.Border.Title") : this.titledBorderText);
        if (this.addButtonPanel) {
            this.cutButton.setText(ToolsRes.getString("FunctionEditor.Button.Cut"));
            this.cutButton.setToolTipText(ToolsRes.getString("FunctionEditor.Button.Cut.Tooltip"));
            this.copyButton.setText(ToolsRes.getString("FunctionEditor.Button.Copy"));
            this.copyButton.setToolTipText(ToolsRes.getString("FunctionEditor.Button.Copy.Tooltip"));
            this.pasteButton.setText(ToolsRes.getString("FunctionEditor.Button.Paste"));
            this.pasteButton.setToolTipText(ToolsRes.getString("FunctionEditor.Button.Paste.Tooltip"));
            this.newButton.setText(ToolsRes.getString("FunctionEditor.Button.New"));
            this.newButton.setToolTipText(this.newButtonTipText == null ? ToolsRes.getString("FunctionEditor.Button.New.Tooltip") : this.newButtonTipText);
        }
        sciFormat0000.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
        decimalFormat.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
        int i = 2;
        while (--i >= 0) {
            this.table.getColumnModel().getColumn(i).setHeaderValue(this.tableModel.getColumnName(i));
        }
        this.repaint();
        if (this.popupEditor != null && this.popupEditor.isVisible()) {
            this.tableCellEditor.stopCellEditing();
        }
        this.popupEditor = null;
    }

    public void setBorderTitle(String title) {
        this.checkGUI();
        this.titledBorder.setTitle(title);
    }

    protected void enableMenuButtons() {
        if (!this.addButtonPanel || !this.haveGUI) {
            return;
        }
        FObject o = this.getSelectedObject();
        this.copyButton.setEnabled(o != null);
        this.cutButton.setEnabled(o != null && this.isRemovable(this.getSelectedObject()));
        this.getClipboardContentsAsync(contents -> this.pasteButton.setEnabled(contents != null));
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.enableMenuButtons();
        }
    }

    protected ParamEditor getParamEditor() {
        return this.paramEditor;
    }

    protected void setParamEditor(ParamEditor editor) {
        if (this.paramEditor == null && editor != null) {
            this.paramEditor = editor;
            this.evaluateAll();
            this.refreshGUI();
        }
    }

    public FunctionPanel getFunctionPanel() {
        return this.functionPanel;
    }

    public void setFunctionPanel(FunctionPanel panel) {
        this.functionPanel = panel;
    }

    protected String getDefaultName() {
        return ToolsRes.getString("FunctionEditor.New.Name.Default");
    }

    protected String getVariablesString(String separator) {
        String selectedName = this.getName(this.getSelectedObject());
        StringBuffer vars = new StringBuffer("");
        if (this.skipAllName == null || !this.skipAllName.equals(selectedName)) {
            int i = 0;
            while (i < this.names.length) {
                if (!this.names[i].equals(selectedName)) {
                    vars.append(" ");
                    vars.append(this.names[i]);
                }
                ++i;
            }
        }
        return this.getVariablesString(vars, separator);
    }

    public String getVariablesString(StringBuffer vars, String separator) {
        return vars.length() == 0 ? ToolsRes.getString("FunctionPanel.Instructions.Help") : String.valueOf(ToolsRes.getString("FunctionPanel.Instructions.ValueCell")) + separator + vars.substring(1);
    }

    private int getRemovableRowCount() {
        int n = 0;
        int i = this.objects.size();
        while (--i >= 0) {
            if (!this.isRemovable(this.objects.get(i))) continue;
            ++n;
        }
        return n;
    }

    protected int getPartlyEditableRowCount() {
        int n = 0;
        int i = this.objects.size();
        while (--i >= 0) {
            FObject obj = this.objects.get(i);
            if (!this.isNameEditable(obj) && !this.isExpressionEditable(obj)) continue;
            ++n;
        }
        return n;
    }

    protected abstract boolean isInvalidExpression(FObject var1);

    public boolean containsInvalidExpressions() {
        int i = this.objects.size();
        while (--i >= 0) {
            if (!this.isInvalidExpression(this.objects.get(i))) continue;
            return true;
        }
        return false;
    }

    private void copy(Object[] array) {
        if (array != null && array.length > 0) {
            XMLControlElement control = new XMLControlElement(this);
            control.setValue("selected", array);
            OSPRuntime.copy(control.toXML(), null);
            this.pasteButton.setEnabled(true);
            this.firePropertyChange(PROPERTY_FUNCTIONEDITOR_CLIPBOARD, null, null);
        }
    }

    protected void pasteAction() {
        this.getClipboardContentsAsync(controls -> {
            if (controls == null) {
                return;
            }
            int i = 0;
            while (i < ((XMLControl[])controls).length) {
                FObject obj = (FObject)controls[i].loadObject(null);
                this.addObject(obj, true);
                ++i;
            }
            this.evaluateAll();
        });
    }

    protected void getClipboardContentsAsync(Consumer<XMLControl[]> c) {
        OSPRuntime.paste(dataString -> {
            if (dataString != null) {
                XMLControlElement control = new XMLControlElement();
                control.readXML((String)dataString);
                if (control.getObjectClass() == this.getClass()) {
                    List<XMLProperty> list = control.getPropsRaw();
                    int i = 0;
                    int n = list.size();
                    while (i < n) {
                        XMLProperty prop = list.get(i);
                        if (prop.getPropertyName().equals("selected")) {
                            c.accept(prop.getChildControls());
                            return;
                        }
                        ++i;
                    }
                }
            }
            c.accept(null);
        });
    }

    protected FObject getSelectedObject() {
        if (this.table == null) {
            return null;
        }
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return this.objects.get(row);
    }

    protected FObject[] getSelectedObjects() {
        if (this.table == null) {
            return null;
        }
        int[] rows = this.table.getSelectedRows();
        FObject[] selected = new FObject[rows.length];
        int i = 0;
        while (i < rows.length) {
            selected[i] = this.objects.get(rows[i]);
            ++i;
        }
        return selected;
    }

    protected abstract FObject createObject(String var1, String var2, FObject var3);

    protected boolean isDisallowedName(FObject obj, String name) {
        if (this.forbiddenNames.contains(name)) {
            return true;
        }
        for (FObject next : this.objects) {
            if (next == obj || !name.equals(this.getName(next))) continue;
            return true;
        }
        if (this.paramEditor != null && this.paramEditor != this) {
            Parameter[] params = this.paramEditor.getParameters();
            int i = 0;
            while (i < params.length) {
                if (params[i] != obj && name.equals(params[i].getName())) {
                    return true;
                }
                ++i;
            }
        }
        return !Double.isNaN(FunctionEditor.getNumber(name));
    }

    private static double getNumber(String name) {
        if (FunctionEditor.couldBeNumber(name)) {
            try {
                return Double.parseDouble(name);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Double.NaN;
    }

    private static boolean couldBeNumber(String n) {
        return n.length() > 0 && "+-.I0123456789".indexOf(n.charAt(0)) >= 0;
    }

    private String getValidName(String proposedName) {
        if (proposedName == null || proposedName.trim().equals("")) {
            return "";
        }
        String name = proposedName;
        ArrayList<String> invalid = this.getInvalidTokens(name);
        while (!invalid.isEmpty()) {
            for (String next : invalid) {
                int n = name.indexOf(next);
                while (n > -1) {
                    name = n == 0 ? name.substring(next.length()) : String.valueOf(name.substring(0, n)) + name.substring(n + next.length());
                    n = name.indexOf(next);
                }
            }
            String input = GUIUtils.showInputDialog(this, ToolsRes.getString("FunctionEditor.Dialog.InvalidName.Message"), ToolsRes.getString("FunctionEditor.Dialog.InvalidName.Title"), 2, name);
            if (input == null) {
                return null;
            }
            if (input.equals(name)) break;
            name = input;
            invalid = this.getInvalidTokens(name);
        }
        if (name.length() > 0 && Character.isDigit(name.charAt(0))) {
            JOptionPane.showMessageDialog(this, ToolsRes.getString("FunctionEditor.Dialog.InvalidNumberInName.Text"), ToolsRes.getString("FunctionEditor.Dialog.InvalidName.Title"), 2);
            return "";
        }
        return name;
    }

    private ArrayList<String> getInvalidTokens(String name) {
        ArrayList<String> invalid = new ArrayList<String>();
        if (name.indexOf(" ") > -1) {
            invalid.add(" ");
        }
        String[] suspects = FunctionTool.parserOperators;
        int i = 0;
        while (i < suspects.length) {
            if (name.indexOf(suspects[i]) > -1) {
                invalid.add(suspects[i]);
            }
            ++i;
        }
        return invalid;
    }

    protected FObject createUniqueObject(FObject obj, String proposedName, boolean confirmChanges) {
        if ((proposedName = this.getValidName(proposedName)) == null || proposedName.trim().equals("")) {
            return null;
        }
        String name = proposedName;
        while (this.isDisallowedName(obj, proposedName)) {
            int i = 0;
            while (this.isDisallowedName(obj, name)) {
                name = String.valueOf(proposedName) + ++i;
            }
            if (!confirmChanges) break;
            String input = GUIUtils.showInputDialog(this, "\"" + proposedName + "\" " + ToolsRes.getString("FunctionEditor.Dialog.DuplicateName.Message"), ToolsRes.getString("FunctionEditor.Dialog.DuplicateName.Title"), 2, name);
            if (input == null) {
                return null;
            }
            if (input.equals("") || input.equals(name)) break;
            name = proposedName = input;
        }
        String expression = obj == null ? "0" : this.getExpression(obj);
        return this.createObject(name, expression, obj);
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean getVariablePoints(JTextPane variablesPane, Point pt, int[] ret) {
        text = variablesPane.getText();
        pt0 = text.indexOf(":\n") + 2;
        if (pt0 < 2) {
            return false;
        }
        doc = variablesPane.getStyledDocument();
        doc.setCharacterAttributes(0, text.length(), doc.getStyle("blue"), false);
        ptvar = variablesPane.viewToModel(pt);
        if (ptvar >= pt0 && ptvar != text.length()) ** GOTO lbl12
        return false;
        while (!(s = text.substring(pt0, ptvar)).endsWith(" ")) {
            --ptvar;
lbl12:
            // 2 sources

            if (ptvar > pt0) continue;
        }
        s = text.substring(ptvar);
        len = s.indexOf(",");
        if (len < 0) {
            len = s.indexOf(" ");
        }
        if (len < 0) {
            len = s.length();
        }
        doc.setCharacterAttributes(ptvar, len, doc.getStyle("red"), false);
        ret[0] = ptvar;
        ret[1] = ptvar + len;
        return true;
    }

    public static String format(double value, double zeroLevel) {
        double absVal;
        int rounded;
        if (Math.abs(value) < zeroLevel) {
            value = 0.0;
        }
        if (Math.abs(value - (double)(rounded = (int)Math.round(value))) < zeroLevel) {
            value = rounded;
        }
        boolean scientific = (absVal = Math.abs(value)) < 0.01 && value != 0.0 || absVal >= 1000.0;
        String s = scientific ? sciFormat0000.format(value) : decimalFormat.format(value);
        int n = s.indexOf("E");
        String tail = n > -1 ? s.substring(n) : "";
        s = n > -1 ? s.substring(0, n) : s;
        if ((n = s.indexOf("0000")) > 1) {
            s = s.substring(0, n + 1);
        }
        if ((n = s.indexOf("9999")) > 1) {
            DecimalFormatSymbols symbols;
            char separator;
            int m = (s = s.substring(0, n)).indexOf(separator = (symbols = sciFormat0000.getDecimalFormatSymbols()).getDecimalSeparator());
            if (m == s.length() - 1) {
                int i = Integer.parseInt(s.substring(0, m)) + 1;
                s = String.valueOf(Integer.toString(i)) + separator + "0";
            } else {
                int i = Integer.parseInt(s.substring(n - 1)) + 1;
                s = String.valueOf(s.substring(0, n - 1)) + i;
            }
        }
        return String.valueOf(s) + tail;
    }

    public static double round(double value, int sigfigs) {
        if (value == 0.0) {
            return value;
        }
        int multiplier = value < 0.0 ? -1 : 1;
        value = Math.abs(value);
        double limit = Math.pow(10.0, sigfigs - 1);
        int power = 0;
        while (value < limit) {
            value *= 10.0;
            ++power;
        }
        while (value > 10.0 * limit) {
            value /= 10.0;
            --power;
        }
        value = Math.round(value);
        return (double)multiplier * value / Math.pow(10.0, power);
    }

    public void tabToNext() {
        this.newButton.requestFocusInWindow();
    }

    private class CellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JPanel panel = new JPanel(new BorderLayout());
        JTextField field = new JTextField();
        boolean keyPressed = false;
        boolean mouseClicked = false;
        JPanel editorPane;
        JPanel dragPane;
        JTextField popupField = new JTextField();
        JTextPane variablesPane;
        JButton revertButton;
        ValueMouseControl valueMouseController;
        int minPopupWidth;
        int varBegin;
        int varEnd;
        FObject prevObject;
        String prevName;
        String prevExpression;
        boolean isExpression;

        CellEditor() {
            this.panel.setFocusable(false);
            this.panel.add((Component)this.field, "Center");
            this.panel.setOpaque(false);
            this.panel.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 2));
            this.field.setBorder(null);
            this.field.setEditable(true);
            this.field.setFont(this.field.getFont().deriveFont(18.0f));
            this.field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        CellEditor.this.keyPressed = true;
                        CellEditor.this.stopCellEditing();
                    } else {
                        CellEditor.this.field.setBackground(Color.yellow);
                    }
                }
            });
            this.field.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    CellEditor.this.stopCellEditing();
                    undoEditsEnabled = true;
                    CellEditor.this.mouseClicked = false;
                    ((CellEditor)CellEditor.this).FunctionEditor.this.table.clearSelection();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (!CellEditor.this.mouseClicked) {
                        CellEditor.this.stopCellEditing();
                    }
                    if (CellEditor.this.keyPressed) {
                        CellEditor.this.keyPressed = false;
                        ((CellEditor)CellEditor.this).FunctionEditor.this.table.requestFocusInWindow();
                    }
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable atable, Object value, boolean isSelected, int row, int column) {
            FunctionEditor.this.table.rowToSelect = row;
            FunctionEditor.this.table.columnToSelect = column;
            undoEditsEnabled = false;
            JDialog popup = this.getPopupEditor();
            if (FunctionEditor.this.functionPanel.functionTool != null) {
                int level = FunctionEditor.this.functionPanel.functionTool.getFontLevel();
                FontSizer.setFonts(popup, level);
            }
            FunctionEditor.this.dragLabel.setText(ToolsRes.getString("FunctionEditor.DragLabel.Text"));
            this.prevObject = FunctionEditor.this.objects.get(row);
            if (this.prevObject != null) {
                this.prevName = FunctionEditor.this.getName(this.prevObject);
                this.prevExpression = FunctionEditor.this.getExpression(this.prevObject);
            }
            String val = value.toString();
            if (this.prevObject != null && column > 0) {
                int n = val.indexOf(FunctionEditor.DEGREES);
                val = n >= 0 ? val.substring(0, n) : this.prevExpression;
            }
            this.popupField.setText(val);
            this.popupField.requestFocusInWindow();
            this.setInitialValues();
            this.popupField.selectAll();
            this.popupField.setBackground(Color.WHITE);
            if (column == 1) {
                this.variablesPane.setText(FunctionEditor.this.getVariablesString(":\n"));
                StyledDocument doc = this.variablesPane.getStyledDocument();
                Style blue = doc.getStyle("blue");
                doc.setCharacterAttributes(0, this.variablesPane.getText().length(), blue, false);
                popup.getContentPane().add((Component)this.variablesPane, "Center");
            } else {
                popup.getContentPane().remove(this.variablesPane);
            }
            Rectangle cell = FunctionEditor.this.table.getCellRect(row, column, true);
            this.minPopupWidth = cell.width + 2;
            boolean b = this.dragPane.isVisible();
            this.dragPane.setVisible(true);
            Dimension dim = this.resizePopupEditor();
            this.dragPane.setVisible(b);
            Point p = FunctionEditor.this.table.getLocationOnScreen();
            popup.setLocation(p.x + cell.x + cell.width / 2 - dim.width / 2, p.y + cell.y + cell.height / 2 - dim.height / 2);
            popup.setVisible(true);
            return this.panel;
        }

        void setInitialValueAsync() {
            SwingUtilities.invokeLater(() -> this.setInitialValues());
        }

        protected void setInitialValues() {
            double value;
            String val = this.popupField.getText().replaceAll(",", ".");
            if ("".equals(val)) {
                val = "0";
            }
            if (Double.isNaN(value = FunctionEditor.getNumber(val))) {
                this.dragPane.setVisible(false);
            } else {
                this.valueMouseController.prevValue = value;
                this.popupField.setToolTipText(ToolsRes.getString("FunctionEditor.PopupField.Tooltip"));
                this.revertButton.setToolTipText(ToolsRes.getString("FunctionEditor.Button.Revert.Tooltip"));
                this.variablesPane.setToolTipText(ToolsRes.getString("FunctionEditor.VariablesPane.Tooltip"));
                int row = FunctionEditor.this.table.rowToSelect;
                String tooltip = ToolsRes.getString("FunctionEditor.DragLabel.Tooltip");
                FunctionEditor.this.dragLabel.setToolTipText(tooltip);
                String name = (String)FunctionEditor.this.table.getValueAt(row, 0);
                if (!name.equals("t")) {
                    this.dragPane.setVisible(true);
                } else {
                    this.dragPane.setVisible(false);
                }
            }
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e == null || e instanceof ActionEvent) {
                return true;
            }
            if (e instanceof MouseEvent) {
                FunctionEditor.this.firePropertyChange(FunctionEditor.PROPERTY_FUNCTIONEDITOR_FOCUS, null, null);
                if (((MouseEvent)e).getClickCount() == 2) {
                    this.mouseClicked = true;
                    SwingUtilities.invokeLater(() -> this.field.selectAll());
                    return true;
                }
            }
            return false;
        }

        @Override
        public Object getCellEditorValue() {
            this.popupField.setBackground(Color.WHITE);
            this.field.setBackground(Color.WHITE);
            SwingUtilities.invokeLater(() -> FunctionEditor.this.table.revalidate());
            return this.field.getText();
        }

        private Dimension resizePopupEditor() {
            String s = this.popupField.getText();
            Font font = this.popupField.getFont();
            Rectangle rect = font.getStringBounds(s, OSPRuntime.frc).getBounds();
            int h = rect.height;
            int w = Math.max(this.minPopupWidth, rect.width + 32);
            if (FunctionEditor.this.table.columnToSelect == 1) {
                s = this.variablesPane.getText();
                int n = s.indexOf("\n");
                s = s.substring(n + 1);
                font = this.variablesPane.getFont().deriveFont(1);
                rect = font.getStringBounds(s, OSPRuntime.frc).getBounds();
                w = Math.max(w, rect.width);
            }
            Dimension dim = new Dimension(w, h);
            this.editorPane.setPreferredSize(dim);
            FunctionEditor.this.popupEditor.pack();
            dim.width = FunctionEditor.this.popupEditor.getWidth();
            return dim;
        }

        private JDialog getPopupEditor() {
            if (FunctionEditor.this.popupEditor != null) {
                return FunctionEditor.this.popupEditor;
            }
            this.popupField.setEditable(true);
            Font font = this.popupField.getFont().deriveFont(24.0f);
            int level = FunctionEditor.this.functionPanel.functionTool.getFontLevel();
            font = FontSizer.getResizedFont(font, level);
            this.popupField.setFont(font);
            this.popupField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        CellEditor.this.getPopupValue();
                    } else {
                        CellEditor.this.popupField.setBackground(Color.yellow);
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        return;
                    }
                    CellEditor.this.setInitialValueAsync();
                }
            });
            this.variablesPane = GUIUtils.newJTextPane();
            this.variablesPane.setEditable(false);
            this.variablesPane.setFocusable(false);
            this.variablesPane.setBorder(this.popupField.getBorder());
            font = this.popupField.getFont().deriveFont(14.0f);
            font = FontSizer.getResizedFont(font, level);
            this.variablesPane.setFont(font);
            StyledDocument doc = this.variablesPane.getStyledDocument();
            Style def = StyleContext.getDefaultStyleContext().getStyle("default");
            StyleConstants.setFontFamily(def, "SansSerif");
            Style blue = doc.addStyle("blue", def);
            StyleConstants.setBold(blue, false);
            StyleConstants.setForeground(blue, Color.blue);
            Style red = doc.addStyle("red", blue);
            StyleConstants.setBold(red, true);
            StyleConstants.setForeground(red, Color.red);
            this.varEnd = 0;
            this.varBegin = 0;
            this.variablesPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (CellEditor.this.varEnd > 0) {
                        CellEditor.this.variablesPane.setCaretPosition(CellEditor.this.varBegin);
                        CellEditor.this.variablesPane.moveCaretPosition(CellEditor.this.varEnd);
                        CellEditor.this.popupField.replaceSelection(CellEditor.this.variablesPane.getSelectedText());
                        CellEditor.this.popupField.setBackground(Color.yellow);
                        CellEditor.this.setInitialValueAsync();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    StyledDocument doc = CellEditor.this.variablesPane.getStyledDocument();
                    doc.setCharacterAttributes(0, CellEditor.this.variablesPane.getText().length(), doc.getStyle("blue"), false);
                    CellEditor.this.varEnd = 0;
                    CellEditor.this.varBegin = 0;
                }
            });
            this.variablesPane.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    CellEditor.this.varEnd = 0;
                    CellEditor.this.varBegin = 0;
                    int[] ret = tempRange;
                    if (FunctionEditor.getVariablePoints(CellEditor.this.variablesPane, e.getPoint(), ret)) {
                        CellEditor.this.varBegin = ret[0];
                        CellEditor.this.varEnd = ret[1];
                    }
                }
            });
            this.dragPane = new JPanel(new BorderLayout());
            this.dragPane.setBackground(new Color(240, 255, 240));
            FunctionEditor.this.dragLabel = new JLabel();
            FunctionEditor.this.dragLabel.setHorizontalAlignment(0);
            Border line = BorderFactory.createLineBorder(LIGHT_BLUE);
            Border space = BorderFactory.createEmptyBorder(2, 3, 2, 3);
            FunctionEditor.this.dragLabel.setBorder(BorderFactory.createCompoundBorder(line, space));
            font = this.popupField.getFont().deriveFont(12.0f);
            font = FontSizer.getResizedFont(font, level);
            FunctionEditor.this.dragLabel.setFont(font);
            FunctionEditor.this.dragLabel.setForeground(Color.green.darker().darker());
            this.dragPane.add((Component)FunctionEditor.this.dragLabel, "Center");
            this.valueMouseController = new ValueMouseControl(FunctionEditor.this.tableCellEditor);
            FunctionEditor.this.dragLabel.addMouseListener(this.valueMouseController);
            FunctionEditor.this.dragLabel.addMouseMotionListener(this.valueMouseController);
            String imageFile = "/org/opensourcephysics/resources/tools/images/close.gif";
            ImageIcon icon = ResourceLoader.getImageIcon(imageFile);
            this.revertButton = new JButton(icon);
            line = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
            space = BorderFactory.createEmptyBorder(0, 2, 0, 2);
            this.revertButton.setBorder(BorderFactory.createCompoundBorder(line, space));
            this.revertButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CellEditor.this.prevObject != null) {
                        if (((CellEditor)CellEditor.this).FunctionEditor.this.table.columnToSelect == 1) {
                            ((CellEditor)CellEditor.this).FunctionEditor.this.table.setValueAt(CellEditor.this.prevExpression, ((CellEditor)CellEditor.this).FunctionEditor.this.table.rowToSelect, 1);
                            CellEditor.this.field.setText(CellEditor.this.prevExpression);
                        } else {
                            ((CellEditor)CellEditor.this).FunctionEditor.this.table.setValueAt(CellEditor.this.prevName, ((CellEditor)CellEditor.this).FunctionEditor.this.table.rowToSelect, 0);
                            CellEditor.this.field.setText(CellEditor.this.prevName);
                        }
                        CellEditor.this.stopCellEditing();
                        undoEditsEnabled = true;
                    }
                    CellEditor.this.popupField.setBackground(Color.WHITE);
                    ((CellEditor)CellEditor.this).FunctionEditor.this.popupEditor.setVisible(false);
                }
            });
            Frame frame = JOptionPane.getFrameForComponent(FunctionEditor.this);
            FunctionEditor.this.popupEditor = new JDialog(frame, true);
            FunctionEditor.this.popupEditor.setUndecorated(true);
            FunctionEditor.this.popupEditor.getRootPane().setWindowDecorationStyle(0);
            JPanel contentPane = new JPanel(new BorderLayout());
            FunctionEditor.this.popupEditor.setContentPane(contentPane);
            this.editorPane = new JPanel(new BorderLayout());
            this.editorPane.setBackground(Color.WHITE);
            this.editorPane.add((Component)this.popupField, "Center");
            this.editorPane.add((Component)this.revertButton, "East");
            contentPane.add((Component)this.editorPane, "North");
            contentPane.add((Component)this.dragPane, "South");
            return FunctionEditor.this.popupEditor;
        }

        protected void getPopupValue() {
            String text = this.popupField.getText().trim();
            char separator = sciFormat0000.getDecimalFormatSymbols().getDecimalSeparator();
            if (separator == ',' && FunctionEditor.this.tableCellEditor.isExpression && !FunctionEditor.this.isValidExpression(text) && (text.contains("if(") || text.contains("if ("))) {
                JOptionPane.showMessageDialog(FunctionEditor.this, String.valueOf(ToolsRes.getString("FunctionEditor.Dialog.IfStatementError.Message1")) + "\n" + ToolsRes.getString("FunctionEditor.Dialog.IfStatementError.Message2"), ToolsRes.getString("FunctionEditor.Dialog.IfStatementError.Title"), 0);
                return;
            }
            int row = FunctionEditor.this.table.rowToSelect;
            FunctionEditor.this.objects.remove(row);
            FunctionEditor.this.objects.add(row, this.prevObject);
            if (FunctionEditor.this.table.columnToSelect == 1) {
                FunctionEditor.this.table.setValueAt(this.prevExpression, row, 1);
            }
            this.field.setText(text);
            undoEditsEnabled = true;
            this.keyPressed = true;
            FunctionEditor.this.popupEditor.setVisible(false);
            if (FunctionEditor.this.table.columnToSelect == 1) {
                FunctionEditor.this.table.setValueAt(text, row, 1);
            }
            this.field.requestFocusInWindow();
            this.field.selectAll();
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        Font font = new JTextField().getFont();

        public CellRenderer() {
            this.setOpaque(true);
            this.setFont(this.font);
            this.setHorizontalAlignment(2);
            this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 2));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            String tooltipText;
            String val = value.toString();
            if (col == 0 && FunctionEditor.this instanceof UserFunctionEditor) {
                val = FitBuilder.localize(val);
            }
            this.setText(val);
            FObject obj = FunctionEditor.this.objects.get(row);
            String tooltip = FunctionEditor.this.getTooltip(obj);
            String string = col == 0 && tooltip != null ? tooltip : (tooltipText = col == 0 ? ToolsRes.getString("FunctionEditor.Table.Cell.Name.Tooltip") : ToolsRes.getString("FunctionEditor.Table.Cell.Value.Tooltip"));
            if (tooltip == null && col == 0) {
                tooltipText = String.valueOf(tooltipText) + " (" + ToolsRes.getString("FunctionEditor.Tooltip.HowToEdit") + ")";
            }
            this.setToolTipText(tooltipText);
            if (col == 1 && FunctionEditor.this.circularErrors.get(row)) {
                this.setToolTipText(ToolsRes.getString("FunctionEditor.Table.Cell.CircularErrors.Tooltip"));
                this.setForeground(DARK_RED);
                if (isSelected) {
                    this.setBackground(MEDIUM_RED);
                } else {
                    this.setBackground(LIGHT_RED);
                }
            } else if (col == 1 && FunctionEditor.this.isInvalidExpression(obj)) {
                this.setToolTipText(ToolsRes.getString("FunctionEditor.Table.Cell.Invalid.Tooltip"));
                this.setForeground(DARK_RED);
                if (isSelected) {
                    this.setBackground(MEDIUM_RED);
                } else {
                    this.setBackground(LIGHT_RED);
                }
            } else if (col == 0 && !FunctionEditor.this.isNameEditable(obj) || col == 1 && !FunctionEditor.this.isExpressionEditable(obj)) {
                this.setForeground(Color.BLACK);
                this.setBackground(LIGHT_GRAY);
            } else if (isSelected) {
                this.setForeground(hasFocus ? Color.BLUE : Color.BLACK);
                this.setBackground(LIGHT_BLUE);
            } else {
                this.setForeground(Color.BLACK);
                this.setBackground(Color.WHITE);
            }
            this.setFont(col == 0 && FunctionEditor.this.isImportant(obj) ? this.font.deriveFont(1) : this.font);
            FunctionEditor.this.enableMenuButtons();
            return this;
        }
    }

    public class DefaultEdit
    extends AbstractUndoableEdit {
        Object redoObj;
        Object undoObj;
        int redoRow;
        int redoCol;
        int undoRow;
        int undoCol;
        int editType;
        String name;
        boolean isNew = true;

        public DefaultEdit(int type, Object newVal, int newRow, int newCol, Object prevVal, int prevRow, int prevCol, String name) {
            this.editType = type;
            this.redoObj = newVal;
            this.undoObj = prevVal;
            this.redoRow = newRow;
            this.redoCol = newCol;
            this.undoRow = prevRow;
            this.undoCol = prevCol;
            this.name = name;
        }

        @Override
        public void undo() throws CannotUndoException {
            this.isNew = false;
            super.undo();
            undoEditsEnabled = false;
            switch (this.editType) {
                case 0: {
                    FunctionEditor.this.removeObject((FObject)this.undoObj, false);
                    break;
                }
                case 1: {
                    FunctionEditor.this.addObject((FObject)this.undoObj, this.undoRow, false, true);
                    break;
                }
                case 2: {
                    FObject obj = FunctionEditor.this.objects.get(this.undoRow);
                    String expression = FunctionEditor.this.getExpression(obj);
                    this.name = this.undoObj.toString();
                    String prevName = this.redoObj.toString();
                    obj = FunctionEditor.this.createObject(this.name, expression, obj);
                    FunctionEditor.this.objects.remove(this.undoRow);
                    FunctionEditor.this.objects.add(this.undoRow, obj);
                    FunctionEditor.this.evaluateAll();
                    FunctionEditor.this.firePropertyChange(FunctionEditor.PROPERTY_FUNCTIONEDITOR_EDIT, this.name, prevName);
                    break;
                }
                case 3: {
                    FObject obj = FunctionEditor.this.objects.get(this.undoRow);
                    Object[] undoArray = (Object[])this.undoObj;
                    obj = FunctionEditor.this.createObject(this.name, undoArray[0].toString(), obj);
                    FunctionEditor.this.objects.remove(this.undoRow);
                    FunctionEditor.this.objects.add(this.undoRow, obj);
                    FunctionEditor.this.evaluateAll();
                    FunctionEditor.this.firePropertyChange(FunctionEditor.PROPERTY_FUNCTIONEDITOR_EDIT, this.name, this);
                }
            }
            FunctionEditor.this.table.rowToSelect = this.undoRow;
            FunctionEditor.this.table.columnToSelect = this.undoCol;
            FunctionEditor.this.getTable().selectOnFocus = true;
            FunctionEditor.this.getTable().requestFocusInWindow();
            FunctionEditor.this.refreshGUI();
            undoEditsEnabled = true;
        }

        @Override
        public void redo() throws CannotUndoException {
            this.isNew = false;
            super.redo();
            undoEditsEnabled = false;
            switch (this.editType) {
                case 0: {
                    FunctionEditor.this.addObject((FObject)this.redoObj, this.redoRow, false, true);
                    break;
                }
                case 1: {
                    FunctionEditor.this.removeObject((FObject)this.redoObj, false);
                    break;
                }
                case 2: {
                    FObject obj = FunctionEditor.this.objects.get(this.redoRow);
                    String expression = FunctionEditor.this.getExpression(obj);
                    this.name = this.redoObj.toString();
                    String prevName = this.undoObj.toString();
                    obj = FunctionEditor.this.createObject(this.name, expression, obj);
                    FunctionEditor.this.objects.remove(this.redoRow);
                    FunctionEditor.this.objects.add(this.redoRow, obj);
                    FunctionEditor.this.evaluateAll();
                    FunctionEditor.this.firePropertyChange(FunctionEditor.PROPERTY_FUNCTIONEDITOR_EDIT, this.name, prevName);
                    break;
                }
                case 3: {
                    FObject obj = FunctionEditor.this.objects.get(this.redoRow);
                    Object[] redoArray = (Object[])this.redoObj;
                    ArrayList buttons = (ArrayList)redoArray[1];
                    for (Object next : buttons) {
                        AbstractButton b = (AbstractButton)next;
                        if (b.isSelected()) continue;
                        b.doClick(0);
                    }
                    obj = FunctionEditor.this.createObject(this.name, redoArray[0].toString(), obj);
                    FunctionEditor.this.objects.remove(this.redoRow);
                    FunctionEditor.this.objects.add(this.redoRow, obj);
                    FunctionEditor.this.evaluateAll();
                    FunctionEditor.this.firePropertyChange(FunctionEditor.PROPERTY_FUNCTIONEDITOR_EDIT, this.name, this);
                }
            }
            FunctionEditor.this.table.rowToSelect = this.redoRow;
            FunctionEditor.this.table.columnToSelect = this.redoCol;
            FunctionEditor.this.getTable().selectOnFocus = true;
            FunctionEditor.this.getTable().requestFocusInWindow();
            FunctionEditor.this.refreshGUI();
            undoEditsEnabled = true;
        }

        @Override
        public String getPresentationName() {
            if (this.editType == 1) {
                return "Deletion";
            }
            return "Edit";
        }

        public boolean isNew() {
            return this.isNew;
        }

        public int getEditType() {
            return this.editType;
        }
    }

    public static interface FObject {
    }

    public class Table
    extends JTable {
        public boolean selectOnFocus = true;
        int rowToSelect;
        int columnToSelect;

        Table(TableModel model) {
            this.setModel(model);
            this.setSelectionMode(2);
            this.setColumnSelectionAllowed(false);
            this.getTableHeader().setReorderingAllowed(false);
            this.setGridColor(Color.BLACK);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    String name;
                    int row = Table.this.rowAtPoint(e.getPoint());
                    int col = Table.this.columnAtPoint(e.getPoint());
                    if (OSPRuntime.isPopupTrigger(e) && ((name = Table.this.getValueAt(row, 0).toString()).contains(THETA) || name.contains(OMEGA))) {
                        JPopupMenu popup = new JPopupMenu();
                        JMenuItem item = new JMenuItem();
                        item.setText(((Table)Table.this).FunctionEditor.this.anglesInDegrees ? ToolsRes.getString("FunctionEditor.Popup.MenuItem.SwitchToRadians") : ToolsRes.getString("FunctionEditor.Popup.MenuItem.SwitchToDegrees"));
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                FunctionEditor.this.setAnglesInDegrees(!((Table)(this).Table.this).FunctionEditor.this.anglesInDegrees);
                                FunctionEditor.this.firePropertyChange(FunctionEditor.PROPERTY_FUNCTIONEDITOR_ANGLESINRADIANS, null, !((Table)(this).Table.this).FunctionEditor.this.anglesInDegrees);
                            }
                        });
                        popup.add(item);
                        popup.show(((Table)Table.this).FunctionEditor.this.table, e.getX(), e.getY());
                    }
                    ((Table)Table.this).FunctionEditor.this.table.rowToSelect = row;
                    ((Table)Table.this).FunctionEditor.this.table.columnToSelect = col;
                    if (!((Table)Table.this).FunctionEditor.this.tableModel.isCellEditable(row, col)) {
                        ((Table)Table.this).FunctionEditor.this.functionPanel.clearSelection();
                        Table.this.selectOnFocus = false;
                    } else if (e.getClickCount() == 1) {
                        ((Table)Table.this).FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, col);
                        Table.this.selectOnFocus = ((Table)Table.this).FunctionEditor.this.table.hasFocus();
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (OSPRuntime.isPopupTrigger(e)) {
                        int col = Table.this.columnAtPoint(e.getPoint());
                        if (col != 0) {
                            return;
                        }
                        int row = Table.this.rowAtPoint(e.getPoint());
                        if (((Table)Table.this).FunctionEditor.this.tableModel.isCellEditable(row, col)) {
                            String name = (String)((Table)Table.this).FunctionEditor.this.table.getValueAt(row, col);
                            FObject obj = FunctionEditor.this.getObject(name);
                            String desc = FunctionEditor.this.getDescription(obj);
                            String message = ToolsRes.getString("FunctionEditor.Dialog.SetDescription.Message");
                            message = String.valueOf(message) + " \"" + name + "\"";
                            String input = GUIUtils.showInputDialog(FunctionEditor.this, message, ToolsRes.getString("FunctionEditor.Dialog.SetDescription.Title"), -1, desc);
                            if (input == null || input.equals(desc)) {
                                return;
                            }
                            desc = input;
                            FunctionEditor.this.setDescription(obj, desc);
                        }
                    }
                }
            });
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    Table.this.firePropertyChange(FunctionEditor.PROPERTY_FUNCTIONEDITOR_FOCUS, null, null);
                    if (Table.this.getRowCount() == 0) {
                        ((Table)Table.this).FunctionEditor.this.functionPanel.tabToNext(FunctionEditor.this);
                        return;
                    }
                    if (Table.this.selectOnFocus && Table.this.getRowCount() > 0) {
                        Table.this.selectCell(Table.this.rowToSelect, Table.this.columnToSelect);
                        int col = ((Table)Table.this).FunctionEditor.this.table.getSelectedColumn();
                        ((Table)Table.this).FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, col);
                    }
                    Table.this.selectOnFocus = true;
                }

                @Override
                public void focusLost(FocusEvent e) {
                    Table.this.rowToSelect = Math.max(0, Table.this.getSelectedRow());
                    Table.this.columnToSelect = Math.max(0, Table.this.getSelectedColumn());
                }
            });
            InputMap im = this.getInputMap(1);
            AbstractAction enterAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTable table = (JTable)e.getSource();
                    int row = table.getSelectedRow();
                    int column = table.getSelectedColumn();
                    table.editCellAt(row, column, e);
                    ((Table)Table.this).FunctionEditor.this.tableCellEditor.field.requestFocus();
                    ((Table)Table.this).FunctionEditor.this.tableCellEditor.field.selectAll();
                }
            };
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            OSPRuntime.setOSPAction(im, enter, "enter", this.getActionMap(), enterAction);
            KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
            AbstractAction tabAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rowCount = ((Table)Table.this).FunctionEditor.this.table.getRowCount();
                    int row = ((Table)Table.this).FunctionEditor.this.table.rowToSelect;
                    int col = ((Table)Table.this).FunctionEditor.this.table.columnToSelect;
                    boolean atEnd = col == 1 && row == rowCount - 1;
                    int n = col = col == 0 ? 1 : 0;
                    int n2 = col == 0 ? (row == Table.this.getRowCount() - 1 ? 0 : row + 1) : (row = row);
                    if (((Table)Table.this).FunctionEditor.this.table.isEditing()) {
                        ((Table)Table.this).FunctionEditor.this.table.rowToSelect = row;
                        ((Table)Table.this).FunctionEditor.this.table.columnToSelect = col;
                        ((Table)Table.this).FunctionEditor.this.tableCellEditor.stopCellEditing();
                    }
                    if (atEnd) {
                        ((Table)Table.this).FunctionEditor.this.functionPanel.tabToNext(FunctionEditor.this);
                        ((Table)Table.this).FunctionEditor.this.table.clearSelection();
                    } else {
                        ((Table)Table.this).FunctionEditor.this.table.requestFocusInWindow();
                        Table.this.selectCell(row, col);
                        ((Table)Table.this).FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, col);
                    }
                }
            };
            this.getActionMap().put(im.get(tab), tabAction);
        }

        /*
         * Unable to fully structure code
         */
        public void selectCell(int row, int col) {
            if (row == this.getRowCount()) {
                row = this.getRowCount() - 1;
                col = 0;
            }
            if (row != -1) ** GOTO lbl14
            return;
lbl-1000:
            // 1 sources

            {
                if (col == 0) {
                    col = 1;
                } else {
                    col = 0;
                    ++row;
                }
                if (row == this.getRowCount()) {
                    row = 0;
                }
                if (row == this.getSelectedRow() && col == this.getSelectedColumn()) break;
lbl14:
                // 2 sources

                ** while (!this.isCellEditable((int)row, (int)col))
            }
lbl15:
            // 2 sources

            FunctionEditor.this.table.rowToSelect = row;
            FunctionEditor.this.table.columnToSelect = col;
            FunctionEditor.this.table.changeSelection(row, col, false, false);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            FunctionEditor.this.tableCellEditor.isExpression = column == 1;
            return FunctionEditor.this.tableCellEditor;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            return FunctionEditor.this.tableCellRenderer;
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            this.getTableHeader().setFont(font);
            FunctionEditor.this.tableCellRenderer.font = font;
            FunctionEditor.this.tableCellEditor.field.setFont(font);
            int size = Math.max(font.getSize(), 24);
            FunctionEditor.this.tableCellEditor.popupField.setFont(font.deriveFont((float)size));
            this.setRowHeight(font.getSize() + 4);
        }
    }

    protected class TableModel
    extends AbstractTableModel {
        boolean settingValue = false;

        protected TableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return FunctionEditor.this.objects.size();
        }

        @Override
        public String getColumnName(int col) {
            return col == 0 ? ToolsRes.getString("FunctionEditor.Table.Column.Name") : ToolsRes.getString("FunctionEditor.Table.Column.Value");
        }

        @Override
        public Object getValueAt(int row, int col) {
            FObject obj = FunctionEditor.this.objects.get(row);
            String name = FunctionEditor.this.getName(obj);
            if (col == 0) {
                return name;
            }
            String expression = FunctionEditor.this.getExpression(obj);
            if (FunctionEditor.this.anglesInDegrees && (name.indexOf(THETA) >= 0 || name.indexOf(OMEGA) >= 0)) {
                boolean isOmega;
                double value;
                String express = expression;
                if (express.indexOf("if") == -1) {
                    express = express.replaceAll(",", ".");
                }
                if (Double.isNaN(value = FunctionEditor.getNumber(express))) {
                    return expression;
                }
                String s = FunctionEditor.format(value * 180.0 / Math.PI, 1.0E-4);
                boolean bl = isOmega = name.indexOf(OMEGA) >= 0;
                if (isOmega || name.indexOf(THETA) >= 0) {
                    s = String.valueOf(s) + FunctionEditor.DEGREES;
                }
                return s;
            }
            if (expression.indexOf("if") == -1) {
                boolean isComma = OSPRuntime.getCurrentDecimalSeparator() == ',';
                String express = expression;
                express = isComma ? express.replaceAll("\\.", ",") : express.replaceAll(",", ".");
                return express;
            }
            return expression;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (this.settingValue) {
                return;
            }
            if (value instanceof String) {
                String val = (String)value;
                int n = val.indexOf(FunctionEditor.DEGREES);
                if (n >= 0) {
                    val = val.substring(0, n);
                }
                String prev = null;
                int type = 0;
                FObject obj = FunctionEditor.this.objects.get(row);
                if (col == 0) {
                    prev = FunctionEditor.this.getName(obj);
                    type = 2;
                    this.settingValue = true;
                    if (!val.equals(prev)) {
                        obj = FunctionEditor.this.createUniqueObject(obj, val, true);
                        val = FunctionEditor.this.getName(obj);
                    }
                    this.settingValue = false;
                    if (obj == null || val.equals(prev)) {
                        FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, 0);
                        return;
                    }
                    FunctionEditor.this.objects.remove(row);
                    FunctionEditor.this.objects.add(row, obj);
                } else {
                    double d;
                    prev = FunctionEditor.this.getExpression(obj);
                    type = 3;
                    if (val.equals(prev)) {
                        FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, 1);
                        return;
                    }
                    if (val.equals("")) {
                        val = "0";
                    }
                    String name = FunctionEditor.this.getName(obj);
                    if (FunctionEditor.this.anglesInDegrees && (name.indexOf(THETA) >= 0 || name.indexOf(OMEGA) >= 0) && !Double.isNaN(d = FunctionEditor.getNumber(val))) {
                        val = String.valueOf(d * Math.PI / 180.0);
                    }
                    obj = FunctionEditor.this.createObject(FunctionEditor.this.getName(obj), val, obj);
                    FunctionEditor.this.objects.remove(row);
                    FunctionEditor.this.objects.add(row, obj);
                }
                FunctionEditor.this.evaluateAll();
                FunctionEditor.this.table.repaint();
                UndoableEdit edit = null;
                if (undoEditsEnabled) {
                    edit = FunctionEditor.this.getUndoableEdit(type, val, row, col, prev, row, col, FunctionEditor.this.getName(obj));
                }
                FunctionEditor.this.firePropertyChange(FunctionEditor.PROPERTY_FUNCTIONEDITOR_EDIT, FunctionEditor.this.getName(obj), edit);
                FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, col);
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            FObject obj = FunctionEditor.this.objects.get(row);
            return col == 0 ? FunctionEditor.this.isNameEditable(obj) : FunctionEditor.this.isExpressionEditable(obj);
        }
    }

    private class ValueMouseControl
    extends MouseAdapter {
        CellEditor cellEditor;
        double prevValue;
        double newValue;
        Point startingPoint;
        int logDelta;

        private ValueMouseControl(CellEditor editor) {
            this.cellEditor = editor;
        }

        int getLogDelta(String val, double relativeX) {
            int exp;
            int minus;
            if ("".equals(val)) {
                return 0;
            }
            int digits = val.length();
            int powerOfTen = 0;
            int decimal = val.replaceAll(",", ".").indexOf(".");
            if (decimal > -1) {
                --digits;
            }
            if ((minus = val.indexOf("-")) > -1) {
                --digits;
                --decimal;
            }
            if ((exp = val.indexOf("E")) > -1) {
                String exponent = val.substring(exp + 1);
                digits -= exponent.length() + 1;
                powerOfTen = Integer.parseInt(exponent);
            }
            int selectableDigits = exp > -1 ? digits : digits + 1;
            int selectedDigit = (int)Math.floor(relativeX * (double)selectableDigits);
            int integerDigits = decimal > -1 ? decimal : digits;
            return powerOfTen += integerDigits - selectedDigit - 1;
        }

        int getSelectionIndex(String val) {
            int exp;
            int minus;
            int powerOfTen = this.logDelta;
            int digits = val.length();
            int offset = 0;
            int decimal = val.replaceAll(",", ".").indexOf(".");
            if (decimal > -1) {
                --digits;
            }
            if ((minus = val.indexOf("-")) > -1) {
                --digits;
                offset = 1;
                --decimal;
            }
            if ((exp = val.indexOf("E")) > -1) {
                String exponent = val.substring(exp + 1);
                digits -= exponent.length() + 1;
                powerOfTen -= Integer.parseInt(exponent);
            }
            int integerDigits = decimal > -1 ? decimal : digits;
            int selectedDigit = integerDigits - powerOfTen - 1;
            int selectionIndex = selectedDigit + (offset += decimal > -1 && selectedDigit >= decimal ? 1 : 0);
            return selectionIndex;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int row = FunctionEditor.this.table.rowToSelect;
            String name = (String)FunctionEditor.this.table.getValueAt(row, 0);
            if (name.equals("t")) {
                this.startingPoint = null;
                return;
            }
            this.startingPoint = e.getPoint();
            this.newValue = this.prevValue;
            double level = 1.0 * (double)this.startingPoint.x / (double)this.cellEditor.dragPane.getWidth();
            this.logDelta = this.getLogDelta(this.cellEditor.popupField.getText(), level);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.startingPoint == null) {
                return;
            }
            this.prevValue = this.newValue;
            this.startingPoint = null;
            String val = this.cellEditor.popupField.getText();
            this.cellEditor.popupField.select(val.length(), val.length());
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.startingPoint == null || Double.isNaN(this.prevValue)) {
                return;
            }
            int pixelsPerStep = e.isShiftDown() ? 1 : 10;
            int d = (e.getPoint().x - this.startingPoint.x) / pixelsPerStep;
            double delta = Math.pow(10.0, this.logDelta);
            this.newValue = this.prevValue + (double)d * delta;
            String s = FunctionEditor.format(this.newValue, 0.0);
            int row = FunctionEditor.this.table.rowToSelect;
            FunctionEditor.this.table.setValueAt(s, row, 1);
            this.cellEditor.popupField.setText(s);
            this.cellEditor.popupField.setBackground(Color.yellow);
            this.cellEditor.popupField.requestFocusInWindow();
            String val = this.cellEditor.popupField.getText();
            int index = this.getSelectionIndex(val);
            this.cellEditor.popupField.select(index, index + 1);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            double level = 1.0 * (double)e.getPoint().x / (double)this.cellEditor.dragPane.getWidth();
            String val = this.cellEditor.popupField.getText();
            this.logDelta = this.getLogDelta(val, level);
            int index = this.getSelectionIndex(val);
            this.cellEditor.popupField.select(index, index + 1);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.cellEditor.dragPane.setCursor(Cursor.getPredefinedCursor(10));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.cellEditor.dragPane.setCursor(Cursor.getDefaultCursor());
        }
    }
}

