/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.tools.DataFunctionEditor;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.ParamEditor;
import org.opensourcephysics.tools.ToolsRes;

public class FunctionPanel
extends JPanel
implements PropertyChangeListener {
    protected FunctionTool functionTool;
    protected ParamEditor paramEditor;
    protected FunctionEditor functionEditor;
    private UndoableEditSupport undoSupport;
    protected UndoManager undoManager;
    protected String prevName;
    protected String description;
    protected Container box;
    protected JTextPane instructions;
    protected JTextField tableEditorField;
    private JButton undoButton;
    private JButton redoButton;
    private Icon icon;
    private boolean haveGUI;
    private String lang = null;
    private Object lastInstruction;

    protected boolean haveGUI() {
        return this.haveGUI;
    }

    public FunctionPanel(FunctionEditor editor) {
        super(new BorderLayout());
        this.functionEditor = editor;
        editor.functionPanel = this;
        this.init();
    }

    protected void init() {
        this.paramEditor = this.functionEditor instanceof DataFunctionEditor ? new ParamEditor(((DataFunctionEditor)this.functionEditor).getData()) : new ParamEditor();
        this.paramEditor.functionPanel = this;
        this.functionEditor.setParamEditor(this.paramEditor);
        this.paramEditor.setFunctionEditors(new FunctionEditor[]{this.functionEditor});
        this.paramEditor.addPropertyChangeListener(this);
        this.paramEditor.addPropertyChangeListener(this.functionEditor);
        this.functionEditor.addPropertyChangeListener(this);
        this.functionEditor.addPropertyChangeListener(this.paramEditor);
    }

    public void checkGUI() {
        if (!this.haveGUI) {
            this.createGUI();
            this.refreshGUI();
        }
    }

    protected void createGUI() {
        this.haveGUI = true;
        this.instructions = GUIUtils.newJTextPane();
        this.instructions.setMinimumSize(new Dimension(300, 60));
        this.instructions.setEditable(false);
        this.instructions.setOpaque(false);
        this.instructions.setFocusable(false);
        this.instructions.setBackground(Color.yellow);
        this.instructions.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        StyledDocument doc = this.instructions.getStyledDocument();
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        StyleConstants.setFontFamily(def, "SansSerif");
        Style blue = doc.addStyle("blue", def);
        StyleConstants.setBold(blue, false);
        StyleConstants.setForeground(blue, Color.blue);
        Style red = doc.addStyle("red", blue);
        StyleConstants.setBold(red, true);
        StyleConstants.setForeground(red, Color.red);
        this.box = Box.createVerticalBox();
        this.box.add(this.paramEditor);
        this.box.add(this.functionEditor);
        this.box.add(new JScrollPane(this.instructions){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                Font font = FunctionPanel.this.instructions.getFont();
                dim.height = Math.max(dim.height, font.getSize() * 4);
                return dim;
            }
        });
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoManager);
        this.undoButton = new JButton();
        this.undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionPanel.this.undoManager.undo();
            }
        });
        this.redoButton = new JButton();
        this.redoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionPanel.this.undoManager.redo();
            }
        });
        this.clearSelection();
        this.add((Component)this.box, "Center");
    }

    protected void refreshGUI() {
        if (!this.haveGUI) {
            return;
        }
        if (this.functionTool != null && this.functionTool.getSelectedPanel() == this && !this.functionTool.hasButton(this.undoButton)) {
            this.functionTool.setButtonBar(new Object[]{"help", this.undoButton, this.redoButton, "close"});
        }
        this.undoButton.setEnabled(this.undoManager.canUndo());
        this.redoButton.setEnabled(this.undoManager.canRedo());
        this.lastInstruction = null;
        this.refreshInstructions(null, -1);
        if (this.lang == ToolsRes.getLanguage()) {
            return;
        }
        this.lang = ToolsRes.getLanguage();
        this.undoButton.setText(ToolsRes.getString("DataFunctionPanel.Button.Undo"));
        this.undoButton.setToolTipText(ToolsRes.getString("DataFunctionPanel.Button.Undo.Tooltip"));
        this.redoButton.setText(ToolsRes.getString("DataFunctionPanel.Button.Redo"));
        this.redoButton.setToolTipText(ToolsRes.getString("DataFunctionPanel.Button.Redo.Tooltip"));
        this.paramEditor.refreshGUI();
        this.functionEditor.refreshGUI();
    }

    public ParamEditor getParamEditor() {
        return this.paramEditor;
    }

    public FunctionEditor getFunctionEditor() {
        return this.functionEditor;
    }

    public FunctionEditor.Table getFunctionTable() {
        return this.functionEditor.getTable();
    }

    public FunctionEditor.Table getParamTable() {
        return this.paramEditor.getTable();
    }

    public String getLabel() {
        return ToolsRes.getString("FunctionPanel.Label");
    }

    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        JPanel bp = this.paramEditor.getButtonPanel();
        dim.width = bp.getPreferredSize().width;
        return dim;
    }

    protected void addForbiddenNames(String[] names) {
        int i = 0;
        while (i < names.length) {
            this.functionEditor.forbiddenNames.add(names[i]);
            if (this.paramEditor != null) {
                this.paramEditor.forbiddenNames.add(names[i]);
            }
            ++i;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "edit": {
                UndoableEdit edit;
                if (e.getNewValue() instanceof UndoableEdit && (!((edit = (UndoableEdit)e.getNewValue()) instanceof FunctionEditor.DefaultEdit) || ((FunctionEditor.DefaultEdit)edit).isNew())) {
                    this.undoSupport.postEdit(edit);
                }
                this.refreshFunctions();
                this.refreshGUI();
                if (this.functionEditor.getObjects().size() <= 0) break;
                String functionName = (String)e.getOldValue();
                String prevName = null;
                if (e.getNewValue() instanceof FunctionEditor.DefaultEdit) {
                    FunctionEditor.DefaultEdit edit2 = (FunctionEditor.DefaultEdit)e.getNewValue();
                    if (edit2.editType == 2) {
                        prevName = edit2.undoObj.toString();
                    }
                } else if (e.getNewValue() instanceof String) {
                    prevName = e.getNewValue().toString();
                }
                if (this.functionTool == null) break;
                this.functionTool.firePropertyChange("function", prevName, functionName);
                break;
            }
            case "function": {
                this.refreshFunctions();
                this.refreshGUI();
                if (this.functionTool == null) break;
                this.functionTool.refreshGUI();
                this.functionTool.firePropertyChange("function", null, null);
                break;
            }
            case "description": {
                if (this.functionTool == null) break;
                this.functionTool.firePropertyChange("description", null, null);
            }
        }
    }

    protected void clearSelection() {
        if (!this.haveGUI) {
            return;
        }
        this.getFunctionTable().clearSelection();
        this.getParamTable().clearSelection();
        this.refreshInstructions(null, -1);
    }

    protected void setFontLevel(int level) {
        this.lastInstruction = null;
        FontSizer.setFonts(this);
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    protected void refreshFunctions() {
        this.functionEditor.evaluateAll();
    }

    public void setFunctionTool(FunctionTool tool) {
        this.functionTool = tool;
    }

    protected void tabToNext(FunctionEditor editor) {
        if (!this.haveGUI) {
            return;
        }
        if (editor == this.functionEditor) {
            this.functionTool.focusHelp();
        } else {
            this.functionEditor.tabToNext();
        }
    }

    protected final void refreshInstructions(FunctionEditor source, int selectedColumn) {
        String s;
        if (this.instructions == null) {
            return;
        }
        boolean isError = false;
        if (this.hasCircularErrors()) {
            s = ToolsRes.getString("FunctionPanel.Instructions.CircularErrors");
            isError = true;
        } else if (this.hasInvalidExpressions()) {
            s = ToolsRes.getString("FunctionPanel.Instructions.BadCell");
            isError = true;
        } else {
            s = this.getCustomInstructions(source, selectedColumn);
        }
        if (s.equals(this.lastInstruction)) {
            return;
        }
        this.lastInstruction = s;
        this.instructions.setText(s);
        StyledDocument doc = this.instructions.getStyledDocument();
        doc.setCharacterAttributes(0, s.length(), doc.getStyle(isError ? "red" : "blue"), false);
    }

    protected String getCustomInstructions(FunctionEditor source, int selectedColumn) {
        String s;
        if (source != null && selectedColumn >= 0) {
            s = ToolsRes.getString("FunctionPanel.Instructions.EditCell");
            if (selectedColumn == 0) {
                s = String.valueOf(s) + "  " + ToolsRes.getString("FunctionPanel.Instructions.NameCell");
                s = String.valueOf(s) + "\n" + ToolsRes.getString("FunctionPanel.Instructions.EditDescription");
            } else {
                s = String.valueOf(s) + " " + ToolsRes.getString("FunctionPanel.Instructions.Help");
            }
        } else {
            s = this.isEmpty() ? ToolsRes.getString("FunctionPanel.Instructions.GetStarted") : String.valueOf(ToolsRes.getString("FunctionPanel.Instructions.General")) + "  " + ToolsRes.getString("FunctionPanel.Instructions.EditDescription");
        }
        return s;
    }

    protected boolean isEmpty() {
        return this.functionEditor.getObjects().size() == 0 && this.paramEditor.getObjects().size() == 0;
    }

    protected boolean hasInvalidExpressions() {
        return this.functionEditor.containsInvalidExpressions() || this.paramEditor.containsInvalidExpressions();
    }

    protected boolean hasCircularErrors() {
        return !this.functionEditor.circularErrors.isEmpty() || !this.paramEditor.circularErrors.isEmpty();
    }

    protected void dispose() {
        this.paramEditor.removePropertyChangeListener(this);
        this.paramEditor.removePropertyChangeListener(this.functionEditor);
        this.functionEditor.removePropertyChangeListener(this);
        this.functionEditor.removePropertyChangeListener(this.paramEditor);
        this.functionEditor.setParamEditor(null);
        this.paramEditor.setFunctionEditors(new FunctionEditor[0]);
        this.functionEditor.setFunctionPanel(null);
        this.functionEditor = null;
        this.paramEditor.setFunctionPanel(null);
        this.paramEditor = null;
        this.setFunctionTool(null);
    }

    public void finalize() {
        OSPLog.finalized(this);
    }
}

