/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.numerics.SuryonoParser;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FitBuilder;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class FunctionTool
extends JDialog
implements PropertyChangeListener {
    public static final String PROPERTY_FUNCTIONTOOL_PANEL = "panel";
    public static final String PROPERTY_FUNCTIONTOOL_VISIBLE = "ft_visible";
    public static final String PROPERTY_FUNCTIONTOOL_FUNCTION = "function";
    public static String[] parserNames = new String[]{"e", "pi", "min", "mod", "sin", "cos", "abs", "log", "acos", "acosh", "ceil", "cosh", "asin", "asinh", "atan", "atanh", "exp", "frac", "floor", "int", "random", "round", "sign", "sinh", "step", "tanh", "atan2", "max", "sqrt", "sqr", "if", "tan"};
    public static String[] parserOperators = new String[]{"!", ",", ".", "+", "-", "*", "/", "^", "=", ">", "<", "&", "|", "(", ")"};
    protected HashSet<String> forbiddenNames = new HashSet();
    protected Set<DatasetCurveFitter> curveFitters = new HashSet<DatasetCurveFitter>();
    protected Map<String, FunctionPanel> trackFunctionPanels = new TreeMap<String, FunctionPanel>();
    protected FunctionPanel selectedPanel;
    protected String helpPath = "";
    protected String helpBase = "https://www.compadre.org/online_help/tools/";
    protected ActionListener helpAction;
    protected int fontLevel = 0;
    protected boolean refreshing;
    private JPanel myContentPane = new JPanel(new BorderLayout());
    private JPanel noData;
    private JToolBar toolbar;
    private Component[] toolbarComponents;
    protected JToolBar dropdownbar;
    private JLabel dropdownLabel;
    private JComboBox<FTObject> dropdown;
    private JPanel buttonbar = new JPanel(new FlowLayout());
    private JButton helpButton;
    private JButton closeButton;
    private JButton undoButton;
    private JButton redoButton;
    private JPanel north = new JPanel(new BorderLayout());
    private JScrollPane selectedPanelScroller;
    private TextFrame helpFrame;
    private JDialog helpDialog;
    protected String dropdownTipText;
    protected String titleText;
    protected String dropdownLabelText;
    private boolean haveGUI;
    private boolean isFitBuilder;

    public FunctionTool(Component comp) {
        this(comp, false, false);
    }

    public FunctionTool(Component comp, boolean isFitBuilder, boolean lazyGUI) {
        super(JOptionPane.getFrameForComponent(comp), comp == null);
        this.isFitBuilder = isFitBuilder;
        this.addForbiddenNames(parserNames);
        this.addForbiddenNames(UserFunction.dummyVars);
        this.setName("FunctionTool");
        this.init();
        if (!lazyGUI) {
            this.createGUI();
        }
    }

    public void checkGUI() {
        if (this.haveGUI) {
            return;
        }
        this.createGUI();
        this.refreshDropdown(null);
        this.refreshGUI();
    }

    protected void init() {
    }

    protected boolean haveGUI() {
        return this.haveGUI;
    }

    protected void createGUI() {
        this.haveGUI = true;
        ToolsRes.addPropertyChangeListener("locale", this);
        this.setDefaultCloseOperation(1);
        this.noData = new JPanel(new BorderLayout());
        this.dropdownbar = new JToolBar();
        this.dropdownbar.setFloatable(false);
        this.dropdownLabel = new JLabel();
        this.dropdownLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 2));
        this.dropdownLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                String name = FunctionTool.this.getSelectedName();
                if (name != null) {
                    FunctionPanel panel = FunctionTool.this.trackFunctionPanels.get(name);
                    panel.clearSelection();
                }
            }
        });
        this.dropdownbar.add(this.dropdownLabel);
        this.dropdown = new JComboBox<FTObject>(){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                if (FunctionTool.this.toolbarComponents != null && FunctionTool.this.toolbarComponents.length > 0 & FunctionTool.this.toolbarComponents[0] instanceof JButton) {
                    JButton button = (JButton)FunctionTool.this.toolbarComponents[0];
                    dim.height = button.getHeight();
                }
                return dim;
            }

            @Override
            public void addItem(FTObject obj) {
                if (obj == null) {
                    return;
                }
                int count = this.getItemCount();
                int i = 0;
                while (i < count) {
                    if (obj.equals(this.getItemAt(i))) {
                        return;
                    }
                    ++i;
                }
                String displayName = obj.displayName;
                if (FunctionTool.this.isFitBuilder) {
                    displayName = FitBuilder.localize(displayName);
                }
                int i2 = 0;
                while (i2 < count) {
                    FTObject fto = (FTObject)this.getItemAt(i2);
                    String dname = fto.displayName;
                    if (FunctionTool.this.isFitBuilder) {
                        dname = FitBuilder.localize(dname);
                    }
                    if (displayName.compareToIgnoreCase(dname) < 0) {
                        this.insertItemAt(obj, i2);
                        return;
                    }
                    ++i2;
                }
                super.addItem(obj);
            }
        };
        this.dropdown.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        this.dropdownbar.add(this.dropdown);
        DropdownRenderer renderer = new DropdownRenderer();
        this.dropdown.setRenderer(renderer);
        this.dropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTObject item = (FTObject)FunctionTool.this.dropdown.getSelectedItem();
                if (item != null) {
                    String name = item.name;
                    FunctionTool.this.select(name);
                    FunctionPanel panel = FunctionTool.this.trackFunctionPanels.get(name);
                    if (panel != null && panel.haveGUI()) {
                        panel.getFunctionTable().clearSelection();
                        panel.getFunctionTable().selectOnFocus = false;
                        panel.getParamTable().clearSelection();
                        panel.getParamTable().selectOnFocus = false;
                        panel.refreshGUI();
                    }
                }
                FunctionTool.this.helpButton.requestFocusInWindow();
            }
        });
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.north.add((Component)this.dropdownbar, "South");
        this.north.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.closeButton = new JButton(ToolsRes.getString("Tool.Button.Close"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionTool.this.setVisible(false);
            }
        });
        this.helpAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FunctionTool.this.helpFrame == null) {
                    String help = XML.getResolvedPath(FunctionTool.this.helpPath, FunctionTool.this.helpBase);
                    if (ResourceLoader.getResource(help) != null) {
                        FunctionTool.this.helpFrame = new TextFrame(help);
                    } else {
                        String classBase = "/org/opensourcephysics/resources/tools/html/";
                        help = XML.getResolvedPath(FunctionTool.this.helpPath, classBase);
                        FunctionTool.this.helpFrame = new TextFrame(help);
                    }
                    FunctionTool.this.helpDialog = new JDialog((Dialog)FunctionTool.this, false);
                    FunctionTool.this.helpDialog.setContentPane(FunctionTool.this.helpFrame.getContentPane());
                    FunctionTool.this.helpDialog.setSize(700, 550);
                    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                    int x = (dim.width - ((FunctionTool)FunctionTool.this).helpDialog.getBounds().width) / 2;
                    int y = (dim.height - ((FunctionTool)FunctionTool.this).helpDialog.getBounds().height) / 2;
                    FunctionTool.this.helpDialog.setLocation(x, y);
                }
                FunctionTool.this.helpDialog.setVisible(true);
            }
        };
        this.helpButton = new JButton(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.addActionListener(this.helpAction);
        this.undoButton = new JButton(ToolsRes.getString("DataFunctionPanel.Button.Undo"));
        this.redoButton = new JButton(ToolsRes.getString("DataFunctionPanel.Button.Redo"));
        this.buttonbar.setBorder(BorderFactory.createEtchedBorder());
        this.buttonbar.add(this.helpButton);
        this.buttonbar.add(this.undoButton);
        this.buttonbar.add(this.redoButton);
        this.buttonbar.add(this.closeButton);
        this.myContentPane.add((Component)this.north, "North");
        this.myContentPane.add((Component)this.noData, "Center");
        this.myContentPane.add((Component)this.buttonbar, "South");
        this.setContentPane(this.myContentPane);
        Dimension dim = this.getPreferredSize();
        this.setPreferredSize(new Dimension(dim.width, Math.max(400, dim.height)));
        this.pack();
        this.buttonbar.remove(this.undoButton);
        this.buttonbar.remove(this.redoButton);
        this.dropdown.setEnabled(false);
        this.dropdownLabel.setEnabled(false);
        dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        this.setLocation(x, y);
    }

    protected void setTitles() {
    }

    protected void refreshGUI() {
        if (!this.haveGUI) {
            return;
        }
        if (this.toolbarComponents == null) {
            this.north.remove(this.toolbar);
        } else {
            this.north.add((Component)this.toolbar, "North");
            this.toolbar.removeAll();
            int i = 0;
            while (i < this.toolbarComponents.length) {
                this.toolbar.add(this.toolbarComponents[i]);
                ++i;
            }
        }
        if (this.dropdownLabelText != null) {
            this.dropdownLabel.setText(this.dropdownLabelText);
        } else if (this.selectedPanel != null) {
            String label = this.selectedPanel.getLabel();
            this.dropdownLabel.setText(String.valueOf(label) + ":");
        }
        if (this.dropdownTipText != null) {
            this.dropdown.setToolTipText(this.dropdownTipText);
        }
        this.setTitles();
        if (this.titleText != null) {
            this.setTitle(this.titleText);
        }
        this.closeButton.setText(ToolsRes.getString("Tool.Button.Close"));
        this.closeButton.setToolTipText(ToolsRes.getString("Tool.Button.Close.ToolTip"));
        this.helpButton.setText(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
        for (FunctionPanel panel : this.trackFunctionPanels.values()) {
            panel.refreshGUI();
        }
        Dimension dim = this.getSize();
        dim.width = Math.max(dim.width, this.getMinimumSize().width);
        this.setSize(dim);
        this.helpButton.requestFocusInWindow();
    }

    public void setToolbarComponents(Component[] toolbarItems) {
        this.toolbarComponents = toolbarItems;
        this.refreshGUI();
    }

    public Component[] getToolbarComponents() {
        return this.toolbarComponents;
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public void addPanel(String name, FunctionPanel panel) {
        panel.setFontLevel(this.fontLevel);
        panel.setName(name);
        panel.setFunctionTool(this);
        this.trackFunctionPanels.put(name, panel);
        panel.addForbiddenNames(this.forbiddenNames.toArray(new String[0]));
        panel.clearSelection();
        if (this.isVisible()) {
            this.refreshDropdown(name);
        }
    }

    public FunctionPanel removePanel(String name) {
        FunctionPanel panel = this.trackFunctionPanels.get(name);
        if (panel != null) {
            this.trackFunctionPanels.remove(name);
            this.refreshDropdown(null);
            this.firePropertyChange(PROPERTY_FUNCTIONTOOL_PANEL, panel, null);
            panel.dispose();
        }
        return panel;
    }

    public FunctionPanel renamePanel(String prevName, String newName) {
        FunctionPanel panel = this.getPanel(prevName);
        if (panel == null || prevName.equals(newName)) {
            return panel;
        }
        this.trackFunctionPanels.remove(prevName);
        this.trackFunctionPanels.put(newName, panel);
        panel.prevName = prevName;
        panel.setName(newName);
        this.refreshDropdown(newName);
        return panel;
    }

    public void setSelectedPanel(String name) {
        if (!this.haveGUI()) {
            return;
        }
        FTObject item = this.getDropdownItem(name);
        if (item != null) {
            this.dropdown.setSelectedItem(item);
        }
    }

    public String getSelectedName() {
        if (this.selectedPanel == null) {
            return null;
        }
        for (String name : this.trackFunctionPanels.keySet()) {
            if (this.trackFunctionPanels.get(name) != this.selectedPanel) continue;
            return name;
        }
        return null;
    }

    public FunctionPanel getSelectedPanel() {
        String name = this.getSelectedName();
        FunctionPanel panel = this.getPanel(name);
        if (panel == null && name != null) {
            this.refreshDropdown(name);
            panel = this.getPanel(name);
        }
        return panel;
    }

    public FunctionPanel getPanel(String name) {
        return name == null ? null : this.trackFunctionPanels.get(name);
    }

    public Set<String> getPanelNames() {
        return this.trackFunctionPanels.keySet();
    }

    public void clearPanels() {
        this.trackFunctionPanels.clear();
        this.refreshDropdown(null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (!this.haveGUI()) {
            return;
        }
        this.refreshGUI();
        if (this.isFitBuilder) {
            this.refreshDropdown(null);
        }
    }

    public void addForbiddenNames(String[] names) {
        int i = 0;
        while (i < names.length) {
            this.forbiddenNames.add(names[i]);
            ++i;
        }
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis == this.isVisible()) {
            return;
        }
        if (vis) {
            this.checkGUI();
            this.setFontLevel(FontSizer.getLevel());
            this.refreshDropdown(this.getSelectedName());
        } else if (!this.haveGUI()) {
            return;
        }
        Container top = this.myContentPane.getTopLevelAncestor();
        if (top == null || top == this) {
            super.setVisible(vis);
        } else {
            top.setVisible(vis);
        }
        this.firePropertyChange(PROPERTY_FUNCTIONTOOL_VISIBLE, null, (Object)vis);
    }

    @Override
    public boolean isVisible() {
        Container top = this.myContentPane.getTopLevelAncestor();
        return top == null ? false : (top == this ? super.isVisible() : top.isVisible());
    }

    public void setHelpPath(String path) {
        this.helpPath = path;
    }

    public void setHelpAction(ActionListener action) {
        this.helpButton.removeActionListener(this.helpAction);
        this.helpAction = action;
        this.helpButton.addActionListener(this.helpAction);
    }

    public boolean isEmpty() {
        return this.trackFunctionPanels.isEmpty();
    }

    public void setFontLevel(int level) {
        if ((level = Math.max(0, level)) == this.fontLevel || this.dropdown == null) {
            return;
        }
        this.fontLevel = level;
        boolean vis = this.isVisible();
        this.setVisible(false);
        FontSizer.setFonts(this, level);
        FontSizer.setFonts(this.myContentPane, level);
        for (FunctionPanel next : this.trackFunctionPanels.values()) {
            next.setFontLevel(level);
        }
        int n = this.dropdown.getSelectedIndex();
        FTObject[] items = new FTObject[this.dropdown.getItemCount()];
        int i = 0;
        while (i < items.length) {
            items[i] = this.dropdown.getItemAt(i);
            ++i;
        }
        DefaultComboBoxModel<FTObject> model = new DefaultComboBoxModel<FTObject>(items);
        this.dropdown.setModel(model);
        this.dropdown.setSelectedIndex(n);
        Container c = this.myContentPane.getTopLevelAncestor();
        Dimension dim = c.getSize();
        dim.width = c.getMinimumSize().width;
        int h = (int)(280.0 * FontSizer.getFactor(level));
        h = Math.max(h, dim.height);
        dim.height = h = Math.min(h, (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        this.setSize(dim);
        c.setSize(dim);
        this.setVisible(vis);
        this.refreshDropdown(null);
    }

    public int getFontLevel() {
        return this.fontLevel;
    }

    public void setDefaultVariables(String[] vars) {
        for (String name : this.getPanelNames()) {
            FunctionPanel panel = this.getPanel(name);
            UserFunctionEditor editor = (UserFunctionEditor)panel.getFunctionEditor();
            editor.setDefaultVariables(vars);
            editor.repaint();
        }
    }

    @Override
    protected void firePropertyChange(String name, Object oldObj, Object newObj) {
        super.firePropertyChange(name, oldObj, newObj);
    }

    private FTObject getDropdownItem(String name) {
        int i = 0;
        while (i < this.dropdown.getItemCount()) {
            FTObject item = this.dropdown.getItemAt(i);
            String itemName = item.name;
            if (itemName.equals(name)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected String getSelectedDropdownName() {
        FTObject item = (FTObject)this.dropdown.getSelectedItem();
        if (item != null) {
            return item.name;
        }
        return null;
    }

    public void refreshDropdown(String name) {
        FTObject item;
        if (!this.haveGUI()) {
            return;
        }
        this.refreshing = true;
        if (name == null && (item = (FTObject)this.dropdown.getSelectedItem()) != null) {
            name = item.name;
        }
        FTObject toSelect = null;
        this.dropdown.removeAllItems();
        for (String next : this.trackFunctionPanels.keySet()) {
            FunctionPanel panel = this.trackFunctionPanels.get(next);
            String displayName = panel.getDisplayName();
            Icon icon = panel.getIcon();
            FTObject item2 = new FTObject(icon, next, displayName);
            this.dropdown.addItem(item2);
            if (toSelect != null && !next.equals(name)) continue;
            toSelect = item2;
        }
        this.refreshing = false;
        if (toSelect != null) {
            this.dropdown.setSelectedItem(toSelect);
        } else {
            this.select(null);
        }
        if (this.dropdownLabelText != null) {
            this.dropdownLabel.setText(this.dropdownLabelText);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FunctionTool.this.dropdown.revalidate();
                FunctionTool.this.helpButton.requestFocusInWindow();
            }
        });
    }

    private void select(String name) {
        if (this.refreshing) {
            return;
        }
        FunctionPanel panel = name == null ? null : this.trackFunctionPanels.get(name);
        FunctionPanel prev = this.selectedPanel;
        if (this.selectedPanel != null) {
            this.myContentPane.remove(this.selectedPanelScroller);
        } else {
            this.myContentPane.remove(this.noData);
        }
        this.selectedPanel = panel;
        this.dropdown.setEnabled(panel != null);
        this.dropdownLabel.setEnabled(panel != null);
        if (panel != null) {
            this.selectedPanelScroller = new JScrollPane(panel);
            this.myContentPane.add((Component)this.selectedPanelScroller, "Center");
            panel.refreshGUI();
        } else {
            this.myContentPane.add((Component)this.noData, "Center");
            this.buttonbar.removeAll();
            this.buttonbar.add(this.helpButton);
            this.buttonbar.add(this.closeButton);
        }
        Container c = this.myContentPane.getTopLevelAncestor();
        c.validate();
        this.refreshGUI();
        c.repaint();
        this.firePropertyChange(PROPERTY_FUNCTIONTOOL_PANEL, prev, panel);
    }

    protected String getUniqueName(String proposedName) {
        int i = 0;
        String name = proposedName;
        if (ToolsRes.getString("DatasetCurveFitter.NewFit.Name").equals(proposedName)) {
            name = String.valueOf(name) + ++i;
        }
        while (this.trackFunctionPanels.keySet().contains(name) || this.forbiddenNames.contains(name)) {
            name = String.valueOf(proposedName) + ++i;
        }
        return name;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public void setButtonBar(Object[] btns) {
        if (!this.haveGUI) {
            return;
        }
        this.buttonbar.removeAll();
        Object[] objectArray = btns;
        int n = btns.length;
        int n2 = 0;
        while (n2 < n) {
            Object btn;
            block12: {
                btn = objectArray[n2];
                if (!(btn instanceof String)) break block12;
                switch ((String)btn) {
                    case "help": {
                        btn = this.helpButton;
                        break;
                    }
                    case "close": {
                        btn = this.closeButton;
                    }
                }
            }
            this.buttonbar.add((Component)btn);
            ++n2;
        }
    }

    public boolean hasButton(JButton btn) {
        return btn != null && btn.getParent() == this.buttonbar;
    }

    public void focusHelp() {
        if (this.haveGUI) {
            this.helpButton.requestFocusInWindow();
        }
    }

    @Override
    public void dispose() {
        if (this.helpDialog != null) {
            this.helpDialog.dispose();
        }
        super.dispose();
    }

    public static boolean arrayContains(String[] s, String name) {
        int i = s.length;
        while (--i >= 0) {
            if (!s[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReservedName(String name) {
        return DataTable.rowName.equals(name) || FunctionTool.arrayContains(parserNames, name) || FunctionTool.arrayContains(UserFunction.dummyVars, name) || !Double.isNaN(SuryonoParser.getNumber(name));
    }

    public class DropdownRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        public DropdownRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 0));
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value != null) {
                FTObject obj = (FTObject)value;
                this.setIcon(obj.icon);
                String displayName = obj.displayName;
                if (FunctionTool.this.isFitBuilder) {
                    displayName = FitBuilder.localize(displayName);
                }
                this.setText(displayName);
            } else {
                this.setIcon(null);
                this.setText(null);
            }
            return this;
        }
    }

    public static class FTObject {
        public Icon icon;
        public String name;
        public String displayName;
        public Trackable track;

        public FTObject(Icon icon, String name, String displayName) {
            this.icon = icon;
            this.name = name;
            this.displayName = displayName;
        }

        public FTObject(Icon icon, Trackable track, String displayName) {
            this.icon = icon;
            this.track = track;
            this.displayName = displayName;
        }

        public boolean equals(Object o) {
            FTObject fto = (FTObject)o;
            return fto != null && (this.name == null ? fto.name == null : this.name.equals(fto.name)) && (this.track == null ? fto.track == null : this.track.equals(fto.track)) && (this.displayName == null ? fto.displayName == null : this.displayName.equals(fto.displayName)) && (this.icon == null ? fto.icon == null : this.icon.equals(fto.icon));
        }

        public String toString() {
            return this.displayName;
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            FunctionTool tool = (FunctionTool)obj;
            ArrayList<FunctionPanel> functions = new ArrayList<FunctionPanel>(tool.trackFunctionPanels.values());
            control.setValue("functions", functions);
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            FunctionTool tool = (FunctionTool)obj;
            ArrayList functions = (ArrayList)control.getObject("functions");
            if (functions != null) {
                for (FunctionPanel panel : functions) {
                    tool.addPanel(panel.getName(), panel);
                }
            }
            return obj;
        }
    }
}

