/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Dimension;
import java.util.List;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.ParamEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;

public class InitialValueEditor
extends ParamEditor {
    public InitialValueEditor(ParamEditor editor) {
        this.skipAllName = "t";
        this.paramEditor = editor;
        this.setFunctionPanel(editor.getFunctionPanel());
    }

    @Override
    public boolean isNameEditable(FunctionEditor.FObject obj) {
        return false;
    }

    @Override
    protected String getVariablesString(String separator) {
        String selectedName = this.getName(this.getSelectedObject());
        StringBuffer vars = new StringBuffer("");
        String[] paramNames = this.paramEditor.getNames();
        int i = 0;
        while (i < paramNames.length) {
            vars.append(" ");
            vars.append(paramNames[i]);
            ++i;
        }
        if (this.skipAllName == null || !this.skipAllName.equals(selectedName)) {
            i = 0;
            while (i < this.names.length) {
                if (!this.names[i].equals(selectedName)) {
                    vars.append(" ");
                    vars.append(this.names[i]);
                }
                ++i;
            }
        }
        return this.getVariablesString(vars, separator);
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dim = super.getMaximumSize();
        dim.height = this.getPreferredSize().height;
        return dim;
    }

    @Override
    public void evaluateAll() {
        Parameter p;
        this.setArrays();
        int nObj = this.objects.size();
        if (this.paramValues.length != nObj) {
            this.paramValues = new double[nObj];
        }
        List<FunctionEditor.FObject> tempList = this.paramEditor.getObjects();
        tempList.addAll(this.getObjects());
        int i = 0;
        while (i < this.evaluate.size()) {
            p = (Parameter)this.evaluate.get(i);
            p.evaluate(tempList);
            ++i;
        }
        i = 0;
        while (i < nObj) {
            p = (Parameter)this.objects.get(i);
            this.paramValues[i] = p.getValue();
            ++i;
        }
    }

    @Override
    protected void createGUI() {
        this.addButtonPanel = false;
        super.createGUI();
    }

    @Override
    protected void setTitles() {
        this.newButtonTipText = ToolsRes.getString("ParamEditor.Button.New.Tooltip");
        this.titledBorderText = ToolsRes.getString("InitialValueEditor.Border.Title");
    }
}

