/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Color;
import javax.swing.JToolTip;
import javax.swing.border.EmptyBorder;

public class JMultiLineToolTip
extends JToolTip {
    private String lastText;
    private String lastWrapped;
    private int maxChar;
    private StringBuilder sb = new StringBuilder();

    public JMultiLineToolTip() {
        this(40, Color.yellow);
    }

    public JMultiLineToolTip(int maxChar, Color bgColor) {
        this.maxChar = maxChar;
        this.setBorder(new EmptyBorder(0, 5, 3, 5));
        this.setBackground(bgColor);
    }

    @Override
    public void setTipText(String tipText) {
        if (tipText == null) {
            return;
        }
        super.setTipText(this.wrapToolTip(tipText));
    }

    protected String wrapToolTip(String text) {
        boolean enclose;
        if (text.equals(this.lastText)) {
            return this.lastWrapped;
        }
        this.lastText = text;
        if ((text = text.trim()).startsWith("<html>")) {
            enclose = false;
        } else if (text.contains("<br") || text.contains("<BR")) {
            enclose = true;
        } else {
            boolean bl = enclose = text.length() > this.maxChar;
            if (enclose) {
                String[] words = text.split(" ");
                this.sb.setLength(0);
                int i = 0;
                int len = 0;
                while (i < words.length) {
                    if ((len += words[i].length()) > this.maxChar) {
                        this.sb.append("<br>");
                        len = 0;
                    } else if (len > 0) {
                        this.sb.append(" ");
                    }
                    this.sb.append(words[i]);
                    ++i;
                }
                text = this.sb.toString();
            }
        }
        this.lastWrapped = enclose ? "<html>" + text + "</html>" : text;
        return this.lastWrapped;
    }
}

