/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.OSPRuntime;

public class JREFinder {
    private static final JREFinder JRE_FINDER = new JREFinder();
    private static boolean isReady = false;
    private static boolean isSearching = false;
    private static TreeSet<File> allJREs = new TreeSet();
    private static TreeSet<File> searchedAndFoundJRE = new TreeSet();
    private JavaFilter javaFilter = new JavaFilter();

    public static JREFinder getFinder() {
        return JRE_FINDER;
    }

    public static boolean isReady() {
        return isReady;
    }

    public boolean is32BitVM(String jrePath) {
        if (jrePath == null) {
            return false;
        }
        if (OSPRuntime.isWindows()) {
            if (jrePath.contains("64")) {
                return false;
            }
            String x86 = System.getenv("ProgramFiles(x86)");
            if (x86 != null) {
                return jrePath.contains(x86);
            }
            return true;
        }
        if (OSPRuntime.isMac()) {
            return false;
        }
        return OSPRuntime.getVMBitness() == 32;
    }

    public TreeSet<File> getJREs(int vmBitness) {
        TreeSet<File> results = this.findJREs();
        Iterator<File> it = results.iterator();
        while (it.hasNext()) {
            String path = it.next().getPath();
            if (vmBitness == 32 && !this.is32BitVM(path)) {
                it.remove();
                continue;
            }
            if (vmBitness == 32 || !this.is32BitVM(path)) continue;
            it.remove();
        }
        return results;
    }

    public File getDefaultJRE(int vmBitness, String path, boolean searchAll, String prefix) {
        File dir;
        if (path != null && (dir = new File(path)).exists()) {
            Set<File> result = new TreeSet<File>();
            if (!(result = this.findJREsInDirectory(dir, result)).isEmpty()) {
                TreeMap<String, File> map = new TreeMap<String, File>();
                for (File f : result) {
                    if (vmBitness == 32 && this.is32BitVM(f.getPath())) {
                        map.put(f.getName(), f);
                        continue;
                    }
                    if (vmBitness != 64 || this.is32BitVM(f.getPath())) continue;
                    map.put(f.getName(), f);
                }
                if (!map.isEmpty()) {
                    String s;
                    if (prefix != null) {
                        s = null;
                        for (String next : map.keySet()) {
                            if (!next.startsWith(prefix)) continue;
                            s = next;
                        }
                        if (s != null) {
                            return (File)map.get(s);
                        }
                    }
                    s = (String)map.keySet().iterator().next();
                    return (File)map.get(s);
                }
            }
        }
        if (!searchAll) {
            return null;
        }
        File JRE = null;
        TreeSet<File> jreDirs = this.getPublicJREs(vmBitness);
        for (File next : jreDirs) {
            if (JRE != null) continue;
            JRE = next;
        }
        if (JRE == null) {
            jreDirs = this.getJREs(vmBitness);
            for (File next : jreDirs) {
                if (JRE != null) continue;
                JRE = next;
            }
        }
        return JRE;
    }

    private TreeSet<File> findJREs() {
        while (isSearching) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!isReady) {
            allJREs.clear();
            isSearching = true;
            TreeSet<File> searchPaths = new TreeSet<File>();
            try {
                File file;
                String trackerhome = System.getenv("TRACKER_HOME");
                if (trackerhome == null) {
                    trackerhome = (String)OSPRuntime.getPreference("TRACKER_HOME");
                }
                if (trackerhome != null && (file = new File(trackerhome)).exists()) {
                    if (OSPRuntime.isMac()) {
                        String path = String.valueOf(file.getParent()) + "/runtime";
                        searchPaths.add(new File(path));
                    } else {
                        searchPaths.add(file);
                    }
                }
                if (OSPRuntime.isWindows()) {
                    File file2;
                    String progfiles = System.getenv("ProgramFiles");
                    String w6432 = System.getenv("ProgramW6432");
                    String x86 = System.getenv("ProgramFiles(x86)");
                    if (progfiles != null && (file2 = new File(progfiles, "Java")).exists()) {
                        searchPaths.add(file2);
                    }
                    if (w6432 != null && (file2 = new File(w6432, "Java")).exists()) {
                        searchPaths.add(file2);
                    }
                    if (x86 != null && (file2 = new File(x86, "Java")).exists()) {
                        searchPaths.add(file2);
                    }
                } else if (OSPRuntime.isMac()) {
                    if (trackerhome != null && (file = new File(trackerhome)).exists()) {
                        searchPaths.add(file.getParentFile());
                    }
                    if ((file = new File("/System/Library/Java")).exists()) {
                        searchPaths.add(file);
                    }
                    if ((file = new File("/Library/Java")).exists()) {
                        searchPaths.add(file);
                    }
                    if ((file = new File("/Library/Internet Plug-Ins")).exists()) {
                        searchPaths.add(file);
                    }
                } else if (OSPRuntime.isLinux() && (file = new File("/usr/lib/jvm")).exists()) {
                    searchPaths.add(file);
                }
                for (File next : searchPaths) {
                    this.findJREsInDirectory(next, allJREs);
                }
            }
            catch (Exception trackerhome) {
                // empty catch block
            }
            isReady = true;
            isSearching = false;
            StringBuffer buf = new StringBuffer("JREs found: ");
            for (File next : allJREs) {
                buf.append(String.valueOf(next.getAbsolutePath()) + ", ");
            }
            OSPLog.fine(buf.toString());
        }
        return new TreeSet<File>((SortedSet<File>)allJREs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<File> findJREsInDirectory(File dir, Set<File> jreSet) {
        if (dir == null || !dir.isDirectory()) {
            return jreSet;
        }
        try {
            if (!dir.getCanonicalPath().equals(dir.getAbsolutePath())) {
                return jreSet;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (OSPRuntime.isMac()) {
            File javaFile = new File(dir, "jre/bin/java");
            if (javaFile.exists()) {
                jreSet.add(new JavaFile(new File(dir, "jre")));
                return jreSet;
            }
            javaFile = new File(dir, "bin/java");
            if (javaFile.exists()) {
                jreSet.add(new JavaFile(dir));
                return jreSet;
            }
            if (dir.getName().contains(".plugin") || dir.getName().contains(".runtime")) {
                File child = new File(dir, "Contents");
                if (child.exists()) {
                    this.findJREsInDirectory(new File(child, "Home"), jreSet);
                }
                return jreSet;
            }
        }
        File parent = dir.getParentFile();
        String[] fileNames = dir.list();
        if (fileNames != null && fileNames.length > 0) {
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String next = stringArray[n2];
                if (this.javaFilter.accept(dir, next)) {
                    Set<File> set = jreSet;
                    synchronized (set) {
                        jreSet.add(new JavaFile(parent));
                        if (parent.getParent().contains("jdk")) {
                            searchedAndFoundJRE.add(parent.getParentFile());
                        } else {
                            searchedAndFoundJRE.add(parent);
                        }
                        break;
                    }
                }
                if (!searchedAndFoundJRE.contains(parent)) {
                    this.findJREsInDirectory(new File(dir, next), jreSet);
                }
                ++n2;
            }
        }
        return jreSet;
    }

    private TreeSet<File> getPublicJREs(int vmBitness) {
        TreeSet<File> jreDirs = this.getJREs(vmBitness);
        if (OSPRuntime.isWindows()) {
            Iterator<File> it = jreDirs.iterator();
            while (it.hasNext()) {
                File next = it.next();
                if (next.getPath().indexOf("jdk") <= -1) continue;
                it.remove();
            }
        }
        return jreDirs;
    }

    private JREFinder() {
    }

    static class JavaFile
    extends File {
        public JavaFile(File file) {
            super(file.getPath());
        }

        @Override
        public int compareTo(File other) {
            String path = this.getPath();
            String otherPath = other.getPath();
            if (!path.contains("jdk") && otherPath.contains("jdk")) {
                return -1;
            }
            if (path.contains("jdk") && !otherPath.contains("jdk")) {
                return 1;
            }
            int comp = super.compareTo(other);
            int n = comp > 0 ? -1 : (comp = comp < 0 ? 1 : 0);
            if (OSPRuntime.isWindows()) {
                if (path.contains("1.") && otherPath.contains("1.")) {
                    return comp;
                }
                if (path.contains("jre6")) {
                    if (otherPath.contains("jre7") || otherPath.contains("1.8") || otherPath.contains("jre-9")) {
                        return 1;
                    }
                    return comp;
                }
                if (otherPath.contains("jre6")) {
                    if (path.contains("jre7") || path.contains("1.8") || path.contains("jre-9")) {
                        return -1;
                    }
                    return comp;
                }
                if (path.contains("jre7")) {
                    if (otherPath.contains("jre6")) {
                        return -1;
                    }
                    if (otherPath.contains("1.8") || otherPath.contains("jre-9")) {
                        return 1;
                    }
                    return comp;
                }
                if (otherPath.contains("jre7")) {
                    if (path.contains("jre6")) {
                        return 1;
                    }
                    if (path.contains("1.8") || path.contains("jre-9")) {
                        return -1;
                    }
                    return comp;
                }
                if (path.contains("jre-9")) {
                    if (otherPath.contains("jre6") || otherPath.contains("jre7") || otherPath.contains("1.8")) {
                        return -1;
                    }
                    return comp;
                }
                if (otherPath.contains("jre-9")) {
                    if (path.contains("jre6") || path.contains("jre7") || path.contains("1.8")) {
                        return 1;
                    }
                    return comp;
                }
            }
            return comp;
        }
    }

    private static class JavaFilter
    implements FilenameFilter {
        private JavaFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            if (!dir.getPath().endsWith("bin")) {
                return false;
            }
            if (!OSPRuntime.isMac() && !dir.getParent().contains("jre")) {
                return false;
            }
            if (dir.getPath().contains("1.7.") || dir.getPath().contains("jre7") || dir.getPath().contains("1.6.") || dir.getPath().contains("jre6") || dir.getPath().contains("1.5.") || dir.getPath().contains("-5-") || dir.getPath().contains("1.4.") || dir.getPath().contains("1.3.") || dir.getPath().contains("1.2.")) {
                return false;
            }
            if (name.equals("java.exe")) {
                return true;
            }
            return name.equals("java");
        }
    }
}

