/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.CheckTreeManager;
import org.opensourcephysics.tools.CheckTreeSelectionModel;
import org.opensourcephysics.tools.JarTreeModel;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

public class JarTreeDialog
extends JDialog {
    protected File rootFile;
    protected JarTreeModel jarModel;
    protected JTree jarTree;
    protected CheckTreeManager checkManager;
    protected TreePath[] selectionPaths;
    protected UndoableEditSupport undoSupport;
    protected UndoManager undoManager;
    protected JButton okButton;
    protected JButton undoButton;
    protected JButton redoButton;
    protected JButton languagesButton;
    protected boolean ignoreEvents;
    protected int prevRow;
    protected Icon jarIcon;
    protected Icon jarFileIcon;
    protected Icon jarFolderIcon;
    protected Icon fileIcon;

    public JarTreeDialog(Frame owner, File root) {
        super(owner, true);
        this.rootFile = root;
        this.createGUI();
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoManager);
        CheckTreeSelectionModel checkModel = this.checkManager.getSelectionModel();
        checkModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (JarTreeDialog.this.ignoreEvents) {
                    return;
                }
                TreePath[] prev = (TreePath[])e.getOldValue();
                TreePath[] curr = (TreePath[])e.getNewValue();
                TreePath path = JarTreeDialog.this.jarTree.getSelectionPath();
                int row = JarTreeDialog.this.jarTree.getRowForPath(path);
                SelectionEdit edit = new SelectionEdit(prev, JarTreeDialog.this.prevRow, curr, row);
                JarTreeDialog.this.undoSupport.postEdit(edit);
                JarTreeDialog.this.prevRow = row;
                JarTreeDialog.this.refresh();
            }
        });
        this.refresh();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        this.setLocation(x, y);
    }

    public String[] getSelectionRelativePaths() {
        if (this.selectionPaths == null) {
            return null;
        }
        ArrayList<String> temp = new ArrayList<String>();
        int i = 0;
        while (i < this.selectionPaths.length) {
            temp.add(this.getRelativePath(this.selectionPaths[i]));
            ++i;
        }
        return temp.toArray(new String[0]);
    }

    public void setSelectionRelativePaths(String[] paths) {
        ArrayList<TreePath> temp = new ArrayList<TreePath>();
        int i = 0;
        while (i < paths.length) {
            temp.add(this.getTreePath(paths[i]));
            ++i;
        }
        TreePath[] treePaths = temp.toArray(new TreePath[0]);
        this.setSelectionPaths(treePaths);
    }

    public TreePath[] getSelectionPaths() {
        return this.selectionPaths;
    }

    public void setSelectionPaths(TreePath[] treePaths) {
        this.ignoreEvents = true;
        CheckTreeSelectionModel checkModel = this.checkManager.getSelectionModel();
        if (treePaths == null) {
            checkModel.setSelectionPaths(new TreePath[0]);
        } else {
            checkModel.setSelectionPaths(treePaths);
        }
        this.ignoreEvents = false;
        this.refresh();
    }

    private String getRelativePath(TreePath path) {
        Object[] nodes = path.getPath();
        StringBuffer buffer = new StringBuffer();
        Object jarNode = this.rootFile;
        int j = 1;
        while (j < nodes.length) {
            if (buffer.toString().endsWith(".jar")) {
                buffer.append("!");
            }
            if (j > 1) {
                buffer.append("/");
            }
            buffer.append(nodes[j].toString());
            jarNode = this.jarModel.getChild(jarNode, nodes[j].toString());
            ++j;
        }
        if (jarNode instanceof File && ((File)jarNode).isDirectory() || jarNode instanceof JarTreeModel.JarNode && !((JarTreeModel.JarNode)jarNode).isLeaf()) {
            buffer.append("/");
        }
        return buffer.toString();
    }

    private TreePath getTreePath(String relativePath) {
        String path = XML.forwardSlash(relativePath);
        TreePath treePath = new TreePath(this.rootFile);
        Object parent = this.rootFile;
        while (parent != null) {
            Object child = null;
            int n = path.indexOf("/");
            if (n > -1) {
                String name = path.substring(0, n);
                path = path.substring(n + 1);
                if (name.endsWith("!")) {
                    name = name.substring(0, name.length() - 1);
                }
                child = this.jarModel.getChild(parent, name);
            } else {
                child = this.jarModel.getChild(parent, path);
            }
            if (child != null) {
                treePath = treePath.pathByAddingChild(child);
            }
            parent = child;
        }
        return treePath;
    }

    protected void refresh() {
        CheckTreeSelectionModel checkModel = this.checkManager.getSelectionModel();
        this.selectionPaths = checkModel.getSelectionPaths();
        this.okButton.setEnabled(!checkModel.isSelectionEmpty());
        this.undoButton.setEnabled(this.undoManager.canUndo());
        this.redoButton.setEnabled(this.undoManager.canRedo());
    }

    protected void createGUI() {
        this.setTitle(ToolsRes.getString("JarTreeDialog.Title"));
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setPreferredSize(new Dimension(480, 320));
        this.setContentPane(contentPane);
        String imageFile = "/org/opensourcephysics/resources/tools/images/jarfile.gif";
        this.jarIcon = ResourceLoader.getImageIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/jarcontent.gif";
        this.jarFileIcon = ResourceLoader.getImageIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/jarfolder.gif";
        this.jarFolderIcon = ResourceLoader.getImageIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/whitefile.gif";
        this.fileIcon = ResourceLoader.getImageIcon(imageFile);
        this.jarModel = new JarTreeModel(this.rootFile);
        this.jarTree = new JTree(this.jarModel);
        this.jarTree.setSelectionRow(0);
        this.jarTree.setCellRenderer(new JarRenderer());
        this.checkManager = new CheckTreeManager(this.jarTree);
        JScrollPane scroller = new JScrollPane(this.jarTree);
        Border etched = BorderFactory.createEtchedBorder();
        TitledBorder title = BorderFactory.createTitledBorder(etched, ToolsRes.getString("JarTreeDialog.Border.Title"));
        scroller.setBorder(title);
        contentPane.add((Component)scroller, "Center");
        this.okButton = new JButton(ToolsRes.getString("JarTreeDialog.Button.OK"));
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JarTreeDialog.this.setVisible(false);
            }
        });
        JButton cancelButton = new JButton(ToolsRes.getString("JarTreeDialog.Button.Cancel"));
        cancelButton.setForeground(new Color(0, 0, 102));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JarTreeDialog.this.selectionPaths = null;
                JarTreeDialog.this.setVisible(false);
            }
        });
        this.undoButton = new JButton(ToolsRes.getString("JarTreeDialog.Button.Undo"));
        this.undoButton.setForeground(new Color(0, 0, 102));
        this.undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JarTreeDialog.this.undoManager.undo();
            }
        });
        this.redoButton = new JButton(ToolsRes.getString("JarTreeDialog.Button.Redo"));
        this.redoButton.setForeground(new Color(0, 0, 102));
        this.redoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JarTreeDialog.this.undoManager.redo();
            }
        });
        this.languagesButton = new JButton(ToolsRes.getString("JarTreeDialog.Button.Languages"));
        this.languagesButton.setForeground(new Color(0, 0, 102));
        this.languagesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JarTreeDialog.this.selectLanguageAction();
            }
        });
        JPanel buttonbar = new JPanel(new FlowLayout());
        buttonbar.setBorder(BorderFactory.createEmptyBorder(1, 0, 3, 0));
        contentPane.add((Component)buttonbar, "South");
        buttonbar.add(this.languagesButton);
        buttonbar.add(this.undoButton);
        buttonbar.add(this.redoButton);
        buttonbar.add(this.okButton);
        buttonbar.add(cancelButton);
        this.pack();
    }

    protected void selectLanguageAction() {
        final ArrayList<Locale> choices = new ArrayList<Locale>();
        ArrayList<String> names = new ArrayList<String>();
        final ArrayList<Locale> originals = new ArrayList<Locale>();
        Locale[] locales = OSPRuntime.getInstalledLocales();
        boolean[] selected = new boolean[locales.length];
        boolean[] disabled = new boolean[locales.length];
        Object[] rootPath = new Object[]{this.jarModel.getRoot()};
        final Collection<Object[]> jarPaths = this.jarModel.getDescendantPaths(rootPath);
        CheckTreeSelectionModel checkModel = this.checkManager.getSelectionModel();
        int i = 0;
        while (i < locales.length) {
            choices.add(locales[i]);
            originals.add(locales[i]);
            names.add(locales[i].getDisplayLanguage(ToolsRes.resourceLocale));
            String lang = locales[i].getLanguage();
            if (locales[i] == Locale.ENGLISH) {
                selected[i] = true;
                disabled[i] = true;
            } else {
                for (Object[] array : jarPaths) {
                    TreePath thePath;
                    String s = array[array.length - 1].toString();
                    if (s.indexOf(".properties") <= -1 || s.indexOf("display_res_" + lang) <= -1 || (thePath = new TreePath(array)).toString().indexOf(OSPRuntime.getLaunchJarName()) <= -1) continue;
                    selected[i] = checkModel.isPathOrAncestorSelected(thePath);
                    break;
                }
            }
            ++i;
        }
        ListChooser dialog = new ListChooser(ToolsRes.getString("JarTreeDialog.Chooser.Languages.Title"), ToolsRes.getString("JarTreeDialog.Chooser.Languages.Message"), this, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1001) {
                    ArrayList<TreePath> removePaths = new ArrayList<TreePath>();
                    ArrayList<TreePath> addPaths = new ArrayList<TreePath>();
                    for (Locale next : originals) {
                        String lang = next.getLanguage();
                        for (Object[] array : jarPaths) {
                            TreePath propPath;
                            String s = array[array.length - 1].toString();
                            if (s.indexOf(".properties") <= -1 || s.indexOf("_" + lang) <= -1 || (propPath = new TreePath(array)).toString().indexOf(OSPRuntime.getLaunchJarName()) <= -1) continue;
                            if (!choices.contains(next)) {
                                removePaths.add(propPath);
                                continue;
                            }
                            addPaths.add(propPath);
                        }
                    }
                    TreePath[] paths = removePaths.toArray(new TreePath[0]);
                    JarTreeDialog.this.checkManager.getSelectionModel().removeSelectionPaths(paths);
                    paths = addPaths.toArray(new TreePath[0]);
                    JarTreeDialog.this.checkManager.getSelectionModel().addSelectionPaths(paths);
                    JarTreeDialog.this.refresh();
                }
            }
        });
        dialog.choose(choices, names, null, null, selected, disabled);
    }

    protected class JarRenderer
    extends DefaultTreeCellRenderer {
        protected JarRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof File) {
                File file = (File)value;
                if (file.getName().endsWith(".jar")) {
                    this.setIcon(JarTreeDialog.this.jarIcon);
                } else if (leaf) {
                    this.setIcon(JarTreeDialog.this.fileIcon);
                }
            } else if (value instanceof JarTreeModel.JarNode) {
                this.setIcon(leaf ? JarTreeDialog.this.jarFileIcon : JarTreeDialog.this.jarFolderIcon);
            }
            return this;
        }
    }

    protected class SelectionEdit
    extends AbstractUndoableEdit {
        TreePath[] undo;
        TreePath[] redo;
        int undoRow;
        int redoRow;

        public SelectionEdit(TreePath[] undoPaths, TreePath[] redoPaths) {
            this.undo = undoPaths;
            this.redo = redoPaths;
        }

        public SelectionEdit(TreePath[] undoPaths, int undoRow, TreePath[] redoPaths, int redoRow) {
            this.undo = undoPaths;
            this.redo = redoPaths;
            this.undoRow = undoRow;
            this.redoRow = redoRow;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            JarTreeDialog.this.ignoreEvents = true;
            CheckTreeSelectionModel checkModel = JarTreeDialog.this.checkManager.getSelectionModel();
            checkModel.setSelectionPaths(this.undo);
            JarTreeDialog.this.jarTree.setSelectionRow(this.undoRow);
            JarTreeDialog.this.ignoreEvents = false;
            JarTreeDialog.this.refresh();
            JarTreeDialog.this.prevRow = this.undoRow;
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            JarTreeDialog.this.ignoreEvents = true;
            CheckTreeSelectionModel checkModel = JarTreeDialog.this.checkManager.getSelectionModel();
            checkModel.setSelectionPaths(this.redo);
            JarTreeDialog.this.jarTree.setSelectionRow(this.redoRow);
            JarTreeDialog.this.ignoreEvents = false;
            JarTreeDialog.this.refresh();
            JarTreeDialog.this.prevRow = this.redoRow;
        }

        @Override
        public String getPresentationName() {
            return "Change Selection";
        }
    }
}

