/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.XML;

public class JarTreeModel
implements TreeModel {
    protected File root;
    protected Map<File, JarNode[]> topLevelNodeArrays = new HashMap<File, JarNode[]>();
    protected Map<File, Map<String, JarNode>> pathMaps = new HashMap<File, Map<String, JarNode>>();

    public JarTreeModel(File root) {
        this.root = root;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof File) {
            File file = (File)node;
            if (file.getName().endsWith(".jar")) {
                return false;
            }
            return ((File)node).isFile();
        }
        if (node instanceof JarNode) {
            JarNode treeNode = (JarNode)node;
            return treeNode.isLeaf();
        }
        return true;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof File) {
            File parentFile = (File)parent;
            if (parentFile.getName().endsWith(".jar")) {
                JarNode[] nodes = this.getJarNodes(parentFile);
                return nodes == null ? 0 : nodes.length;
            }
            String[] children = ((File)parent).list();
            return children == null ? 0 : children.length;
        }
        if (parent instanceof JarNode) {
            JarNode treeNode = (JarNode)parent;
            return treeNode.getChildCount();
        }
        return 0;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof File) {
            File parentFile = (File)parent;
            if (parentFile.getName().endsWith(".jar")) {
                JarNode[] nodes = this.getJarNodes(parentFile);
                if (nodes != null && nodes.length > index) {
                    return nodes[index];
                }
                return "no child found";
            }
            String[] children = parentFile.list();
            if (children == null || index >= children.length) {
                return null;
            }
            return new File(parentFile, children[index]){

                @Override
                public String toString() {
                    return this.getName();
                }
            };
        }
        if (parent instanceof JarNode) {
            JarNode treeNode = (JarNode)parent;
            return treeNode.getChildAt(index);
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof File) {
            String[] children;
            File parentFile = (File)parent;
            if (parentFile.getName().endsWith(".jar")) {
                JarNode[] nodes = this.getJarNodes(parentFile);
                if (nodes == null) {
                    return -1;
                }
                int i = 0;
                while (i < nodes.length) {
                    if (nodes[i].equals(child)) {
                        return i;
                    }
                    ++i;
                }
            }
            if ((children = ((File)parent).list()) == null) {
                return -1;
            }
            String childname = ((File)child).getName();
            int i = 0;
            while (i < children.length) {
                if (childname.equals(children[i])) {
                    return i;
                }
                ++i;
            }
        } else if (parent instanceof JarNode) {
            JarNode treeNode = (JarNode)parent;
            return treeNode.getIndex((JarNode)child);
        }
        return -1;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newvalue) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    public Object getChild(Object parent, String name) {
        block8: {
            block7: {
                String[] children;
                int i;
                JarNode[] nodes;
                if (!(parent instanceof File)) break block7;
                File parentFile = (File)parent;
                if (parentFile.getName().endsWith(".jar") && (nodes = this.getJarNodes(parentFile)) != null) {
                    i = 0;
                    while (i < nodes.length) {
                        if (nodes[i].toString().equals(name)) {
                            return nodes[i];
                        }
                        ++i;
                    }
                }
                if ((children = parentFile.list()) == null) break block8;
                i = 0;
                while (i < children.length) {
                    if (children[i].toString().equals(name)) {
                        return new File(parentFile, children[i]){

                            @Override
                            public String toString() {
                                return this.getName();
                            }
                        };
                    }
                    ++i;
                }
                break block8;
            }
            if (parent instanceof JarNode) {
                JarNode treeNode = (JarNode)parent;
                Enumeration<TreeNode> e = treeNode.children();
                while (e.hasMoreElements()) {
                    JarNode next = (JarNode)e.nextElement();
                    if (!next.toString().equals(name)) continue;
                    return next;
                }
            }
        }
        return null;
    }

    protected Collection<Object[]> getDescendantPaths(Object[] parentPath) {
        ArrayList<Object[]> c = new ArrayList<Object[]>();
        c.add(parentPath);
        Object parent = parentPath[parentPath.length - 1];
        int n = this.getChildCount(parent);
        int i = 0;
        while (i < n) {
            Object child = this.getChild(parent, i);
            Object[] childPath = new Object[parentPath.length + 1];
            System.arraycopy(parentPath, 0, childPath, 0, parentPath.length);
            childPath[parentPath.length] = child;
            Collection<Object[]> childPaths = this.getDescendantPaths(childPath);
            c.addAll(childPaths);
            ++i;
        }
        return c;
    }

    public JarNode getJarNode(File jarFile, String path) {
        Map<String, JarNode> pathMap = this.pathMaps.get(jarFile);
        if (pathMap == null) {
            this.readJar(jarFile);
            pathMap = this.pathMaps.get(jarFile);
        }
        return pathMap.get(path);
    }

    public JarNode[] getJarNodes(File jarFile) {
        JarNode[] array = this.topLevelNodeArrays.get(jarFile);
        if (array == null) {
            this.readJar(jarFile);
            array = this.topLevelNodeArrays.get(jarFile);
        }
        return array;
    }

    private void readJar(File jarFile) {
        Collection<String> entries = this.getJarEntries(jarFile);
        ArrayList<JarNode> topLevelNodes = new ArrayList<JarNode>();
        HashMap<String, JarNode> nodes = new HashMap<String, JarNode>();
        Iterator<String> it = entries.iterator();
        while (it.hasNext()) {
            String path = XML.forwardSlash(it.next().toString());
            if (path.startsWith("META-INF")) continue;
            JarNode parent = null;
            String parentPath = "";
            while (path != null) {
                JarNode node;
                int n = path.indexOf("/");
                if (n > -1) {
                    node = (JarNode)nodes.get(parentPath = String.valueOf(parentPath) + path.substring(0, n + 1));
                    if (node == null) {
                        node = new JarNode(parentPath);
                        nodes.put(parentPath, node);
                        if (parent != null) {
                            parent.add(node);
                        } else {
                            topLevelNodes.add(node);
                        }
                    }
                    path = path.substring(n + 1);
                    parent = node;
                    continue;
                }
                path = String.valueOf(parentPath) + path;
                node = (JarNode)nodes.get(path);
                if (node == null) {
                    node = new JarNode(path);
                    nodes.put(path, node);
                    if (parent != null) {
                        parent.add(node);
                    } else {
                        topLevelNodes.add(node);
                    }
                }
                path = null;
            }
        }
        JarNode[] array = topLevelNodes.toArray(new JarNode[0]);
        this.topLevelNodeArrays.put(jarFile, array);
        this.pathMaps.put(jarFile, nodes);
    }

    private Collection<String> getJarEntries(File jarFile) {
        JarFile jar = null;
        try {
            jar = new JarFile(jarFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (jar != null) {
            TreeSet<String> entries = new TreeSet<String>();
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                entries.add(entry.getName());
            }
            try {
                jar.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return entries;
        }
        return null;
    }

    class JarNode
    extends DefaultMutableTreeNode {
        String name;

        public JarNode(String path) {
            this.name = XML.getName(path);
            if (this.name.equals("")) {
                this.name = XML.getName(path.substring(0, path.length() - 1));
            }
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

