/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.Tool;

public class JobManager {
    Tool localTool;
    Map<Job, Collection<Tool>> replies = new HashMap<Job, Collection<Tool>>();
    Map<Job, Collection<Object>> objects = new HashMap<Job, Collection<Object>>();

    public JobManager(Tool tool) {
        this.localTool = tool;
    }

    public void log(Job job, Tool tool) {
        if (tool == null) {
            return;
        }
        Collection<Tool> tools2 = this.replies.get(job);
        if (tools2 == null) {
            tools2 = new HashSet<Tool>();
            this.replies.put(job, tools2);
        }
        tools2.add(tool);
    }

    public void associate(Job job, Object obj) {
        if (obj == null) {
            return;
        }
        Collection<Object> tags = this.objects.get(job);
        if (tags == null) {
            tags = new HashSet<Object>();
            this.objects.put(job, tags);
        }
        tags.add(obj);
    }

    public Job[] getJobs(Object obj) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (Job job : this.objects.keySet()) {
            Collection<Object> tags = this.objects.get(job);
            if (tags == null) {
                return null;
            }
            if (!tags.contains(obj)) continue;
            jobs.add(job);
        }
        return jobs.toArray(new Job[0]);
    }

    public Object[] getObjects(Job job) {
        Collection<Object> tags = this.objects.get(job);
        if (tags == null) {
            return new Object[0];
        }
        return tags.toArray(new Object[0]);
    }

    public Collection<Tool> getTools(Object obj) {
        HashSet<Tool> tools2 = new HashSet<Tool>();
        Job[] jobs = this.getJobs(obj);
        int i = 0;
        while (i < jobs.length) {
            Collection<Tool> next = this.replies.get(jobs[i]);
            if (next != null) {
                tools2.addAll(next);
            }
            ++i;
        }
        return tools2;
    }

    public void sendReplies(Object obj) {
        Job[] jobs = this.getJobs(obj);
        XMLControlElement control = new XMLControlElement(obj);
        String xml = control.toXML();
        int i = 0;
        while (i < jobs.length) {
            jobs[i].setXML(xml);
            this.sendReplies(jobs[i]);
            ++i;
        }
    }

    public void sendReplies(Job job) {
        Collection<Tool> tools2 = this.replies.get(job);
        if (tools2 == null) {
            return;
        }
        for (Tool tool : tools2) {
            tool.send(job, this.localTool);
        }
    }
}

