/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import org.opensourcephysics.numerics.PolynomialLeastSquareFit;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;

public class KnownPolynomial
extends PolynomialLeastSquareFit
implements KnownFunction {
    String name;
    String description;
    String[] paramNames = new String[]{"A", "B", "C", "D", "E", "F"};
    String[] paramDescriptions;

    KnownPolynomial(double[] xdata, double[] ydata, int degree) {
        super(xdata, ydata, degree);
    }

    public KnownPolynomial(double[] coeffs) {
        super(coeffs);
    }

    @Override
    public int getParameterCount() {
        return this.coefficients.length;
    }

    @Override
    public String getParameterName(int i) {
        return this.paramNames[i];
    }

    @Override
    public String getParameterDescription(int i) {
        if (this.paramDescriptions != null && this.paramDescriptions.length > i) {
            return this.paramDescriptions[i];
        }
        if (this.getParameterCount() == 2) {
            if (i == 0) {
                return ToolsRes.getString("Function.Parameter.Slope.Description");
            }
            return ToolsRes.getString("Function.Parameter.Intercept.Description");
        }
        return null;
    }

    @Override
    public double getParameterValue(int i) {
        return this.coefficients[this.coefficients.length - i - 1];
    }

    @Override
    public void setParameterValue(int i, double value) {
        if (Double.isNaN(value)) {
            return;
        }
        this.coefficients[this.coefficients.length - i - 1] = value;
    }

    @Override
    public void setParameters(String[] names, double[] values, String[] descriptions) {
        int i;
        if (names != null) {
            i = 0;
            while (i < Math.min(names.length, this.getParameterCount())) {
                if (names[i] != null && !"".equals(names[i].trim())) {
                    this.paramNames[i] = names[i];
                }
                ++i;
            }
        }
        this.paramDescriptions = descriptions;
        if (values != null) {
            i = 0;
            while (i < Math.min(values.length, this.getParameterCount())) {
                this.setParameterValue(i, values[i]);
                ++i;
            }
        }
    }

    @Override
    public String getExpression(String indepVarName) {
        StringBuffer eqn = new StringBuffer();
        int end = this.coefficients.length - 1;
        int i = 0;
        while (i <= end) {
            eqn.append(this.getParameterName(i));
            if (end - i > 0) {
                eqn.append("*");
                eqn.append(indepVarName);
                if (end - i > 1) {
                    eqn.append("^");
                    eqn.append(end - i);
                }
                eqn.append(" + ");
            }
            ++i;
        }
        return eqn.toString();
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "Poly" + (this.getParameterCount() - 1);
    }

    @Override
    public void setName(String aName) {
        if (aName != null && !"".equals(aName.trim())) {
            this.name = aName;
        }
    }

    @Override
    public String getDescription() {
        if (this.description != null && !"".equals(this.description.trim())) {
            return this.description;
        }
        return String.valueOf(ToolsRes.getString("KnownPolynomial.Description")) + " " + (this.getParameterCount() - 1);
    }

    @Override
    public void setDescription(String aDescription) {
        this.description = aDescription;
    }

    @Override
    public KnownPolynomial clone() {
        KnownPolynomial clone = new KnownPolynomial(this.coefficients);
        clone.setName(this.getName());
        clone.setDescription(this.getDescription());
        String[] names = new String[this.coefficients.length];
        double[] values = new double[this.coefficients.length];
        String[] desc = new String[this.coefficients.length];
        int i = 0;
        while (i < this.coefficients.length) {
            names[i] = this.getParameterName(i);
            values[i] = this.getParameterValue(i);
            desc[i] = this.getParameterDescription(i);
            ++i;
        }
        clone.setParameters(names, values, desc);
        return clone;
    }

    @Override
    public boolean equals(Object f) {
        if (!(f instanceof KnownPolynomial)) {
            return false;
        }
        KnownPolynomial poly = (KnownPolynomial)f;
        int n = this.getParameterCount();
        if (n != poly.getParameterCount()) {
            return false;
        }
        int i = 0;
        while (i < n) {
            if (!this.getParameterName(i).equals(poly.getParameterName(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String toString() {
        return "KnownPolynomial: " + this.getExpression("<x>");
    }

    @Override
    public UserFunction newUserFunction(String var) {
        UserFunction uf = new UserFunction(this.getName());
        int n = this.getParameterCount();
        String[] params = new String[n];
        double[] values = new double[n];
        String[] desc = new String[n];
        int i = 0;
        while (i < n) {
            params[i] = this.getParameterName(i);
            values[i] = this.getParameterValue(i);
            desc[i] = this.getParameterDescription(i);
            ++i;
        }
        uf.setParameters(params, values, desc);
        uf.setExpression(this.getExpression(var), new String[]{var});
        return uf;
    }
}

