/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PrintUtils;
import org.opensourcephysics.tools.EncryptionTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.JarTool;
import org.opensourcephysics.tools.JarTreeDialog;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.LaunchPanel;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.LaunchSaver;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.LauncherUndo;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class LaunchBuilder
extends Launcher {
    static final Color RED = new Color(255, 102, 102);
    static JFileChooser fileChooser;
    static javax.swing.filechooser.FileFilter jarFileFilter;
    static javax.swing.filechooser.FileFilter htmlFileFilter;
    static javax.swing.filechooser.FileFilter pdfFileFilter;
    static javax.swing.filechooser.FileFilter allFileFilter;
    static int maxArgs;
    static File ospJarFolder;
    static Color enabledColor;
    static Color disabledColor;
    Action newTabSetAction;
    Action changeAction;
    Action newTabAction;
    Action addAction;
    Action cutAction;
    Action copyAction;
    Action pasteAction;
    Action importAction;
    Action saveAsAction;
    Action saveAction;
    Action saveAllAction;
    Action saveSetAsAction;
    Action moveUpAction;
    Action moveDownAction;
    Action openJarAction;
    Action searchJarAction;
    Action saveJarAction;
    Action openArgAction;
    Action openModelArgAction;
    Action openURLAction;
    Action openPDFAction;
    Action searchJarForModelAction;
    Action openTabAction;
    Icon openIcon;
    JTabbedPane editorTabs;
    FocusListener focusListener;
    KeyListener keyListener;
    JPanel displayPanel;
    JPanel launchPanel;
    JPanel authorPanel;
    ArrayList<JLabel> labels;
    JTextField titleField;
    JLabel titleLabel;
    JTextField passwordEditor;
    JLabel passwordLabel;
    JTextField nameField;
    JLabel nameLabel;
    JTextField tooltipField;
    JLabel tooltipLabel;
    TitledBorder displayTitle;
    JTextField classField;
    JLabel classLabel;
    JTextField argField;
    JLabel argLabel;
    JSpinner argSpinner;
    JTextField jarField;
    JLabel jarLabel;
    JToolBar displayBar;
    JLabel displayLabel;
    SpinnerNumberModel displaySpinnerModel;
    JSpinner displaySpinner;
    JLabel pathLabel;
    JTextField pathField;
    JButton openDisplayChooserButton;
    JButton showModelArgsButton;
    JDialog modelArgsDialog;
    JTextField modelArgField;
    JLabel modelArgLabel;
    JSpinner modelArgSpinner;
    JButton modelArgCloseButton;
    JButton modelArgClearButton;
    JLabel tabTitleLabel;
    JTextField tabTitleField;
    JPanel urlPanel;
    JTextPane descriptionPane;
    JScrollPane descriptionScroller;
    TitledBorder descriptionTitle;
    JEditorPane htmlPane;
    JScrollPane htmlScroller;
    JSplitPane displaySplitPane;
    JTextField authorField;
    JLabel authorLabel;
    JTextField keywordField;
    JLabel keywordLabel;
    JTextField levelField;
    JLabel levelLabel;
    JTextField languagesField;
    JLabel languagesLabel;
    JTextPane commentPane;
    JScrollPane commentScroller;
    TitledBorder commentTitle;
    TitledBorder optionsTitle;
    TitledBorder securityTitle;
    JCheckBox editorEnabledCheckBox;
    JCheckBox encryptCheckBox;
    JCheckBox onEditCheckBox;
    JCheckBox onLoadCheckBox;
    JCheckBox hideRootCheckBox;
    JCheckBox hiddenCheckBox;
    JCheckBox buttonViewCheckBox;
    JCheckBox singleVMCheckBox;
    JCheckBox showLogCheckBox;
    JCheckBox clearLogCheckBox;
    JCheckBox singletonCheckBox;
    JCheckBox singleAppCheckBox;
    JComboBox<Level> levelDropDown;
    String previousClassPath;
    JButton newTabButton;
    JButton addButton;
    JButton cutButton;
    JButton copyButton;
    JButton pasteButton;
    JButton moveUpButton;
    JButton moveDownButton;
    JMenuItem newItem;
    JMenuItem previewItem;
    JMenuItem saveNodeItem;
    JMenuItem saveNodeAsItem;
    JMenuItem saveSetAsItem;
    JMenuItem saveAllItem;
    JMenuItem saveJarItem;
    JMenuItem importItem;
    JMenuItem openTabItem;
    JMenu toolsMenu;
    JMenuItem encryptionToolItem;
    JToolBar toolbar;
    LaunchSaver saver = new LaunchSaver(this);

    static {
        maxArgs = 4;
        enabledColor = UIManager.getColor("Label.foreground");
        if (enabledColor == null) {
            enabledColor = Color.BLACK;
        }
        if ((disabledColor = UIManager.getColor("Label.disabledForeground")) == null) {
            disabledColor = UIManager.getColor("Label.disabledText");
        }
        if (disabledColor == null) {
            disabledColor = Color.LIGHT_GRAY;
        }
    }

    public LaunchBuilder() {
        OSPRuntime.setAuthorMode(true);
        XML.setLoader(NodeSet.class, new NodeSet.Loader());
    }

    public LaunchBuilder(String fileName) {
        super(fileName);
        OSPRuntime.setAuthorMode(true);
        XML.setLoader(NodeSet.class, new NodeSet.Loader());
    }

    public LaunchBuilder(boolean splash) {
        super(splash);
        OSPRuntime.setAuthorMode(true);
        XML.setLoader(NodeSet.class, new NodeSet.Loader());
    }

    public LaunchBuilder(String fileName, boolean splash) {
        super(fileName, splash);
        OSPRuntime.setAuthorMode(true);
        XML.setLoader(NodeSet.class, new NodeSet.Loader());
    }

    public static void main(String[] args) {
        String fileName = null;
        if (args != null && args.length != 0) {
            fileName = args[0];
        }
        LaunchBuilder builder = new LaunchBuilder(fileName);
        builder.frame.setVisible(true);
    }

    public String save(LaunchNode node, String fileName) {
        if (node == null) {
            return null;
        }
        if (fileName == null || fileName.trim().equals("")) {
            return this.saveAs(node);
        }
        if (XML.getExtension(fileName) == null) {
            while (fileName.endsWith(".")) {
                fileName = fileName.substring(0, fileName.length() - 1);
            }
            fileName = String.valueOf(fileName) + ".xml";
        }
        if (!this.saveOwnedNodes(node)) {
            return null;
        }
        String filepath = fileName;
        if (!tabSetBasePath.equals("")) {
            filepath = XML.getResolvedPath(fileName, tabSetBasePath);
        } else {
            String jarBase = OSPRuntime.getLaunchJarDirectory();
            filepath = XML.getResolvedPath(fileName, jarBase);
        }
        File file = new File(filepath);
        OSPLog.fine(String.valueOf(fileName) + " = " + file.getAbsolutePath());
        String fullName = XML.forwardSlash(file.getAbsolutePath());
        String path = XML.getDirectoryPath(fullName);
        XML.createFolders(path);
        XMLControlElement control = new XMLControlElement(node);
        control.write(fullName);
        if (!control.canWrite) {
            OSPLog.info(String.valueOf(LaunchRes.getString("Dialog.SaveFailed.Message")) + " " + fullName);
            JOptionPane.showMessageDialog(null, String.valueOf(LaunchRes.getString("Dialog.SaveFailed.Message")) + " " + fileName, LaunchRes.getString("Dialog.SaveFailed.Title"), 2);
            return null;
        }
        node.setFileName(fileName);
        this.changedFiles.remove(node.getFileName());
        return fileName;
    }

    public String saveAs(LaunchNode node) {
        String name;
        LaunchBuilder.getXMLChooser().setFileFilter(xmlFileFilter);
        if (node.getFileName() != null) {
            name = XML.getResolvedPath(node.getFileName(), tabSetBasePath);
            LaunchBuilder.getXMLChooser().setSelectedFile(new File(name));
        } else {
            name = node.name;
            if (name.equals(LaunchRes.getString("NewNode.Name")) || name.equals(LaunchRes.getString("NewTab.Name"))) {
                name = LaunchRes.getString("NewFile.Name");
            }
            String path = XML.getResolvedPath(String.valueOf(name) + ".xml", tabSetBasePath);
            LaunchBuilder.getXMLChooser().setSelectedFile(new File(path));
        }
        int result = LaunchBuilder.getXMLChooser().showDialog(null, LaunchRes.getString("FileChooser.SaveAs.Title"));
        if (result == 0) {
            File file = LaunchBuilder.getXMLChooser().getSelectedFile();
            String path = XML.forwardSlash(file.getParent());
            XML.createFolders(path);
            if (file.exists()) {
                String name2 = XML.forwardSlash(file.getAbsolutePath());
                name2 = XML.getPathRelativeTo(name2, tabSetBasePath);
                if (this.getOpenPaths().contains(name2)) {
                    JOptionPane.showMessageDialog(this.frame, String.valueOf(LaunchRes.getString("Dialog.DuplicateFileName.Message")) + " \"" + name2 + "\"", LaunchRes.getString("Dialog.DuplicateFileName.Title"), 2);
                    return null;
                }
                int selected = JOptionPane.showConfirmDialog(this.frame, String.valueOf(LaunchRes.getString("Dialog.ReplaceFile.Message")) + " " + file.getName() + XML.NEW_LINE + LaunchRes.getString("Dialog.ReplaceFile.Question"), LaunchRes.getString("Dialog.ReplaceFile.Title"), 0);
                if (selected != 0) {
                    return null;
                }
            }
            path = XML.forwardSlash(file.getAbsolutePath());
            String fileName = XML.getPathRelativeTo(path, tabSetBasePath);
            OSPRuntime.chooserDir = XML.getDirectoryPath(path);
            Map<LaunchPanel, LaunchNode> clones = this.getClones(node);
            path = this.save(node, fileName);
            if (path != null) {
                if (node.isRoot()) {
                    int i = 0;
                    while (i < this.tabbedPane.getTabCount()) {
                        LaunchPanel tab = (LaunchPanel)this.tabbedPane.getComponentAt(i);
                        if (tab.getRootNode() == node) {
                            this.tabbedPane.setTitleAt(i, node.toString());
                            break;
                        }
                        ++i;
                    }
                }
                for (LaunchPanel cloneTab : clones.keySet()) {
                    LaunchNode clone = clones.get(cloneTab);
                    clone.setFileName(node.getFileName());
                    if (clone != cloneTab.getRootNode()) continue;
                    int n = this.tabbedPane.indexOfComponent(cloneTab);
                    this.tabbedPane.setTitleAt(n, node.toString());
                }
                if (this.tabSetName != null) {
                    this.changedFiles.add(this.tabSetName);
                }
            }
            return path;
        }
        return null;
    }

    protected boolean saveOwnedNodes(LaunchNode node) {
        if (node == null) {
            return false;
        }
        if (node.isSelfContained()) {
            return true;
        }
        LaunchNode[] nodes = node.getChildOwnedNodes();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i].getChildOwnedNodes().length > 1 && !this.saveOwnedNodes(nodes[i])) {
                return false;
            }
            if (this.save(nodes[i], nodes[i].getFileName()) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected String saveTabSetAs() {
        int selected;
        this.saver.setBuilder(this);
        this.saver.setVisible(true);
        if (!this.saver.isApproved()) {
            return null;
        }
        String fileName = XML.getResolvedPath(this.tabSetName, tabSetBasePath);
        File file = new File(fileName);
        if (file.exists() && (selected = JOptionPane.showConfirmDialog(this.frame, String.valueOf(LaunchRes.getString("Dialog.ReplaceFile.Message")) + " " + file.getName() + XML.NEW_LINE + LaunchRes.getString("Dialog.ReplaceFile.Question"), LaunchRes.getString("Dialog.ReplaceFile.Title"), 0)) != 0) {
            return null;
        }
        this.saveState = this.saver.saveStateCheckBox.isSelected();
        return this.saveTabSet();
    }

    public String saveTabSet() {
        if (this.tabSetName == null) {
            return null;
        }
        if (this.tabSetName.trim().equals("")) {
            return this.saveTabSetAs();
        }
        if (!this.isTabSetWritable()) {
            return this.saveTabSetAs();
        }
        if (!this.selfContained && !this.saveTabs()) {
            return null;
        }
        String fileName = this.tabSetName;
        if (!tabSetBasePath.equals("")) {
            fileName = XML.getResolvedPath(this.tabSetName, tabSetBasePath);
        } else {
            String jarBase = OSPRuntime.getLaunchJarDirectory();
            fileName = XML.getResolvedPath(this.tabSetName, jarBase);
        }
        OSPLog.fine(fileName);
        File file = new File(fileName);
        fileName = XML.forwardSlash(file.getAbsolutePath());
        String path = XML.getDirectoryPath(fileName);
        XML.createFolders(path);
        Launcher.LaunchSet tabset = new Launcher.LaunchSet(this, this, this.tabSetName);
        XMLControlElement control = new XMLControlElement(tabset);
        if (control.write(fileName) == null) {
            return null;
        }
        this.changedFiles.clear();
        this.jarBasePath = null;
        if (this.spawner != null) {
            this.spawner.open(fileName);
            this.spawner.refreshGUI();
        }
        return fileName;
    }

    public boolean saveTabs() {
        Component[] tabs = this.tabbedPane.getComponents();
        int i = 0;
        while (i < tabs.length) {
            LaunchPanel tab = (LaunchPanel)tabs[i];
            LaunchNode root = tab.getRootNode();
            if (root.getFileName() != null && !root.getFileName().equals("")) {
                this.save(root, XML.getResolvedPath(root.getFileName(), tabSetBasePath));
            }
            ++i;
        }
        return true;
    }

    protected void refreshSelectedNode() {
        this.refreshNode(this.getSelectedNode());
    }

    protected void refreshNode(LaunchNode node) {
        boolean changed = false;
        if (node != null) {
            LaunchNode root;
            boolean change;
            String className;
            String title;
            String path;
            String jarPath;
            LaunchNode parent;
            if (node.isSingleVM() != this.singleVMCheckBox.isSelected()) {
                LaunchBuilder.log("Log.Message.ChangeNodeVM");
                parent = (LaunchNode)node.getParent();
                if (parent != null && parent.isSingleVM()) {
                    node.singleVM = false;
                    node.singleVMOff = !this.singleVMCheckBox.isSelected();
                } else {
                    node.singleVM = this.singleVMCheckBox.isSelected();
                    node.singleVMOff = false;
                }
                if (node.isSingleVM()) {
                    this.showLogCheckBox.setSelected(node.showLog);
                    this.clearLogCheckBox.setSelected(node.clearLog);
                    this.singleAppCheckBox.setSelected(node.isSingleApp());
                } else {
                    this.singletonCheckBox.setSelected(node.singleton);
                }
                changed = true;
            }
            if (node.isSingleVM() && node.showLog != this.showLogCheckBox.isSelected()) {
                LaunchBuilder.log("Log.Message.ChangeNodeShowLog");
                node.showLog = this.showLogCheckBox.isSelected();
                changed = true;
            }
            if (node.isSingleVM() && node.isShowLog() && node.clearLog != this.clearLogCheckBox.isSelected()) {
                LaunchBuilder.log("Log.Message.ChangeNodeClearLog");
                node.clearLog = this.clearLogCheckBox.isSelected();
                changed = true;
            }
            if (node.isSingleVM() && node.isSingleApp() != this.singleAppCheckBox.isSelected()) {
                LaunchBuilder.log("Log.Message.ChangeNodeSingleApp");
                parent = (LaunchNode)node.getParent();
                if (parent != null && parent.isSingleApp()) {
                    node.singleApp = false;
                    node.singleAppOff = !this.singleAppCheckBox.isSelected();
                } else {
                    node.singleApp = this.singleAppCheckBox.isSelected();
                    node.singleAppOff = false;
                }
                changed = true;
            }
            if (node.singleton != this.singletonCheckBox.isSelected()) {
                LaunchBuilder.log("Log.Message.ChangeNodeSingleton");
                node.singleton = this.singletonCheckBox.isSelected();
                changed = true;
            }
            if (node.hiddenInLauncher != this.hiddenCheckBox.isSelected()) {
                LaunchBuilder.log("Log.Message.ChangeNodeHidden");
                node.hiddenInLauncher = this.hiddenCheckBox.isSelected();
                changed = true;
            }
            if (node.isButtonView() != this.buttonViewCheckBox.isSelected()) {
                LaunchBuilder.log("Log.Message.ChangeButtonView");
                node.setButtonView(this.buttonViewCheckBox.isSelected());
                changed = true;
            }
            if (!node.name.equals(this.nameField.getText())) {
                LaunchBuilder.log("Log.Message.ChangeNodeName");
                node.name = this.nameField.getText();
                changed = true;
            }
            if (!node.tooltip.equals(this.tooltipField.getText())) {
                LaunchBuilder.log("Log.Message.ChangeTooltip");
                node.tooltip = this.tooltipField.getText();
                changed = true;
            }
            if (!node.description.equals(this.descriptionPane.getText())) {
                LaunchBuilder.log("Log.Message.ChangeNodeDesc");
                node.description = this.descriptionPane.getText();
                changed = true;
            }
            int n = (Integer)this.argSpinner.getValue();
            String arg = this.argField.getText();
            if (!arg.equals("")) {
                node.setMinimumArgLength(n + 1);
            }
            if (node.args.length > n && !arg.equals(node.args[n])) {
                LaunchBuilder.log("Log.Message.ChangeNodeArgs " + n);
                node.args[n] = arg;
                if (arg.equals("")) {
                    node.setMinimumArgLength(1);
                }
                changed = true;
            }
            if ((jarPath = this.jarField.getText()).equals("") && node.classPath != null || !jarPath.equals("") && !jarPath.equals(node.classPath)) {
                LaunchBuilder.log("Log.Message.ChangeNodePath");
                node.setClassPath(jarPath.equals("") ? null : jarPath);
                changed = true;
            }
            n = (Integer)this.displaySpinner.getValue();
            LaunchNode.DisplayTab displayTab = node.getDisplayTab(n);
            String input = this.pathField.getText();
            String string = path = displayTab == null ? null : displayTab.getPath();
            if (displayTab == null || (path != null ? !path.equals(input) : input != null && !input.equals(path))) {
                title = displayTab == null ? null : displayTab.getTitle();
                String[] args = displayTab == null ? null : displayTab.getModelArgs();
                node.setDisplayTab(n, title, input, args);
                LaunchBuilder.log("Log.Message.ChangeNodeURL");
                changed = true;
            }
            if (displayTab != null && displayTab.modelClass != null && this.modelArgsDialog.isVisible()) {
                String[] args;
                n = (Integer)this.modelArgSpinner.getValue();
                arg = this.modelArgField.getText();
                if (!arg.equals("")) {
                    displayTab.setMinimumModelArgLength(n + 1);
                }
                if ((args = displayTab.getModelArgs()).length > n && !arg.equals(args[n])) {
                    LaunchBuilder.log("Log.Message.ChangeModelArgs " + n);
                    args[n] = arg.equals("") ? null : arg;
                    displayTab.setModelArgs(args);
                    if (arg.equals("")) {
                        displayTab.setMinimumModelArgLength(0);
                    }
                    changed = true;
                }
            }
            if ((input = this.tabTitleField.getText()).equals("")) {
                input = null;
            }
            String string2 = title = displayTab == null ? null : displayTab.getTitle();
            if (displayTab != null && (title != null ? !title.equals(input) : input != null && !input.equals(title))) {
                LaunchBuilder.log("Log.Message.ChangeNodeHTMLTabTitle");
                node.setDisplayTab(n, input, displayTab.getPath(), displayTab.getModelArgs());
                changed = true;
            }
            if ((className = this.classField.getText()).equals("")) {
                if (node.launchClassName != null) {
                    node.launchClassName = null;
                    node.launchClass = null;
                    node.launchModelScroller = null;
                    LaunchBuilder.log("Log.Message.ChangeNodeLaunchClass");
                    changed = true;
                }
            } else if ((!className.equals(node.launchClassName) || !className.equals("") && node.getLaunchClass() == null) && (change = node.setLaunchClass(className))) {
                LaunchBuilder.log("Log.Message.ChangeNodeLaunchClass");
                changed = true;
            }
            if (!node.getAuthor().equals(this.authorField.getText())) {
                LaunchBuilder.log("Log.Message.ChangeNodeAuthor");
                node.author = this.authorField.getText();
                changed = true;
            }
            if (!node.keywords.equals(this.keywordField.getText())) {
                LaunchBuilder.log("Log.Message.ChangeNodeKeywords");
                node.keywords = this.keywordField.getText();
                changed = true;
            }
            if (!node.level.equals(this.levelField.getText())) {
                LaunchBuilder.log("Log.Message.ChangeNodeLevel");
                node.level = this.levelField.getText();
                changed = true;
            }
            if (!node.languages.equals(this.languagesField.getText())) {
                LaunchBuilder.log("Log.Message.ChangeNodeLanguages");
                node.languages = this.languagesField.getText();
                changed = true;
            }
            if (!node.comment.equals(this.commentPane.getText())) {
                LaunchBuilder.log("Log.Message.ChangeNodeComment");
                node.comment = this.commentPane.getText();
                changed = true;
            }
            if ((root = (LaunchNode)node.getRoot()) != null) {
                boolean edit;
                boolean hide = this.hideRootCheckBox.isSelected();
                if (hide != root.hiddenWhenRoot) {
                    root.hiddenWhenRoot = hide;
                    LaunchBuilder.log("Log.Message.ChangeNodeRootHidden");
                    changed = true;
                }
                if ((edit = this.editorEnabledCheckBox.isSelected()) != this.editorEnabled) {
                    this.editorEnabled = edit;
                    LaunchBuilder.log("Log.Message.ChangeNodeEditorEnabled");
                    if (this.tabSetName != null) {
                        this.changedFiles.add(this.tabSetName);
                    }
                    this.refreshGUI();
                }
            }
            if (changed) {
                OSPLog.fine(String.valueOf(LaunchRes.getString("Log.Message.ChangeNode")) + " \"" + node.toString() + "\"");
                LaunchPanel tab = this.getSelectedTab();
                if (tab != null) {
                    tab.treeModel.nodeChanged(node);
                }
                if (node.getOwner() != null) {
                    this.changedFiles.add(node.getOwner().getFileName());
                } else {
                    this.changedFiles.add(this.tabSetName);
                }
                this.refreshClones(node);
                this.refreshGUI();
            }
        }
    }

    @Override
    public boolean addTab(LaunchNode root) {
        if (root == null) {
            return false;
        }
        OSPLog.finest(root.toString());
        boolean added = super.addTab(root);
        if (added) {
            if (this.tabSetName == null) {
                this.tabSetName = LaunchRes.getString("Tabset.Name.New");
            }
            this.changedFiles.add(this.tabSetName);
            this.refreshGUI();
        }
        return added;
    }

    @Override
    public boolean removeSelectedTab() {
        if (this.tabbedPane.getTabCount() == 1) {
            String[] prevArgs = this.undoManager.getLauncherState();
            boolean removed = this.removeAllTabs();
            if (removed && prevArgs != null) {
                LauncherUndo launcherUndo = this.undoManager;
                launcherUndo.getClass();
                LauncherUndo.LoadEdit edit = new LauncherUndo.LoadEdit(launcherUndo, null, prevArgs);
                this.undoSupport.postEdit(edit);
            }
            return removed;
        }
        LaunchPanel tab = (LaunchPanel)this.tabbedPane.getSelectedComponent();
        if (tab != null && !this.saveChanges(tab)) {
            return false;
        }
        boolean removed = super.removeSelectedTab();
        if (this.tabSetName != null && removed) {
            this.changedFiles.add(this.tabSetName);
            this.refreshGUI();
        }
        return removed;
    }

    protected boolean saveChanges(LaunchPanel tab) {
        LaunchNode root = tab.getRootNode();
        int n = this.tabbedPane.indexOfComponent(tab);
        String name = n > -1 ? this.tabbedPane.getTitleAt(n) : LaunchBuilder.getDisplayName(root.getFileName());
        boolean changed = this.changedFiles.contains(root.getFileName());
        LaunchNode[] nodes = root.getAllOwnedNodes();
        int i = 0;
        while (i < nodes.length) {
            changed = changed || this.changedFiles.contains(nodes[i].getFileName());
            ++i;
        }
        if (changed) {
            int selected = JOptionPane.showConfirmDialog(this.frame, String.valueOf(LaunchRes.getString("Dialog.SaveChanges.Tab.Message")) + " \"" + name + "\"" + XML.NEW_LINE + LaunchRes.getString("Dialog.SaveChanges.Question"), LaunchRes.getString("Dialog.SaveChanges.Title"), 1);
            if (selected == 2) {
                return false;
            }
            if (selected == 0) {
                this.save(root, root.getFileName());
            }
        }
        return true;
    }

    @Override
    protected boolean removeAllTabs() {
        if (!this.saveAllChanges()) {
            return false;
        }
        return super.removeAllTabs();
    }

    protected boolean saveAllChanges() {
        if (!this.changedFiles.isEmpty() && this.tabbedPane.getTabCount() > 0) {
            String message = LaunchRes.getString("Dialog.SaveChanges.Tabset.Message");
            int selected = JOptionPane.showConfirmDialog(this.frame, String.valueOf(message) + "\"" + this.tabSetName + "\"" + XML.NEW_LINE + LaunchRes.getString("Dialog.SaveChanges.Question"), LaunchRes.getString("Dialog.SaveChanges.Title"), 1);
            if (selected == 2) {
                return false;
            }
            if (selected == 0) {
                if (this.tabSetName.equals(LaunchRes.getString("Tabset.Name.New")) || !this.saveAllItem.isEnabled()) {
                    this.saveTabSetAs();
                } else {
                    this.saveTabSet();
                }
            }
        }
        return true;
    }

    @Override
    protected void refreshStringResources() {
        Rectangle2D rect;
        super.refreshStringResources();
        this.saver = new LaunchSaver(this);
        this.editorTabs.setTitleAt(0, LaunchRes.getString("Tab.Display"));
        this.editorTabs.setTitleAt(1, LaunchRes.getString("Tab.Launch"));
        this.editorTabs.setTitleAt(2, LaunchRes.getString("Tab.Author"));
        this.displayTitle.setTitle(LaunchRes.getString("Label.DisplayPane"));
        this.commentTitle.setTitle(LaunchRes.getString("Label.Comments"));
        this.descriptionTitle.setTitle(LaunchRes.getString("Label.Description"));
        this.optionsTitle.setTitle(LaunchRes.getString("Label.Options"));
        this.hiddenCheckBox.setText(LaunchRes.getString("Checkbox.Hidden"));
        this.buttonViewCheckBox.setText(LaunchRes.getString("Checkbox.ButtonView"));
        this.nameLabel.setText(LaunchRes.getString("Label.Name"));
        this.tooltipLabel.setText(LaunchRes.getString("Label.Tooltip"));
        this.displayLabel.setText(LaunchRes.getString("Label.Display"));
        this.tabTitleLabel.setText(LaunchRes.getString("Label.TabTitle"));
        this.pathLabel.setText(LaunchRes.getString("Label.Path"));
        this.jarLabel.setText(LaunchRes.getString("Label.Jar"));
        this.classLabel.setText(LaunchRes.getString("Label.Class"));
        this.argLabel.setText(LaunchRes.getString("Label.Args"));
        this.singleVMCheckBox.setText(LaunchRes.getString("Checkbox.SingleVM"));
        this.showLogCheckBox.setText(LaunchRes.getString("Checkbox.ShowLog"));
        this.clearLogCheckBox.setText(LaunchRes.getString("Checkbox.ClearLog"));
        this.singletonCheckBox.setText(LaunchRes.getString("Checkbox.Singleton"));
        this.singleAppCheckBox.setText(LaunchRes.getString("Checkbox.SingleApp"));
        this.authorLabel.setText(LaunchRes.getString("Label.Author"));
        this.keywordLabel.setText(LaunchRes.getString("Label.Keywords"));
        this.levelLabel.setText(LaunchRes.getString("Label.Level"));
        this.languagesLabel.setText(LaunchRes.getString("Label.Languages"));
        this.securityTitle.setTitle(LaunchRes.getString("Label.Security"));
        this.editorEnabledCheckBox.setText(LaunchRes.getString("Checkbox.EditorEnabled"));
        this.encryptCheckBox.setText(LaunchRes.getString("Checkbox.Encrypted"));
        this.passwordLabel.setText(LaunchRes.getString("Label.Password"));
        this.onLoadCheckBox.setText(LaunchRes.getString("Checkbox.PWLoad"));
        this.titleLabel.setText(LaunchRes.getString("Label.Title"));
        this.hideRootCheckBox.setText(LaunchRes.getString("Checkbox.HideRoot"));
        this.previewItem.setText(LaunchRes.getString("Menu.File.Preview"));
        this.encryptionToolItem.setText(LaunchRes.getString("MenuItem.EncryptionTool"));
        this.newItem.setText(LaunchRes.getString("Menu.File.New"));
        this.importItem.setText(LaunchRes.getString("Action.Import"));
        this.saveNodeItem.setText(LaunchRes.getString("Action.SaveNode"));
        this.saveNodeAsItem.setText(LaunchRes.getString("Action.SaveNodeAs"));
        this.saveAllItem.setText(LaunchRes.getString("Action.SaveAll"));
        this.openTabItem.setText(LaunchRes.getString("Action.OpenTab"));
        this.saveSetAsItem.setText(LaunchRes.getString("Action.SaveSetAs"));
        this.toolsMenu.setText(LaunchRes.getString("Menu.Tools"));
        this.newTabButton.setText(LaunchRes.getString("Action.New"));
        this.addButton.setText(LaunchRes.getString("Action.Add"));
        this.cutButton.setText(LaunchRes.getString("Action.Cut"));
        this.copyButton.setText(LaunchRes.getString("Action.Copy"));
        this.pasteButton.setText(LaunchRes.getString("Action.Paste"));
        this.moveUpButton.setText(LaunchRes.getString("Action.Up"));
        this.moveDownButton.setText(LaunchRes.getString("Action.Down"));
        this.showModelArgsButton.setText(LaunchRes.getString("Button.ModelArgs"));
        this.modelArgsDialog.setTitle(LaunchRes.getString("Dialog.ModelArgs.Title"));
        this.modelArgCloseButton.setText(LaunchRes.getString("Dialog.Button.Close"));
        this.modelArgClearButton.setText(LaunchRes.getString("Dialog.Button.Clear"));
        this.modelArgLabel.setText(LaunchRes.getString("Label.Args"));
        this.pathField.setToolTipText(LaunchRes.getString("Display.Path.Tooltip"));
        this.tabTitleField.setToolTipText(LaunchRes.getString("Display.Tab.Title.Tooltip"));
        this.displaySpinner.setToolTipText(LaunchRes.getString("Display.Tab.Number.Tooltip"));
        this.openDisplayChooserButton.setToolTipText(LaunchRes.getString("Button.OpenDisplay.Tooltip"));
        this.showModelArgsButton.setToolTipText(LaunchRes.getString("Button.ModelArgs.Tooltip"));
        this.labels.clear();
        this.labels.add(this.nameLabel);
        this.labels.add(this.tooltipLabel);
        this.labels.add(this.displayLabel);
        FontRenderContext frc = new FontRenderContext(null, false, false);
        Font font = this.nameLabel.getFont();
        int w = 0;
        for (JLabel next : this.labels) {
            Rectangle2D rect2 = font.getStringBounds(String.valueOf(next.getText()) + " ", frc);
            w = Math.max(w, (int)rect2.getWidth() + 1);
        }
        Dimension labelSize = new Dimension(w, 20);
        for (JLabel next : this.labels) {
            next.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            next.setPreferredSize(labelSize);
            next.setHorizontalAlignment(11);
        }
        this.labels.clear();
        this.labels.add(this.jarLabel);
        this.labels.add(this.classLabel);
        this.labels.add(this.argLabel);
        w = 0;
        for (JLabel next : this.labels) {
            rect = font.getStringBounds(String.valueOf(next.getText()) + " ", frc);
            w = Math.max(w, (int)rect.getWidth() + 1);
        }
        labelSize = new Dimension(w, 20);
        for (JLabel next : this.labels) {
            next.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            next.setPreferredSize(labelSize);
            next.setHorizontalAlignment(11);
        }
        this.labels.clear();
        this.labels.add(this.authorLabel);
        this.labels.add(this.keywordLabel);
        this.labels.add(this.levelLabel);
        this.labels.add(this.languagesLabel);
        w = 0;
        for (JLabel next : this.labels) {
            rect = font.getStringBounds(String.valueOf(next.getText()) + " ", frc);
            w = Math.max(w, (int)rect.getWidth() + 1);
        }
        labelSize = new Dimension(w, 20);
        for (JLabel next : this.labels) {
            next.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            next.setPreferredSize(labelSize);
            next.setHorizontalAlignment(11);
        }
    }

    @Override
    protected void refreshGUI() {
        LaunchPanel tab;
        LaunchNode root;
        boolean rootEnabled;
        if (this.previousNode != null) {
            LaunchNode prev = this.previousNode;
            this.previousNode = null;
            this.refreshNode(prev);
        }
        if (this.newNodeSelected) {
            this.argSpinner.setValue(0);
            this.displaySpinner.setValue(0);
            this.newNodeSelected = false;
        }
        boolean bl = rootEnabled = (root = this.getRootNode()) == null || root.enabled;
        if (!rootEnabled) {
            this.editorTabs.setSelectedIndex(0);
        }
        this.titleField.setText(this.title);
        this.titleField.setBackground(Color.white);
        super.refreshGUI();
        String theTitle = this.frame.getTitle();
        if (this.title != null) {
            theTitle = !this.changedFiles.isEmpty() ? String.valueOf(theTitle) + " [" + this.tabSetName + "*]" : String.valueOf(theTitle) + " [" + this.tabSetName + "]";
        } else if (!this.changedFiles.isEmpty()) {
            if (this.tabbedPane.getTabCount() == 0) {
                this.changedFiles.clear();
            } else {
                theTitle = String.valueOf(theTitle) + "*";
            }
        }
        this.frame.setTitle(theTitle);
        LaunchNode node = this.getSelectedNode();
        if (node != null) {
            JScrollPane scroller;
            int i = 0;
            while (i < this.tabbedPane.getTabCount()) {
                root = this.getTab(i).getRootNode();
                this.tabbedPane.setTitleAt(i, root.toString());
                ++i;
            }
            this.hiddenCheckBox.setSelected(node.isHiddenInLauncher());
            boolean parentHidden = node.getParent() != null && ((LaunchNode)node.getParent()).isHiddenInLauncher();
            this.hiddenCheckBox.setEnabled(!parentHidden && rootEnabled);
            this.nameField.setText(node.toString());
            this.nameField.setBackground(Color.white);
            this.tooltipField.setText(node.tooltip);
            this.tooltipField.setBackground(Color.white);
            this.descriptionPane.setText(node.description);
            this.descriptionPane.setBackground(Color.white);
            int n = (Integer)this.displaySpinner.getValue();
            LaunchNode.DisplayTab displayTab = node.getDisplayTab(n);
            String urlPath = displayTab == null ? null : displayTab.getPath();
            boolean badURL = urlPath != null && displayTab != null && displayTab.url == null && displayTab.modelClass == null;
            this.pathField.setText(urlPath);
            this.pathField.setBackground(badURL ? RED : Color.white);
            this.displaySpinnerModel.setMaximum(Integer.valueOf(node.getDisplayTabCount()));
            this.displaySpinner.setVisible(node.getDisplayTab(0) != null);
            boolean hasHTML = displayTab != null && LaunchBuilder.isDisplayable(displayTab.getPath());
            this.tabTitleLabel.setVisible(hasHTML);
            this.tabTitleField.setVisible(hasHTML);
            this.tabTitleField.setText(displayTab != null ? displayTab.getTitle() : null);
            this.tabTitleField.setBackground(Color.white);
            this.displayBar.remove(this.showModelArgsButton);
            if (displayTab != null && (displayTab.url != null && LaunchBuilder.isDisplayable(displayTab.url.getPath()) || displayTab.getModelScroller() != null)) {
                if (displayTab.url != null) {
                    this.displaySplitPane.setTopComponent(this.htmlScroller);
                    if (!displayTab.url.equals(this.htmlPane.getPage())) {
                        if (displayTab.urlExists()) {
                            URL url = displayTab.url;
                            SwingUtilities.invokeLater(() -> {
                                try {
                                    this.htmlPane.setPage(url);
                                }
                                catch (IOException ex) {
                                    OSPLog.fine(String.valueOf(LaunchRes.getString("Log.Message.BadURL")) + " " + url);
                                }
                            });
                        } else {
                            this.htmlPane.setText(null);
                        }
                    }
                } else if (displayTab.getModelScroller() != null) {
                    scroller = displayTab.getModelScroller();
                    scroller.setBorder(this.displayTitle);
                    this.displaySplitPane.setTopComponent(scroller);
                    this.displayBar.add(this.showModelArgsButton);
                    n = (Integer)this.modelArgSpinner.getValue();
                    this.modelArgField.setText(displayTab.modelArgs.length > n ? displayTab.modelArgs[n] : "");
                    this.modelArgField.setBackground(this.modelArgField.getText().endsWith(".xml") && ResourceLoader.getResource(this.modelArgField.getText()) == null ? RED : Color.WHITE);
                }
            } else if (n == 0 && node.getLaunchModelScroller() != null) {
                scroller = node.getLaunchModelScroller();
                scroller.setBorder(this.displayTitle);
                this.displaySplitPane.setTopComponent(scroller);
            } else {
                this.displaySplitPane.setTopComponent(this.htmlScroller);
                this.htmlPane.setContentType("text");
                this.htmlPane.setText(null);
            }
            this.displayBar.validate();
            String path = node.getClassPath();
            if (!path.equals(this.previousClassPath)) {
                boolean success = this.getClassChooser().setPath(path);
                this.searchJarAction.setEnabled(success);
                this.searchJarForModelAction.setEnabled(success);
            }
            this.previousClassPath = node.getClassPath();
            this.jarField.setText(node.classPath);
            this.jarField.setBackground(node.classPath != null && !this.getClassChooser().isLoaded(node.classPath) ? RED : Color.white);
            this.classField.setText(node.launchClassName);
            this.classField.setBackground(node.getLaunchClass() == null && node.launchClassName != null ? RED : Color.white);
            n = (Integer)this.argSpinner.getValue();
            if (node.args.length > n) {
                this.argField.setText(node.args[n]);
            } else {
                this.argField.setText("");
            }
            boolean xmlArg = this.argField.getText().endsWith(".xml");
            Resource res = null;
            if (xmlArg) {
                res = ResourceLoader.getResource(this.argField.getText());
                this.argField.setBackground(res == null ? RED : Color.white);
            } else {
                this.argField.setBackground(Color.white);
            }
            LaunchNode parent = (LaunchNode)node.getParent();
            this.singletonCheckBox.setEnabled(parent == null || !parent.isSingleton());
            this.singletonCheckBox.setSelected(node.isSingleton());
            this.singleVMCheckBox.setSelected(node.isSingleVM());
            if (node.isSingleVM()) {
                this.showLogCheckBox.setEnabled(parent == null || !parent.isShowLog());
                this.showLogCheckBox.setSelected(node.isShowLog());
                this.clearLogCheckBox.setEnabled(parent == null || !parent.isClearLog());
                this.clearLogCheckBox.setSelected(node.isClearLog());
                this.singleAppCheckBox.setEnabled(true);
                this.singleAppCheckBox.setSelected(node.isSingleApp());
            } else {
                this.showLogCheckBox.setEnabled(false);
                this.showLogCheckBox.setSelected(false);
                this.clearLogCheckBox.setEnabled(false);
                this.clearLogCheckBox.setSelected(false);
                this.singleAppCheckBox.setEnabled(false);
                this.singleAppCheckBox.setSelected(false);
            }
            this.levelDropDown.setVisible(node.isShowLog());
            this.clearLogCheckBox.setVisible(node.isShowLog());
            if (this.levelDropDown.isVisible()) {
                boolean useAll = parent == null || !parent.isShowLog();
                this.levelDropDown.setEnabled(false);
                this.levelDropDown.removeAllItems();
                int i2 = 0;
                while (i2 < OSPLog.levels.length) {
                    if (useAll || parent != null && OSPLog.levels[i2].intValue() <= parent.getLogLevel().intValue()) {
                        this.levelDropDown.addItem(OSPLog.levels[i2]);
                    }
                    ++i2;
                }
                this.levelDropDown.setSelectedItem(node.getLogLevel());
                this.levelDropDown.setEnabled(true);
            }
            this.authorField.setText(node.getAuthor());
            this.authorField.setBackground(Color.white);
            this.keywordField.setText(node.keywords);
            this.keywordField.setBackground(Color.white);
            this.levelField.setText(node.level);
            this.levelField.setBackground(Color.white);
            this.languagesField.setText(node.languages);
            this.languagesField.setBackground(Color.white);
            this.commentPane.setText(node.comment);
            this.commentPane.setBackground(Color.white);
            boolean hasPW = this.password != null && !this.password.equals("");
            this.onLoadCheckBox.setEnabled(hasPW);
            this.onLoadCheckBox.setSelected(hasPW && this.pwRequiredToLoad);
            this.encryptCheckBox.setSelected(this.password != null);
            this.passwordEditor.setEnabled(this.encryptCheckBox.isSelected());
            this.passwordLabel.setEnabled(this.encryptCheckBox.isSelected());
            this.passwordEditor.setText(this.password);
            this.passwordEditor.setBackground(Color.white);
        }
        this.fileMenu.removeAll();
        this.fileMenu.add(this.newItem);
        if (this.undoManager.canReload()) {
            this.fileMenu.add(this.backItem);
        }
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.openItem);
        if (this.openFromJarMenu != null) {
            this.fileMenu.add(this.openFromJarMenu);
        }
        if ((tab = this.getSelectedTab()) != null && !tab.getRootNode().enabled) {
            this.fileMenu.add(this.passwordItem);
        }
        boolean isZipped = this.jarBasePath != null && !this.jarBasePath.equals("");
        this.saveAllItem.setEnabled(!isZipped && this.isTabSetWritable());
        if (tab != null) {
            if (rootEnabled) {
                this.fileMenu.add(this.importItem);
            }
            this.fileMenu.addSeparator();
            if (rootEnabled) {
                this.fileMenu.add(this.closeTabItem);
            }
            this.fileMenu.add(this.closeAllItem);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.previewItem);
            if (rootEnabled) {
                this.fileMenu.addSeparator();
                this.fileMenu.add(this.saveAllItem);
                this.fileMenu.add(this.saveSetAsItem);
                if (OSPRuntime.getLaunchJarName() != null) {
                    this.fileMenu.addSeparator();
                    this.fileMenu.add(this.saveJarItem);
                }
            }
            JMenu printMenu = new JMenu(DisplayRes.getString("DrawingFrame.Print_menu_title"));
            JMenuItem printFrameItem = new JMenuItem(DisplayRes.getString("DrawingFrame.PrintFrame_menu_item"));
            JMenuItem saveFrameAsEPSItem = new JMenuItem(DisplayRes.getString("DrawingFrame.SaveFrameAsEPS_menu_item"));
            printMenu.add(printFrameItem);
            printMenu.add(saveFrameAsEPSItem);
            this.fileMenu.add(printMenu);
            printFrameItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrintUtils.printComponent(LaunchBuilder.this.frame);
                }
            });
            saveFrameAsEPSItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        PrintUtils.saveComponentAsEPS(LaunchBuilder.this.frame);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            this.frame.getContentPane().add((Component)this.toolbar, "North");
            tab.dataPanel.add((Component)this.editorTabs, "Center");
            if (this.getRootNode().getChildCount() == 0) {
                this.getRootNode().hiddenWhenRoot = false;
                this.hideRootCheckBox.setEnabled(false);
            } else {
                this.hideRootCheckBox.setEnabled(node == null || !node.isButtonView());
            }
            if (!rootEnabled) {
                this.hideRootCheckBox.setEnabled(false);
            }
            boolean rootVisible = !this.getRootNode().hiddenWhenRoot;
            this.hideRootCheckBox.setSelected(!rootVisible);
            tab.tree.setRootVisible(rootVisible);
            if (this.getSelectedNode() == null && !rootVisible) {
                tab.setTreeSelectionPath((LaunchNode)this.getRootNode().getChildAt(0));
            }
            this.buttonViewCheckBox.setSelected(node != null && node.isButtonView());
            this.buttonViewCheckBox.setEnabled(rootVisible && rootEnabled);
            this.editorEnabledCheckBox.setSelected(this.editorEnabled);
            this.editorTabs.setEnabled(rootEnabled);
            this.nameField.setEnabled(rootEnabled);
            this.tooltipField.setEnabled(rootEnabled);
            this.descriptionPane.setEnabled(rootEnabled);
            this.pathField.setEnabled(rootEnabled);
            this.titleField.setEnabled(rootEnabled);
            this.displaySpinner.setEnabled(rootEnabled);
            this.openDisplayChooserButton.setEnabled(rootEnabled);
            this.titleLabel.setEnabled(rootEnabled);
            this.nameLabel.setEnabled(rootEnabled);
            this.tooltipLabel.setEnabled(rootEnabled);
            this.displayLabel.setEnabled(rootEnabled);
            this.pathLabel.setEnabled(rootEnabled);
            this.newTabButton.setEnabled(rootEnabled);
            this.addButton.setEnabled(rootEnabled);
            this.cutButton.setEnabled(rootEnabled);
            this.copyButton.setEnabled(rootEnabled);
            this.pasteButton.setEnabled(rootEnabled);
            this.moveUpButton.setEnabled(rootEnabled);
            this.moveDownButton.setEnabled(rootEnabled);
            this.tabTitleField.setEnabled(rootEnabled);
            this.htmlScroller.setEnabled(rootEnabled);
            this.showModelArgsButton.setEnabled(rootEnabled);
            this.displayTitle.setTitleColor(rootEnabled ? enabledColor : disabledColor);
            this.descriptionTitle.setTitleColor(rootEnabled ? enabledColor : disabledColor);
        } else {
            this.frame.getContentPane().remove(this.toolbar);
        }
        if (this.exitItem != null) {
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.exitItem);
        }
        int k = 0;
        while (k < this.tabbedPane.getTabCount()) {
            root = this.getTab(k).getRootNode();
            if (root.getFileName() != null) {
                this.tabbedPane.setIconAt(k, this.getFileIcon(root));
                this.tabbedPane.setToolTipTextAt(k, String.valueOf(LaunchRes.getString("ToolTip.FileName")) + " \"" + root.getFileName() + "\"");
            } else {
                this.tabbedPane.setIconAt(k, null);
                this.tabbedPane.setToolTipTextAt(k, null);
            }
            ++k;
        }
    }

    @Override
    protected void createGUI(boolean splash) {
        wInit = 600;
        hInit = 540;
        this.labels = new ArrayList();
        super.createGUI(splash);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                OSPRuntime.setAuthorMode(true);
            }

            @Override
            public void windowActivated(WindowEvent e) {
                OSPRuntime.setAuthorMode(true);
            }

            @Override
            public void windowOpened(WindowEvent e) {
                if (LaunchBuilder.this.getSelectedNode() != null) {
                    LaunchBuilder.this.htmlPane.setContentType("text");
                    LaunchBuilder.this.htmlPane.setText(null);
                }
                LaunchBuilder.this.refreshGUI();
            }
        });
        this.tabbedPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                LaunchBuilder.this.refreshGUI();
            }
        });
        whiteFileIcon = LaunchBuilder.loadIcon("whitefile.gif");
        ghostFileIcon = LaunchBuilder.loadIcon("ghostfile.gif");
        redFileIcon = LaunchBuilder.loadIcon("redfile.gif");
        yellowFileIcon = LaunchBuilder.loadIcon("yellowfile.gif");
        redFolderIcon = LaunchBuilder.loadIcon("redfolder.gif");
        greenFolderIcon = LaunchBuilder.loadIcon("greenfolder.gif");
        yellowFolderIcon = LaunchBuilder.loadIcon("yellowfolder.gif");
        this.createActions();
        this.titleField = new JTextField();
        this.titleField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    String text = LaunchBuilder.this.titleField.getText();
                    if (text.equals("")) {
                        text = null;
                    }
                    if (text != LaunchBuilder.this.title) {
                        LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                    }
                    LaunchBuilder.this.title = text;
                    LaunchBuilder.this.refreshGUI();
                } else {
                    LaunchBuilder.this.titleField.setBackground(Color.yellow);
                }
            }
        });
        this.titleField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String text = LaunchBuilder.this.titleField.getText();
                if (text.equals("")) {
                    text = null;
                }
                if (text != LaunchBuilder.this.title) {
                    LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                }
                LaunchBuilder.this.title = text;
                LaunchBuilder.this.refreshGUI();
            }
        });
        this.nameField = new JTextField();
        this.nameField.addKeyListener(this.keyListener);
        this.nameField.addFocusListener(this.focusListener);
        this.tooltipField = new JTextField();
        this.tooltipField.addKeyListener(this.keyListener);
        this.tooltipField.addFocusListener(this.focusListener);
        this.displayTitle = BorderFactory.createTitledBorder(LaunchRes.getString("Label.DisplayPane"));
        this.classField = new JTextField();
        this.classField.addKeyListener(this.keyListener);
        this.classField.addFocusListener(this.focusListener);
        this.argField = new JTextField();
        this.argField.addKeyListener(this.keyListener);
        this.argField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                XMLControlElement control;
                if (OSPRuntime.isPopupTrigger(e) && (control = new XMLControlElement()).read(LaunchBuilder.this.argField.getText()) != null) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem item = new JMenuItem(LaunchRes.getString("MenuItem.EncryptionTool"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            EncryptionTool tool = EncryptionTool.getTool();
                            tool.open((this).LaunchBuilder.this.argField.getText());
                            tool.setVisible(true);
                        }
                    });
                    popup.add(item);
                    popup.show(LaunchBuilder.this.argField, e.getX(), e.getY() + 8);
                }
            }
        });
        this.argField.addFocusListener(this.focusListener);
        this.modelArgField = new JTextField();
        this.modelArgField.addKeyListener(this.keyListener);
        this.modelArgField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                XMLControlElement control;
                if (OSPRuntime.isPopupTrigger(e) && (control = new XMLControlElement()).read(LaunchBuilder.this.modelArgField.getText()) != null) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem item = new JMenuItem(LaunchRes.getString("MenuItem.EncryptionTool"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            EncryptionTool tool = EncryptionTool.getTool();
                            tool.open((this).LaunchBuilder.this.modelArgField.getText());
                            tool.setVisible(true);
                        }
                    });
                    popup.add(item);
                    popup.show(LaunchBuilder.this.modelArgField, e.getX(), e.getY() + 8);
                }
            }
        });
        this.modelArgField.addFocusListener(this.focusListener);
        this.jarField = new JTextField();
        this.jarField.addKeyListener(this.keyListener);
        this.jarField.addFocusListener(this.focusListener);
        this.pathField = new JTextField();
        this.pathField.addKeyListener(this.keyListener);
        this.pathField.addFocusListener(this.focusListener);
        this.tabTitleField = new JTextField();
        this.tabTitleField.addKeyListener(this.keyListener);
        this.tabTitleField.addFocusListener(this.focusListener);
        this.keywordField = new JTextField();
        this.keywordField.addKeyListener(this.keyListener);
        this.keywordField.addFocusListener(this.focusListener);
        this.authorField = new JTextField();
        this.authorField.addKeyListener(this.keyListener);
        this.authorField.addFocusListener(this.focusListener);
        this.levelField = new JTextField();
        this.levelField.addKeyListener(this.keyListener);
        this.levelField.addFocusListener(this.focusListener);
        this.languagesField = new JTextField();
        this.languagesField.addKeyListener(this.keyListener);
        this.languagesField.addFocusListener(this.focusListener);
        this.commentPane = GUIUtils.newJTextPane();
        this.commentPane.addKeyListener(this.keyListener);
        this.commentPane.addFocusListener(this.focusListener);
        this.commentScroller = new JScrollPane(this.commentPane);
        this.commentTitle = BorderFactory.createTitledBorder(LaunchRes.getString("Label.Comments"));
        this.commentScroller.setBorder(this.commentTitle);
        this.descriptionPane = new JTextPane();
        this.descriptionPane.addKeyListener(this.keyListener);
        this.descriptionPane.addFocusListener(this.focusListener);
        this.descriptionScroller = new JScrollPane(this.descriptionPane);
        this.descriptionTitle = BorderFactory.createTitledBorder(LaunchRes.getString("Label.Description"));
        this.descriptionScroller.setBorder(this.descriptionTitle);
        this.displaySplitPane = new JSplitPane(0){

            @Override
            public void setDividerLocation(int loc) {
                super.setDividerLocation(loc);
                double divider = this.getDividerLocation();
                this.setName("" + (divider /= (double)(this.getHeight() - this.getDividerSize())));
            }

            @Override
            public void setTopComponent(Component comp) {
                if (comp == this.getTopComponent()) {
                    return;
                }
                int prev = this.getLastDividerLocation();
                String divider = this.getName();
                super.setTopComponent(comp);
                if (divider != null) {
                    double loc = Double.parseDouble(divider);
                    loc = Math.max(0.0, loc);
                    loc = Math.min(1.0, loc);
                    this.setDividerLocation(loc);
                    this.setLastDividerLocation(prev);
                    SwingUtilities.invokeLater(() -> {
                        JViewport view = LaunchBuilder.this.descriptionScroller.getViewport();
                        view.setViewPosition(new Point(0, 0));
                    });
                }
            }
        };
        this.displaySplitPane.setBottomComponent(this.descriptionScroller);
        this.displaySplitPane.setOneTouchExpandable(true);
        this.displaySplitPane.setResizeWeight(1.0);
        this.htmlPane = GUIUtils.newJTextPane();
        this.htmlPane.setEditable(false);
        this.htmlScroller = new JScrollPane(this.htmlPane);
        this.htmlScroller.setBorder(this.displayTitle);
        this.displaySplitPane.setTopComponent(this.htmlScroller);
        this.hiddenCheckBox = new JCheckBox();
        this.hiddenCheckBox.addActionListener(this.changeAction);
        this.hiddenCheckBox.setContentAreaFilled(false);
        this.hiddenCheckBox.setAlignmentX(0.0f);
        this.buttonViewCheckBox = new JCheckBox();
        this.buttonViewCheckBox.addActionListener(this.changeAction);
        this.buttonViewCheckBox.setContentAreaFilled(false);
        this.buttonViewCheckBox.setAlignmentX(0.0f);
        JPanel displayPanel = new JPanel(new BorderLayout());
        JToolBar nameBar = new JToolBar();
        nameBar.setFloatable(false);
        this.nameLabel = new JLabel();
        this.labels.add(this.nameLabel);
        nameBar.add(this.nameLabel);
        nameBar.add(this.nameField);
        nameBar.add(this.hiddenCheckBox);
        displayPanel.add((Component)nameBar, "North");
        JPanel tooltipPanel = new JPanel(new BorderLayout());
        displayPanel.add((Component)tooltipPanel, "Center");
        JToolBar tooltipBar = new JToolBar();
        tooltipBar.setFloatable(false);
        this.tooltipLabel = new JLabel();
        tooltipBar.add(this.tooltipLabel);
        tooltipBar.add(this.tooltipField);
        tooltipPanel.add((Component)tooltipBar, "North");
        this.urlPanel = new JPanel(new BorderLayout());
        tooltipPanel.add((Component)this.urlPanel, "Center");
        this.displayBar = new JToolBar();
        this.displayBar.setFloatable(false);
        this.displayLabel = new JLabel();
        this.pathLabel = new JLabel();
        this.pathLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.tabTitleLabel = new JLabel();
        this.tabTitleLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.displaySpinnerModel = new SpinnerNumberModel(0, 0, 1, 1);
        this.displaySpinner = new JSpinner(this.displaySpinnerModel);
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.displaySpinner);
        this.displaySpinner.setEditor(editor);
        this.displaySpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (LaunchBuilder.this.pathField.getBackground() == Color.yellow) {
                    LaunchBuilder.this.refreshSelectedNode();
                } else {
                    LaunchBuilder.this.refreshGUI();
                }
            }
        });
        this.displayBar.add(this.displayLabel);
        this.displayBar.add(this.displaySpinner);
        this.displayBar.add(this.pathLabel);
        this.displayBar.add(this.pathField);
        this.openDisplayChooserButton = new JButton(this.openIcon);
        this.openDisplayChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu openPopup = new JPopupMenu();
                openPopup.add(LaunchBuilder.this.openURLAction);
                openPopup.add(LaunchBuilder.this.openPDFAction);
                openPopup.add(LaunchBuilder.this.searchJarForModelAction);
                openPopup.show(LaunchBuilder.this.openDisplayChooserButton, 0, LaunchBuilder.this.openDisplayChooserButton.getHeight());
            }
        });
        this.displayBar.add(this.openDisplayChooserButton);
        this.modelArgsDialog = new JDialog((Frame)this.frame, true);
        JToolBar modelArgBar = new JToolBar();
        modelArgBar.setFloatable(false);
        modelArgBar.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 10));
        this.modelArgLabel = new JLabel();
        this.modelArgLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
        this.modelArgSpinner = new JSpinner(new SpinnerNumberModel(0, 0, maxArgs - 1, 1));
        editor = new JSpinner.NumberEditor(this.modelArgSpinner);
        this.modelArgSpinner.setEditor(editor);
        this.modelArgSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (LaunchBuilder.this.argField.getBackground() == Color.yellow) {
                    LaunchBuilder.this.refreshSelectedNode();
                } else {
                    LaunchBuilder.this.refreshGUI();
                }
            }
        });
        modelArgBar.add(this.modelArgLabel);
        modelArgBar.add(this.modelArgSpinner);
        modelArgBar.add(this.modelArgField);
        modelArgBar.add(this.openModelArgAction);
        this.modelArgCloseButton = new JButton(LaunchRes.getString("Dialog.Button.Close"));
        this.modelArgCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchBuilder.this.modelArgsDialog.setVisible(false);
            }
        });
        this.modelArgClearButton = new JButton(LaunchRes.getString("Dialog.Button.Clear"));
        this.modelArgClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int n = (Integer)LaunchBuilder.this.displaySpinner.getValue();
                LaunchNode node = LaunchBuilder.this.getSelectedNode();
                LaunchNode.DisplayTab tab = node.getDisplayTab(n);
                if (tab != null) {
                    tab.setModelArgs(new String[0]);
                    LaunchBuilder.this.refreshGUI();
                }
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.modelArgClearButton);
        buttonPanel.add(this.modelArgCloseButton);
        this.modelArgsDialog.add((Component)modelArgBar, "Center");
        this.modelArgsDialog.add((Component)buttonPanel, "South");
        this.modelArgsDialog.pack();
        Dimension dim = this.modelArgsDialog.getSize();
        int w = Math.max(dim.width, 240);
        this.modelArgsDialog.setSize(w, dim.height);
        this.showModelArgsButton = new JButton();
        this.showModelArgsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Point p0 = new Frame().getLocation();
                if (LaunchBuilder.this.modelArgsDialog.getLocation().x == p0.x) {
                    LaunchBuilder.this.modelArgsDialog.setLocationRelativeTo(LaunchBuilder.this.showModelArgsButton);
                }
                LaunchBuilder.this.modelArgsDialog.setVisible(true);
            }
        });
        this.displayBar.add(this.tabTitleLabel);
        this.displayBar.add(this.tabTitleField);
        this.urlPanel.add((Component)this.displayBar, "North");
        this.urlPanel.add((Component)this.displaySplitPane, "Center");
        JPanel launchPanel = new JPanel(new BorderLayout());
        JToolBar jarBar = new JToolBar();
        jarBar.setFloatable(false);
        this.jarLabel = new JLabel();
        this.labels.add(this.jarLabel);
        jarBar.add(this.jarLabel);
        jarBar.add(this.jarField);
        jarBar.add(this.openJarAction);
        launchPanel.add((Component)jarBar, "North");
        JPanel classPanel = new JPanel(new BorderLayout());
        launchPanel.add((Component)classPanel, "Center");
        JToolBar classBar = new JToolBar();
        classBar.setFloatable(false);
        this.classLabel = new JLabel();
        this.labels.add(this.classLabel);
        classBar.add(this.classLabel);
        classBar.add(this.classField);
        classBar.add(this.searchJarAction);
        classPanel.add((Component)classBar, "North");
        JPanel argPanel = new JPanel(new BorderLayout());
        classPanel.add((Component)argPanel, "Center");
        JToolBar argBar = new JToolBar();
        argBar.setFloatable(false);
        this.argLabel = new JLabel();
        this.labels.add(this.argLabel);
        argBar.add(this.argLabel);
        this.argSpinner = new JSpinner(new SpinnerNumberModel(0, 0, maxArgs - 1, 1));
        editor = new JSpinner.NumberEditor(this.argSpinner);
        this.argSpinner.setEditor(editor);
        this.argSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (LaunchBuilder.this.argField.getBackground() == Color.yellow) {
                    LaunchBuilder.this.refreshSelectedNode();
                } else {
                    LaunchBuilder.this.refreshGUI();
                }
            }
        });
        argBar.add(this.argSpinner);
        argBar.add(this.argField);
        argBar.add(this.openArgAction);
        argPanel.add((Component)argBar, "North");
        JPanel optionsPanel = new JPanel(new BorderLayout());
        argPanel.add((Component)optionsPanel, "Center");
        JToolBar optionsBar = new JToolBar();
        optionsBar.setFloatable(false);
        this.singleVMCheckBox = new JCheckBox();
        this.singleVMCheckBox.addActionListener(this.changeAction);
        this.singleVMCheckBox.setContentAreaFilled(false);
        this.singleVMCheckBox.setAlignmentX(0.0f);
        this.showLogCheckBox = new JCheckBox();
        this.showLogCheckBox.addActionListener(this.changeAction);
        this.showLogCheckBox.setContentAreaFilled(false);
        this.showLogCheckBox.setAlignmentX(0.0f);
        this.clearLogCheckBox = new JCheckBox();
        this.clearLogCheckBox.addActionListener(this.changeAction);
        this.clearLogCheckBox.setContentAreaFilled(false);
        this.clearLogCheckBox.setAlignmentX(0.0f);
        this.singletonCheckBox = new JCheckBox();
        this.singletonCheckBox.addActionListener(this.changeAction);
        this.singletonCheckBox.setContentAreaFilled(false);
        this.singletonCheckBox.setAlignmentX(0.0f);
        this.singleAppCheckBox = new JCheckBox();
        this.singleAppCheckBox.addActionListener(this.changeAction);
        this.singleAppCheckBox.setContentAreaFilled(false);
        this.singleAppCheckBox.setAlignmentX(0.0f);
        this.levelDropDown = new JComboBox<Level>(OSPLog.levels);
        this.levelDropDown.setMaximumSize(this.levelDropDown.getMinimumSize());
        this.levelDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchNode node;
                if (LaunchBuilder.this.levelDropDown.isEnabled() && (node = LaunchBuilder.this.getSelectedNode()) != null) {
                    node.setLogLevel((Level)LaunchBuilder.this.levelDropDown.getSelectedItem());
                }
            }
        });
        Box checkBoxPanel = Box.createVerticalBox();
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setAlignmentX(0.0f);
        bar.add(this.singletonCheckBox);
        bar.add(Box.createHorizontalGlue());
        checkBoxPanel.add(bar);
        bar = new JToolBar();
        bar.setFloatable(false);
        bar.setAlignmentX(0.0f);
        bar.add(this.singleVMCheckBox);
        bar.add(Box.createHorizontalGlue());
        checkBoxPanel.add(bar);
        bar = new JToolBar();
        bar.setFloatable(false);
        bar.setAlignmentX(0.0f);
        bar.add(this.singleAppCheckBox);
        bar.add(Box.createHorizontalGlue());
        checkBoxPanel.add(bar);
        bar = new JToolBar();
        bar.setFloatable(false);
        bar.add(this.showLogCheckBox);
        bar.add(Box.createHorizontalStrut(4));
        bar.add(this.levelDropDown);
        bar.add(Box.createHorizontalStrut(4));
        bar.add(this.clearLogCheckBox);
        bar.add(Box.createHorizontalGlue());
        bar.setAlignmentX(0.0f);
        checkBoxPanel.add(bar);
        this.optionsTitle = BorderFactory.createTitledBorder(LaunchRes.getString("Label.Options"));
        Border recess = BorderFactory.createLoweredBevelBorder();
        optionsBar.setBorder(BorderFactory.createCompoundBorder(recess, this.optionsTitle));
        optionsBar.add(checkBoxPanel);
        optionsPanel.add((Component)optionsBar, "North");
        JPanel authorPanel = new JPanel(new BorderLayout());
        JToolBar authorBar = new JToolBar();
        authorPanel.add((Component)authorBar, "North");
        authorBar.setFloatable(false);
        this.authorLabel = new JLabel();
        this.labels.add(this.authorLabel);
        authorBar.add(this.authorLabel);
        authorBar.add(this.authorField);
        JPanel keywordPanel = new JPanel(new BorderLayout());
        authorPanel.add((Component)keywordPanel, "Center");
        JToolBar keywordBar = new JToolBar();
        keywordPanel.add((Component)keywordBar, "North");
        keywordBar.setFloatable(false);
        this.keywordLabel = new JLabel();
        this.labels.add(this.keywordLabel);
        keywordBar.add(this.keywordLabel);
        keywordBar.add(this.keywordField);
        JPanel levelPanel = new JPanel(new BorderLayout());
        keywordPanel.add((Component)levelPanel, "Center");
        JToolBar levelBar = new JToolBar();
        levelPanel.add((Component)levelBar, "North");
        levelBar.setFloatable(false);
        this.levelLabel = new JLabel();
        this.labels.add(this.levelLabel);
        levelBar.add(this.levelLabel);
        levelBar.add(this.levelField);
        JPanel languagesPanel = new JPanel(new BorderLayout());
        levelPanel.add((Component)languagesPanel, "Center");
        JToolBar languagesBar = new JToolBar();
        languagesPanel.add((Component)languagesBar, "North");
        languagesBar.setFloatable(false);
        this.languagesLabel = new JLabel();
        this.labels.add(this.languagesLabel);
        languagesBar.add(this.languagesLabel);
        languagesBar.add(this.languagesField);
        JPanel securityPanel = new JPanel(new BorderLayout());
        languagesPanel.add((Component)securityPanel, "Center");
        JToolBar securityBar = new JToolBar();
        securityBar.setFloatable(false);
        securityPanel.add((Component)securityBar, "North");
        this.securityTitle = BorderFactory.createTitledBorder(LaunchRes.getString("Label.Security"));
        securityBar.setBorder(BorderFactory.createCompoundBorder(recess, this.securityTitle));
        Box securityBox = Box.createVerticalBox();
        securityBar.add(securityBox);
        bar = new JToolBar();
        bar.setFloatable(false);
        bar.setAlignmentX(0.0f);
        this.editorEnabledCheckBox = new JCheckBox();
        this.editorEnabledCheckBox.addActionListener(this.changeAction);
        this.editorEnabledCheckBox.setContentAreaFilled(false);
        this.editorEnabledCheckBox.setAlignmentX(0.0f);
        bar.add(this.editorEnabledCheckBox);
        bar.add(Box.createHorizontalGlue());
        securityBox.add(bar);
        bar = new JToolBar();
        bar.setFloatable(false);
        bar.setAlignmentX(0.0f);
        this.encryptCheckBox = new JCheckBox();
        this.encryptCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LaunchBuilder.this.encryptCheckBox.isSelected() && LaunchBuilder.this.password == null) {
                    LaunchBuilder.this.password = "";
                } else if (!LaunchBuilder.this.encryptCheckBox.isSelected()) {
                    LaunchBuilder.this.password = null;
                }
                LaunchBuilder.log("Log.Message.ChangeEncrypted");
                if (LaunchBuilder.this.tabSetName != null) {
                    LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                }
                LaunchBuilder.this.refreshGUI();
            }
        });
        this.encryptCheckBox.setContentAreaFilled(false);
        bar.add(this.encryptCheckBox);
        bar.add(Box.createHorizontalGlue());
        securityBox.add(bar);
        bar = new JToolBar();
        bar.setFloatable(false);
        bar.setAlignmentX(0.0f);
        this.passwordLabel = new JLabel();
        this.passwordLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        bar.add(this.passwordLabel);
        this.passwordEditor = new JTextField();
        this.passwordEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    String text = LaunchBuilder.this.passwordEditor.getText();
                    if (!(!text.equals("") || LaunchBuilder.this.encryptCheckBox.isSelected() && LaunchBuilder.this.encryptCheckBox.isEnabled())) {
                        text = null;
                    }
                    if (text != LaunchBuilder.this.password) {
                        LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                    }
                    LaunchBuilder.this.password = text;
                    LaunchBuilder.this.refreshGUI();
                } else {
                    LaunchBuilder.this.passwordEditor.setBackground(Color.yellow);
                }
            }
        });
        bar.add(this.passwordEditor);
        bar.add(Box.createHorizontalGlue());
        this.onLoadCheckBox = new JCheckBox();
        this.onLoadCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchBuilder.this.pwRequiredToLoad = LaunchBuilder.this.onLoadCheckBox.isSelected();
                LaunchBuilder.log("Log.Message.ChangePWRequirement");
                if (LaunchBuilder.this.tabSetName != null) {
                    LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                }
                LaunchBuilder.this.refreshGUI();
            }
        });
        this.onLoadCheckBox.setContentAreaFilled(false);
        bar.add(this.onLoadCheckBox);
        securityBox.add(bar);
        securityPanel.add((Component)this.commentScroller, "Center");
        this.editorTabs = new JTabbedPane(1);
        this.editorTabs.addTab(LaunchRes.getString("Tab.Display"), displayPanel);
        this.editorTabs.addTab(LaunchRes.getString("Tab.Launch"), launchPanel);
        this.editorTabs.addTab(LaunchRes.getString("Tab.Author"), authorPanel);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.toolbar.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.frame.getContentPane().add((Component)this.toolbar, "North");
        this.newTabButton = new JButton(this.newTabAction);
        this.toolbar.add(this.newTabButton);
        this.addButton = new JButton(this.addAction);
        this.toolbar.add(this.addButton);
        this.cutButton = new JButton(this.cutAction);
        this.toolbar.add(this.cutButton);
        this.copyButton = new JButton(this.copyAction);
        this.toolbar.add(this.copyButton);
        this.pasteButton = new JButton(this.pasteAction);
        this.toolbar.add(this.pasteButton);
        this.moveUpButton = new JButton(this.moveUpAction);
        this.toolbar.add(this.moveUpButton);
        this.moveDownButton = new JButton(this.moveDownAction);
        this.toolbar.add(this.moveDownButton);
        this.titleLabel = new JLabel(LaunchRes.getString("Label.Title"));
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        this.toolbar.add(this.titleLabel);
        this.toolbar.add(this.titleField);
        this.toolbar.add(this.buttonViewCheckBox);
        this.hideRootCheckBox = new JCheckBox();
        this.hideRootCheckBox.addActionListener(this.changeAction);
        this.hideRootCheckBox.setContentAreaFilled(false);
        this.toolbar.add(this.hideRootCheckBox);
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.newItem = new JMenuItem(this.newTabSetAction);
        this.newItem.setAccelerator(KeyStroke.getKeyStroke(78, mask));
        this.previewItem = new JMenuItem();
        this.previewItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String base = tabSetBasePath;
                LaunchBuilder.this.previewing = true;
                Launcher.LaunchSet set = new Launcher.LaunchSet(LaunchBuilder.this, LaunchBuilder.this, LaunchBuilder.this.tabSetName);
                XMLControlElement control = new XMLControlElement(set);
                control.setValue("filename", LaunchBuilder.this.tabSetName);
                Launcher launcher2 = new Launcher(control.toXML());
                LaunchNode node = LaunchBuilder.this.getSelectedNode();
                if (node != null) {
                    launcher2.setSelectedNode(node.getPathString());
                }
                Point p = LaunchBuilder.this.frame.getLocation();
                launcher2.frame.setLocation(p.x + 24, p.y + 24);
                launcher2.frame.setVisible(true);
                launcher2.frame.setDefaultCloseOperation(2);
                tabSetBasePath = base;
                LaunchBuilder.this.previewing = false;
                launcher2.password = LaunchBuilder.this.password;
                launcher2.previewing = true;
                launcher2.spawner = LaunchBuilder.this;
                launcher2.refreshGUI();
            }
        });
        this.importItem = new JMenuItem(this.importAction);
        this.saveJarItem = new JMenuItem(this.saveJarAction);
        this.saveNodeItem = new JMenuItem(this.saveAction);
        this.saveNodeAsItem = new JMenuItem(this.saveAsAction);
        this.saveAllItem = new JMenuItem(this.saveAllAction);
        this.openTabItem = new JMenuItem(this.openTabAction);
        this.saveAllItem.setAccelerator(KeyStroke.getKeyStroke(83, mask));
        this.saveSetAsItem = new JMenuItem(this.saveSetAsAction);
        this.toolsMenu = new JMenu();
        this.frame.getJMenuBar().add((Component)this.toolsMenu, 2);
        this.encryptionToolItem = new JMenuItem();
        this.toolsMenu.add(this.encryptionToolItem);
        this.encryptionToolItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EncryptionTool.getTool().setVisible(true);
            }
        });
        this.tabbedPane.removeMouseListener(this.tabListener);
        this.tabListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (LaunchBuilder.this.contentPane.getTopLevelAncestor() != LaunchBuilder.this.frame) {
                    return;
                }
                if (OSPRuntime.isPopupTrigger(e)) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem item = new JMenuItem(LaunchRes.getString("MenuItem.Close"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LaunchBuilder.this.removeSelectedTab();
                        }
                    });
                    popup.add(item);
                    popup.addSeparator();
                    item = new JMenuItem(LaunchRes.getString("Menu.File.SaveAs"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LaunchNode node = LaunchBuilder.this.getSelectedTab().getRootNode();
                            if (LaunchBuilder.this.saveAs(node) != null) {
                                int i = (this).LaunchBuilder.this.tabbedPane.getSelectedIndex();
                                (this).LaunchBuilder.this.tabbedPane.setTitleAt(i, node.toString());
                            }
                            LaunchBuilder.this.refreshGUI();
                        }
                    });
                    popup.add(item);
                    final int i = LaunchBuilder.this.tabbedPane.getSelectedIndex();
                    if (i > 0 || i < LaunchBuilder.this.tabbedPane.getTabCount() - 1) {
                        popup.addSeparator();
                    }
                    if (i < LaunchBuilder.this.tabbedPane.getTabCount() - 1) {
                        item = new JMenuItem(LaunchRes.getString("Popup.MenuItem.MoveUp"));
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                LaunchBuilder.this.move(i + 1);
                            }
                        });
                        popup.add(item);
                    }
                    if (i > 0) {
                        item = new JMenuItem(LaunchRes.getString("Popup.MenuItem.MoveDown"));
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                LaunchBuilder.this.move(i - 1);
                            }
                        });
                        popup.add(item);
                    }
                    popup.show(LaunchBuilder.this.tabbedPane, e.getX(), e.getY() + 8);
                }
            }
        };
        this.tabbedPane.addMouseListener(this.tabListener);
        this.frame.pack();
        this.displaySplitPane.setDividerLocation(0.7);
    }

    protected void move(int newPos) {
        LaunchPanel tab = this.getSelectedTab();
        LaunchNode root = tab.getRootNode();
        super.removeSelectedTab();
        this.tabbedPane.insertTab(LaunchBuilder.getDisplayName(root.getFileName()), null, tab, null, newPos);
        this.tabbedPane.setSelectedComponent(tab);
        this.tabs.add(newPos, tab);
    }

    @Override
    public void setFontLevel(int level) {
        int prev = this.displaySplitPane.getLastDividerLocation();
        String divider = this.displaySplitPane.getName();
        FontSizer.setFonts(this.displayTitle, level);
        FontSizer.setFonts(this.commentTitle, level);
        FontSizer.setFonts(this.descriptionTitle, level);
        FontSizer.setFonts(this.optionsTitle, level);
        FontSizer.setFonts(this.securityTitle, level);
        super.setFontLevel(level);
        if (divider != null) {
            SwingUtilities.invokeLater(() -> {
                double loc = Double.parseDouble(divider);
                loc = Math.max(0.0, loc);
                loc = Math.min(1.0, loc);
                this.displaySplitPane.setDividerLocation(loc);
                this.displaySplitPane.setLastDividerLocation(prev);
            });
        }
    }

    protected void createActions() {
        this.openIcon = LaunchBuilder.loadIcon("open.gif");
        this.openJarAction = new AbstractAction(null, this.openIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = LaunchBuilder.getJARChooser();
                int result = chooser.showOpenDialog(null);
                if (result == 0) {
                    File file = chooser.getSelectedFile();
                    String newJar = XML.getRelativePath(file.getPath());
                    String jars = LaunchBuilder.this.jarField.getText();
                    if (jars.indexOf(newJar) > -1) {
                        newJar = null;
                    }
                    if (!jars.equals("")) {
                        jars = String.valueOf(jars) + ";";
                    }
                    if (newJar != null) {
                        LaunchBuilder.this.jarField.setText(String.valueOf(jars) + newJar);
                    }
                    OSPRuntime.chooserDir = XML.getDirectoryPath(file.getPath());
                    LaunchBuilder.this.searchJarAction.setEnabled(true);
                    LaunchBuilder.this.refreshSelectedNode();
                }
            }
        };
        this.searchJarAction = new AbstractAction(null, this.openIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchNode node = LaunchBuilder.this.getSelectedNode();
                if (node != null && LaunchBuilder.this.getClassChooser().chooseClassFor(node)) {
                    if (node.getOwner() != null) {
                        LaunchBuilder.this.changedFiles.add(node.getOwner().getFileName());
                    } else {
                        LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                    }
                    LaunchBuilder.this.refreshClones(node);
                    LaunchBuilder.this.refreshGUI();
                }
            }
        };
        this.searchJarAction.setEnabled(false);
        this.saveJarAction = new AbstractAction(LaunchRes.getString("LaunchBuilder.Action.CreateJar.Name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                File base = new File(XML.getDirectoryPath(OSPRuntime.getLaunchJarPath()));
                String jarName = String.valueOf(XML.stripExtension(LaunchBuilder.this.tabSetName)) + ".jar";
                File target = new File(base, jarName);
                final ArrayList<String> source = new ArrayList<String>();
                JarTreeDialog jarChooser = new JarTreeDialog((Frame)LaunchBuilder.this.frame, base);
                source.add(OSPRuntime.getLaunchJarName());
                base.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        if (f.getName().endsWith(".jar") || f.getName().endsWith(".zip") || f.getName().endsWith(".trz") || f.getName().endsWith(".DS_Store") || f.getName().endsWith(".localized") || f.getName().endsWith(".tmp")) {
                            return false;
                        }
                        source.add(f.getName());
                        return true;
                    }
                });
                jarChooser.setSelectionRelativePaths(source.toArray(new String[0]));
                jarChooser.setVisible(true);
                String[] paths = jarChooser.getSelectionRelativePaths();
                if (paths == null) {
                    return;
                }
                source.clear();
                int i = 0;
                while (i < paths.length) {
                    if (paths[i].equals(OSPRuntime.getLaunchJarName())) {
                        source.add(0, paths[i]);
                    } else {
                        source.add(paths[i]);
                    }
                    ++i;
                }
                Manifest manifest = JarTool.createManifest("", "org.opensourcephysics.tools.Launcher");
                JarTool.alwaysOverwrite();
                JarTool.setOwnerFrame(LaunchBuilder.this.frame);
                JarTool.getInstance().create(source, base, target, manifest);
            }
        };
        this.openArgAction = new AbstractAction(null, this.openIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = LaunchBuilder.getFileChooser();
                int result = chooser.showOpenDialog(null);
                if (result == 0) {
                    File file = chooser.getSelectedFile();
                    LaunchBuilder.this.argField.setText(XML.getRelativePath(file.getPath()));
                    OSPRuntime.chooserDir = XML.getDirectoryPath(file.getPath());
                    LaunchBuilder.this.refreshSelectedNode();
                }
            }
        };
        this.openModelArgAction = new AbstractAction(null, this.openIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = LaunchBuilder.getFileChooser();
                int result = chooser.showOpenDialog(null);
                if (result == 0) {
                    File file = chooser.getSelectedFile();
                    LaunchBuilder.this.modelArgField.setText(XML.getRelativePath(file.getPath()));
                    OSPRuntime.chooserDir = XML.getDirectoryPath(file.getPath());
                    LaunchBuilder.this.refreshSelectedNode();
                }
            }
        };
        this.openURLAction = new AbstractAction(LaunchRes.getString("Popup.MenuItem.OpenHTML")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = LaunchBuilder.getHTMLChooser();
                int result = chooser.showOpenDialog(null);
                if (result == 0) {
                    File file = chooser.getSelectedFile();
                    LaunchBuilder.this.pathField.setText(XML.getRelativePath(file.getPath()));
                    OSPRuntime.chooserDir = XML.getDirectoryPath(file.getPath());
                    LaunchBuilder.this.refreshSelectedNode();
                }
            }
        };
        this.openPDFAction = new AbstractAction(LaunchRes.getString("Popup.MenuItem.OpenPDF")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = LaunchBuilder.getPDFChooser();
                int result = chooser.showOpenDialog(null);
                if (result == 0) {
                    File file = chooser.getSelectedFile();
                    LaunchBuilder.this.pathField.setText(XML.getRelativePath(file.getPath()));
                    OSPRuntime.chooserDir = XML.getDirectoryPath(file.getPath());
                    LaunchBuilder.this.refreshSelectedNode();
                }
            }
        };
        this.searchJarForModelAction = new AbstractAction(LaunchRes.getString("Popup.MenuItem.OpenModel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Class<?> type = LaunchBuilder.this.getClassChooser().chooseModel(LaunchBuilder.this.pathField.getText());
                if (type != null) {
                    LaunchBuilder.this.pathField.setText(type.getName());
                    LaunchBuilder.this.refreshSelectedNode();
                }
            }
        };
        this.searchJarForModelAction.setEnabled(false);
        this.openTabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchNode node = LaunchBuilder.this.getSelectedNode();
                String tabName = node.toString();
                int i = 0;
                while (i < LaunchBuilder.this.tabbedPane.getComponentCount()) {
                    if (LaunchBuilder.this.tabbedPane.getTitleAt(i).equals(tabName)) {
                        LaunchBuilder.this.tabbedPane.setSelectedIndex(i);
                        return;
                    }
                    ++i;
                }
                XMLControlElement control = new XMLControlElement(node);
                XMLControlElement cloneControl = new XMLControlElement(control);
                LaunchNode clone = (LaunchNode)cloneControl.loadObject(null);
                clone.setFileName(node.getFileName());
                LaunchBuilder.this.addTab(clone);
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.changeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchBuilder.this.refreshSelectedNode();
            }
        };
        this.newTabSetAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] prevArgs = LaunchBuilder.this.undoManager.getLauncherState();
                if (LaunchBuilder.this.removeAllTabs()) {
                    if (prevArgs != null) {
                        LauncherUndo launcherUndo = LaunchBuilder.this.undoManager;
                        launcherUndo.getClass();
                        LauncherUndo.LoadEdit edit = new LauncherUndo.LoadEdit(launcherUndo, null, prevArgs);
                        LaunchBuilder.this.undoSupport.postEdit(edit);
                    }
                    LaunchNode root = new LaunchNode(LaunchRes.getString("NewTab.Name"));
                    LaunchBuilder.this.addTab(root);
                }
            }
        };
        this.addAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchNode newNode = new LaunchNode(LaunchRes.getString("NewNode.Name"));
                LaunchBuilder.this.addChildToSelectedNode(newNode);
            }
        };
        this.newTabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchNode root = new LaunchNode(LaunchRes.getString("NewTab.Name"));
                LaunchBuilder.this.addTab(root);
            }
        };
        this.cutAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchBuilder.this.copyAction.actionPerformed(null);
                LaunchBuilder.this.removeSelectedNodes();
            }
        };
        this.copyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<LaunchNode> nodes;
                if (LaunchBuilder.this.getSelectedTab() != null && (nodes = LaunchBuilder.this.getSelectedTab().getSelectedNodes()) != null) {
                    OSPRuntime.copy(new XMLControlElement(new NodeSet(nodes)).toXML(), null);
                }
            }
        };
        this.pasteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSPRuntime.paste(dataString -> {
                    if (dataString != null) {
                        XMLControlElement control = new XMLControlElement();
                        control.readXML((String)dataString);
                        if (control.getObjectClass() == NodeSet.class) {
                            NodeSet nodeSet = (NodeSet)control.loadObject(null);
                            for (Object[] next : nodeSet.nodes) {
                                LaunchNode node = (LaunchNode)next[0];
                                if (next.length > 1 && next[1] != null) {
                                    node.setFileName(next[1].toString());
                                }
                                LaunchBuilder.this.addChildToSelectedNode(node);
                            }
                        }
                    }
                });
            }
        };
        this.importAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchBuilder.getXMLChooser().setFileFilter(xmlFileFilter);
                int result = LaunchBuilder.getXMLChooser().showOpenDialog(null);
                if (result == 0) {
                    File file = LaunchBuilder.getXMLChooser().getSelectedFile();
                    String fileName = file.getAbsolutePath();
                    OSPRuntime.chooserDir = XML.getDirectoryPath(file.getPath());
                    XMLControlElement control = new XMLControlElement(file);
                    if (control.failedToRead()) {
                        OSPLog.info(String.valueOf(LaunchRes.getString("Log.Message.InvalidXML")) + " " + fileName);
                        JOptionPane.showMessageDialog(null, String.valueOf(LaunchRes.getString("Dialog.InvalidXML.Message")) + " \"" + XML.getName(fileName) + "\"", LaunchRes.getString("Dialog.InvalidXML.Title"), 2);
                        return;
                    }
                    if (control.getObjectClass() == LaunchNode.class) {
                        LaunchNode child = (LaunchNode)control.loadObject(null);
                        child.setFileName(fileName);
                        LaunchBuilder.this.addChildToSelectedNode(child);
                    } else {
                        OSPLog.info(String.valueOf(LaunchRes.getString("Log.Message.NotLauncherFile")) + " " + fileName);
                        JOptionPane.showMessageDialog(null, String.valueOf(LaunchRes.getString("Dialog.NotLauncherFile.Message")) + " \"" + XML.getName(fileName) + "\"", LaunchRes.getString("Dialog.NotLauncherFile.Title"), 2);
                    }
                }
            }
        };
        this.saveAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchNode node = LaunchBuilder.this.getSelectedNode();
                if (node.getFileName() != null) {
                    LaunchBuilder.this.save(node, node.getFileName());
                    LaunchBuilder.this.refreshGUI();
                }
            }
        };
        this.saveAsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchNode node = LaunchBuilder.this.getSelectedNode();
                LaunchNode parent = (LaunchNode)node.getParent();
                String fileName = LaunchBuilder.this.saveAs(node);
                if (fileName != null) {
                    LaunchBuilder.this.selfContained = false;
                    Enumeration<TreeNode> en = node.pathFromAncestorEnumeration(node.getRoot());
                    while (en.hasMoreElements()) {
                        LaunchNode next = (LaunchNode)en.nextElement();
                        next.setSelfContained(false);
                        next.parentSelfContained = false;
                    }
                    if (parent != null) {
                        if (parent.getOwner() != null) {
                            LaunchBuilder.this.changedFiles.add(parent.getOwner().getFileName());
                        }
                        LaunchBuilder.this.refreshClones(parent);
                    }
                }
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.saveAllAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LaunchBuilder.this.tabSetName.equals(LaunchRes.getString("Tabset.Name.New"))) {
                    LaunchBuilder.this.saveTabSetAs();
                } else {
                    LaunchBuilder.this.saveTabSet();
                }
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.saveSetAsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchBuilder.this.saveTabSetAs();
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.moveUpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<LaunchNode> nodes = LaunchBuilder.this.getSelectedTab().getSelectedNodes();
                if (nodes == null) {
                    return;
                }
                for (LaunchNode node : nodes) {
                    int i;
                    LaunchNode parent = (LaunchNode)node.getParent();
                    if (parent == null || (i = parent.getIndex(node)) <= 0 || nodes.contains(parent.getChildBefore(node))) continue;
                    LaunchBuilder.this.getSelectedTab().treeModel.removeNodeFromParent(node);
                    LaunchBuilder.this.getSelectedTab().treeModel.insertNodeInto(node, parent, i - 1);
                    if (parent.getOwner() != null) {
                        LaunchBuilder.this.changedFiles.add(parent.getOwner().getFileName());
                        continue;
                    }
                    LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                }
                LaunchBuilder.this.getSelectedTab().setTreeSelectionPaths(nodes);
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.moveDownAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<LaunchNode> nodes = LaunchBuilder.this.getSelectedTab().getSelectedNodes();
                if (nodes == null) {
                    return;
                }
                int j = nodes.size() - 1;
                while (j > -1) {
                    int end;
                    int i;
                    LaunchNode node = nodes.get(j);
                    LaunchNode parent = (LaunchNode)node.getParent();
                    if (parent != null && (i = parent.getIndex(node)) < (end = parent.getChildCount()) - 1 && !nodes.contains(parent.getChildAfter(node))) {
                        LaunchBuilder.this.getSelectedTab().treeModel.removeNodeFromParent(node);
                        LaunchBuilder.this.getSelectedTab().treeModel.insertNodeInto(node, parent, i + 1);
                        if (parent.getOwner() != null) {
                            LaunchBuilder.this.changedFiles.add(parent.getOwner().getFileName());
                        } else {
                            LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                        }
                    }
                    --j;
                }
                LaunchBuilder.this.getSelectedTab().setTreeSelectionPaths(nodes);
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                LaunchBuilder.this.refreshSelectedNode();
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                JComponent comp = (JComponent)e.getSource();
                if (e.getKeyCode() == 10 && (comp != LaunchBuilder.this.descriptionPane && comp != LaunchBuilder.this.commentPane || e.isControlDown() || e.isShiftDown())) {
                    LaunchBuilder.this.refreshSelectedNode();
                    LaunchBuilder.this.refreshGUI();
                } else {
                    comp.setBackground(Color.yellow);
                }
            }
        };
    }

    public void removeSelectedNode() {
        LaunchNode node = this.getSelectedNode();
        if (node == null || node.getParent() == null) {
            return;
        }
        LaunchNode parent = (LaunchNode)node.getParent();
        this.getSelectedTab().treeModel.removeNodeFromParent(node);
        this.getSelectedTab().setTreeSelectionPath(parent);
        if (parent.getOwner() != null) {
            this.changedFiles.add(parent.getOwner().getFileName());
        } else {
            this.changedFiles.add(this.tabSetName);
        }
        this.refreshClones(parent);
        this.refreshGUI();
    }

    public void removeSelectedNodes() {
        if (this.getSelectedTab() == null) {
            return;
        }
        ArrayList<LaunchNode> nodes = this.getSelectedTab().getSelectedNodes();
        if (nodes == null) {
            return;
        }
        LaunchNode toSelect = null;
        for (LaunchNode node : nodes) {
            if (node.getParent() == null || node.getRoot() != this.getRootNode()) continue;
            LaunchNode parent = (LaunchNode)node.getParent();
            if (toSelect == null) {
                toSelect = parent;
            }
            this.getSelectedTab().treeModel.removeNodeFromParent(node);
            if (parent.getOwner() != null) {
                this.changedFiles.add(parent.getOwner().getFileName());
            } else {
                this.changedFiles.add(this.tabSetName);
            }
            this.refreshClones(parent);
        }
        if (toSelect != null) {
            this.getSelectedTab().setTreeSelectionPath(toSelect);
            this.refreshGUI();
        }
    }

    public void addChildToSelectedNode(LaunchNode child) {
        LaunchNode parent = this.getSelectedNode();
        if (parent != null && child != null) {
            LaunchNode[] nodes = child.getAllOwnedNodes();
            int i = 0;
            while (i < nodes.length) {
                LaunchNode node = this.getSelectedTab().getClone(nodes[i]);
                if (node != null) {
                    this.getSelectedTab().setTreeSelectionPath(node);
                    JOptionPane.showMessageDialog(this.frame, String.valueOf(LaunchRes.getString("Dialog.DuplicateNode.Message")) + " \"" + node + "\"", LaunchRes.getString("Dialog.DuplicateNode.Title"), 2);
                    return;
                }
                ++i;
            }
            this.getSelectedTab().treeModel.insertNodeInto(child, parent, parent.getChildCount());
            this.getSelectedTab().tree.scrollPathToVisible(new TreePath(child.getPath()));
            child.setLaunchClass(child.launchClassName);
            if (parent.getOwner() != null) {
                this.changedFiles.add(parent.getOwner().getFileName());
            } else {
                this.changedFiles.add(this.tabSetName);
            }
            this.refreshClones(parent);
            this.refreshGUI();
        }
    }

    protected void refreshClones(LaunchNode node) {
        Map<LaunchPanel, LaunchNode> clones = this.getClones(node);
        this.replaceClones(node, clones);
    }

    protected void replaceClones(LaunchNode node, Map<LaunchPanel, LaunchNode> clones) {
        if (clones.isEmpty()) {
            return;
        }
        XMLControlElement control = new XMLControlElement(node.getOwner());
        for (LaunchPanel tab : clones.keySet()) {
            LaunchNode clone = clones.get(tab);
            LaunchNode parent = (LaunchNode)clone.getParent();
            boolean expanded = tab.tree.isExpanded(new TreePath(clone.getPath()));
            if (parent != null) {
                int index = parent.getIndex(clone);
                tab.treeModel.removeNodeFromParent(clone);
                clone = (LaunchNode)new XMLControlElement(control).loadObject(null);
                clone.setFileName(node.getFileName());
                tab.treeModel.insertNodeInto(clone, parent, index);
            } else {
                clone = (LaunchNode)new XMLControlElement(control).loadObject(null);
                clone.setFileName(node.getFileName());
                tab.treeModel.setRoot(clone);
            }
            if (!expanded) continue;
            tab.tree.expandPath(new TreePath(clone.getPath()));
        }
    }

    protected Map<LaunchPanel, LaunchNode> getClones(LaunchNode node) {
        HashMap<LaunchPanel, LaunchNode> clones = new HashMap<LaunchPanel, LaunchNode>();
        if ((node = node.getOwner()) == null) {
            return clones;
        }
        Component[] tabs = this.tabbedPane.getComponents();
        int i = 0;
        while (i < tabs.length) {
            LaunchPanel tab = (LaunchPanel)tabs[i];
            LaunchNode clone = tab.getClone(node);
            if (clone != null && clone != node) {
                clones.put(tab, clone);
            }
            ++i;
        }
        return clones;
    }

    protected static JFileChooser getJARChooser() {
        LaunchBuilder.getFileChooser().setFileFilter(jarFileFilter);
        return fileChooser;
    }

    public static JFileChooser getHTMLChooser() {
        LaunchBuilder.getFileChooser().setFileFilter(htmlFileFilter);
        return fileChooser;
    }

    public static JFileChooser getPDFChooser() {
        LaunchBuilder.getFileChooser().setFileFilter(pdfFileFilter);
        return fileChooser;
    }

    protected static JFileChooser getFileChooser() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser(new File(OSPRuntime.chooserDir));
            allFileFilter = fileChooser.getFileFilter();
            jarFileFilter = new javax.swing.filechooser.FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f == null) {
                        return false;
                    }
                    if (f.isDirectory()) {
                        return true;
                    }
                    String extension = null;
                    String name = f.getName();
                    int i = name.lastIndexOf(46);
                    if (i > 0 && i < name.length() - 1) {
                        extension = name.substring(i + 1).toLowerCase();
                    }
                    return extension != null && extension.equals("jar");
                }

                @Override
                public String getDescription() {
                    return LaunchRes.getString("FileChooser.JarFilter.Description");
                }
            };
            htmlFileFilter = new javax.swing.filechooser.FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f == null) {
                        return false;
                    }
                    if (f.isDirectory()) {
                        return true;
                    }
                    String extension = null;
                    String name = f.getName();
                    int i = name.lastIndexOf(46);
                    if (i > 0 && i < name.length() - 1) {
                        extension = name.substring(i + 1).toLowerCase();
                    }
                    return extension != null && (extension.equals("htm") || extension.equals("html"));
                }

                @Override
                public String getDescription() {
                    return LaunchRes.getString("FileChooser.HTMLFilter.Description");
                }
            };
            pdfFileFilter = new javax.swing.filechooser.FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f == null) {
                        return false;
                    }
                    if (f.isDirectory()) {
                        return true;
                    }
                    String extension = XML.getExtension(f.getName());
                    return extension != null && extension.equals("pdf");
                }

                @Override
                public String getDescription() {
                    return LaunchRes.getString("FileChooser.PDFFilter.Description");
                }
            };
        }
        fileChooser.removeChoosableFileFilter(jarFileFilter);
        fileChooser.removeChoosableFileFilter(htmlFileFilter);
        fileChooser.setFileFilter(allFileFilter);
        FontSizer.setFonts(fileChooser, FontSizer.getLevel());
        return fileChooser;
    }

    public static javax.swing.filechooser.FileFilter getHTMLFilter() {
        if (htmlFileFilter == null) {
            LaunchBuilder.getFileChooser();
        }
        return htmlFileFilter;
    }

    public static javax.swing.filechooser.FileFilter getPDFFilter() {
        if (pdfFileFilter == null) {
            LaunchBuilder.getFileChooser();
        }
        return pdfFileFilter;
    }

    @Override
    protected void handleMousePressed(MouseEvent e, LaunchPanel tab) {
        super.handleMousePressed(e, tab);
        if (OSPRuntime.isPopupTrigger(e)) {
            TreePath path = tab.tree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            LaunchNode node = this.getSelectedNode();
            if (node == null) {
                return;
            }
            String fileName = node.getFileName();
            if (fileName != null && this.changedFiles.contains(fileName)) {
                if (this.popup.getComponentCount() != 0) {
                    this.popup.addSeparator();
                }
                this.popup.add(this.saveNodeItem);
            }
            if (this.popup.getComponentCount() != 0) {
                this.popup.addSeparator();
            }
            this.popup.add(this.saveNodeAsItem);
            if (!node.isRoot()) {
                this.popup.addSeparator();
                this.openTabItem.setText(LaunchRes.getString("Action.OpenTab"));
                this.popup.add(this.openTabItem);
            }
            this.popup.show(tab, e.getX() + 4, e.getY() + 12);
        }
    }

    @Override
    protected void exit() {
        OSPRuntime.setAuthorMode(false);
        if (!this.saveAllChanges()) {
            int op = this.frame.getDefaultCloseOperation();
            this.frame.setDefaultCloseOperation(0);
            SwingUtilities.invokeLater(() -> this.frame.setDefaultCloseOperation(op));
            return;
        }
        super.exit();
    }

    protected boolean isTabSetWritable() {
        boolean writable;
        String path = XML.getResolvedPath(this.tabSetName, tabSetBasePath);
        Resource res = ResourceLoader.getResource(path);
        File file = res == null ? null : res.getFile();
        boolean bl = writable = file == null ? true : file.canWrite();
        if (!this.selfContained) {
            int i = 0;
            while (i < this.tabbedPane.getTabCount()) {
                LaunchNode root = this.getTab(i).getRootNode();
                writable = writable && this.isNodeWritable(root);
                ++i;
            }
        }
        return writable;
    }

    protected boolean isNodeWritable(LaunchNode node) {
        boolean writable;
        File file = node.getFile();
        boolean bl = writable = file == null ? true : file.canWrite();
        if (!node.isSelfContained()) {
            LaunchNode[] nodes = node.getChildOwnedNodes();
            int i = 0;
            while (i < nodes.length) {
                writable = writable && this.isNodeWritable(nodes[i]);
                ++i;
            }
        }
        return writable;
    }

    protected static class NodeSet {
        ArrayList<Object[]> nodes = new ArrayList();

        private NodeSet(ArrayList<LaunchNode> list) {
            for (LaunchNode next : list) {
                Object[] data = new Object[]{next, next.getFileName()};
                this.nodes.add(data);
            }
        }

        private NodeSet(XMLControl control) {
            ArrayList input = (ArrayList)control.getObject("nodes");
            if (input != null) {
                for (Object next : input) {
                    this.nodes.add((Object[])next);
                }
            }
        }

        public static XML.ObjectLoader getLoader() {
            return new Loader();
        }

        static class Loader
        implements XML.ObjectLoader {
            Loader() {
            }

            @Override
            public void saveObject(XMLControl control, Object obj) {
                NodeSet nodeSet = (NodeSet)obj;
                control.setValue("nodes", nodeSet.nodes);
            }

            @Override
            public Object createObject(XMLControl control) {
                return new NodeSet(control);
            }

            @Override
            public Object loadObject(XMLControl control, Object obj) {
                return obj;
            }
        }
    }
}

