/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.LaunchableClassMap;

public class LaunchClassChooser
extends JDialog {
    private static Pattern pattern;
    private static Matcher matcher;
    private static Map<String, LaunchableClassMap> classMaps;
    protected static boolean jarsOnly;
    protected static String baseDirectoryPath;
    private JTextField searchField;
    private String defaultSearch;
    private String currentSearch;
    private JScrollPane scroller;
    private JList<String> choices;
    private LaunchableClassMap classMap;
    private boolean applyChanges;
    private JButton okButton;

    static {
        classMaps = new TreeMap<String, LaunchableClassMap>();
        jarsOnly = true;
    }

    public LaunchClassChooser(Component owner) {
        super(JOptionPane.getFrameForComponent(owner), true);
        this.currentSearch = this.defaultSearch = "";
        this.applyChanges = false;
        this.setTitle(LaunchRes.getString("ClassChooser.Frame.Title"));
        JLabel textLabel = new JLabel(String.valueOf(LaunchRes.getString("ClassChooser.Search.Label")) + " ");
        this.okButton = new JButton(LaunchRes.getString("ClassChooser.Button.Accept"));
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchClassChooser.this.applyChanges = true;
                LaunchClassChooser.this.setVisible(false);
            }
        });
        JButton cancelButton = new JButton(LaunchRes.getString("ClassChooser.Button.Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchClassChooser.this.setVisible(false);
            }
        });
        this.searchField = new JTextField(this.defaultSearch);
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Object obj = LaunchClassChooser.this.choices.getSelectedValue();
                if ("model".equals(LaunchClassChooser.this.searchField.getName())) {
                    LaunchClassChooser.this.searchForModel();
                } else {
                    LaunchClassChooser.this.search();
                }
                LaunchClassChooser.this.choices.setSelectedValue(obj, true);
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        JPanel headerPane = new JPanel();
        headerPane.setLayout(new BoxLayout(headerPane, 0));
        headerPane.add(textLabel);
        headerPane.add(Box.createHorizontalGlue());
        headerPane.add(this.searchField);
        headerPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        JPanel scrollPane = new JPanel(new BorderLayout());
        scrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(this.okButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)headerPane, "North");
        contentPane.add((Component)scrollPane, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.scroller = new JScrollPane();
        this.scroller.setPreferredSize(new Dimension(400, 300));
        scrollPane.add((Component)this.scroller, "Center");
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        this.setLocation(x, y);
    }

    public boolean setPath(String path) {
        String[] jarNames = LaunchClassChooser.parsePath(path);
        this.classMap = null;
        if (jarNames == null || jarNames.length == 0) {
            return false;
        }
        String key = "";
        int i = 0;
        while (i < jarNames.length) {
            if (!key.equals("")) {
                key = String.valueOf(key) + ";";
            }
            key = String.valueOf(key) + jarNames[i];
            ++i;
        }
        this.classMap = classMaps.get(key);
        if (this.classMap == null) {
            this.classMap = new LaunchableClassMap(jarNames);
            classMaps.put(key, this.classMap);
        }
        return true;
    }

    public boolean isLoaded(String path) {
        if (this.classMap == null) {
            return false;
        }
        String[] jarNames = LaunchClassChooser.parsePath(path);
        int i = 0;
        while (i < jarNames.length) {
            if (!this.classMap.includesJar(jarNames[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean chooseClassFor(LaunchNode node) {
        if ("model".equals(this.searchField.getName())) {
            this.searchField.setText(null);
        }
        this.setTitle(LaunchRes.getString("ClassChooser.Frame.Title"));
        this.searchField.setName("launch");
        this.search();
        this.choices.setSelectedValue(node.launchClassName, true);
        this.applyChanges = false;
        this.setVisible(true);
        if (!this.applyChanges) {
            return false;
        }
        String obj = this.choices.getSelectedValue();
        if (obj == null) {
            return false;
        }
        String className = obj.toString();
        node.launchClass = (Class)this.classMap.get(className);
        node.launchClassName = className;
        node.launchModelScroller = null;
        return true;
    }

    public Class<?> chooseModel(String previousClassName) {
        if ("launch".equals(this.searchField.getName())) {
            this.searchField.setText(null);
        }
        this.setTitle(LaunchRes.getString("ModelClassChooser.Frame.Title"));
        this.searchField.setName("model");
        this.searchForModel();
        this.choices.setSelectedValue(previousClassName, true);
        this.applyChanges = false;
        this.setVisible(true);
        if (!this.applyChanges) {
            return null;
        }
        String obj = this.choices.getSelectedValue();
        if (obj == null) {
            return null;
        }
        String className = obj.toString();
        return this.classMap.models.get(className);
    }

    public Class<?> getClass(String className) {
        if (this.classMap == null) {
            return null;
        }
        return this.classMap.getClass(className);
    }

    public static void setBasePath(String path) {
        baseDirectoryPath = path;
    }

    public static Class<?> getClass(String classPath, String className) {
        if (classPath == null || className == null) {
            return null;
        }
        String[] jarNames = LaunchClassChooser.parsePath(classPath);
        LaunchableClassMap classMap = LaunchClassChooser.getClassMap(jarNames);
        return classMap.getClass(className);
    }

    public static Class<?> getModelClass(String classPath, String className) {
        if (classPath == null || className == null) {
            return null;
        }
        String[] jarNames = LaunchClassChooser.parsePath(classPath);
        LaunchableClassMap classMap = LaunchClassChooser.getClassMap(jarNames);
        return classMap.getModelClass(className);
    }

    public static Class<?> getClassOfType(String classPath, String className, Class<?> type) {
        if (classPath == null || className == null) {
            return null;
        }
        String[] jarNames = LaunchClassChooser.parsePath(classPath);
        LaunchableClassMap classMap = LaunchClassChooser.getClassMap(jarNames);
        return classMap.getClassOfType(className, type);
    }

    public static ClassLoader getClassLoader(String classPath) {
        if (classPath == null || classPath.equals("")) {
            return null;
        }
        String[] jarNames = LaunchClassChooser.parsePath(classPath);
        LaunchableClassMap classMap = LaunchClassChooser.getClassMap(jarNames);
        return classMap.classLoader;
    }

    private static LaunchableClassMap getClassMap(String[] jarNames) {
        String key = "";
        int i = 0;
        while (i < jarNames.length) {
            if (!key.equals("")) {
                key = String.valueOf(key) + ";";
            }
            key = String.valueOf(key) + jarNames[i];
            ++i;
        }
        LaunchableClassMap classMap = classMaps.get(key);
        if (classMap == null) {
            classMap = new LaunchableClassMap(jarNames);
            classMaps.put(key, classMap);
        }
        return classMap;
    }

    private void search() {
        if (this.classMap == null) {
            return;
        }
        this.classMap.loadAllClasses();
        if (this.search(this.searchField.getText())) {
            this.currentSearch = this.searchField.getText();
            this.searchField.setBackground(Color.white);
        } else {
            JOptionPane.showMessageDialog(this, String.valueOf(LaunchRes.getString("Dialog.InvalidRegex.Message")) + " \"" + this.searchField.getText() + "\"", LaunchRes.getString("Dialog.InvalidRegex.Title"), 2);
            this.searchField.setText(this.currentSearch);
        }
    }

    private void searchForModel() {
        if (this.classMap == null) {
            return;
        }
        this.classMap.loadAllClasses();
        if (this.searchForModel(this.searchField.getText())) {
            this.currentSearch = this.searchField.getText();
            this.searchField.setBackground(Color.white);
        } else {
            JOptionPane.showMessageDialog(this, String.valueOf(LaunchRes.getString("Dialog.InvalidRegex.Message")) + " \"" + this.searchField.getText() + "\"", LaunchRes.getString("Dialog.InvalidRegex.Title"), 2);
            this.searchField.setText(this.currentSearch);
        }
    }

    private boolean search(String regex) {
        regex = regex.toLowerCase();
        this.okButton.setEnabled(false);
        try {
            pattern = Pattern.compile(regex);
        }
        catch (Exception ex) {
            return false;
        }
        ArrayList<String> matches = new ArrayList<String>();
        for (String name : this.classMap.keySet()) {
            matcher = pattern.matcher(name.toLowerCase());
            if (!matcher.find()) continue;
            matches.add(name);
        }
        String[] results = matches.toArray(new String[matches.size()]);
        this.choices = new JList<String>(results);
        this.choices.setSelectionMode(0);
        this.choices.setFont(this.searchField.getFont());
        this.choices.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JList theList = (JList)e.getSource();
                LaunchClassChooser.this.okButton.setEnabled(!theList.isSelectionEmpty());
            }
        });
        this.choices.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JList theList = (JList)e.getSource();
                if (e.getClickCount() == 2 && !theList.isSelectionEmpty()) {
                    LaunchClassChooser.this.okButton.doClick();
                }
            }
        });
        this.scroller.getViewport().setView(this.choices);
        return true;
    }

    private boolean searchForModel(String regex) {
        regex = regex.toLowerCase();
        this.okButton.setEnabled(false);
        try {
            pattern = Pattern.compile(regex);
        }
        catch (Exception ex) {
            return false;
        }
        ArrayList<String> matches = new ArrayList<String>();
        for (String name : this.classMap.models.keySet()) {
            matcher = pattern.matcher(name.toLowerCase());
            if (!matcher.find()) continue;
            matches.add(name);
        }
        String[] results = matches.toArray(new String[matches.size()]);
        this.choices = new JList<String>(results);
        this.choices.setSelectionMode(0);
        this.choices.setFont(this.searchField.getFont());
        this.choices.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JList theList = (JList)e.getSource();
                LaunchClassChooser.this.okButton.setEnabled(!theList.isSelectionEmpty());
            }
        });
        this.choices.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JList theList = (JList)e.getSource();
                if (e.getClickCount() == 2 && !theList.isSelectionEmpty()) {
                    LaunchClassChooser.this.okButton.doClick();
                }
            }
        });
        this.scroller.getViewport().setView(this.choices);
        return true;
    }

    static String[] parsePath(String path) {
        return LaunchClassChooser.parsePath(path, jarsOnly);
    }

    static String[] parsePath(String path, boolean jarsOnly) {
        ArrayList<String> tokens = new ArrayList<String>();
        String next = path;
        int i = path.indexOf(";");
        if (i != -1) {
            next = path.substring(0, i);
            path = path.substring(i + 1);
        } else {
            path = "";
        }
        while (next.length() > 0) {
            if (!jarsOnly || next.endsWith(".jar")) {
                tokens.add(next);
            }
            if ((i = path.indexOf(";")) == -1) {
                next = path.trim();
                path = "";
                continue;
            }
            next = path.substring(0, i).trim();
            path = path.substring(i + 1).trim();
        }
        return tokens.toArray(new String[0]);
    }
}

