/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.opensourcephysics.controls.ConsoleLevel;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.LaunchClassChooser;
import org.opensourcephysics.tools.LaunchPanel;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class LaunchNode
extends DefaultMutableTreeNode {
    static final Level DEFAULT_LOG_LEVEL = ConsoleLevel.OUT_CONSOLE;
    Object launchObj;
    String classPath;
    String launchClassName;
    Class<?> launchClass;
    String[] args = new String[]{""};
    boolean showLog = false;
    boolean clearLog = false;
    Level logLevel = DEFAULT_LOG_LEVEL;
    boolean singleVM = false;
    boolean singleVMOff = false;
    boolean hiddenWhenRoot = false;
    boolean buttonView = false;
    boolean singleton = false;
    boolean singleApp = false;
    boolean singleAppOff = false;
    boolean hiddenInLauncher = false;
    String name = "";
    String description = "";
    String tooltip = "";
    String xsetName = "";
    String author = "";
    String keywords = "";
    String level = "";
    String languages = "";
    String comment = "";
    String appletWidth = "";
    String appletHeight = "";
    ArrayList<DisplayTab> tabData = new ArrayList();
    private String fileName;
    Collection<Process> processes = new HashSet<Process>();
    Collection<Frame> frames = new HashSet<Frame>();
    Collection<Action> actions = new HashSet<Action>();
    Map<Runnable, Thread> threads = new HashMap<Runnable, Thread>();
    int launchCount = 0;
    LaunchPanel launchPanel;
    boolean selfContained;
    boolean parentSelfContained;
    boolean previewing;
    boolean saveHiddenNodes;
    boolean enabled = true;
    List<String> jars = new ArrayList<String>();
    List<String> pdf = new ArrayList<String>();
    int tabNumber = -1;
    int prevTabNumber = -1;
    private URL htmlURL;
    URL prevURL;
    JScrollPane launchModelScroller;
    boolean isDisplayable;

    public void setURL(URL url) {
        this.htmlURL = url;
        this.isDisplayable = url != null && Launcher.isDisplayable(url.toString());
    }

    public URL getURL() {
        return this.htmlURL;
    }

    public LaunchNode(String name) {
        this.setUserObject(this);
        if (name != null) {
            this.name = name;
        }
    }

    public void threadRunning(boolean starting) {
        this.launchCount += starting ? 1 : -1;
        this.launchCount = Math.max(0, this.launchCount);
        if (this.launchPanel != null) {
            this.launchPanel.repaint();
        }
    }

    public void launch() {
        this.launch(null);
    }

    public void launch(LaunchPanel tab) {
        if (!this.isLeaf()) {
            return;
        }
        this.launchPanel = tab;
        OSPRuntime.launchingInSingleVM = this.isSingleVM();
        Launcher.singleAppMode = this.isSingleApp();
        Launcher.classPath = this.getClassPath();
        if (this.isShowLog() && this.isSingleVM()) {
            OSPLog.setLevel(this.getLogLevel());
            OSPLog log = OSPLog.getOSPLog();
            if (this.isClearLog()) {
                log.clear();
            }
            log.setVisible(true);
        }
        this.setMinimumArgLength(1);
        String arg0 = this.args[0];
        if (this.getLaunchClass() != null) {
            if (arg0.equals("this")) {
                Object launchObj = this.getLaunchObject();
                if (launchObj != null) {
                    XMLControlElement control = new XMLControlElement(launchObj);
                    this.args[0] = control.toXML();
                } else {
                    this.args[0] = "";
                }
            }
            if (this.args[0].equals("") && this.args.length == 1) {
                Launcher.launch(this.getLaunchClass(), null, this);
            } else {
                Launcher.launch(this.getLaunchClass(), this.args, this);
            }
        }
        this.args[0] = arg0;
    }

    public LaunchNode getOwner() {
        if (this.fileName != null) {
            return this;
        }
        if (this.getParent() != null) {
            return ((LaunchNode)this.getParent()).getOwner();
        }
        return null;
    }

    public LaunchNode[] getAllOwnedNodes() {
        ArrayList<LaunchNode> nodes = new ArrayList<LaunchNode>();
        Enumeration<TreeNode> e = this.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            LaunchNode next = (LaunchNode)e.nextElement();
            if (next.fileName == null || next == this) continue;
            nodes.add(next);
        }
        return nodes.toArray(new LaunchNode[0]);
    }

    public LaunchNode[] getChildOwnedNodes() {
        ArrayList<LaunchNode> nodes = new ArrayList<LaunchNode>();
        LaunchNode[] owned = this.getAllOwnedNodes();
        LaunchNode owner = this.getOwner();
        int i = 0;
        while (i < owned.length) {
            LaunchNode next = ((LaunchNode)owned[i].getParent()).getOwner();
            if (next == owner) {
                nodes.add(owned[i]);
            }
            ++i;
        }
        return nodes.toArray(new LaunchNode[0]);
    }

    @Override
    public String toString() {
        if (this.name != null && !this.name.equals("")) {
            return this.name;
        }
        if (this.launchClassName != null) {
            return XML.getExtension(this.launchClassName);
        }
        if (!this.args[0].equals("")) {
            String name = this.args[0];
            name = XML.getName(name);
            return XML.stripExtension(name);
        }
        return "";
    }

    public String getID() {
        return String.valueOf(this.hashCode());
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getDescription() {
        return this.description;
    }

    public void setArgs(String[] args) {
        if (args != null && args.length > 0 && args[0] != null) {
            this.args = args;
        }
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setTooltip(String _tooltip) {
        this.tooltip = _tooltip;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setAuthor(String _author) {
        this.author = _author;
    }

    public String getAuthor() {
        if (!this.author.equals("")) {
            return this.author;
        }
        if (this.isRoot()) {
            return "";
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return parent.getAuthor();
    }

    public void setKeyword(String _keywords) {
        this.keywords = _keywords;
    }

    public String getKeywords() {
        if (!this.keywords.equals("")) {
            return this.keywords;
        }
        if (this.isRoot()) {
            return "";
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return parent.getKeywords();
    }

    public void setComment(String _comment) {
        this.comment = _comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setPreferredAppletWidth(String _width) {
        this.appletWidth = _width;
    }

    public String getPreferredAppletWidth() {
        return this.appletWidth;
    }

    public void setPreferredAppletHeight(String _height) {
        this.appletHeight = _height;
    }

    public String getPreferredAppletHeight() {
        return this.appletHeight;
    }

    public void setCourseLevel(String _level) {
        this.level = _level;
    }

    public String getCourseLevel() {
        if (!this.level.equals("")) {
            return this.level;
        }
        if (this.isRoot()) {
            return "";
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return parent.getCourseLevel();
    }

    public void setLanguages(String _lang) {
        this.languages = _lang;
    }

    public String getLanguages() {
        if (!this.languages.equals("")) {
            return this.languages;
        }
        if (this.isRoot()) {
            return "";
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return parent.getLanguages();
    }

    public String getClassPath() {
        String path = "";
        if (this.classPath != null) {
            path = String.valueOf(path) + this.classPath;
        }
        LaunchNode node = this;
        while (!node.isRoot()) {
            node = (LaunchNode)node.getParent();
            if (node.classPath == null) continue;
            if (!path.equals("")) {
                path = String.valueOf(path) + ";";
            }
            path = String.valueOf(path) + node.classPath;
        }
        if (!path.equals("")) {
            this.jars.clear();
            String next = path;
            int i = path.indexOf(";");
            if (i == -1) {
                i = path.indexOf(":");
            }
            if (i != -1) {
                next = path.substring(0, i);
                path = path.substring(i + 1);
            } else {
                path = "";
            }
            while (next.length() > 0) {
                if (!this.jars.contains(next)) {
                    this.jars.add(next);
                }
                if ((i = path.indexOf(";")) == -1) {
                    i = path.indexOf(":");
                }
                if (i == -1) {
                    next = path.trim();
                    path = "";
                    continue;
                }
                next = path.substring(0, i).trim();
                path = path.substring(i + 1).trim();
            }
            Iterator<String> it = this.jars.iterator();
            while (it.hasNext()) {
                if (!path.equals("")) {
                    path = String.valueOf(path) + ";";
                }
                path = String.valueOf(path) + it.next();
            }
        }
        if (OSPRuntime.getLaunchJarName() != null && path.indexOf(OSPRuntime.getLaunchJarName()) == -1 && LaunchClassChooser.baseDirectoryPath == null) {
            if (!path.equals("")) {
                path = String.valueOf(path) + ";";
            }
            path = String.valueOf(path) + OSPRuntime.getLaunchJarName();
        }
        return path;
    }

    /*
     * Unable to fully structure code
     */
    public void setClassPath(String jarNames) {
        if (jarNames != null && !jarNames.equals("")) ** GOTO lbl5
        this.classPath = null;
        return;
lbl-1000:
        // 1 sources

        {
            jarNames = jarNames.substring(1);
lbl5:
            // 2 sources

            ** while (jarNames.startsWith((String)":") || jarNames.startsWith((String)";"))
        }
lbl6:
        // 2 sources

        while (jarNames.endsWith(":") || jarNames.endsWith(";")) {
            jarNames = jarNames.substring(0, jarNames.length() - 1);
        }
        s = jarNames;
        i = jarNames.indexOf(";;");
        if (i == -1) {
            i = jarNames.indexOf("::");
        }
        if (i == -1) {
            i = jarNames.indexOf(":;");
        }
        if (i == -1) {
            i = jarNames.indexOf(";:");
        }
        while (i > -1) {
            s = jarNames = String.valueOf(jarNames.substring(0, i + 1)) + s.substring(i + 2);
            i = jarNames.indexOf(";;");
            if (i == -1) {
                i = jarNames.indexOf("::");
            }
            if (i == -1) {
                i = jarNames.indexOf(":;");
            }
            if (i != -1) continue;
            i = jarNames.indexOf(";:");
        }
        this.classPath = jarNames;
    }

    public String getLaunchClassName() {
        return this.launchClassName;
    }

    public boolean setLaunchClass(String className) {
        if (className == null) {
            return false;
        }
        if (this.launchClassName == className && this.launchClass != null) {
            return false;
        }
        this.launchModelScroller = null;
        this.launchClassName = className;
        this.launchClass = LaunchClassChooser.getClass(this.getClassPath(), className);
        OSPLog.finest("node " + this.getName() + ": " + LaunchRes.getString("Log.Message.SetLaunchClass") + " " + className + (this.launchClass == null ? " (not found!)" : ""));
        return this.launchClass != null;
    }

    public Class<?> getLaunchClass() {
        if (this.launchClass == null && this.launchClassName != null && !this.launchClassName.equals("")) {
            this.setLaunchClass(this.launchClassName);
        }
        return this.launchClass;
    }

    public Object getLaunchObject() {
        if (this.launchObj != null) {
            return this.launchObj;
        }
        if (this.isRoot()) {
            return null;
        }
        LaunchNode node = (LaunchNode)this.getParent();
        return node.getLaunchObject();
    }

    public void setLaunchObject(Object obj) {
        this.launchObj = obj;
    }

    public DisplayTab setDisplayTab(int n, String title, String path, String[] args) {
        if (n >= this.tabData.size()) {
            return this.addDisplayTab(title, path, args);
        }
        if (path == null || path.equals("")) {
            return this.removeDisplayTab(n);
        }
        DisplayTab tab = this.tabData.get(n);
        tab.title = title;
        tab.setPath(path);
        tab.setModelArgs(args);
        OSPLog.finest("tab " + n + " changed: [\"" + title + "\", \"" + path + "\"]");
        return tab;
    }

    public DisplayTab addDisplayTab(String title, String path, String[] args) {
        if (path == null || path.equals("")) {
            return null;
        }
        DisplayTab tab = new DisplayTab(title, path);
        tab.setModelArgs(args);
        this.tabData.add(tab);
        OSPLog.finest("tab added: [\"" + title + "\", \"" + path + "\"]");
        return tab;
    }

    public DisplayTab insertDisplayTab(int n, String title, String path, String[] args) {
        if (path == null || path.equals("") || n >= this.tabData.size()) {
            return null;
        }
        DisplayTab tab = new DisplayTab(title, path);
        tab.setModelArgs(args);
        this.tabData.add(n, tab);
        OSPLog.finest("tab inserted: [\"" + title + "\", \"" + path + "\"]");
        return tab;
    }

    public DisplayTab removeDisplayTab(int n) {
        DisplayTab tab = this.getDisplayTab(n);
        if (tab != null) {
            this.tabData.remove(tab);
            OSPLog.finest("tab " + n + " removed: [\"" + tab.title + "\", \"" + tab.urlOrModel + "\"]");
        }
        return tab;
    }

    public DisplayTab getDisplayTab(int n) {
        if (n < 0 || n >= this.tabData.size()) {
            return null;
        }
        return this.tabData.get(n);
    }

    public int getDisplayTabCount() {
        return this.tabData.size();
    }

    public List<String> getPDFPaths() {
        int n = this.getDisplayTabCount();
        this.pdf.clear();
        int i = 0;
        while (i < n) {
            String path = this.getDisplayTab(i).getPath();
            if (path.toLowerCase().endsWith(".pdf")) {
                this.pdf.add(path);
            }
            ++i;
        }
        return this.pdf;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPathString() {
        TreeNode[] nodes = this.getPath();
        LaunchNode next = (LaunchNode)nodes[0];
        StringBuffer path = new StringBuffer(next.name);
        int i = 1;
        while (i < nodes.length) {
            next = (LaunchNode)nodes[i];
            path.append("/" + next.name);
            ++i;
        }
        return path.toString();
    }

    public String setFileName(String path) {
        this.fileName = path == null ? null : XML.getPathRelativeTo(path, Launcher.tabSetBasePath);
        return this.fileName;
    }

    public boolean isParentSelfContained() {
        if (this.parentSelfContained) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return parent.isSelfContained();
    }

    public boolean isSelfContained() {
        return this.selfContained || this.isParentSelfContained();
    }

    public boolean isPreviewing() {
        if (this.previewing) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode node = (LaunchNode)this.getParent();
        return node.isPreviewing();
    }

    public boolean isSavingHiddenNodes() {
        if (this.saveHiddenNodes) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode node = (LaunchNode)this.getParent();
        return node.isSavingHiddenNodes();
    }

    public void setSelfContained(boolean selfContained) {
        this.selfContained = selfContained;
    }

    public boolean isSingleVM() {
        if (this.singleVM || OSPRuntime.isWebStart()) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return this.singleVMOff ? false : parent.isSingleVM();
    }

    public void setSingleVM(boolean singleVM) {
        this.singleVM = singleVM;
    }

    public boolean isShowLog() {
        if (this.showLog) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return parent.isShowLog();
    }

    public void setShowLog(boolean show) {
        this.showLog = show;
    }

    public boolean isClearLog() {
        if (this.clearLog) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return parent.isClearLog();
    }

    public void setClearLog(boolean clear) {
        this.clearLog = clear;
    }

    public Level getLogLevel() {
        Level parentLevel;
        if (this.isRoot()) {
            return this.logLevel;
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        if (parent.isShowLog() && (parentLevel = parent.getLogLevel()).intValue() < this.logLevel.intValue()) {
            return parentLevel;
        }
        return this.logLevel;
    }

    public void setLogLevel(Level level) {
        if (level != null) {
            this.logLevel = level;
        }
    }

    public boolean isSingleApp() {
        if (this.singleApp) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return this.singleAppOff ? false : parent.isSingleApp();
    }

    public void setSingleApp(boolean singleApp) {
        this.singleApp = singleApp;
    }

    public void setHiddenWhenRoot(boolean hide) {
        this.hiddenWhenRoot = hide;
    }

    public boolean isButtonView() {
        if (this.buttonView) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return parent.isButtonView();
    }

    public void setButtonView(boolean buttonView) {
        LaunchNode root = (LaunchNode)this.getRoot();
        root.buttonView = buttonView;
    }

    public boolean isSingleton() {
        if (this.singleton) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return parent.isSingleton();
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean isHiddenInLauncher() {
        if (this.hiddenInLauncher) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return parent.isHiddenInLauncher();
    }

    public void setHiddenInLauncher(boolean hide) {
        this.hiddenInLauncher = hide;
    }

    public Resource getResource() {
        if (this.fileName == null) {
            return null;
        }
        String path = XML.getResolvedPath(this.fileName, Launcher.tabSetBasePath);
        return ResourceLoader.getResource(path);
    }

    public boolean exists() {
        return this.getResource() != null;
    }

    public File getFile() {
        if (this.exists()) {
            return this.getResource().getFile();
        }
        return null;
    }

    public boolean matches(LaunchNode node) {
        if (node == null) {
            return false;
        }
        boolean match = this.showLog == node.showLog && this.clearLog == node.clearLog && this.singleton == node.singleton && this.singleVM == node.singleVM && this.hiddenWhenRoot == node.hiddenWhenRoot && this.name.equals(node.name) && this.description.equals(node.description) && this.args[0].equals(node.args[0]) && (this.fileName == null && node.fileName == null || this.fileName != null && this.fileName.equals(node.fileName)) && (this.getLaunchClass() == null && node.getLaunchClass() == null || this.getLaunchClass() != null && this.getLaunchClass().equals(node.getLaunchClass())) && (this.classPath == null && node.classPath == null || this.classPath != null && this.classPath.equals(node.classPath));
        return match;
    }

    public LaunchNode getChildNode(String childFileName) {
        Enumeration<TreeNode> e = this.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            LaunchNode next = (LaunchNode)e.nextElement();
            if (!childFileName.equals(next.fileName)) continue;
            return next;
        }
        return null;
    }

    public void addMenuItemsTo(JComponent menu) {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            JMenuItem item;
            LaunchNode child = (LaunchNode)e.nextElement();
            if (child.isLeaf()) {
                item = new JMenuItem(child.toString());
                menu.add(item);
                item.setToolTipText(child.tooltip);
                item.setActionCommand(child.getID());
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String id = e.getActionCommand();
                        LaunchNode root = (LaunchNode)LaunchNode.this.getRoot();
                        Enumeration<TreeNode> e2 = root.postorderEnumeration();
                        while (e2.hasMoreElements()) {
                            LaunchNode node = (LaunchNode)e2.nextElement();
                            if (!node.getID().equals(id)) continue;
                            node.launch();
                            break;
                        }
                    }
                });
                continue;
            }
            item = new JMenu(child.toString());
            menu.add(item);
            child.addMenuItemsTo(item);
        }
    }

    public void addTerminateAction(Action action) {
        this.actions.add(action);
        ++this.launchCount;
    }

    public void removeTerminateAction(Action action) {
        this.actions.remove(action);
        this.launchCount = Math.max(0, --this.launchCount);
    }

    public void terminate(Action action) {
        if (this.actions.contains(action)) {
            this.removeTerminateAction(action);
            if (this.launchPanel != null) {
                this.launchPanel.repaint();
            }
        }
    }

    public void terminateAll() {
        for (Process proc : this.processes) {
            proc.destroy();
        }
        for (Frame frame : this.frames) {
            WindowListener[] listeners = frame.getWindowListeners();
            int j = 0;
            while (j < listeners.length) {
                if (listeners[j] instanceof Launcher.FrameCloser) {
                    frame.removeWindowListener(listeners[j]);
                }
                ++j;
            }
            frame.dispose();
        }
        for (Thread thread : this.threads.values()) {
            if (thread == null) continue;
            thread.interrupt();
        }
        HashSet<Action> allActions = new HashSet<Action>(this.actions);
        for (Action action : allActions) {
            if (action == null) continue;
            action.actionPerformed(null);
        }
        this.processes.clear();
        this.frames.clear();
        this.threads.clear();
        this.actions.clear();
        this.launchCount = 0;
    }

    protected JScrollPane getLaunchModelScroller() {
        if (this.launchModelScroller == null) {
            final JComponent content = Launcher.getModelPane(this.getLaunchClass(), this.getArgs());
            if (content == null) {
                return null;
            }
            JPanel panel = new JPanel(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dim = content.getPreferredSize();
                    dim.width += 8;
                    dim.height += 8;
                    return dim;
                }
            };
            panel.setLayout(new BorderLayout());
            panel.setBackground(Color.white);
            panel.add((Component)content, "Center");
            this.launchModelScroller = new JScrollPane(panel);
        }
        return this.launchModelScroller;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private String[][] getDisplayData() {
        if (this.tabData.isEmpty()) {
            return null;
        }
        String[][] data = new String[this.tabData.size()][2];
        int i = 0;
        while (i < this.tabData.size()) {
            DisplayTab tab = this.tabData.get(i);
            data[i] = new String[]{tab.title, tab.urlOrModel};
            ++i;
        }
        return data;
    }

    private void setDisplayData(String[][] data) {
        if (data == null) {
            return;
        }
        this.tabData.clear();
        int i = 0;
        while (i < data.length) {
            DisplayTab tab = new DisplayTab(data[i][0], data[i][1]);
            this.tabData.add(tab);
            ++i;
        }
    }

    private String[][] getDisplayArgs() {
        if (this.tabData.isEmpty()) {
            return null;
        }
        String[][] data = new String[this.tabData.size()][];
        int i = 0;
        while (i < this.tabData.size()) {
            DisplayTab tab = this.tabData.get(i);
            String[] args = tab.getModelArgs();
            data[i] = args.length == 0 ? null : args;
            ++i;
        }
        return data;
    }

    private void setDisplayArgs(String[][] data) {
        if (data == null) {
            return;
        }
        int len = Math.min(data.length, this.tabData.size());
        int i = 0;
        while (i < len) {
            DisplayTab tab = this.tabData.get(i);
            tab.setModelArgs(data[i]);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void setMinimumArgLength(int n) {
        block4: {
            if ((n = Math.max(n, 1)) == this.args.length) {
                return;
            }
            if (n <= this.args.length) ** GOTO lbl19
            newArgs = new String[n];
            i = 0;
            while (i < n) {
                newArgs[i] = i < this.args.length ? this.args[i] : "";
                ++i;
            }
            this.setArgs(newArgs);
            break block4;
lbl-1000:
            // 1 sources

            {
                newArgs = new String[this.args.length - 1];
                i = 0;
                while (i < newArgs.length) {
                    newArgs[i] = this.args[i];
                    ++i;
                }
                this.setArgs(newArgs);
lbl19:
                // 2 sources

                ** while (this.args.length > n && this.args[this.args.length - 1].equals((Object)""))
            }
        }
    }

    protected void removeThread(Runnable runner) {
        this.threads.remove(runner);
    }

    @Deprecated
    public DisplayTab addHTML(String title, String path) {
        return this.addDisplayTab(title, path, null);
    }

    @Deprecated
    public DisplayTab insertHTML(int n, String title, String path) {
        return this.insertDisplayTab(n, title, path, null);
    }

    @Deprecated
    public DisplayTab removeHTML(int n) {
        return this.removeDisplayTab(n);
    }

    @Deprecated
    public DisplayTab getHTML(int n) {
        return this.getDisplayTab(n);
    }

    @Deprecated
    public int getHTMLCount() {
        return this.getDisplayTabCount();
    }

    @Deprecated
    public DisplayTab setHTML(int n, String title, String path) {
        return this.setDisplayTab(n, title, path, null);
    }

    public void scrollToRef(String scrollRef) {
    }

    public class DisplayTab {
        private String title;
        boolean hyperlinksEnabled = true;
        private String urlOrModel;
        URL url;
        Class<?> modelClass;
        JComponent modelPane;
        JScrollPane modelScroller;
        String[] modelArgs = new String[0];
        boolean isDisplayable;
        private Boolean urlExists;

        DisplayTab(String title, String path) {
            this.setTitle(title);
            this.setPath(path);
        }

        public String getPath() {
            return this.urlOrModel;
        }

        public void setPath(String path) {
            this.urlOrModel = path;
            if (!this.setURL(path)) {
                this.setModelClass(path);
            }
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public URL getURL() {
            if (this.url == null && this.modelClass == null && !"".equals(this.urlOrModel)) {
                this.setURL(this.urlOrModel);
            }
            return this.url;
        }

        public Class<?> getModelClass() {
            if (this.url == null && this.modelClass == null && this.urlOrModel != null && !this.urlOrModel.equals("")) {
                this.setModelClass(this.urlOrModel);
            }
            return this.modelClass;
        }

        public JComponent getModelPane() {
            if (this.modelPane == null && this.getModelClass() != null) {
                if (JComponent.class.isAssignableFrom(this.modelClass)) {
                    try {
                        this.modelPane = (JComponent)this.modelClass.newInstance();
                    }
                    catch (Exception exception) {}
                } else {
                    this.modelPane = Launcher.getModelPane(this.modelClass, this.getModelArgs());
                }
            }
            return this.modelPane;
        }

        public String[] getModelArgs() {
            return this.modelArgs;
        }

        public void setModelArgs(String[] args) {
            if (args != null) {
                this.modelArgs = args;
                this.modelPane = null;
                this.modelScroller = null;
            }
        }

        protected JScrollPane getModelScroller() {
            final JComponent content = this.getModelPane();
            if (this.modelScroller == null && content != null) {
                JPanel panel = new JPanel(){

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension dim = content.getPreferredSize();
                        dim.width += 8;
                        dim.height += 8;
                        return dim;
                    }
                };
                panel.setLayout(new BorderLayout());
                panel.setBackground(Color.white);
                panel.add((Component)content, "Center");
                this.modelScroller = new JScrollPane(panel);
            }
            return this.modelScroller;
        }

        /*
         * Unable to fully structure code
         */
        protected void setMinimumModelArgLength(int n) {
            block4: {
                if ((n = Math.max(n, 0)) == this.modelArgs.length) {
                    return;
                }
                if (n <= this.modelArgs.length) ** GOTO lbl19
                newArgs = new String[n];
                i = 0;
                while (i < n) {
                    newArgs[i] = i < this.modelArgs.length ? this.modelArgs[i] : null;
                    ++i;
                }
                this.setModelArgs(newArgs);
                break block4;
lbl-1000:
                // 1 sources

                {
                    newArgs = new String[this.modelArgs.length - 1];
                    i = 0;
                    while (i < newArgs.length) {
                        newArgs[i] = this.modelArgs[i];
                        ++i;
                    }
                    this.setModelArgs(newArgs);
lbl19:
                    // 2 sources

                    ** while (this.modelArgs.length > n && this.modelArgs[this.modelArgs.length - 1] == null)
                }
            }
        }

        private boolean setURL(String path) {
            this.url = null;
            this.isDisplayable = false;
            this.urlExists = null;
            Resource res = ResourceLoader.getResource(path);
            if (res != null && res.getURL() != null) {
                this.url = res.getURL();
                try {
                    InputStream in = ResourceLoader.openStream(this.url);
                    in.close();
                    OSPLog.finer(String.valueOf(LaunchRes.getString("Log.Message.URL")) + " " + this.url);
                }
                catch (Exception ex) {
                    this.url = null;
                }
            }
            if (this.url == null) {
                return false;
            }
            this.isDisplayable = Launcher.isDisplayable(path);
            return true;
        }

        public boolean urlExists() {
            return this.urlExists == null ? (this.urlExists = Boolean.valueOf(Launcher.urlExists(this.url))) : this.urlExists;
        }

        private boolean setModelClass(String className) {
            this.urlOrModel = className;
            if (className == null) {
                return false;
            }
            if (this.modelClass != null && className.equals(this.modelClass.getName())) {
                return false;
            }
            this.modelPane = null;
            this.modelScroller = null;
            this.modelClass = LaunchClassChooser.getModelClass(LaunchNode.this.getClassPath(), className);
            return this.modelClass != null;
        }

        public String toString() {
            return "[LaunchNode.DisplayTab " + this.title + " " + this.urlOrModel + "]";
        }
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            LaunchNode node = (LaunchNode)obj;
            node.setMinimumArgLength(1);
            if (!node.name.equals("")) {
                control.setValue("name", node.name);
            }
            if (!node.description.equals("")) {
                control.setValue("description", node.description);
            }
            if (!node.tooltip.equals("")) {
                control.setValue("tooltip", node.tooltip);
            }
            if (!node.xsetName.equals("")) {
                control.setValue("launchset", node.xsetName);
            }
            control.setValue("display_tabs", node.getDisplayData());
            control.setValue("display_args", node.getDisplayArgs());
            if (node.getLaunchClass() != null) {
                control.setValue("launch_class", node.getLaunchClass().getName());
            } else if (node.launchClassName != null) {
                control.setValue("launch_class", node.launchClassName);
            }
            if (!node.args[0].equals("") || node.args.length > 1) {
                control.setValue("launch_args", node.args);
            }
            if (node.classPath != null && !node.classPath.equals("")) {
                control.setValue("classpath", node.classPath);
            }
            if (node.hiddenWhenRoot) {
                control.setValue("root_hidden", true);
            }
            if (node.buttonView) {
                control.setValue("button_view", true);
            }
            if (node.singleton) {
                control.setValue("singleton", true);
            }
            if (node.singleVM) {
                control.setValue("single_vm", true);
            }
            if (node.singleVMOff) {
                control.setValue("single_vm_off", true);
            }
            if (node.showLog) {
                control.setValue("show_log", true);
            }
            if (node.logLevel != DEFAULT_LOG_LEVEL) {
                control.setValue("log_level", node.logLevel.getName());
            }
            if (node.clearLog) {
                control.setValue("clear_log", true);
            }
            if (node.singleApp) {
                control.setValue("single_app", true);
            }
            if (node.singleAppOff) {
                control.setValue("single_app_off", true);
            }
            if (node.hiddenInLauncher) {
                control.setValue("hidden_in_launcher", true);
            }
            if (!node.author.equals("")) {
                control.setValue("author", node.author);
            }
            if (!node.keywords.equals("")) {
                control.setValue("keywords", node.keywords);
            }
            if (!node.level.equals("")) {
                control.setValue("level", node.level);
            }
            if (!node.languages.equals("")) {
                control.setValue("languages", node.languages);
            }
            if (!node.comment.equals("")) {
                control.setValue("comment", node.comment);
            }
            if (!node.appletWidth.equals("")) {
                control.setValue("applet_width", node.appletWidth);
            }
            if (!node.appletHeight.equals("")) {
                control.setValue("applet_height", node.appletHeight);
            }
            if (node.children != null) {
                ArrayList<Object> children = new ArrayList<Object>();
                Enumeration<TreeNode> e = node.children();
                boolean saveAll = node.isSavingHiddenNodes();
                while (e.hasMoreElements()) {
                    LaunchNode child = (LaunchNode)e.nextElement();
                    if (!saveAll && child.isHiddenInLauncher()) continue;
                    if (node.isPreviewing()) {
                        children.add(child);
                        continue;
                    }
                    if (child.fileName != null && !node.isSelfContained()) {
                        children.add(child.fileName);
                        continue;
                    }
                    child.fileName = null;
                    child.setSelfContained(false);
                    children.add(child);
                }
                if (children.size() > 0) {
                    control.setValue("child_nodes", children);
                }
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            String name = control.getString("name");
            if (name == null) {
                name = LaunchRes.getString("NewNode.Name");
            }
            return new LaunchNode(name);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            ArrayList children;
            String height;
            String width;
            String comment;
            String lang;
            String level;
            String keywords;
            String author;
            String[] args;
            String url;
            String xsetName;
            String tooltip;
            String description;
            LaunchNode node = (LaunchNode)obj;
            String name = control.getString("name");
            if (name != null) {
                node.name = name;
            }
            if ((description = control.getString("description")) != null) {
                node.description = description;
            }
            if ((tooltip = control.getString("tooltip")) != null) {
                node.tooltip = tooltip;
            }
            if ((xsetName = control.getString("launchset")) != null) {
                node.xsetName = xsetName;
            }
            if ((url = control.getString("url")) != null) {
                String[][] stringArray = new String[1][];
                String[] stringArray2 = new String[2];
                stringArray2[1] = url;
                stringArray[0] = stringArray2;
                node.setDisplayData(stringArray);
            } else {
                if (control.getPropertyNamesRaw().contains("html")) {
                    node.setDisplayData((String[][])control.getObject("html"));
                } else {
                    node.setDisplayData((String[][])control.getObject("display_tabs"));
                }
                node.setDisplayArgs((String[][])control.getObject("display_args"));
            }
            node.setClassPath(control.getString("classpath"));
            String className = control.getString("launch_class");
            if (className != null) {
                node.launchClassName = className;
                node.launchModelScroller = null;
            }
            if ((args = (String[])control.getObject("launch_args")) != null) {
                node.setArgs(args);
            }
            node.hiddenWhenRoot = control.getBoolean("root_hidden");
            node.buttonView = control.getBoolean("button_view");
            node.singleton = control.getBoolean("singleton");
            node.singleVM = control.getBoolean("single_vm");
            node.singleVMOff = control.getBoolean("single_vm_off");
            node.showLog = control.getBoolean("show_log");
            node.clearLog = control.getBoolean("clear_log");
            node.singleApp = control.getBoolean("single_app");
            node.singleAppOff = control.getBoolean("single_app_off");
            node.hiddenInLauncher = control.getBoolean("hidden_in_launcher");
            Level logLevel = OSPLog.parseLevel(control.getString("log_level"));
            if (logLevel != null) {
                node.logLevel = logLevel;
            }
            if ((author = control.getString("author")) != null) {
                node.author = author;
            }
            if ((keywords = control.getString("keywords")) != null) {
                node.keywords = keywords;
            }
            if ((level = control.getString("level")) != null) {
                node.level = level;
            }
            if ((lang = control.getString("languages")) != null) {
                node.languages = lang;
            }
            if ((comment = control.getString("comment")) != null) {
                node.comment = comment;
            }
            if ((width = control.getString("applet_width")) != null) {
                node.appletWidth = width;
            }
            if ((height = control.getString("applet_height")) != null) {
                node.appletHeight = height;
            }
            if ((name = control.getString("filename")) != null) {
                node.setFileName(name);
            }
            if ((children = (ArrayList)control.getObject("child_nodes")) != null) {
                node.removeAllChildren();
                for (Object next : children) {
                    Class<?> type;
                    LaunchNode root;
                    if (next instanceof LaunchNode) {
                        LaunchNode child = (LaunchNode)next;
                        node.add(child);
                        child.setLaunchClass(child.launchClassName);
                        continue;
                    }
                    if (!(next instanceof String)) continue;
                    String fileName = (String)next;
                    String path = XML.getResolvedPath(fileName, Launcher.tabSetBasePath);
                    ResourceLoader.addSearchPath(Launcher.resourcesPath);
                    ResourceLoader.addSearchPath(Launcher.tabSetBasePath);
                    XMLControlElement childControl = new XMLControlElement();
                    String absolutePath = childControl.read(path);
                    if (childControl.failedToRead()) {
                        JOptionPane.showMessageDialog(null, String.valueOf(LaunchRes.getString("Dialog.InvalidXML.Message")) + " \"" + fileName + "\"", LaunchRes.getString("Dialog.InvalidXML.Title"), 2);
                    }
                    if ((root = (LaunchNode)node.getRoot()).getChildNode(fileName) != null || fileName.equals(root.fileName) || !LaunchNode.class.isAssignableFrom(type = childControl.getObjectClass())) continue;
                    LaunchNode child = new LaunchNode(LaunchRes.getString("NewNode.Name"));
                    child.setFileName(fileName);
                    OSPLog.finest(String.valueOf(LaunchRes.getString("Log.Message.Loading")) + ": " + absolutePath);
                    node.add(child);
                    childControl.loadObject(child);
                }
            }
            return node;
        }
    }
}

