/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.LaunchBuilder;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.LauncherUndo;
import org.opensourcephysics.tools.ResourceLoader;

public class LaunchPanel
extends JPanel {
    protected static final String TEXT_TYPE = "text";
    protected JTree tree;
    protected DefaultTreeModel treeModel;
    protected JSplitPane splitPane;
    protected JPanel dataPanel;
    protected JTabbedPane tabbedPane;
    protected JEditorPane descriptionPane;
    protected JScrollPane descriptionScroller;
    protected boolean showAllNodes;
    protected Map<LaunchNode, VisibleNode> visibleNodeMap = new HashMap<LaunchNode, VisibleNode>();
    protected Launcher launcher;
    protected boolean rebuildingTabs;
    protected Map<String, String> htmlSubstitutions = new TreeMap<String, String>();
    private String noTitle;
    public boolean isSelectingNode;

    public LaunchPanel(LaunchNode rootNode, Launcher launcher2) {
        this.showAllNodes = launcher2 instanceof LaunchBuilder;
        this.launcher = launcher2;
        this.createGUI();
        this.createTree(rootNode);
        this.setTreeSelectionPath(rootNode);
    }

    public void setTreeSelectionPath(LaunchNode node) {
        if (node == null) {
            return;
        }
        if (node == this.getSelectedNode()) {
            this.rebuildAndDisplayTabs(node);
        } else {
            this.tree.setSelectionPath(new TreePath(node.getPath()));
        }
    }

    public void setTreeSelectionPaths(ArrayList<LaunchNode> nodes) {
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        TreePath[] paths = new TreePath[nodes.size()];
        int i = 0;
        for (LaunchNode node : nodes) {
            paths[i++] = new TreePath(node.getPath());
        }
        this.tree.setSelectionPaths(paths);
    }

    public void setSelectedNode(LaunchNode node, int tabNumber) {
        this.setSelectedNode(node, tabNumber, null);
    }

    public void setSelectedNode(LaunchNode node, int tabNumber, URL url) {
        String scrollRef;
        node.tabNumber = url == null && node.getDisplayTabCount() == 0 ? -1 : tabNumber;
        LaunchNode.DisplayTab htmlData = null;
        URL prevURL = null;
        LaunchNode node0 = this.getSelectedNode();
        if (node.tabNumber >= 0) {
            htmlData = node.tabData.get(node.tabNumber);
        }
        if (htmlData != null) {
            prevURL = htmlData.url;
        }
        if (url != null) {
            node.setURL(url);
            if (htmlData != null) {
                htmlData.url = url;
            }
        }
        String string = scrollRef = node0 == node && url != null && prevURL != null && url.getPath().equals(prevURL.getPath()) ? "#" : null;
        if (scrollRef == null) {
            this.setTreeSelectionPath(node);
        } else if (url != null) {
            this.setTreeSelectionPath(node);
        }
        if (htmlData != null) {
            htmlData.url = prevURL;
        }
    }

    public LaunchNode getSelectedNode() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (LaunchNode)path.getLastPathComponent();
    }

    public ArrayList<LaunchNode> getSelectedNodes() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        ArrayList<LaunchNode> temp = new ArrayList<LaunchNode>();
        int i = 0;
        while (i < paths.length) {
            temp.add((LaunchNode)paths[i].getLastPathComponent());
            ++i;
        }
        ArrayList<LaunchNode> nodes = new ArrayList<LaunchNode>();
        Enumeration<TreeNode> e = this.getRootNode().preorderEnumeration();
        while (e.hasMoreElements()) {
            LaunchNode next = (LaunchNode)e.nextElement();
            if (!temp.contains(next)) continue;
            nodes.add(next);
        }
        return nodes;
    }

    public int getSelectedDisplayTab() {
        return this.tabbedPane.getSelectedIndex();
    }

    public LaunchNode getRootNode() {
        return (LaunchNode)this.treeModel.getRoot();
    }

    public Map<String, String> getHTMLSubstitutionMap() {
        return this.htmlSubstitutions;
    }

    protected LaunchNode getClone(LaunchNode node) {
        if (node.getFileName() == null) {
            return null;
        }
        Enumeration<TreeNode> e = this.getRootNode().breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            LaunchNode next = (LaunchNode)e.nextElement();
            if (!node.getFileName().equals(next.getFileName())) continue;
            return next;
        }
        return null;
    }

    protected void rebuildAndDisplayTabs(LaunchNode node) {
        if (node == null) {
            return;
        }
        OSPLog.finer(String.valueOf(LaunchRes.getString("Log.Message.NodeSelected")) + " " + node);
        boolean isBuilder = this.launcher instanceof LaunchBuilder;
        URL url = node.isDisplayable ? node.getURL() : null;
        int tabNumber = node.tabNumber;
        boolean hasModel = false;
        if (url == null && node.getDisplayTabCount() > 0) {
            LaunchNode.DisplayTab displayTab;
            int k = 0;
            int i = tabNumber;
            while (i < node.getDisplayTabCount()) {
                LaunchNode.DisplayTab tab = node.getDisplayTab(i);
                if (tab == null || tab.isDisplayable) break;
                ++i;
                ++k;
            }
            if ((displayTab = node.getDisplayTab((tabNumber = Math.max(0, tabNumber)) + k)) != null) {
                if (displayTab.url == null) {
                    hasModel = displayTab.getModelClass() != null;
                } else if (displayTab.isDisplayable) {
                    url = displayTab.url;
                }
            }
        }
        this.rebuildingTabs = true;
        int tabCount = 0;
        if (!isBuilder) {
            this.tabbedPane.removeAll();
        }
        this.noTitle = LaunchRes.getString("HTMLTab.Title.Untitled");
        for (LaunchNode.DisplayTab displayTab : node.tabData) {
            if (displayTab.isDisplayable) {
                if (displayTab.urlExists()) {
                    Launcher.HTMLPane html = this.launcher.getHTMLTab(tabCount);
                    URL theURL = tabNumber == tabCount && url != null ? url : displayTab.url;
                    SwingUtilities.invokeLater(() -> this.launchHtml(html, theURL, displayTab.hyperlinksEnabled && launchNode.enabled));
                    if (isBuilder) continue;
                    this.addTab(displayTab, html.scroller);
                    ++tabCount;
                    continue;
                }
                OSPLog.fine(String.valueOf(LaunchRes.getString("Log.Message.BadURL")) + " " + displayTab.url);
                continue;
            }
            if (displayTab.getModelScroller() == null || isBuilder) continue;
            this.addTab(displayTab, displayTab.getModelScroller());
            ++tabCount;
        }
        if (!isBuilder) {
            if (url != null || hasModel) {
                if (this.tabbedPane.getTabCount() == 1 && this.tabbedPane.getTitleAt(0).equals(this.noTitle)) {
                    this.splitPane.setRightComponent(this.tabbedPane.getComponentAt(0));
                } else if (this.tabbedPane.getTabCount() > 0) {
                    this.splitPane.setRightComponent(this.tabbedPane);
                    if (this.tabbedPane.getTabCount() > tabNumber) {
                        this.tabbedPane.setSelectedIndex(tabNumber);
                    }
                }
            } else {
                JScrollPane launchPane = node.getLaunchModelScroller();
                if (launchPane != null) {
                    this.splitPane.setRightComponent(launchPane);
                } else {
                    this.descriptionPane.setText(node.description);
                    this.splitPane.setRightComponent(this.descriptionScroller);
                }
            }
        }
        this.tabbedPane.setVisible(this.tabbedPane.getTabCount() > 1);
        this.rebuildingTabs = false;
        this.launcher.refreshGUI();
    }

    private void addTab(LaunchNode.DisplayTab displayTab, JScrollPane scroller) {
        String title = displayTab.getTitle() == null ? this.noTitle : displayTab.getTitle();
        this.tabbedPane.addTab(title, scroller);
    }

    protected void launchHtml(Launcher.HTMLPane html, URL theURL, boolean nodeEnabled) {
        try {
            if (this.htmlSubstitutions.isEmpty()) {
                html.editorPane.setPage(theURL);
            } else {
                Scanner scanner = new Scanner(ResourceLoader.openStream(theURL), "UTF-8");
                String text = scanner.useDelimiter("\\A").next();
                scanner.close();
                for (String target : this.htmlSubstitutions.keySet()) {
                    String newValue = this.htmlSubstitutions.get(target);
                    text = text.replaceAll(target, newValue);
                }
                HTMLDocument doc = (HTMLDocument)html.editorPane.getDocument();
                doc.setBase(theURL);
                doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
                html.editorPane.setText(text);
                html.editorPane.setCaretPosition(0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (theURL.getRef() != null) {
            html.editorPane.scrollToReference(theURL.getRef());
            if (FontSizer.getLevel() > 0) {
                OSPRuntime.trigger(100, e -> hTMLPane.editorPane.scrollToReference(theURL.getRef()));
            }
        }
        this.launcher.setLinksEnabled(html.editorPane, nodeEnabled);
    }

    protected void createGUI() {
        this.setPreferredSize(new Dimension(400, 200));
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane();
        this.add((Component)this.splitPane, "Center");
        this.dataPanel = new JPanel(new BorderLayout());
        this.descriptionPane = GUIUtils.newJTextPane();
        this.descriptionPane.setEditable(false);
        this.descriptionPane.setContentType(TEXT_TYPE);
        this.descriptionScroller = new JScrollPane(this.descriptionPane);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LaunchNode node = LaunchPanel.this.getSelectedNode();
                if (node != null && node == LaunchPanel.this.launcher.selectedNode) {
                    URL htmlURL = node.getURL();
                    if (LaunchPanel.this.rebuildingTabs && htmlURL != null) {
                        return;
                    }
                    node.prevTabNumber = node.tabNumber;
                    node.prevURL = htmlURL;
                    int n = Math.max(0, LaunchPanel.this.tabbedPane.getSelectedIndex());
                    int n2 = node.tabNumber = node.tabData.isEmpty() ? -1 : n;
                    if (node.tabNumber > -1) {
                        LaunchNode.DisplayTab displayTab = node.getDisplayTab(node.tabNumber);
                        if (displayTab.url != null) {
                            node.setURL(displayTab.url);
                        } else {
                            Launcher.HTMLPane tab = LaunchPanel.this.launcher.getHTMLTab(node.tabNumber);
                            node.setURL(tab.editorPane.getPage());
                        }
                    }
                }
            }
        });
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LaunchNode node = LaunchPanel.this.getSelectedNode();
                if (node != null && LaunchPanel.this.launcher.postEdits) {
                    String nodePath = node.getPathString();
                    Integer undoPage = node.prevTabNumber;
                    Integer redoPage = node.tabNumber;
                    Object[] objectArray = new Object[4];
                    objectArray[1] = nodePath;
                    objectArray[2] = undoPage;
                    objectArray[3] = node.prevURL;
                    Object[] undoData = objectArray;
                    Object[] objectArray2 = new Object[4];
                    objectArray2[1] = nodePath;
                    objectArray2[2] = redoPage;
                    objectArray2[3] = node.getURL();
                    Object[] redoData = objectArray2;
                    LauncherUndo launcherUndo = LaunchPanel.this.launcher.undoManager;
                    launcherUndo.getClass();
                    LauncherUndo.NavEdit edit = new LauncherUndo.NavEdit(launcherUndo, undoData, redoData);
                    LaunchPanel.this.launcher.undoSupport.postEdit(edit);
                }
            }
        });
        this.splitPane.setRightComponent(this.dataPanel);
        this.splitPane.setDividerLocation(160);
    }

    protected void createTree(LaunchNode rootNode) {
        if (!this.showAllNodes) {
            VisibleNode visibleRoot = new VisibleNode(rootNode);
            this.visibleNodeMap.put(rootNode, visibleRoot);
            this.addVisibleNodes(visibleRoot);
        }
        this.treeModel = new LaunchTreeModel(rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setToolTipText("");
        this.tree.setRootVisible(!rootNode.hiddenWhenRoot);
        if (this.launcher instanceof LaunchBuilder) {
            this.tree.getSelectionModel().setSelectionMode(4);
        } else {
            this.tree.getSelectionModel().setSelectionMode(1);
        }
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath treePath;
                LaunchNode node = LaunchPanel.this.launcher.getSelectedNode();
                if (LaunchPanel.this.launcher.postEdits && (treePath = e.getOldLeadSelectionPath()) != null && node != null) {
                    LaunchNode prevNode = (LaunchNode)treePath.getLastPathComponent();
                    if (!node.tabData.isEmpty()) {
                        int page = Math.max(0, node.tabNumber);
                        LaunchNode.DisplayTab htmlData = node.tabData.get(page);
                        node.setURL(htmlData.url);
                        node.tabNumber = page;
                    }
                    LauncherUndo launcherUndo = LaunchPanel.this.launcher.undoManager;
                    launcherUndo.getClass();
                    LauncherUndo.NavEdit edit = new LauncherUndo.NavEdit(launcherUndo, prevNode, node);
                    LaunchPanel.this.launcher.undoSupport.postEdit(edit);
                }
                LaunchPanel.this.rebuildAndDisplayTabs(node);
            }
        });
        JScrollPane treeScroller = new JScrollPane(this.tree);
        this.splitPane.setLeftComponent(treeScroller);
    }

    protected Collection<String> getExpandedNodes() {
        ArrayList<String> list = new ArrayList<String>();
        TreePath path = new TreePath(this.getRootNode());
        Enumeration<TreePath> en = this.tree.getExpandedDescendants(path);
        while (en != null && en.hasMoreElements()) {
            TreePath next = en.nextElement();
            LaunchNode node = (LaunchNode)next.getLastPathComponent();
            list.add(node.getPathString());
        }
        return list;
    }

    protected void setExpandedNodes(Collection<?> expanded) {
        Iterator<?> it = expanded.iterator();
        while (it.hasNext()) {
            String path = it.next().toString();
            Enumeration<TreeNode> e = this.getRootNode().breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                LaunchNode node = (LaunchNode)e.nextElement();
                if (!path.equals(node.getPathString())) continue;
                TreePath treePath = new TreePath(node.getPath());
                this.tree.expandPath(treePath);
            }
        }
    }

    private void addVisibleNodes(VisibleNode visibleParent) {
        int n = visibleParent.node.getChildCount();
        int i = 0;
        while (i < n) {
            LaunchNode child = (LaunchNode)visibleParent.node.getChildAt(i);
            if (!child.isHiddenInLauncher()) {
                VisibleNode visibleChild = new VisibleNode(child);
                this.visibleNodeMap.put(child, visibleChild);
                visibleParent.add(visibleChild);
                this.addVisibleNodes(visibleChild);
            }
            ++i;
        }
    }

    class LaunchTreeModel
    extends DefaultTreeModel {
        LaunchTreeModel(LaunchNode root) {
            super(root);
        }

        @Override
        public Object getChild(Object parent, int index) {
            VisibleNode visibleChild;
            if (LaunchPanel.this.showAllNodes) {
                return super.getChild(parent, index);
            }
            VisibleNode visibleParent = LaunchPanel.this.visibleNodeMap.get(parent);
            if (visibleParent != null && (visibleChild = (VisibleNode)visibleParent.getChildAt(index)) != null) {
                return visibleChild.node;
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (LaunchPanel.this.showAllNodes) {
                return super.getChildCount(parent);
            }
            VisibleNode visibleParent = LaunchPanel.this.visibleNodeMap.get(parent);
            if (visibleParent != null) {
                return visibleParent.getChildCount();
            }
            return 0;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (LaunchPanel.this.showAllNodes) {
                return super.getIndexOfChild(parent, child);
            }
            VisibleNode visibleParent = LaunchPanel.this.visibleNodeMap.get(parent);
            VisibleNode visibleChild = LaunchPanel.this.visibleNodeMap.get(child);
            if (visibleParent != null && visibleChild != null) {
                return visibleParent.getIndex(visibleChild);
            }
            return -1;
        }
    }

    private class VisibleNode
    extends DefaultMutableTreeNode {
        LaunchNode node;

        VisibleNode(LaunchNode node) {
            this.node = node;
        }
    }
}

