/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

public class LaunchRes {
    static Locale resourceLocale = Locale.ENGLISH;
    static final String BUNDLE_NAME = "org.opensourcephysics.resources.tools.launcher";
    static ResourceLoader.Bundle res;
    static PropertyChangeSupport support;

    static {
        support = new SwingPropertyChangeSupport(new LaunchRes());
        String language = Locale.getDefault().getLanguage();
        resourceLocale = Locale.ENGLISH;
        Locale[] localeArray = OSPRuntime.getInstalledLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            if (locale.getLanguage().equals(language)) {
                resourceLocale = locale;
                break;
            }
            ++n2;
        }
        res = ResourceLoader.getBundle(BUNDLE_NAME, resourceLocale);
    }

    public static void setLocale(Locale loc) {
        if (resourceLocale == loc) {
            return;
        }
        Locale prev = resourceLocale;
        resourceLocale = loc;
        res = ResourceLoader.getBundle(BUNDLE_NAME, resourceLocale);
        support.firePropertyChange("locale", prev, resourceLocale);
        ToolsRes.setLocale(loc);
    }

    private LaunchRes() {
    }

    static String getString(String key) {
        try {
            return res.getString(key);
        }
        catch (MissingResourceException ex) {
            return "!" + key + "!";
        }
    }

    public static void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        if (property.equals("locale")) {
            support.addPropertyChangeListener(property, listener);
        }
    }

    public static void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        support.removePropertyChangeListener(property, listener);
    }
}

