/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JComponent;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.LaunchClassChooser;
import org.opensourcephysics.tools.Launcher;

class LaunchableClassMap
extends TreeMap<String, Class<?>> {
    ClassLoader classLoader;
    String[] jarOrDirectoryNames;
    boolean allLoaded = false;
    TreeMap<String, Class<?>> models = new TreeMap();

    LaunchableClassMap(String[] names) {
        this.jarOrDirectoryNames = names;
        ArrayList<URL> urls = new ArrayList<URL>();
        String basePath = LaunchClassChooser.baseDirectoryPath;
        if (basePath == null) {
            basePath = OSPRuntime.getLaunchJarDirectory();
        }
        int i = 0;
        while (i < names.length) {
            String path = XML.getResolvedPath(names[i], basePath);
            if (!path.endsWith(".jar") && !path.endsWith("/")) {
                path = String.valueOf(path) + "/";
            }
            try {
                urls.add(new URL("file:" + path));
            }
            catch (MalformedURLException ex) {
                OSPLog.info(ex + " " + path);
            }
            ++i;
        }
        this.classLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]));
    }

    Class<?> smartLoadClass(String name) throws ClassNotFoundException {
        try {
            return this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return this.getClass().getClassLoader().loadClass(name);
        }
    }

    ArrayList<File> getClassFiles(File directory) {
        ArrayList<File> files = new ArrayList<File>();
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File next = fileArray[n2];
            if (next.isDirectory()) {
                files.addAll(this.getClassFiles(next));
            } else if (next.getName().endsWith(".class")) {
                files.add(next);
            }
            ++n2;
        }
        return files;
    }

    void loadAllClasses() {
        if (this.allLoaded) {
            return;
        }
        String[] stringArray = this.jarOrDirectoryNames;
        int n = this.jarOrDirectoryNames.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            if (next.indexOf(".jar") > -1) {
                JarFile jar = null;
                try {
                    if (!OSPRuntime.isApplet) {
                        String basePath = LaunchClassChooser.baseDirectoryPath;
                        if (basePath == null) {
                            basePath = OSPRuntime.getLaunchJarDirectory();
                        }
                        String path = XML.getResolvedPath(next, basePath);
                        jar = new JarFile(path);
                    } else {
                        String path = XML.getResolvedPath(next, OSPRuntime.applet.getCodeBase().toExternalForm());
                        URL url = new URL("jar:" + path + "!/");
                        JarURLConnection conn = (JarURLConnection)url.openConnection();
                        jar = conn.getJarFile();
                    }
                }
                catch (Exception ex) {
                    OSPLog.info(String.valueOf(ex.getClass().getName()) + ": " + ex.getMessage());
                }
                if (jar != null) {
                    Enumeration<JarEntry> e = jar.entries();
                    while (e.hasMoreElements()) {
                        JarEntry entry = e.nextElement();
                        String name = entry.getName();
                        if (!name.endsWith(".class")) continue;
                        this.loadClass(name);
                    }
                }
            } else {
                String basePath = LaunchClassChooser.baseDirectoryPath;
                if (basePath == null) {
                    basePath = OSPRuntime.getLaunchJarDirectory();
                }
                String directoryPath = XML.getResolvedPath(next, basePath);
                for (File nextFile : this.getClassFiles(new File(directoryPath))) {
                    String name = XML.getPathRelativeTo(nextFile.getPath(), directoryPath);
                    this.loadClass(name);
                }
            }
            ++n2;
        }
        this.allLoaded = true;
    }

    void loadClass(String name) {
        if (name.indexOf("$") == -1) {
            name = name.substring(0, name.indexOf(".class"));
            int j = name.indexOf("/");
            while (j != -1) {
                name = String.valueOf(name.substring(0, j)) + "." + name.substring(j + 1);
                j = name.indexOf("/");
            }
            if (this.get(name) != null || this.models.get(name) != null) {
                return;
            }
            try {
                Class<?> nextClass = this.smartLoadClass(name);
                if (Launcher.isLaunchable(nextClass)) {
                    this.put(name, nextClass);
                }
                if (Launcher.isModel(nextClass)) {
                    this.models.put(name, nextClass);
                }
            }
            catch (ClassNotFoundException nextClass) {
            }
            catch (NoClassDefFoundError err) {
                OSPLog.info(err.toString());
            }
        }
    }

    boolean includesJar(String jarName) {
        int i = 0;
        while (i < this.jarOrDirectoryNames.length) {
            if (this.jarOrDirectoryNames[i].equals(jarName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    Class<?> getClass(String className) {
        Class<?> type = (Class<?>)this.get(className);
        if (type != null || this.allLoaded) {
            return type;
        }
        try {
            type = this.smartLoadClass(className);
            if (Launcher.isLaunchable(type)) {
                return type;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError err) {
            OSPLog.info(err.toString());
        }
        return null;
    }

    Class<?> getModelClass(String className) {
        Class<?> type = this.models.get(className);
        if (type != null) {
            return type;
        }
        try {
            type = this.smartLoadClass(className);
            if (Launcher.isModel(type)) {
                return type;
            }
            if (JComponent.class.isAssignableFrom(type)) {
                try {
                    type.getConstructor(null);
                    return type;
                }
                catch (Exception exception) {}
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError err) {
            OSPLog.info(err.toString());
        }
        return null;
    }

    Class<?> getClassOfType(String className, Class<?> type) {
        try {
            Class<?> theClass = this.smartLoadClass(className);
            if (type.isAssignableFrom(theClass)) {
                return theClass;
            }
        }
        catch (ClassNotFoundException theClass) {
        }
        catch (NoClassDefFoundError err) {
            OSPLog.info(err.toString());
        }
        return null;
    }
}

