/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.controls.Cryptic;
import org.opensourcephysics.controls.MessageFrame;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.Password;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTable;
import org.opensourcephysics.controls.XMLTableInspector;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.AppFrame;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PrintUtils;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.tools.Diagnostics;
import org.opensourcephysics.tools.EjsTool;
import org.opensourcephysics.tools.EncryptionTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.LaunchBuilder;
import org.opensourcephysics.tools.LaunchClassChooser;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.LaunchPanel;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.LauncherUndo;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class Launcher {
    protected static ResizableIcon defaultIcon;
    protected static Launcher mainLauncher;
    protected static String defaultFileName;
    protected static String resourcesPath;
    protected static String classPath;
    protected static String tabSetBasePath;
    protected static String releaseDate;
    protected static JFileChooser chooser;
    protected static FileFilter xmlFileFilter;
    protected static FileFilter xsetFileFilter;
    protected static FileFilter launcherFileFilter;
    protected static int wInit;
    protected static int hInit;
    protected static JDialog splashDialog;
    protected static JLabel creditsLabel;
    protected static JLabel splashTitleLabel;
    protected static JLabel splashPathLabel;
    protected static Timer splashTimer;
    protected static float baseMenuFontSize;
    protected static ResizableIcon launchIcon;
    protected static ResizableIcon launchedIcon;
    protected static ResizableIcon singletonIcon;
    protected static ResizableIcon whiteFolderIcon;
    protected static ResizableIcon redFileIcon;
    protected static ResizableIcon greenFileIcon;
    protected static ResizableIcon magentaFileIcon;
    protected static ResizableIcon yellowFileIcon;
    protected static ResizableIcon whiteFileIcon;
    protected static ResizableIcon noFileIcon;
    protected static ResizableIcon ghostFileIcon;
    protected static ResizableIcon redFolderIcon;
    protected static ResizableIcon greenFolderIcon;
    protected static ResizableIcon yellowFolderIcon;
    protected static ResizableIcon linkIcon;
    protected static ResizableIcon htmlIcon;
    protected static ResizableIcon launchEmptyIcon;
    protected static ResizableIcon ejsIcon;
    protected static ResizableIcon navOpenIcon;
    protected static ResizableIcon navClosedIcon;
    protected static ResizableIcon backIcon;
    protected static ResizableIcon forwardIcon;
    protected static ResizableIcon backDisabledIcon;
    protected static ResizableIcon forwardDisabledIcon;
    public static boolean singleAppMode;
    private static boolean newVMAllowed;
    protected static Timer frameFinder;
    protected static ArrayList<Frame> existingFrames;
    protected static String[] extractExtensions;
    protected static Set<String> passwords;
    private boolean canExit = true;
    protected JDialog xmlInspector;
    protected JDialog tableInspector;
    protected int divider = 160;
    public LauncherFrame frame;
    public boolean popupEnabled = true;
    protected boolean postEdits = true;
    protected JPanel contentPane;
    protected JTabbedPane tabbedPane;
    protected boolean navigationVisible = true;
    protected JToolBar navbar;
    protected JButton navButton;
    protected JButton backButton;
    protected JButton forwardButton;
    protected Component navSpacer = Box.createHorizontalGlue();
    protected Component[] navbarAddOns;
    protected JMenuItem singleAppItem;
    protected LaunchNode selectedNode;
    protected LaunchNode previousNode;
    protected String tabSetName;
    protected JTextPane textPane;
    protected JScrollPane textScroller;
    protected boolean showText = true;
    protected ArrayList<HTMLPane> htmlTabList = new ArrayList();
    protected JMenu fileMenu;
    protected JMenu displayMenu;
    protected JMenu helpMenu;
    protected JMenuItem openItem;
    protected JMenu openFromJarMenu;
    protected JMenuItem passwordItem;
    protected JMenuItem closeTabItem;
    protected JMenuItem closeAllItem;
    protected JMenuItem editItem;
    protected JMenuItem exitItem;
    protected JMenuItem inspectItem;
    protected JMenuItem hideItem;
    protected JMenuItem backItem;
    protected JMenu languageMenu;
    protected JMenuItem sizeUpItem;
    protected JMenuItem sizeDownItem;
    protected JMenu lookFeelMenu;
    protected ButtonGroup specificLFGroup;
    protected ButtonGroup genericLFGroup;
    protected JMenuItem javaLFItem;
    protected JMenuItem systemLFItem;
    protected JMenuItem defaultLFItem;
    protected JMenuItem lookFeelItem;
    protected JMenuItem logItem;
    protected JMenuItem aboutItem;
    protected JMenuItem authorInfoItem;
    protected JMenu diagnosticMenu;
    protected JMenuItem[] languageItems;
    protected LaunchClassChooser classChooser;
    protected JPopupMenu popup = new JPopupMenu();
    protected Set<String> openPaths = new HashSet<String>();
    protected Launcher spawner;
    protected boolean previewing = false;
    protected boolean editorEnabled = true;
    protected Set<String> changedFiles = new HashSet<String>();
    protected MouseListener tabListener;
    protected boolean newNodeSelected = false;
    protected boolean selfContained = false;
    protected String jarBasePath = null;
    protected String title;
    protected ArrayList<Component> tabs = new ArrayList();
    protected LauncherUndo undoManager;
    protected UndoableEditSupport undoSupport;
    protected String password;
    protected boolean pwRequiredToLoad;
    protected HyperlinkListener linkListener;
    protected boolean saveState = true;
    protected String lookAndFeel;
    protected Collection<?>[] expansions;
    protected String selectedPath;
    protected JButton memoryButton;
    protected int xsetMemorySize;

    static {
        defaultFileName = "launcher_default";
        resourcesPath = "/org/opensourcephysics/resources/tools/";
        tabSetBasePath = "";
        releaseDate = "July 2007";
        wInit = 480;
        hInit = 400;
        singleAppMode = false;
        newVMAllowed = false;
        existingFrames = new ArrayList();
        extractExtensions = new String[]{"pdf", "txt", "doc"};
        passwords = new HashSet<String>();
        OSPRuntime.setAuthorMode(false);
        OSPRuntime.setLauncherMode(true);
        String[] stringArray = extractExtensions;
        int n = extractExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            ResourceLoader.addExtractExtension(ext);
            ++n2;
        }
        launchIcon = Launcher.loadIcon("launch.gif");
        launchIcon = Launcher.loadIcon("launch.gif");
        launchedIcon = Launcher.loadIcon("launched.gif");
        singletonIcon = Launcher.loadIcon("singleton.gif");
        noFileIcon = Launcher.loadIcon("nofile.gif");
        greenFileIcon = Launcher.loadIcon("greenfile.gif");
        magentaFileIcon = Launcher.loadIcon("magentafile.gif");
        linkIcon = Launcher.loadIcon("link.gif");
        htmlIcon = Launcher.loadIcon("html.gif");
        launchEmptyIcon = Launcher.loadIcon("launchempty.gif");
        ejsIcon = Launcher.loadIcon("launchEJS.gif");
        whiteFolderIcon = Launcher.loadIcon("whitefolder.gif");
        navOpenIcon = Launcher.loadIcon("nav_open.gif");
        navClosedIcon = Launcher.loadIcon("nav_closed.gif");
        backIcon = Launcher.loadIcon("undo.gif");
        forwardIcon = Launcher.loadIcon("redo.gif");
        backDisabledIcon = Launcher.loadIcon("undodisabled.gif");
        forwardDisabledIcon = Launcher.loadIcon("redodisabled.gif");
    }

    public Launcher() {
        this(true);
    }

    public Launcher(boolean splash) {
        this.createGUI(splash);
        XML.setLoader(LaunchSet.class, new LaunchSet());
        if (!OSPRuntime.isJS && !OSPRuntime.isApplet) {
            Runnable launchRunner = new Runnable(){

                @Override
                public void run() {
                    if (OSPRuntime.isVista() || OSPRuntime.isLinux()) {
                        return;
                    }
                    try {
                        Process proc = Runtime.getRuntime().exec("java");
                        newVMAllowed = true;
                        proc.destroy();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            try {
                Thread thread = new Thread(launchRunner);
                thread.start();
                if (!OSPRuntime.isJS) {
                    thread.join(5000L);
                }
            }
            catch (InterruptedException thread) {
                // empty catch block
            }
        }
        if (FontSizer.getLevel() != 0) {
            this.setFontLevel(FontSizer.getLevel());
        } else {
            this.refreshStringResources();
            this.refreshGUI();
        }
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.frame.getBounds().width) / 2;
        int y = (dim.height - this.frame.getBounds().height) / 2;
        this.frame.setLocation(x, y);
    }

    public Launcher(String fileName) {
        this(fileName, fileName == null || !fileName.startsWith("<?xml"));
    }

    public Launcher(String help_path, boolean splash) {
        this(help_path, splash, null);
    }

    public Launcher(String fileName, boolean splash, JPanel contentPane) {
        this.contentPane = contentPane;
        this.createGUI(splash);
        XML.setLoader(LaunchSet.class, new LaunchSet());
        String path = null;
        if (fileName == null) {
            if (OSPRuntime.getLaunchJarName() != null) {
                fileName = String.valueOf(XML.stripExtension(OSPRuntime.getLaunchJarName())) + ".xset";
                path = this.open(fileName);
            }
            if (path == null) {
                fileName = String.valueOf(defaultFileName) + ".xset";
                path = this.open(fileName);
            }
            if (path == null) {
                fileName = String.valueOf(defaultFileName) + ".xml";
                path = this.open(fileName);
            }
        } else {
            path = this.open(fileName);
        }
        if (FontSizer.getLevel() != 0) {
            this.setFontLevel(FontSizer.getLevel());
        } else {
            this.refreshStringResources();
            this.refreshGUI();
        }
        if (this.frame != null) {
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.frame.getBounds().width) / 2;
            int y = (dim.height - this.frame.getBounds().height) / 2;
            this.frame.setLocation(x, y);
        }
    }

    public void setCanExit(boolean _can) {
        this.canExit = _can;
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public Dimension getSize() {
        return this.frame == null ? this.contentPane.getPreferredSize() : this.contentPane.getSize();
    }

    public void setSize(Dimension dim) {
        this.contentPane.setPreferredSize(dim);
        if (this.frame != null) {
            this.frame.pack();
        }
    }

    public int getDivider() {
        return this.divider;
    }

    public void setDivider(int loc) {
        this.divider = loc;
        this.refreshGUI();
    }

    public boolean isVisible() {
        return this.frame.isVisible();
    }

    public void setVisible(boolean visible) {
        this.frame.setVisible(visible);
    }

    public void setNavigationVisible(boolean vis) {
        this.navigationVisible = vis;
        LaunchNode node = this.getSelectedNode();
        if (node != null && node.isButtonView()) {
            this.showButtonView(node);
        } else {
            this.showTabbedPaneView();
        }
    }

    public void clearHistory() {
        this.undoManager.discardAllEdits();
        this.backButton.setEnabled(false);
        this.forwardButton.setEnabled(false);
    }

    public void setEditorEnabled(boolean enabled) {
        this.editorEnabled = enabled;
    }

    public void setHyperlinksEnabled(boolean enabled) {
        int i = 0;
        while (i < this.getTabCount()) {
            LaunchPanel tab = this.getTab(i);
            Enumeration<TreeNode> e = tab.getRootNode().breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                LaunchNode next = (LaunchNode)e.nextElement();
                this.setHyperlinksEnabled(next, enabled);
            }
            ++i;
        }
    }

    public void setHyperlinksEnabled(LaunchNode node, boolean enabled) {
        int i = 0;
        while (i < node.getDisplayTabCount()) {
            LaunchNode.DisplayTab html = node.getDisplayTab(i);
            html.hyperlinksEnabled = enabled;
            ++i;
        }
    }

    public LaunchPanel getSelectedTab() {
        return (LaunchPanel)this.tabbedPane.getSelectedComponent();
    }

    public LaunchPanel setSelectedTab(String path) {
        if (path == null) {
            return null;
        }
        String rootName = path;
        int n = path.indexOf("/");
        if (n > -1) {
            rootName = path.substring(0, n);
        }
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            LaunchPanel tab = this.getTab(i);
            if (rootName.equals(tab.getRootNode().name)) {
                tab.isSelectingNode = true;
                this.tabbedPane.setSelectedComponent(tab);
                tab.isSelectingNode = false;
                return tab;
            }
            ++i;
        }
        return null;
    }

    public LaunchPanel setSelectedTab(LaunchPanel tab) {
        this.tabbedPane.setSelectedComponent(tab);
        return tab == this.tabbedPane.getSelectedComponent() ? tab : null;
    }

    public LaunchNode getSelectedNode() {
        this.selectedNode = this.getSelectedTab() == null ? null : this.getSelectedTab().getSelectedNode();
        return this.selectedNode;
    }

    public LaunchNode setSelectedNode(String path) {
        return this.setSelectedNode(path, 0, null);
    }

    public LaunchNode setSelectedNode(String path, int tabNumber) {
        return this.setSelectedNode(path, tabNumber, null);
    }

    public LaunchNode setSelectedNode(String path, int tabNumber, URL url) {
        if (path == null) {
            return null;
        }
        path = XML.forwardSlash(path);
        this.setSelectedTab(path);
        LaunchPanel tab = this.getSelectedTab();
        if (tab == null) {
            return null;
        }
        Enumeration<TreeNode> e = tab.getRootNode().breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            LaunchNode node = (LaunchNode)e.nextElement();
            if (!path.equals(node.getPathString())) continue;
            tab.setSelectedNode(node, tabNumber, url);
            return node;
        }
        return null;
    }

    public LaunchNode setSelectedNodeByKey(String keywords, int tabNumber) {
        if (keywords == null || keywords.equals("")) {
            return null;
        }
        String anchor = null;
        int n = keywords.indexOf("#");
        if (n > -1) {
            anchor = keywords.substring(n);
            keywords = keywords.substring(0, n);
        }
        int i = 0;
        while (i < this.getTabCount()) {
            LaunchPanel tab = this.getTab(i);
            Enumeration<TreeNode> e = tab.getRootNode().breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                LaunchNode node = (LaunchNode)e.nextElement();
                if (!keywords.equals(node.keywords)) continue;
                this.setSelectedTab(tab);
                URL url = node.getDisplayTab((int)tabNumber).url;
                if (url != null && anchor != null) {
                    try {
                        url = new URL(url, anchor);
                        tab.setSelectedNode(node, tabNumber, url);
                        return node;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                tab.setSelectedNode(node, tabNumber);
                return node;
            }
            ++i;
        }
        return null;
    }

    public LaunchNode getRootNode() {
        if (this.getSelectedTab() == null) {
            return null;
        }
        return this.getSelectedTab().getRootNode();
    }

    public int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public LaunchPanel getTab(int i) {
        if (i >= this.tabbedPane.getTabCount()) {
            return null;
        }
        return (LaunchPanel)this.tabbedPane.getComponentAt(i);
    }

    public HTMLPane getHTMLTab(int i) {
        while (i >= this.htmlTabList.size()) {
            this.htmlTabList.add(new HTMLPane());
        }
        return this.htmlTabList.get(i);
    }

    public int getHTMLTabCount() {
        return this.htmlTabList.size();
    }

    public String open(String[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        String path = this.open(args[0]);
        if (args.length > 1 && args[1] != null) {
            this.setSelectedNode(args[1]);
        }
        return path;
    }

    public String open(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        ResourceLoader.addSearchPath(resourcesPath);
        ResourceLoader.addSearchPath(tabSetBasePath);
        String path = name;
        String absolutePath = "";
        XMLControlElement control = new XMLControlElement();
        if (name.startsWith("<?xml")) {
            control.readXML(name);
            if (control.failedToRead()) {
                return null;
            }
        }
        if (control.getObjectClassName().equals(Object.class.getName())) {
            String jarBase = OSPRuntime.getLaunchJarDirectory();
            absolutePath = control.read(XML.getResolvedPath(path, jarBase));
            if (control.failedToRead()) {
                absolutePath = control.read(path);
            }
        }
        if (control.failedToRead()) {
            String jar = XML.stripExtension(OSPRuntime.getLaunchJarName());
            if (!name.startsWith(defaultFileName) && jar != null && !name.startsWith(jar)) {
                OSPLog.info(String.valueOf(LaunchRes.getString("Log.Message.InvalidXML")) + " " + name);
                JOptionPane.showMessageDialog(null, String.valueOf(LaunchRes.getString("Dialog.InvalidXML.Message")) + " \"" + name + "\"", LaunchRes.getString("Dialog.InvalidXML.Title"), 2);
            }
            return null;
        }
        OSPLog.fine(name);
        String returnPath = XML.forwardSlash(absolutePath);
        String jarName = LaunchRes.getString("Splash.Label.Internal");
        int zip = Math.max(returnPath.indexOf("jar!"), returnPath.indexOf("zip!"));
        zip = Math.max(zip, returnPath.indexOf("trz!"));
        if (zip > -1) {
            jarName = XML.getName(returnPath.substring(0, zip + 3));
            String s = XML.getDirectoryPath(returnPath.substring(0, zip + 3));
            this.jarBasePath = s.equals("") ? XML.forwardSlash(System.getProperty("user.dir", "")) : s;
            returnPath = returnPath.substring(zip + 5);
        } else {
            this.jarBasePath = null;
        }
        Class<?> type = control.getObjectClass();
        if (LaunchSet.class.equals(type)) {
            LaunchNode root;
            if (!returnPath.equals("") && splashDialog != null && splashDialog.isVisible()) {
                Resource res = ResourceLoader.getResource(path);
                String loading = String.valueOf(LaunchRes.getString("Log.Message.Loading")) + ": ";
                if (res.getFile() != null) {
                    OSPLog.info(String.valueOf(loading) + res.getAbsolutePath());
                    splashDialog.getContentPane().setBackground(new Color(242, 242, 255));
                    splashPathLabel.setIcon(magentaFileIcon);
                    splashPathLabel.setText(String.valueOf(loading) + name);
                } else {
                    boolean internal;
                    loading = String.valueOf(LaunchRes.getString("Log.Message.LoadingFrom")) + " " + jarName + ": " + name;
                    boolean bl = internal = jarName.equals(LaunchRes.getString("Splash.Label.Internal")) || jarName.equals(OSPRuntime.getLaunchJarName());
                    if (internal) {
                        splashDialog.getContentPane().setBackground(new Color(255, 255, 228));
                        splashPathLabel.setIcon(greenFileIcon);
                    } else {
                        splashDialog.getContentPane().setBackground(new Color(242, 242, 255));
                        splashPathLabel.setIcon(magentaFileIcon);
                    }
                    splashPathLabel.setText(loading);
                    loading = String.valueOf(LaunchRes.getString("Log.Message.Loading")) + ": ";
                    OSPLog.info(String.valueOf(loading) + res.getAbsolutePath());
                }
            }
            if (!this.removeAllTabs()) {
                return null;
            }
            this.tabSetName = XML.getName(returnPath);
            if (!returnPath.equals("")) {
                tabSetBasePath = this.jarBasePath != null ? "" : XML.getDirectoryPath(returnPath);
            }
            OSPLog.finest(String.valueOf(LaunchRes.getString("Log.Message.Loading")) + ": " + returnPath);
            boolean post = this.postEdits;
            this.postEdits = false;
            LaunchSet tabset = new LaunchSet(this, this.tabSetName);
            control.loadObject(tabset);
            if (tabset.failedToLoad) {
                if (this.tabSetName.equals(XML.getName(returnPath))) {
                    this.tabSetName = null;
                }
                returnPath = null;
            } else if (splashDialog != null && splashDialog.isVisible() && (root = this.getRootNode()) != null && !root.getAuthor().trim().equals("")) {
                String by = String.valueOf(LaunchRes.getString("Label.Author")) + ": ";
                creditsLabel.setText(String.valueOf(by) + root.getAuthor());
            }
            this.changedFiles.clear();
            OSPLog.fine("returning " + returnPath);
            this.postEdits = post;
            return returnPath;
        }
        if (LaunchNode.class.equals(type)) {
            OSPLog.finest(String.valueOf(LaunchRes.getString("Log.Message.Loading")) + ": " + path);
            LaunchNode node = new LaunchNode(LaunchRes.getString("NewNode.Name"));
            node.setFileName(XML.getPathRelativeTo(returnPath, tabSetBasePath));
            control.loadObject(node);
            String tabName = Launcher.getDisplayName(returnPath);
            int i = 0;
            while (i < this.tabbedPane.getComponentCount()) {
                LaunchNode root;
                if (this.tabbedPane.getTitleAt(i).equals(tabName) && (root = ((LaunchPanel)this.tabbedPane.getComponent(i)).getRootNode()).matches(node)) {
                    this.tabbedPane.setSelectedIndex(i);
                    return null;
                }
                ++i;
            }
            this.postEdits = false;
            if (this.tabSetName == null) {
                this.tabSetName = LaunchRes.getString("Tabset.Name.New");
                this.title = null;
                tabSetBasePath = XML.getDirectoryPath(returnPath);
                this.editorEnabled = true;
            }
            this.addTab(node);
            Enumeration<TreeNode> e = node.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                LaunchNode next = (LaunchNode)e.nextElement();
                next.setLaunchClass(next.launchClassName);
            }
            this.postEdits = true;
            return returnPath;
        }
        OSPLog.info(LaunchRes.getString("Log.Message.NotLauncherFile"));
        if (name.length() > 20) {
            name = String.valueOf(name.substring(0, 20)) + "...";
        }
        JOptionPane.showMessageDialog(null, String.valueOf(LaunchRes.getString("Dialog.NotLauncherFile.Message")) + " \"" + name + "\"", LaunchRes.getString("Dialog.NotLauncherFile.Title"), 2);
        return null;
    }

    public void setNavbarRightEndComponents(Component[] comps) {
        Component c;
        int n;
        int n2;
        Component[] componentArray;
        if (this.navbar.getComponentCount() > 1 && this.navbarAddOns != null) {
            this.navbar.remove(this.navSpacer);
            componentArray = this.navbarAddOns;
            n2 = this.navbarAddOns.length;
            n = 0;
            while (n < n2) {
                c = componentArray[n];
                if (c != null) {
                    this.navbar.remove(c);
                }
                ++n;
            }
        }
        this.navbarAddOns = comps;
        if (this.navbar.getComponentCount() > 1 && this.navbarAddOns != null) {
            this.navbar.add(this.navSpacer);
            componentArray = this.navbarAddOns;
            n2 = this.navbarAddOns.length;
            n = 0;
            while (n < n2) {
                c = componentArray[n];
                if (c != null) {
                    this.navbar.add(c);
                }
                ++n;
            }
        }
        this.navbar.revalidate();
    }

    public boolean addTab(LaunchNode root) {
        final LaunchPanel tab = new LaunchPanel(root, this);
        this.tabs.add(tab);
        if (root.isHiddenInLauncher() && !(this instanceof LaunchBuilder)) {
            return false;
        }
        tab.tree.setCellRenderer(new LaunchRenderer());
        tab.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Launcher.this.newNodeSelected = true;
                Launcher.this.refreshGUI();
            }
        });
        tab.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (splashDialog != null) {
                    splashDialog.dispose();
                }
                tab.tree.removeMouseListener(this);
            }
        });
        tab.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Launcher.this.popup.removeAll();
                Launcher.this.handleMousePressed(e, tab);
            }
        });
        this.tabbedPane.addTab(root.toString(), tab);
        this.tabbedPane.setSelectedComponent(tab);
        tab.setTreeSelectionPath(root);
        if (!root.tooltip.equals("")) {
            this.tabbedPane.setToolTipTextAt(this.tabbedPane.getSelectedIndex(), root.tooltip);
        }
        tab.dataPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Launcher.this.divider = tab.splitPane.getDividerLocation();
            }
        });
        return true;
    }

    protected void showButtonView(final LaunchNode node) {
        LaunchNode.DisplayTab tab = node.getDisplayTab(0);
        if (tab != null && tab.url != null) {
            this.setLinksEnabled(this.textPane, node.enabled && tab.hyperlinksEnabled);
            if (tab.urlExists()) {
                URL url = tab.url;
                SwingUtilities.invokeLater(() -> {
                    try {
                        this.textPane.setPage(url);
                    }
                    catch (IOException ex) {
                        OSPLog.fine(String.valueOf(LaunchRes.getString("Log.Message.BadURL")) + " " + url);
                    }
                });
            } else {
                OSPLog.finest(String.valueOf(LaunchRes.getString("Log.Message.BadURL")) + " " + tab.url);
                if (this.showText) {
                    this.textPane.setContentType("text");
                    this.textPane.setText(node.description);
                }
            }
        } else if (this.showText) {
            this.textPane.setContentType("text");
            this.textPane.setText(node.description);
        }
        this.contentPane.removeAll();
        if (this.navigationVisible && !(this instanceof LaunchBuilder)) {
            this.contentPane.add((Component)this.navbar, "North");
        }
        this.contentPane.add((Component)this.textScroller, "Center");
        JPanel box = new JPanel();
        this.contentPane.add((Component)box, "South");
        AbstractAction openAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = Integer.parseInt(e.getActionCommand());
                LaunchNode child = (LaunchNode)node.getChildAt(i);
                if (child.getLaunchClass() == null) {
                    String[] prevArgs = Launcher.this.undoManager.getLauncherState();
                    if (Launcher.this.open(child.args) != null) {
                        if (prevArgs != null) {
                            LauncherUndo launcherUndo = Launcher.this.undoManager;
                            launcherUndo.getClass();
                            LauncherUndo.LoadEdit edit = new LauncherUndo.LoadEdit(launcherUndo, child.args, prevArgs);
                            Launcher.this.undoSupport.postEdit(edit);
                        }
                        Launcher.this.refreshGUI();
                    }
                } else {
                    child.launch();
                }
            }
        };
        int i = 0;
        while (i < node.getChildCount()) {
            LaunchNode child = (LaunchNode)node.getChildAt(i);
            JButton button = new JButton(child.name);
            button.addActionListener(openAction);
            button.setActionCommand(String.valueOf(i));
            button.setToolTipText(child.tooltip);
            button.setEnabled(node.enabled);
            box.add(button);
            ++i;
        }
        this.frame.validate();
        this.refreshGUI();
        this.frame.repaint();
    }

    protected void showTabbedPaneView() {
        this.contentPane.removeAll();
        if (this.navigationVisible && !(this instanceof LaunchBuilder)) {
            this.contentPane.add((Component)this.navbar, "North");
        }
        this.contentPane.add((Component)this.tabbedPane, "Center");
        if (this.frame == null) {
            return;
        }
        this.frame.validate();
        this.refreshGUI();
        this.frame.repaint();
    }

    protected String open() {
        Launcher.getXMLChooser().setFileFilter(launcherFileFilter);
        int result = Launcher.getXMLChooser().showOpenDialog(null);
        if (result == 0) {
            File file = Launcher.getXMLChooser().getSelectedFile();
            String fileName = XML.forwardSlash(file.getAbsolutePath());
            OSPRuntime.chooserDir = XML.getDirectoryPath(fileName);
            return this.open(fileName);
        }
        return null;
    }

    public boolean removeSelectedTab() {
        int i = this.tabbedPane.getSelectedIndex();
        if (i < 0) {
            return false;
        }
        String[] prevArgs = this.undoManager.getLauncherState();
        this.tabs.remove(this.getTab(i));
        this.tabbedPane.removeTabAt(i);
        this.previousNode = this.selectedNode;
        this.newNodeSelected = true;
        if (this.tabbedPane.getTabCount() == 0) {
            this.tabSetName = null;
            this.title = null;
            if (prevArgs != null) {
                LauncherUndo launcherUndo = this.undoManager;
                launcherUndo.getClass();
                LauncherUndo.LoadEdit edit = new LauncherUndo.LoadEdit(launcherUndo, null, prevArgs);
                this.undoSupport.postEdit(edit);
            }
        }
        this.refreshGUI();
        return true;
    }

    protected boolean removeAllTabs() {
        int n = this.tabbedPane.getTabCount();
        if (n == 0) {
            return true;
        }
        boolean post = this.postEdits;
        this.postEdits = false;
        int i = n - 1;
        while (i >= 0) {
            this.tabbedPane.removeTabAt(i);
            --i;
        }
        if (this.tabbedPane.getTabCount() == 0) {
            this.tabSetName = null;
            this.title = null;
            this.password = null;
        } else {
            this.previousNode = this.selectedNode;
            this.newNodeSelected = true;
        }
        this.refreshGUI();
        this.tabs.clear();
        i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            this.tabs.add(this.tabbedPane.getComponentAt(i));
            ++i;
        }
        this.postEdits = post;
        return this.tabbedPane.getTabCount() == 0;
    }

    protected void refreshStringResources() {
        if (this.frame == null) {
            return;
        }
        this.fileMenu.setText(LaunchRes.getString("Menu.File"));
        this.displayMenu.setText(LaunchRes.getString("Menu.Display"));
        this.openItem.setText(LaunchRes.getString("Menu.File.Open"));
        this.passwordItem.setText(LaunchRes.getString("Launcher.MenuItem.EnterPassword"));
        this.closeTabItem.setText(LaunchRes.getString("Menu.File.CloseTab"));
        this.closeAllItem.setText(LaunchRes.getString("Menu.File.CloseAll"));
        this.editItem.setText(LaunchRes.getString("Menu.File.Edit"));
        this.backItem.setText(LaunchRes.getString("Menu.File.Back"));
        this.helpMenu.setText(LaunchRes.getString("Menu.Help"));
        this.logItem.setText(LaunchRes.getString("Menu.Help.MessageLog"));
        this.inspectItem.setText(LaunchRes.getString("Menu.Help.Inspect"));
        String s = XML.getSimpleClassName(this.getClass());
        String about = String.valueOf(LaunchRes.getString("Menu.Help.About")) + " " + s + "...";
        this.aboutItem.setText(about);
        String authorInfo = String.valueOf(LaunchRes.getString("Menu.Help.AuthorInfo")) + "...";
        LaunchNode node = this.getSelectedNode();
        if (node != null) {
            authorInfo = String.valueOf(LaunchRes.getString("Help.About.Title")) + " \"" + node.getName() + "\"...";
        }
        this.authorInfoItem.setText(authorInfo);
        this.diagnosticMenu.setText(LaunchRes.getString("Menu.Help.Diagnostics"));
        if (this.exitItem != null) {
            this.exitItem.setText(LaunchRes.getString("Menu.File.Exit"));
        }
        this.languageMenu.setText(LaunchRes.getString("Menu.Display.Language"));
        this.sizeUpItem.setText(LaunchRes.getString("Menu.Display.IncreaseFontSize"));
        this.sizeDownItem.setText(LaunchRes.getString("Menu.Display.DecreaseFontSize"));
        this.lookFeelMenu.setText(LaunchRes.getString("Menu.Display.LookFeel"));
        this.javaLFItem.setText(LaunchRes.getString("MenuItem.JavaLookFeel"));
        this.systemLFItem.setText(LaunchRes.getString("MenuItem.SystemLookFeel"));
        this.defaultLFItem.setText(LaunchRes.getString("MenuItem.DefaultLookFeel"));
        if (this.openFromJarMenu != null) {
            this.openFromJarMenu.setText(LaunchRes.getString("Menu.File.OpenFromJar"));
        }
        Locale[] locales = OSPRuntime.getInstalledLocales();
        int i = 0;
        while (i < locales.length) {
            if (locales[i].getLanguage().equals(LaunchRes.resourceLocale.getLanguage())) {
                this.languageItems[i].setSelected(true);
            }
            ++i;
        }
    }

    protected void refreshGUI() {
        boolean rootDisabled;
        this.refreshMemoryButton();
        LaunchPanel tab = this.getSelectedTab();
        boolean bl = rootDisabled = tab != null && !tab.getRootNode().enabled;
        if (tab != null) {
            tab.tree.setEnabled(tab.getRootNode().enabled);
            this.tabbedPane.setEnabled(tab.getRootNode().enabled);
            tab.splitPane.setDividerLocation(this.divider);
        }
        this.backButton.setEnabled(this.undoManager.canUndo());
        this.forwardButton.setEnabled(this.undoManager.canRedo());
        if (this.frame != null) {
            String name = this.title == null ? this.tabSetName : this.title;
            name = name == null ? LaunchRes.getString("Frame.Title") : String.valueOf(LaunchRes.getString("Frame.Title")) + ": " + name;
            if (rootDisabled) {
                name = String.valueOf(name) + " " + LaunchRes.getString("Launcher.Title.NeedsPassword");
            }
            this.frame.setTitle(name);
            this.fileMenu.removeAll();
            if (this.undoManager.canReload()) {
                this.fileMenu.add(this.backItem);
            }
            if (!OSPRuntime.isApplet) {
                if (this.fileMenu.getItemCount() > 0) {
                    this.fileMenu.addSeparator();
                }
                this.fileMenu.add(this.openItem);
            }
            if (this.openFromJarMenu != null) {
                this.fileMenu.add(this.openFromJarMenu);
            }
            if (rootDisabled) {
                this.fileMenu.add(this.passwordItem);
            }
            if (OSPRuntime.isApplet) {
                this.fileMenu.add(this.hideItem);
                return;
            }
            if (tab != null) {
                if (this.fileMenu.getItemCount() > 0) {
                    this.fileMenu.addSeparator();
                }
                boolean showCloseTab = true;
                if (this.getClass() == Launcher.class) {
                    if (tab.getRootNode().isButtonView()) {
                        showCloseTab = false;
                        name = String.valueOf(LaunchRes.getString("Frame.Title")) + ": " + tab.getRootNode().name;
                    } else if (this.tabbedPane.getTabCount() == 1) {
                        showCloseTab = false;
                    }
                }
                if (showCloseTab) {
                    this.fileMenu.add(this.closeTabItem);
                    this.closeAllItem.setText(LaunchRes.getString("Menu.File.CloseAll"));
                } else {
                    this.closeAllItem.setText(LaunchRes.getString("MenuItem.Close"));
                }
                this.fileMenu.add(this.closeAllItem);
            }
            if (this.editorEnabled && !OSPRuntime.isWebStart() && !rootDisabled) {
                this.fileMenu.addSeparator();
                this.fileMenu.add(this.editItem);
            }
            JMenu printMenu = new JMenu(DisplayRes.getString("DrawingFrame.Print_menu_title"));
            JMenuItem printFrameItem = new JMenuItem(DisplayRes.getString("DrawingFrame.PrintFrame_menu_item"));
            JMenuItem saveFrameAsEPSItem = new JMenuItem(DisplayRes.getString("DrawingFrame.SaveFrameAsEPS_menu_item"));
            printMenu.add(printFrameItem);
            printMenu.add(saveFrameAsEPSItem);
            this.fileMenu.add(printMenu);
            printFrameItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrintUtils.printComponent(Launcher.this.frame);
                }
            });
            saveFrameAsEPSItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        PrintUtils.saveComponentAsEPS(Launcher.this.frame);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            this.fileMenu.addSeparator();
            if (this.exitItem != null) {
                this.fileMenu.add(this.exitItem);
            }
            boolean rootEnabled = this.getRootNode() != null && this.getRootNode().enabled;
            this.inspectItem.setEnabled(rootEnabled && (this.password == null || this instanceof LaunchBuilder));
            this.sizeDownItem.setEnabled((float)this.fileMenu.getFont().getSize() > baseMenuFontSize);
        }
    }

    private void appletGUI() {
        this.hideItem = new JMenuItem(LaunchRes.getString("Menu.File.Hide"));
        this.hideItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Launcher.this.exit();
            }
        });
    }

    protected void createGUI(boolean splash) {
        this.appletGUI();
        Frame[] frames = Frame.getFrames();
        int i = 0;
        int n = frames.length;
        while (i < n) {
            existingFrames.add(frames[i]);
            ++i;
        }
        OSPLog.getOSPLog();
        OSPRuntime.getTranslator();
        this.undoManager = new LauncherUndo(this);
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoManager);
        if (this.contentPane == null) {
            this.frame = new LauncherFrame();
            existingFrames.add(this.frame);
            if (splash && !OSPRuntime.isApplet) {
                this.splash();
            }
            this.xmlInspector = new JDialog((Frame)this.frame, false);
            this.xmlInspector.setSize(new Dimension(600, 300));
            this.tableInspector = new XMLTableInspector(true, false);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.xmlInspector.getBounds().width) / 2;
            int y = (dim.height - this.xmlInspector.getBounds().height) / 2;
            this.xmlInspector.setLocation(x, y);
            x = (dim.width - this.tableInspector.getBounds().width) / 2;
            y = (dim.height - this.tableInspector.getBounds().height) / 2;
            this.tableInspector.setLocation(x, y);
            this.contentPane = new JPanel(new BorderLayout());
            this.contentPane.setPreferredSize(new Dimension(wInit, hInit));
            this.frame.setContentPane(this.contentPane);
            this.frame.setDefaultCloseOperation(1);
        }
        this.navbar = new JToolBar();
        this.navbar.setFloatable(false);
        this.navbar.setBorder(BorderFactory.createEtchedBorder());
        this.navButton = new JButton(navOpenIcon);
        this.navButton.setBorder(BorderFactory.createEmptyBorder());
        this.navButton.setBorderPainted(false);
        this.navButton.setOpaque(false);
        this.navButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Launcher.this.navbar.getComponentCount() > 1) {
                    Launcher.this.navbar.remove(Launcher.this.backButton);
                    Launcher.this.navbar.remove(Launcher.this.forwardButton);
                    Launcher.this.navbar.remove(Launcher.this.navSpacer);
                    if (Launcher.this.navbarAddOns != null) {
                        Component[] componentArray = Launcher.this.navbarAddOns;
                        int n = Launcher.this.navbarAddOns.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Component c = componentArray[n2];
                            if (c != null) {
                                Launcher.this.navbar.remove(c);
                            }
                            ++n2;
                        }
                    }
                    Launcher.this.navButton.setIcon(navClosedIcon);
                } else {
                    Launcher.this.navbar.add(Launcher.this.backButton);
                    Launcher.this.navbar.add(Launcher.this.forwardButton);
                    if (Launcher.this.navbarAddOns != null) {
                        Launcher.this.navbar.add(Launcher.this.navSpacer);
                        Component[] componentArray = Launcher.this.navbarAddOns;
                        int n = Launcher.this.navbarAddOns.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Component c = componentArray[n3];
                            if (c != null) {
                                Launcher.this.navbar.add(c);
                            }
                            ++n3;
                        }
                    }
                    Launcher.this.navButton.setIcon(navOpenIcon);
                }
                Launcher.this.navbar.revalidate();
            }
        });
        this.navbar.add(this.navButton);
        this.backButton = new JButton(backIcon);
        this.backButton.setDisabledIcon(backDisabledIcon);
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Launcher.this.undoManager.undo();
                Launcher.this.refreshGUI();
            }
        });
        this.navbar.add(this.backButton);
        this.forwardButton = new JButton(forwardIcon);
        this.forwardButton.setDisabledIcon(forwardDisabledIcon);
        this.forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Launcher.this.undoManager.redo();
                Launcher.this.refreshGUI();
            }
        });
        this.navbar.add(this.forwardButton);
        this.backButton.setEnabled(false);
        this.forwardButton.setEnabled(false);
        this.memoryButton = new JButton();
        this.memoryButton.setOpaque(false);
        this.memoryButton.setBorderPainted(false);
        Border space = BorderFactory.createEmptyBorder(2, 4, 2, 3);
        Border line = BorderFactory.createLineBorder(Color.GRAY);
        this.memoryButton.setBorder(BorderFactory.createCompoundBorder(line, space));
        Font font = this.memoryButton.getFont();
        this.memoryButton.setFont(font.deriveFont(0, font.getSize() - 1));
        this.memoryButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Launcher.this.refreshMemoryButton();
                Launcher.this.memoryButton.setBorderPainted(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Launcher.this.memoryButton.setBorderPainted(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int[] sizes;
                JPopupMenu popup = new JPopupMenu();
                JMenu menu = new JMenu(LaunchRes.getString("Launcher.Button.Memory.Popup.Relaunch"));
                ActionListener relauncher = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JMenuItem item = (JMenuItem)e.getSource();
                        String text = item.getText();
                        text = text.substring(0, text.length() - 2);
                        long memorySize = Long.parseLong(text);
                        Launcher.relaunch(null, memorySize, (this).Launcher.this.frame);
                    }
                };
                long memSize = 512L;
                if (!OSPRuntime.isJS) {
                    MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
                    memSize = memory.getHeapMemoryUsage().getMax() / 0x100000L;
                }
                int[] nArray = sizes = new int[]{64, 125, 250, 500, 1000};
                int n = sizes.length;
                int n2 = 0;
                while (n2 < n) {
                    int next = nArray[n2];
                    if (Launcher.this.xsetMemorySize < 9 * next / 10 && (memSize < (long)(9 * next / 10) || memSize > (long)(11 * next / 10))) {
                        JMenuItem item = new JMenuItem(String.valueOf(next) + "MB");
                        item.addActionListener(relauncher);
                        menu.add(item);
                    }
                    ++n2;
                }
                if (menu.getItemCount() > 0) {
                    popup.add(menu);
                    popup.show(Launcher.this.memoryButton, 0, Launcher.this.memoryButton.getHeight());
                }
            }
        });
        Component[] comps = new Component[]{Box.createHorizontalGlue(), this.memoryButton, Box.createHorizontalStrut(2)};
        this.setNavbarRightEndComponents(comps);
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.textScroller = new JScrollPane(this.textPane);
        this.tabbedPane = new JTabbedPane(3);
        this.contentPane.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Launcher.this.previousNode = Launcher.this.selectedNode;
                Launcher.this.selectedNode = Launcher.this.getSelectedNode();
                Launcher.this.newNodeSelected = true;
                Launcher.this.refreshSelectedTab();
                if (Launcher.this.previousNode != null && Launcher.this.selectedNode != null) {
                    if (Launcher.this.selectedNode.getURL() == null && !Launcher.this.selectedNode.tabData.isEmpty()) {
                        int page = Math.max(0, Launcher.this.selectedNode.tabNumber);
                        LaunchNode.DisplayTab htmlData = Launcher.this.selectedNode.tabData.get(page);
                        Launcher.this.selectedNode.setURL(htmlData.url);
                        Launcher.this.selectedNode.tabNumber = page;
                    }
                    if (Launcher.this.postEdits) {
                        LauncherUndo launcherUndo = Launcher.this.undoManager;
                        launcherUndo.getClass();
                        LauncherUndo.NavEdit edit = new LauncherUndo.NavEdit(launcherUndo, Launcher.this.previousNode, Launcher.this.selectedNode);
                        Launcher.this.undoSupport.postEdit(edit);
                    }
                }
                Launcher.this.refreshGUI();
            }
        });
        this.tabListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (Launcher.this.frame == null) {
                    return;
                }
                if (OSPRuntime.isPopupTrigger(e)) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem item = new JMenuItem(LaunchRes.getString("MenuItem.Close"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Launcher.this.removeSelectedTab();
                        }
                    });
                    popup.add(item);
                    popup.show(Launcher.this.tabbedPane, e.getX(), e.getY() + 8);
                }
            }
        };
        this.tabbedPane.addMouseListener(this.tabListener);
        if (this.frame != null) {
            JarFile jar;
            JMenuBar menubar = new JMenuBar();
            this.fileMenu = new JMenu();
            this.fileMenu.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (splashDialog != null) {
                        splashDialog.dispose();
                    }
                    Launcher.this.fileMenu.removeMouseListener(this);
                }
            });
            menubar.add(this.fileMenu);
            this.openItem = new JMenuItem();
            int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, mask));
            this.openItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[] prevArgs = Launcher.this.undoManager.getLauncherState();
                    if (prevArgs != null) {
                        String fileName = Launcher.this.open();
                        if (fileName != null) {
                            String[] args = new String[]{fileName};
                            LauncherUndo launcherUndo = Launcher.this.undoManager;
                            launcherUndo.getClass();
                            LauncherUndo.LoadEdit edit = new LauncherUndo.LoadEdit(launcherUndo, args, prevArgs);
                            Launcher.this.undoSupport.postEdit(edit);
                            Launcher.this.refreshGUI();
                        }
                    } else {
                        Launcher.this.open();
                        Launcher.this.refreshGUI();
                    }
                }
            });
            this.passwordItem = new JMenuItem();
            this.passwordItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Password.verify(Launcher.this.password, Launcher.this.tabSetName)) {
                        passwords.add(Launcher.this.password);
                        Launcher.this.getRootNode().enabled = true;
                        if (Launcher.this.expansions != null) {
                            int i = 0;
                            while (i < Launcher.this.expansions.length) {
                                Launcher.this.getTab(i).setExpandedNodes(Launcher.this.expansions[i]);
                                ++i;
                            }
                        }
                        if (Launcher.this.selectedPath != null) {
                            Launcher.this.setSelectedNode(Launcher.this.selectedPath);
                        }
                        Launcher.this.changedFiles.clear();
                        Launcher.this.refreshSelectedTab();
                        Launcher.this.frame.validate();
                    }
                }
            });
            this.closeTabItem = new JMenuItem();
            this.closeTabItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Launcher.this.removeSelectedTab();
                }
            });
            this.closeAllItem = new JMenuItem();
            this.closeAllItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[] prevArgs = Launcher.this.undoManager.getLauncherState();
                    if (Launcher.this.removeAllTabs() && prevArgs != null) {
                        LauncherUndo launcherUndo = Launcher.this.undoManager;
                        launcherUndo.getClass();
                        LauncherUndo.LoadEdit edit = new LauncherUndo.LoadEdit(launcherUndo, null, prevArgs);
                        Launcher.this.undoSupport.postEdit(edit);
                    }
                    Launcher.this.refreshGUI();
                }
            });
            this.editItem = new JMenuItem();
            this.editItem.setAccelerator(KeyStroke.getKeyStroke(69, mask));
            if (OSPRuntime.isWebStart()) {
                this.editItem.setEnabled(false);
            }
            this.editItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Launcher.this.password != null && !Launcher.this.pwRequiredToLoad && !Password.verify(Launcher.this.password, Launcher.this.tabSetName)) {
                        return;
                    }
                    if (Launcher.this.previewing) {
                        LaunchNode node;
                        Launcher.this.previewing = false;
                        if (Launcher.this.spawner != null && (node = Launcher.this.getSelectedNode()) != null) {
                            Launcher.this.spawner.setSelectedNode(node.getPathString());
                        }
                        Launcher.this.exit();
                    } else {
                        LaunchBuilder builder;
                        if (Launcher.this.tabSetName == null) {
                            builder = new LaunchBuilder(false);
                            builder.newItem.doClick();
                        } else {
                            LaunchSet tabset = new LaunchSet(Launcher.this, Launcher.this.tabSetName);
                            XMLControlElement control = new XMLControlElement(tabset);
                            control.setPassword(null);
                            builder = new LaunchBuilder(control.toXML());
                            LaunchNode node = Launcher.this.getSelectedNode();
                            if (node != null) {
                                builder.setSelectedNode(node.getPathString());
                            }
                            builder.tabSetName = Launcher.this.tabSetName;
                            builder.password = Launcher.this.password;
                        }
                        builder.spawner = Launcher.this;
                        builder.jarBasePath = Launcher.this.jarBasePath;
                        Point p = Launcher.this.frame.getLocation();
                        builder.frame.setLocation(p.x + 24, p.y + 24);
                        builder.frame.setVisible(true);
                        builder.frame.pack();
                        builder.frame.setDefaultCloseOperation(0);
                    }
                }
            });
            this.backItem = new JMenuItem();
            this.backItem.setAccelerator(KeyStroke.getKeyStroke(37, mask));
            this.backItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Launcher.this.undoManager.undo();
                    Launcher.this.refreshGUI();
                }
            });
            this.displayMenu = new JMenu();
            menubar.add(this.displayMenu);
            LaunchRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    Launcher.this.refreshStringResources();
                    Launcher.this.refreshGUI();
                }
            });
            this.languageMenu = new JMenu();
            final Locale[] locales = OSPRuntime.getInstalledLocales();
            AbstractAction languageAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String language = e.getActionCommand();
                    OSPLog.finest("setting language to " + language);
                    int i = 0;
                    while (i < locales.length) {
                        if (language.equals(locales[i].getDisplayName())) {
                            LaunchRes.setLocale(locales[i]);
                            return;
                        }
                        ++i;
                    }
                }
            };
            ButtonGroup languageGroup = new ButtonGroup();
            this.languageItems = new JMenuItem[locales.length];
            int i2 = 0;
            while (i2 < locales.length) {
                this.languageItems[i2] = new JRadioButtonMenuItem(OSPRuntime.getDisplayLanguage(locales[i2]));
                this.languageItems[i2].setActionCommand(locales[i2].getDisplayName());
                this.languageItems[i2].addActionListener(languageAction);
                this.languageMenu.add(this.languageItems[i2]);
                languageGroup.add(this.languageItems[i2]);
                ++i2;
            }
            this.displayMenu.add(this.languageMenu);
            this.displayMenu.addSeparator();
            FontSizer.addListener("level", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    int level = (Integer)e.getNewValue();
                    Launcher.this.setFontLevel(level);
                }
            });
            this.sizeUpItem = new JMenuItem();
            this.sizeUpItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FontSizer.levelUp();
                }
            });
            this.displayMenu.add(this.sizeUpItem);
            this.sizeDownItem = new JMenuItem();
            this.sizeDownItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FontSizer.levelDown();
                }
            });
            this.displayMenu.add(this.sizeDownItem);
            this.displayMenu.addSeparator();
            this.lookFeelMenu = new JMenu();
            this.displayMenu.add(this.lookFeelMenu);
            AbstractAction lfAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Launcher.this.setLookAndFeel(e.getActionCommand(), false);
                }
            };
            String currentLF = UIManager.getLookAndFeel().getClass().getName();
            this.specificLFGroup = new ButtonGroup();
            UIManager.LookAndFeelInfo[] lfInfo = UIManager.getInstalledLookAndFeels();
            int i3 = 0;
            while (i3 < lfInfo.length) {
                String command;
                String next = lfInfo[i3].getClassName();
                Object object = next.indexOf("Nimbus") > -1 ? "NIMBUS" : (next.indexOf("GTK") > -1 ? "GTK" : (next.indexOf("Motif") > -1 ? "MOTIF" : (next.indexOf("WindowsClassic") > -1 ? null : (next.indexOf("Windows") > -1 ? "WINDOWS" : (command = next.indexOf("Metal") > -1 ? "METAL" : null)))));
                if (command != null) {
                    String name = XML.getName(lfInfo[i3].getName());
                    JRadioButtonMenuItem item = new JRadioButtonMenuItem(name);
                    this.specificLFGroup.add(item);
                    item.setActionCommand(command);
                    item.addActionListener(lfAction);
                    this.lookFeelMenu.add(item);
                    if (currentLF.equals(next)) {
                        item.setSelected(true);
                    }
                }
                ++i3;
            }
            this.genericLFGroup = new ButtonGroup();
            this.defaultLFItem = new JRadioButtonMenuItem();
            this.defaultLFItem.setSelected(true);
            this.defaultLFItem.setActionCommand("DEFAULT");
            this.defaultLFItem.addActionListener(lfAction);
            this.genericLFGroup.add(this.defaultLFItem);
            this.javaLFItem = new JRadioButtonMenuItem();
            this.javaLFItem.setActionCommand("CROSS_PLATFORM");
            this.javaLFItem.addActionListener(lfAction);
            this.genericLFGroup.add(this.javaLFItem);
            this.systemLFItem = new JRadioButtonMenuItem();
            this.systemLFItem.setActionCommand("SYSTEM");
            this.systemLFItem.addActionListener(lfAction);
            this.genericLFGroup.add(this.systemLFItem);
            this.lookFeelMenu.addSeparator();
            this.lookFeelMenu.add(this.javaLFItem);
            this.lookFeelMenu.add(this.systemLFItem);
            this.lookFeelMenu.add(this.defaultLFItem);
            this.helpMenu = new JMenu();
            this.helpMenu.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (splashDialog != null) {
                        splashDialog.dispose();
                    }
                    Launcher.this.helpMenu.removeMouseListener(this);
                }
            });
            this.helpMenu.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    this.mousePressed(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    LaunchNode node = Launcher.this.getSelectedNode();
                    if (node != null) {
                        Launcher.this.helpMenu.add(Launcher.this.authorInfoItem);
                    } else {
                        Launcher.this.helpMenu.remove(Launcher.this.authorInfoItem);
                    }
                }
            });
            menubar.add(this.helpMenu);
            this.logItem = new JMenuItem();
            this.logItem.setAccelerator(KeyStroke.getKeyStroke(76, mask));
            this.logItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!OSPRuntime.isApplet) {
                        Point p0 = new Frame().getLocation();
                        JFrame log = OSPLog.getFrame();
                        if (log.getLocation().x == p0.x && log.getLocation().y == p0.y) {
                            Point p = Launcher.this.frame.getLocation();
                            log.setLocation(p.x + 28, p.y + 28);
                        }
                    }
                    OSPLog.showLog();
                }
            });
            this.helpMenu.add(this.logItem);
            this.inspectItem = new JMenuItem();
            this.helpMenu.add(this.inspectItem);
            this.inspectItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LaunchSet tabSet = new LaunchSet(Launcher.this, Launcher.this.tabSetName);
                    tabSet.showHiddenNodes = Launcher.this instanceof LaunchBuilder;
                    XMLControlElement xml = new XMLControlElement(tabSet);
                    XMLTreePanel treePanel = new XMLTreePanel(xml, false);
                    Launcher.this.xmlInspector.setContentPane(treePanel);
                    Launcher.this.xmlInspector.setTitle(String.valueOf(LaunchRes.getString("Inspector.Title.TabSet")) + " \"" + Launcher.getDisplayName(Launcher.this.tabSetName) + "\"");
                    Launcher.this.xmlInspector.setVisible(true);
                }
            });
            this.diagnosticMenu = new JMenu();
            this.helpMenu.add(this.diagnosticMenu);
            JMenuItem jarItem = new JMenuItem("Jar");
            jarItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Diagnostics.aboutLaunchJar();
                }
            });
            this.diagnosticMenu.add(jarItem);
            JMenuItem vmItem = new JMenuItem("Java VM");
            vmItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Diagnostics.aboutJava();
                }
            });
            this.diagnosticMenu.add(vmItem);
            JMenuItem OSItem = new JMenuItem("OS");
            OSItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Diagnostics.aboutOS();
                }
            });
            this.diagnosticMenu.add(OSItem);
            JMenuItem j3dItem = new JMenuItem("Java 3D");
            j3dItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Diagnostics.aboutJava3D();
                }
            });
            this.diagnosticMenu.add(j3dItem);
            JMenuItem joglItem = new JMenuItem("JOGL");
            joglItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Diagnostics.aboutJOGL();
                }
            });
            this.diagnosticMenu.add(joglItem);
            this.helpMenu.addSeparator();
            this.aboutItem = new JMenuItem();
            this.aboutItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Launcher.this.showAboutDialog();
                }
            });
            this.helpMenu.add(this.aboutItem);
            this.authorInfoItem = new JMenuItem();
            this.authorInfoItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Launcher.this.showAuthorInformation();
                }
            });
            this.helpMenu.add(this.authorInfoItem);
            if (this.frame != null && !OSPRuntime.isApplet) {
                this.frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        Launcher.this.exit();
                    }

                    @Override
                    public void windowGainedFocus(WindowEvent e) {
                        OSPRuntime.setAuthorMode(false);
                    }

                    @Override
                    public void windowActivated(WindowEvent e) {
                        OSPRuntime.setAuthorMode(false);
                    }
                });
                this.fileMenu.addSeparator();
                this.exitItem = new JMenuItem();
                this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, mask));
                this.exitItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Launcher.this.exit();
                    }
                });
            }
            if (!OSPRuntime.isJS && OSPRuntime.getLaunchJarPath() == null) {
                ResourceLoader.getResource("/org/opensourcephysics/tools/Launcher.class");
            }
            if (!OSPRuntime.isJS && OSPRuntime.getLaunchJarPath() != null && (jar = OSPRuntime.getLaunchJar()) != null) {
                AbstractAction action = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String fileName = ((JMenuItem)e.getSource()).getText();
                        fileName = String.valueOf(OSPRuntime.getLaunchJarName()) + "!/" + fileName;
                        String[] prevArgs = Launcher.this.undoManager.getLauncherState();
                        if (prevArgs != null && Launcher.this.open(fileName) != null) {
                            String[] args = new String[]{fileName};
                            LauncherUndo launcherUndo = Launcher.this.undoManager;
                            launcherUndo.getClass();
                            LauncherUndo.LoadEdit edit = new LauncherUndo.LoadEdit(launcherUndo, args, prevArgs);
                            Launcher.this.undoSupport.postEdit(edit);
                            Launcher.this.refreshGUI();
                        } else {
                            Launcher.this.open(fileName);
                            Launcher.this.refreshGUI();
                        }
                    }
                };
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(".xset") || name.startsWith(resourcesPath.substring(1)) || name.startsWith(defaultFileName)) continue;
                    if (this.openFromJarMenu == null) {
                        this.openFromJarMenu = new JMenu();
                    }
                    JMenuItem item = new JMenuItem(name);
                    item.addActionListener(action);
                    this.openFromJarMenu.add(item);
                }
            }
            baseMenuFontSize = this.fileMenu.getFont().getSize();
            this.frame.setJMenuBar(menubar);
            this.frame.pack();
        }
    }

    public void setFontLevel(int level) {
        if (this.frame != null) {
            FontSizer.setFonts(this.frame.getJMenuBar(), level);
        }
        FontSizer.setFonts(this.contentPane, level);
        LaunchPanel lp = this.getSelectedTab();
        FontSizer.setFonts(lp.splitPane, level);
        this.refreshStringResources();
        int i = 0;
        while (i < this.getTabCount()) {
            LaunchPanel tab = this.getTab(i);
            Enumeration<TreeNode> en = tab.getRootNode().breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                LaunchNode node = (LaunchNode)en.nextElement();
                tab.treeModel.nodeChanged(node);
            }
            tab.repaint();
            ++i;
        }
        this.refreshGUI();
    }

    protected Set<String> getOpenPaths() {
        this.openPaths.clear();
        this.openPaths.add(this.tabSetName);
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            LaunchPanel panel = (LaunchPanel)this.tabbedPane.getComponentAt(i);
            LaunchNode[] nodes = panel.getRootNode().getAllOwnedNodes();
            int j = 0;
            while (j < nodes.length) {
                this.openPaths.add(nodes[j].getFileName());
                ++j;
            }
            this.openPaths.add(panel.getRootNode().getFileName());
            ++i;
        }
        return this.openPaths;
    }

    protected Launcher setLookAndFeel(final String lf, final boolean always) {
        if (lf == null) {
            return null;
        }
        this.lookAndFeel = lf;
        boolean newDecorations = true;
        boolean currentDecorations = JFrame.isDefaultLookAndFeelDecorated();
        if (lf.equals("SYSTEM")) {
            this.systemLFItem.setSelected(true);
        } else if (lf.equals("CROSS_PLATFORM")) {
            this.javaLFItem.setSelected(true);
        } else if (lf.equals("DEFAULT")) {
            newDecorations = OSPRuntime.DEFAULT_LOOK_AND_FEEL_DECORATIONS;
            this.defaultLFItem.setSelected(true);
        } else if (this.genericLFGroup.getSelection() != null) {
            this.genericLFGroup.remove(this.systemLFItem);
            this.genericLFGroup.remove(this.javaLFItem);
            this.genericLFGroup.remove(this.defaultLFItem);
            this.systemLFItem.setSelected(false);
            this.javaLFItem.setSelected(false);
            this.defaultLFItem.setSelected(false);
            this.genericLFGroup.add(this.systemLFItem);
            this.genericLFGroup.add(this.javaLFItem);
            this.genericLFGroup.add(this.defaultLFItem);
        }
        String lfType = OSPRuntime.LOOK_AND_FEEL_TYPES.get(lf);
        LookAndFeel currentLF = UIManager.getLookAndFeel();
        if (!always && newDecorations == currentDecorations && currentLF.getClass().getName().equals(lfType)) {
            return null;
        }
        if (!this.isVisible()) {
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    Launcher.this.setLookAndFeel(lf, always);
                    Launcher.this.frame.removeWindowListener(this);
                }
            });
            return null;
        }
        OSPRuntime.setLookAndFeel(newDecorations, lf);
        if (this.spawner != null) {
            this.spawner = this.spawner.setLookAndFeel(lf, true);
        }
        this.exitCurrentApps();
        LauncherUndo undoManager = this.undoManager;
        UndoableEditSupport undoSupport = this.undoSupport;
        LaunchNode node = this.getSelectedNode();
        Point loc = this.frame.getLocation();
        this.frame.dispose();
        LaunchSet tabset = new LaunchSet(this, this.tabSetName);
        XMLControlElement control = new XMLControlElement(tabset);
        control.setPassword(null);
        Launcher launcher2 = this instanceof LaunchBuilder ? new LaunchBuilder(control.toXML()) : new Launcher(control.toXML());
        launcher2.setSelectedNode(node.getPathString());
        undoManager.setLauncher(launcher2);
        launcher2.undoManager = undoManager;
        launcher2.undoSupport = undoSupport;
        launcher2.tabSetName = this.tabSetName;
        launcher2.password = this.password;
        launcher2.spawner = this.spawner;
        launcher2.jarBasePath = this.jarBasePath;
        launcher2.frame.setDefaultCloseOperation(this.frame.getDefaultCloseOperation());
        launcher2.refreshGUI();
        launcher2.frame.setLocation(loc);
        launcher2.setVisible(true);
        launcher2.frame.pack();
        SwingUtilities.updateComponentTreeUI(OSPLog.getFrame());
        return launcher2;
    }

    protected void showAboutDialog() {
        String newline = XML.NEW_LINE;
        String vers = "6.3.3";
        String date = OSPRuntime.getLaunchJarBuildDate();
        if ("".equals(date)) {
            date = "27 Oct 2025";
        }
        vers = String.valueOf(vers) + "   " + date;
        String name = this.getClass().getSimpleName();
        String aboutString = String.valueOf(name) + " " + vers + newline + "Copyright (c) 2025 Wolfgang Christian" + newline + "Open Source Physics Project" + newline + "www.opensourcephysics.org" + newline + newline + LaunchRes.getString("Label.CodeAuthor") + ": Douglas Brown";
        String translator = LaunchRes.getString("Launcher.About.Translator");
        if (!translator.equals("")) {
            Locale loc = LaunchRes.resourceLocale;
            String language = OSPRuntime.getDisplayLanguage(loc);
            aboutString = String.valueOf(aboutString) + newline + newline + LaunchRes.getString("Launcher.About.Language") + ": " + language + newline;
            aboutString = String.valueOf(aboutString) + LaunchRes.getString("Launcher.About.TranslationBy") + ": " + translator + newline;
        }
        JOptionPane.showMessageDialog(this.frame, aboutString, String.valueOf(LaunchRes.getString("Help.About.Title")) + " " + name, 1);
    }

    protected void showAuthorInformation() {
        LaunchNode node = this.getSelectedNode();
        if (node != null) {
            String line = XML.NEW_LINE;
            String info = "";
            if (!node.getAuthor().trim().equals("")) {
                info = String.valueOf(info) + LaunchRes.getString("Label.Author") + ": ";
                info = String.valueOf(info) + node.getAuthor() + line;
            }
            if (!node.getKeywords().trim().equals("")) {
                info = String.valueOf(info) + LaunchRes.getString("Label.Keywords") + ": ";
                info = String.valueOf(info) + node.getKeywords() + line;
            }
            if (!node.getCourseLevel().trim().equals("")) {
                info = String.valueOf(info) + LaunchRes.getString("Label.Level") + ": ";
                info = String.valueOf(info) + node.getCourseLevel() + line;
            }
            if (!node.getLanguages().trim().equals("")) {
                info = String.valueOf(info) + LaunchRes.getString("Label.Languages") + ": ";
                info = String.valueOf(info) + node.getLanguages() + line;
            }
            if (!node.getComment().trim().equals("")) {
                info = String.valueOf(info) + LaunchRes.getString("Label.Comments") + ": ";
                info = String.valueOf(info) + node.getComment() + line;
            }
            if (info.equals("")) {
                info = LaunchRes.getString("Dialog.AuthorInfo.NoInfo");
            }
            JOptionPane.showMessageDialog(this.frame, info, String.valueOf(LaunchRes.getString("Help.About.Title")) + " \"" + node.getName() + "\"", 1);
        }
    }

    protected boolean isLink(LaunchNode node) {
        if (node == null || !node.isLeaf() || node.launchClassName != null && !node.launchClassName.equals("")) {
            return false;
        }
        return !node.args[0].equals("") || node.args.length > 1 && !node.args[1].equals("") || node.args.length > 2 && !node.args[2].equals("");
    }

    protected boolean hasEJSModel(LaunchNode node) {
        if (!OSPRuntime.launcherAllowEJSModel || node == null || !node.isLeaf()) {
            return false;
        }
        return node.getLaunchClass() == null ? false : EjsTool.hasEjsModel(node.getLaunchClass());
    }

    protected boolean isLaunchable(LaunchNode node) {
        if (node == null || !node.isLeaf()) {
            return false;
        }
        return Launcher.isLaunchable(node.getLaunchClass());
    }

    protected void setLinksEnabled(JEditorPane textPane, boolean enabled) {
        if (this.linkListener == null && enabled) {
            this.linkListener = new HyperlinkListener(){
                HyperlinkEvent event;

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (this.event == e) {
                            return;
                        }
                        this.event = e;
                        URL url = e.getURL();
                        Launcher.this.handleHyperLink(url);
                    }
                }
            };
        }
        if (enabled) {
            textPane.addHyperlinkListener(this.linkListener);
        } else {
            textPane.removeHyperlinkListener(this.linkListener);
        }
    }

    protected void handleHyperLink(URL url) {
        boolean browseExternally;
        String path = url.toString();
        boolean extracted = !Launcher.isDisplayable(path);
        boolean bl = browseExternally = !url.getHost().equals("") || extracted;
        if (browseExternally) {
            if (extracted && path.indexOf("jar!") >= 0) {
                int j = path.indexOf("jar!/");
                String fileName = path.substring(j + 5);
                File target = new File(fileName);
                if (target.exists()) {
                    path = target.toURI().toString();
                } else {
                    Resource res = ResourceLoader.getResource(path);
                    if (res != null) {
                        path = res.getURL().toString();
                        final File tempFile = res.getFile();
                        Thread shutdownHook = new Thread(){

                            @Override
                            public void run() {
                                tempFile.deleteOnExit();
                            }
                        };
                        Runtime.getRuntime().addShutdownHook(shutdownHook);
                    }
                }
            }
            if (!OSPDesktop.displayURL(path)) {
                OSPLog.warning("unable to open in browser: " + path);
            }
        } else {
            Object[] nodeData;
            String undoPath = this.selectedNode.getPathString();
            Integer undoPage = this.selectedNode.tabNumber;
            URL prev = this.selectedNode.getURL();
            if (prev.equals(url)) {
                if (url.getRef() != null) {
                    this.setSelectedNode(undoPath, undoPage, url);
                }
                return;
            }
            Object[] objectArray = new Object[4];
            objectArray[1] = undoPath;
            objectArray[2] = undoPage;
            objectArray[3] = prev;
            Object[] undoData = objectArray;
            Object[] redoData = null;
            Object[] objectArray2 = nodeData = prev.getPath().equals(url.getPath()) ? null : this.getNodeAndPage(url);
            if (nodeData != null) {
                undoPath = (String)nodeData[0];
                undoPage = (int)((Integer)nodeData[1]);
            }
            Object[] objectArray3 = new Object[4];
            objectArray3[1] = undoPath;
            objectArray3[2] = undoPage;
            objectArray3[3] = url;
            redoData = objectArray3;
            if (this.postEdits) {
                LauncherUndo launcherUndo = this.undoManager;
                launcherUndo.getClass();
                LauncherUndo.NavEdit edit = new LauncherUndo.NavEdit(launcherUndo, undoData, redoData);
                this.undoSupport.postEdit(edit);
            }
            this.postEdits = false;
            this.setSelectedNode(undoPath, undoPage, url);
            this.postEdits = true;
        }
    }

    public static boolean isDisplayable(String path) {
        if (path.indexOf("#") < 0) {
            String[] stringArray = extractExtensions;
            int n = extractExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                if (path.endsWith(ext)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    protected Object[] getNodeAndPage(URL html) {
        String urlPath = html.getFile();
        int i = 0;
        while (i < this.getTabCount()) {
            LaunchPanel tab = this.getTab(i);
            Enumeration<TreeNode> e = tab.getRootNode().breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                LaunchNode node = (LaunchNode)e.nextElement();
                int j = 0;
                while (j < node.getDisplayTabCount()) {
                    String nextPath;
                    URL next = node.getDisplayTab(j).getURL();
                    if (next != null && (nextPath = next.getFile()).equals(urlPath)) {
                        String nodePath = node.getPathString();
                        return new Object[]{nodePath, j};
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    protected static boolean isLaunchable(Class<?> type) {
        if (type == null) {
            return false;
        }
        try {
            type.getMethod("main", String[].class);
            return true;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    protected static boolean isModel(Class<?> type) {
        if (type == null) {
            return false;
        }
        try {
            type.getMethod("getModelPane", String[].class, JFrame.class);
            return true;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    protected static JComponent getModelPane(Class<?> type, String[] args) {
        if (type == null) {
            return null;
        }
        LauncherFrame frame = null;
        Frame[] frameArray = Frame.getFrames();
        int n = frameArray.length;
        int n2 = 0;
        while (n2 < n) {
            Frame next = frameArray[n2];
            if (next instanceof LauncherFrame) {
                frame = (LauncherFrame)next;
                break;
            }
            ++n2;
        }
        try {
            Method m = type.getMethod("getModelPane", String[].class, JFrame.class);
            return (JComponent)m.invoke(type, args, frame);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void handleMousePressed(MouseEvent e, final LaunchPanel tab) {
        block24: {
            LaunchNode selectedNode;
            block27: {
                block26: {
                    block25: {
                        block23: {
                            selectedNode = this.getSelectedNode();
                            if (!OSPRuntime.isPopupTrigger(e)) break block23;
                            if (!this.popupEnabled) {
                                return;
                            }
                            TreePath path = tab.tree.getPathForLocation(e.getX(), e.getY());
                            if (path == null) {
                                return;
                            }
                            tab.tree.setSelectionPath(path);
                            final LaunchNode node = this.getSelectedNode();
                            if (node == null) {
                                return;
                            }
                            JMenuItem inspectItem = new JMenuItem(LaunchRes.getString("MenuItem.Inspect"));
                            inspectItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    Launcher.this.inspect(node);
                                }
                            });
                            inspectItem.setEnabled(this.password == null || this instanceof LaunchBuilder);
                            this.popup.add(inspectItem);
                            if (node.getLaunchClass() != null) {
                                if (node.launchCount == 0) {
                                    this.popup.addSeparator();
                                    JMenuItem launchItem = new JMenuItem(LaunchRes.getString("MenuItem.Launch"));
                                    this.popup.add(launchItem);
                                    launchItem.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            node.launch(tab);
                                        }
                                    });
                                } else {
                                    this.popup.addSeparator();
                                    JMenuItem terminateItem = new JMenuItem(LaunchRes.getString("MenuItem.Terminate"));
                                    this.popup.add(terminateItem);
                                    terminateItem.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            node.terminateAll();
                                        }
                                    });
                                    if (node.launchCount > 1) {
                                        terminateItem.setText(LaunchRes.getString("MenuItem.TerminateAll"));
                                    }
                                    if (!node.isSingleton()) {
                                        JMenuItem launchItem = new JMenuItem(LaunchRes.getString("MenuItem.Relaunch"));
                                        this.popup.add(launchItem);
                                        launchItem.addActionListener(new ActionListener(){

                                            @Override
                                            public void actionPerformed(ActionEvent e) {
                                                node.launch(tab);
                                            }
                                        });
                                    }
                                }
                                if (this.hasEJSModel(node)) {
                                    this.popup.addSeparator();
                                    JMenuItem ejsItem = new JMenuItem(LaunchRes.getString("Popup.MenuItem.EjsModel"));
                                    this.popup.add(ejsItem);
                                    ejsItem.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            boolean quit = EjsTool.runEjs(node.getLaunchClass(), new Cryptic(Launcher.this.password).getCryptic());
                                            if (quit) {
                                                node.terminateAll();
                                            }
                                        }
                                    });
                                }
                            }
                            if (this.getClass().equals(Launcher.class)) {
                                this.popup.show(tab, e.getX() + 4, e.getY() + 12);
                            }
                            break block24;
                        }
                        if (e.getClickCount() != 2) break block24;
                        if (!this.isLaunchable(selectedNode)) break block25;
                        if (selectedNode.launchCount == 0) {
                            selectedNode.launch(tab);
                        } else if (selectedNode.isSingleton() || selectedNode.isSingleVM() && selectedNode.isSingleApp()) {
                            JOptionPane.showMessageDialog(this.frame, String.valueOf(LaunchRes.getString("Dialog.Singleton.Message")) + " \"" + selectedNode.toString() + "\"", LaunchRes.getString("Dialog.Singleton.Title"), 1);
                        } else {
                            int selected = JOptionPane.showConfirmDialog(this.frame, LaunchRes.getString("Dialog.Relaunch.Message"), LaunchRes.getString("Dialog.Relaunch.Title"), 0);
                            if (selected == 0) {
                                selectedNode.launch(tab);
                            }
                        }
                        if (selectedNode.launchPanel != null) {
                            selectedNode.launchPanel.repaint();
                        }
                        break block24;
                    }
                    if (!this.isLink(selectedNode)) break block26;
                    String[] prevArgs = this.undoManager.getLauncherState();
                    if (this.open(selectedNode.args) != null && prevArgs != null) {
                        LauncherUndo launcherUndo = this.undoManager;
                        launcherUndo.getClass();
                        LauncherUndo.LoadEdit edit = new LauncherUndo.LoadEdit(launcherUndo, selectedNode.args, prevArgs);
                        this.undoSupport.postEdit(edit);
                    }
                    this.refreshGUI();
                    break block24;
                }
                if (selectedNode.getPDFPaths().isEmpty()) break block27;
                for (String path : selectedNode.getPDFPaths()) {
                    String base = tabSetBasePath.equals("") ? this.jarBasePath : tabSetBasePath;
                    String target = XML.getResolvedPath(path, base);
                    target = ResourceLoader.getURIPath(target);
                    OSPLog.finer("opening PDF target: " + target);
                    OSPDesktop.displayURL(target);
                }
                break block24;
            }
            if (selectedNode.getLaunchClass() != null || selectedNode.launchClassName == null || selectedNode.launchClassName.equals("")) break block24;
            String[] jars = LaunchClassChooser.parsePath(selectedNode.getClassPath());
            String jarList = "";
            int i = 0;
            while (i < jars.length) {
                block29: {
                    block28: {
                        if (jarList.equals("")) break block28;
                        if (jars[i].equals(OSPRuntime.getLaunchJarName())) break block29;
                        jarList = String.valueOf(jarList) + ", ";
                    }
                    jarList = String.valueOf(jarList) + jars[i];
                }
                ++i;
            }
            JOptionPane.showMessageDialog(this.frame, String.valueOf(LaunchRes.getString("Dialog.ClassNotFound.Message1")) + selectedNode.launchClassName + XML.NEW_LINE + LaunchRes.getString("Dialog.ClassNotFound.Message2") + XML.NEW_LINE + jarList, LaunchRes.getString("Dialog.ClassNotFound.Title"), 2);
        }
    }

    private void exitCurrentApps() {
        Frame[] prevFrames = Frame.getFrames();
        int i = 0;
        int n = prevFrames.length;
        while (i < n) {
            if (!existingFrames.contains(prevFrames[i]) && !(prevFrames[i] instanceof LauncherFrame)) {
                WindowListener[] listeners = prevFrames[i].getWindowListeners();
                int j = 0;
                while (j < listeners.length) {
                    listeners[j].windowClosing(null);
                    ++j;
                }
                if (prevFrames[i].isVisible()) {
                    prevFrames[i].dispose();
                }
            }
            ++i;
        }
    }

    private void splash() {
        int w = 360;
        int h = 120;
        if (splashDialog == null) {
            splashDialog = new JDialog((Frame)this.frame, false);
            if (!OSPRuntime.isJS) {
                splashDialog.setUndecorated(true);
            }
            Color darkred = new Color(128, 0, 0);
            JPanel splash = new JPanel(new BorderLayout());
            splash.setBackground(Color.white);
            splash.setPreferredSize(new Dimension(w, h));
            splash.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    splashDialog.dispose();
                }
            });
            this.frame.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    splashDialog.dispose();
                    Launcher.this.frame.removeMouseListener(this);
                }
            });
            Border etch = BorderFactory.createEtchedBorder();
            splash.setBorder(etch);
            splashDialog.setContentPane(splash);
            Box labels = Box.createVerticalBox();
            JLabel titleLabel = new JLabel("OSP Launcher");
            if (this instanceof LaunchBuilder) {
                titleLabel.setText("OSP Launch Builder");
            }
            Font font = titleLabel.getFont().deriveFont(1);
            titleLabel.setFont(font.deriveFont(24.0f));
            titleLabel.setForeground(darkred);
            titleLabel.setAlignmentX(0.5f);
            titleLabel.setHorizontalAlignment(0);
            creditsLabel = new JLabel(" ");
            font = font.deriveFont(0);
            font = font.deriveFont(12.0f);
            creditsLabel.setFont(font);
            creditsLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 10, 2));
            creditsLabel.setHorizontalAlignment(0);
            creditsLabel.setAlignmentX(0.5f);
            splashPathLabel = new JLabel(" "){

                @Override
                public void setText(String s) {
                    int max = 80;
                    if (s != null && s.length() > max) {
                        s = String.valueOf(s.substring(0, max - 4)) + "...";
                    }
                    super.setText(s);
                }
            };
            splashPathLabel.setFont(font);
            splashPathLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            splashPathLabel.setHorizontalAlignment(0);
            splashPathLabel.setAlignmentX(0.5f);
            labels.add(Box.createGlue());
            labels.add(titleLabel);
            labels.add(Box.createGlue());
            labels.add(splashPathLabel);
            labels.add(creditsLabel);
            splash.add((Component)labels, "Center");
            splashDialog.pack();
            splashTimer = new Timer(4000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Launcher.this.frame.isShowing()) {
                        splashDialog.dispose();
                        splashTimer.stop();
                    }
                }
            });
        }
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = dim.width / 2;
        int y = dim.height / 2;
        splashDialog.setLocation(x - w / 2, y - h / 2);
        splashDialog.setVisible(true);
        splashTimer.start();
    }

    protected void exit() {
        if (!this.terminateApps()) {
            int op = this.frame.getDefaultCloseOperation();
            this.frame.setDefaultCloseOperation(0);
            SwingUtilities.invokeLater(() -> this.frame.setDefaultCloseOperation(op));
            return;
        }
        if (!OSPRuntime.isApplet && this.frame.getDefaultCloseOperation() == 1) {
            if (this.canExit) {
                System.exit(0);
            } else {
                this.exitCurrentApps();
                this.frame.setVisible(false);
            }
        } else {
            this.exitCurrentApps();
            this.frame.setVisible(false);
        }
    }

    protected boolean terminateApps() {
        if (this.frame.getDefaultCloseOperation() == 1) {
            boolean approved = false;
            Frame[] frames = Frame.getFrames();
            int i = 0;
            int n = frames.length;
            while (i < n) {
                if (!(approved || !frames[i].isVisible() || frames[i] instanceof LauncherFrame || frames[i] != OSPLog.getFrame() || frames[i] instanceof EncryptionTool || existingFrames.contains(frames[i]))) {
                    int selected = JOptionPane.showConfirmDialog(this.frame, String.valueOf(LaunchRes.getString("Dialog.Terminate.Message")) + XML.NEW_LINE + LaunchRes.getString("Dialog.Terminate.Question"), LaunchRes.getString("Dialog.Terminate.Title"), 0);
                    if (selected == 0) {
                        approved = true;
                    } else {
                        return false;
                    }
                }
                ++i;
            }
            approved = false;
            boolean declined = false;
            Component[] comps = this.tabbedPane.getComponents();
            int i2 = 0;
            while (i2 < comps.length) {
                LaunchPanel tab = (LaunchPanel)comps[i2];
                Enumeration<TreeNode> e = tab.getRootNode().breadthFirstEnumeration();
                while (e.hasMoreElements()) {
                    LaunchNode node = (LaunchNode)e.nextElement();
                    if (node.processes.isEmpty()) continue;
                    if (!approved && !declined) {
                        int selected = JOptionPane.showConfirmDialog(this.frame, String.valueOf(LaunchRes.getString("Dialog.TerminateSeparateVM.Message")) + XML.NEW_LINE + LaunchRes.getString("Dialog.TerminateSeparateVM.Question"), LaunchRes.getString("Dialog.TerminateSeparateVM.Title"), 0);
                        approved = selected == 0;
                        boolean bl = declined = !approved;
                    }
                    if (approved) {
                        Iterator<Process> it = node.processes.iterator();
                        while (it.hasNext()) {
                            Process proc = it.next();
                            it.remove();
                            proc.destroy();
                        }
                        continue;
                    }
                    return false;
                }
                ++i2;
            }
        }
        return true;
    }

    protected ResizableIcon getFileIcon(LaunchNode node) {
        if (node.getFileName().length() == 0) {
            return null;
        }
        File file = node.getFile();
        Resource res = node.getResource();
        boolean changed = this.changedFiles.contains(node.getFileName());
        if (changed) {
            return yellowFileIcon;
        }
        if (res == null || node.isParentSelfContained()) {
            return ghostFileIcon;
        }
        if (file != null && file.canWrite()) {
            return whiteFileIcon;
        }
        if (file == null) {
            return magentaFileIcon;
        }
        return redFileIcon;
    }

    public static void launch(Class<?> type) {
        Launcher.launch(type, null, null);
    }

    public static void launch(Class<?> type, String[] args) {
        Launcher.launch(type, args, null);
    }

    public static void launch(final Class<?> type, String[] args, final LaunchNode node) {
        if (type == null) {
            OSPLog.info(LaunchRes.getString("Log.Message.NoClass"));
            JOptionPane.showMessageDialog(null, LaunchRes.getString("Dialog.NoLaunchClass.Message"), LaunchRes.getString("Dialog.NoLaunchClass.Title"), 2);
            return;
        }
        String desc = String.valueOf(LaunchRes.getString("Log.Message.Launching")) + " " + type + ", args ";
        if (args == null) {
            desc = String.valueOf(desc) + args;
        } else {
            desc = String.valueOf(desc) + "{";
            int i = 0;
            while (i < args.length) {
                desc = String.valueOf(desc) + args[i];
                if (i < args.length - 1) {
                    desc = String.valueOf(desc) + ", ";
                }
                ++i;
            }
            desc = String.valueOf(desc) + "}";
        }
        OSPLog.fine(desc);
        if (OSPRuntime.launchingInSingleVM || !newVMAllowed) {
            OSPRuntime.launchingInSingleVM = true;
            OSPLog.finer(LaunchRes.getString("Log.Message.LaunchCurrentVM"));
            final Frame[] prevFrames = Frame.getFrames();
            if (singleAppMode) {
                OSPLog.finer(LaunchRes.getString("Log.Message.LaunchSingleApp"));
                boolean vis = OSPLog.isLogVisible();
                int i = 0;
                int n = prevFrames.length;
                while (i < n) {
                    if (!existingFrames.contains(prevFrames[i]) && !(prevFrames[i] instanceof LauncherFrame)) {
                        WindowListener[] listeners = prevFrames[i].getWindowListeners();
                        int j = 0;
                        while (j < listeners.length) {
                            listeners[j].windowClosing(null);
                            ++j;
                        }
                        prevFrames[i].dispose();
                    }
                    ++i;
                }
                if (vis) {
                    OSPLog.showLog();
                }
            }
            if (node != null) {
                String classPath = node.getClassPath();
                XML.setClassLoader(LaunchClassChooser.getClassLoader(classPath));
            }
            if (node != null && node.launchPanel != null && node.launchPanel.launcher != null) {
                String pw = node.launchPanel.launcher.password;
                String encrypted = pw == null ? null : new Cryptic(pw).getCryptic();
                try {
                    System.setProperty("launcher.password", encrypted);
                }
                catch (Exception n) {
                    // empty catch block
                }
            }
            final String[] launchArgs = args;
            final Runnable launchRunner = new Runnable(){

                @Override
                public void run() {
                    OSPRuntime.activeNode = node;
                    try {
                        Method m = type.getMethod("main", String[].class);
                        m.invoke((Object)type, new Object[]{launchArgs});
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if (node != null) {
                        node.threads.remove(this);
                    }
                    OSPRuntime.activeNode = null;
                    if (frameFinder != null) {
                        Launcher.findFramesFor(node, prevFrames, this);
                        if (frameFinder != null) {
                            frameFinder.stop();
                            frameFinder = null;
                        }
                    }
                }
            };
            if (frameFinder != null) {
                frameFinder.stop();
            }
            frameFinder = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Launcher.findFramesFor(node, prevFrames, launchRunner);
                }
            });
            Thread launchThread = new Thread(launchRunner);
            launchThread.setDaemon(true);
            if (node != null) {
                node.threads.put(launchRunner, launchThread);
            }
            launchThread.start();
            frameFinder.start();
            return;
        }
        OSPLog.finer(LaunchRes.getString("Log.Message.LaunchSeparateVM"));
        final Vector<String> cmd = new Vector<String>();
        cmd.add("java");
        cmd.add("-Dorg.osp.launcher=true");
        if (node != null && node.launchPanel != null && node.launchPanel.launcher != null && node.launchPanel.launcher.password != null) {
            String encrypted = new Cryptic(node.launchPanel.launcher.password).getCryptic();
            cmd.add("-Dlauncher.password=" + encrypted);
        }
        if (classPath != null && !classPath.equals("")) {
            String jar = Launcher.getDefaultJar();
            if (jar != null && classPath.indexOf(jar) == -1) {
                classPath = String.valueOf(classPath) + ";" + jar;
            }
            int i = classPath.indexOf(":");
            while (i != -1) {
                classPath = String.valueOf(classPath.substring(0, i)) + ";" + classPath.substring(i + 1);
                i = classPath.indexOf(":");
            }
            char pathSeparator = System.getProperty("path.separator").charAt(0);
            classPath = classPath.replace(';', pathSeparator);
            cmd.add("-classpath");
            cmd.add(classPath);
        }
        cmd.add(type.getName());
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i] != null) {
                    cmd.add(args[i]);
                }
                ++i;
            }
        }
        Runnable launchRunner = new Runnable(){

            @Override
            public void run() {
                block6: {
                    OSPLog.finer(String.valueOf(LaunchRes.getString("Log.Message.Command")) + " " + cmd.toString());
                    String[] cmdarray = cmd.toArray(new String[0]);
                    String[] envVars = new String[]{"osp_launcher=true"};
                    try {
                        int datum;
                        Process proc = Runtime.getRuntime().exec(cmdarray, envVars);
                        if (node != null) {
                            node.processes.add(proc);
                        }
                        BufferedInputStream errStream = new BufferedInputStream(proc.getErrorStream());
                        StringBuffer buff = new StringBuffer();
                        while ((datum = errStream.read()) != -1) {
                            buff.append((char)datum);
                        }
                        String msg = buff.toString().trim();
                        if (msg.length() > 0) {
                            OSPLog.warning("error when launching node " + node + ": " + buff.toString());
                        }
                        errStream.close();
                        proc.waitFor();
                        if (node != null) {
                            node.threadRunning(false);
                            node.processes.remove(proc);
                        }
                    }
                    catch (Exception ex) {
                        OSPLog.info(ex.toString());
                        if (node == null) break block6;
                        node.threadRunning(false);
                    }
                }
            }
        };
        if (node != null) {
            node.threadRunning(true);
        }
        new Thread(launchRunner).start();
    }

    public static void setJarsOnly(boolean onlyJars) {
        LaunchClassChooser.jarsOnly = onlyJars;
    }

    private static void start(String[] args, long desiredMemorySize) {
        MemoryMXBean memory;
        long memorySize;
        if (!OSPRuntime.isJS && (memorySize = (memory = ManagementFactory.getMemoryMXBean()).getHeapMemoryUsage().getMax() / 0x100000L) < 9L * desiredMemorySize / 10L) {
            Launcher.relaunch(args, desiredMemorySize, null);
            return;
        }
        mainLauncher = new Launcher();
        if (args != null && args.length > 0) {
            mainLauncher.open(args);
        } else {
            String path = null;
            if (OSPRuntime.getLaunchJarName() != null) {
                path = mainLauncher.open(String.valueOf(XML.stripExtension(OSPRuntime.getLaunchJarName())) + ".xset");
            }
            if (path == null) {
                path = mainLauncher.open(String.valueOf(defaultFileName) + ".xset");
            }
            if (path == null) {
                path = mainLauncher.open(String.valueOf(defaultFileName) + ".xml");
            }
        }
        mainLauncher.refreshGUI();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - Launcher.mainLauncher.frame.getBounds().width) / 2;
        int y = (dim.height - Launcher.mainLauncher.frame.getBounds().height) / 2;
        Launcher.mainLauncher.frame.setLocation(x, y);
        Launcher.mainLauncher.frame.setVisible(true);
    }

    protected static void relaunch(final String[] args, final long memorySize, final Component comp) {
        String jarPath = OSPRuntime.getLaunchJarPath();
        final Vector<String> cmd = new Vector<String>();
        cmd.add("java");
        cmd.add("-Xms32m");
        cmd.add("-Xmx" + memorySize + "m");
        cmd.add("-jar");
        cmd.add(jarPath);
        if (args != null) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String next = stringArray[n2];
                cmd.add(next);
                ++n2;
            }
        }
        final Timer timer = OSPRuntime.trigger(500, e -> System.exit(0));
        Runnable launchRunner = new Runnable(){

            @Override
            public void run() {
                String[] cmdarray = cmd.toArray(new String[0]);
                try {
                    Process proc = Runtime.getRuntime().exec(cmdarray);
                    BufferedInputStream errStream = new BufferedInputStream(proc.getErrorStream());
                    errStream.read();
                    timer.stop();
                    errStream.close();
                    JOptionPane.showMessageDialog(comp, String.valueOf(LaunchRes.getString("Launcher.Dialog.InsufficientMemory.Message")) + " " + memorySize + "MB.", LaunchRes.getString("Launcher.Dialog.InsufficientMemory.Title"), 2);
                    if (mainLauncher == null) {
                        if (!OSPRuntime.isJS) {
                            MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
                            long memorySize2 = memory.getHeapMemoryUsage().getMax() / 0x100000L;
                            Launcher.start(args, memorySize2);
                        } else {
                            Launcher.start(args, 512L);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        new Thread(launchRunner).start();
    }

    public static void main(String[] args) {
        String jarBase;
        String xset;
        String path;
        XMLControlElement control;
        long memorySize = 512L;
        if (!OSPRuntime.isJS) {
            MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
            memorySize = memory.getHeapMemoryUsage().getMax() / 0x100000L;
        }
        if (OSPRuntime.getLaunchJarName() != null && !(control = new XMLControlElement(path = XML.getResolvedPath(xset = String.valueOf(XML.stripExtension(OSPRuntime.getLaunchJarName())) + ".xset", jarBase = OSPRuntime.getLaunchJarDirectory()))).failedToRead() && control.getPropertyNamesRaw().contains("memory_size")) {
            memorySize = control.getInt("memory_size");
        }
        Launcher.start(args, memorySize);
    }

    protected LaunchClassChooser getClassChooser() {
        if (this.classChooser == null) {
            this.classChooser = new LaunchClassChooser(this.contentPane);
        }
        return this.classChooser;
    }

    protected static FileFilter getXMLFilter() {
        if (xmlFileFilter == null) {
            xmlFileFilter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f == null) {
                        return false;
                    }
                    if (f.isDirectory()) {
                        return true;
                    }
                    String extension = null;
                    String name = f.getName();
                    int i = name.lastIndexOf(46);
                    if (i > 0 && i < name.length() - 1) {
                        extension = name.substring(i + 1).toLowerCase();
                    }
                    return extension != null && extension.equals("xml");
                }

                @Override
                public String getDescription() {
                    return LaunchRes.getString("FileChooser.XMLFilter.Description");
                }
            };
        }
        return xmlFileFilter;
    }

    protected static JFileChooser getXMLChooser() {
        if (chooser != null) {
            FontSizer.setFonts(chooser, FontSizer.getLevel());
            return chooser;
        }
        chooser = new JFileChooser(new File(OSPRuntime.chooserDir));
        launcherFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                String extension = null;
                String name = f.getName();
                int i = name.lastIndexOf(46);
                if (i > 0 && i < name.length() - 1) {
                    extension = name.substring(i + 1).toLowerCase();
                }
                return extension != null && (extension.equals("xset") || extension.equals("xml") || extension.equals("zip") || extension.equals("trz"));
            }

            @Override
            public String getDescription() {
                return LaunchRes.getString("FileChooser.LauncherFilter.Description");
            }
        };
        xsetFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                String extension = null;
                String name = f.getName();
                int i = name.lastIndexOf(46);
                if (i > 0 && i < name.length() - 1) {
                    extension = name.substring(i + 1).toLowerCase();
                }
                return extension != null && extension.equals("xset");
            }

            @Override
            public String getDescription() {
                return LaunchRes.getString("FileChooser.XSETFilter.Description");
            }
        };
        chooser.addChoosableFileFilter(Launcher.getXMLFilter());
        chooser.addChoosableFileFilter(xsetFileFilter);
        chooser.addChoosableFileFilter(launcherFileFilter);
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        return chooser;
    }

    public void refreshSelectedTab() {
        LaunchNode root = this.getRootNode();
        if (root != null && root.isButtonView() && this.getClass() == Launcher.class) {
            this.showButtonView(root);
        } else {
            this.showTabbedPaneView();
            LaunchPanel tab = this.getSelectedTab();
            if (tab != null && !tab.isSelectingNode) {
                tab.rebuildAndDisplayTabs(this.getSelectedNode() == null ? root : this.selectedNode);
            }
        }
    }

    protected void refreshMemoryButton() {
        long cur = 0L;
        long max = 512L;
        if (!OSPRuntime.isJS) {
            System.gc();
            MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
            cur = memory.getHeapMemoryUsage().getUsed() / 0x100000L;
            max = memory.getHeapMemoryUsage().getMax() / 0x100000L;
        }
        String mem = String.valueOf(LaunchRes.getString("Launcher.Button.Memory")) + ": ";
        String of = String.valueOf(LaunchRes.getString("Launcher.Of")) + " ";
        this.memoryButton.setText(String.valueOf(mem) + cur + "MB " + of + max + "MB");
        double used = (double)cur / (double)max;
        this.memoryButton.setForeground(used > 0.8 ? Color.red : Color.black);
    }

    protected static String getDisplayName(String fileName) {
        int i = (fileName = XML.getName(fileName)).lastIndexOf(".");
        if (i != -1) {
            return fileName.substring(0, i);
        }
        return fileName;
    }

    protected static String getDefaultJar() {
        URL url = ClassLoader.getSystemResource(String.valueOf(defaultFileName) + ".xset");
        if (url == null) {
            url = ClassLoader.getSystemResource(String.valueOf(defaultFileName) + ".xml");
        }
        if (url == null) {
            return null;
        }
        String path = url.getPath();
        int i = path.indexOf("/" + defaultFileName);
        if (i == -1) {
            return null;
        }
        if ((i = (path = path.substring(0, i)).lastIndexOf("!")) == -1) {
            return null;
        }
        return path.substring(path.lastIndexOf("/") + 1, i);
    }

    private void inspect(LaunchNode node) {
        XMLControlElement xml = new XMLControlElement(node);
        if (this.hasEJSModel(node)) {
            String name = XML.getSimpleClassName(node.getLaunchClass());
            xml.setValue("EJS_model", String.valueOf(name) + ".xml");
        }
        XMLTable table = new XMLTable(xml);
        this.tableInspector.setContentPane(new JScrollPane(table));
        this.tableInspector.setTitle(String.valueOf(LaunchRes.getString("Inspector.Title.Node")) + " \"" + node.name + "\"");
        this.tableInspector.setVisible(true);
    }

    private static void findFramesFor(LaunchNode node, Frame[] prevFrames, Runnable runner) {
        Frame[] frames = Frame.getFrames();
        ArrayList<Frame> newFrames = new ArrayList<Frame>();
        int i = 0;
        while (i < frames.length) {
            JFrame frame;
            if (!(frames[i] instanceof JFrame && ((frame = (JFrame)frames[i]).getDefaultCloseOperation() == 0 || frame instanceof MessageFrame || frame instanceof LauncherFrame) || frames[i].getClass().getName().indexOf("SharedOwnerFrame") > -1)) {
                newFrames.add(frames[i]);
            }
            ++i;
        }
        i = 0;
        while (i < prevFrames.length) {
            newFrames.remove(prevFrames[i]);
            ++i;
        }
        if (newFrames.isEmpty()) {
            return;
        }
        frames = newFrames.toArray(new Frame[0]);
        newFrames.clear();
        FrameCloser frameCloser = new FrameCloser(node, newFrames, runner);
        int i2 = 0;
        while (i2 < frames.length) {
            if (frames[i2] instanceof JFrame) {
                JFrame frame = (JFrame)frames[i2];
                if (frame instanceof AppFrame && ((AppFrame)((Object)frame)).wishesToExit() || frame.getDefaultCloseOperation() == 3) {
                    if (frame.getDefaultCloseOperation() == 3) {
                        frame.setDefaultCloseOperation(2);
                    }
                    frame.addWindowListener(frameCloser);
                }
                newFrames.add(frame);
            }
            ++i2;
        }
        if (node != null) {
            node.frames.addAll(newFrames);
            ++node.launchCount;
            if (frameFinder != null) {
                frameFinder.stop();
                frameFinder = null;
            }
            if (node.launchPanel != null) {
                node.launchPanel.repaint();
            }
        }
    }

    protected static ResizableIcon loadIcon(String imageName) {
        ResizableIcon icon = ResourceLoader.getResizableIcon("/org/opensourcephysics/resources/tools/images/" + imageName);
        if (icon != null) {
            return icon;
        }
        if (defaultIcon == null) {
            defaultIcon = new ResizableIcon(new Icon(){

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    Color prev = g.getColor();
                    g.setColor(Color.BLUE);
                    g.drawOval(x + 3, y + 3, 10, 10);
                    g.setColor(prev);
                }

                @Override
                public int getIconWidth() {
                    return 16;
                }

                @Override
                public int getIconHeight() {
                    return 16;
                }
            });
        }
        return defaultIcon;
    }

    protected static void log(String key) {
        OSPLog.finest(LaunchRes.getString(key));
    }

    public static boolean urlExists(URL url) {
        try {
            InputStream stream = (InputStream)url.getContent();
            if (stream != null) {
                stream.close();
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    static class FrameCloser
    extends WindowAdapter {
        LaunchNode node;
        Collection<Frame> frames;
        Runnable runner;

        FrameCloser(LaunchNode node, Collection<Frame> newFrames, Runnable runner) {
            this.frames = newFrames;
            this.node = node;
            this.runner = runner;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            OSPLog.fine("Closing frames for node " + this.node);
            for (Frame frame : this.frames) {
                frame.removeWindowListener(this);
                frame.dispose();
            }
            if (this.node != null) {
                Thread thread = this.node.threads.get(this.runner);
                if (thread != null) {
                    thread.interrupt();
                    this.node.threads.put(this.runner, null);
                }
                this.node.frames.removeAll(this.frames);
                this.node.launchCount = Math.max(0, --this.node.launchCount);
                if (this.node.launchPanel != null) {
                    this.node.launchPanel.repaint();
                }
            }
        }
    }

    public class HTMLPane {
        public JTextPane editorPane = GUIUtils.newJTextPane();
        JScrollPane scroller;

        HTMLPane() {
            this.editorPane.setEditable(false);
            this.editorPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!((HTMLPane)HTMLPane.this).Launcher.this.undoManager.canUndo()) {
                        return;
                    }
                    if (OSPRuntime.isPopupTrigger(e)) {
                        JPopupMenu popup = new JPopupMenu();
                        JMenuItem item = new JMenuItem(LaunchRes.getString("Popup.MenuItem.Back"));
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ((HTMLPane)(this).HTMLPane.this).Launcher.this.undoManager.undo();
                            }
                        });
                        popup.add(item);
                        popup.show(HTMLPane.this.editorPane, e.getX(), e.getY() + 8);
                    }
                }
            });
            HTMLEditorKit editorKit = new HTMLEditorKit();
            this.editorPane.setEditorKit(editorKit);
            this.scroller = new JScrollPane(this.editorPane);
        }
    }

    private class LaunchRenderer
    extends DefaultTreeCellRenderer {
        private LaunchRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            LaunchNode node = (LaunchNode)value;
            this.setToolTipText(node.tooltip.equals("") ? null : node.tooltip);
            ResizableIcon icon = whiteFolderIcon;
            if (node.getFileName() != null && Launcher.this instanceof LaunchBuilder) {
                this.setToolTipText(String.valueOf(LaunchRes.getString("ToolTip.FileName")) + " \"" + node.getFileName() + "\"");
                icon = Launcher.this.getFileIcon(node);
            } else if (node.launchCount > 0) {
                icon = node.isSingleton() ? singletonIcon : (node.isSingleVM() && node.isSingleApp() ? singletonIcon : launchedIcon);
            } else if (Launcher.this.hasEJSModel(node)) {
                icon = ejsIcon;
            } else if (Launcher.this.isLaunchable(node)) {
                icon = launchIcon;
            } else if (Launcher.this.isLink(node)) {
                icon = linkIcon;
            } else if (node.isLeaf()) {
                if (node.getLaunchClass() == null && node.launchClassName != null && !node.launchClassName.equals("")) {
                    icon = launchEmptyIcon;
                } else if (node.getDisplayTabCount() > 0) {
                    int count = 0;
                    for (LaunchNode.DisplayTab html : node.tabData) {
                        if (html.url == null && html.getModelClass() == null) continue;
                        ++count;
                    }
                    icon = count > 0 ? htmlIcon : noFileIcon;
                } else {
                    icon = noFileIcon;
                }
            }
            this.setIcon(icon);
            return this;
        }
    }

    public class LaunchSet
    implements XML.ObjectLoader {
        private Launcher launcher;
        private String name;
        boolean failedToLoad = false;
        public boolean showHiddenNodes = true;

        public LaunchSet() {
            this.launcher = Launcher.this;
        }

        protected LaunchSet(Launcher launcher3, String path) {
            this.launcher = launcher3;
            this.name = XML.getName(XML.forwardSlash(path));
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            boolean hasPW;
            LaunchSet tabset = (LaunchSet)obj;
            Launcher launcher2 = tabset.launcher;
            control.setValue("classpath", classPath);
            control.setValue("title", launcher2.title);
            Dimension dim = launcher2.getSize();
            control.setValue("width", dim.width);
            control.setValue("height", dim.height);
            control.setValue("divider", launcher2.divider);
            control.setValue("look_and_feel", launcher2.lookAndFeel);
            control.setValue("editor_enabled", launcher2.editorEnabled);
            if (Launcher.this.saveState) {
                LaunchNode node = launcher2.getSelectedNode();
                control.setValue("selected_node", node.getPathString());
                int n = launcher2.tabbedPane.getTabCount();
                Collection[] expansions = new Collection[n];
                int i = 0;
                while (i < n) {
                    LaunchPanel tab = launcher2.getTab(i);
                    expansions[i] = tab.getExpandedNodes();
                    ++i;
                }
                control.setValue("expanded", expansions);
            }
            ArrayList<Object> nodes = new ArrayList<Object>();
            int i = 0;
            while (i < launcher2.tabs.size()) {
                LaunchNode root = ((LaunchPanel)launcher2.tabs.get(i)).getRootNode();
                if (!root.isHiddenInLauncher() || tabset.showHiddenNodes) {
                    root.parentSelfContained = false;
                    root.previewing = false;
                    root.saveHiddenNodes = tabset.showHiddenNodes;
                    if (launcher2.selfContained) {
                        root.setSelfContained(false);
                        root.parentSelfContained = true;
                        nodes.add(root);
                    } else if (launcher2.previewing) {
                        root.previewing = true;
                        nodes.add(root);
                    } else if (root.getFileName() == null || root.getFileName().equals("")) {
                        nodes.add(root);
                    } else {
                        nodes.add(root.getFileName());
                    }
                }
                ++i;
            }
            control.setValue("launch_nodes", nodes);
            boolean bl = hasPW = launcher2.password != null && !launcher2.password.equals("");
            if (hasPW && Launcher.this.pwRequiredToLoad) {
                control.setValue("pw_required_by_launcher", true);
            }
            control.setValue("xml_password", launcher2.password);
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            String lookAndFeel;
            LaunchSet tabset = (LaunchSet)obj;
            Launcher launcher2 = tabset.launcher;
            if (control.getPropertyNamesRaw().contains("launchset")) {
                String path = launcher2.open(control.getString("launchset"));
                tabset.failedToLoad = path == null;
                return obj;
            }
            if (control.getPropertyNamesRaw().contains("classpath")) {
                classPath = control.getString("classpath");
            }
            if ((lookAndFeel = control.getString("look_and_feel")) != null) {
                SwingUtilities.invokeLater(() -> launcher2.setLookAndFeel(lookAndFeel, false));
            }
            launcher2.xsetMemorySize = control.getPropertyNamesRaw().contains("memory_size") ? control.getInt("memory_size") : 0;
            String selectedPath = control.getString("selected_node");
            launcher2.saveState = selectedPath != null;
            boolean rootEnabled = true;
            Collection nodes = (Collection)Collection.class.cast(control.getObject("launch_nodes"));
            if (nodes != null && !nodes.isEmpty()) {
                int i = launcher2.tabbedPane.getSelectedIndex();
                Iterator it = nodes.iterator();
                boolean tabAdded = false;
                LaunchNode buttonNode = null;
                while (it.hasNext()) {
                    Object next = it.next();
                    if (tabset.name != null && tabset.name.equals(next)) continue;
                    if (next instanceof String) {
                        String path = XML.getResolvedPath((String)next, tabSetBasePath);
                        if (launcher2.open(path) == null) continue;
                        tabAdded = true;
                        continue;
                    }
                    if (!(next instanceof LaunchNode)) continue;
                    LaunchNode node = (LaunchNode)next;
                    if (!tabAdded) {
                        XMLControlElement element;
                        String pw;
                        if (splashDialog != null && splashDialog.isVisible() && !node.getAuthor().trim().equals("")) {
                            String by = String.valueOf(LaunchRes.getString("Label.Author")) + ": ";
                            creditsLabel.setText(String.valueOf(by) + node.getAuthor());
                        }
                        if (control instanceof XMLControlElement && (pw = (element = (XMLControlElement)control).getPassword()) != null && !passwords.contains(pw)) {
                            boolean pwRequired = control.getBoolean("pw_required_by_launcher");
                            if (Launcher.this instanceof LaunchBuilder || pwRequired) {
                                node.enabled = false;
                                rootEnabled = false;
                            }
                        }
                    }
                    if (launcher2.getClass() == Launcher.class && node.isButtonView() && buttonNode == null) {
                        buttonNode = node;
                    }
                    boolean bl = tabAdded = launcher2.addTab(node) || tabAdded;
                }
                if (!launcher2.saveState || !rootEnabled) {
                    if (buttonNode != null) {
                        int j = 0;
                        while (j < launcher2.tabbedPane.getTabCount()) {
                            if (launcher2.getTab(j).getRootNode() == buttonNode) {
                                launcher2.tabbedPane.setSelectedIndex(j);
                            }
                            ++j;
                        }
                    } else if (tabAdded) {
                        launcher2.tabbedPane.setSelectedIndex(i + 1);
                    }
                }
            }
            if (launcher2.saveState) {
                Collection[] expansions = (Collection[])Collection[].class.cast(control.getObject("expanded"));
                if (expansions != null) {
                    if (rootEnabled) {
                        int i = 0;
                        while (i < expansions.length) {
                            LaunchPanel tab = launcher2.getTab(i);
                            tab.setExpandedNodes(expansions[i]);
                            ++i;
                        }
                    } else {
                        launcher2.expansions = expansions;
                    }
                }
                if (rootEnabled) {
                    launcher2.setSelectedNode(selectedPath);
                } else {
                    launcher2.selectedPath = selectedPath;
                }
            }
            launcher2.title = control.getString("title");
            if (control.getPropertyNamesRaw().contains("editor_enabled")) {
                launcher2.editorEnabled = control.getBoolean("editor_enabled");
            }
            launcher2.password = control.getString("xml_password");
            launcher2.pwRequiredToLoad = control.getBoolean("pw_required_by_launcher");
            if (control.getPropertyNamesRaw().contains("width") && control.getPropertyNamesRaw().contains("height")) {
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                dim.width = Math.min(8 * dim.width / 10, control.getInt("width"));
                dim.height = Math.min(8 * dim.height / 10, control.getInt("height"));
                launcher2.setSize(dim);
            }
            if (control.getPropertyNamesRaw().contains("divider")) {
                launcher2.divider = control.getInt("divider");
                launcher2.refreshGUI();
            }
            if (launcher2.getRootNode() != null && !launcher2.getRootNode().enabled) {
                Launcher launchr = launcher2;
                SwingUtilities.invokeLater(() -> launcher2.passwordItem.doClick(0));
            }
            return obj;
        }
    }

    public class LauncherFrame
    extends JFrame {
        private LauncherFrame() {
            this.setName("LauncherTool");
            try {
                this.setIconImage(ResourceLoader.getImageIcon("/org/opensourcephysics/resources/controls/images/osp_icon.gif").getImage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

