/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.net.URL;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.Launcher;

public class LauncherUndo
extends UndoManager {
    private Launcher launcher;

    public LauncherUndo(Launcher launcher2) {
        this.setLauncher(launcher2);
    }

    public void setLauncher(Launcher launcher2) {
        this.launcher = launcher2;
    }

    public boolean canReload() {
        return this.editToBeUndone() instanceof LoadEdit;
    }

    public String[] getLauncherState() {
        if (this.launcher.tabSetName == null) {
            return null;
        }
        String fileName = XML.getResolvedPath(this.launcher.tabSetName, Launcher.tabSetBasePath);
        if (!fileName.startsWith(Launcher.defaultFileName) && Launcher.tabSetBasePath.equals("")) {
            fileName = String.valueOf(OSPRuntime.getLaunchJarName()) + "!/" + fileName;
        } else {
            File file = new File(fileName);
            if (!file.exists()) {
                return null;
            }
        }
        String[] state = new String[]{fileName, this.launcher.getSelectedNode() != null ? this.launcher.getSelectedNode().getPathString() : (this.launcher.getSelectedTab() == null ? "" : this.launcher.getSelectedTab().getRootNode().name)};
        return state;
    }

    protected class LoadEdit
    extends AbstractUndoableEdit {
        String[] args = new String[2];
        String[] prev = new String[2];

        public LoadEdit(String[] newArgs, String[] prevArgs) {
            if (newArgs != null) {
                this.args[0] = newArgs[0];
                this.args[1] = newArgs.length < 2 ? "" : newArgs[1];
            }
            this.prev[0] = prevArgs[0];
            this.prev[1] = prevArgs.length < 2 ? "" : prevArgs[1];
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            ((LauncherUndo)LauncherUndo.this).launcher.postEdits = false;
            LauncherUndo.this.launcher.open(this.prev);
            if (this.args[0] == null) {
                int n = LauncherUndo.this.edits.size() - 1;
                LauncherUndo.this.trimEdits(n, n);
            }
            LauncherUndo.this.launcher.refreshGUI();
            ((LauncherUndo)LauncherUndo.this).launcher.postEdits = true;
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            ((LauncherUndo)LauncherUndo.this).launcher.postEdits = false;
            LauncherUndo.this.launcher.open(this.args);
            LauncherUndo.this.launcher.refreshGUI();
            ((LauncherUndo)LauncherUndo.this).launcher.postEdits = true;
        }

        @Override
        public String getPresentationName() {
            return "Link";
        }
    }

    protected class NavEdit
    extends AbstractUndoableEdit {
        String undoFile;
        String redoFile;
        String undoNode;
        String redoNode;
        Integer undoPage;
        Integer redoPage;
        URL redoURL;
        URL undoURL;

        public NavEdit(Object[] oldState, Object[] newState) {
            this.undoFile = (String)oldState[0];
            this.redoFile = (String)newState[0];
            this.undoNode = (String)oldState[1];
            this.redoNode = (String)newState[1];
            this.undoPage = (Integer)oldState[2];
            this.redoPage = (Integer)newState[2];
            this.undoURL = (URL)oldState[3];
            this.redoURL = (URL)newState[3];
        }

        public NavEdit(LaunchNode prev, LaunchNode node) {
            if (prev != null) {
                this.undoNode = prev.getPathString();
                this.undoURL = prev.getURL();
                this.undoPage = prev.tabNumber;
            }
            if (node != null) {
                this.redoNode = node.getPathString();
                this.redoURL = node.getURL();
                this.redoPage = node.tabNumber;
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (this.undoFile != null) {
                this.undoFile.equals(this.redoFile);
            }
            ((LauncherUndo)LauncherUndo.this).launcher.postEdits = false;
            int page = this.undoPage == null ? 0 : this.undoPage;
            LauncherUndo.this.launcher.setSelectedNode(this.undoNode, page, this.undoURL);
            ((LauncherUndo)LauncherUndo.this).launcher.postEdits = true;
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            if (this.redoFile != null) {
                this.redoFile.equals(this.undoFile);
            }
            ((LauncherUndo)LauncherUndo.this).launcher.postEdits = false;
            int page = this.redoPage == null ? 0 : this.redoPage;
            LauncherUndo.this.launcher.setSelectedNode(this.redoNode, page, this.redoURL);
            ((LauncherUndo)LauncherUndo.this).launcher.postEdits = true;
        }

        @Override
        public String getPresentationName() {
            return "Navigation";
        }
    }
}

