/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.LibraryBrowser;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

public class Library {
    protected String name;
    protected ArrayList<String> pathList = new ArrayList();
    protected HashMap<String, String> pathToNameMap = new HashMap();
    protected ArrayList<String> comPADREPathList = new ArrayList();
    protected HashMap<String, String> comPADREPathToNameMap = new HashMap();
    protected ArrayList<String> ospLibraryPathList = new ArrayList();
    protected HashMap<String, Library> ospPathToLibraryMap = new HashMap();
    protected ArrayList<String> importedPathList = new ArrayList();
    protected HashMap<String, Library> importedPathToLibraryMap = new HashMap();
    protected ArrayList<String> subPathList = new ArrayList();
    protected HashMap<String, Library> subPathToLibraryMap = new HashMap();
    protected HashMap<String, String> allPathsToNameMap = new HashMap();
    protected Set<String> noSearchSet = new TreeSet<String>();
    protected String[] openTabPaths;
    protected ArrayList<String> recentTabs = new ArrayList();
    protected int maxRecentTabCount = 6;
    protected String chooserDir;
    protected LibraryBrowser browser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOSPLibrary(String path) {
        if (this.ospLibraryPathList.contains(path)) {
            return false;
        }
        ArrayList<String> arrayList = this.ospLibraryPathList;
        synchronized (arrayList) {
            XMLControlElement control;
            block5: {
                control = new XMLControlElement(path);
                if (!control.failedToRead() && control.getObjectClass() == Library.class) break block5;
                return false;
            }
            Library library = new Library();
            control.loadObject(library);
            library.browser = this.browser;
            this.ospLibraryPathList.add(path);
            this.ospPathToLibraryMap.put(path, library);
        }
        return true;
    }

    public boolean importLibrary(String path) {
        if (this.importedPathList.contains(path)) {
            return false;
        }
        XMLControlElement control = new XMLControlElement(path);
        if (control.failedToRead() || control.getObjectClass() != Library.class) {
            return false;
        }
        Library library = new Library();
        library.browser = this.browser;
        control.loadObject(library);
        return this.importLibrary(path, library);
    }

    public boolean addComPADRECollection(String path, String name) {
        if (this.comPADREPathList.contains(path = path.trim())) {
            return false;
        }
        this.comPADREPathList.add(path);
        this.comPADREPathToNameMap.put(path, name.trim());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSubLibrary(String path) {
        if (this.subPathList.contains(path)) {
            return false;
        }
        ArrayList<String> arrayList = this.subPathList;
        synchronized (arrayList) {
            XMLControlElement control;
            block5: {
                control = new XMLControlElement(path);
                if (!control.failedToRead() && control.getObjectClass() == Library.class) break block5;
                return false;
            }
            Library library = new Library();
            library.browser = this.browser;
            control.loadObject(library);
            this.subPathList.add(path);
            this.subPathToLibraryMap.put(path, library);
        }
        return true;
    }

    public String toString() {
        return this.getName();
    }

    protected void setName(String name) {
        if (name == null) {
            name = OSPRuntime.getUserHome().replace('\\', '/');
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            name = String.valueOf(XML.getName(name)) + " " + ToolsRes.getString("Library.Name");
        }
        this.name = name;
    }

    protected String getName() {
        return this.name;
    }

    protected void save(String path) {
        if (path != null) {
            new XMLControlElement(this).write(path);
        }
    }

    protected void load(String path) {
        if (path != null) {
            new XMLControlElement(path).loadObject(this);
        }
    }

    protected Collection<String> getNames() {
        return this.pathToNameMap.values();
    }

    protected boolean isEmpty() {
        return this.pathList.isEmpty();
    }

    protected boolean containsPath(String path, boolean allLists) {
        int n = (path = path.trim()).indexOf("&OSPPrimary=Subject");
        if (n >= 0) {
            path = path.substring(0, n);
        }
        return this.pathList.contains(path) || allLists && (this.comPADREPathList.contains(path) || this.ospLibraryPathList.contains(path));
    }

    public void addCollection(String path, String name) {
        if (this.pathList.contains(path = path.trim())) {
            return;
        }
        this.pathList.add(path);
        this.pathToNameMap.put(path, name.trim());
        this.allPathsToNameMap.put(path, name.trim());
    }

    protected void renameCollection(String path, String newName) {
        if (!this.pathList.contains(path = path.trim())) {
            return;
        }
        this.pathToNameMap.put(path, newName.trim());
        this.allPathsToNameMap.put(path, newName.trim());
    }

    public TreeSet<String> getAllPaths() {
        Library library;
        TreeSet<String> paths = new TreeSet<String>();
        paths.addAll(this.pathList);
        paths.addAll(this.comPADREPathList);
        if (!this.subPathList.isEmpty()) {
            for (String path : this.subPathList) {
                library = this.subPathToLibraryMap.get(path);
                paths.addAll(library.getAllPaths());
            }
        }
        for (String path : this.ospLibraryPathList) {
            library = this.ospPathToLibraryMap.get(path);
            paths.addAll(library.getAllPaths());
        }
        return paths;
    }

    public HashMap<String, String> getNameMap() {
        return this.allPathsToNameMap;
    }

    protected Library getCloneForExport() {
        Library lib = new Library();
        lib.pathList = this.pathList;
        lib.pathToNameMap = this.pathToNameMap;
        lib.name = this.name;
        return lib;
    }

    protected boolean importLibrary(String path, Library library) {
        if (this.importedPathList.contains(path)) {
            return false;
        }
        this.importedPathList.add(path);
        this.importedPathToLibraryMap.put(path, library);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRecent(String filename, boolean atEnd) {
        if (filename == null) {
            return;
        }
        ArrayList<String> arrayList = this.recentTabs;
        synchronized (arrayList) {
            while (this.recentTabs.contains(filename)) {
                this.recentTabs.remove(filename);
            }
            if (atEnd) {
                this.recentTabs.add(filename);
            } else {
                this.recentTabs.add(0, filename);
            }
            while (this.recentTabs.size() > this.maxRecentTabCount) {
                this.recentTabs.remove(this.recentTabs.size() - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRecent(String filename) {
        if (filename == null) {
            return;
        }
        ArrayList<String> arrayList = this.recentTabs;
        synchronized (arrayList) {
            while (this.recentTabs.contains(filename)) {
                this.recentTabs.remove(filename);
            }
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            File cache;
            int i;
            String[] names;
            String[] paths;
            Library library = (Library)obj;
            control.setValue("name", library.getName());
            if (!library.pathList.isEmpty()) {
                paths = library.pathList.toArray(new String[0]);
                control.setValue("collection_paths", paths);
                names = new String[paths.length];
                i = 0;
                while (i < paths.length) {
                    names[i] = library.pathToNameMap.get(paths[i]);
                    ++i;
                }
                control.setValue("collection_names", names);
            }
            if (!library.subPathList.isEmpty()) {
                paths = library.subPathList.toArray(new String[0]);
                control.setValue("sublibrary_paths", paths);
            }
            if (!library.importedPathList.isEmpty()) {
                paths = library.importedPathList.toArray(new String[0]);
                control.setValue("imported_library_paths", paths);
            }
            control.setValue("open_tabs", library.openTabPaths);
            control.setValue("chooser_directory", library.chooserDir);
            if (!library.recentTabs.isEmpty()) {
                paths = library.recentTabs.toArray(new String[0]);
                control.setValue("recently_opened", paths);
                names = new String[paths.length];
                i = 0;
                while (i < names.length) {
                    names[i] = library.getNameMap().get(paths[i]);
                    if (names[i] == null) {
                        names[i] = XML.getName(paths[i]);
                    }
                    ++i;
                }
                control.setValue("recently_opened_names", names);
            }
            if (!library.noSearchSet.isEmpty()) {
                paths = library.noSearchSet.toArray(new String[0]);
                control.setValue("no_search_paths", paths);
            }
            if ((cache = ResourceLoader.getOSPCache()) != null) {
                control.setValue("cache", cache.getPath());
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new Library();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            String[] stringArray;
            String path;
            int n;
            String[] stringArray2;
            int i;
            String[] names;
            Library library = (Library)obj;
            library.setName(control.getString("name"));
            String[] paths = (String[])control.getObject("collection_paths");
            if (paths != null) {
                names = (String[])control.getObject("collection_names");
                library.pathList.clear();
                library.pathToNameMap.clear();
                i = 0;
                while (i < paths.length) {
                    if (paths[i] != null && names[i] != null) {
                        library.pathList.add(paths[i]);
                        library.pathToNameMap.put(paths[i], names[i]);
                        library.allPathsToNameMap.put(paths[i], names[i]);
                    }
                    ++i;
                }
            }
            if ((paths = (String[])control.getObject("sublibrary_paths")) != null) {
                stringArray2 = paths;
                n = paths.length;
                i = 0;
                while (i < n) {
                    path = stringArray2[i];
                    library.addSubLibrary(path);
                    ++i;
                }
            }
            if ((paths = (String[])control.getObject("imported_library_paths")) != null) {
                stringArray2 = paths;
                n = paths.length;
                i = 0;
                while (i < n) {
                    path = stringArray2[i];
                    library.importLibrary(path);
                    ++i;
                }
            }
            paths = (String[])control.getObject("recently_opened");
            names = (String[])control.getObject("recently_opened_names");
            if (paths != null) {
                stringArray = paths;
                int n2 = paths.length;
                n = 0;
                while (n < n2) {
                    String path2 = stringArray[n];
                    library.addRecent(path2, true);
                    ++n;
                }
                if (names != null) {
                    int i2 = 0;
                    while (i2 < names.length) {
                        library.getNameMap().put(paths[i2], names[i2]);
                        ++i2;
                    }
                }
            }
            if ((paths = (String[])control.getObject("no_search_paths")) != null) {
                stringArray = paths;
                int n3 = paths.length;
                n = 0;
                while (n < n3) {
                    String path3 = stringArray[n];
                    library.noSearchSet.add(path3);
                    ++n;
                }
            }
            library.openTabPaths = (String[])control.getObject("open_tabs");
            library.chooserDir = control.getString("chooser_directory");
            if (ResourceLoader.getOSPCache() == null) {
                ResourceLoader.setOSPCache(control.getString("cache"));
            }
            return obj;
        }
    }
}

