/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javajs.async.AsyncDialog;
import javajs.async.AsyncFileChooser;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPButton;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.JREFinder;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.Library;
import org.opensourcephysics.tools.LibraryCollection;
import org.opensourcephysics.tools.LibraryComPADRE;
import org.opensourcephysics.tools.LibraryManager;
import org.opensourcephysics.tools.LibraryResource;
import org.opensourcephysics.tools.LibraryTreeNode;
import org.opensourcephysics.tools.LibraryTreePanel;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

public class LibraryBrowser
extends JPanel {
    public static final String TRACKER_LIBRARY = "https://opensourcephysics.github.io/resources/CAB/tracker_library.xml";
    public static final String SHARED_LIBRARY = "https://opensourcephysics.github.io/resources/CAB/shared_library.xml";
    protected static final String AND = " AND ";
    protected static final String OR = " OR ";
    protected static final String OPENING = "(";
    protected static final String CLOSING = ")";
    protected static final String MY_LIBRARY_NAME = "my_library.xml";
    protected static final String MY_COLLECTION_NAME = "my_collection.xml";
    protected static final String RECENT_COLLECTION_NAME = "recent_collection.xml";
    protected static final String LIBRARY_HELP_NAME = "library_browser_help.html";
    protected static final String LIBRARY_HELP_ONLINE = "https://opensourcephysics.github.io/tracker-website/help/library_browser.html";
    protected static final String WINDOWS_OSP_DIRECTORY = "/My Documents/OSP/";
    protected static final String OSP_DIRECTORY = "/Documents/OSP/";
    protected static final String WEB_SEARCH_BASE_PATH = "https://opensourcephysics.github.io/resources/Search/";
    protected static final String WEB_EJS = "https://www.um.es/fem/wikis/runwebejs/?url=";
    protected static final String TRACKER_ONLINE = "https://opensourcephysics.github.io/tracker-online/?j2sargs=";
    protected static final String DATATOOL_ONLINE = "https://opensourcephysics.github.io/tracker-online/DataTool.html?j2sargs=";
    public static final String HINT_LOAD_RESOURCE = "LOAD";
    public static final String HINT_DOWNLOAD_RESOURCE = "DOWNLOAD";
    public static final String PROPERTY_LIBRARY_TARGET = "target";
    public static final String PROPERTY_LIBRARY_EDITED = "collection_edit";
    private static String ospPath;
    private static LibraryBrowser browser;
    protected static Border buttonBorder;
    private static boolean checkedWebConnection;
    protected static JFrame frame;
    protected static JDialog externalDialog;
    protected static JMenuBar menubar;
    protected static ResizableIcon expandIcon;
    protected static ResizableIcon contractIcon;
    protected static ResizableIcon heavyExpandIcon;
    protected static ResizableIcon heavyContractIcon;
    protected static ResizableIcon refreshIcon;
    protected static ResizableIcon downloadIcon;
    protected static ResizableIcon downloadDisabledIcon;
    protected static ResizableIcon searchTargetIcon;
    protected static final TrackerDLFilter TRACKER_FILTER;
    protected static javax.swing.filechooser.FileFilter filesAndFoldersFilter;
    protected static Timer searchTimer;
    public static boolean fireHelpEvent;
    public static int maxRecentCollectionSize;
    private static int wide;
    private static int high;
    protected static boolean useOnlineOnly;
    protected boolean webConnected = OSPRuntime.isJS;
    protected boolean localLibraryLoaded = false;
    protected Library library = new Library();
    protected String libraryPath;
    protected JToolBar toolbar;
    protected JButton messageButton;
    protected Action commandAction;
    protected Action searchAction;
    protected Action openRecentAction;
    protected Action downloadAction;
    protected JLabel commandLabel;
    protected JLabel searchLabel;
    protected JTextField commandField;
    protected JTextField searchField;
    protected JMenu fileMenu;
    protected JMenu recentMenu;
    protected JMenu collectionsMenu;
    protected JMenu manageMenu;
    protected JMenu helpMenu;
    protected JMenuItem newItem;
    protected JMenuItem openItem;
    protected JMenuItem saveItem;
    protected JMenuItem saveAsItem;
    protected JMenuItem closeItem;
    protected JMenuItem closeAllItem;
    protected JMenuItem exitItem;
    protected JMenuItem deleteItem;
    protected JMenuItem collectionsItem;
    protected JMenuItem searchItem;
    protected JMenuItem cacheItem;
    protected JMenuItem aboutItem;
    protected JMenuItem logItem;
    protected JMenuItem helpItem;
    protected JButton openButton;
    protected JButton editButton;
    protected JButton refreshButton;
    protected JButton downloadButton;
    protected JButton searchTargetButton;
    protected ActionListener loadCollectionAction;
    protected boolean exitOnClose;
    protected JTabbedPane tabbedPane;
    protected JScrollPane htmlScroller;
    protected PropertyChangeListener treePanelListener;
    protected PropertyChangeListener metadataLoaderListener;
    protected boolean keyPressed;
    protected boolean textChanged;
    protected TextFrame helpFrame;
    protected JEditorPane htmlAboutPane;
    protected TrackerDLFilter dlFileFilter = TRACKER_FILTER;
    protected boolean isResourcePathXML;
    protected LibraryManager libraryManager;
    protected ListChooser searchTargetChooser;
    protected LibraryTreePanel searchResultsTreePanel;
    ArrayList<String> searchTargetPaths;
    ArrayList<String> searchTargetNames;
    private int myFontLevel;
    static Map<String, LibraryResource> searchResourceMap;
    protected TreeMap<String, String> searchPathMap;
    static boolean isSearchMapLoaded;

    static {
        checkedWebConnection = OSPRuntime.isJS;
        TRACKER_FILTER = new TrackerDLFilter();
        filesAndFoldersFilter = new FilesAndFoldersFilter();
        fireHelpEvent = false;
        maxRecentCollectionSize = 18;
        wide = 900;
        high = 560;
        useOnlineOnly = true;
        buttonBorder = BorderFactory.createEtchedBorder();
        Border space = BorderFactory.createEmptyBorder(1, 2, 2, 2);
        buttonBorder = BorderFactory.createCompoundBorder(buttonBorder, space);
        space = BorderFactory.createEmptyBorder(0, 1, 0, 1);
        buttonBorder = BorderFactory.createCompoundBorder(space, buttonBorder);
        menubar = new JMenuBar();
        String imageFile = "/org/opensourcephysics/resources/tools/images/expand.png";
        expandIcon = ResourceLoader.getResizableIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/contract.png";
        contractIcon = ResourceLoader.getResizableIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/expand_bold.png";
        heavyExpandIcon = ResourceLoader.getResizableIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/contract_bold.png";
        heavyContractIcon = ResourceLoader.getResizableIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/refresh.gif";
        refreshIcon = ResourceLoader.getResizableIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/download.gif";
        downloadIcon = ResourceLoader.getResizableIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/downloaddisabled.gif";
        downloadDisabledIcon = ResourceLoader.getResizableIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/searchtarget.gif";
        searchTargetIcon = ResourceLoader.getResizableIcon(imageFile);
        isSearchMapLoaded = false;
    }

    public static LibraryBrowser getBrowser() {
        if (browser == null) {
            browser = LibraryBrowser.getBrowser(null);
        }
        return browser;
    }

    public static LibraryBrowser getBrowser(JDialog dialog) {
        boolean newFrame = false;
        if (frame == null && dialog == null) {
            newFrame = true;
            frame = new JFrame();
        }
        if ((externalDialog = dialog) != null) {
            externalDialog.setDefaultCloseOperation(0);
        }
        if (browser == null) {
            LibraryTreePanel treePanel;
            String ospPath;
            File libraryFile;
            boolean libraryExists;
            String libraryPath = null;
            if (!OSPRuntime.isJS && !(libraryExists = (libraryFile = new File(libraryPath = String.valueOf(ospPath = LibraryBrowser.getOSPPath()) + MY_LIBRARY_NAME)).exists())) {
                String collectionPath = String.valueOf(ospPath) + MY_COLLECTION_NAME;
                File collectionFile = new File(collectionPath);
                if (!collectionFile.exists()) {
                    String name = ToolsRes.getString("LibraryCollection.Name.Local");
                    LibraryCollection collection = new LibraryCollection(name);
                    String base = XML.getDirectoryPath(collectionPath);
                    collection.setBasePath(XML.forwardSlash(base));
                    XMLControlElement control = new XMLControlElement(collection);
                    control.write(collectionPath);
                }
                Library library = new Library();
                String name = ToolsRes.getString("LibraryCollection.Name.Local");
                library.addCollection(collectionPath, name);
                library.save(libraryPath);
            }
            if ((treePanel = (browser = new LibraryBrowser(libraryPath)).getSelectedTreePanel()) != null) {
                treePanel.setSelectedNode(treePanel.rootNode);
                treePanel.showInfo(treePanel.rootNode, "LibraryBrowser.getBrowser");
            }
            OSPLog.getOSPLog();
        }
        browser.setTitle(ToolsRes.getString("LibraryBrowser.Title"));
        if (externalDialog != null) {
            externalDialog.setContentPane(browser);
            externalDialog.setJMenuBar(menubar);
            externalDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    browser.exit();
                }
            });
            externalDialog.pack();
        } else {
            frame.setContentPane(browser);
            frame.setJMenuBar(menubar);
            frame.setDefaultCloseOperation(0);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    browser.exit();
                }
            });
            try {
                frame.setIconImage(ResourceLoader.getImageIcon("/org/opensourcephysics/resources/controls/images/osp_icon.gif").getImage());
            }
            catch (Exception libraryPath) {
                // empty catch block
            }
            frame.pack();
            if (newFrame) {
                if (OSPRuntime.isJS) {
                    int dh = frame.getHeight() - browser.getHeight();
                    double factor = 1.0 + (FontSizer.getFactor() - 1.0) * 0.5;
                    int w = (int)(factor * (double)wide);
                    int h = (int)(factor * (double)high);
                    browser.setPreferredSize(new Dimension(w, h - dh));
                    frame.pack();
                }
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                int x = (dim.width - LibraryBrowser.frame.getBounds().width) / 2;
                int y = (dim.height - LibraryBrowser.frame.getBounds().height) / 2;
                frame.setLocation(x, y);
            }
        }
        return browser;
    }

    public static boolean isPopulatedCollection(LibraryTreeNode node) {
        return node.record instanceof LibraryCollection && node.children().hasMoreElements();
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
        frame.setAlwaysOnTop(alwaysOnTop);
    }

    public void setFontLevel(int level) {
        if (this.myFontLevel == level) {
            return;
        }
        this.myFontLevel = FontSizer.setFonts(frame);
        LibraryResource.bodyFont = FontSizer.getResizedFont(LibraryResource.bodyFont, this.myFontLevel);
        LibraryResource.h1Font = FontSizer.getResizedFont(LibraryResource.h1Font, this.myFontLevel);
        LibraryResource.h2Font = FontSizer.getResizedFont(LibraryResource.h2Font, this.myFontLevel);
        LibraryResource.h3Font = FontSizer.getResizedFont(LibraryResource.h3Font, this.myFontLevel);
        LibraryTreePanel.clearMaps();
        Font font = this.tabbedPane.getFont();
        this.tabbedPane.setFont(FontSizer.getResizedFont(font, level));
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            LibraryTreePanel treePanel = this.getTreePanel(i);
            treePanel.setFontLevel(level);
            Component c = this.tabbedPane.getTabComponentAt(i);
            if (c != null && c instanceof TabTitle) {
                ((TabTitle)c).refreshFontSize();
            }
            ++i;
        }
        if (this.libraryManager != null) {
            this.libraryManager.setFontLevel(level);
        }
        OSPLog.setFonts(level);
    }

    public void importLibrary(String path) {
        SwingUtilities.invokeLater(() -> {
            this.library.importLibrary(path);
            this.refreshCollectionsMenu();
        });
    }

    public void addOSPLibrary(final String path) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                LibraryBrowser.this.library.addOSPLibrary(path);
            }
        };
        runner.run();
    }

    public void addComPADRECollection(String path) {
        this.library.addComPADRECollection(path, LibraryComPADRE.getCollectionName(path));
    }

    public synchronized void refreshCollectionsMenu() {
        JMenu submenu;
        Library lib;
        JMenuItem item;
        String name;
        JMenu menu = this.collectionsMenu;
        menu.removeAll();
        if (!OSPRuntime.isJS) {
            JMenu myLibraryMenu = new JMenu(ToolsRes.getString("Library.Name.Local"));
            menu.add(myLibraryMenu);
            if (!this.library.pathList.isEmpty()) {
                for (String path : this.library.pathList) {
                    name = this.library.pathToNameMap.get(path);
                    item = new JMenuItem(name);
                    myLibraryMenu.add(item);
                    item.addActionListener(this.loadCollectionAction);
                    item.setToolTipText(path);
                    item.setActionCommand(path);
                }
            }
        }
        if (!this.library.comPADREPathList.isEmpty()) {
            JMenu submenu2 = new JMenu(ToolsRes.getString("Library.Name.ComPADRE"));
            menu.add(submenu2);
            for (String path : this.library.comPADREPathList) {
                name = this.library.comPADREPathToNameMap.get(path);
                item = new JMenuItem(name);
                submenu2.add(item);
                item.addActionListener(this.loadCollectionAction);
                item.setToolTipText(path);
                item.setActionCommand(path);
                this.library.allPathsToNameMap.put(path, name);
            }
        }
        if (!this.library.ospLibraryPathList.isEmpty()) {
            for (String path : this.library.ospLibraryPathList) {
                lib = this.library.ospPathToLibraryMap.get(path);
                submenu = new JMenu(lib.getName());
                menu.add(submenu);
                this.populateSubMenu(submenu, lib);
            }
        }
        if (!this.library.importedPathList.isEmpty()) {
            menu.addSeparator();
            for (String path : this.library.importedPathList) {
                lib = this.library.importedPathToLibraryMap.get(path);
                submenu = new JMenu(lib.getName());
                menu.add(submenu);
                for (String next : lib.pathList) {
                    String name2 = lib.pathToNameMap.get(next);
                    JMenuItem item2 = new JMenuItem(name2);
                    submenu.add(item2);
                    item2.addActionListener(this.loadCollectionAction);
                    item2.setToolTipText(next);
                    item2.setActionCommand(next);
                    this.library.allPathsToNameMap.put(next, name2);
                }
            }
        }
        FontSizer.setMenuFonts(this.collectionsMenu);
        this.searchTargetButton.setEnabled(true);
    }

    private void populateSubMenu(JMenu menu, Library lib) {
        for (String next : lib.pathList) {
            String name = lib.pathToNameMap.get(next);
            JMenuItem item = new JMenuItem(name);
            menu.add(item);
            item.addActionListener(this.loadCollectionAction);
            item.setToolTipText(next);
            item.setActionCommand(next);
            this.library.allPathsToNameMap.put(next, name);
        }
        if (!lib.subPathList.isEmpty()) {
            for (String path : lib.subPathList) {
                if (this.library.ospLibraryPathList.contains(path)) continue;
                Library sublib = lib.subPathToLibraryMap.get(path);
                JMenu submenu = new JMenu(sublib.getName());
                menu.add(submenu);
                this.populateSubMenu(submenu, sublib);
            }
        }
    }

    public void setTitle(String title) {
        if (frame != null) {
            frame.setTitle(title);
        } else if (externalDialog != null) {
            externalDialog.setTitle(title);
        }
    }

    public FileFilter getDLFileFilter() {
        return this.dlFileFilter;
    }

    @Override
    public void setVisible(boolean vis) {
        this.setFontLevel(FontSizer.getLevel());
        super.setVisible(vis);
        Window c = (Window)this.getTopLevelAncestor();
        if (c != null) {
            c.setVisible(vis);
            if (vis) {
                SwingUtilities.invokeLater(() -> c.toFront());
            }
        }
    }

    public boolean exit() {
        LibraryTreePanel selected = this.getSelectedTreePanel();
        if (selected != null) {
            selected.refreshEntryFields();
        }
        String recentCollectionPath = OSPRuntime.isJS ? null : String.valueOf(LibraryBrowser.getOSPPath()) + RECENT_COLLECTION_NAME;
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            LibraryTreePanel treePanel = this.getTreePanel(i);
            if (!treePanel.saveChanges(this.getTabTitle(i))) {
                return false;
            }
            if (recentCollectionPath != null && recentCollectionPath.equals(treePanel.rootResource.collectionPath)) {
                treePanel.save();
            }
            ++i;
        }
        ArrayList<String> tabsToSave = new ArrayList<String>();
        int n = this.tabbedPane.getTabCount();
        int i2 = 0;
        while (i2 < n) {
            String path = this.getTreePanel((int)i2).pathToRoot;
            if (!path.equals("")) {
                tabsToSave.add(path);
            }
            ++i2;
        }
        String[] stringArray = this.library.openTabPaths = tabsToSave.isEmpty() ? null : tabsToSave.toArray(new String[tabsToSave.size()]);
        if (this.localLibraryLoaded) {
            this.library.save(this.libraryPath);
        }
        if (this.exitOnClose) {
            System.exit(0);
        } else {
            this.refreshGUI();
            this.setVisible(false);
        }
        return true;
    }

    public void cancelLoading() {
        VideoIO.setCanceled(true);
        this.setMessage("Loading canceled", Color.YELLOW);
        OSPRuntime.trigger(1000, e -> this.doneLoading());
    }

    public void doneLoading() {
        this.setComandButtonEnabled(true);
        LibraryTreePanel treePanel = this.getSelectedTreePanel();
        LibraryTreeNode node = treePanel == null ? null : treePanel.getSelectedNode();
        this.setMessage(node == null ? "" : node.getToolTip(), null);
    }

    private LibraryBrowser(String libraryPath) {
        super(new BorderLayout());
        this.libraryPath = libraryPath;
        this.library.browser = this;
        this.createGUI();
        this.refreshGUI(true);
        this.editButton.requestFocusInWindow();
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                LibraryBrowser.this.refreshGUI(true);
                LibraryBrowser.this.refreshCollectionsMenu();
                if (LibraryBrowser.this.libraryManager != null) {
                    LibraryBrowser.this.libraryManager.refreshGUI();
                }
                LibraryTreePanel.clearMaps();
                LibraryTreePanel treePanel = LibraryBrowser.this.getSelectedTreePanel();
                if (treePanel != null) {
                    treePanel.showInfo(treePanel.getSelectedNode(), "LibraryBrowser locale change");
                }
            }
        });
        FileDropHandler handler = new FileDropHandler();
        this.setTransferHandler(handler);
    }

    protected LibraryManager getManager() {
        if (this.libraryManager == null) {
            this.libraryManager = externalDialog != null ? new LibraryManager(this, externalDialog) : new LibraryManager(this, frame);
            this.libraryManager.refreshGUI();
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.libraryManager.getBounds().width) / 2;
            int y = (dim.height - this.libraryManager.getBounds().height) / 2;
            this.libraryManager.setLocation(x, y);
        }
        if (this.library.pathList.size() > 0 && this.libraryManager.collectionList.getSelectedIndex() == -1) {
            this.libraryManager.collectionList.setSelectedIndex(0);
        }
        if (this.library.importedPathList.size() > 0 && this.libraryManager.guestList.getSelectedIndex() == -1) {
            this.libraryManager.guestList.setSelectedIndex(0);
        }
        this.libraryManager.setFontLevel(FontSizer.getLevel());
        return this.libraryManager;
    }

    public LibraryTreePanel getSelectedTreePanel() {
        return (LibraryTreePanel)this.tabbedPane.getSelectedComponent();
    }

    protected LibraryTreePanel getTreePanel(int index) {
        return (LibraryTreePanel)this.tabbedPane.getComponentAt(index);
    }

    protected String getTabTitle(String path) {
        int i = this.getTabIndexFromPath(path);
        return i > -1 ? this.getTabTitle(i) : null;
    }

    protected String getTabTitle(int index) {
        String title = this.tabbedPane.getTitleAt(index);
        if (title == null) {
            return null;
        }
        if (title.endsWith("*")) {
            title = title.substring(0, title.length() - 1);
        }
        return title;
    }

    protected int getTabIndexFromPath(String path) {
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            LibraryTreePanel next = this.getTreePanel(i);
            if (next.pathToRoot.equals(path)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int getTabIndexFromTitle(String title) {
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            String next = this.tabbedPane.getTitleAt(i);
            if (next.equals(title)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void loadTab(String path, List<String> treePath) {
        if (path == null) {
            return;
        }
        path = XML.forwardSlash(path);
        this.library.addRecent(path, false);
        this.refreshRecentMenu();
        int i = this.getTabIndexFromPath(path);
        if (i > -1) {
            this.tabbedPane.setSelectedIndex(i);
            LibraryTreePanel treePanel = this.getTreePanel(i);
            treePanel.setSelectionPath(treePath);
            return;
        }
        this.loadTabAndListen(path, treePath, "LoadTab");
    }

    protected boolean loadTabAndListen(String path, List<String> treePath, final String mode) {
        return this.addTabAndExecute(path, treePath, new PropertyChangeListener(){

            /*
             * Exception decompiling
             */
            @Override
            public void propertyChange(PropertyChangeEvent e) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[5] lbl43 : CaseStatement: default:\u000a, @NONE, blocks:[5] lbl43 : CaseStatement: default:\u000a]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
                 *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
                 *     at java.base/java.util.TimSort.sort(TimSort.java:220)
                 *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
                 *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
                 *     at java.base/java.util.Collections.sort(Collections.java:178)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    public LibraryCollection getRecentCollection() {
        XMLControlElement control;
        File recentCollectionFile;
        if (OSPRuntime.isJS) {
            return null;
        }
        String path = String.valueOf(LibraryBrowser.getOSPPath()) + RECENT_COLLECTION_NAME;
        int i = this.getTabIndexFromPath(path);
        if (i > -1) {
            LibraryTreePanel treePanel = this.getTreePanel(i);
            LibraryResource record = treePanel.rootResource;
            if (record instanceof LibraryCollection) {
                return (LibraryCollection)record;
            }
        }
        if (!(recentCollectionFile = new File(path)).exists()) {
            String name = ToolsRes.getString("LibraryCollection.Name.Recent");
            LibraryCollection recentCollection = new LibraryCollection(name);
            String base = XML.getDirectoryPath(path);
            recentCollection.setBasePath(XML.forwardSlash(base));
            XMLControlElement control2 = new XMLControlElement(recentCollection);
            control2.write(path);
        }
        if (!(control = new XMLControlElement(path)).failedToRead() && control.getObjectClass() != null && LibraryCollection.class.isAssignableFrom(control.getObjectClass())) {
            LibraryCollection collection = (LibraryCollection)control.loadObject(null);
            collection.collectionPath = path;
            return collection;
        }
        return null;
    }

    protected void loadResourceAsync(String path, Function<LibraryResource, Void> whenDone) {
        this.isResourcePathXML = false;
        if (LibraryComPADRE.isComPADREPath(path)) {
            whenDone.apply(LibraryComPADRE.getCollection(path));
            return;
        }
        File targetFile = new File(path);
        if (targetFile.isDirectory()) {
            whenDone.apply(this.createCollectionFromDirectory(targetFile, targetFile, this.dlFileFilter));
            return;
        }
        XMLControlElement control = new XMLControlElement();
        control.readAsync(path, fullPath -> {
            if (control.failedToRead() || control.getObjectClass() == null || !LibraryResource.class.isAssignableFrom(control.getObjectClass())) {
                whenDone.apply(this.createResource(targetFile, targetFile.getParentFile(), this.dlFileFilter));
            } else {
                this.isResourcePathXML = true;
                whenDone.apply((LibraryResource)control.loadObject(null));
            }
            return null;
        });
    }

    protected LibraryResource loadResource(String path) {
        this.isResourcePathXML = false;
        if (LibraryComPADRE.isComPADREPath(path)) {
            return LibraryComPADRE.getCollection(path);
        }
        boolean isHTTP = ResourceLoader.isHTTP(path);
        if (!isHTTP) {
            path = ResourceLoader.getNonURIPath(path);
        }
        File targetFile = null;
        targetFile = new File(path);
        if (targetFile.isDirectory()) {
            return this.createCollectionFromDirectory(targetFile, targetFile, this.dlFileFilter);
        }
        if (!this.dlFileFilter.accept(targetFile)) {
            XMLControlElement control;
            XMLControlElement xMLControlElement = control = isHTTP ? new XMLControlElement(path) : new XMLControlElement(targetFile);
            if (!control.failedToRead() && control.getObjectClass() != null && LibraryResource.class.isAssignableFrom(control.getObjectClass())) {
                this.isResourcePathXML = true;
                return (LibraryResource)control.loadObject(null);
            }
        }
        return this.createResource(targetFile, targetFile.getParentFile(), this.dlFileFilter);
    }

    protected LibraryResource createResource(File targetFile, File baseDir, FileFilter filter) {
        Map<String, ZipEntry> contents;
        boolean isTRZ;
        if (targetFile == null || !targetFile.exists()) {
            return null;
        }
        if (!filter.accept(targetFile)) {
            return null;
        }
        String fileName = targetFile.getName();
        String path = XML.forwardSlash(targetFile.getAbsolutePath());
        String base = XML.forwardSlash(baseDir.getAbsolutePath());
        String relPath = XML.getPathRelativeTo(path, base);
        LibraryResource record = new LibraryResource(fileName);
        record.setBasePath(base);
        record.setTarget(relPath);
        fileName = fileName.toLowerCase();
        if (fileName.indexOf(".htm") > -1) {
            record.setHTMLPath(relPath);
            record.setType("HTML");
        }
        if (fileName.endsWith(".zip") && filter == TRACKER_FILTER) {
            record.setType("Tracker");
        }
        if (fileName.endsWith(".trz")) {
            record.setType("Tracker");
        }
        boolean bl = isTRZ = fileName.endsWith(".zip") && filter == TRACKER_FILTER || fileName.endsWith(".trz");
        if (isTRZ && (contents = ResourceLoader.getZipContents(path, true)) != null) {
            String baseName = XML.stripExtension(XML.getName(path));
            for (String next : contents.keySet()) {
                if (next.indexOf("_thumbnail") <= -1) continue;
                String thumb = XML.getName(next);
                baseName = thumb.substring(0, thumb.indexOf("_thumbnail"));
                break;
            }
            for (String next : contents.keySet()) {
                String nextName;
                if (!next.endsWith(".html") && !next.endsWith(".htm") || !XML.stripExtension(nextName = XML.getName(next)).equals(String.valueOf(baseName) + "_info")) continue;
                String trzName = XML.getName(path);
                record.setHTMLPath(String.valueOf(trzName) + "!/" + next);
                break;
            }
        }
        return record;
    }

    private LibraryCollection createCollectionFromDirectory(File targetDir, File base, FileFilter filter) {
        String fileName;
        File[] resourceFiles;
        File[] subdirs;
        HTMLFilter htmlFilter = new HTMLFilter();
        File[] htmlFiles = targetDir.listFiles(htmlFilter);
        HashSet<File> matchedNames = new HashSet<File>();
        String name = targetDir.getName();
        LibraryCollection collection = new LibraryCollection(name);
        if (base == targetDir) {
            collection.setBasePath(XML.forwardSlash(base.getAbsolutePath()));
        }
        File[] fileArray = htmlFiles;
        int n = htmlFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File htmlFile = fileArray[n2];
            if (XML.stripExtension(htmlFile.getName()).equals(String.valueOf(name) + "_info")) {
                String relPath = XML.getPathRelativeTo(htmlFile.getAbsolutePath(), base.getAbsolutePath());
                collection.setHTMLPath(relPath);
                String htmlCode = ResourceLoader.getHTMLCode(htmlFile.getAbsolutePath());
                String title = ResourceLoader.getTitleFromHTMLCode(htmlCode);
                if (title != null) {
                    collection.setName(title);
                }
                matchedNames.add(htmlFile);
            }
            ++n2;
        }
        File[] fileArray2 = subdirs = targetDir.listFiles(new DirectoryFilter());
        int n3 = subdirs.length;
        n = 0;
        while (n < n3) {
            File dir = fileArray2[n];
            LibraryCollection subCollection = this.createCollectionFromDirectory(dir, base, filter);
            if (subCollection.getResources().length > 0) {
                collection.addResource(subCollection);
            }
            ++n;
        }
        File[] fileArray3 = resourceFiles = filter == null ? targetDir.listFiles() : targetDir.listFiles(filter);
        int n4 = resourceFiles.length;
        n3 = 0;
        while (n3 < n4) {
            File next = fileArray3[n3];
            if (!htmlFilter.accept(next)) {
                String relPath = XML.getPathRelativeTo(next.getAbsolutePath(), base.getAbsolutePath());
                fileName = next.getName();
                String baseName = XML.stripExtension(fileName);
                LibraryResource record = new LibraryResource(fileName);
                collection.addResource(record);
                record.setTarget(relPath);
                if (fileName.toLowerCase().endsWith(".zip") && filter == TRACKER_FILTER) {
                    record.setType("Tracker");
                }
                if (fileName.toLowerCase().endsWith(".trz")) {
                    record.setType("Tracker");
                }
                File[] fileArray4 = htmlFiles;
                int n5 = htmlFiles.length;
                int n6 = 0;
                while (n6 < n5) {
                    File htmlFile = fileArray4[n6];
                    String htmlName = XML.stripExtension(htmlFile.getName());
                    if (htmlName.equals(String.valueOf(baseName) + "_info")) {
                        if ("".equals(record.getHTMLPath())) {
                            relPath = XML.getPathRelativeTo(htmlFile.getAbsolutePath(), base.getAbsolutePath());
                            record.setHTMLPath(relPath);
                            String htmlCode = ResourceLoader.getHTMLCode(htmlFile.getAbsolutePath());
                            String title = ResourceLoader.getTitleFromHTMLCode(htmlCode);
                            if (title != null) {
                                record.setName(title);
                            }
                        }
                        matchedNames.add(htmlFile);
                        break;
                    }
                    ++n6;
                }
            }
            ++n3;
        }
        int i = 0;
        File[] fileArray5 = htmlFiles;
        int n7 = htmlFiles.length;
        n4 = 0;
        while (n4 < n7) {
            File html = fileArray5[n4];
            if (!matchedNames.contains(html) && (filter == null || filter.accept(html))) {
                fileName = html.getName();
                LibraryResource record = new LibraryResource(fileName);
                String relPath = XML.getPathRelativeTo(html.getAbsolutePath(), base.getAbsolutePath());
                record.setHTMLPath(relPath);
                record.setType("HTML");
                collection.insertResource(record, i++);
            }
            ++n4;
        }
        return collection;
    }

    protected boolean addTabAndExecute(String path, List<String> treePath, PropertyChangeListener listener) {
        if (path == null) {
            return false;
        }
        File cachedFile = ResourceLoader.getSearchCacheFile(path);
        boolean isCachePath = cachedFile.exists() && this.metadataLoaderListener == null;
        boolean[] isDialogShown = new boolean[1];
        if (!isCachePath && ResourceLoader.isHTTP(path) && !this.isWebConnected(isDialogShown) && !ResourceLoader.ignoreMissingWebConnection) {
            if (!isDialogShown[0] && ResourceLoader.showWebConnectionDialog() == 1) {
                checkedWebConnection = false;
                ResourceLoader.clearWebTest();
                return this.addTabAndExecute(path, treePath, listener);
            }
            return false;
        }
        this.loadTabAsync(path, -1, treePath, listener);
        return true;
    }

    protected void refreshTabTitle(String path, LibraryResource collection) {
        boolean changed;
        int n = this.getTabIndexFromPath(path);
        if (n == -1) {
            return;
        }
        String title = this.library.getNameMap().get(path);
        if (title == null) {
            title = collection.getTitle(path);
        }
        if (path.contains("https://www.compadre.org/osp/services/REST/osp_tracker.cfm?verb=Identify&OSPType=Tracker") && this.tabbedPane.getTabComponentAt(n) == null) {
            boolean primary = path.contains("OSPPrimary");
            ResizableIcon icon = primary ? expandIcon : contractIcon;
            ResizableIcon heavyIcon = primary ? heavyExpandIcon : heavyContractIcon;
            TabTitle tabTitle = new TabTitle(icon, heavyIcon);
            tabTitle.refreshFontSize();
            tabTitle.iconLabel.setToolTipText(primary ? ToolsRes.getString("LibraryBrowser.Tooltip.Expand") : ToolsRes.getString("LibraryBrowser.Tooltip.Contract"));
            this.tabbedPane.setTabComponentAt(n, tabTitle);
        }
        this.tabbedPane.setTitleAt(n, (changed = this.getTreePanel(n).isChanged()) ? String.valueOf(title) + "*" : title);
        this.library.getNameMap().put(path, title);
        if (n == this.tabbedPane.getSelectedIndex()) {
            String tabname = " '" + title + "'";
            this.closeItem.setText(String.valueOf(ToolsRes.getString("LibraryBrowser.MenuItem.CloseTab")) + tabname);
        }
    }

    protected void loadTabAsync(String path, int index, List<String> treePath, PropertyChangeListener listener) {
        TabLoader loader = new TabLoader(path, index, treePath);
        if (listener != null) {
            loader.addPropertyChangeListener(listener);
        }
        loader.execute();
    }

    protected void createGUI() {
        double factor = 1.0 + (FontSizer.getFactor() - 1.0) * 0.5;
        int w = (int)(factor * (double)wide);
        int h = (int)(factor * (double)high);
        this.setPreferredSize(new Dimension(w, h));
        this.loadCollectionAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryBrowser.this.loadTab(e.getActionCommand(), null);
            }
        };
        this.commandAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryBrowser.this.doCommand();
            }
        };
        this.downloadAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryBrowser.this.doDownload();
            }
        };
        this.commandLabel = new JLabel();
        this.commandLabel.setAlignmentX(0.5f);
        this.commandLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 2));
        this.commandField = new JTextField(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                return dim;
            }
        };
        LibraryTreePanel.defaultForeground = this.commandField.getForeground();
        this.commandField.addActionListener(this.commandAction);
        this.commandField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                String text = LibraryBrowser.this.commandField.getText();
                boolean enable = !"".equals(text);
                LibraryBrowser.this.openButton.setEnabled(enable);
                LibraryBrowser.this.downloadButton.setEnabled(enable);
                LibraryBrowser.this.textChanged = LibraryBrowser.this.keyPressed;
                LibraryTreePanel treePanel = LibraryBrowser.this.getSelectedTreePanel();
                if (treePanel != null) {
                    treePanel.command = text;
                    LibraryTreeNode node = treePanel.getSelectedNode();
                    if (node != null && node.isRoot() && node.record instanceof LibraryCollection && treePanel.pathToRoot.equals(text)) {
                        LibraryBrowser.this.openButton.setEnabled(false);
                        LibraryBrowser.this.downloadButton.setEnabled(false);
                    }
                } else {
                    LibraryBrowser.this.commandField.setBackground(Color.yellow);
                    LibraryBrowser.this.commandField.setForeground(LibraryTreePanel.defaultForeground);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                boolean enable = !"".equals(LibraryBrowser.this.commandField.getText());
                LibraryBrowser.this.openButton.setEnabled(enable);
                LibraryBrowser.this.downloadButton.setEnabled(enable);
                LibraryBrowser.this.textChanged = LibraryBrowser.this.keyPressed;
                LibraryTreePanel treePanel = LibraryBrowser.this.getSelectedTreePanel();
                if (treePanel != null) {
                    treePanel.command = LibraryBrowser.this.commandField.getText();
                } else {
                    LibraryBrowser.this.commandField.setBackground(Color.yellow);
                    LibraryBrowser.this.commandField.setForeground(LibraryTreePanel.defaultForeground);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.commandField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                LibraryBrowser.this.keyPressed = true;
            }

            @Override
            public void keyReleased(KeyEvent e) {
                LibraryTreePanel treePanel = LibraryBrowser.this.getSelectedTreePanel();
                if (treePanel != null && LibraryBrowser.this.textChanged && e.getKeyCode() != 10) {
                    LibraryBrowser.this.commandField.setBackground(Color.yellow);
                    LibraryBrowser.this.commandField.setForeground(LibraryTreePanel.defaultForeground);
                    treePanel.setSelectedNode(null);
                }
                LibraryBrowser.this.keyPressed = false;
                LibraryBrowser.this.textChanged = false;
            }
        });
        this.commandField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LibraryBrowser.this.commandField.selectAll();
            }
        });
        this.openButton = new OSPButton(this.commandAction);
        this.downloadButton = new OSPButton(this.downloadAction);
        this.downloadButton.setIcon(downloadIcon);
        this.downloadButton.setDisabledIcon(downloadDisabledIcon);
        this.searchAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryBrowser.this.doSearch();
            }
        };
        this.searchLabel = new JLabel();
        this.searchLabel.setAlignmentX(0.5f);
        this.searchLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
        this.searchField = new LibraryTreePanel.EntryField(){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                dim.width = (int)(120.0 * FontSizer.getFactor());
                return dim;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = (int)(120.0 * FontSizer.getFactor());
                return dim;
            }
        };
        this.searchField.addActionListener(this.searchAction);
        this.searchTargetButton = new OSPButton(searchTargetIcon);
        this.searchTargetButton.addActionListener(e -> this.chooseSearchTargets());
        this.searchTargetButton.setToolTipText(ToolsRes.getString("LibraryBrowser.Dialog.SearchTargets.Text"));
        this.searchTargetButton.setEnabled(false);
        this.refreshButton = new OSPButton(refreshIcon);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryTreePanel treePanel = LibraryBrowser.this.getSelectedTreePanel();
                if (treePanel == null) {
                    return;
                }
                LibraryTreeNode node = treePanel.getSelectedNode();
                if (node == treePanel.rootNode) {
                    LibraryResource resource;
                    File cachedFile = ResourceLoader.getSearchCacheFile(treePanel.pathToRoot);
                    if (cachedFile.exists()) {
                        cachedFile.delete();
                    }
                    if ((resource = LibraryBrowser.this.loadResource(treePanel.pathToRoot)) != null) {
                        boolean isXML = treePanel.pathToRoot.toLowerCase().endsWith(".xml");
                        treePanel.setRootResource(resource, treePanel.pathToRoot, treePanel.rootNode.isEditable(), isXML);
                        LibraryBrowser.this.refreshTabTitle(treePanel.pathToRoot, treePanel.rootResource);
                        if (treePanel.metadataLoader != null) {
                            treePanel.metadataLoader.cancel();
                        }
                        LibraryTreePanel libraryTreePanel = treePanel;
                        libraryTreePanel.getClass();
                        treePanel.metadataLoader = new LibraryTreePanel.MetadataLoader(libraryTreePanel, null);
                        treePanel.metadataLoader.execute();
                        LibraryBrowser.this.refreshGUI(false);
                        return;
                    }
                } else if (node != null) {
                    File thumb;
                    LibraryTreePanel.HTMLPane pane = new LibraryTreePanel.HTMLPane();
                    pane.setText("<h2>" + ToolsRes.getString("LibraryBrowser.Info.Refreshing") + " '" + node + "'</h2>");
                    treePanel.htmlScroller.setViewportView(pane);
                    URL url = node.getHTMLURL();
                    if (url != null) {
                        File cachedFile = ResourceLoader.getOSPCacheFile(url.toExternalForm());
                        if (cachedFile.exists()) {
                            cachedFile.delete();
                        }
                        LibraryTreePanel.htmlPanesByURL.remove(url);
                    }
                    String target = node.getAbsoluteTarget();
                    if (OSPRuntime.doCacheThumbnail && target != null && (thumb = node.getThumbnailFile()).exists()) {
                        thumb.delete();
                        node.record.setThumbnail(null);
                    }
                    node.record.setMetadata(null);
                    node.record.setDescription(null);
                    node.tooltip = null;
                    node.metadataSource = null;
                    LibraryTreePanel libraryTreePanel = treePanel;
                    libraryTreePanel.getClass();
                    new LibraryTreePanel.NodeLoader(libraryTreePanel, node).execute();
                }
            }
        });
        this.tabbedPane = new JTabbedPane(1){

            @Override
            public void setTitleAt(int i, String title) {
                super.setTitleAt(i, title);
                TabTitle tab = (TabTitle)LibraryBrowser.this.tabbedPane.getTabComponentAt(i);
                if (tab != null) {
                    tab.setTitle(title);
                }
            }
        };
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LibraryBrowser.this.refreshGUI();
                LibraryTreePanel treePanel = LibraryBrowser.this.getSelectedTreePanel();
                if (treePanel != null) {
                    LibraryTreeNode node = treePanel.getSelectedNode();
                    if (node != null) {
                        String path = node.isRoot() ? treePanel.pathToRoot : node.getAbsoluteTarget();
                        LibraryBrowser.this.commandField.setText(path);
                        LibraryBrowser.this.setMessage(node.getToolTip(), null);
                        treePanel.showInfo(node, "tabbedPaneChange");
                    } else {
                        LibraryBrowser.this.commandField.setText(treePanel.command);
                        LibraryBrowser.this.commandField.setCaretPosition(0);
                    }
                }
                LibraryBrowser.this.commandField.setBackground(Color.white);
                LibraryBrowser.this.commandField.setForeground(LibraryTreePanel.defaultForeground);
                if (LibraryBrowser.this.libraryManager != null && LibraryBrowser.this.libraryManager.isVisible()) {
                    LibraryBrowser.this.libraryManager.refreshGUI();
                }
            }
        });
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!OSPRuntime.isPopupTrigger(e)) {
                    return;
                }
                JPopupMenu popup = new JPopupMenu();
                JMenuItem item = new JMenuItem(ToolsRes.getString("MenuItem.Close"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int i = (this).LibraryBrowser.this.tabbedPane.getSelectedIndex();
                        LibraryBrowser.this.closeTab(i);
                    }
                });
                popup.add(item);
                final LibraryTreePanel treePanel = LibraryBrowser.this.getSelectedTreePanel();
                if (!"".equals(treePanel.pathToRoot) && !LibraryBrowser.this.library.containsPath(treePanel.pathToRoot, false)) {
                    item = new JMenuItem(ToolsRes.getString("LibraryBrowser.MenuItem.AddToLibrary"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LibraryBrowser.this.addToCollections(treePanel.pathToRoot);
                        }
                    });
                    popup.addSeparator();
                    popup.add(item);
                }
                FontSizer.setFonts(popup, FontSizer.getLevel());
                popup.show(LibraryBrowser.this.tabbedPane, e.getX(), e.getY() + 8);
            }
        });
        this.treePanelListener = new PropertyChangeListener(){

            /*
             * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
             * Enabled aggressive block sorting
             */
            @Override
            public void propertyChange(PropertyChangeEvent e) {
                switch (e.getPropertyName()) {
                    default: {
                        return;
                    }
                    case "collection_edit": {
                        LibraryBrowser.this.refreshGUI();
                        return;
                    }
                    case "target": 
                }
                Object hint = e.getOldValue();
                Object newValue = e.getNewValue();
                LibraryTreeNode node = null;
                LibraryResource record = null;
                if (newValue instanceof LibraryTreeNode) {
                    node = (LibraryTreeNode)newValue;
                    String target = node.getTarget();
                    if (LibraryBrowser.isPopulatedCollection(node) || target != null && target.startsWith("&OSPSubject=")) {
                        LibraryBrowser.this.processTargetCollection(node);
                        return;
                    }
                    record = node.record.getClone();
                    record.setBasePath(node.getBasePath());
                } else if (newValue instanceof LibraryResource) {
                    record = (LibraryResource)newValue;
                }
                LibraryBrowser.this.processTargetSelection(record, hint);
            }
        };
        this.editButton = new OSPButton();
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final LibraryTreePanel treePanel = LibraryBrowser.this.getSelectedTreePanel();
                if (treePanel == null) {
                    return;
                }
                if (!treePanel.isEditing()) {
                    treePanel.setEditing(true);
                    LibraryBrowser.this.refreshGUI();
                } else if (!treePanel.isChanged()) {
                    treePanel.setEditing(false);
                    LibraryBrowser.this.refreshGUI();
                } else {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem item = new JMenuItem(ToolsRes.getString("LibraryBrowser.MenuItem.SaveEdits"));
                    popup.add(item);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String path = LibraryBrowser.this.save();
                            if (path == null) {
                                return;
                            }
                            treePanel.setEditing(false);
                            LibraryBrowser.this.refreshGUI();
                        }
                    });
                    item = new JMenuItem(ToolsRes.getString("LibraryBrowser.MenuItem.Discard"));
                    popup.add(item);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            treePanel.setEditing(false);
                            treePanel.revert();
                            LibraryBrowser.this.refreshGUI();
                        }
                    });
                    FontSizer.setFonts(popup, FontSizer.getLevel());
                    popup.show(LibraryBrowser.this.editButton, 0, LibraryBrowser.this.editButton.getHeight());
                }
            }
        });
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        Border empty = BorderFactory.createEmptyBorder(1, 2, 1, 2);
        Border etched = BorderFactory.createEtchedBorder();
        this.toolbar.setBorder(BorderFactory.createCompoundBorder(etched, empty));
        this.toolbar.add(this.commandLabel);
        this.toolbar.add(this.commandField);
        this.toolbar.add(this.openButton);
        this.toolbar.add(this.downloadButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.searchTargetButton);
        this.toolbar.add(this.searchLabel);
        this.toolbar.add(this.searchField);
        this.toolbar.addSeparator();
        this.toolbar.add(this.editButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.refreshButton);
        this.add((Component)this.toolbar, "North");
        this.fileMenu = new JMenu();
        menubar.add(this.fileMenu);
        this.newItem = new JMenuItem();
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.newItem.setAccelerator(KeyStroke.getKeyStroke(78, mask));
        this.newItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryBrowser.this.createNewCollection();
            }
        });
        this.openItem = new JMenuItem();
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, mask));
        this.openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryBrowser.this.open();
            }
        });
        this.closeItem = new JMenuItem();
        this.closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = LibraryBrowser.this.tabbedPane.getSelectedIndex();
                if (LibraryBrowser.this.closeTab(i)) {
                    LibraryBrowser.this.refreshGUI();
                }
            }
        });
        this.closeAllItem = new JMenuItem();
        this.closeAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = LibraryBrowser.this.tabbedPane.getTabCount() - 1;
                while (i >= 0) {
                    if (!LibraryBrowser.this.closeTab(i)) break;
                    --i;
                }
                LibraryBrowser.this.refreshGUI();
            }
        });
        this.recentMenu = new JMenu();
        this.fileMenu.add(this.recentMenu);
        this.saveItem = new JMenuItem();
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, mask));
        this.saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryBrowser.this.save();
            }
        });
        this.saveAsItem = new JMenuItem();
        this.saveAsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = LibraryBrowser.this.saveAs();
                LibraryBrowser.this.library.addRecent(path, false);
                LibraryBrowser.this.refreshRecentMenu();
            }
        });
        this.exitItem = new JMenuItem();
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, mask));
        this.exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryBrowser.this.exit();
            }
        });
        this.collectionsMenu = new JMenu();
        menubar.add(this.collectionsMenu);
        this.manageMenu = new JMenu();
        if (!OSPRuntime.isJS) {
            menubar.add(this.manageMenu);
        }
        this.collectionsItem = new JMenuItem();
        this.manageMenu.add(this.collectionsItem);
        this.collectionsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryManager manager = browser.getManager();
                manager.tabbedPane.setSelectedComponent(manager.collectionsPanel);
                manager.setVisible(true);
            }
        });
        this.cacheItem = new JMenuItem();
        this.manageMenu.add(this.cacheItem);
        this.cacheItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryManager manager = browser.getManager();
                manager.tabbedPane.setSelectedComponent(manager.cachePanel);
                manager.setVisible(true);
            }
        });
        this.searchItem = new JMenuItem();
        this.manageMenu.add(this.searchItem);
        this.searchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryManager manager = browser.getManager();
                manager.tabbedPane.setSelectedComponent(manager.searchPanel);
                manager.setVisible(true);
            }
        });
        this.helpMenu = new JMenu();
        menubar.add(this.helpMenu);
        this.helpItem = new JMenuItem();
        this.helpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryBrowser.this.showHelp();
            }
        });
        this.helpMenu.add(this.helpItem);
        this.helpMenu.addSeparator();
        this.logItem = new JMenuItem();
        this.logItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSPLog.showLogInvokeLater();
            }
        });
        this.helpMenu.add(this.logItem);
        this.helpMenu.addSeparator();
        this.aboutItem = new JMenuItem();
        this.aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryBrowser.this.showAboutDialog();
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.htmlAboutPane = new LibraryTreePanel.HTMLPane();
        this.htmlScroller = new JScrollPane(this.htmlAboutPane);
        this.htmlAboutPane.setText(this.getAboutLibraryBrowserText());
        this.htmlAboutPane.setCaretPosition(0);
        if (externalDialog != null) {
            externalDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    new LibraryLoader().execute();
                }
            });
        } else {
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    new LibraryLoader().execute();
                }
            });
        }
        this.messageButton = new JButton();
        this.messageButton.addActionListener(e -> {
            if (this.messageButton.getBackground() == Color.YELLOW) {
                this.cancelLoading();
            }
        });
        this.messageButton.setHorizontalAlignment(2);
        this.messageButton.setBorder(BorderFactory.createEmptyBorder(1, 6, 1, 6));
        this.add((Component)this.messageButton, "South");
        this.messageButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    LibraryBrowser.this.cancelLoading();
                }
            }
        });
        this.setMessage(null, null);
    }

    protected void flashOpen() {
        this.openButton.setForeground(Color.yellow);
        Timer t = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryBrowser.this.openButton.setForeground(Color.black);
            }
        });
        t.setRepeats(false);
        t.start();
    }

    public void setMessage(String message, Color color) {
        boolean isEmpty = message == null || "".equals(message.trim());
        this.messageButton.setText(isEmpty ? " " : message);
        this.messageButton.setBackground(color != null ? color : Color.WHITE);
        this.messageButton.setFont(color != null ? this.openButton.getFont() : this.commandField.getFont());
        if (color != null) {
            this.messageButton.requestFocusInWindow();
        }
    }

    protected void processTargetCollection(final LibraryTreeNode node) {
        Runnable onSuccess = new Runnable(){

            @Override
            public void run() {
                node.createChildNodes();
                LibraryTreePanel.htmlPanesByNode.remove(node);
                LibraryBrowser.this.getSelectedTreePanel().scrollToPath(((LibraryTreeNode)node.getLastChild()).getTreePath(), false);
                LibraryBrowser.this.getSelectedTreePanel().showInfo(node, "LibraryBrowser.processTargetCollection");
                LibraryBrowser.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        Runnable onFailure = new Runnable(){

            @Override
            public void run() {
                LibraryBrowser.this.setCursor(Cursor.getDefaultCursor());
                String s = "\"" + node.getName() + "\"";
                JOptionPane.showMessageDialog(browser, ToolsRes.getString("LibraryBrowser.Dialog.NoResources.Message"), s, -1);
            }
        };
        this.setCursor(Cursor.getPredefinedCursor(3));
        LibraryComPADRE.loadResources(node, onSuccess, onFailure);
    }

    protected void processTargetSelection(LibraryResource record, Object hint) {
        block47: {
            String target;
            block46: {
                PropertyChangeListener[] listeners;
                if (record == null) {
                    return;
                }
                target = record.getAbsoluteTarget();
                String uriPath = ResourceLoader.getURIPath(target);
                if (ResourceLoader.isHTTP(uriPath) && !ResourceLoader.isURLAvailable(uriPath)) {
                    new AsyncDialog().showMessageDialog(frame, String.valueOf(ToolsRes.getString("LibraryBrowser.Dialog.NoResources.File")) + " \"" + XML.getName(target) + "\" " + ToolsRes.getString("LibraryBrowser.Dialog.NoResources.Message"), ToolsRes.getString("LibraryBrowser.Dialog.NoResources.Title"), 2, e -> {});
                    return;
                }
                if (target != null && (target.toLowerCase().endsWith(".pdf") || target.toLowerCase().endsWith(".html") || target.toLowerCase().endsWith(".htm") || "URL".equals(record.getType()))) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    OSPDesktop.displayURL(uriPath);
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                if (record instanceof LibraryCollection && target != null && target.toLowerCase().endsWith(".xml")) {
                    this.open(target);
                }
                if ((listeners = this.getPropertyChangeListeners(PROPERTY_LIBRARY_TARGET)).length <= 0 || "EJS".equals(record.getType()) || "URL".equals(record.getType()) || "Collection".equals(record.getType())) break block46;
                this.firePropertyChange(PROPERTY_LIBRARY_TARGET, hint, record);
                break block47;
            }
            String type = record.getType();
            if ("Unknown".equals(type)) {
                type = LibraryResource.getTypeFromPath(target, null);
            }
            switch (type) {
                case "Image": 
                case "Video": 
                case "Tracker": {
                    String encodedUrl;
                    String trackerHome = (String)OSPRuntime.getPreference("TRACKER_HOME");
                    boolean launched = false;
                    if (trackerHome != null && !useOnlineOnly) {
                        trackerHome = XML.forwardSlash(trackerHome);
                        try {
                            JREFinder jreFinder = JREFinder.getFinder();
                            File jreFile = jreFinder.getDefaultJRE(64, trackerHome, true, "OpenJDK");
                            if (jreFile != null) {
                                ArrayList<String> cmd = new ArrayList<String>();
                                cmd.add(String.valueOf(XML.forwardSlash(jreFile.getAbsolutePath())) + "/bin/java");
                                cmd.add("-jar");
                                cmd.add(String.valueOf(trackerHome) + "/tracker_starter.jar");
                                cmd.add(target);
                                launched = true;
                                ProcessBuilder builder = new ProcessBuilder(cmd);
                                Process process = builder.start();
                                int result = process.waitFor();
                                if (result > 0) {
                                    launched = false;
                                }
                            }
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (launched) break;
                    try {
                        encodedUrl = URLEncoder.encode(target, StandardCharsets.UTF_8.toString());
                        OSPDesktop.displayURL(TRACKER_ONLINE + encodedUrl);
                    }
                    catch (UnsupportedEncodingException e3) {
                        e3.printStackTrace();
                    }
                    break;
                }
                case "EJS": {
                    try {
                        String tar = target;
                        String name = "&name=" + record.getName();
                        int n = target.indexOf("&name=");
                        if (n > 0) {
                            name = target.substring(n);
                            tar = target.substring(0, n);
                        }
                        String encodedUrl = URLEncoder.encode(tar, StandardCharsets.UTF_8.toString());
                        encodedUrl = String.valueOf(encodedUrl) + name;
                        OSPDesktop.displayURL(WEB_EJS + encodedUrl);
                    }
                    catch (UnsupportedEncodingException e4) {
                        e4.printStackTrace();
                    }
                    break;
                }
                case "Data": {
                    String encodedUrl;
                    try {
                        encodedUrl = URLEncoder.encode(target, StandardCharsets.UTF_8.toString());
                        OSPDesktop.displayURL(DATATOOL_ONLINE + encodedUrl);
                    }
                    catch (UnsupportedEncodingException e5) {
                        e5.printStackTrace();
                    }
                    break;
                }
                case "URL": {
                    String encodedUrl;
                    try {
                        encodedUrl = URLEncoder.encode(target, StandardCharsets.UTF_8.toString());
                        OSPDesktop.displayURL(DATATOOL_ONLINE + encodedUrl);
                        break;
                    }
                    catch (UnsupportedEncodingException e6) {
                        e6.printStackTrace();
                    }
                }
            }
        }
        if (hint == HINT_LOAD_RESOURCE) {
            boolean isLocalTRZ;
            String recentCollectionPath = String.valueOf(LibraryBrowser.getOSPPath()) + RECENT_COLLECTION_NAME;
            int index = this.getTabIndexFromPath(recentCollectionPath);
            boolean bl = isLocalTRZ = !ResourceLoader.isHTTP(record.getAbsoluteTarget()) && ResourceLoader.isJarZipTrz(record.getAbsoluteTarget().toLowerCase(), false);
            if (isLocalTRZ && index >= 0) {
                LibraryCollection collection = this.getRecentCollection();
                LibraryResource child = this.loadResource(record.getAbsoluteTarget());
                if (child != null) {
                    LibraryResource duplicate = null;
                    LibraryResource[] resArray = collection.getResources();
                    int i = 0;
                    while (i < resArray.length) {
                        LibraryResource next = resArray[i];
                        if (next.getAbsoluteTarget().equals(child.getAbsoluteTarget())) {
                            duplicate = next;
                            break;
                        }
                        ++i;
                    }
                    if (duplicate != null) {
                        collection.removeResource(duplicate);
                    }
                    collection.insertResource(child, 0);
                    String prevName = child.getName();
                    List<String> treePath = child.getTreePath(null);
                    child.setName(prevName);
                    LibraryTreePanel treePanel = this.getTreePanel(index);
                    treePanel.setRootResource(collection, treePanel.pathToRoot, false, true);
                    treePanel.setSelectionPath(treePath);
                    if (treePanel.metadataLoader != null) {
                        treePanel.metadataLoader.cancel();
                    }
                    LibraryTreePanel libraryTreePanel = treePanel;
                    libraryTreePanel.getClass();
                    treePanel.metadataLoader = new LibraryTreePanel.MetadataLoader(libraryTreePanel, treePath);
                    treePanel.metadataLoader.execute();
                }
            }
        }
    }

    protected void doSearch() {
        String searchTerm = this.searchField.getText().trim();
        if (searchTerm.length() == 0) {
            return;
        }
        this.searchField.selectAll();
        this.searchField.setBackground(Color.white);
        new Searcher(searchTerm).execute();
    }

    protected void doDownload() {
        String urlPath = this.commandField.getText().trim();
        if (urlPath == null || "".equals(urlPath)) {
            return;
        }
        String uriPath = ResourceLoader.getURIPath(urlPath);
        LibraryTreePanel treePanel = this.getSelectedTreePanel();
        LibraryTreeNode node = treePanel == null ? null : treePanel.getSelectedNode();
        LibraryResource record = node == null ? null : node.record;
        String name = this.getDownloadName(urlPath, record);
        VideoIO.getChooserFilesAsync("save resource " + name, files -> {
            File file;
            if (VideoIO.getChooser().getSelectedOption() == 0 && files != null && (file = ResourceLoader.downloadResourceFromDialog(uriPath, files[0])) != null) {
                this.firePropertyChange(PROPERTY_LIBRARY_TARGET, HINT_DOWNLOAD_RESOURCE, file);
            }
            return null;
        });
    }

    private String getDownloadName(String name, LibraryResource record) {
        String target;
        String string = target = record == null ? name : record.getAbsoluteTarget();
        if (target.indexOf("document/ServeFile.cfm?") >= 0) {
            String string2 = target = record == null ? null : record.getProperty("download_filename");
            if (target != null) {
                return target;
            }
            name = String.valueOf(name) + ".zip";
        }
        return XML.getName(ResourceLoader.getNonURIPath(name));
    }

    protected void doCommand() {
        boolean isCollection;
        LibraryTreeNode node;
        if (!this.openButton.isEnabled()) {
            return;
        }
        this.commandField.setBackground(Color.white);
        this.commandField.setForeground(LibraryTreePanel.defaultForeground);
        LibraryResource record = null;
        String path = this.commandField.getText().trim();
        LibraryTreePanel tpanel = this.getSelectedTreePanel();
        LibraryTreeNode libraryTreeNode = node = tpanel == null ? null : tpanel.getSelectedNode();
        if (node != null && path.equals(node.getAbsoluteTarget())) {
            if (node.record != null && !path.equals(node.record.getAbsoluteTarget())) {
                node.record.setBasePath(node.getBasePath());
            }
            this.processTargetSelection(node.record, HINT_LOAD_RESOURCE);
            return;
        }
        if (path.equals("")) {
            return;
        }
        path = XML.forwardSlash(path);
        Resource res = null;
        ResourceLoader.warningShown = false;
        String xmlPath = ResourceLoader.getNonURIPath(path);
        if (ResourceLoader.isHTTP(path)) {
            path = path.replace("/OSP/", "/osp/");
            if (OSPRuntime.isJS) {
                path = path.replace("http:", "https:");
            }
        }
        if (!path.startsWith("https://www.compadre.org/osp/") && XML.getExtension(path) == null) {
            while (xmlPath.endsWith("/")) {
                xmlPath = xmlPath.substring(0, xmlPath.length() - 1);
            }
            if (!xmlPath.equals("")) {
                String name = XML.getName(xmlPath);
                xmlPath = String.valueOf(xmlPath) + "/" + name + ".xml";
                res = ResourceLoader.getResource(xmlPath);
            }
        }
        if (res != null) {
            path = xmlPath;
        } else {
            res = ResourceLoader.getResourceZipURLsOK(path);
        }
        if (res == null) {
            this.commandField.setForeground(LibraryTreePanel.darkRed);
            return;
        }
        boolean bl = isCollection = res.getFile() != null && res.getFile().isDirectory() || !this.dlFileFilter.acceptPath(path) && "LibraryCollection".equals(res.getXMLClassName());
        if (isCollection) {
            this.loadTab(path, null);
            this.refreshGUI();
            LibraryTreePanel treePanel = this.getSelectedTreePanel();
            if (treePanel != null && treePanel.pathToRoot.equals(path)) {
                treePanel.setSelectedNode(treePanel.rootNode);
                this.commandField.setBackground(Color.white);
                this.commandField.repaint();
            }
            return;
        }
        record = new LibraryResource("");
        record.setTarget(path);
        record.setProperty("download_filename", this.getDownloadName(path, null));
        this.firePropertyChange(PROPERTY_LIBRARY_TARGET, HINT_LOAD_RESOURCE, record);
    }

    public void setComandButtonEnabled(boolean enabled) {
        String text = this.commandField.getText();
        this.openButton.setEnabled(enabled && !"".equals(text));
    }

    protected void refreshGUI() {
        this.refreshGUI(false);
    }

    protected void refreshGUI(boolean andRebuild) {
        LibraryTreePanel treePanel;
        if (this.tabbedPane.getTabCount() == 0) {
            if (this.htmlScroller.getParent() != this) {
                this.remove(this.tabbedPane);
                this.add((Component)this.htmlScroller, "Center");
                this.validate();
            }
        } else if (this.tabbedPane.getParent() != this) {
            this.remove(this.htmlScroller);
            this.add((Component)this.tabbedPane, "Center");
        }
        if (andRebuild) {
            this.setTitle(ToolsRes.getString("LibraryBrowser.Title"));
            this.fileMenu.setText(ToolsRes.getString("Menu.File"));
            this.newItem.setText(ToolsRes.getString("LibraryBrowser.MenuItem.New"));
            this.openItem.setText(ToolsRes.getString("LibraryBrowser.MenuItem.Open"));
            this.closeAllItem.setText(ToolsRes.getString("LibraryBrowser.MenuItem.CloseAll"));
            this.saveItem.setText(ToolsRes.getString("LibraryBrowser.MenuItem.Save"));
            this.saveAsItem.setText(ToolsRes.getString("LibraryBrowser.MenuItem.SaveAs"));
            this.exitItem.setText(ToolsRes.getString("MenuItem.Exit"));
            this.collectionsMenu.setText(ToolsRes.getString("LibraryBrowser.Menu.Collections"));
            this.manageMenu.setText(ToolsRes.getString("LibraryBrowser.Menu.Manage"));
            this.collectionsItem.setText(String.valueOf(ToolsRes.getString("LibraryManager.Tab.MyLibrary")) + "...");
            this.searchItem.setText(String.valueOf(ToolsRes.getString("LibraryManager.Tab.Search")) + "...");
            this.cacheItem.setText(String.valueOf(ToolsRes.getString("LibraryManager.Tab.Cache")) + "...");
            this.helpMenu.setText(ToolsRes.getString("Menu.Help"));
            this.helpItem.setText(ToolsRes.getString("LibraryBrowser.MenuItem.Help"));
            this.logItem.setText(ToolsRes.getString("MenuItem.Log"));
            this.aboutItem.setText(ToolsRes.getString("MenuItem.About"));
            this.commandLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.Target"));
            this.openButton.setText(ToolsRes.getString("LibraryTreePanel.Button.Load"));
            this.commandField.setToolTipText(ToolsRes.getString("LibraryBrowser.Field.Command.Tooltip"));
            this.searchLabel.setText(String.valueOf(ToolsRes.getString("LibraryBrowser.Label.Search")) + ":");
            this.searchField.setToolTipText(ToolsRes.getString("LibraryBrowser.Field.Search.Tooltip"));
            this.refreshRecentMenu();
            this.fileMenu.removeAll();
            this.fileMenu.add(this.newItem);
            this.fileMenu.add(this.openItem);
            this.fileMenu.add(this.recentMenu);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.closeItem);
            this.fileMenu.add(this.closeAllItem);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.saveItem);
            this.fileMenu.add(this.saveAsItem);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.exitItem);
        }
        if ((treePanel = this.getSelectedTreePanel()) != null) {
            this.editButton.setText(!treePanel.isEditing() ? ToolsRes.getString("LibraryBrowser.Button.OpenEditor") : ToolsRes.getString("LibraryBrowser.Button.CloseEditor"));
            this.editButton.setEnabled(treePanel.isEditable());
            String tabname = " '" + this.getTabTitle(treePanel.pathToRoot) + "'";
            this.closeItem.setText(String.valueOf(ToolsRes.getString("LibraryBrowser.MenuItem.CloseTab")) + tabname);
            this.closeItem.setEnabled(true);
            this.closeAllItem.setEnabled(true);
            this.saveItem.setEnabled(treePanel.isChanged());
            this.saveAsItem.setEnabled(true);
            int i = this.tabbedPane.getSelectedIndex();
            String title = this.tabbedPane.getTitleAt(i);
            if (treePanel.isChanged() && !title.endsWith("*")) {
                this.tabbedPane.setTitleAt(i, String.valueOf(title) + "*");
            } else if (!treePanel.isChanged() && title.endsWith("*")) {
                this.tabbedPane.setTitleAt(i, title.substring(0, title.length() - 1));
            }
            treePanel.refreshGUI(andRebuild);
        } else {
            this.refreshButton.setToolTipText(ToolsRes.getString("LibraryBrowser.Tooltip.Refresh"));
            this.downloadButton.setToolTipText(ToolsRes.getString("LibraryBrowser.Button.Download.Tooltip"));
            this.editButton.setText(ToolsRes.getString("LibraryBrowser.Button.OpenEditor"));
            this.saveItem.setEnabled(false);
            this.closeItem.setText(ToolsRes.getString("LibraryBrowser.MenuItem.CloseTab"));
            this.closeItem.setEnabled(false);
            this.closeAllItem.setEnabled(false);
            this.editButton.setEnabled(false);
            this.refreshButton.setEnabled(false);
            this.commandField.setText(null);
            this.openButton.setEnabled(false);
            this.downloadButton.setEnabled(false);
            this.saveAsItem.setEnabled(false);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRecentMenu() {
        ArrayList<String> arrayList = this.library.recentTabs;
        synchronized (arrayList) {
            this.recentMenu.setText(ToolsRes.getString("LibraryBrowser.Menu.OpenRecent"));
            this.recentMenu.setEnabled(!this.library.recentTabs.isEmpty());
            if (this.openRecentAction == null) {
                this.openRecentAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String path = e.getActionCommand();
                        LibraryBrowser.this.library.addRecent(path, false);
                        int i = LibraryBrowser.this.getTabIndexFromPath(path);
                        if (i > -1) {
                            LibraryBrowser.this.tabbedPane.setSelectedIndex(i);
                            return;
                        }
                        if (!LibraryBrowser.this.loadTabAndListen(path, null, "OpenRecent")) {
                            LibraryBrowser.this.library.recentTabs.remove(path);
                            LibraryBrowser.this.refreshRecentMenu();
                            JOptionPane.showMessageDialog(LibraryBrowser.this, String.valueOf(ToolsRes.getString("LibraryBrowser.Dialog.FileNotFound.Message")) + ": " + path, ToolsRes.getString("LibraryBrowser.Dialog.FileNotFound.Title"), 2);
                        }
                    }
                };
            }
            this.recentMenu.removeAll();
            this.recentMenu.setEnabled(!this.library.recentTabs.isEmpty());
            for (String next : this.library.recentTabs) {
                String text = this.library.getNameMap().get(next);
                if (text == null) {
                    text = XML.getName(next);
                }
                if (text.contains("temp_")) continue;
                JMenuItem item = new JMenuItem(text);
                item.setActionCommand(next);
                item.setToolTipText(next);
                item.addActionListener(this.openRecentAction);
                this.recentMenu.add(item);
            }
        }
        FontSizer.setMenuFonts(this.recentMenu);
    }

    protected void open() {
        final AsyncFileChooser fileChooser = OSPRuntime.getChooser();
        if (fileChooser == null) {
            return;
        }
        javax.swing.filechooser.FileFilter[] fileFilterArray = fileChooser.getChoosableFileFilters();
        int n = fileFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            javax.swing.filechooser.FileFilter filter = fileFilterArray[n2];
            fileChooser.removeChoosableFileFilter(filter);
            ++n2;
        }
        fileChooser.addChoosableFileFilter(filesAndFoldersFilter);
        fileChooser.addChoosableFileFilter(Launcher.getXMLFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setFileFilter(filesAndFoldersFilter);
        String oldTitle = fileChooser.getDialogTitle();
        fileChooser.showOpenDialog(this, new Runnable(){

            @Override
            public void run() {
                File file = fileChooser.getSelectedFile();
                if (file != null) {
                    LibraryBrowser.this.open(file.getAbsolutePath());
                }
            }
        }, null);
        fileChooser.setDialogTitle(oldTitle);
        fileChooser.removeChoosableFileFilter(filesAndFoldersFilter);
        fileChooser.removeChoosableFileFilter(Launcher.getXMLFilter());
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setFileSelectionMode(0);
    }

    public void open(String path) {
        this.loadTab(path, null);
    }

    public boolean closeTab(int index) {
        if (index < 0 || index >= this.tabbedPane.getTabCount()) {
            return true;
        }
        LibraryTreePanel treePanel = this.getTreePanel(index);
        if (!treePanel.saveChanges(this.getTabTitle(index))) {
            return false;
        }
        if (treePanel.rootResource == this.getRecentCollection()) {
            treePanel.save();
        }
        this.tabbedPane.removeTabAt(index);
        if (treePanel.metadataLoader != null) {
            treePanel.metadataLoader.cancel();
        }
        return true;
    }

    public int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    protected String save() {
        LibraryTreePanel treePanel = this.getSelectedTreePanel();
        if (treePanel == null) {
            return null;
        }
        String path = null;
        if ("temp".equals(treePanel.getName())) {
            treePanel.setName("");
            String tempPath = treePanel.pathToRoot;
            path = this.saveAs();
            if (path != null && tempPath != null) {
                File tempFile = new File(tempPath);
                tempFile.delete();
                this.library.addRecent(path, false);
                this.refreshRecentMenu();
            }
        } else {
            path = treePanel.save();
        }
        this.refreshGUI();
        return path;
    }

    protected String saveAs() {
        String title = ToolsRes.getString("LibraryBrowser.FileChooser.Title.SaveAs");
        String path = this.getChooserSavePath(title);
        if (path != null) {
            path = XML.forwardSlash(path);
            LibraryTreePanel treePanel = this.getSelectedTreePanel();
            if (treePanel == null) {
                return null;
            }
            treePanel.setRootResource(treePanel.rootResource, path, true, true);
            path = this.save();
            treePanel.setEditing(true);
            this.refreshTabTitle(path, treePanel.rootResource);
            this.refreshGUI();
            this.commandField.setForeground(LibraryTreePanel.defaultForeground);
        }
        return path;
    }

    protected String getChooserSavePath(String chooserTitle) {
        int response;
        File file = GUIUtils.showSaveDialog(this, chooserTitle);
        if (file == null) {
            return null;
        }
        String path = file.getAbsolutePath();
        String extension = XML.getExtension(path);
        if (extension == null && (file = new File(path = String.valueOf(XML.stripExtension(path)) + ".xml")).exists() && (response = JOptionPane.showConfirmDialog(this, String.valueOf(ToolsRes.getString("Tool.Dialog.ReplaceFile.Message")) + " " + file.getName() + "?", ToolsRes.getString("Tool.Dialog.ReplaceFile.Title"), 1)) != 0) {
            return null;
        }
        return path;
    }

    protected static void addSearchResource(LibraryResource resource) {
        String s;
        if (searchResourceMap == null) {
            searchResourceMap = new HashMap<String, LibraryResource>();
        }
        if ((s = resource.collectionPath) != null && s.length() > 0) {
            searchResourceMap.put(s, resource);
        }
    }

    protected TreeMap<String, String> getSearchPathMap() {
        this.loadSearchPathMap();
        return this.searchPathMap;
    }

    protected void loadSearchPathMap() {
        ArrayList<File> temp;
        if (isSearchMapLoaded) {
            return;
        }
        isSearchMapLoaded = true;
        ArrayList<File> arrayList = temp = OSPRuntime.isJS ? null : new ArrayList<File>();
        if (this.searchPathMap == null) {
            this.searchPathMap = new TreeMap();
        }
        this.searchPathMap.clear();
        TreeSet<String> paths = this.library.getAllPaths();
        for (String path : paths) {
            if (path.contains("EJS") || !ResourceLoader.isHTTP(path)) continue;
            String name = this.library.getNameMap().get(path);
            if (LibraryComPADRE.isComPADREPath(path)) {
                name = "ComPADRE " + name;
            }
            this.searchPathMap.put(name, path);
            if (temp == null) continue;
            temp.add(ResourceLoader.getSearchCacheFile(path));
        }
        if (temp != null) {
            List<File> files = ResourceLoader.getSearchFileList();
            int i = 0;
            while (i < files.size()) {
                XMLControlElement control;
                String name;
                File next = files.get(i);
                if (!temp.contains(next) && (name = (control = new XMLControlElement(next.getPath())).getString("name")) != null) {
                    String realPath = control.getString("real_path");
                    this.searchPathMap.put(name, realPath == null ? next.getPath() : realPath);
                }
                ++i;
            }
        }
        this.searchTargetPaths = new ArrayList();
        this.searchTargetNames = new ArrayList();
        for (String name : this.searchPathMap.keySet()) {
            String path = this.searchPathMap.get(name);
            this.searchTargetNames.add(name);
            this.searchTargetPaths.add(path);
            if (!OSPRuntime.isJS || this.getTabIndexFromPath(path) <= -1 && !name.startsWith("ComPADRE")) continue;
            this.library.noSearchSet.remove(path);
        }
    }

    private void chooseSearchTargets() {
        boolean firstTime;
        this.loadSearchPathMap();
        boolean bl = firstTime = this.searchTargetChooser == null;
        if (firstTime) {
            this.searchTargetChooser = new ListChooser(ToolsRes.getString("LibraryManager.Title.Search"), String.valueOf(ToolsRes.getString("LibraryBrowser.Dialog.SearchTargets.Text")) + ":", null, e -> {
                this.library.noSearchSet.clear();
                int i = 0;
                while (i < this.searchTargetNames.size()) {
                    String path = this.searchPathMap.get(this.searchTargetNames.get(i));
                    if (!this.searchTargetPaths.contains(path)) {
                        this.library.noSearchSet.add(path);
                    }
                    ++i;
                }
            });
            this.searchTargetChooser.includeCancelButton(false);
            this.searchTargetChooser.setIconImage(((ImageIcon)searchTargetIcon.getBaseIcon()).getImage());
        }
        this.searchTargetPaths.clear();
        boolean[] selected = new boolean[this.searchPathMap.size()];
        int i = 0;
        for (String name : this.searchPathMap.keySet()) {
            String path = this.searchPathMap.get(name);
            this.searchTargetPaths.add(path);
            selected[i] = !this.library.noSearchSet.contains(path);
            ++i;
        }
        this.searchTargetChooser.choose(this.searchTargetPaths, this.searchTargetNames, null, null, selected, null);
    }

    private void loadSearchResourceMap() {
        this.loadSearchPathMap();
        if (!OSPRuntime.isJS) {
            List<File> cacheFiles = ResourceLoader.getSearchFileList();
            for (String nextPath : this.searchPathMap.values()) {
                XMLControlElement control;
                File cacheFile = ResourceLoader.getSearchCacheFile(nextPath);
                if (!cacheFiles.contains(cacheFile) || this.library.noSearchSet.contains(nextPath) || searchResourceMap != null && searchResourceMap.keySet().contains(nextPath) || (control = new XMLControlElement(cacheFile)).failedToRead() || !LibraryResource.class.isAssignableFrom(control.getObjectClass())) continue;
                LibraryResource resource = (LibraryResource)control.loadObject(null);
                resource.collectionPath = control.getString("real_path");
                LibraryBrowser.addSearchResource(resource);
            }
        }
        TreeSet<String> paths = this.library.getAllPaths();
        for (String path : paths) {
            File f;
            String searchPath;
            XMLControlElement control;
            if (this.library.noSearchSet.contains(path) || !ResourceLoader.isHTTP(path) || searchResourceMap != null && searchResourceMap.keySet().contains(path) || (control = new XMLControlElement(searchPath = WEB_SEARCH_BASE_PATH + (f = ResourceLoader.getSearchCacheFile(path)).getName())).failedToRead() || !LibraryResource.class.isAssignableFrom(control.getObjectClass())) continue;
            LibraryCollection collection = (LibraryCollection)control.loadObject(null);
            collection.collectionPath = path;
            LibraryBrowser.addSearchResource(collection);
        }
    }

    protected Set<LibraryResource> getSearchTargets() {
        this.loadSearchResourceMap();
        TreeSet<LibraryResource> searchTargets = new TreeSet<LibraryResource>();
        if (searchResourceMap != null) {
            for (LibraryResource r : searchResourceMap.values()) {
                LibraryResource rc = r.getClone();
                String path = rc.collectionPath;
                if (path == null || this.library.noSearchSet.contains(path)) continue;
                searchTargets.add(rc);
            }
        } else {
            List<File> xmlFiles = ResourceLoader.getSearchFileList();
            for (File file : xmlFiles) {
                XMLControlElement control = new XMLControlElement(file);
                if (control.failedToRead() || !LibraryResource.class.isAssignableFrom(control.getObjectClass())) continue;
                LibraryResource resource = (LibraryResource)control.loadObject(null);
                resource.collectionPath = control.getString("real_path");
                String path = resource.collectionPath;
                if (path == null || this.library.noSearchSet.contains(path)) continue;
                searchTargets.add(resource);
            }
        }
        return searchTargets;
    }

    protected LibraryTreeNode searchFor(String searchPhrase, Set<LibraryResource> searchTargets) {
        LibraryTreeNode newNode;
        LibraryResource clone;
        if (searchPhrase == null || searchPhrase.trim().equals("")) {
            return null;
        }
        TreeMap<LibraryResource, List<String[]>> found = new TreeMap<LibraryResource, List<String[]>>();
        for (LibraryResource target : searchTargets) {
            if (target == null) continue;
            if (target instanceof LibraryCollection) {
                Map<LibraryResource, List<String[]>> map = this.searchCollectionFor(searchPhrase, (LibraryCollection)target);
                for (LibraryResource next : map.keySet()) {
                    next.collectionPath = target.collectionPath;
                    found.put(next, map.get(next));
                }
                continue;
            }
            List<String[]> results = this.searchResourceFor(searchPhrase, target);
            if (results == null) continue;
            found.put(target, results);
        }
        if (found.isEmpty()) {
            return null;
        }
        LibraryTreePanel treePanel = this.getSearchResultsTreePanel();
        LibraryTreeNode root = treePanel.rootNode;
        LibraryCollection rootCollection = (LibraryCollection)treePanel.getCollection();
        String name = "'" + searchPhrase + "'";
        int j = 0;
        while (j < root.getChildCount()) {
            LibraryTreeNode childNode = (LibraryTreeNode)root.getChildAt(j);
            if (childNode.getName().equals(name)) {
                treePanel.removeNode(childNode);
            }
            ++j;
        }
        LibraryCollection results = new LibraryCollection(name);
        rootCollection.addResource(results);
        LibraryTreeNode resultsNode = new LibraryTreeNode(results, treePanel);
        treePanel.insertChildAt(resultsNode, root, root.getChildCount());
        for (LibraryResource next : found.keySet()) {
            if (!next.collectionPath.contains("compadre.org")) continue;
            clone = next.getClone();
            results.addResource(clone);
            newNode = new LibraryTreeNode(clone, treePanel);
            newNode.setBasePath(next.getInheritedBasePath());
            treePanel.insertChildAt(newNode, resultsNode, resultsNode.getChildCount());
        }
        for (LibraryResource next : found.keySet()) {
            if (next.collectionPath.contains("compadre.org")) continue;
            clone = next.getClone();
            results.addResource(clone);
            newNode = new LibraryTreeNode(clone, treePanel);
            newNode.setBasePath(next.getInheritedBasePath());
            treePanel.insertChildAt(newNode, resultsNode, resultsNode.getChildCount());
        }
        treePanel.scrollToPath(((LibraryTreeNode)resultsNode.getLastChild()).getTreePath(), false);
        treePanel.isChanged = false;
        FontSizer.setFonts(treePanel);
        treePanel.setSelectedNode(resultsNode);
        return resultsNode;
    }

    private LibraryTreePanel getSearchResultsTreePanel() {
        if (this.searchResultsTreePanel == null) {
            this.searchResultsTreePanel = this.createLibraryTreePanel();
            LibraryCollection collection = new LibraryCollection("");
            this.searchResultsTreePanel.setRootResource(collection, "", false, false);
        }
        this.searchResultsTreePanel.getCollection().setName(ToolsRes.getString("LibraryBrowser.SearchResults"));
        return this.searchResultsTreePanel;
    }

    protected Map<LibraryResource, List<String[]>> searchCollectionFor(String searchPhrase, LibraryCollection collection) {
        String[] toAND = searchPhrase.split(AND);
        String[] toOR = searchPhrase.split(OR);
        if (toAND.length > 1 && toOR.length == 1) {
            Map<LibraryResource, List<String[]>> results = this.searchCollectionFor(toAND[0], collection);
            OSPLog.finer("AND '" + toAND[0] + "' (found: " + results.size() + CLOSING);
            int i = 1;
            while (i < toAND.length) {
                Map<LibraryResource, List<String[]>> next = this.searchCollectionFor(toAND[i], collection);
                OSPLog.finer("AND '" + toAND[i] + "' (found: " + results.size() + CLOSING);
                results = this.applyAND(results, next);
                ++i;
            }
            OSPLog.finer("AND found: " + results.size());
            return results;
        }
        if (toOR.length > 1 && toAND.length == 1) {
            Map<LibraryResource, List<String[]>> results = this.searchCollectionFor(toOR[0], collection);
            OSPLog.finer("OR '" + toOR[0] + "' (found: " + results.size() + CLOSING);
            int i = 1;
            while (i < toOR.length) {
                Map<LibraryResource, List<String[]>> next = this.searchCollectionFor(toOR[i], collection);
                OSPLog.finer("OR '" + toOR[i] + "' (found: " + results.size() + CLOSING);
                results = this.applyOR(results, next);
                ++i;
            }
            OSPLog.finer("OR found: " + results.size());
            return results;
        }
        if (toOR.length > 1 && toAND.length > 1) {
            String[] split = this.getNextSplit(searchPhrase);
            Map<LibraryResource, List<String[]>> results = this.searchCollectionFor(split[0], collection);
            while (split.length > 2) {
                String operator = split[1];
                String remainder = split[2];
                split = this.getNextSplit(remainder);
                Map<LibraryResource, List<String[]>> next = this.searchCollectionFor(split[0], collection);
                if (operator.equals(AND)) {
                    results = this.applyAND(results, next);
                    continue;
                }
                if (!operator.equals(OR)) continue;
                results = this.applyOR(results, next);
            }
            return results;
        }
        TreeMap<LibraryResource, List<String[]>> found = new TreeMap<LibraryResource, List<String[]>>();
        List<String[]> results = this.searchResourceFor(searchPhrase, collection);
        if (results != null) {
            found.put(collection, results);
        }
        LibraryResource[] libraryResourceArray = collection.getResources();
        int n = libraryResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            LibraryResource record = libraryResourceArray[n2];
            if (record != null) {
                if (record instanceof LibraryCollection) {
                    Map<LibraryResource, List<String[]>> map = this.searchCollectionFor(searchPhrase, (LibraryCollection)record);
                    for (LibraryResource next : map.keySet()) {
                        found.put(next, map.get(next));
                    }
                } else {
                    results = this.searchResourceFor(searchPhrase, record);
                    if (results != null) {
                        found.put(record, results);
                    }
                }
            }
            ++n2;
        }
        return found;
    }

    protected List<String[]> searchResourceFor(String searchPhrase, LibraryResource record) {
        TreeSet<LibraryResource.Metadata> metadata;
        String type;
        String toMatch = searchPhrase.toLowerCase();
        ArrayList<String[]> foundData = new ArrayList<String[]>();
        String name = record.getName();
        if (name.toLowerCase().contains(toMatch)) {
            foundData.add(new String[]{"name", name});
        }
        if ((type = record.getType()).toLowerCase().contains(toMatch)) {
            foundData.add(new String[]{"type", type});
        }
        if ((metadata = record.getMetadata()) != null) {
            for (LibraryResource.Metadata next : metadata) {
                String key = next.getData()[0];
                String value = next.getData()[1];
                if (value.toLowerCase().indexOf(toMatch) <= -1) continue;
                foundData.add(new String[]{key, value});
            }
        }
        return foundData.isEmpty() ? null : foundData;
    }

    protected String[] getNextSplit(String phrase) {
        int which;
        String[] and = phrase.split(AND, 2);
        String[] or = phrase.split(OR, 2);
        String[] open = phrase.split(Pattern.quote(OPENING), 2);
        int n = and[0].length() <= or[0].length() ? (and[0].length() <= open[0].length() ? 0 : 2) : (which = or[0].length() <= open[0].length() ? 1 : 2);
        if (which == 2 && open.length > 1) {
            String[] split = this.getParenthesisSplit(open[1]);
            if (split.length == 1) {
                return new String[]{split[0]};
            }
            int n2 = split[1].indexOf(AND);
            int m = split[1].indexOf(OR);
            if (n2 == -1 && m == -1) {
                return new String[]{open[1]};
            }
            if (n2 > -1 && (m == -1 || n2 < m)) {
                return new String[]{split[0], AND, split[1].substring(n2 + AND.length())};
            }
            if (m > -1 && (n2 == -1 || m < n2)) {
                return new String[]{split[0], OR, split[1].substring(m + OR.length())};
            }
        }
        switch (which) {
            case 0: {
                if (and.length == 1) {
                    return new String[]{and[0]};
                }
                return new String[]{and[0], AND, and[1]};
            }
            case 1: {
                if (or.length == 1) {
                    return new String[]{or[0]};
                }
                return new String[]{or[0], OR, or[1]};
            }
        }
        return new String[]{phrase};
    }

    protected String[] getParenthesisSplit(String phrase) {
        String[] stringArray;
        int index = 1;
        int n = 1;
        int opening = phrase.indexOf(OPENING, index);
        int closing = phrase.indexOf(CLOSING, index);
        while (n > 0) {
            if (opening > -1 && opening < closing) {
                ++n;
                index = opening + 1;
                opening = phrase.indexOf(OPENING, index);
                continue;
            }
            if (closing > -1) {
                --n;
                index = closing + 1;
                closing = phrase.indexOf(CLOSING, index);
                continue;
            }
            return new String[]{phrase};
        }
        String token = phrase.substring(0, index - 1);
        String remainder = phrase.substring(index);
        if (remainder.trim().equals("")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = token;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = token;
            stringArray = stringArray3;
            stringArray3[1] = remainder;
        }
        return stringArray;
    }

    protected Map<LibraryResource, List<String[]>> applyAND(Map<LibraryResource, List<String[]>> results1, Map<LibraryResource, List<String[]>> results2) {
        TreeMap<LibraryResource, List<String[]>> resultsAND = new TreeMap<LibraryResource, List<String[]>>();
        Set<LibraryResource> keys1 = results1.keySet();
        for (LibraryResource node : results2.keySet()) {
            if (!keys1.contains(node)) continue;
            ArrayList matchedTerms = new ArrayList();
            matchedTerms.addAll(results1.get(node));
            matchedTerms.addAll(results2.get(node));
            resultsAND.put(node, matchedTerms);
        }
        return resultsAND;
    }

    protected Map<LibraryResource, List<String[]>> applyOR(Map<LibraryResource, List<String[]>> results1, Map<LibraryResource, List<String[]>> results2) {
        ArrayList matchedTerms;
        TreeMap<LibraryResource, List<String[]>> resultsOR = new TreeMap<LibraryResource, List<String[]>>();
        for (LibraryResource node : results1.keySet()) {
            matchedTerms = new ArrayList();
            matchedTerms.addAll(results1.get(node));
            resultsOR.put(node, matchedTerms);
        }
        for (LibraryResource node : results2.keySet()) {
            if (resultsOR.keySet().contains(node)) {
                ((List)resultsOR.get(node)).addAll((Collection)results2.get(node));
                continue;
            }
            matchedTerms = new ArrayList();
            matchedTerms.addAll(results2.get(node));
            resultsOR.put(node, matchedTerms);
        }
        return resultsOR;
    }

    protected void addToCollections(String path) {
        LibraryResource collection;
        if (this.library.containsPath(path, true)) {
            return;
        }
        String proposed = this.getTabTitle(path);
        if (proposed == null && (collection = this.loadResource(path)) != null) {
            proposed = collection.getName();
        }
        if (proposed == null) {
            return;
        }
        if (proposed.equals("")) {
            proposed = XML.getName(path);
        }
        this.library.addCollection(path, proposed);
        this.refreshCollectionsMenu();
        this.refreshGUI();
    }

    protected String createNewCollection() {
        String osppath = LibraryBrowser.getOSPPath();
        String path = null;
        if (osppath != null) {
            String name = "temp_";
            path = String.valueOf(osppath) + name + "0.xml";
            File file = new File(path);
            if (file.exists()) {
                int i = 1;
                while (i < 100) {
                    path = String.valueOf(osppath) + name + i + ".xml";
                    file = new File(path);
                    if (!file.exists()) break;
                    ++i;
                }
            }
            LibraryCollection collection = new LibraryCollection(null);
            XMLControlElement control = new XMLControlElement(collection);
            control.write(path);
            path = XML.forwardSlash(path);
            this.loadTabAndListen(path, null, "CreateNew");
        }
        return path;
    }

    protected String getUniqueName(String proposed, String nameToIgnore) {
        if (this.isDuplicateName(proposed = proposed.trim(), nameToIgnore)) {
            int i = 2;
            String s = String.valueOf(proposed) + " (" + i + CLOSING;
            while (this.isDuplicateName(s, nameToIgnore)) {
                s = String.valueOf(proposed) + " (" + ++i + CLOSING;
            }
            return s;
        }
        return proposed;
    }

    protected boolean isDuplicateName(String name, String nameToIgnore) {
        for (String next : this.library.getNames()) {
            if (next.equals(nameToIgnore) || !name.equals(next)) continue;
            return true;
        }
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            String title = this.tabbedPane.getTitleAt(i);
            if (title.endsWith("*")) {
                title = title.substring(0, title.length() - 1);
            }
            if (!title.equals(nameToIgnore) && name.equals(title)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected LibraryTreePanel createLibraryTreePanel() {
        LibraryTreePanel treePanel = new LibraryTreePanel(this);
        treePanel.addPropertyChangeListener(this.treePanelListener);
        return treePanel;
    }

    protected void showAboutDialog() {
        String date = OSPRuntime.getLaunchJarBuildDate();
        if ("".equals(date)) {
            date = "27 Oct 2025";
        }
        String aboutString = String.valueOf(ToolsRes.getString("LibraryBrowser.Version")) + " " + "6.3.3" + "\nRelease date " + date + "\n" + "Open Source Physics\n" + "www.opensourcephysics.org";
        JOptionPane.showMessageDialog(this, aboutString, String.valueOf(ToolsRes.getString("Dialog.About.Title")) + " " + ToolsRes.getString("LibraryBrowser.Title"), 1);
    }

    protected void showHelp() {
        if (fireHelpEvent) {
            this.firePropertyChange("help", null, null);
            return;
        }
        String helpPath = LIBRARY_HELP_ONLINE;
        if (ResourceLoader.getResource(helpPath) != null) {
            OSPDesktop.displayURL(helpPath);
        } else {
            String classBase = "/org/opensourcephysics/resources/tools/html/";
            helpPath = XML.getResolvedPath(LIBRARY_HELP_NAME, classBase);
            if (this.helpFrame == null || !helpPath.equals(this.helpFrame.getTitle())) {
                this.helpFrame = new TextFrame(helpPath);
                this.helpFrame.enableHyperlinks();
                this.helpFrame.setSize(1000, 700);
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                int x = (dim.width - this.helpFrame.getBounds().width) / 2;
                int y = (dim.height - this.helpFrame.getBounds().height) / 2;
                this.helpFrame.setLocation(x, y);
            }
            this.helpFrame.setVisible(true);
        }
    }

    protected String getAboutLibraryBrowserText() {
        String path = "/org/opensourcephysics/resources/tools/images/compadre_banner.jpg";
        Resource res = ResourceLoader.getResource(path);
        String imageCode = "";
        if (res != null) {
            imageCode = "<p align=\"center\"><img src=\"" + res.getURL() + "\"></p>";
        }
        String code = String.valueOf(imageCode) + "<div style=\"font-family:'Verdana'\"><h1 align=\"center\">Open Source Physics Library Browser</h1>" + "<p>Use the OSP Library Browser to browse online collections of Tracker projects, EJS simulations and other learning resources.</p><ul> <li>Open a collection by choosing from the Collections menu or entering a URL directly in the toolbar as with a web browser.</li>" + "<li>Collections are organized and displayed in a tree. Each tree node is a resource or sub-collection. Click a node to learn about the resource or double-click to download and/or open it in Tracker, EJS, DataTool or your web browser.</li>" + "<li>To build your own collection choose File|New Collection. Add your own resources or copy and paste from other collections. Collections are saved as xml documents that contain references to the actual resource files. For more information, choose Help.</li>" + "</ul><p><strong>ComPADRE</strong> is a network of online resource collections and community web sites supporting physics education with content, tools, and expert advice. Open a ComPADRE collection by choosing from the Collections|ComPADRE Library menu." + "  You can help build the ComPADRE collection by reviewing resources, participating in discussions, and adding your own OSP resources. For more information, see <a href=\"https://www.compadre.org/osp/\">http://www.compadre.org/osp/</a>. " + "To recommend a resource for ComPADRE, visit <em>Suggest a Resource</em> at <a href=\"https://www.compadre.org/osp/items/suggest.cfm\">http://www.compadre.org/osp/items/suggest.cfm</a>. Contact Wolfgang Christian, the OSP Collection editor, for more information.</p>" + "</div>";
        return code;
    }

    public static void main(String[] args) {
        LibraryBrowser browser = LibraryBrowser.getBrowser();
        browser.addOSPLibrary(TRACKER_LIBRARY);
        browser.addOSPLibrary(SHARED_LIBRARY);
        browser.addComPADRECollection("https://www.compadre.org/osp/services/REST/osp_jars.cfm?verb=Identify&OSPType=EJS%20Model&AttachedDocument=Source%20Code&OSPPrimary=Subject");
        browser.addComPADRECollection("https://www.compadre.org/osp/services/REST/osp_tracker.cfm?verb=Identify&OSPType=Tracker&OSPPrimary=Subject");
        if (args != null && args.length > 0 && args[0] != null) {
            browser.open(args[0]);
        }
        browser.exitOnClose = true;
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - browser.getBounds().width) / 2;
        int y = (dim.height - browser.getBounds().height) / 2;
        browser.setLocation(x, y);
        browser.setVisible(true);
    }

    public void warnNotLoaded(String path) {
        String s = String.valueOf(ToolsRes.getString("LibraryBrowser.Dialog.CollectionNotFound.Message")) + ":\n" + path;
        System.out.println("WARN - LibraryBrowser " + s);
    }

    protected boolean isWebConnected(boolean[] isDialogShown) {
        if (!checkedWebConnection) {
            checkedWebConnection = true;
            this.webConnected = ResourceLoader.isWebConnected();
            if (!this.webConnected) {
                if (isDialogShown != null) {
                    isDialogShown[0] = true;
                }
                if (ResourceLoader.showWebConnectionDialog() == 1) {
                    checkedWebConnection = false;
                    ResourceLoader.clearWebTest();
                    return this.isWebConnected(isDialogShown);
                }
            }
        }
        return this.webConnected;
    }

    protected static String getRedirectFromHTMLCode(String code) {
        if (code == null) {
            return null;
        }
        String[] parts = code.split("<!--");
        if (parts.length > 1) {
            int i = 1;
            while (i < parts.length) {
                if (parts[i].trim().startsWith("redirect:")) {
                    String[] subparts = parts[i].split("-->");
                    return subparts.length > 1 ? subparts[0].substring(9).trim() : null;
                }
                ++i;
            }
        }
        return null;
    }

    public static ArrayList<String[]> getMetadataFromHTML(String htmlCode) {
        ArrayList<String[]> results = new ArrayList<String[]>();
        if (htmlCode == null) {
            return results;
        }
        String[] parts = htmlCode.split("<meta name=\"");
        int i = 1;
        while (i < parts.length) {
            int n = parts[i].indexOf("\">");
            if (n > -1) {
                parts[i] = parts[i].substring(0, n);
                String divider = "\" content=\"";
                String[] subparts = parts[i].split(divider);
                if (subparts.length > 1) {
                    String name = subparts[0];
                    String value = subparts[1];
                    results.add(new String[]{name, value});
                }
            }
            ++i;
        }
        return results;
    }

    public void addMetadataLoaderListener(PropertyChangeListener listener) {
        this.metadataLoaderListener = listener;
    }

    protected static String getOSPPath() {
        if (OSPRuntime.isJS) {
            return null;
        }
        if (ospPath == null) {
            String userHome = OSPRuntime.getUserHome().replace('\\', '/');
            String ospFolder = OSPRuntime.isWindows() ? WINDOWS_OSP_DIRECTORY : OSP_DIRECTORY;
            ospPath = String.valueOf(userHome) + ospFolder;
            if (!new File(ospPath).exists()) {
                ArrayList<String> dirs = OSPRuntime.getDefaultSearchPaths();
                ospPath = XML.forwardSlash(dirs.get(0));
            }
            if (!ospPath.endsWith("/")) {
                ospPath = String.valueOf(ospPath) + "/";
            }
        }
        return ospPath;
    }

    public static void clearCache() {
        ResourceLoader.clearOSPCache(null, false);
        LibraryTreePanel.clearMaps();
    }

    static class DirectoryFilter
    implements FileFilter {
        DirectoryFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.getName().startsWith("_")) {
                return false;
            }
            return file.isDirectory();
        }
    }

    public class FileDropHandler
    extends TransferHandler {
        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            List<File> fileList = this.getFileList(support.getTransferable());
            try {
                if (fileList != null) {
                    File f = fileList.get(0);
                    if (f.getName().toLowerCase().endsWith(".xml")) {
                        LibraryBrowser.this.open(f.getAbsolutePath());
                    }
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        private List<File> getFileList(Transferable t) {
            try {
                return (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    static class FilesAndFoldersFilter
    extends javax.swing.filechooser.FileFilter {
        FilesAndFoldersFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f != null;
        }

        @Override
        public String getDescription() {
            return ToolsRes.getString("LibraryBrowser.FilesAndFoldersFilter.Description");
        }
    }

    static class HTMLFilter
    implements FileFilter {
        HTMLFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file == null || file.isDirectory()) {
                return false;
            }
            String name = file.getName();
            if (name.startsWith("_")) {
                return false;
            }
            String ext = XML.getExtension(name);
            if (ext == null) {
                return false;
            }
            return ext.toLowerCase().startsWith("htm");
        }
    }

    class LibraryLoader
    extends SwingWorker<Library, Object> {
        LibraryLoader() {
        }

        @Override
        public Library doInBackground() {
            if (LibraryBrowser.this.libraryPath == null) {
                return LibraryBrowser.this.library;
            }
            Runnable webChecker = new Runnable(){

                @Override
                public void run() {
                    boolean[] isDialogShown = new boolean[1];
                    if (!LibraryBrowser.this.isWebConnected(isDialogShown) && !isDialogShown[0] && ResourceLoader.showWebConnectionDialog() == 1) {
                        checkedWebConnection = false;
                        ResourceLoader.clearWebTest();
                        this.run();
                    }
                }
            };
            if (!ResourceLoader.isHTTP(LibraryBrowser.this.libraryPath)) {
                LibraryBrowser.this.library.load(LibraryBrowser.this.libraryPath);
                LibraryBrowser.this.localLibraryLoaded = true;
                if (LibraryBrowser.this.library.openTabPaths != null && LibraryBrowser.this.metadataLoaderListener == null) {
                    String path;
                    String[] paths;
                    ArrayList<String> unopenedTabs = new ArrayList<String>();
                    ArrayList<String> openedTabs = new ArrayList<String>();
                    String[] stringArray = paths = LibraryBrowser.this.library.openTabPaths;
                    int n = paths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        path = stringArray[n2];
                        int k = LibraryBrowser.this.getTabIndexFromPath(path);
                        if (k <= -1 && !openedTabs.contains(path)) {
                            File cachedFile = ResourceLoader.getSearchCacheFile(path);
                            if (cachedFile.exists()) {
                                LibraryBrowser.this.addTabAndExecute(path, null, null);
                                openedTabs.add(path);
                            } else {
                                unopenedTabs.add(path);
                            }
                        }
                        ++n2;
                    }
                    if (!unopenedTabs.isEmpty()) {
                        paths = unopenedTabs.toArray(new String[unopenedTabs.size()]);
                        unopenedTabs.clear();
                        stringArray = paths;
                        n = paths.length;
                        n2 = 0;
                        while (n2 < n) {
                            path = stringArray[n2];
                            Resource res = ResourceLoader.getResource(path);
                            if (res != null && !ResourceLoader.isHTTP(path)) {
                                LibraryBrowser.this.addTabAndExecute(path, null, null);
                            } else {
                                unopenedTabs.add(path);
                            }
                            ++n2;
                        }
                    }
                    boolean done = unopenedTabs.isEmpty();
                    LibraryBrowser.this.library.openTabPaths = done ? null : unopenedTabs.toArray(new String[unopenedTabs.size()]);
                }
                webChecker.run();
            } else {
                webChecker.run();
                if (LibraryBrowser.this.isWebConnected(null)) {
                    LibraryBrowser.this.library.load(LibraryBrowser.this.libraryPath);
                }
            }
            return LibraryBrowser.this.library;
        }

        @Override
        protected void done() {
            try {
                Library library = (Library)this.get();
                if (library.openTabPaths != null && LibraryBrowser.this.metadataLoaderListener == null) {
                    String[] stringArray = library.openTabPaths;
                    int n = library.openTabPaths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        boolean available;
                        String path = stringArray[n2];
                        boolean bl = available = LibraryBrowser.this.isWebConnected(null) && ResourceLoader.isHTTP(path);
                        if (available) {
                            LibraryBrowser.this.addTabAndExecute(path, null, null);
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            LibraryBrowser.this.refreshCollectionsMenu();
            LibraryBrowser.this.refreshRecentMenu();
        }
    }

    class Searcher
    extends SwingWorker<LibraryTreeNode, Object> {
        private String searchTerm;

        public Searcher(String searchTerm) {
            this.searchTerm = searchTerm;
        }

        @Override
        public LibraryTreeNode doInBackground() {
            Set<LibraryResource> searchTargets = LibraryBrowser.this.getSearchTargets();
            return LibraryBrowser.this.searchFor(this.searchTerm.trim(), searchTargets);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                LibraryTreeNode resultsTreeNode = (LibraryTreeNode)this.get();
                if (resultsTreeNode == null) {
                    Toolkit.getDefaultToolkit().beep();
                    OSPLog.finer(String.valueOf(this.searchTerm) + "not found");
                    Color color = LibraryBrowser.this.searchField.getForeground();
                    LibraryBrowser.this.searchField.setText(ToolsRes.getString("LibraryBrowser.Search.NotFound"));
                    LibraryBrowser.this.searchField.setForeground(Color.RED);
                    LibraryBrowser.this.searchField.setBackground(Color.white);
                    if (searchTimer == null) {
                        searchTimer = OSPRuntime.trigger(1000, e -> {
                            LibraryBrowser.this.searchField.setText(this.searchTerm);
                            LibraryBrowser.this.searchField.setForeground(color);
                            LibraryBrowser.this.searchField.selectAll();
                            LibraryBrowser.this.searchField.setBackground(Color.white);
                        });
                    } else {
                        searchTimer.restart();
                    }
                    return;
                }
                LibraryTreePanel treePanel = LibraryBrowser.this.getSearchResultsTreePanel();
                String title = treePanel.getCollection().getName();
                int i = LibraryBrowser.this.getTabIndexFromTitle(title);
                JTabbedPane jTabbedPane = LibraryBrowser.this.tabbedPane;
                synchronized (jTabbedPane) {
                    if (i == -1) {
                        LibraryBrowser.this.tabbedPane.addTab(title, treePanel);
                    }
                    LibraryBrowser.this.tabbedPane.setSelectedComponent(treePanel);
                }
                LibraryTreePanel.htmlPanesByNode.remove(resultsTreeNode);
                treePanel.showInfo(resultsTreeNode, "LibraryBrowser.Searcher.done");
                LibraryBrowser.this.refreshGUI();
            }
            catch (Exception e2) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    class TabLoader
    extends SwingWorker<LibraryTreePanel, Object> {
        String path;
        int index;
        List<String> treePath;

        TabLoader(String pathToAdd, int tabIndex, List<String> treePath) {
            this.path = pathToAdd;
            this.index = tabIndex;
            this.treePath = treePath;
        }

        @Override
        public LibraryTreePanel doInBackground() {
            boolean isLocal;
            LibraryBrowser.this.setCursor(Cursor.getPredefinedCursor(3));
            String realPath = this.path;
            File cachedFile = ResourceLoader.getSearchCacheFile(this.path);
            if (cachedFile.exists() && ResourceLoader.isHTTP(this.path) && LibraryBrowser.this.metadataLoaderListener == null) {
                realPath = cachedFile.getAbsolutePath();
            }
            boolean doCache = OSPRuntime.doCacheZipContents;
            OSPRuntime.doCacheZipContents = true;
            LibraryResource resource = LibraryBrowser.this.loadResource(realPath);
            OSPRuntime.doCacheZipContents = doCache;
            if (!doCache) {
                ResourceLoader.clearZipCache();
            }
            boolean isTRZ = ResourceLoader.isJarZipTrz(this.path.toLowerCase(), false);
            boolean bl = isLocal = !ResourceLoader.isHTTP(realPath);
            if (resource != null) {
                LibraryTreePanel treePanel = null;
                if (isTRZ) {
                    Map<String, ZipEntry> contents = ResourceLoader.getZipContents(realPath, true);
                    if (contents != null) {
                        String baseName = XML.stripExtension(XML.getName(realPath));
                        for (String next : contents.keySet()) {
                            if (next.indexOf("_thumbnail") <= -1) continue;
                            String thumb = XML.getName(next);
                            baseName = thumb.substring(0, thumb.indexOf("_thumbnail"));
                            resource.setName(baseName);
                            break;
                        }
                        for (String next : contents.keySet()) {
                            String nextName;
                            if (!next.endsWith(".html") && !next.endsWith(".htm") || !XML.stripExtension(nextName = XML.getName(next)).equals(String.valueOf(baseName) + "_info")) continue;
                            String trzName = XML.getName(realPath);
                            resource.setHTMLPath(String.valueOf(trzName) + "!/" + next);
                            break;
                        }
                    }
                    if (isLocal) {
                        String recentCollectionPath;
                        this.path = recentCollectionPath = String.valueOf(LibraryBrowser.getOSPPath()) + LibraryBrowser.RECENT_COLLECTION_NAME;
                        LibraryCollection collection = LibraryBrowser.this.getRecentCollection();
                        LibraryResource duplicate = null;
                        LibraryResource[] resArray = collection.getResources();
                        int i = 0;
                        while (i < resArray.length) {
                            LibraryResource next = resArray[i];
                            if (next.getTarget().equals(resource.getTarget())) {
                                duplicate = next;
                                break;
                            }
                            ++i;
                        }
                        if (collection.insertResource(resource, 0)) {
                            if (duplicate != null) {
                                collection.removeResource(duplicate);
                            }
                            LibraryResource[] resources = collection.getResources();
                            int n = resources.length - maxRecentCollectionSize;
                            int i2 = 0;
                            while (i2 < n) {
                                collection.removeResource(resources[resources.length - 1 - i2]);
                                ++i2;
                            }
                            resource.collectionPath = recentCollectionPath;
                        }
                        this.treePath = resource.getTreePath(null);
                        this.index = LibraryBrowser.this.getTabIndexFromPath(recentCollectionPath);
                        resource = collection;
                    }
                }
                LibraryTreePanel libraryTreePanel = treePanel = this.index < 0 ? LibraryBrowser.this.createLibraryTreePanel() : LibraryBrowser.this.getTreePanel(this.index);
                if (isLocal && isTRZ) {
                    treePanel.setRootResource(resource, this.path, false, true);
                } else {
                    boolean editable;
                    boolean bl2 = editable = !ResourceLoader.isHTTP(this.path) && this.path.toLowerCase().endsWith(".xml");
                    if (!OSPRuntime.isJS) {
                        if (this.path.equals(String.valueOf(LibraryBrowser.getOSPPath()) + LibraryBrowser.RECENT_COLLECTION_NAME)) {
                            editable = false;
                            resource.collectionPath = this.path;
                        }
                        if (ResourceLoader.isSearchPath(this.path)) {
                            editable = false;
                        }
                    }
                    treePanel.setRootResource(resource, this.path, editable, LibraryBrowser.this.isResourcePathXML);
                }
                return treePanel;
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                LibraryTreePanel treePanel = (LibraryTreePanel)this.get();
                if (treePanel != null) {
                    treePanel.setFontLevel(FontSizer.getLevel());
                    if (this.index < 0) {
                        LibraryBrowser.this.tabbedPane.addTab("", treePanel);
                        this.index = LibraryBrowser.this.tabbedPane.getTabCount() - 1;
                    }
                    LibraryBrowser.this.refreshTabTitle(this.path, treePanel.rootResource);
                    LibraryBrowser.this.tabbedPane.setToolTipTextAt(this.index, this.path);
                    treePanel.setSelectionPath(this.treePath);
                    LibraryTreeNode node = treePanel.getSelectedNode();
                    LibraryTreePanel libraryTreePanel = treePanel;
                    libraryTreePanel.getClass();
                    new LibraryTreePanel.NodeLoader(libraryTreePanel, node).execute();
                    if (treePanel.metadataLoader != null) {
                        treePanel.metadataLoader.cancel();
                    }
                    LibraryTreePanel libraryTreePanel2 = treePanel;
                    libraryTreePanel2.getClass();
                    treePanel.metadataLoader = new LibraryTreePanel.MetadataLoader(libraryTreePanel2, this.treePath);
                    treePanel.metadataLoader.execute();
                    this.setProgress(this.index);
                } else {
                    LibraryBrowser.this.warnNotLoaded(this.path);
                    LibraryBrowser.this.library.removeRecent(this.path);
                    LibraryBrowser.this.refreshRecentMenu();
                    this.setProgress(-1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            LibraryBrowser.this.setCursor(Cursor.getDefaultCursor());
        }
    }

    class TabTitle
    extends JPanel {
        private JLabel titleLabel;
        private JLabel iconLabel;
        private Icon normalIcon;
        private Icon boldIcon;

        TabTitle(Icon lightIcon, Icon heavyIcon) {
            super(new BorderLayout());
            this.setOpaque(false);
            this.titleLabel = new JLabel();
            this.iconLabel = new JLabel();
            this.iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            this.iconLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int i = LibraryBrowser.this.getTabIndexFromTitle(TabTitle.this.titleLabel.getText());
                    if (i >= 0 && ((TabTitle)TabTitle.this).LibraryBrowser.this.tabbedPane.getSelectedIndex() != i) {
                        ((TabTitle)TabTitle.this).LibraryBrowser.this.tabbedPane.setSelectedIndex(i);
                    }
                    boolean primaryOnly = TabTitle.this.normalIcon == contractIcon;
                    int index = LibraryBrowser.this.getTabIndexFromTitle(TabTitle.this.titleLabel.getText());
                    if (index >= 0) {
                        LibraryTreePanel treePanel = LibraryBrowser.this.getTreePanel(index);
                        String path = LibraryComPADRE.getCollectionPath(treePanel.pathToRoot, primaryOnly);
                        LibraryBrowser.this.loadTabAsync(path, index, null, null);
                        TabTitle.this.setIcons(primaryOnly ? expandIcon : contractIcon, primaryOnly ? heavyExpandIcon : heavyContractIcon);
                        TabTitle.this.iconLabel.setToolTipText(primaryOnly ? ToolsRes.getString("LibraryBrowser.Tooltip.Expand") : ToolsRes.getString("LibraryBrowser.Tooltip.Contract"));
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    TabTitle.this.iconLabel.setIcon(TabTitle.this.boldIcon);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    TabTitle.this.iconLabel.setIcon(TabTitle.this.normalIcon);
                }
            });
            this.add((Component)this.titleLabel, "West");
            this.add((Component)this.iconLabel, "East");
            this.setIcons(lightIcon, heavyIcon);
        }

        void setTitle(String title) {
            this.titleLabel.setText(title);
        }

        void setIcons(Icon lightIcon, Icon heavyIcon) {
            this.normalIcon = lightIcon;
            this.boldIcon = heavyIcon;
            this.iconLabel.setIcon(this.normalIcon);
        }

        void refreshFontSize() {
            FontSizer.setFont(this.titleLabel);
        }
    }

    static class TrackerDLFilter
    implements FileFilter {
        TrackerDLFilter() {
        }

        public boolean acceptPath(String path) {
            String ext;
            String name = XML.getName(path);
            if (name.startsWith("_")) {
                return false;
            }
            if (name.indexOf("TrackerSet=") >= 0) {
                return true;
            }
            switch (ext = XML.getExtension(name).toLowerCase()) {
                case "xml": {
                    return false;
                }
                case "zip": {
                    if (ResourceLoader.isHTTP(path)) {
                        return true;
                    }
                    Map<String, ZipEntry> files = ResourceLoader.getZipContents(path, true);
                    for (String next : files.keySet()) {
                        if (!next.toLowerCase().endsWith(".trk")) continue;
                        return true;
                    }
                    return false;
                }
                case "htm": 
                case "pdf": 
                case "trk": 
                case "trz": 
                case "html": {
                    return true;
                }
            }
            String[] stringArray = VideoIO.getVideoExtensions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String next = stringArray[n2];
                if (ext.equals(next.toLowerCase())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public boolean accept(File file) {
            return file == null || file.isDirectory() ? false : this.acceptPath(file.toString());
        }
    }

    static class XMLFilter
    implements FileFilter {
        XMLFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            String ext = XML.getExtension(file.getName());
            if (ext == null) {
                return false;
            }
            return ext.toLowerCase().equals("xml");
        }
    }
}

