/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.util.ArrayList;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.tools.LibraryResource;

public class LibraryCollection
extends LibraryResource {
    private ArrayList<LibraryResource> resources = new ArrayList();

    public LibraryCollection(String name) {
        super(name);
    }

    @Override
    public String getType() {
        return "Collection";
    }

    @Override
    public boolean setType(String type) {
        return false;
    }

    @Override
    public boolean setTarget(String path) {
        String string = path = path == null ? "" : path.trim();
        if (path.equals(this.target)) {
            return false;
        }
        this.target = path;
        return true;
    }

    public void addResource(LibraryResource resource) {
        if (resource == null) {
            return;
        }
        this.resources.add(resource);
        resource.parent = this;
    }

    public boolean insertResource(LibraryResource resource, int index) {
        if (!this.resources.contains(resource)) {
            this.resources.add(index, resource);
            resource.parent = this;
            return true;
        }
        return false;
    }

    public void removeResource(LibraryResource resource) {
        this.resources.remove(resource);
    }

    public LibraryResource[] getResources() {
        return this.resources.toArray(new LibraryResource[this.resources.size()]);
    }

    public void clearResources() {
        this.resources.clear();
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            XML.getLoader(LibraryResource.class).saveObject(control, obj);
            LibraryCollection collection = (LibraryCollection)obj;
            if (!collection.resources.isEmpty()) {
                control.setValue("resources", collection.getResources());
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            String name = control.getString("name");
            return new LibraryCollection(name);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            XML.getLoader(LibraryResource.class).loadObject(control, obj);
            LibraryCollection collection = (LibraryCollection)obj;
            collection.resources.clear();
            LibraryResource[] resources = (LibraryResource[])control.getObject("resources");
            if (resources != null) {
                LibraryResource[] libraryResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    LibraryResource next = libraryResourceArray[n2];
                    collection.addResource(next);
                    ++n2;
                }
            } else {
                String target = control.getString("target");
                collection.setTarget(target);
            }
            return collection;
        }
    }
}

