/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.LibraryCollection;
import org.opensourcephysics.tools.LibraryResource;
import org.opensourcephysics.tools.LibraryTreeNode;
import org.opensourcephysics.tools.ResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LibraryComPADRE {
    public static final String OSP_INFO_URL = "https://www.compadre.org/osp/online_help/EjsDL/OSPCollection.html";
    public static final String EJS_SERVER_TREE = "https://www.compadre.org/osp/services/REST/osp_jars.cfm?verb=Identify&OSPType=EJS%20Model&AttachedDocument=Source%20Code";
    public static final String EJS_SERVER_RECORDS = "https://www.compadre.org/osp/services/REST/osp_jars.cfm?OSPType=EJS%20Model&AttachedDocument=Source%20Code";
    public static final String EJS_COLLECTION_NAME = "OSP EJS Collection";
    public static final String EJS_INFO_URL = "https://www.compadre.org/osp/online_help/EjsDL/DLModels.html";
    public static final String TRACKER_SERVER_TREE = "https://www.compadre.org/osp/services/REST/osp_tracker.cfm?verb=Identify&OSPType=Tracker";
    public static final String TRACKER_SERVER_RECORDS = "https://www.compadre.org/osp/services/REST/osp_tracker.cfm?OSPType=Tracker";
    public static final String TRACKER_COLLECTION_NAME = "OSP Tracker Collection";
    public static final String TRACKER_INFO_URL = "https://opensourcephysics.github.io/resources/CAB/comPADRE_collection.html";
    public static final String PRIMARY_ONLY = "&OSPPrimary=Subject";
    public static final String GENERIC_COLLECTION_NAME = "ComPADRE OSP Collection";
    public static final String ABOUT_OSP = "About OSP and ComPADRE";
    public static final String HOST = "www.compadre.org";
    public static final String COMPADRE_QUERY = "https://www.compadre.org/osp/services/REST/osp";
    public static String desiredOSPType;

    protected static boolean load(LibraryCollection collection, String query) {
        try {
            URL url = new URL(query);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().parse(url.openStream());
            NodeList nodeList = doc.getElementsByTagName("Identify");
            boolean success = false;
            int i = 0;
            while (i < nodeList.getLength()) {
                success = LibraryComPADRE.loadSubtrees(collection, nodeList.item(i).getChildNodes(), "osp-subject", "") || success;
                ++i;
            }
            return success;
        }
        catch (Exception e) {
            OSPLog.warning("failed to load ComPADRE collection " + query + " " + e);
            return false;
        }
    }

    protected static boolean loadSubtrees(LibraryCollection collection, NodeList nodeList, String attributeType, String serviceParameter) {
        boolean success = false;
        String dblClick = "...";
        int i = 0;
        while (i < nodeList.getLength()) {
            List<Node> subTrees;
            Element node;
            if (nodeList.item(i) instanceof Element && (node = (Element)nodeList.item(i)).getNodeName().equals("sub-tree-set") && attributeType.equals(node.getAttribute("type")) && (subTrees = LibraryComPADRE.getAllChildren(node, "sub-tree")).size() > 0) {
                String unclassifiedURL = null;
                int j = 0;
                while (j < subTrees.size()) {
                    if (subTrees.get(j) instanceof Element) {
                        Element subtree = (Element)subTrees.get(j);
                        String name = subtree.getAttribute("name");
                        String serviceParam = subtree.getAttribute("service-parameter");
                        serviceParam = String.valueOf(serviceParameter) + "&" + ResourceLoader.getNonURIPath(serviceParam);
                        if (name.equals("Unclassified")) {
                            unclassifiedURL = serviceParam;
                        } else {
                            LibraryCollection subCollection = new LibraryCollection(name);
                            collection.addResource(subCollection);
                            success = true;
                            if (LibraryComPADRE.getAllChildren(subtree, "sub-tree-set").isEmpty()) {
                                String nodeName = "<h2>" + name + "</h2><blockquote>";
                                subCollection.setDescription(String.valueOf(nodeName) + dblClick + "</blockquote>");
                                subCollection.setTarget(serviceParam);
                            } else {
                                LibraryComPADRE.loadSubtrees(subCollection, subtree.getChildNodes(), String.valueOf(attributeType) + "-detail", serviceParam);
                            }
                        }
                    }
                    ++j;
                }
                if (unclassifiedURL != null) {
                    collection.setTarget(unclassifiedURL);
                }
            }
            ++i;
        }
        return success;
    }

    protected static void loadResources(final LibraryTreeNode treeNode, final Runnable onSuccess, final Runnable onFailure) {
        if (!(treeNode.record instanceof LibraryCollection)) {
            return;
        }
        final LibraryCollection collection = (LibraryCollection)treeNode.record;
        final boolean[] success = new boolean[1];
        final int[] index = new int[1];
        final Runnable whenDone = new Runnable(){

            @Override
            public void run() {
                collection.setDescription(null);
                collection.setTarget(null);
                if (success[0]) {
                    onSuccess.run();
                } else {
                    onFailure.run();
                }
            }
        };
        try {
            final String urlPath = treeNode.getAbsoluteTarget();
            URL url = new URL(urlPath);
            ResourceLoader.getURLContentsAsync(url, bytes -> {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                int n = 0;
                NodeList list = null;
                try {
                    Document doc = factory.newDocumentBuilder().parse(new ByteArrayInputStream((byte[])bytes));
                    list = doc.getElementsByTagName("record");
                    n = list.getLength();
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    e.printStackTrace();
                }
                if (n == 0) {
                    collection.setDescription(null);
                    collection.setTarget(null);
                    onFailure.run();
                    return null;
                }
                final Runnable[] nextIndex = new Runnable[1];
                final Runnable onFound = new Runnable(){

                    @Override
                    public void run() {
                        success[0] = true;
                        LibraryComPADRE.start(nextIndex[0]);
                    }
                };
                final Runnable onNothingNew = new Runnable(){

                    @Override
                    public void run() {
                        success[0] = true;
                        LibraryComPADRE.start(nextIndex[0]);
                    }
                };
                final int ni = n;
                final NodeList l = list;
                nextIndex[0] = new Runnable(){

                    @Override
                    public void run() {
                        if (index[0] >= ni) {
                            whenDone.run();
                        } else if (l != null) {
                            int n = index[0];
                            index[0] = n + 1;
                            LibraryComPADRE.loadNode(l.item(n), collection, treeNode, urlPath, onFound, onNothingNew);
                        }
                    }
                };
                LibraryComPADRE.start(nextIndex[0]);
                return null;
            });
        }
        catch (Exception e) {
            whenDone.run();
            e.printStackTrace();
        }
    }

    protected static void start(Runnable runnable) {
        runnable.run();
    }

    protected static void loadNode(Node node, LibraryCollection collection, LibraryTreeNode treeNode, String urlPath, Runnable onFound, Runnable onNothingNew) {
        try {
            boolean found = false;
            LibraryResource.Attachment attachment = null;
            if (LibraryComPADRE.isDesiredOSPType(node)) {
                if ("EJS".equals(desiredOSPType) && !LibraryComPADRE.isTrackerType(node)) {
                    attachment = LibraryComPADRE.getAttachment(node, new String[]{"Source Code"});
                } else {
                    attachment = LibraryComPADRE.getAttachment(node, new String[]{"Main", "Primary"});
                    if (attachment == null) {
                        attachment = LibraryComPADRE.getAttachment(node, new String[]{"Supplemental"});
                    }
                }
            }
            if (attachment == null) {
                onNothingNew.run();
                return;
            }
            String name = LibraryComPADRE.getChildValue(node, "title");
            LibraryResource record = new LibraryResource(name);
            collection.addResource(record);
            if (LibraryComPADRE.setRecord(record, node, attachment, treeNode)) {
                found = true;
                OSPRuntime.showStatus(name);
                record.setProperty("reload_url", urlPath);
            }
            if (found) {
                onFound.run();
            } else {
                onNothingNew.run();
            }
        }
        catch (Exception e) {
            OSPLog.debug("LibraryComPADRE exception " + e.getMessage());
        }
    }

    protected static void reloadResource(LibraryTreeNode treeNode, String urlPath, Runnable whenDone) {
        try {
            LibraryResource record = treeNode.record;
            URL url = new URL(urlPath);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().parse(url.openStream());
            NodeList list = doc.getElementsByTagName("record");
            int n = list.getLength();
            int i = 0;
            while (i < n) {
                String downloadURL;
                Node node = list.item(i);
                LibraryResource.Attachment attachment = null;
                if (LibraryComPADRE.isDesiredOSPType(node)) {
                    if ("EJS".equals(desiredOSPType) && !LibraryComPADRE.isTrackerType(node)) {
                        attachment = LibraryComPADRE.getAttachment(node, new String[]{"Source Code"});
                    } else {
                        attachment = LibraryComPADRE.getAttachment(node, new String[]{"Main", "Primary"});
                        if (attachment == null) {
                            attachment = LibraryComPADRE.getAttachment(node, new String[]{"Supplemental"});
                        }
                    }
                }
                if (attachment != null && (downloadURL = LibraryComPADRE.processURL(attachment.url)).equals(record.getTarget())) {
                    LibraryComPADRE.setRecord(record, node, attachment, treeNode);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static boolean setRecord(LibraryResource record, Node node, LibraryResource.Attachment attachment, LibraryTreeNode treeNode) {
        try {
            String downloadURL = LibraryComPADRE.processURL(attachment.url);
            record.setTarget(downloadURL);
            String name = LibraryComPADRE.getChildValue(node, "title");
            record.setName(name);
            record.setProperty("download_filename", attachment.filename);
            String type = LibraryComPADRE.getChildValue(node, "osp-type");
            if (LibraryComPADRE.isDesiredOSPType(node)) {
                if ("EJS".equals(desiredOSPType) && !LibraryComPADRE.isTrackerType(node)) {
                    type = "EJS";
                    record.setType(type);
                } else if ("Tracker".equals(desiredOSPType)) {
                    type = "Tracker";
                    record.setType(type);
                } else if (type.toLowerCase().contains("track")) {
                    type = "Tracker";
                    record.setType(type);
                } else if (type.toLowerCase().contains("ej")) {
                    type = "EJS";
                    record.setType(type);
                } else {
                    record.setType("Unknown");
                }
            }
            String description = LibraryComPADRE.getChildValue(node, "description");
            String infoURL = LibraryComPADRE.getChildValue(node, "information-url");
            String thumbnailURL = LibraryComPADRE.getChildValue(node, "thumbnail-url");
            String authors = "";
            for (Node next : LibraryComPADRE.getAllChildren(LibraryComPADRE.getFirstChild(node, "contributors"), "contributor")) {
                Element el = (Element)next;
                if (!"Author".equals(el.getAttribute("role"))) continue;
                authors = String.valueOf(authors) + LibraryComPADRE.getNodeValue(next) + ", ";
            }
            if (authors.endsWith(", ")) {
                authors = authors.substring(0, authors.length() - 2);
            }
            if (OSPRuntime.doCacheThumbnail) {
                File cachedFile = ResourceLoader.getOSPCacheFile(thumbnailURL);
                String cachePath = cachedFile.getAbsolutePath();
                record.setThumbnail(cachePath);
                if (!cachedFile.exists()) {
                    LibraryTreeNode libraryTreeNode = treeNode;
                    libraryTreeNode.getClass();
                    new LibraryTreeNode.ThumbnailLoader(libraryTreeNode, thumbnailURL, cachePath, "LibraryComPADR.setRecord").runMe();
                }
                thumbnailURL = ResourceLoader.getURIPath(cachePath);
            } else {
                record.setThumbnail(thumbnailURL);
            }
            String htmlCode = LibraryResource.getHTMLBody(name, type, thumbnailURL, description, authors, null, infoURL, attachment);
            record.setDescription(htmlCode);
            record.setMetadata(null);
            ArrayList<String> words = new ArrayList<String>();
            for (Node next : LibraryComPADRE.getAllChildren(node, "osp-subject")) {
                String[] subjects;
                String[] stringArray = subjects = LibraryComPADRE.getNodeValue(next).split(" / ");
                int n = subjects.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (!s.equals("General") && !words.contains(s)) {
                        words.add(s);
                    }
                    ++n2;
                }
            }
            if (!words.isEmpty()) {
                StringBuffer buf = new StringBuffer();
                for (String s : words) {
                    buf.append(String.valueOf(s) + ", ");
                }
                String keywords = buf.toString();
                keywords = keywords.substring(0, keywords.length() - 2);
                record.addMetadata(new LibraryResource.Metadata("keywords", keywords));
            }
            if (!"".equals(authors)) {
                record.addMetadata(new LibraryResource.Metadata("author", authors));
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected static LibraryResource.Attachment getAttachment(Node node, String[] attachmentTypes) {
        String id = LibraryComPADRE.getChildValue(node, "file-identifier");
        NodeList childList = node.getChildNodes();
        LibraryResource.Attachment attachment = null;
        int i = 0;
        int n = childList.getLength();
        while (i < n) {
            Node child = childList.item(i);
            if (child.getNodeName().equals("attached-document")) {
                boolean matchID = id.equals(LibraryComPADRE.getChildValue(child, "file-identifier"));
                Node fileTypeNode = LibraryComPADRE.getFirstChild(child, "file-type");
                int j = 0;
                while (j < attachmentTypes.length) {
                    Node urlNode;
                    if (fileTypeNode != null && attachmentTypes[j].equals(LibraryComPADRE.getNodeValue(fileTypeNode)) && (urlNode = LibraryComPADRE.getFirstChild(child, "download-url")) != null && (attachment == null || matchID)) {
                        String attachmentURL = LibraryComPADRE.getNodeValue(urlNode);
                        Element fileNode = (Element)LibraryComPADRE.getFirstChild(child, "file-name");
                        attachment = new LibraryResource.Attachment(node, attachmentTypes[j], attachmentURL, LibraryComPADRE.getNodeValue(fileNode), fileNode == null ? 0 : Integer.parseInt(fileNode.getAttribute("file-size")));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return attachment;
    }

    protected static Node getFirstChild(Node parent, String name) {
        NodeList childList = parent.getChildNodes();
        int i = 0;
        int n = childList.getLength();
        while (i < n) {
            Node child = childList.item(i);
            if (child.getNodeName().equals(name)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    protected static List<Node> getAllChildren(Node parent, String name) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList childrenList = parent.getChildNodes();
        int i = 0;
        int n = childrenList.getLength();
        while (i < n) {
            Node child = childrenList.item(i);
            if (child.getNodeName().equals(name)) {
                list.add(child);
            }
            ++i;
        }
        return list;
    }

    protected static String getNodeValue(Node node) {
        if (node != null) {
            Node child = node.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 3) {
                    return child.getNodeValue();
                }
                child = child.getNextSibling();
            }
        }
        return null;
    }

    protected static String getChildValue(Node parent, String name) {
        Node node = LibraryComPADRE.getFirstChild(parent, name);
        return node == null ? null : LibraryComPADRE.getNodeValue(node);
    }

    protected static String processURL(String url) {
        StringBuffer processed = new StringBuffer();
        int index = url.indexOf("&amp;");
        while (index >= 0) {
            processed.append(url.subSequence(0, index + 1));
            url = url.substring(index + 5);
            index = url.indexOf("&amp;");
        }
        processed.append(url);
        return processed.toString();
    }

    protected static String writeXmlFile(Document doc, String filename) {
        try {
            DOMSource source = new DOMSource(doc);
            File file = new File(filename);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            return ResourceLoader.getString(filename);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getCollectionName(String path) {
        if (path.startsWith(EJS_SERVER_TREE)) {
            return EJS_COLLECTION_NAME;
        }
        if (path.startsWith(TRACKER_SERVER_TREE)) {
            return TRACKER_COLLECTION_NAME;
        }
        return GENERIC_COLLECTION_NAME;
    }

    protected static LibraryCollection getCollection(String path) {
        String name = LibraryComPADRE.getCollectionName(path);
        boolean primarySubjectOnly = path.indexOf(PRIMARY_ONLY) > -1;
        LibraryCollection collection = new LibraryCollection(name);
        if (name.equals(EJS_COLLECTION_NAME)) {
            collection.setHTMLPath(EJS_INFO_URL);
        } else if (name.equals(TRACKER_COLLECTION_NAME)) {
            collection.setHTMLPath(TRACKER_INFO_URL);
        }
        LibraryResource aboutOSP = new LibraryResource(ABOUT_OSP);
        aboutOSP.setHTMLPath(OSP_INFO_URL);
        collection.addResource(aboutOSP);
        LibraryComPADRE.load(collection, path);
        String base = EJS_SERVER_RECORDS;
        if (name.equals(TRACKER_COLLECTION_NAME)) {
            base = TRACKER_SERVER_RECORDS;
        }
        if (primarySubjectOnly) {
            base = String.valueOf(base) + PRIMARY_ONLY;
        }
        collection.setBasePath(base);
        return collection;
    }

    protected static String getCollectionPath(String path, boolean primarySubjectOnly) {
        boolean isPrimary = path.endsWith(PRIMARY_ONLY);
        if (isPrimary && primarySubjectOnly) {
            return path;
        }
        if (!isPrimary && !primarySubjectOnly) {
            return path;
        }
        if (!isPrimary && primarySubjectOnly) {
            return String.valueOf(path) + PRIMARY_ONLY;
        }
        return path.substring(0, path.length() - PRIMARY_ONLY.length());
    }

    protected static boolean isComPADREPath(String path) {
        return path != null && path.startsWith(COMPADRE_QUERY);
    }

    protected static boolean isPrimarySubjectOnly(String path) {
        return path.indexOf(PRIMARY_ONLY) > -1;
    }

    protected static boolean isDesiredOSPType(Node node) {
        List<Node> nodes = LibraryComPADRE.getAllChildren(node, "osp-type");
        for (Node next : nodes) {
            String s;
            if (desiredOSPType != null && !(s = LibraryComPADRE.getNodeValue(next)).contains(desiredOSPType) && !s.contains("Tracker")) continue;
            return true;
        }
        return false;
    }

    protected static boolean isTrackerType(Node node) {
        List<Node> nodes = LibraryComPADRE.getAllChildren(node, "osp-type");
        for (Node next : nodes) {
            if (!LibraryComPADRE.getNodeValue(next).contains("Tracker")) continue;
            return true;
        }
        return false;
    }
}

