/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.tools.Library;
import org.opensourcephysics.tools.LibraryBrowser;
import org.opensourcephysics.tools.LibraryComPADRE;
import org.opensourcephysics.tools.ResourceLoader;

public class LibraryJSSearchRefresher
implements PropertyChangeListener {
    private final int BUFFER_SIZE = 4096;
    private final String host = "opensourcephysics.github.io/tracker-website/search/";
    private final String ftpURLFormat = "ftp://%s@%s;type=i";
    private final String[] libraryPaths = new String[]{"https://opensourcephysics.github.io/resources/CAB/tracker_library.xml", "https://opensourcephysics.github.io/resources/CAB/shared_library.xml"};
    private LibraryBrowser browser;
    private ArrayList<String> paths = new ArrayList();
    private ArrayList<String> names = new ArrayList();
    private TreeMap<String, String> nameToPathMap = new TreeMap();
    private int currentIndex = 0;
    private String usernameAndPW;

    public static void main(String[] args) {
        new LibraryJSSearchRefresher().refreshSearchData();
    }

    void refreshSearchData() {
        this.readFTPLoginData();
        this.openLibraryBrowser();
        this.chooseCollectionsToRefresh();
        this.refreshNext();
    }

    void readFTPLoginData() {
        String userhome = System.getProperty("user.home");
        File file = new File(userhome, "ftp_login.txt");
        if (!file.exists()) {
            JOptionPane.showMessageDialog(null, "File " + file.getPath() + " not found.\n" + "The file should contain the single line \"FTPusername:pw\"");
            System.exit(0);
        }
        this.usernameAndPW = ResourceLoader.getString(file.getPath()).trim();
    }

    void openLibraryBrowser() {
        this.browser = LibraryBrowser.getBrowser();
        this.browser.addMetadataLoaderListener(this);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.browser.getBounds().width) / 2;
        int y = (dim.height - this.browser.getBounds().height) / 2;
        this.browser.setLocation(x, y);
        this.browser.setVisible(true);
    }

    void chooseCollectionsToRefresh() {
        String query = "https://www.compadre.org/osp/services/REST/osp_tracker.cfm?verb=Identify&OSPType=Tracker&OSPPrimary=Subject";
        String compadreName = "ComPADRE " + LibraryComPADRE.getCollectionName(query);
        this.nameToPathMap.put(compadreName, query);
        int i = 0;
        while (i < this.libraryPaths.length) {
            XMLControlElement control = new XMLControlElement(this.libraryPaths[i]);
            Library lib = new Library();
            control.loadObject(lib);
            HashMap<String, String> map = lib.getNameMap();
            TreeSet<String> paths = lib.getAllPaths();
            for (String path : paths) {
                this.nameToPathMap.put(map.get(path), path);
            }
            ++i;
        }
        for (String name : this.nameToPathMap.keySet()) {
            this.names.add(name);
            this.paths.add(this.nameToPathMap.get(name));
        }
        ListChooser dialog = new ListChooser("", "Refresh search data for:", null, null);
        if (!dialog.choose(this.paths, this.names, null, null, null, null)) {
            this.paths.clear();
        }
    }

    void refreshNext() {
        if (this.currentIndex < this.paths.size()) {
            String next = this.paths.get(this.currentIndex);
            ++this.currentIndex;
            this.browser.open(next);
        } else {
            System.exit(0);
        }
    }

    void uploadToWeb(String localFilePath) {
        String ftpURL = String.format("ftp://%s@%s;type=i", this.usernameAndPW, "opensourcephysics.github.io/tracker-website/search/" + XML.getName(localFilePath));
        try {
            URL url = new URL(ftpURL);
            URLConnection conn = url.openConnection();
            OutputStream outputStream = conn.getOutputStream();
            FileInputStream inputStream = new FileInputStream(localFilePath);
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            inputStream.close();
            outputStream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        File file = (File)e.getNewValue();
        if (file.exists()) {
            this.uploadToWeb(file.getAbsolutePath());
        }
        this.browser.closeTab(0);
        this.refreshNext();
    }
}

