/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Library;
import org.opensourcephysics.tools.LibraryBrowser;
import org.opensourcephysics.tools.LibraryCollection;
import org.opensourcephysics.tools.LibraryTreePanel;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

public class LibraryManager
extends JDialog {
    LibraryBrowser browser;
    Library library;
    JTabbedPane tabbedPane;
    JPanel collectionsPanel;
    JPanel importsPanel;
    JPanel searchPanel;
    JPanel cachePanel;
    JPanel recentPanel;
    JList<String> collectionList;
    JList<String> guestList;
    JTextField nameField;
    JTextField pathField;
    ActionListener nameAction;
    ActionListener pathAction;
    JButton okButton;
    JButton setCacheButton;
    JButton moveUpButton;
    JButton moveDownButton;
    JButton addButton;
    JButton removeButton;
    JButton allButton;
    JButton noneButton;
    JButton clearCacheButton;
    JToolBar libraryButtonbar;
    Box nameBox;
    Box pathBox;
    Box libraryEditBox;
    Box searchBox;
    Box cacheBox;
    JLabel nameLabel;
    JLabel pathLabel;
    Font sharedFont;
    TitledBorder collectionsTitleBorder;
    TitledBorder importsTitleBorder;
    TitledBorder searchTitleBorder;
    TitledBorder cacheTitleBorder;
    ArrayList<SearchCheckBox> checkboxes = new ArrayList();
    Dimension defaultSize = new Dimension(400, 300);
    Border listButtonBorder;

    protected LibraryManager(LibraryBrowser browser, JFrame frame) {
        super((Frame)frame, true);
        this.browser = browser;
        this.library = browser.library;
        this.setDefaultCloseOperation(1);
        this.createGUI();
        Dimension dim = new Dimension(this.defaultSize);
        double factor = 1.0 + (double)FontSizer.getLevel() * 0.25;
        dim.width = (int)((double)dim.width * factor);
        dim.height = (int)((double)dim.height * factor);
        this.setSize(dim);
    }

    protected LibraryManager(LibraryBrowser browser, JDialog dialog) {
        super((Dialog)dialog, true);
        this.browser = browser;
        this.library = browser.library;
        this.setDefaultCloseOperation(1);
        this.createGUI();
        Dimension dim = new Dimension(this.defaultSize);
        double factor = 1.0 + (double)FontSizer.getLevel() * 0.25;
        dim.width = (int)((double)dim.width * factor);
        dim.height = (int)((double)dim.height * factor);
        this.setSize(dim);
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            this.refreshSearchTab();
            this.refreshCacheTab();
        } else {
            this.library.noSearchSet.clear();
            for (SearchCheckBox next : this.checkboxes) {
                if (next.isSelected()) continue;
                this.library.noSearchSet.add(next.urlPath);
            }
        }
        super.setVisible(vis);
    }

    protected void createGUI() {
        JButton throwaway = new JButton("by");
        throwaway.setBorder(LibraryBrowser.buttonBorder);
        int h = throwaway.getPreferredSize().height;
        this.sharedFont = throwaway.getFont();
        AbstractListModel<String> collectionListModel = new AbstractListModel<String>(){

            @Override
            public int getSize() {
                return LibraryManager.this.library.pathList.size();
            }

            @Override
            public String getElementAt(int i) {
                String path = LibraryManager.this.library.pathList.get(i);
                return LibraryManager.this.library.pathToNameMap.get(path);
            }
        };
        this.collectionList = new JList<String>(collectionListModel);
        this.collectionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LibraryManager.this.refreshGUI();
            }
        });
        this.collectionList.setFixedCellHeight(h);
        this.collectionList.setFont(this.sharedFont);
        this.collectionList.setSelectionMode(0);
        AbstractListModel<String> importListModel = new AbstractListModel<String>(){

            @Override
            public int getSize() {
                return LibraryManager.this.library.importedPathList.size();
            }

            @Override
            public String getElementAt(int i) {
                String path = LibraryManager.this.library.importedPathList.get(i);
                return LibraryManager.this.library.importedPathToLibraryMap.get(path).getName();
            }
        };
        this.guestList = new JList<String>(importListModel);
        this.guestList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LibraryManager.this.refreshGUI();
            }
        });
        this.guestList.setFont(this.sharedFont);
        this.guestList.setFixedCellHeight(h);
        this.guestList.setSelectionMode(0);
        this.nameAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = LibraryManager.this.pathField.getText();
                String prev = LibraryManager.this.library.pathToNameMap.get(path);
                String input = LibraryManager.this.nameField.getText().trim();
                if (input == null || input.equals("") || input.equals(prev)) {
                    return;
                }
                LibraryManager.this.library.renameCollection(path, input);
                LibraryManager.this.browser.refreshCollectionsMenu();
                LibraryManager.this.collectionList.repaint();
                LibraryManager.this.refreshGUI();
            }
        };
        this.nameField = new LibraryTreePanel.EntryField();
        this.nameField.addActionListener(this.nameAction);
        this.nameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LibraryManager.this.nameField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                LibraryManager.this.nameAction.actionPerformed(null);
            }
        });
        this.nameField.setBackground(Color.white);
        this.nameLabel = new JLabel();
        this.nameLabel.setFont(this.sharedFont);
        this.nameLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        this.nameLabel.setHorizontalAlignment(11);
        this.pathField = new LibraryTreePanel.EntryField();
        this.pathField.setEditable(false);
        this.pathField.setBackground(Color.white);
        this.pathLabel = new JLabel();
        this.pathLabel.setFont(this.sharedFont);
        this.pathLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        this.pathLabel.setHorizontalAlignment(11);
        this.okButton = new JButton();
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryManager.this.setVisible(false);
            }
        });
        this.moveUpButton = new JButton();
        this.moveUpButton.setOpaque(false);
        this.moveUpButton.setBorder(LibraryBrowser.buttonBorder);
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isImports = LibraryManager.this.tabbedPane.getSelectedComponent() == LibraryManager.this.importsPanel;
                JList<String> list = isImports ? LibraryManager.this.guestList : LibraryManager.this.collectionList;
                ArrayList<String> paths = isImports ? LibraryManager.this.library.importedPathList : LibraryManager.this.library.pathList;
                int i = list.getSelectedIndex();
                String path = paths.get(i);
                paths.remove(path);
                paths.add(i - 1, path);
                list.setSelectedIndex(i - 1);
                LibraryManager.this.browser.refreshCollectionsMenu();
                LibraryManager.this.browser.refreshGUI();
            }
        });
        this.moveDownButton = new JButton();
        this.moveDownButton.setOpaque(false);
        this.moveDownButton.setBorder(LibraryBrowser.buttonBorder);
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isImports = LibraryManager.this.tabbedPane.getSelectedComponent() == LibraryManager.this.importsPanel;
                JList<String> list = isImports ? LibraryManager.this.guestList : LibraryManager.this.collectionList;
                ArrayList<String> paths = isImports ? LibraryManager.this.library.importedPathList : LibraryManager.this.library.pathList;
                int i = list.getSelectedIndex();
                String path = paths.get(i);
                paths.remove(path);
                paths.add(i + 1, path);
                list.setSelectedIndex(i + 1);
                LibraryManager.this.browser.refreshCollectionsMenu();
                LibraryManager.this.browser.refreshGUI();
            }
        });
        this.addButton = new JButton();
        this.addButton.setOpaque(false);
        this.addButton.setBorder(LibraryBrowser.buttonBorder);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLControlElement control;
                String title;
                boolean imported = LibraryManager.this.tabbedPane.getSelectedComponent() == LibraryManager.this.importsPanel;
                String message = imported ? ToolsRes.getString("LibraryBrowser.Dialog.AddLibrary.Message") : ToolsRes.getString("LibraryBrowser.Dialog.AddCollection.Message");
                String input = GUIUtils.showInputDialog(LibraryManager.this.browser, message, title = imported ? ToolsRes.getString("LibraryBrowser.Dialog.AddLibrary.Title") : ToolsRes.getString("LibraryBrowser.Dialog.AddCollection.Title"), 3, null);
                if (input == null || input.equals("")) {
                    return;
                }
                String path = input;
                path = XML.forwardSlash(path);
                path = ResourceLoader.getNonURIPath(path);
                if (LibraryManager.this.tabbedPane.getSelectedComponent() == LibraryManager.this.collectionsPanel) {
                    boolean isResource = false;
                    if (!ResourceLoader.isHTTP(path) && new File(path).isDirectory()) {
                        isResource = true;
                    } else {
                        control = new XMLControlElement(path);
                        if (!control.failedToRead() && control.getObjectClass() == LibraryCollection.class) {
                            isResource = true;
                        }
                    }
                    if (isResource) {
                        System.out.println("LM OK " + path);
                        LibraryManager.this.browser.addToCollections(path);
                        ListModel<String> model = LibraryManager.this.collectionList.getModel();
                        LibraryManager.this.collectionList.setModel(model);
                        LibraryManager.this.refreshGUI();
                        LibraryManager.this.collectionList.repaint();
                        LibraryManager.this.collectionList.setSelectedIndex(LibraryManager.this.library.pathList.size() - 1);
                        LibraryManager.this.browser.refreshCollectionsMenu();
                        return;
                    }
                }
                if (LibraryManager.this.tabbedPane.getSelectedComponent() == LibraryManager.this.importsPanel) {
                    boolean isLibrary = false;
                    control = new XMLControlElement(path);
                    if (!control.failedToRead() && control.getObjectClass() == Library.class) {
                        isLibrary = true;
                    }
                    if (isLibrary) {
                        Library newLibrary = new Library();
                        newLibrary.browser = LibraryManager.this.browser;
                        control.loadObject(newLibrary);
                        if (LibraryManager.this.library.importLibrary(path, newLibrary)) {
                            ListModel<String> model = LibraryManager.this.guestList.getModel();
                            LibraryManager.this.guestList.setModel(model);
                            LibraryManager.this.refreshGUI();
                            LibraryManager.this.guestList.repaint();
                            LibraryManager.this.guestList.setSelectedIndex(LibraryManager.this.library.importedPathList.size() - 1);
                            LibraryManager.this.browser.refreshCollectionsMenu();
                        }
                        return;
                    }
                }
                LibraryManager.this.warnNotFound(path);
            }
        });
        this.removeButton = new JButton();
        this.removeButton.setOpaque(false);
        this.removeButton.setBorder(LibraryBrowser.buttonBorder);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isImports = LibraryManager.this.tabbedPane.getSelectedComponent() == LibraryManager.this.importsPanel;
                JList<String> list = isImports ? LibraryManager.this.guestList : LibraryManager.this.collectionList;
                ArrayList<String> paths = isImports ? LibraryManager.this.library.importedPathList : LibraryManager.this.library.pathList;
                int i = list.getSelectedIndex();
                String path = paths.get(i);
                paths.remove(path);
                if (isImports) {
                    LibraryManager.this.library.importedPathToLibraryMap.remove(path);
                } else {
                    LibraryManager.this.library.pathToNameMap.remove(path);
                }
                list.repaint();
                if (i >= paths.size()) {
                    list.setSelectedIndex(paths.size() - 1);
                }
                LibraryManager.this.browser.refreshCollectionsMenu();
                LibraryManager.this.refreshGUI();
                LibraryManager.this.browser.refreshGUI();
            }
        });
        this.allButton = new JButton();
        this.allButton.setOpaque(false);
        this.allButton.setBorder(LibraryBrowser.buttonBorder);
        this.allButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (SearchCheckBox next : LibraryManager.this.checkboxes) {
                    next.setSelected(true);
                }
            }
        });
        this.noneButton = new JButton();
        this.noneButton.setOpaque(false);
        this.noneButton.setBorder(LibraryBrowser.buttonBorder);
        this.noneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (SearchCheckBox next : LibraryManager.this.checkboxes) {
                    next.setSelected(false);
                }
            }
        });
        this.clearCacheButton = new JButton();
        this.clearCacheButton.setOpaque(false);
        this.clearCacheButton.setBorder(LibraryBrowser.buttonBorder);
        this.clearCacheButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryBrowser.clearCache();
                LibraryManager.this.refreshCacheTab();
                LibraryManager.this.tabbedPane.repaint();
            }
        });
        this.setCacheButton = new JButton();
        this.setCacheButton.setOpaque(false);
        this.setCacheButton.setBorder(LibraryBrowser.buttonBorder);
        this.setCacheButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceLoader.setOSPCache(ResourceLoader.chooseOSPCache(LibraryManager.this.browser));
                LibraryManager.this.refreshCacheTab();
            }
        });
        Border emptyInside = BorderFactory.createEmptyBorder(1, 2, 1, 2);
        Border etched = BorderFactory.createEtchedBorder();
        CompoundBorder buttonbarBorder = BorderFactory.createCompoundBorder(etched, emptyInside);
        this.libraryButtonbar = new JToolBar();
        this.libraryButtonbar.setFloatable(false);
        this.libraryButtonbar.setBorder(buttonbarBorder);
        this.libraryButtonbar.add(this.moveUpButton);
        this.libraryButtonbar.add(this.moveDownButton);
        this.libraryButtonbar.add(this.addButton);
        this.libraryButtonbar.add(this.removeButton);
        this.nameBox = Box.createHorizontalBox();
        this.nameBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 4));
        this.nameBox.add(this.nameLabel);
        this.nameBox.add(this.nameField);
        this.pathBox = Box.createHorizontalBox();
        this.pathBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 4));
        this.pathBox.add(this.pathLabel);
        this.pathBox.add(this.pathField);
        this.libraryEditBox = Box.createVerticalBox();
        this.libraryEditBox.add(this.nameBox);
        this.libraryEditBox.add(this.pathBox);
        this.collectionsPanel = new JPanel(new BorderLayout());
        JScrollPane scroller = new JScrollPane(this.collectionList);
        scroller.setViewportBorder(etched);
        scroller.getVerticalScrollBar().setUnitIncrement(8);
        this.collectionsTitleBorder = BorderFactory.createTitledBorder("");
        scroller.setBorder(this.collectionsTitleBorder);
        this.collectionsPanel.add((Component)scroller, "Center");
        this.collectionsPanel.add((Component)this.libraryEditBox, "South");
        this.collectionsPanel.add((Component)this.libraryButtonbar, "North");
        this.importsPanel = new JPanel(new BorderLayout());
        scroller = new JScrollPane(this.guestList);
        scroller.setViewportBorder(etched);
        scroller.getVerticalScrollBar().setUnitIncrement(8);
        this.importsTitleBorder = BorderFactory.createTitledBorder("");
        scroller.setBorder(this.importsTitleBorder);
        this.importsPanel.add((Component)scroller, "Center");
        this.searchPanel = new JPanel(new BorderLayout());
        this.searchBox = Box.createVerticalBox();
        this.searchBox.setBackground(Color.white);
        this.searchBox.setOpaque(true);
        this.refreshSearchTab();
        scroller = new JScrollPane(this.searchBox);
        scroller.setViewportBorder(etched);
        scroller.getVerticalScrollBar().setUnitIncrement(8);
        this.searchTitleBorder = BorderFactory.createTitledBorder("");
        scroller.setBorder(this.searchTitleBorder);
        this.searchPanel.add((Component)scroller, "Center");
        JToolBar searchButtonbar = new JToolBar();
        searchButtonbar.setFloatable(false);
        searchButtonbar.setBorder(buttonbarBorder);
        searchButtonbar.add(this.allButton);
        searchButtonbar.add(this.noneButton);
        this.searchPanel.add((Component)searchButtonbar, "North");
        this.cachePanel = new JPanel(new BorderLayout());
        this.cacheBox = Box.createVerticalBox();
        this.cacheBox.setBackground(Color.white);
        this.cacheBox.setOpaque(true);
        this.refreshCacheTab();
        scroller = new JScrollPane(this.cacheBox);
        scroller.setViewportBorder(etched);
        scroller.getVerticalScrollBar().setUnitIncrement(8);
        this.cacheTitleBorder = BorderFactory.createTitledBorder("");
        scroller.setBorder(this.cacheTitleBorder);
        this.cachePanel.add((Component)scroller, "Center");
        JToolBar cacheButtonbar = new JToolBar();
        cacheButtonbar.setFloatable(false);
        cacheButtonbar.setBorder(buttonbarBorder);
        cacheButtonbar.add(this.clearCacheButton);
        cacheButtonbar.add(this.setCacheButton);
        this.cachePanel.add((Component)cacheButtonbar, "North");
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("", this.collectionsPanel);
        this.tabbedPane.addTab("", this.cachePanel);
        if (!OSPRuntime.isJS) {
            this.tabbedPane.addTab("", this.searchPanel);
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (LibraryManager.this.tabbedPane.getSelectedComponent() == LibraryManager.this.collectionsPanel) {
                    LibraryManager.this.collectionsPanel.add((Component)LibraryManager.this.libraryButtonbar, "North");
                    LibraryManager.this.collectionsPanel.add((Component)LibraryManager.this.libraryEditBox, "South");
                    LibraryManager.this.refreshGUI();
                } else if (LibraryManager.this.tabbedPane.getSelectedComponent() == LibraryManager.this.importsPanel) {
                    LibraryManager.this.importsPanel.add((Component)LibraryManager.this.libraryButtonbar, "North");
                    LibraryManager.this.importsPanel.add((Component)LibraryManager.this.libraryEditBox, "South");
                    LibraryManager.this.refreshGUI();
                }
            }
        });
        Border space = BorderFactory.createEmptyBorder(0, 2, 0, 2);
        this.listButtonBorder = BorderFactory.createCompoundBorder(etched, space);
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        contentPane.add((Component)this.tabbedPane, "Center");
        JPanel south = new JPanel();
        south.add(this.okButton);
        contentPane.add((Component)south, "South");
    }

    protected void warnNotFound(String path) {
        String s = ToolsRes.getString("LibraryBrowser.Dialog.CollectionNotFound.Message");
        System.out.println("WARN - LibraryManager " + s + " " + path);
    }

    protected void refreshGUI() {
        this.setTitle(ToolsRes.getString("LibraryManager.Title"));
        this.okButton.setText(ToolsRes.getString("Tool.Button.Close"));
        this.addButton.setText(ToolsRes.getString("LibraryManager.Button.Add"));
        this.removeButton.setText(ToolsRes.getString("LibraryManager.Button.Remove"));
        this.moveUpButton.setText(ToolsRes.getString("LibraryTreePanel.Button.Up"));
        this.moveDownButton.setText(ToolsRes.getString("LibraryTreePanel.Button.Down"));
        this.allButton.setText(ToolsRes.getString("LibraryManager.Button.All"));
        this.noneButton.setText(ToolsRes.getString("LibraryManager.Button.None"));
        this.clearCacheButton.setText(ToolsRes.getString("LibraryManager.Button.ClearCache"));
        this.setCacheButton.setText(ToolsRes.getString("LibraryManager.Button.SetCache"));
        this.addButton.setToolTipText(ToolsRes.getString("LibraryManager.Button.Add.Tooltip"));
        this.removeButton.setToolTipText(ToolsRes.getString("LibraryManager.Button.Remove.Tooltip"));
        this.moveUpButton.setToolTipText(ToolsRes.getString("LibraryTreePanel.Button.Up.Tooltip"));
        this.moveDownButton.setToolTipText(ToolsRes.getString("LibraryTreePanel.Button.Down.Tooltip"));
        this.allButton.setToolTipText(ToolsRes.getString("LibraryManager.Button.All.Tooltip"));
        this.noneButton.setToolTipText(ToolsRes.getString("LibraryManager.Button.None.Tooltip"));
        this.clearCacheButton.setToolTipText(ToolsRes.getString("LibraryManager.Button.ClearCache.Tooltip"));
        this.setCacheButton.setToolTipText(ToolsRes.getString("LibraryManager.Button.SetCache.Tooltip"));
        this.nameLabel.setText(String.valueOf(ToolsRes.getString("LibraryManager.Label.Name")) + ":");
        this.pathLabel.setText(String.valueOf(ToolsRes.getString("LibraryManager.Label.Path")) + ":");
        this.collectionsTitleBorder.setTitle(String.valueOf(ToolsRes.getString("LibraryManager.Title.MenuItems")) + ":");
        this.importsTitleBorder.setTitle(String.valueOf(ToolsRes.getString("LibraryManager.Title.Import")) + ":");
        this.searchTitleBorder.setTitle(String.valueOf(ToolsRes.getString("LibraryManager.Title.Search")) + ":");
        this.cacheTitleBorder.setTitle(String.valueOf(ToolsRes.getString("LibraryManager.Title.Cache")) + ":");
        int k = this.tabbedPane.indexOfComponent(this.collectionsPanel);
        if (k > -1) {
            this.tabbedPane.setTitleAt(k, ToolsRes.getString("LibraryManager.Tab.MyLibrary"));
            this.tabbedPane.setToolTipTextAt(k, ToolsRes.getString("LibraryManager.Tab.MyLibrary.Tooltip"));
        }
        if ((k = this.tabbedPane.indexOfComponent(this.importsPanel)) > -1) {
            this.tabbedPane.setTitleAt(k, ToolsRes.getString("LibraryManager.Tab.Import"));
            this.tabbedPane.setToolTipTextAt(k, ToolsRes.getString("LibraryManager.Tab.Import.Tooltip"));
        }
        if ((k = this.tabbedPane.indexOfComponent(this.searchPanel)) > -1) {
            this.tabbedPane.setTitleAt(k, ToolsRes.getString("LibraryManager.Tab.Search"));
            this.tabbedPane.setToolTipTextAt(k, ToolsRes.getString("LibraryManager.Tab.Search.Tooltip"));
        }
        if ((k = this.tabbedPane.indexOfComponent(this.cachePanel)) > -1) {
            this.tabbedPane.setTitleAt(k, ToolsRes.getString("LibraryManager.Tab.Cache"));
            this.tabbedPane.setToolTipTextAt(k, ToolsRes.getString("LibraryManager.Tab.Cache.Tooltip"));
        }
        this.resizeLabels();
        this.pathField.setForeground(LibraryTreePanel.defaultForeground);
        if (this.tabbedPane.getSelectedComponent() == this.collectionsPanel) {
            this.nameField.setEditable(true);
            int i = this.collectionList.getSelectedIndex();
            this.moveDownButton.setEnabled(i < this.library.pathList.size() - 1);
            this.moveUpButton.setEnabled(i > 0);
            if (i > -1 && this.library.pathList.size() > i) {
                Resource res;
                this.removeButton.setEnabled(true);
                String path = this.library.pathList.get(i);
                this.pathField.setText(path);
                this.pathField.setCaretPosition(0);
                String name = this.library.pathToNameMap.get(path);
                this.nameField.setText(name);
                boolean unavailable = ResourceLoader.isHTTP(path) && !this.browser.isWebConnected(null);
                Resource resource = res = unavailable ? null : ResourceLoader.getResourceZipURLsOK(path);
                if (res == null) {
                    this.pathField.setForeground(LibraryTreePanel.darkRed);
                }
            } else {
                this.removeButton.setEnabled(false);
                this.nameField.setEditable(false);
                this.nameField.setText(null);
                this.nameField.setBackground(Color.white);
                this.pathField.setText(null);
                this.pathField.setBackground(Color.white);
            }
        } else if (this.tabbedPane.getSelectedComponent() == this.importsPanel) {
            this.nameField.setEditable(false);
            int i = this.guestList.getSelectedIndex();
            this.moveDownButton.setEnabled(i < this.library.importedPathList.size() - 1);
            this.moveUpButton.setEnabled(i > 0);
            if (i > -1 && this.library.importedPathList.size() > i) {
                Resource res;
                this.removeButton.setEnabled(true);
                String path = this.library.importedPathList.get(i);
                this.pathField.setText(path);
                this.pathField.setCaretPosition(0);
                String name = this.library.importedPathToLibraryMap.get(path).getName();
                this.nameField.setText(name);
                boolean unavailable = ResourceLoader.isHTTP(path) && !this.browser.isWebConnected(null);
                Resource resource = res = unavailable ? null : ResourceLoader.getResourceZipURLsOK(path);
                if (res == null) {
                    this.pathField.setForeground(LibraryTreePanel.darkRed);
                }
            } else {
                this.removeButton.setEnabled(false);
                this.nameField.setText(null);
                this.nameField.setBackground(Color.white);
                this.pathField.setText(null);
                this.pathField.setBackground(Color.white);
            }
        }
        this.nameField.setBackground(Color.white);
        this.pathField.setBackground(Color.white);
    }

    protected void refreshSearchTab() {
        this.searchBox.removeAll();
        this.checkboxes.clear();
        ArrayList<JLabel> labels = new ArrayList<JLabel>();
        Set<String> names = this.browser.getSearchPathMap().keySet();
        for (String name : names) {
            String string = this.browser.searchPathMap.get(name);
            JLabel jLabel = new JLabel(name);
            jLabel.setToolTipText(string);
            labels.add(jLabel);
            SearchCheckBox checkbox = new SearchCheckBox(string);
            this.checkboxes.add(checkbox);
            Box bar = Box.createHorizontalBox();
            bar.add(jLabel);
            bar.add(checkbox);
            if (!ResourceLoader.isHTTP(string)) {
                bar.add(new DeleteButton(string));
            }
            bar.add(Box.createHorizontalGlue());
            this.searchBox.add(bar);
        }
        FontSizer.setFonts(this.searchBox, FontSizer.getLevel());
        if (labels.isEmpty()) {
            return;
        }
        Font font = ((JLabel)labels.get(0)).getFont();
        int w = 0;
        for (JLabel jLabel : labels) {
            Rectangle2D rect = font.getStringBounds(jLabel.getText(), OSPRuntime.frc);
            w = Math.max(w, (int)rect.getWidth());
        }
        Dimension dimension = new Dimension(w + 48, 20);
        for (JLabel jLabel : labels) {
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            jLabel.setPreferredSize(dimension);
        }
    }

    protected void refreshCacheTab() {
        this.cacheBox.removeAll();
        ArrayList<JLabel> labels = new ArrayList<JLabel>();
        File cache = ResourceLoader.getOSPCache();
        File[] hosts = cache == null ? new File[]{} : cache.listFiles(ResourceLoader.OSP_CACHE_FILTER);
        this.clearCacheButton.setEnabled(hosts.length > 0);
        if (hosts.length == 0) {
            JLabel label = new JLabel(ToolsRes.getString("LibraryManager.Cache.IsEmpty"));
            label.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            Box box = Box.createHorizontalBox();
            box.add(label);
            box.add(Box.createHorizontalGlue());
            this.cacheBox.add(box);
            return;
        }
        File[] fileArray = hosts;
        int n = hosts.length;
        int box = 0;
        while (box < n) {
            File hostFile = fileArray[box];
            String hostText = hostFile.getName().substring(4).replace('_', '.');
            long bytes = this.getFileSize(hostFile);
            long size = bytes / 0x100000L;
            if (bytes > 0L) {
                hostText = size > 0L ? String.valueOf(hostText) + " (" + size + " MB)" : String.valueOf(hostText) + " (" + bytes / 1024L + " kB)";
            }
            JLabel label = new JLabel(hostText);
            label.setToolTipText(hostFile.getAbsolutePath());
            labels.add(label);
            ClearHostButton button = new ClearHostButton(hostFile);
            Box bar = Box.createHorizontalBox();
            bar.add(label);
            bar.add(button);
            bar.add(Box.createHorizontalGlue());
            this.cacheBox.add(bar);
            FontSizer.setFonts(this.cacheBox, FontSizer.getLevel());
            ++box;
        }
        Font font = ((JLabel)labels.get(0)).getFont();
        int w = 0;
        for (JLabel next : labels) {
            Rectangle2D rect = font.getStringBounds(next.getText(), OSPRuntime.frc);
            w = Math.max(w, (int)rect.getWidth());
        }
        Dimension labelSize = new Dimension(w + 48, 20);
        for (JLabel next : labels) {
            next.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            next.setPreferredSize(labelSize);
        }
    }

    protected void setFontLevel(int level) {
        FontSizer.setFonts(this, level);
        Font font = this.collectionList.getFont();
        font = FontSizer.getResizedFont(font, level);
        int space = 8 + level;
        this.collectionList.setFixedCellHeight(font.getSize() + space);
        this.resizeLabels();
    }

    private void resizeLabels() {
        int w = 0;
        Font font = this.nameLabel.getFont();
        Rectangle2D rect = font.getStringBounds(String.valueOf(this.nameLabel.getText()) + " ", OSPRuntime.frc);
        w = Math.max(w, (int)rect.getWidth() + 4);
        rect = font.getStringBounds(String.valueOf(this.pathLabel.getText()) + " ", OSPRuntime.frc);
        w = Math.max(w, (int)rect.getWidth() + 4);
        Dimension labelSize = new Dimension(w, 20);
        this.nameLabel.setPreferredSize(labelSize);
        this.nameLabel.setMinimumSize(labelSize);
        this.pathLabel.setPreferredSize(labelSize);
        this.pathLabel.setMinimumSize(labelSize);
    }

    private long getFileSize(File folder) {
        File[] files;
        if (folder == null) {
            return 0L;
        }
        long foldersize = 0L;
        File[] fileArray = files = folder.equals(ResourceLoader.getOSPCache()) ? folder.listFiles(ResourceLoader.OSP_CACHE_FILTER) : folder.listFiles();
        if (files == null) {
            return 0L;
        }
        int i = 0;
        while (i < files.length) {
            foldersize = files[i].isDirectory() ? (foldersize += this.getFileSize(files[i])) : (foldersize += files[i].length());
            ++i;
        }
        return foldersize;
    }

    protected class ClearHostButton
    extends JButton {
        File hostCacheDir;

        public ClearHostButton(File host) {
            this.hostCacheDir = host;
            this.setText(ToolsRes.getString("LibraryManager.Button.Clear"));
            this.setToolTipText(ToolsRes.getString("LibraryManager.Button.Clear.Tooltip"));
            this.setOpaque(false);
            this.setBorder(LibraryManager.this.listButtonBorder);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ClearHostButton.this.setBorderPainted(true);
                    ClearHostButton.this.setContentAreaFilled(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ClearHostButton.this.setBorderPainted(false);
                    ClearHostButton.this.setContentAreaFilled(false);
                }
            });
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResourceLoader.clearOSPCacheHost(ClearHostButton.this.hostCacheDir);
                    LibraryManager.this.refreshCacheTab();
                    ((ClearHostButton)ClearHostButton.this).LibraryManager.this.tabbedPane.repaint();
                }
            });
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    protected class DeleteButton
    extends JButton {
        String urlPath;

        public DeleteButton(String path) {
            this.urlPath = path;
            this.setText(ToolsRes.getString("LibraryManager.Button.Delete"));
            this.setToolTipText(ToolsRes.getString("LibraryManager.Button.Delete.Tooltip"));
            this.setOpaque(false);
            this.setBorder(LibraryManager.this.listButtonBorder);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    DeleteButton.this.setBorderPainted(true);
                    DeleteButton.this.setContentAreaFilled(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    DeleteButton.this.setBorderPainted(false);
                    DeleteButton.this.setContentAreaFilled(false);
                }
            });
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file = ResourceLoader.getSearchCacheFile(DeleteButton.this.urlPath);
                    if (file.delete()) {
                        LibraryBrowser.isSearchMapLoaded = false;
                        LibraryManager.this.refreshSearchTab();
                    }
                }
            });
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    protected class SearchCheckBox
    extends JCheckBoxMenuItem {
        String urlPath;

        public SearchCheckBox(String path) {
            this.urlPath = path;
            this.setText(ToolsRes.getString("LibraryManager.Checkbox.Search"));
            this.setFont(LibraryManager.this.sharedFont);
            this.setSelected(!LibraryManager.this.library.noSearchSet.contains(path));
            this.setOpaque(false);
            int space = 20 + FontSizer.getLevel() * 5;
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, space));
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

