/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Font;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JButton;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.LibraryCollection;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;
import org.w3c.dom.Node;

public class LibraryResource
implements Comparable<LibraryResource> {
    public static final String META_AUTHOR = "Author";
    public static final String META_CONTACT = "Contact";
    public static final String META_KEYWORDS = "Keywords";
    public static final String[] META_TYPES = new String[]{"Author", "Contact", "Keywords"};
    public static final String UNKNOWN_TYPE = "Unknown";
    public static final String COLLECTION_TYPE = "Collection";
    public static final String TRACKER_TYPE = "Tracker";
    public static final String EJS_TYPE = "EJS";
    public static final String VIDEO_TYPE = "Video";
    public static final String IMAGE_TYPE = "Image";
    public static final String HTML_TYPE = "HTML";
    public static final String PDF_TYPE = "PDF";
    public static final String DATA_TYPE = "Data";
    public static final String URL_TYPE = "URL";
    protected static final String[] RESOURCE_TYPES = new String[]{"Tracker", "EJS", "Video", "Image", "HTML", "PDF", "Data", "URL", "Unknown"};
    protected static List<String> allResourceTypes = new ArrayList<String>();
    protected static ResizableIcon htmlIcon;
    protected static ResizableIcon videoIcon;
    protected static ResizableIcon trackerIcon;
    protected static ResizableIcon ejsIcon;
    protected static ResizableIcon pdfIcon;
    protected static ResizableIcon unknownIcon;
    protected static ResizableIcon imageIcon;
    protected static ResizableIcon dataIcon;
    protected static ResizableIcon urlIcon;
    protected static ResizableIcon collectionIcon;
    protected static DecimalFormat megabyteFormat;
    protected static Font bodyFont;
    protected static Font h1Font;
    protected static Font h2Font;
    protected static Font h3Font;
    private String name = "";
    private String description = "";
    private String basePath = "";
    private String htmlPath = "";
    protected String target = "";
    private String type = "Unknown";
    protected String displayName;
    private String thumbnail;
    private Map<String, String> properties = new TreeMap<String, String>();
    private TreeSet<Metadata> metadata;
    protected String[][] loaderMetadata;
    protected LibraryCollection parent;
    protected String collectionPath;
    protected List<String> treePath;

    static {
        bodyFont = new JButton().getFont().deriveFont(12.0f);
        h1Font = bodyFont.deriveFont(24.0f);
        h2Font = bodyFont.deriveFont(16.0f);
        h3Font = bodyFont.deriveFont(14.0f);
        allResourceTypes.add(COLLECTION_TYPE);
        String[] stringArray = RESOURCE_TYPES;
        int n = RESOURCE_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            allResourceTypes.add(next);
            ++n2;
        }
        String imageFile = "/org/opensourcephysics/resources/tools/images/html.gif";
        htmlIcon = ResourceLoader.getResizableIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/pdf.gif";
        pdfIcon = ResourceLoader.getResizableIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/video.gif";
        videoIcon = ResourceLoader.getResizableIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/portrait.gif";
        imageIcon = ResourceLoader.getResizableIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/tracker_icon_16.png";
        trackerIcon = ResourceLoader.getResizableIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/ejsicon.gif";
        ejsIcon = ResourceLoader.getResizableIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/data.gif";
        dataIcon = ResourceLoader.getResizableIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/url.gif";
        urlIcon = ResourceLoader.getResizableIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/question_mark.gif";
        unknownIcon = ResourceLoader.getResizableIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/yellowarrowfolder.gif";
        collectionIcon = ResourceLoader.getResizableIcon(imageFile);
        try {
            megabyteFormat = (DecimalFormat)NumberFormat.getInstance();
            megabyteFormat.applyPattern("0.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public LibraryResource(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public boolean setName(String aName) {
        String string = aName = aName == null ? "" : aName.trim();
        if (!aName.equals(this.name)) {
            this.name = aName;
            return true;
        }
        return false;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public boolean setBasePath(String path) {
        String string = path = path == null ? "" : path.trim();
        if (!path.equals(this.basePath)) {
            this.basePath = path;
            return true;
        }
        return false;
    }

    protected String getInheritedBasePath() {
        return !"".equals(this.basePath) ? this.basePath : (this.parent != null ? this.parent.getInheritedBasePath() : "");
    }

    public String getTarget() {
        return "".equals(this.target) ? null : this.target;
    }

    public String getAbsoluteTarget() {
        return "".equals(this.target) ? "" : XML.getResolvedPath(this.target, this.getInheritedBasePath());
    }

    public boolean setTarget(String path) {
        String string = path = path == null ? "" : path.trim();
        if (path.equals(this.target)) {
            return false;
        }
        this.thumbnail = null;
        this.target = path;
        String type = LibraryResource.getTypeFromPath(path, this.getHTMLPath());
        if (!UNKNOWN_TYPE.equals(type)) {
            this.setType(type);
        }
        return true;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    static String getTypeFromPath(String path, String htmlPath) {
        if (path == null) {
            path = "";
        }
        String ext = path.length() >= 4 ? XML.getExtension(path) : (htmlPath == null ? "" : "html");
        String string = ext = ext == null ? "" : ext.toLowerCase();
        if (ext.contains("&trackerset")) {
            ext = "trk";
        }
        switch (ext) {
            case "html": {
                return HTML_TYPE;
            }
            case "trk": 
            case "trz": {
                return TRACKER_TYPE;
            }
            case "zip": {
                return UNKNOWN_TYPE;
            }
            case "pdf": {
                return PDF_TYPE;
            }
            case "ejs": {
                return EJS_TYPE;
            }
            default: {
                ArrayList<VideoType> types = VideoIO.getVideoTypesForPath(ext);
                switch (types.size() == 0 ? "" : types.get(0).getTypeName()) {
                    default: {
                        return UNKNOWN_TYPE;
                    }
                    case "Image": {
                        return IMAGE_TYPE;
                    }
                    case "Xuggle": 
                    case "JS": 
                }
                return VIDEO_TYPE;
            }
            case "": 
        }
        return UNKNOWN_TYPE;
    }

    public String getHTMLPath() {
        return this.htmlPath;
    }

    public boolean setHTMLPath(String path) {
        String string = path = path == null ? "" : path.trim();
        if (!path.equals(this.htmlPath)) {
            this.htmlPath = path;
            if (!(this instanceof LibraryCollection) && this.getTarget() == null) {
                if (path.equals("")) {
                    this.setType(UNKNOWN_TYPE);
                } else {
                    this.setType(HTML_TYPE);
                }
            }
            return true;
        }
        return false;
    }

    private String getAbsoluteHTMLPath() {
        return "".equals(this.htmlPath) ? "" : XML.getResolvedPath(this.htmlPath, this.getInheritedBasePath());
    }

    boolean hasExternalHTML() {
        if (this.getTarget() != null) {
            String s = this.getTarget().toLowerCase();
            String html = this.getHTMLPath();
            if (html.startsWith(String.valueOf(s) + "!")) {
                return false;
            }
        }
        return true;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean setDescription(String desc) {
        String string = desc = desc == null ? "" : desc.trim();
        if (!desc.equals(this.description)) {
            this.description = desc;
            return true;
        }
        return false;
    }

    public String getType() {
        return this.type;
    }

    public boolean setType(String type) {
        if (this.type.equals(type)) {
            return false;
        }
        for (String next : allResourceTypes) {
            if (!next.equals(type)) continue;
            this.type = next;
            return true;
        }
        return false;
    }

    public TreeSet<Metadata> getMetadata() {
        return this.metadata;
    }

    public Metadata getMetadata(String key) {
        if (this.metadata == null) {
            return null;
        }
        for (Metadata next : this.metadata) {
            if (!next.data[0].equals(key)) continue;
            return next;
        }
        return null;
    }

    public void setMetadata(TreeSet<Metadata> data) {
        this.metadata = data;
    }

    public void addMetadata(Metadata data) {
        String key = data.data[0].toLowerCase();
        String[] exclude = new String[]{"generator", "progid", "originator", "referrer", "theme-color", "color-scheme", "viewport", "googlebot", "robots"};
        int i = 0;
        while (i < exclude.length) {
            if (key.equals(exclude[i])) {
                return;
            }
            ++i;
        }
        if (this.metadata == null) {
            this.metadata = new TreeSet();
        }
        String[] stringArray = META_TYPES;
        int n = META_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.toLowerCase().equals(data.getData()[0])) {
                data.getData()[0] = type;
            }
            ++n2;
        }
        this.metadata.add(data);
    }

    public boolean removeMetadata(Metadata data) {
        if (this.metadata == null) {
            this.metadata = new TreeSet();
        }
        Iterator<Metadata> it = this.metadata.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(data)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Icon getIcon() {
        switch (this.type) {
            case "Tracker": {
                return trackerIcon;
            }
            case "EJS": {
                return ejsIcon;
            }
            case "Video": {
                return videoIcon;
            }
            case "Image": {
                return imageIcon;
            }
            case "HTML": {
                return htmlIcon;
            }
            case "PDF": {
                return pdfIcon;
            }
            case "Data": {
                return dataIcon;
            }
            case "URL": {
                return urlIcon;
            }
        }
        return null;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(String imagePath) {
        this.thumbnail = imagePath;
    }

    public String getCollectionPath() {
        if (this.collectionPath != null) {
            return this.collectionPath;
        }
        if (this.parent != null) {
            return this.parent.getCollectionPath();
        }
        return null;
    }

    public String getTitle(String path) {
        String title = this.getName();
        if (title.equals("") && path != null) {
            String fileName = XML.getName(path);
            String basePath = XML.getDirectoryPath(path);
            if (ResourceLoader.isHTTP(basePath)) {
                basePath = basePath.substring(5);
                while (basePath.startsWith("/")) {
                    basePath = basePath.substring(1);
                }
                int i = basePath.indexOf("/");
                if (i > -1) {
                    basePath = basePath.substring(0, i);
                }
                title = String.valueOf(basePath) + ": " + fileName;
            } else {
                title = XML.getName(path);
            }
        }
        this.displayName = title;
        return title;
    }

    public String toString() {
        return this.getDisplayString();
    }

    public String getDisplayString() {
        if (!this.getName().equals("")) {
            return this.getName();
        }
        if (this.displayName != null) {
            return this.displayName;
        }
        if (this.collectionPath != null && this.parent == null) {
            return this.getTitle(this.collectionPath);
        }
        if (this instanceof LibraryCollection) {
            return ToolsRes.getString("LibraryCollection.Name.Default");
        }
        return ToolsRes.getString("LibraryResource.Name.Default");
    }

    @Override
    public int compareTo(LibraryResource resource) {
        int BEFORE = -1;
        int EQUAL = 0;
        int AFTER = 1;
        if (this == resource) {
            return EQUAL;
        }
        int result = this.getName().compareTo(resource.getName());
        if (result != EQUAL) {
            return result;
        }
        String tar1 = this.getAbsoluteTarget();
        String tar2 = resource.getAbsoluteTarget();
        if ((tar1 == null && tar2 == null ? EQUAL : (tar1 == null ? AFTER : (result = tar2 == null ? BEFORE : tar1.compareTo(tar2)))) != EQUAL) {
            return result;
        }
        String html1 = this.getAbsoluteHTMLPath();
        String html2 = resource.getAbsoluteHTMLPath();
        if ((html1 == null && html2 == null ? EQUAL : (html1 == null ? AFTER : (result = html2 == null ? BEFORE : html1.compareTo(html2)))) != EQUAL) {
            return result;
        }
        result = this.getType().compareTo(resource.getType());
        if (result != EQUAL) {
            return result;
        }
        if (this instanceof LibraryCollection && resource instanceof LibraryCollection) {
            LibraryResource[] children2;
            LibraryResource[] children1 = ((LibraryCollection)this).getResources();
            if (children1.length > (children2 = ((LibraryCollection)resource).getResources()).length) {
                return BEFORE;
            }
            if (children1.length < children2.length) {
                return AFTER;
            }
            int i = 0;
            while (i < children1.length) {
                result = children1[i].compareTo(children2[i]);
                if (result != EQUAL) {
                    return result;
                }
                ++i;
            }
        }
        return EQUAL;
    }

    public boolean equals(Object obj) {
        return obj instanceof LibraryResource && this.compareTo((LibraryResource)obj) == 0;
    }

    public LibraryResource getClone() {
        boolean isCollection = this instanceof LibraryCollection;
        LibraryResource resource = isCollection ? new LibraryCollection(this.getName()) : new LibraryResource(this.getName());
        resource.setBasePath(this.getBasePath());
        resource.setTarget(this.getTarget());
        resource.setHTMLPath(this.getHTMLPath());
        resource.setDescription(this.getDescription());
        resource.setType(this.getType());
        for (String string : this.getPropertyNames()) {
            resource.setProperty(string, this.getProperty(string));
        }
        if (this.getMetadata() != null) {
            for (Metadata metadata : this.getMetadata()) {
                resource.addMetadata(new Metadata(metadata.getData()[0], metadata.getData()[1]));
            }
        }
        if (isCollection) {
            LibraryCollection libraryCollection = (LibraryCollection)this;
            LibraryResource[] libraryResourceArray = libraryCollection.getResources();
            int n = libraryResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                LibraryResource next = libraryResourceArray[n2];
                ((LibraryCollection)resource).addResource(next.getClone());
                ++n2;
            }
        }
        resource.collectionPath = this.getCollectionPath();
        resource.treePath = this.getTreePath(null);
        return resource;
    }

    protected List<String> getTreePath(List<String> pathComponents) {
        if (pathComponents == null) {
            pathComponents = new ArrayList<String>();
        }
        if (this.parent != null) {
            this.parent.getTreePath(pathComponents);
        }
        pathComponents.add(this.getDisplayString());
        return pathComponents;
    }

    public static String getHTMLCode(String title, String resourceType, String thumbnailPath, String description, String authors, String contact, String moreInfoURL, Attachment attachment, Map<String, String> data) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        buffer.append("\n  <html>");
        buffer.append("\n    <head>");
        buffer.append("\n" + LibraryResource.getStyleSheetCode());
        buffer.append("\n      <meta http-equiv=\"content-type\" content=\"text/html;charset=iso-8859-1\">");
        if (data != null) {
            for (String name : data.keySet()) {
                String value = data.get(name);
                buffer.append("\n      <meta name=\"" + name + "\" content=\"" + value + "\">");
            }
        }
        if (title != null && !title.equals("")) {
            buffer.append("\n      <title>" + title + "</title>");
        }
        buffer.append("\n    </head>\n");
        buffer.append("\n    <body>");
        buffer.append(LibraryResource.getHTMLBody(title, resourceType, thumbnailPath, description, authors, contact, moreInfoURL, attachment));
        buffer.append("\n    </body>");
        buffer.append("\n  </html>");
        return buffer.toString();
    }

    protected static String getHTMLBody(String title, String resourceType, String thumbnailPath, String description, String authors, String contact, String moreInfoURL, Attachment attachment) {
        StringBuffer buffer = new StringBuffer();
        if (title != null && !title.equals("")) {
            buffer.append("\n      <h2>" + title + "</h2>");
        }
        buffer.append("\n      <blockquote>");
        if (resourceType != null && !resourceType.equals("")) {
            if (allResourceTypes.contains(resourceType)) {
                resourceType = ToolsRes.getString("LibraryResource.Type." + resourceType);
            }
            buffer.append("\n        <b>" + resourceType + "</b>");
        }
        if (thumbnailPath != null && !thumbnailPath.equals("")) {
            thumbnailPath = "<p><img src=\"" + thumbnailPath + "\"";
            if (title != null && !title.equals("")) {
                thumbnailPath = String.valueOf(thumbnailPath) + " alt=\"" + title + "\"";
            }
            buffer.append("\n        " + thumbnailPath + "></p>");
        }
        if (description != null && !description.equals("")) {
            if (!description.startsWith("<p>")) {
                description = "<p>" + LibraryResource.insertLineBreaks(description) + "</p>";
            }
            buffer.append("\n        " + description);
        }
        if (authors != null && !authors.equals("")) {
            String authorTitle = ToolsRes.getString("LibraryTreePanel.Label.Author");
            buffer.append("\n        <p><b>" + authorTitle + ":  </b>" + authors + "</p>");
        }
        if (contact != null && !contact.equals("")) {
            String contactTitle = ToolsRes.getString("LibraryTreePanel.Label.Contact");
            buffer.append("\n        <p><b>" + contactTitle + ":  </b>" + contact + "</p>");
        }
        if (attachment != null && attachment.filename != null) {
            String filename = attachment.filename;
            String resTitle = ToolsRes.getString("LibraryResource.Description.Resource");
            int bytes = attachment.size;
            megabyteFormat.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
            String size = " (" + megabyteFormat.format((double)bytes / 1048576.0) + "MB)";
            buffer.append("\n        <p><b>" + resTitle + ":  </b>" + filename + size + "</p>");
        }
        if (moreInfoURL != null && !moreInfoURL.equals("")) {
            try {
                new URL(moreInfoURL);
                String infoTitle = ToolsRes.getString("LibraryComPADRE.Description.InfoField");
                buffer.append("\n        <p><b>" + infoTitle + "  </b><a href=\"" + moreInfoURL + "\">" + moreInfoURL + "</a></p>");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        buffer.append("\n      </blockquote>");
        return buffer.toString();
    }

    protected static String getBodyStyle() {
        return "body {\n  font-family: Verdana, Arial, Helvetica, sans-serif;\n  font-size: " + bodyFont.getSize() + "pt;\n" + "  color: #405050;\n" + "  background-color: #FFFFFF;\n" + "}\n";
    }

    protected static String getH1Style() {
        return "h1 {\n  font-size: " + h1Font.getSize() + "pt;\n" + "  text-align: center;\n" + "}\n";
    }

    protected static String getH2Style() {
        return "h2 {\n  font-size: " + h2Font.getSize() + "pt;\n" + "}\n";
    }

    protected static String getH3Style() {
        return "h3 {\n  font-size: " + h3Font.getSize() + "pt;\n" + "}\n";
    }

    protected static String getPStyle() {
        return "p, li, h4, h5 {\n  font-family: Verdana, Arial, Helvetica, sans-serif;\n  font-size: " + bodyFont.getSize() + "pt;\n" + "  color: #405050;\n" + "  background-color: #FFFFFF;\n" + "}\n";
    }

    protected static String getHTMLStyles() {
        return String.valueOf(LibraryResource.getBodyStyle()) + LibraryResource.getH1Style() + LibraryResource.getH2Style() + LibraryResource.getH3Style() + LibraryResource.getPStyle();
    }

    protected static String getStyleSheetCode() {
        return "<style TYPE=\"text/css\">\n<!--\n" + LibraryResource.getHTMLStyles() + "-->\n" + "</style>\n";
    }

    protected static String insertLineBreaks(String text) {
        String[] parts = text.split("\n");
        StringBuffer buf = new StringBuffer();
        int last = parts.length - 1;
        int i = 0;
        while (i <= last) {
            String next = parts[i];
            buf.append(next);
            if (i < last) {
                buf.append("<br>");
            }
            ++i;
        }
        return buf.toString();
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Attachment {
        Node node;
        String type;
        String url;
        String filename;
        int size;

        Attachment(Node node, String type, String url, String filename, int size) {
            this.node = node;
            this.type = type;
            this.url = url;
            this.filename = filename;
            this.size = size;
        }

        public String toString() {
            return "[Attachment " + this.node + " " + this.type + " " + this.url + " " + this.filename + " " + this.size + "]";
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            LibraryResource res = (LibraryResource)obj;
            control.setValue("name", res.name);
            if (!"".equals(res.description)) {
                control.setValue("description", res.description);
            }
            if (!"".equals(res.htmlPath) && res.hasExternalHTML()) {
                control.setValue("html_path", res.htmlPath);
            }
            if (!"".equals(res.basePath)) {
                control.setValue("base_path", res.basePath);
            }
            if (!"".equals(res.target)) {
                control.setValue("target", res.getTarget());
            }
            if (!LibraryResource.UNKNOWN_TYPE.equals(res.type)) {
                control.setValue("type", res.type);
            }
            if (res.metadata != null && res.metadata.size() > 0) {
                int len = res.metadata.size();
                String[][] data = new String[len][];
                int i = 0;
                for (Metadata next : res.metadata) {
                    data[i] = next.data;
                    ++i;
                }
                control.setValue("metadata", data);
            }
            if (!res.getPropertyNames().isEmpty()) {
                ArrayList<String[]> props = new ArrayList<String[]>();
                for (String name : res.getPropertyNames()) {
                    props.add(new String[]{name, res.getProperty(name)});
                }
                control.setValue("properties", props.toArray((T[])new String[props.size()][2]));
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            String name = control.getString("name");
            return new LibraryResource(name);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            String[][] props;
            String[] next;
            LibraryResource res = (LibraryResource)obj;
            res.setDescription(control.getString("description"));
            res.setBasePath(control.getString("base_path"));
            String target = control.getString("target");
            if (target != null) {
                res.target = target;
            }
            res.setHTMLPath(control.getString("html_path"));
            res.setType(control.getString("type"));
            String[][] data = (String[][])control.getObject("metadata");
            if (data != null) {
                res.loaderMetadata = data;
                if (res.getMetadata() != null) {
                    res.getMetadata().clear();
                }
                int i = 0;
                while (i < data.length) {
                    next = data[i];
                    res.addMetadata(new Metadata(next[0], next[1]));
                    ++i;
                }
            }
            if ((props = (String[][])control.getObject("properties")) != null) {
                String[][] stringArray = props;
                int n = props.length;
                int n2 = 0;
                while (n2 < n) {
                    next = stringArray[n2];
                    res.setProperty(next[0], next[1]);
                    ++n2;
                }
            }
            return res;
        }
    }

    protected static class Metadata
    implements Comparable<Metadata> {
        private String[] data;

        public Metadata() {
            this.data = new String[]{"", ""};
        }

        public Metadata(String key, String value) {
            key = key == null ? "" : key;
            value = value == null ? "" : value;
            this.data = new String[]{key, value};
        }

        public String[] getData() {
            return this.data;
        }

        public void clearData() {
            this.data[0] = "";
            this.data[1] = "";
        }

        @Override
        public int compareTo(Metadata meta) {
            int result = this.data[0].compareTo(meta.data[0]);
            return result == 0 ? this.data[1].compareTo(meta.data[1]) : result;
        }

        public String toString() {
            return String.valueOf(this.data[0]) + ": " + this.data[1];
        }
    }
}

