/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.function.Function;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.mov.MovieFactory;
import org.opensourcephysics.tools.LibraryBrowser;
import org.opensourcephysics.tools.LibraryCollection;
import org.opensourcephysics.tools.LibraryResource;
import org.opensourcephysics.tools.LibraryTreePanel;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

public class LibraryTreeNode
extends DefaultMutableTreeNode
implements Comparable<LibraryTreeNode> {
    protected static HashMap<String, URL> htmlURLs = new HashMap();
    protected static HashMap<String, URL> targetURLs = new HashMap();
    protected static Dimension defaultThumbnailDimension = new Dimension(320, 240);
    protected LibraryResource record;
    protected boolean editable = true;
    protected LibraryTreePanel treePanel;
    protected ArrayList<LibraryResource> resources = new ArrayList();
    protected String tooltip;
    protected LibraryResource.Metadata selectedMetadata;
    protected String metadataSource;

    protected LibraryTreeNode(LibraryResource resource, LibraryTreePanel treePanel) {
        this.record = resource;
        this.treePanel = treePanel;
        if (treePanel.tree != null) {
            this.createChildNodes();
        }
        this.setUserObject(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LibraryTreeNode treeNode = (LibraryTreeNode)obj;
        String target1 = this.getAbsoluteTarget();
        String target2 = treeNode.getAbsoluteTarget();
        String html1 = this.getHTMLPath();
        String html2 = treeNode.getHTMLPath();
        return (target1 == null && target2 == null || target1 != null && target2 != null && target1.equals(target2)) && (html1 == null && html2 == null || html1 != null && html2 != null && html1.equals(html2)) && treeNode.getName().equals(this.getName());
    }

    @Override
    public int compareTo(LibraryTreeNode node) {
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == node || this.equals(node)) {
            return 0;
        }
        int result = this.getName().compareTo(node.getName());
        if (result != 0) {
            return result;
        }
        String tar1 = this.getAbsoluteTarget();
        String tar2 = node.getAbsoluteTarget();
        if (tar1 != null || tar2 != null) {
            if (tar1 == null) {
                return 1;
            }
            if (tar2 == null) {
                return -1;
            }
            result = tar1.compareTo(tar2);
        }
        if (result != 0) {
            return result;
        }
        String html1 = this.getHTMLPath();
        String html2 = node.getHTMLPath();
        if (html1 != null || html2 != null) {
            if (html1 == null) {
                return 1;
            }
            if (html2 == null) {
                return -1;
            }
            return html1.compareTo(html2);
        }
        return 0;
    }

    protected boolean createChildNodes() {
        ArrayList<String> children = new ArrayList<String>();
        int i = 0;
        while (i < this.getChildCount()) {
            children.add(this.getChildAt(i).toString());
            ++i;
        }
        boolean changed = false;
        if (this.record instanceof LibraryCollection) {
            LibraryCollection collection = (LibraryCollection)this.record;
            LibraryResource[] libraryResourceArray = collection.getResources();
            int n = libraryResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                LibraryTreeNode newNode;
                String name;
                LibraryResource next = libraryResourceArray[n2];
                String string = name = next == null ? "" : next.getName();
                if ("".equals(name)) {
                    name = ToolsRes.getString("LibraryResource.Name.Default");
                }
                if (next != null && !children.contains(name) && this.treePanel.insertChildAt(newNode = new LibraryTreeNode(next, this.treePanel), this, this.getChildCount())) {
                    changed = true;
                }
                ++n2;
            }
        }
        if (changed) {
            this.treePanel.setChanged();
        }
        return changed;
    }

    protected String getName() {
        return this.record.getName();
    }

    protected String getBasePath() {
        String base = this.record.getBasePath();
        if (!base.equals("")) {
            return base;
        }
        LibraryTreeNode parent = (LibraryTreeNode)this.getParent();
        if (parent != null) {
            return parent.getBasePath();
        }
        if (this.treePanel != null) {
            return XML.getDirectoryPath(this.treePanel.pathToRoot);
        }
        return "";
    }

    protected String getHTMLPath() {
        String path = this.record.getHTMLPath();
        if (path != null && !path.trim().equals("")) {
            path = XML.getResolvedPath(path, this.getBasePath());
            return path;
        }
        return null;
    }

    protected URL getHTMLURL() {
        String path = this.getHTMLPath();
        if (path == null) {
            return null;
        }
        URL url = null;
        File cachedFile = null;
        boolean foundInCache = false;
        cachedFile = ResourceLoader.getOSPCacheFile(path);
        foundInCache = cachedFile.exists();
        if (htmlURLs.keySet().contains(path)) {
            url = htmlURLs.get(path);
        } else {
            boolean loadable;
            String workingPath = path;
            if (foundInCache) {
                workingPath = cachedFile.toURI().toString();
            }
            Resource res = null;
            boolean bl = loadable = ResourceLoader.isWebConnected() || !ResourceLoader.isHTTP(workingPath);
            if (loadable) {
                res = ResourceLoader.getResourceZipURLsOK(workingPath);
            }
            if (res != null) {
                url = res.getURL();
            } else {
                workingPath = ResourceLoader.getURIPath(workingPath);
                if (loadable) {
                    res = ResourceLoader.getResourceZipURLsOK(workingPath);
                }
                if (res != null) {
                    url = res.getURL();
                }
            }
        }
        htmlURLs.put(path, url);
        return url;
    }

    /*
     * Unable to fully structure code
     */
    protected String getHTMLString() {
        if (!this.record.getDescription().equals("")) {
            return this.record.getDescription();
        }
        target = this.record.getTarget();
        rtype = this.record.getType();
        isImage = rtype.equals("Image") != false && target != null;
        isVideo = rtype.equals("Video") != false && target != null;
        isThumbnailType = isVideo != false || isImage != false || ResourceLoader.isJarZipTrz(target, false) != false;
        thumb = null;
        if (isThumbnailType) {
            thumb = this.record.getThumbnail();
            if (thumb != null && !this.getThumbnailFile().exists()) {
                thumb = null;
            }
            if (thumb == null && OSPRuntime.doCacheThumbnail) {
                source = this.getAbsoluteTarget();
                thumbFile = this.getThumbnailFile();
                if (thumbFile.exists()) {
                    thumb = thumbFile.getAbsolutePath();
                    this.record.setThumbnail(thumb);
                } else {
                    new ThumbnailLoader(source, thumbFile.getAbsolutePath(), "LibraryTreeNode.getHTMLString").runMe();
                }
            }
            if (thumb != null) {
                thumb = XML.getResolvedPath(thumb, this.record.getInheritedBasePath());
                thumb = XML.forwardSlash(thumb);
                thumb = ResourceLoader.getURIPath(thumb);
            }
        }
        buffer = new StringBuffer();
        collection = " " + ToolsRes.getString("LibraryResource.Type.Collection.Description");
        title = this.record.getName();
        if ("".equals(title) && this.isRoot()) {
            title = this.record.getTitle(this.treePanel.pathToRoot);
        }
        var11_10 = LibraryResource.allResourceTypes.iterator();
        block9: while (var11_10.hasNext()) {
            var13_13 = type = var11_10.next();
            tmp = -1;
            switch (var13_13.hashCode()) {
                case 79058: {
                    if (var13_13.equals("PDF")) {
                        tmp = 1;
                    }
                    break;
                }
                case 2228139: {
                    if (var13_13.equals("HTML")) {
                        tmp = 2;
                    }
                    break;
                }
                case 1379812394: {
                    if (var13_13.equals("Unknown")) {
                        tmp = 1;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 2: {
                    type = "Other";
                    types = new String[]{"HTML", "PDF", "Unknown"};
                    ** GOTO lbl59
                }
                default: {
                    types = new String[]{type};
lbl59:
                    // 2 sources

                    children = this.getChildResources(types);
                    if (children.isEmpty()) continue block9;
                    s = "LibraryResource.Type." + type + ".List";
                    buffer.append("<p>" + ToolsRes.getString(s) + " " + title + collection + ":</p>\n");
                    buffer.append("<ol>\n");
                    for (LibraryResource next : children) {
                        name = next.getName();
                        if (name.equals("")) {
                            name = ToolsRes.getString("LibraryResource.Name.Default");
                        }
                        buffer.append("<li>" + name + "</li>\n");
                    }
                    buffer.append("</ol>\n");
                }
                case 1: 
            }
        }
        description = buffer.toString();
        htmlCode = LibraryResource.getHTMLBody(title, this.record.getType(), thumb, description, null, null, null, null);
        return htmlCode;
    }

    protected String getTarget() {
        return this.record.getTarget();
    }

    protected String getAbsoluteTarget() {
        String target = this.getTarget();
        if (target == null) {
            return null;
        }
        if (LibraryBrowser.isPopulatedCollection(this)) {
            return String.valueOf(this.getBasePath()) + target;
        }
        return XML.getResolvedPath(target, this.getBasePath());
    }

    protected URL getTargetURL() {
        String path = this.getAbsoluteTarget();
        if (path == null) {
            return null;
        }
        String workingPath = path;
        URL url = null;
        String filename = this.record.getProperty("download_filename");
        File cachedFile = ResourceLoader.getOSPCacheFile(path, filename);
        boolean foundInCache = cachedFile.exists();
        if (foundInCache) {
            workingPath = ResourceLoader.getURIPath(cachedFile.getAbsolutePath());
        }
        if (targetURLs.keySet().contains(path)) {
            url = targetURLs.get(path);
        } else if (OSPRuntime.isJS) {
            try {
                url = new URL(path);
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            Resource res = ResourceLoader.getResourceZipURLsOK(workingPath);
            if (res != null) {
                url = res.getURL();
            } else {
                res = ResourceLoader.getResourceZipURLsOK(workingPath = ResourceLoader.getURIPath(workingPath));
                if (res != null) {
                    url = res.getURL();
                }
            }
        }
        targetURLs.put(path, url);
        return url;
    }

    @Override
    public String toString() {
        return this.record.toString();
    }

    public String getDisplayString() {
        return this.record.getDisplayString();
    }

    protected boolean isEditable() {
        if (this.isRoot()) {
            return this.editable;
        }
        LibraryTreeNode parent = (LibraryTreeNode)this.getParent();
        return this.editable && parent.isEditable();
    }

    protected void setEditable(boolean edit) {
        this.editable = edit;
    }

    protected void setName(String name) {
        if (this.record.setName(name)) {
            this.treePanel.tree.getModel().valueForPathChanged(this.getTreePath(), name);
            this.treePanel.showInfo(this, "LibraryTreeNode.setName " + name);
            this.treePanel.setChanged();
        }
    }

    public TreePath getTreePath() {
        return new TreePath(this.getPath());
    }

    protected boolean setTarget(String path) {
        if (this.record.setTarget(path)) {
            String type = LibraryResource.getTypeFromPath(path, this.getHTMLPath());
            if (!"Unknown".equals(type)) {
                this.setType(type);
            }
            LibraryTreePanel.htmlPanesByNode.remove(this);
            this.record.setThumbnail(null);
            this.treePanel.showInfo(this, "LibraryTreeNode.setTarget " + path);
            this.treePanel.setChanged();
            this.tooltip = null;
            return true;
        }
        return false;
    }

    protected void setHTMLPath(String path) {
        if (this.record.setHTMLPath(path)) {
            this.treePanel.showInfo(this, "LibraryTreeNode.setHTMLPath " + path);
            this.treePanel.setChanged();
            this.tooltip = null;
        }
    }

    protected void setBasePath(String path) {
        if (this.record.setBasePath(path)) {
            LibraryTreePanel.htmlPanesByNode.remove(this);
            this.record.setThumbnail(null);
            this.treePanel.showInfo(this, "LibraryTreeNode.setBasePath " + path);
            this.treePanel.setChanged();
        }
    }

    protected void setType(String type) {
        if (this.record.setType(type)) {
            LibraryTreePanel.htmlPanesByNode.remove(this);
            this.treePanel.showInfo(this, "LibraryTreeNode.setType");
            this.treePanel.setChanged();
            this.tooltip = null;
        }
    }

    protected ArrayList<LibraryResource> getChildResources(String[] types) {
        this.resources.clear();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            int i = 0;
            while (i < this.getChildCount()) {
                LibraryTreeNode child = (LibraryTreeNode)this.getChildAt(i);
                if (child.record.getType().equals(type)) {
                    this.resources.add(child.record);
                }
                ++i;
            }
            ++n2;
        }
        return this.resources;
    }

    public String getToolTip() {
        if (this.tooltip == null) {
            TreeSet<LibraryResource.Metadata> data;
            StringBuffer buf = new StringBuffer();
            if (this.record.getType().equals("Collection") && this.isRoot() && !"".equals(this.treePanel.pathToRoot)) {
                buf.append(String.valueOf(ToolsRes.getString("LibraryTreeNode.Tooltip.CollectionPath")) + ": " + this.treePanel.pathToRoot);
            }
            if ((data = this.record.getMetadata()) != null) {
                for (LibraryResource.Metadata next : data) {
                    String key = next.getData()[0];
                    String value = next.getData()[1];
                    boolean breakLine = false;
                    String[] stringArray = LibraryResource.META_TYPES;
                    int n = LibraryResource.META_TYPES.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String metadataType = stringArray[n2];
                        if (metadataType.toLowerCase().contains(key.toLowerCase())) {
                            key = ToolsRes.getString("LibraryTreePanel.Label." + metadataType);
                        }
                        ++n2;
                    }
                    if (breakLine && value.length() > 100) {
                        int len = key.length();
                        String space = "";
                        int i = 0;
                        while (i < len) {
                            space = String.valueOf(space) + "  ";
                            ++i;
                        }
                        StringBuffer b = new StringBuffer();
                        String line = value.substring(0, 80);
                        String remainder = value.substring(80);
                        while (true) {
                            String[] parts = remainder.split(" ", 2);
                            b.append(String.valueOf(line) + parts[0]);
                            if (parts.length == 1) break;
                            if (parts[1].length() < 100) {
                                b.append("\n" + space + parts[1]);
                                break;
                            }
                            b.append("\n" + space);
                            line = parts[1].substring(0, 80);
                            remainder = parts[1].substring(80);
                        }
                        value = b.toString();
                    }
                    if (buf.length() > 0) {
                        buf.append(" | ");
                    }
                    buf.append(String.valueOf(key) + ": " + value);
                }
            }
            this.tooltip = buf.toString();
        }
        return this.tooltip.length() > 0 ? this.tooltip : ToolsRes.getString("LibraryTreeNode.Tooltip.None");
    }

    protected String getMetadataSource() {
        return this.metadataSource != null ? this.metadataSource : this.getHTMLPath();
    }

    protected TreeSet<LibraryResource.Metadata> getMetadata() {
        TreeSet<LibraryResource.Metadata> metaData = this.record.getMetadata();
        if (metaData == null) {
            String metaSource;
            metaData = new TreeSet();
            this.record.setMetadata(metaData);
            if (this.record.loaderMetadata != null) {
                int i = 0;
                while (i < this.record.loaderMetadata.length) {
                    String[] next = this.record.loaderMetadata[i];
                    this.record.addMetadata(new LibraryResource.Metadata(next[0], next[1]));
                    ++i;
                }
            }
            if ((metaSource = this.getMetadataSource()) != null) {
                String code = metaSource;
                if (!code.contains("<html")) {
                    Resource res = ResourceLoader.getResourceZipURLsOK(metaSource);
                    String string = code = res == null ? code : res.getString();
                }
                if (code != null && code.contains("<html")) {
                    boolean[] isStandardType = new boolean[LibraryResource.META_TYPES.length];
                    ArrayList<String[]> metaList = LibraryBrowser.getMetadataFromHTML(code);
                    int i = 0;
                    while (i < metaList.size()) {
                        String[] next = metaList.get(i);
                        String name = next[0];
                        int k = 0;
                        while (k < LibraryResource.META_TYPES.length) {
                            if (!isStandardType[k] && LibraryResource.META_TYPES[k].toLowerCase().contains(name.toLowerCase())) {
                                name = LibraryResource.META_TYPES[k];
                                isStandardType[k] = true;
                            }
                            ++k;
                        }
                        this.record.addMetadata(new LibraryResource.Metadata(name, next[1]));
                        ++i;
                    }
                }
            }
            this.tooltip = null;
        }
        return metaData;
    }

    protected String getMetadataValue(String key) {
        TreeSet<LibraryResource.Metadata> searchData = this.record.getMetadata();
        if (searchData != null) {
            for (LibraryResource.Metadata next : searchData) {
                if (next.getData()[0].indexOf(key) <= -1) continue;
                return next.getData()[1];
            }
        }
        return null;
    }

    protected File getThumbnailFile() {
        String thumbPath = this.record.getThumbnail();
        if (thumbPath != null) {
            return new File(thumbPath);
        }
        String path = this.getAbsoluteTarget();
        String name = XML.stripExtension(XML.getName(path));
        String fileName = String.valueOf(name) + "_thumbnail.png";
        return ResourceLoader.getOSPCacheFile(path, fileName);
    }

    protected File createThumbnailFile(BufferedImage image, String path, Dimension maxSize) {
        double widthFactor = maxSize.getWidth() / (double)image.getWidth();
        double heightFactor = maxSize.getHeight() / (double)image.getHeight();
        double factor = Math.min(widthFactor, heightFactor);
        int w = (int)((double)image.getWidth() * factor);
        int h = (int)((double)image.getHeight() * factor);
        BufferedImage thumbnailImage = new BufferedImage(w, h, 5);
        Graphics2D g = thumbnailImage.createGraphics();
        AffineTransform transform = AffineTransform.getScaleInstance(factor, factor);
        g.setTransform(transform);
        g.drawImage((Image)image, 0, 0, null);
        return VideoIO.writeImageFile(thumbnailImage, path);
    }

    class ThumbnailLoader
    extends SwingWorker<File, Object> {
        String thumbPath;
        String sourcePath;
        File thumbFile;

        ThumbnailLoader(String imageSource, String thumbnailPath, String source) {
            this.thumbPath = thumbnailPath;
            this.sourcePath = imageSource;
        }

        @Override
        public File doInBackground() {
            this.runMe();
            return null;
        }

        public void runMe() {
            String extx = XML.getExtension(this.sourcePath);
            switch (extx = extx == null ? "" : extx.toLowerCase()) {
                case "trz": 
                case "zip": {
                    final File thumbFile = new File(this.thumbPath);
                    if (OSPRuntime.isJS) {
                        LibraryTreeNode.this.record.setThumbnail(thumbFile.getAbsolutePath());
                    } else {
                        ResourceLoader.getZipEntryBytesAsync(String.valueOf(this.sourcePath) + "!/*_thumbnail", thumbFile, new Function<byte[], Void>(){

                            @Override
                            public Void apply(byte[] bytes) {
                                if (bytes == null) {
                                    OSPLog.fine("failed to create thumbnail for " + ThumbnailLoader.this.thumbPath);
                                }
                                ThumbnailLoader.this.doneAsync(bytes == null ? null : thumbFile);
                                return null;
                            }
                        });
                    }
                    return;
                }
                default: {
                    this.doneAsync(MovieFactory.createThumbnailFile(defaultThumbnailDimension, this.sourcePath, this.thumbPath));
                    return;
                }
                case "gif": {
                    boolean status = false;
                    if (!status) break;
                    OSPLog.fine("failed to create thumbnail for GIF " + this.thumbPath);
                    this.doneAsync(null);
                    return;
                }
                case "jpg": 
                case "png": 
                case "jpeg": 
            }
            ResourceLoader.copyURLtoFileAsync(this.sourcePath, this.thumbPath, t -> {
                this.doneAsync((File)t);
                return null;
            });
        }

        protected void doneAsync(File thumbFile) {
            SwingUtilities.invokeLater(() -> {
                try {
                    LibraryTreeNode.this.record.setThumbnail(thumbFile == null || !thumbFile.exists() ? null : thumbFile.getAbsolutePath());
                    if (LibraryTreeNode.this.record.getThumbnail() != null) {
                        LibraryTreePanel.htmlPanesByNode.remove(LibraryTreeNode.this);
                        LibraryTreeNode.this.treePanel.showInfo(LibraryTreeNode.this.treePanel.getSelectedNode(), "LibraryTreeNode.ThumbnailDone");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }

        @Override
        protected void done() {
        }
    }
}

