/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javajs.async.AsyncDialog;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.JMultiLineToolTip;
import org.opensourcephysics.tools.LibraryBrowser;
import org.opensourcephysics.tools.LibraryCollection;
import org.opensourcephysics.tools.LibraryComPADRE;
import org.opensourcephysics.tools.LibraryResource;
import org.opensourcephysics.tools.LibraryTreeNode;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

public class LibraryTreePanel
extends JPanel {
    protected final String AND = " AND ";
    protected final String OR = " OR ";
    protected final String OPENING = "(";
    protected final String CLOSING = ")";
    protected static int keyFieldWidth = 100;
    protected static Color lightRed = new Color(255, 180, 200);
    protected static Color darkRed = new Color(220, 0, 0);
    protected static Color lightGreen = new Color(100, 200, 100);
    protected static Color defaultForeground;
    protected static Icon openFileIcon;
    protected static HyperlinkListener hyperlinkListener;
    protected static JFileChooser chooser;
    protected static FileFilter htmlFilter;
    protected static FileFilter folderFilter;
    protected static HashMap<URL, HTMLPane> htmlPanesByURL;
    protected static HashMap<LibraryTreeNode, HTMLPane> htmlPanesByNode;
    protected LibraryBrowser browser;
    protected LibraryResource rootResource;
    protected String pathToRoot;
    protected LibraryTreeNode rootNode;
    protected DefaultTreeModel treeModel;
    protected LibraryTreeNodeRenderer treeNodeRenderer;
    protected JTree tree;
    protected JScrollPane treeScroller = new JScrollPane();
    protected JScrollPane htmlScroller = new JScrollPane();
    protected JToolBar editorbar;
    protected Action cutAction;
    protected Action copyAction;
    protected Action pasteAction;
    protected Action addCollectionAction;
    protected Action addResourceAction;
    protected Action moveUpAction;
    protected Action moveDownAction;
    protected Action metadataAction;
    protected JButton cutButton;
    protected JButton copyButton;
    protected JButton pasteButton;
    protected JButton addCollectionButton;
    protected JButton addResourceButton;
    protected JButton moveUpButton;
    protected JButton moveDownButton;
    protected JButton metadataButton;
    protected Box editorPanel;
    protected Box fileBox;
    protected JPanel displayPanel;
    protected HTMLPane emptyHTMLPane;
    protected JSplitPane splitPane;
    protected EntryField nameField;
    protected EntryField htmlField;
    protected EntryField basePathField;
    protected EntryField targetField;
    protected JLabel nameLabel;
    protected JLabel htmlLabel;
    protected JLabel basePathLabel;
    protected JLabel targetLabel;
    protected ActionListener metadataFieldListener;
    protected EntryField authorField;
    protected EntryField contactField;
    protected EntryField keywordsField;
    protected JLabel authorLabel;
    protected JLabel contactLabel;
    protected JLabel keywordsLabel;
    protected JLabel metadataLabel;
    protected Box authorBox;
    protected Box contactBox;
    protected Box keywordsBox;
    protected Box metadataBox;
    protected MetadataComboBoxModel metadataModel;
    protected JComboBox<LibraryResource.Metadata> metadataDropdown;
    protected MetadataEditField keyEditField;
    protected MetadataEditField valueEditField;
    protected JLabel typeLabel;
    protected JLabel typeField;
    protected JButton openHTMLButton;
    protected JButton openBasePathButton;
    protected JButton openFileButton;
    protected ArrayList<JLabel> labels = new ArrayList();
    protected JPopupMenu popup;
    protected MouseAdapter treeMouseListener;
    protected MouseAdapter convertPathMouseListener;
    protected TreeSelectionListener treeSelectionListener;
    protected XMLControl pasteControl;
    protected boolean isEditing;
    protected boolean isChanged;
    protected boolean isXMLPath;
    protected boolean ignoreChanges;
    protected boolean launchLater;
    protected XMLControl revertControl;
    protected int typeFieldWidth;
    protected String command;
    protected TreePath prevTreePath;
    protected LibraryResource.Metadata emptyMetadata = new LibraryResource.Metadata();
    protected MetadataLoader metadataLoader;
    protected Set<EntryField> entryFields = new HashSet<EntryField>();
    private int myFontLevel;
    private Boolean clipboardAvailable;

    static {
        htmlPanesByURL = new HashMap();
        htmlPanesByNode = new HashMap();
        openFileIcon = ResourceLoader.getImageIcon("resources/tools/images/open.gif");
        hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    OSPDesktop.displayURL(e.getURL().toString());
                }
            }
        };
    }

    public LibraryTreePanel(LibraryBrowser browser) {
        super(new BorderLayout());
        this.browser = browser;
        this.createGUI();
    }

    public void setRootResource(LibraryResource resource, String path, boolean editable, boolean pathIsXML) {
        this.rootResource = resource;
        this.isXMLPath = pathIsXML;
        this.pathToRoot = path;
        if (this.tree != null) {
            this.tree.removeTreeSelectionListener(this.treeSelectionListener);
            this.tree.removeMouseListener(this.treeMouseListener);
        }
        this.setEditing(false);
        if (resource != null) {
            this.ignoreChanges = true;
            this.rootNode = new LibraryTreeNode(resource, this);
            this.rootNode.setEditable(editable);
            this.createTree(this.rootNode);
            this.tree.setSelectionRow(0);
            this.splitPane.setDividerLocation(this.treeScroller.getPreferredSize().width);
            this.isChanged = false;
            this.ignoreChanges = false;
            this.refreshGUI(false);
            FontSizer.setFonts(this.tree);
        }
    }

    public LibraryResource getCollection() {
        return this.rootResource;
    }

    public LibraryTreeNode getSelectedNode() {
        return this.tree == null ? null : (LibraryTreeNode)this.tree.getLastSelectedPathComponent();
    }

    protected void setSelectedNode(LibraryTreeNode node) {
        this.tree.setSelectionPath(node == null ? null : node.getTreePath());
    }

    protected void setSelectionPath(List<String> treePath) {
        if (treePath != null && treePath.get(0).equals(this.rootNode.toString())) {
            LibraryTreeNode node = this.rootNode;
            int i = 1;
            while (i < treePath.size()) {
                String name = treePath.get(i);
                int n = node.getChildCount();
                int j = 0;
                while (j < n) {
                    if (name.equals(node.getChildAt(j).toString())) {
                        node = (LibraryTreeNode)node.getChildAt(j);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            this.setSelectedNode(node);
        }
    }

    protected void setFontLevel(int level) {
        if (this.myFontLevel == level) {
            return;
        }
        this.myFontLevel = level;
        Object[] toSize = new Object[]{this.splitPane, this.editorPanel, this.editorbar, this.authorField, this.contactField, this.keywordsField, this.authorLabel, this.contactLabel, this.keywordsLabel, this.metadataLabel, this.metadataDropdown};
        FontSizer.setFonts(toSize, level);
        EntryField.font = this.authorField.getFont();
        TreeModel model = this.tree.getModel();
        if (model instanceof DefaultTreeModel) {
            LibraryTreeNode selectedNode = this.getSelectedNode();
            DefaultTreeModel treeModel = (DefaultTreeModel)model;
            treeModel.nodeStructureChanged(this.rootNode);
            this.setSelectedNode(selectedNode);
        }
        this.refreshGUI(false);
    }

    protected void setEditing(boolean edit) {
        this.isEditing = edit;
        if (this.isEditing) {
            this.refreshGUI(true);
            this.displayPanel.add((Component)this.editorPanel, "North");
            this.add((Component)this.editorbar, "North");
            this.showInfo(this.getSelectedNode(), "LibraryTreePanel.setEditing");
        } else {
            this.displayPanel.remove(this.editorPanel);
            this.remove(this.editorbar);
        }
        this.validate();
        if (this.isEditing) {
            this.revertControl = new XMLControlElement(this.rootResource);
        }
    }

    protected boolean isEditable() {
        boolean editable;
        boolean bl = editable = this.rootNode != null && this.rootNode.isEditable();
        if (editable && !ResourceLoader.isHTTP(this.pathToRoot)) {
            File file = new File(this.pathToRoot);
            editable = !file.exists() || file.canWrite();
        }
        return editable;
    }

    protected boolean isEditing() {
        return this.isEditing;
    }

    protected void showInfo(LibraryTreeNode node, String why) {
        if (node == null) {
            this.initGUI();
            return;
        }
        boolean isCollection = node.record instanceof LibraryCollection;
        boolean isRoot = node.isRoot();
        String path = isRoot ? this.pathToRoot : node.getAbsoluteTarget();
        LibraryTreePanel selected = this.browser.getSelectedTreePanel();
        this.showHTMLPane(node);
        if (selected == this && !this.browser.commandField.getText().equals(path)) {
            this.setCommandField(node, path, isCollection);
        }
        if (this.isEditing()) {
            this.showEditorData(node, isCollection);
        }
        this.tree.expandPath(node.getTreePath());
    }

    private void initGUI() {
        this.htmlScroller.setViewportView(this.emptyHTMLPane);
        this.nameField.setText(null);
        this.typeField.setText(" ");
        this.basePathField.setText(null);
        this.htmlField.setText(null);
        this.targetField.setText(null);
        this.nameField.setBackground(Color.white);
        this.basePathField.setBackground(Color.white);
        this.htmlField.setBackground(Color.white);
        this.targetField.setBackground(Color.white);
        this.nameField.setEnabled(false);
        this.basePathField.setEnabled(false);
        this.htmlField.setEnabled(false);
        this.targetField.setEnabled(false);
        this.typeField.setEnabled(false);
        this.nameLabel.setEnabled(false);
        this.htmlLabel.setEnabled(false);
        this.basePathLabel.setEnabled(false);
        this.targetLabel.setEnabled(false);
        this.typeLabel.setEnabled(false);
        this.openHTMLButton.setEnabled(false);
        this.openBasePathButton.setEnabled(false);
        this.openFileButton.setEnabled(false);
    }

    private void setCommandField(LibraryTreeNode node, String path, boolean isCollection) {
        this.browser.commandField.setText(path);
        boolean available = node.isRoot();
        if (path != null && !available) {
            if (ResourceLoader.isHTTP(path)) {
                String uriPath = ResourceLoader.getURIPath(path);
                available = ResourceLoader.isURLAvailable(uriPath);
                if (!available) {
                    available = (isCollection ? ResourceLoader.getSearchCacheFile(path) : ResourceLoader.getOSPCacheFile(path, node.record.getProperty("download_filename"))).exists();
                }
            } else {
                available = ResourceLoader.getResourceZipURLsOK(ResourceLoader.getURIPath(path)) != null;
            }
        }
        this.browser.commandField.setForeground(available ? defaultForeground : darkRed);
        this.browser.commandField.setCaretPosition(0);
        if (node.isRoot()) {
            this.browser.openButton.setEnabled(false);
        } else if (available) {
            this.browser.flashOpen();
        }
    }

    private void showEditorData(LibraryTreeNode node, boolean isCollection) {
        String keys;
        String contact;
        String base;
        if (!this.nameField.getText().equals(node.getName())) {
            this.nameField.setText(node.getName());
            this.nameField.setCaretPosition(0);
        }
        String string = base = this.basePathField.hasFocus() ? node.record.getBasePath() : node.getBasePath();
        if (!this.basePathField.getText().equals(base)) {
            this.basePathField.setText(base);
            this.basePathField.setCaretPosition(0);
        }
        if (!this.htmlField.getText().equals(node.record.getHTMLPath())) {
            this.htmlField.setText(node.record.hasExternalHTML() ? node.record.getHTMLPath() : null);
            this.htmlField.setCaretPosition(0);
        }
        boolean isValidHTML = true;
        if (!"".equals(node.record.getHTMLPath())) {
            isValidHTML = node.getHTMLURL() != null;
        }
        this.htmlField.setForeground(isValidHTML ? defaultForeground : darkRed);
        this.htmlField.setBackground(Color.white);
        if (!this.targetField.getText().equals(node.getTarget())) {
            this.targetField.setText(node.getTarget());
            this.targetField.setCaretPosition(0);
        }
        boolean isValidTarget = true;
        if (node.getTarget() != null) {
            String fullTarget;
            int n;
            boolean bl = isValidTarget = node.getTargetURL() != null;
            if (!isValidTarget && "EJS".equals(node.record.getType()) && (n = (fullTarget = node.getTarget()).indexOf("&name=")) > 0) {
                node.record.setTarget(fullTarget.substring(0, n));
                isValidTarget = node.getTargetURL() != null;
                node.record.setTarget(fullTarget);
            }
        }
        this.targetField.setForeground(isValidTarget ? defaultForeground : darkRed);
        this.targetField.setBackground(Color.white);
        String type = node.record.getType();
        type = ToolsRes.getString("LibraryResource.Type." + type);
        this.typeField.setText(type);
        boolean hasBasePath = !"".equals(node.record.getBasePath());
        boolean hasChildren = node.children().hasMoreElements();
        this.nameField.setEnabled(true);
        this.basePathField.setEnabled(true);
        this.htmlField.setEnabled(true);
        this.typeField.setEnabled(true);
        this.targetField.setEnabled(!isCollection || !hasChildren);
        this.nameLabel.setEnabled(true);
        this.htmlLabel.setEnabled(true);
        this.basePathLabel.setEnabled(true);
        this.targetLabel.setEnabled(!isCollection || !hasChildren);
        this.typeLabel.setEnabled(true);
        this.openHTMLButton.setEnabled(true);
        this.openBasePathButton.setEnabled(true);
        this.openFileButton.setEnabled(!isCollection || !hasChildren);
        this.basePathField.setForeground(hasBasePath || this.basePathField.hasFocus() ? defaultForeground : lightGreen);
        this.nameField.setBackground(Color.white);
        this.basePathField.setBackground(Color.white);
        String authors = node.getMetadataValue("Author");
        if (authors == null) {
            authors = "";
        }
        if (!this.authorField.getText().equals(authors)) {
            this.authorField.setText(authors);
            this.authorField.setCaretPosition(0);
            this.authorField.setBackground(Color.white);
        }
        if ((contact = node.getMetadataValue("Contact")) == null) {
            contact = "";
        }
        if (!this.contactField.getText().equals(contact)) {
            this.contactField.setText(contact);
            this.contactField.setCaretPosition(0);
            this.contactField.setBackground(Color.white);
        }
        if ((keys = node.getMetadataValue("Keywords")) == null) {
            keys = "";
        }
        if (!this.keywordsField.getText().equals(keys)) {
            this.keywordsField.setText(keys);
            this.keywordsField.setCaretPosition(0);
            this.keywordsField.setBackground(Color.white);
        }
        if (node.selectedMetadata != null) {
            this.metadataDropdown.getEditor().setItem(node.selectedMetadata);
        } else {
            this.metadataDropdown.getEditor().setItem(this.emptyMetadata);
        }
        String path = this.htmlField.getText();
        if (!path.equals(XML.getPathRelativeTo(path, base))) {
            this.htmlField.setToolTipText(ToolsRes.getString("LibraryTreePanel.Tooltip.Relative"));
        } else if (!path.equals(XML.getResolvedPath(path, base))) {
            this.htmlField.setToolTipText(ToolsRes.getString("LibraryTreePanel.Tooltip.Absolute"));
        } else {
            this.htmlField.setToolTipText(null);
        }
        path = this.targetField.getText();
        if (!path.equals(XML.getPathRelativeTo(path, base))) {
            this.targetField.setToolTipText(ToolsRes.getString("LibraryTreePanel.Tooltip.Relative"));
        } else if (!path.equals(XML.getResolvedPath(path, base))) {
            this.targetField.setToolTipText(ToolsRes.getString("LibraryTreePanel.Tooltip.Absolute"));
        } else {
            this.targetField.setToolTipText(null);
        }
    }

    protected void showHTMLPane(LibraryTreeNode node) {
        HTMLPane htmlPane = htmlPanesByNode.get(node);
        if (htmlPane == null || htmlPane != this.htmlScroller.getViewport().getView()) {
            new HTMLDisplayer(node).execute();
        }
    }

    protected void createGUI() {
        JButton[] buttons;
        this.addCollectionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
                htmlPanesByNode.remove(node);
                LibraryCollection collection = (LibraryCollection)node.record;
                LibraryCollection newCollection = new LibraryCollection(null);
                collection.addResource(newCollection);
                LibraryTreeNode newNode = new LibraryTreeNode(newCollection, LibraryTreePanel.this);
                if (LibraryTreePanel.this.insertChildAt(newNode, node, node.getChildCount())) {
                    LibraryTreePanel.this.scrollToPath(newNode.getTreePath(), true);
                }
                LibraryTreePanel.this.setChanged();
            }
        };
        this.addResourceAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
                htmlPanesByNode.remove(node);
                LibraryCollection collection = (LibraryCollection)node.record;
                LibraryResource record = new LibraryResource(null);
                collection.addResource(record);
                LibraryTreeNode newNode = new LibraryTreeNode(record, LibraryTreePanel.this);
                if (LibraryTreePanel.this.insertChildAt(newNode, node, node.getChildCount())) {
                    LibraryTreePanel.this.scrollToPath(newNode.getTreePath(), true);
                }
                LibraryTreePanel.this.setChanged();
            }
        };
        this.copyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
                if (node != null) {
                    XMLControlElement control = new XMLControlElement(node.record);
                    String target = XML.forwardSlash(node.getTarget());
                    if (!LibraryTreePanel.this.isEditing() && !target.startsWith("/") && target.indexOf(":") == -1) {
                        control.setValue("base_path", node.getBasePath());
                    }
                    OSPRuntime.copy(control.toXML(), null);
                    LibraryTreePanel.this.enableButtons();
                }
            }
        };
        this.cutAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
                if (node != null) {
                    LibraryTreePanel.this.copyAction.actionPerformed(null);
                    LibraryTreePanel.this.removeNode(node);
                    LibraryTreePanel.this.enableButtons();
                    LibraryTreePanel.this.setChanged();
                }
            }
        };
        this.pasteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryTreeNode parent = LibraryTreePanel.this.getSelectedNode();
                if (parent == null || !(parent.record instanceof LibraryCollection)) {
                    return;
                }
                OSPRuntime.paste(dataString -> {
                    if (dataString != null) {
                        XMLControlElement control = new XMLControlElement();
                        control.readXML((String)dataString);
                        if (LibraryResource.class.isAssignableFrom(control.getObjectClass())) {
                            htmlPanesByNode.remove(parent);
                            LibraryResource record = (LibraryResource)control.loadObject(null);
                            LibraryCollection collection = (LibraryCollection)libraryTreeNode.record;
                            collection.addResource(record);
                            LibraryTreeNode newNode = new LibraryTreeNode(record, LibraryTreePanel.this);
                            if (LibraryTreePanel.this.insertChildAt(newNode, parent, parent.getChildCount())) {
                                LibraryTreePanel.this.scrollToPath(newNode.getTreePath(), true);
                            }
                            LibraryTreePanel.this.setChanged();
                        }
                        LibraryTreePanel.this.enableButtons();
                    }
                });
            }
        };
        this.moveUpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                LibraryTreeNode parent;
                LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
                if (node != null && (parent = (LibraryTreeNode)node.getParent()) != null && (i = parent.getIndex(node)) > 0) {
                    htmlPanesByNode.remove(parent);
                    LibraryTreePanel.this.treeModel.removeNodeFromParent(node);
                    LibraryTreePanel.this.treeModel.insertNodeInto(node, parent, i - 1);
                    LibraryCollection collection = (LibraryCollection)parent.record;
                    collection.removeResource(node.record);
                    collection.insertResource(node.record, i - 1);
                    LibraryTreePanel.this.setSelectedNode(node);
                    LibraryTreePanel.this.enableButtons();
                    LibraryTreePanel.this.setChanged();
                }
            }
        };
        this.moveDownAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int end;
                int i;
                LibraryTreeNode parent;
                LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
                if (node != null && (parent = (LibraryTreeNode)node.getParent()) != null && (i = parent.getIndex(node)) < (end = parent.getChildCount()) - 1) {
                    htmlPanesByNode.remove(parent);
                    LibraryTreePanel.this.treeModel.removeNodeFromParent(node);
                    LibraryTreePanel.this.treeModel.insertNodeInto(node, parent, i + 1);
                    LibraryCollection collection = (LibraryCollection)parent.record;
                    collection.removeResource(node.record);
                    collection.insertResource(node.record, i + 1);
                    LibraryTreePanel.this.setSelectedNode(node);
                    LibraryTreePanel.this.enableButtons();
                    LibraryTreePanel.this.setChanged();
                }
            }
        };
        this.metadataAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean select = !LibraryTreePanel.this.metadataButton.isSelected();
                LibraryTreePanel.this.metadataButton.setSelected(select);
                LibraryTreePanel.this.metadataButton.setText(select ? ToolsRes.getString("LibraryTreePanel.Button.Metadata.Hide") : ToolsRes.getString("LibraryTreePanel.Button.Metadata.Show"));
                if (select) {
                    LibraryTreePanel.this.editorPanel.add(LibraryTreePanel.this.authorBox);
                    LibraryTreePanel.this.editorPanel.add(LibraryTreePanel.this.contactBox);
                    LibraryTreePanel.this.editorPanel.add(LibraryTreePanel.this.keywordsBox);
                    LibraryTreePanel.this.editorPanel.add(LibraryTreePanel.this.metadataBox);
                } else {
                    LibraryTreePanel.this.editorPanel.remove(LibraryTreePanel.this.authorBox);
                    LibraryTreePanel.this.editorPanel.remove(LibraryTreePanel.this.contactBox);
                    LibraryTreePanel.this.editorPanel.remove(LibraryTreePanel.this.keywordsBox);
                    LibraryTreePanel.this.editorPanel.remove(LibraryTreePanel.this.metadataBox);
                }
            }
        };
        this.convertPathMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LibraryTreePanel.this.doMouseClick(e);
            }
        };
        this.treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                LibraryTreePanel.this.prevTreePath = e.getOldLeadSelectionPath();
                LibraryTreePanel.this.emptyMetadata.clearData();
                LibraryTreePanel.this.metadataModel.dataChanged();
                LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
                if (node == null) {
                    return;
                }
                LibraryTreePanel.this.showInfo(node, "LibraryTreePanel.treeselectionlistener");
                LibraryTreePanel.this.enableButtons();
                if (node.record != null && node.record instanceof LibraryCollection && node.getTarget() != null && node.getTarget().startsWith("&")) {
                    LibraryTreePanel.this.firePropertyChange("target", "LOAD", node);
                }
            }
        };
        this.treeMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path = LibraryTreePanel.this.tree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                LibraryTreePanel.this.tree.setSelectionPath(path);
                LibraryTreeNode node = (LibraryTreeNode)LibraryTreePanel.this.tree.getLastSelectedPathComponent();
                if (OSPRuntime.isPopupTrigger(e)) {
                    LibraryTreePanel.this.getPopup(node).show(LibraryTreePanel.this.tree, e.getX(), e.getY() + 8);
                } else if (path.equals(LibraryTreePanel.this.prevTreePath)) {
                    this.checkLoadEvent(e, node, () -> LibraryTreePanel.this.firePropertyChange("target", "LOAD", node));
                } else {
                    LibraryTreePanel.this.prevTreePath = path;
                }
            }

            private void checkLoadEvent(MouseEvent e, final LibraryTreeNode node, final Runnable load) {
                String target = node.getAbsoluteTarget();
                if (target == null) {
                    return;
                }
                if (LibraryComPADRE.isComPADREPath(target)) {
                    load.run();
                    return;
                }
                int n = e.getClickCount();
                boolean bl = LibraryTreePanel.this.launchLater = n == 1;
                if (n == 2) {
                    LibraryTreePanel.this.launchLater = false;
                    load.run();
                    return;
                }
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if ((this).LibraryTreePanel.this.launchLater) {
                            AsyncDialog.showYesNoAsync(LibraryBrowser.frame, String.valueOf(ToolsRes.getString("LibraryTreePanel.Dialog.Open.Message")) + " \"" + node.getName() + "\"?", ToolsRes.getString("LibraryTreePanel.Dialog.Open.Title"), new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (e.getID() == 0) {
                                        load.run();
                                    }
                                }
                            });
                        }
                    }
                };
                OSPRuntime.setTimeout("loadEvent", 800, true, r);
            }
        };
        this.addCollectionButton = new JButton(this.addCollectionAction);
        this.addResourceButton = new JButton(this.addResourceAction);
        this.copyButton = new JButton(this.copyAction);
        this.cutButton = new JButton(this.cutAction);
        this.pasteButton = new JButton(this.pasteAction);
        this.moveUpButton = new JButton(this.moveUpAction);
        this.moveDownButton = new JButton(this.moveDownAction);
        this.metadataButton = new JButton(this.metadataAction);
        JButton[] jButtonArray = buttons = new JButton[]{this.addCollectionButton, this.addResourceButton, this.copyButton, this.cutButton, this.pasteButton, this.moveUpButton, this.moveDownButton, this.metadataButton};
        int n = buttons.length;
        int n2 = 0;
        while (n2 < n) {
            JButton next = jButtonArray[n2];
            next.setOpaque(false);
            next.setBorder(LibraryBrowser.buttonBorder);
            ++n2;
        }
        this.editorbar = new JToolBar();
        this.editorbar.setFloatable(false);
        this.editorbar.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        this.editorbar.add(this.addResourceButton);
        this.editorbar.add(this.addCollectionButton);
        this.editorbar.addSeparator();
        this.editorbar.add(this.copyButton);
        this.editorbar.add(this.cutButton);
        this.editorbar.add(this.pasteButton);
        this.editorbar.addSeparator();
        this.editorbar.add(this.moveUpButton);
        this.editorbar.add(this.moveDownButton);
        this.editorbar.add(Box.createHorizontalGlue());
        this.editorbar.add(this.metadataButton);
        this.emptyHTMLPane = new HTMLPane();
        this.displayPanel = new JPanel(new BorderLayout());
        this.displayPanel.add((Component)this.htmlScroller, "Center");
        this.splitPane = new JSplitPane(1, this.treeScroller, this.displayPanel);
        this.add((Component)this.splitPane, "Center");
        this.treeScroller.setPreferredSize(new Dimension(320, 500));
        this.editorPanel = Box.createVerticalBox();
        this.nameField = new EntryField();
        this.entryFields.add(this.nameField);
        this.nameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
                if (node != null) {
                    htmlPanesByNode.remove(node);
                    LibraryTreeNode parent = (LibraryTreeNode)node.getParent();
                    if (parent != null) {
                        htmlPanesByNode.remove(parent);
                    }
                    node.setName(LibraryTreePanel.this.nameField.getText());
                    if (node.isRoot()) {
                        LibraryTreePanel.this.browser.refreshTabTitle(LibraryTreePanel.this.pathToRoot, LibraryTreePanel.this.rootResource);
                    }
                }
            }
        });
        this.typeField = new JLabel(" "){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = LibraryTreePanel.this.nameField.getPreferredSize();
                dim.width = LibraryTreePanel.this.typeFieldWidth;
                return dim;
            }
        };
        this.typeField.setBorder(this.nameField.getBorder());
        this.typeField.setBackground(this.nameField.getBackground());
        this.typeField.setFont(this.nameField.getFont());
        this.typeField.setOpaque(true);
        this.typeField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                final LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
                if (node != null && !(node.record instanceof LibraryCollection)) {
                    JPopupMenu popup = new JPopupMenu();
                    ActionListener typeListener = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String type = e.getActionCommand();
                            if (!type.equals(node.record.getType())) {
                                htmlPanesByNode.remove(node);
                                LibraryTreeNode parent = (LibraryTreeNode)node.getParent();
                                if (parent != null) {
                                    htmlPanesByNode.remove(parent);
                                }
                                node.setType(type);
                                type = ToolsRes.getString("LibraryResource.Type." + node.record.getType());
                                (this).LibraryTreePanel.this.typeField.setText(type);
                                LibraryTreePanel.this.setChanged();
                                LibraryTreePanel.this.showInfo(node, "LibraryTreePanel.typeListener");
                            }
                        }
                    };
                    String[] stringArray = LibraryResource.RESOURCE_TYPES;
                    int n = LibraryResource.RESOURCE_TYPES.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String next = stringArray[n2];
                        JMenuItem item = new JMenuItem(ToolsRes.getString("LibraryResource.Type." + next)){

                            @Override
                            public Dimension getPreferredSize() {
                                Dimension dim = (this).LibraryTreePanel.this.typeField.getPreferredSize();
                                dim.width -= 2;
                                return dim;
                            }
                        };
                        popup.add(item);
                        item.addActionListener(typeListener);
                        item.setActionCommand(next);
                        ++n2;
                    }
                    popup.show(LibraryTreePanel.this.typeField, 0, LibraryTreePanel.this.typeField.getHeight());
                }
            }
        });
        this.htmlField = new EntryField();
        this.entryFields.add(this.htmlField);
        this.htmlField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
                if (node != null) {
                    node.setHTMLPath(LibraryTreePanel.this.htmlField.getText());
                }
            }
        });
        this.htmlField.addMouseListener(this.convertPathMouseListener);
        this.openHTMLButton = new JButton(openFileIcon);
        this.openHTMLButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 2));
        this.openHTMLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
                if (node != null) {
                    int result = 1;
                    JFileChooser chooser = LibraryTreePanel.getFileChooser();
                    chooser.setDialogTitle(null);
                    chooser.setFileSelectionMode(0);
                    chooser.setAcceptAllFileFilterUsed(true);
                    chooser.addChoosableFileFilter(htmlFilter);
                    result = chooser.showOpenDialog(LibraryTreePanel.this);
                    File file = chooser.getSelectedFile();
                    chooser.removeChoosableFileFilter(htmlFilter);
                    chooser.setSelectedFile(new File(""));
                    if (result == 0) {
                        LibraryTreePanel.this.browser.library.chooserDir = chooser.getCurrentDirectory().toString();
                        if (file != null) {
                            String path = XML.forwardSlash(file.getAbsolutePath());
                            String base = node.getBasePath();
                            if (!"".equals(base)) {
                                path = XML.getPathRelativeTo(path, base);
                            }
                            node.setHTMLPath(path);
                        }
                    }
                }
            }
        });
        this.basePathField = new EntryField();
        this.entryFields.add(this.basePathField);
        this.basePathField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
                if (LibraryTreePanel.this.basePathField.getBackground() != Color.yellow) {
                    return;
                }
                if (node != null) {
                    if (!LibraryTreePanel.this.basePathField.getText().equals(node.record.getBasePath())) {
                        htmlPanesByNode.remove(node);
                        LibraryTreeNode parent = (LibraryTreeNode)node.getParent();
                        if (parent != null) {
                            htmlPanesByNode.remove(parent);
                        }
                        node.setBasePath(LibraryTreePanel.this.basePathField.getText());
                        LibraryTreePanel.this.setChanged();
                    }
                    boolean noBase = node.record.getBasePath() == null;
                    LibraryTreePanel.this.basePathField.setForeground(noBase ? lightGreen : defaultForeground);
                }
            }
        });
        this.basePathField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
                if ("".equals(node.record.getBasePath())) {
                    LibraryTreePanel.this.basePathField.setText(null);
                    LibraryTreePanel.this.basePathField.setForeground(LibraryTreePanel.this.htmlField.getForeground());
                    LibraryTreePanel.this.basePathField.setBackground(Color.white);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
                String base = node.getBasePath();
                if (!LibraryTreePanel.this.basePathField.getText().equals(base)) {
                    LibraryTreePanel.this.basePathField.setText(base);
                    LibraryTreePanel.this.basePathField.setCaretPosition(0);
                    LibraryTreePanel.this.basePathField.setForeground(node.record.getBasePath().equals(base) ? defaultForeground : lightGreen);
                    LibraryTreePanel.this.basePathField.setBackground(Color.white);
                }
            }
        });
        this.openBasePathButton = new JButton(openFileIcon);
        this.openBasePathButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 2));
        this.openBasePathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
                if (node != null) {
                    int result = 1;
                    JFileChooser chooser = LibraryTreePanel.getFileChooser();
                    chooser.setFileSelectionMode(1);
                    chooser.setAcceptAllFileFilterUsed(false);
                    chooser.addChoosableFileFilter(folderFilter);
                    chooser.setDialogTitle(ToolsRes.getString("LibraryTreePanel.FileChooser.Title.Base"));
                    result = chooser.showDialog(LibraryTreePanel.this, ToolsRes.getString("LibraryTreePanel.FileChooser.Button.Select"));
                    File file = chooser.getSelectedFile();
                    chooser.removeChoosableFileFilter(folderFilter);
                    chooser.setSelectedFile(new File(""));
                    if (result == 0) {
                        LibraryTreePanel.this.browser.library.chooserDir = chooser.getCurrentDirectory().toString();
                        if (file != null) {
                            htmlPanesByNode.remove(node);
                            LibraryTreeNode parent = (LibraryTreeNode)node.getParent();
                            if (parent != null) {
                                htmlPanesByNode.remove(parent);
                            }
                            node.setBasePath(XML.forwardSlash(file.getAbsolutePath()));
                            LibraryTreePanel.this.setChanged();
                            LibraryTreePanel.this.showInfo(node, "LibraryTreePanel.openBasePath");
                        }
                    }
                }
            }
        });
        this.targetField = new EntryField();
        this.entryFields.add(this.targetField);
        this.targetField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
                if (!(node == null || node.record instanceof LibraryCollection && node.children().hasMoreElements())) {
                    node.setTarget(LibraryTreePanel.this.targetField.getText());
                }
            }
        });
        this.targetField.addMouseListener(this.convertPathMouseListener);
        this.openFileButton = new JButton(openFileIcon);
        this.openFileButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 2));
        this.openFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
                if (node != null) {
                    int result = 1;
                    JFileChooser chooser = LibraryTreePanel.getFileChooser();
                    chooser.setDialogTitle(null);
                    chooser.setFileSelectionMode(0);
                    chooser.setAcceptAllFileFilterUsed(true);
                    result = chooser.showOpenDialog(LibraryTreePanel.this);
                    File file = chooser.getSelectedFile();
                    chooser.setSelectedFile(new File(""));
                    if (result == 0) {
                        LibraryTreePanel.this.browser.library.chooserDir = chooser.getCurrentDirectory().toString();
                        if (file != null) {
                            String path = XML.forwardSlash(file.getAbsolutePath());
                            String base = node.getBasePath();
                            if (!"".equals(base)) {
                                path = XML.getPathRelativeTo(path, base);
                            }
                            node.setTarget(path);
                        }
                    }
                }
            }
        });
        this.nameLabel = new JLabel();
        this.nameLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.nameLabel.setHorizontalAlignment(11);
        this.typeLabel = new JLabel();
        this.typeLabel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 2));
        this.typeLabel.setHorizontalAlignment(11);
        this.htmlLabel = new JLabel();
        this.htmlLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.htmlLabel.setHorizontalAlignment(11);
        this.basePathLabel = new JLabel();
        this.basePathLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.basePathLabel.setHorizontalAlignment(11);
        this.targetLabel = new JLabel();
        this.targetLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.targetLabel.setHorizontalAlignment(11);
        this.labels.add(this.nameLabel);
        this.labels.add(this.htmlLabel);
        this.labels.add(this.basePathLabel);
        this.labels.add(this.targetLabel);
        Box box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 2));
        box.add(this.nameLabel);
        box.add(this.nameField);
        box.add(this.typeLabel);
        box.add(this.typeField);
        this.editorPanel.add(box);
        box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 2));
        box.add(this.htmlLabel);
        box.add(this.htmlField);
        box.add(this.openHTMLButton);
        this.editorPanel.add(box);
        box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 2));
        box.add(this.basePathLabel);
        box.add(this.basePathField);
        box.add(this.openBasePathButton);
        this.editorPanel.add(box);
        this.fileBox = Box.createHorizontalBox();
        this.fileBox.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 1));
        this.fileBox.add(this.targetLabel);
        this.fileBox.add(this.targetField);
        this.fileBox.add(this.openFileButton);
        this.editorPanel.add(this.fileBox);
        this.metadataFieldListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
                if (node != null) {
                    EntryField field = (EntryField)e.getSource();
                    String s = field.getText().trim();
                    LibraryResource.Metadata metadata = node.selectedMetadata;
                    String key = null;
                    int index = 1;
                    if (field == LibraryTreePanel.this.authorField) {
                        key = "Author";
                        metadata = node.record.getMetadata(key);
                    } else if (field == LibraryTreePanel.this.contactField) {
                        key = "Contact";
                        metadata = node.record.getMetadata(key);
                    } else if (field == LibraryTreePanel.this.keywordsField) {
                        key = "Keywords";
                        metadata = node.record.getMetadata(key);
                    } else if (field == LibraryTreePanel.this.keyEditField) {
                        index = 0;
                    }
                    if (metadata != null && s.equals(metadata.getData()[index])) {
                        return;
                    }
                    if (s.length() > 0 && (metadata == null || metadata == LibraryTreePanel.this.emptyMetadata)) {
                        metadata = index == 0 ? new LibraryResource.Metadata(s, null) : new LibraryResource.Metadata(key, s);
                        node.record.addMetadata(metadata);
                        LibraryTreePanel.this.metadataModel.dataAdded();
                        if (field == LibraryTreePanel.this.keyEditField || field == LibraryTreePanel.this.valueEditField) {
                            node.selectedMetadata = metadata;
                        }
                    } else if (metadata != null) {
                        if ("".equals(s)) {
                            node.record.removeMetadata(metadata);
                            LibraryTreePanel.this.metadataModel.dataRemoved();
                            if (node.selectedMetadata == metadata) {
                                node.selectedMetadata = null;
                            }
                        } else {
                            String[] data = metadata.getData();
                            data[index] = s;
                            LibraryTreePanel.this.metadataModel.dataChanged();
                        }
                    }
                    LibraryTreePanel.this.setChanged();
                    node.tooltip = null;
                    LibraryTreePanel.this.showInfo(node, "LibraryTreePanel.metadatafield");
                }
            }
        };
        this.authorField = new EntryField();
        this.entryFields.add(this.authorField);
        this.authorField.addActionListener(this.metadataFieldListener);
        this.contactField = new EntryField();
        this.entryFields.add(this.contactField);
        this.contactField.addActionListener(this.metadataFieldListener);
        this.keywordsField = new EntryField();
        this.entryFields.add(this.keywordsField);
        this.keywordsField.addActionListener(this.metadataFieldListener);
        this.metadataModel = new MetadataComboBoxModel();
        this.metadataDropdown = new JComboBox<LibraryResource.Metadata>(this.metadataModel);
        this.metadataDropdown.setRenderer(new MetadataComboBoxRenderer());
        this.metadataDropdown.setEditor(new MetadataComboBoxEditor());
        this.metadataDropdown.setEditable(true);
        this.authorLabel = new JLabel();
        this.authorLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.authorLabel.setHorizontalAlignment(11);
        this.contactLabel = new JLabel();
        this.contactLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.contactLabel.setHorizontalAlignment(11);
        this.keywordsLabel = new JLabel();
        this.keywordsLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.keywordsLabel.setHorizontalAlignment(11);
        this.metadataLabel = new JLabel();
        this.metadataLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.metadataLabel.setHorizontalAlignment(11);
        this.labels.add(this.authorLabel);
        this.labels.add(this.contactLabel);
        this.labels.add(this.keywordsLabel);
        this.labels.add(this.metadataLabel);
        this.authorBox = Box.createHorizontalBox();
        this.authorBox.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 1));
        this.authorBox.add(this.authorLabel);
        this.authorBox.add(this.authorField);
        this.contactBox = Box.createHorizontalBox();
        this.contactBox.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 1));
        this.contactBox.add(this.contactLabel);
        this.contactBox.add(this.contactField);
        this.keywordsBox = Box.createHorizontalBox();
        this.keywordsBox.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 1));
        this.keywordsBox.add(this.keywordsLabel);
        this.keywordsBox.add(this.keywordsField);
        this.metadataBox = Box.createHorizontalBox();
        this.metadataBox.add(this.metadataLabel);
        this.metadataBox.add(this.metadataDropdown);
    }

    protected void doMouseClick(MouseEvent e) {
        boolean isTarget;
        if (!OSPRuntime.isPopupTrigger(e)) {
            return;
        }
        LibraryTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        EntryField field = (EntryField)e.getSource();
        String path = field.getText();
        if ("".equals(path)) {
            return;
        }
        String base = node.getBasePath();
        if ("".equals(base)) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        String relPath = XML.getPathRelativeTo(path, base);
        String absPath = XML.getResolvedPath(path, base);
        boolean bl = isTarget = field == this.targetField;
        if (!path.equals(relPath)) {
            JMenuItem item = new JMenuItem(ToolsRes.getString("LibraryTreePanel.MenuItem.SetToRelative"));
            popup.add(item);
            item.addActionListener(ev -> {
                if (isTarget) {
                    node.setTarget(relPath);
                } else {
                    node.setHTMLPath(relPath);
                }
            });
        } else if (!path.equals(absPath)) {
            JMenuItem item = new JMenuItem(ToolsRes.getString("LibraryTreePanel.MenuItem.SetToAbsolute"));
            popup.add(item);
            item.addActionListener(ev -> {
                if (isTarget) {
                    node.setTarget(absPath);
                } else {
                    node.setHTMLPath(absPath);
                }
            });
        }
        if (popup.getComponentCount() > 0) {
            popup.show(field, e.getX() + 2, e.getY() + 2);
        }
    }

    protected void refreshGUI() {
        this.refreshGUI(false);
    }

    protected void refreshGUI(boolean andRebuild) {
        if (andRebuild) {
            this.addCollectionButton.setText(ToolsRes.getString("LibraryTreePanel.Button.AddCollection"));
            this.addResourceButton.setText(ToolsRes.getString("LibraryTreePanel.Button.AddResource"));
            this.copyButton.setText(ToolsRes.getString("LibraryTreePanel.Button.Copy"));
            this.cutButton.setText(ToolsRes.getString("LibraryTreePanel.Button.Cut"));
            this.pasteButton.setText(ToolsRes.getString("LibraryTreePanel.Button.Paste"));
            this.moveUpButton.setText(ToolsRes.getString("LibraryTreePanel.Button.Up"));
            this.moveDownButton.setText(ToolsRes.getString("LibraryTreePanel.Button.Down"));
            this.metadataButton.setText(this.metadataButton.isSelected() ? ToolsRes.getString("LibraryTreePanel.Button.Metadata.Hide") : ToolsRes.getString("LibraryTreePanel.Button.Metadata.Show"));
            this.nameLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.Name"));
            this.typeLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.Type"));
            this.htmlLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.HTML"));
            this.basePathLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.BasePath"));
            this.targetLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.TargetFile"));
            this.authorLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.Author"));
            this.contactLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.Contact"));
            this.keywordsLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.Keywords"));
            this.metadataLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.Metadata"));
        }
        this.browser.refreshButton.setEnabled(this.getSelectedNode() != null);
        if (this.getSelectedNode() == this.rootNode) {
            this.browser.refreshButton.setToolTipText(ToolsRes.getString("LibraryBrowser.Tooltip.Reload"));
        } else {
            this.browser.refreshButton.setToolTipText(ToolsRes.getString("LibraryBrowser.Tooltip.Refresh"));
        }
        int w = 0;
        int h = 0;
        Font font = this.nameLabel.getFont();
        for (JLabel next : this.labels) {
            Rectangle2D rect = font.getStringBounds(String.valueOf(next.getText()) + " ", OSPRuntime.frc);
            w = Math.max(w, (int)rect.getWidth() + 4);
            h = Math.max(h, (int)rect.getHeight() + 4);
        }
        h = Math.max(h, 20);
        Dimension labelSize = new Dimension(w, h);
        for (JLabel jLabel : this.labels) {
            jLabel.setPreferredSize(labelSize);
            jLabel.setMinimumSize(labelSize);
        }
        this.typeFieldWidth = 0;
        String[] stringArray = LibraryResource.RESOURCE_TYPES;
        int n = LibraryResource.RESOURCE_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            string2 = ToolsRes.getString("LibraryResource.Type." + string2);
            Rectangle2D rect = font.getStringBounds(String.valueOf(string2) + " ", OSPRuntime.frc);
            this.typeFieldWidth = Math.max(this.typeFieldWidth, (int)rect.getWidth() + 24);
            ++n2;
        }
    }

    protected void enableButtons() {
        LibraryTreeNode node = this.getSelectedNode();
        boolean nodeIsCollection = node != null && node.record instanceof LibraryCollection;
        this.addCollectionButton.setEnabled(nodeIsCollection);
        this.addResourceButton.setEnabled(nodeIsCollection);
        this.copyButton.setEnabled(node != null);
        this.cutButton.setEnabled(node != null && node != this.rootNode);
        this.pasteButton.setEnabled(false);
        if (nodeIsCollection) {
            this.ifClipboardPastable(() -> this.pasteButton.setEnabled(true));
        }
        boolean canMoveUp = false;
        boolean canMoveDown = false;
        if (node != null && node.getParent() != null) {
            LibraryTreeNode parent = (LibraryTreeNode)node.getParent();
            int i = parent.getIndex(node);
            canMoveUp = i > 0;
            canMoveDown = i < parent.getChildCount() - 1;
        }
        this.moveUpButton.setEnabled(canMoveUp);
        this.moveDownButton.setEnabled(canMoveDown);
    }

    protected void revert() {
        if (this.revertControl != null) {
            this.revertControl = new XMLControlElement(this.revertControl);
            LibraryResource record = (LibraryResource)this.revertControl.loadObject(null);
            this.isChanged = false;
            this.setRootResource(record, this.pathToRoot, this.rootNode.isEditable(), this.isXMLPath);
            this.browser.refreshTabTitle(this.pathToRoot, this.rootResource);
        }
    }

    protected void createTree(LibraryTreeNode root) {
        this.treeModel = new DefaultTreeModel(root);
        this.tree = new JTree(this.treeModel){

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip(100, new Color(0xCCCCFF));
            }

            @Override
            public String convertValueToText(Object node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                return ((LibraryTreeNode)node).record.getDisplayString();
            }
        };
        if (root.createChildNodes()) {
            this.scrollToPath(((LibraryTreeNode)root.getLastChild()).getTreePath(), false);
        }
        this.treeNodeRenderer = new LibraryTreeNodeRenderer();
        this.tree.setCellRenderer(this.treeNodeRenderer);
        this.tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.tree.addMouseListener(this.treeMouseListener);
        this.treeScroller.setViewportView(this.tree);
    }

    protected void ifClipboardPastable(Runnable r) {
        if (!OSPRuntime.allowLibClipboardPasteCheck) {
            return;
        }
        if (this.clipboardAvailable == Boolean.TRUE) {
            r.run();
        }
        this.clipboardAvailable = Boolean.FALSE;
        this.pasteControl = null;
        OSPRuntime.paste(dataString -> {
            if (dataString != null) {
                XMLControlElement control = new XMLControlElement();
                control.readXML((String)dataString);
                Class<?> type = control.getObjectClass();
                if (type != null && LibraryResource.class.isAssignableFrom(type)) {
                    this.pasteControl = control;
                    this.clipboardAvailable = Boolean.TRUE;
                    r.run();
                }
            }
        });
    }

    protected JPopupMenu getPopup(LibraryTreeNode node) {
        JMenuItem item;
        if (this.popup == null) {
            this.popup = new JPopupMenu();
        }
        this.popup.removeAll();
        if (!this.isEditing()) {
            JMenuItem item2 = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Button.Copy"));
            this.popup.add(item2);
            item2.addActionListener(this.copyAction);
            if ("".equals(this.pathToRoot) && node.record.getCollectionPath() != null) {
                item2 = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Popup.Item.OpenCollection"));
                this.popup.addSeparator();
                this.popup.add(item2);
                item2.addActionListener(e -> {
                    String path = libraryTreeNode.record.getCollectionPath();
                    this.browser.loadTab(path, libraryTreeNode.record.treePath);
                });
            }
            if (this.rootResource == this.browser.getRecentCollection()) {
                item2 = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Popup.Item.Remove"));
                this.popup.addSeparator();
                this.popup.add(item2);
                item2.addActionListener(e -> this.removeNode(node));
            }
            FontSizer.setFonts(this.popup, FontSizer.getLevel());
            return this.popup;
        }
        boolean isCollection = node.record instanceof LibraryCollection;
        boolean canMoveUp = false;
        boolean canMoveDown = false;
        if (node.getParent() != null) {
            LibraryTreeNode parent = (LibraryTreeNode)node.getParent();
            int i = parent.getIndex(node);
            canMoveUp = i > 0;
            boolean bl = canMoveDown = i < parent.getChildCount() - 1;
        }
        if (isCollection) {
            item = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Button.AddResource"));
            this.popup.add(item);
            item.addActionListener(this.addResourceAction);
            item = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Button.AddCollection"));
            this.popup.add(item);
            item.addActionListener(this.addCollectionAction);
            this.popup.addSeparator();
        }
        item = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Button.Copy"));
        this.popup.add(item);
        item.addActionListener(this.copyAction);
        item = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Button.Cut"));
        this.popup.add(item);
        item.addActionListener(this.cutAction);
        JMenuItem citem = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Button.Paste"));
        citem.setEnabled(false);
        if (isCollection) {
            this.ifClipboardPastable(() -> {
                citem.setEnabled(true);
                citem.addActionListener(this.pasteAction);
            });
        }
        this.popup.add(citem);
        if (canMoveUp || canMoveDown) {
            this.popup.addSeparator();
            if (canMoveUp) {
                item = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Button.Up"));
                this.popup.add(item);
                item.addActionListener(this.moveUpAction);
            }
            if (canMoveDown) {
                item = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Button.Down"));
                this.popup.add(item);
                item.addActionListener(this.moveDownAction);
            }
        }
        FontSizer.setFonts(this.popup, FontSizer.getLevel());
        return this.popup;
    }

    protected boolean insertChildAt(LibraryTreeNode child, LibraryTreeNode parent, int index) {
        if (this.tree == null || parent.getChildCount() < index) {
            return false;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        model.insertNodeInto(child, parent, index);
        return true;
    }

    protected void removeNode(LibraryTreeNode node) {
        if (this.rootNode == null || node == this.rootNode) {
            return;
        }
        LibraryTreeNode parent = (LibraryTreeNode)node.getParent();
        htmlPanesByNode.remove(parent);
        htmlPanesByNode.remove(node);
        LibraryCollection collection = (LibraryCollection)parent.record;
        collection.removeResource(node.record);
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        model.removeNodeFromParent(node);
        this.scrollToPath(parent.getTreePath(), true);
    }

    protected void setChanged() {
        if (this.ignoreChanges) {
            return;
        }
        this.isChanged = true;
        this.firePropertyChange("collection_edit", null, null);
    }

    protected boolean isChanged() {
        return this.isEditable() && this.isChanged;
    }

    protected String save() {
        if (!this.isXMLPath) {
            return this.browser.saveAs();
        }
        if (this.isEditable() || this.rootResource == this.browser.getRecentCollection()) {
            XMLControlElement control = new XMLControlElement(this.rootResource);
            control.write(this.pathToRoot);
            this.isChanged = false;
        }
        File cacheFile = ResourceLoader.getSearchCacheFile(this.pathToRoot);
        XMLControlElement control = new XMLControlElement(this.rootNode.record);
        control.setValue("real_path", this.pathToRoot);
        control.write(cacheFile.getAbsolutePath());
        return this.pathToRoot;
    }

    protected boolean saveChanges(String name) {
        if (!this.isChanged() || OSPRuntime.isJS || OSPRuntime.isApplet) {
            return true;
        }
        int i = JOptionPane.showConfirmDialog(this, String.valueOf(ToolsRes.getString("LibraryBrowser.Dialog.SaveChanges.Message")) + " \"" + name + "\"?", ToolsRes.getString("LibraryBrowser.Dialog.SaveChanges.Title"), 1, 3);
        if (i == -1 || i == 2) {
            return false;
        }
        if (i == 0) {
            if ("temp".equals(this.getName())) {
                this.setName("");
                String path = this.browser.saveAs();
                return path != null;
            }
            if (this.save() == null) {
                return false;
            }
        } else if ("temp".equals(this.getName())) {
            String tempPath = this.pathToRoot;
            if (tempPath != null) {
                File tempFile = new File(tempPath);
                tempFile.delete();
            }
        } else {
            this.revert();
        }
        return true;
    }

    protected String[] getNextSplit(String phrase) {
        int which;
        String[] and = phrase.split(" AND ", 2);
        String[] or = phrase.split(" OR ", 2);
        String[] open = phrase.split(Pattern.quote("("), 2);
        int n = and[0].length() <= or[0].length() ? (and[0].length() <= open[0].length() ? 0 : 2) : (which = or[0].length() <= open[0].length() ? 1 : 2);
        if (which == 2 && open.length > 1) {
            String[] split = this.getParenthesisSplit(open[1]);
            if (split.length == 1) {
                return new String[]{split[0]};
            }
            int n2 = split[1].indexOf(" AND ");
            int m = split[1].indexOf(" OR ");
            if (n2 == -1 && m == -1) {
                return new String[]{open[1]};
            }
            if (n2 > -1 && (m == -1 || n2 < m)) {
                return new String[]{split[0], " AND ", split[1].substring(n2 + " AND ".length())};
            }
            if (m > -1 && (n2 == -1 || m < n2)) {
                return new String[]{split[0], " OR ", split[1].substring(m + " OR ".length())};
            }
        }
        switch (which) {
            case 0: {
                if (and.length == 1) {
                    return new String[]{and[0]};
                }
                return new String[]{and[0], " AND ", and[1]};
            }
            case 1: {
                if (or.length == 1) {
                    return new String[]{or[0]};
                }
                return new String[]{or[0], " OR ", or[1]};
            }
        }
        return new String[]{phrase};
    }

    protected String[] getParenthesisSplit(String phrase) {
        String[] stringArray;
        int index = 1;
        int n = 1;
        int opening = phrase.indexOf("(", index);
        int closing = phrase.indexOf(")", index);
        while (n > 0) {
            if (opening > -1 && opening < closing) {
                ++n;
                index = opening + 1;
                opening = phrase.indexOf("(", index);
                continue;
            }
            if (closing > -1) {
                --n;
                index = closing + 1;
                closing = phrase.indexOf(")", index);
                continue;
            }
            return new String[]{phrase};
        }
        String token = phrase.substring(0, index - 1);
        String remainder = phrase.substring(index);
        if (remainder.trim().equals("")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = token;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = token;
            stringArray = stringArray3;
            stringArray3[1] = remainder;
        }
        return stringArray;
    }

    protected Map<LibraryTreeNode, List<String[]>> applyAND(Map<LibraryTreeNode, List<String[]>> results1, Map<LibraryTreeNode, List<String[]>> results2) {
        HashMap<LibraryTreeNode, List<String[]>> resultsAND = new HashMap<LibraryTreeNode, List<String[]>>();
        Set<LibraryTreeNode> keys1 = results1.keySet();
        for (LibraryTreeNode node : results2.keySet()) {
            if (!keys1.contains(node)) continue;
            ArrayList matchedTerms = new ArrayList();
            matchedTerms.addAll(results1.get(node));
            matchedTerms.addAll(results2.get(node));
            resultsAND.put(node, matchedTerms);
        }
        return resultsAND;
    }

    protected Map<LibraryTreeNode, List<String[]>> applyOR(Map<LibraryTreeNode, List<String[]>> results1, Map<LibraryTreeNode, List<String[]>> results2) {
        ArrayList matchedTerms;
        HashMap<LibraryTreeNode, List<String[]>> resultsOR = new HashMap<LibraryTreeNode, List<String[]>>();
        for (LibraryTreeNode node : results1.keySet()) {
            matchedTerms = new ArrayList();
            matchedTerms.addAll(results1.get(node));
            resultsOR.put(node, matchedTerms);
        }
        for (LibraryTreeNode node : results2.keySet()) {
            if (resultsOR.keySet().contains(node)) {
                ((List)resultsOR.get(node)).addAll((Collection)results2.get(node));
                continue;
            }
            matchedTerms = new ArrayList();
            matchedTerms.addAll(results2.get(node));
            resultsOR.put(node, matchedTerms);
        }
        return resultsOR;
    }

    protected String getHTMLBody(String path) {
        String code = ResourceLoader.getString(path);
        if (code != null) {
            String[] parts = code.split("<body>");
            parts = parts[1].split("</body>");
            return parts[0];
        }
        return null;
    }

    protected void refreshEntryFields() {
        for (EntryField next : this.entryFields) {
            if (next.getBackground() != Color.yellow) continue;
            next.processEntry();
        }
    }

    protected static String getRelativePath(Map<String, ZipEntry> files, String baseName) {
        String fileName;
        for (String s : files.keySet()) {
            fileName = XML.getName(s);
            int n = fileName.indexOf("_thumbnail");
            if (n <= -1) continue;
            baseName = fileName.substring(0, n);
        }
        for (String s : files.keySet()) {
            fileName = XML.stripExtension(XML.getName(s));
            if (!s.toLowerCase().contains(".htm") || !fileName.equals(String.valueOf(baseName) + "_info")) continue;
            return s;
        }
        for (String s : files.keySet()) {
            if (!"trk".equals(XML.getExtension(s))) continue;
            String trkName = XML.stripExtension(XML.getName(s));
            for (String ss : files.keySet()) {
                String htmlName = XML.stripExtension(XML.getName(ss));
                if (!ss.toLowerCase().contains(".htm") || !htmlName.equals(String.valueOf(trkName) + "_info")) continue;
                return ss;
            }
        }
        return null;
    }

    protected static void showHTMLDocument(HTMLPane htmlPane, URL url, String htmlStr) {
        HTMLDocument document = (HTMLDocument)htmlPane.getDocument();
        document.setBase(url);
        htmlPane.setText(ResourceLoader.fixHTTPS(htmlStr, url));
        document.getStyleSheet().addRule(LibraryResource.getHTMLStyles());
    }

    protected static JFileChooser getFileChooser() {
        if (chooser == null) {
            String chooserDir = LibraryBrowser.getBrowser().library.chooserDir;
            chooser = chooserDir == null ? new JFileChooser() : new JFileChooser(new File(chooserDir));
            htmlFilter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    String[] accept;
                    if (f == null) {
                        return false;
                    }
                    if (f.isDirectory()) {
                        return true;
                    }
                    String ext = XML.getExtension(f.getName());
                    String[] stringArray = accept = new String[]{"html", "htm"};
                    int n = accept.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String next = stringArray[n2];
                        if (next.equals(ext)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    return ToolsRes.getString("LibraryTreePanel.HTMLFileFilter.Description");
                }
            };
            folderFilter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f != null && f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return ToolsRes.getString("LibraryTreePanel.FolderFileFilter.Description");
                }
            };
        }
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        return chooser;
    }

    public void refreshSelectedNode() {
    }

    protected void scrollToPath(TreePath path, boolean andSelect) {
        if (OSPRuntime.doScrollToPath) {
            this.tree.scrollPathToVisible(path);
        }
        if (andSelect) {
            this.tree.setSelectionPath(path);
        }
    }

    public static void clearMaps() {
        htmlPanesByURL.clear();
        htmlPanesByNode.clear();
    }

    protected static class EntryField
    extends JTextField {
        static Font font = new JTextField().getFont();
        static DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EntryField field = (EntryField)e.getDocument().getProperty("parent");
                field.setBackground(Color.yellow);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EntryField field = (EntryField)e.getDocument().getProperty("parent");
                field.setBackground(Color.yellow);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        static FocusListener focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                EntryField field = (EntryField)e.getSource();
                if (field.getDefaultText() != null) {
                    field.setText(null);
                    field.setFont(field.getDefaultFont());
                    field.setForeground(defaultForeground);
                }
                field.selectAll();
                field.setBackground(Color.white);
            }

            @Override
            public void focusLost(FocusEvent e) {
                EntryField field = (EntryField)e.getSource();
                field.processEntry();
            }
        };
        static ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntryField field = (EntryField)e.getSource();
                field.setBackground(Color.white);
            }
        };

        EntryField() {
            this.getDocument().putProperty("parent", this);
            this.addFocusListener(focusListener);
            this.addActionListener(actionListener);
            this.getDocument().addDocumentListener(documentListener);
        }

        protected String getDefaultText() {
            return null;
        }

        protected Font getEmptyFont() {
            return this.getFont();
        }

        protected Font getDefaultFont() {
            return this.getFont();
        }

        protected void processEntry() {
            boolean fire;
            boolean bl = fire = this.getBackground() == Color.yellow;
            if (this.getDefaultText() != null && "".equals(this.getText())) {
                this.setText(this.getDefaultText());
                this.setForeground(Color.gray);
                this.setFont(this.getEmptyFont());
            }
            this.setBackground(Color.white);
            if (fire) {
                this.fireActionPerformed();
            }
        }
    }

    class HTMLDisplayer
    extends SwingWorker<HTMLPane, Void> {
        LibraryTreeNode node;
        boolean hasNewChildren = false;

        HTMLDisplayer(LibraryTreeNode treeNode) {
            this.node = treeNode;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public HTMLPane doInBackground() {
            try {
                HTMLPane htmlPane = htmlPanesByNode.get(this.node);
                if (htmlPane == null) {
                    HTMLPane pane;
                    String htmlStr;
                    URL url = this.node.getHTMLURL();
                    if (url == null) {
                        htmlPane = new HTMLPane();
                        htmlStr = this.node.getHTMLString();
                    } else {
                        htmlPane = htmlPanesByURL.get(url);
                        if (htmlPane == null) {
                            htmlPane = new HTMLPane();
                            htmlPanesByURL.put(url, htmlPane);
                            if (!OSPRuntime.isJS) {
                                htmlStr = null;
                                try {
                                    pane = htmlPane;
                                    TreeSet<LibraryResource.Metadata> data = this.node.record.getMetadata();
                                    if (data == null || data.size() == 0) {
                                        htmlPane.addPropertyChangeListener(e -> {
                                            String htmlCode;
                                            if (e.getPropertyName() == "page" && this.node == LibraryTreePanel.this.getSelectedNode() && (htmlCode = pane.getText()).indexOf("<meta name=") > -1) {
                                                this.node.record.setMetadata(null);
                                                this.node.metadataSource = htmlCode;
                                                this.node.getMetadata();
                                                LibraryTreePanel.this.browser.setMessage(this.node.getToolTip(), null);
                                            }
                                        });
                                    }
                                    htmlPane.setPage(url);
                                }
                                catch (Exception pane2) {}
                            } else {
                                htmlStr = "";
                            }
                        } else if (url.equals(htmlPane.getPage())) {
                            htmlStr = null;
                        } else {
                            htmlStr = "";
                            htmlPane.getDocument().putProperty("stream", null);
                        }
                    }
                    if (htmlStr != null) {
                        pane = htmlPane;
                        if (htmlStr == "") {
                            if (OSPRuntime.allowAsyncURL) {
                                ResourceLoader.getURLContentsAsync(url, bytes -> {
                                    String s = bytes == null ? "<h2>" + this.node + "</h2>" : new String((byte[])bytes);
                                    LibraryTreePanel.showHTMLDocument(pane, url, s);
                                    htmlPanesByNode.put(this.node, pane);
                                    pane.setCaretPosition(0);
                                    this.whenDone(pane);
                                    return null;
                                });
                                return null;
                            }
                            htmlStr = new String(ResourceLoader.getURLContents(url));
                        }
                        LibraryTreePanel.showHTMLDocument(htmlPane, url, htmlStr);
                    }
                    htmlPanesByNode.put(this.node, htmlPane);
                    htmlPane.setCaretPosition(0);
                }
                this.whenDone(htmlPane);
                return null;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                System.out.println("LibraryTreePanel exception " + e2);
            }
            return null;
        }

        protected void whenDone(HTMLPane htmlPane) {
            SwingUtilities.invokeLater(() -> {
                if (htmlPane != null && this.node == LibraryTreePanel.this.getSelectedNode()) {
                    LibraryTreePanel.this.htmlScroller.setViewportView(htmlPane);
                    LibraryTreePanel.this.browser.setMessage(this.node.getToolTip(), null);
                    if (this.node == LibraryTreePanel.this.rootNode) {
                        LibraryTreePanel.this.browser.refreshButton.setToolTipText(ToolsRes.getString("LibraryBrowser.Tooltip.Reload"));
                    } else {
                        LibraryTreePanel.this.browser.refreshButton.setToolTipText(ToolsRes.getString("LibraryBrowser.Tooltip.Refresh"));
                    }
                }
            });
        }

        @Override
        protected void done() {
        }
    }

    protected static class HTMLPane
    extends JEditorPane {
        public HTMLPane() {
            this.setEditable(false);
            this.setFocusable(false);
            this.setContentType("text/html; charset=UTF-8");
            this.addHyperlinkListener(hyperlinkListener);
            this.addPropertyChangeListener(e -> {
                if (e.getPropertyName().equals("page")) {
                    HTMLDocument document = (HTMLDocument)this.getDocument();
                    document.getStyleSheet().addRule(LibraryResource.getHTMLStyles());
                    document.getStyleSheet().addRule(LibraryResource.getBodyStyle());
                    document.getStyleSheet().addRule(LibraryResource.getH1Style());
                    document.getStyleSheet().addRule(LibraryResource.getH2Style());
                }
            });
        }

        @Override
        public void paintComponent(Graphics g) {
            if (OSPRuntime.antiAliasText) {
                Graphics2D g2 = (Graphics2D)g;
                RenderingHints rh = g2.getRenderingHints();
                rh.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                rh.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            super.paintComponent(g);
        }
    }

    protected class LibraryTreeNodeRenderer
    extends DefaultTreeCellRenderer {
        ResizableIcon resizableOpenIcon = new ResizableIcon(super.getOpenIcon());
        ResizableIcon resizableClosedIcon = new ResizableIcon(super.getClosedIcon());

        LibraryTreeNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            LibraryTreeNode node = (LibraryTreeNode)value;
            Icon icon = node.record.getIcon();
            Color c = this.getForeground();
            if (node.record instanceof LibraryCollection) {
                Icon icon2 = icon = expanded ? this.getOpenIcon() : this.getClosedIcon();
                if (node.getTarget() != null) {
                    icon = LibraryResource.collectionIcon;
                    if (node.getTarget().contains("&OSPSubject=")) {
                        c = Color.RED;
                    }
                }
            }
            this.setToolTipText(node.getToolTip());
            if (icon == null) {
                icon = LibraryResource.unknownIcon;
            }
            this.setIcon(icon);
            this.setForeground(c);
            return this;
        }

        @Override
        public Icon getOpenIcon() {
            return this.resizableOpenIcon;
        }

        @Override
        public Icon getClosedIcon() {
            return this.resizableClosedIcon;
        }
    }

    protected class MetadataComboBoxEditor
    extends Box
    implements ComboBoxEditor {
        JLabel spacer;
        LibraryResource.Metadata metadata;

        MetadataComboBoxEditor() {
            super(0);
            LibraryTreePanel.this.keyEditField = new MetadataEditField(LibraryTreePanel.this, keyFieldWidth){

                @Override
                protected String getDefaultText() {
                    return MetadataComboBoxEditor.this.metadata == ((MetadataComboBoxEditor)MetadataComboBoxEditor.this).LibraryTreePanel.this.emptyMetadata ? ToolsRes.getString("LibraryTreePanel.Metadata.Name") : null;
                }

                @Override
                protected Font getEmptyFont() {
                    return font.deriveFont(3);
                }

                @Override
                protected Font getDefaultFont() {
                    return font.deriveFont(1);
                }
            };
            LibraryTreePanel.this.entryFields.add(LibraryTreePanel.this.keyEditField);
            LibraryTreePanel.this.keyEditField.setHorizontalAlignment(4);
            LibraryTreePanel.this.keyEditField.setFont(LibraryTreePanel.this.keyEditField.getDefaultFont());
            LibraryTreePanel.this.valueEditField = new MetadataEditField(LibraryTreePanel.this, 0){

                @Override
                protected String getDefaultText() {
                    return MetadataComboBoxEditor.this.metadata == ((MetadataComboBoxEditor)MetadataComboBoxEditor.this).LibraryTreePanel.this.emptyMetadata ? ToolsRes.getString("LibraryTreePanel.Metadata.Value") : null;
                }

                @Override
                protected Font getEmptyFont() {
                    return font.deriveFont(2);
                }

                @Override
                protected Font getDefaultFont() {
                    return font.deriveFont(0);
                }
            };
            LibraryTreePanel.this.entryFields.add(LibraryTreePanel.this.valueEditField);
            CompoundBorder border = BorderFactory.createCompoundBorder(LibraryTreePanel.this.keyEditField.getBorder(), BorderFactory.createEmptyBorder(0, 1, 0, 1));
            LibraryTreePanel.this.keyEditField.setBorder(border);
            LibraryTreePanel.this.valueEditField.setBorder(border);
            this.spacer = new JLabel();
            this.spacer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.add(LibraryTreePanel.this.keyEditField);
            this.add(this.spacer);
            this.add(LibraryTreePanel.this.valueEditField);
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public void setItem(Object obj) {
            boolean empty;
            if (obj == null) {
                return;
            }
            this.metadata = (LibraryResource.Metadata)obj;
            boolean bl = empty = this.metadata == LibraryTreePanel.this.emptyMetadata;
            if (empty) {
                LibraryTreePanel.this.keyEditField.setText(ToolsRes.getString("LibraryTreePanel.Metadata.Name"));
                LibraryTreePanel.this.valueEditField.setText(ToolsRes.getString("LibraryTreePanel.Metadata.Value"));
                LibraryTreePanel.this.keyEditField.setForeground(Color.gray);
                LibraryTreePanel.this.valueEditField.setForeground(Color.gray);
                LibraryTreePanel.this.keyEditField.setFont(LibraryTreePanel.this.keyEditField.getEmptyFont());
                LibraryTreePanel.this.valueEditField.setFont(LibraryTreePanel.this.valueEditField.getEmptyFont());
            } else {
                LibraryTreePanel.this.keyEditField.setText(this.metadata.getData()[0]);
                LibraryTreePanel.this.keyEditField.setCaretPosition(0);
                LibraryTreePanel.this.valueEditField.setText(this.metadata.getData()[1]);
                LibraryTreePanel.this.valueEditField.setCaretPosition(0);
                LibraryTreePanel.this.keyEditField.setForeground(defaultForeground);
                LibraryTreePanel.this.valueEditField.setForeground(defaultForeground);
                LibraryTreePanel.this.keyEditField.setFont(LibraryTreePanel.this.keyEditField.getDefaultFont());
                LibraryTreePanel.this.valueEditField.setFont(LibraryTreePanel.this.valueEditField.getDefaultFont());
            }
            LibraryTreePanel.this.keyEditField.setBackground(Color.white);
            LibraryTreePanel.this.valueEditField.setBackground(Color.white);
        }

        @Override
        public Object getItem() {
            return this.metadata;
        }

        @Override
        public void selectAll() {
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }
    }

    protected class MetadataComboBoxModel
    extends AbstractListModel<LibraryResource.Metadata>
    implements ComboBoxModel<LibraryResource.Metadata> {
        protected MetadataComboBoxModel() {
        }

        @Override
        public int getSize() {
            LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
            if (node == null) {
                return 0;
            }
            TreeSet<LibraryResource.Metadata> data = node.record.getMetadata();
            if (data == null) {
                return 1;
            }
            return data.size() + 1;
        }

        @Override
        public LibraryResource.Metadata getElementAt(int index) {
            LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
            if (node == null) {
                return LibraryTreePanel.this.emptyMetadata;
            }
            TreeSet<LibraryResource.Metadata> data = node.record.getMetadata();
            if (data == null) {
                return LibraryTreePanel.this.emptyMetadata;
            }
            int i = 0;
            for (LibraryResource.Metadata next : data) {
                if (index == i) {
                    return next;
                }
                ++i;
            }
            return LibraryTreePanel.this.emptyMetadata;
        }

        @Override
        public void setSelectedItem(Object obj) {
            LibraryResource.Metadata metadata;
            if (obj == null || !(obj instanceof LibraryResource.Metadata)) {
                return;
            }
            LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
            if (node == null) {
                return;
            }
            node.selectedMetadata = metadata = (LibraryResource.Metadata)obj;
        }

        @Override
        public Object getSelectedItem() {
            LibraryTreeNode node = LibraryTreePanel.this.getSelectedNode();
            if (node == null) {
                return null;
            }
            LibraryResource.Metadata metadata = node.selectedMetadata;
            return metadata;
        }

        void dataChanged() {
            if (this.getSize() > 0) {
                this.fireContentsChanged(this, 0, this.getSize() - 1);
            }
        }

        void dataAdded() {
            if (this.getSize() > 0) {
                this.fireIntervalAdded(this, 0, this.getSize() - 1);
            }
        }

        void dataRemoved() {
            if (this.getSize() > 0) {
                this.fireIntervalRemoved(this, 0, this.getSize() - 1);
            }
        }
    }

    protected class MetadataComboBoxRenderer
    extends Box
    implements ListCellRenderer<LibraryResource.Metadata> {
        JTextField keyField;
        JTextField valueField;
        JLabel spacer;

        public MetadataComboBoxRenderer() {
            super(0);
            this.keyField = new JTextField(){

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }

                @Override
                public Dimension getPreferredSize() {
                    return ((MetadataComboBoxRenderer)MetadataComboBoxRenderer.this).LibraryTreePanel.this.keyEditField.getPreferredSize();
                }
            };
            this.keyField.setHorizontalAlignment(4);
            this.keyField.setFont(this.keyField.getFont().deriveFont(1));
            this.valueField = new JTextField(){

                @Override
                public Dimension getMaximumSize() {
                    return ((MetadataComboBoxRenderer)MetadataComboBoxRenderer.this).LibraryTreePanel.this.valueEditField.getMaximumSize();
                }

                @Override
                public Dimension getPreferredSize() {
                    return this.getMinimumSize();
                }
            };
            CompoundBorder border = BorderFactory.createCompoundBorder(this.keyField.getBorder(), BorderFactory.createEmptyBorder(0, 1, 0, 1));
            this.keyField.setBorder(border);
            this.valueField.setBorder(border);
            this.spacer = new JLabel();
            this.spacer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.add(this.keyField);
            this.add(this.spacer);
            this.add(this.valueField);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends LibraryResource.Metadata> list, LibraryResource.Metadata value, int index, boolean isSelected, boolean cellHasFocus) {
            boolean empty = false;
            if (value != null && value instanceof LibraryResource.Metadata) {
                LibraryResource.Metadata metadata = value;
                boolean bl = empty = metadata == LibraryTreePanel.this.emptyMetadata;
                if (empty) {
                    this.keyField.setText(ToolsRes.getString("LibraryTreePanel.Metadata.Name"));
                    this.valueField.setText(ToolsRes.getString("LibraryTreePanel.Metadata.Value"));
                    this.keyField.setFont(LibraryTreePanel.this.keyEditField.getEmptyFont());
                    this.valueField.setFont(LibraryTreePanel.this.valueEditField.getEmptyFont());
                } else {
                    this.keyField.setText(metadata.getData()[0]);
                    this.valueField.setText(metadata.getData()[1]);
                    this.keyField.setFont(LibraryTreePanel.this.keyEditField.getDefaultFont());
                    this.valueField.setFont(LibraryTreePanel.this.valueEditField.getDefaultFont());
                }
            }
            if (isSelected) {
                this.keyField.setBackground(list.getSelectionBackground());
                this.keyField.setForeground(empty ? Color.gray : list.getSelectionForeground());
                this.valueField.setBackground(list.getSelectionBackground());
                this.valueField.setForeground(empty ? Color.gray : list.getSelectionForeground());
            } else {
                this.keyField.setBackground(list.getBackground());
                this.keyField.setForeground(empty ? Color.gray : list.getForeground());
                this.valueField.setBackground(list.getBackground());
                this.valueField.setForeground(empty ? Color.gray : list.getForeground());
            }
            return this;
        }
    }

    protected class MetadataEditField
    extends EntryField {
        int preferredWidth;

        MetadataEditField(int width) {
            this.preferredWidth = width;
            this.addActionListener(LibraryTreePanel.this.metadataFieldListener);
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension dim = super.getMaximumSize();
            dim.height = this.getPreferredSize().height;
            if (this.preferredWidth > 0) {
                dim.width = this.preferredWidth;
            }
            return dim;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dim = super.getMinimumSize();
            if (this.preferredWidth > 0) {
                dim.width = this.preferredWidth;
            }
            return dim;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            if (this.preferredWidth > 0) {
                dim.width = this.preferredWidth;
            }
            return dim;
        }
    }

    class MetadataLoader
    extends SwingWorker<Void, Void> {
        boolean canceled = false;
        List<String> treePath;

        MetadataLoader(List<String> treePath) {
            this.treePath = treePath;
        }

        void cancel() {
            this.canceled = true;
        }

        @Override
        public Void doInBackground() {
            if (!OSPRuntime.isJS) {
                this.setupAndRunLoaders();
            }
            return null;
        }

        private void setupAndRunLoaders() {
            final ArrayList<NodeLoader> nodeLoaders = new ArrayList<NodeLoader>();
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    MetadataLoader.this.finalizeLoader((NodeLoader)e.getSource(), nodeLoaders, e.getPropertyName());
                }
            };
            Enumeration<TreeNode> e = LibraryTreePanel.this.rootNode.preorderEnumeration();
            while (e.hasMoreElements()) {
                LibraryTreeNode node = (LibraryTreeNode)e.nextElement();
                NodeLoader nodeLoader = new NodeLoader(node);
                nodeLoaders.add(nodeLoader);
                nodeLoader.addPropertyChangeListener(listener);
            }
            if (OSPRuntime.allowBackgroundNodeLoading) {
                ((NodeLoader)nodeLoaders.get(0)).execute();
            }
        }

        protected void finalizeLoader(NodeLoader nodeLoader, ArrayList<NodeLoader> nodeLoaders, String propName) {
            if (nodeLoader.isDone()) {
                if (this.canceled) {
                    return;
                }
                int i = nodeLoaders.indexOf(nodeLoader);
                if (i + 1 < nodeLoaders.size()) {
                    nodeLoader = nodeLoaders.get(i + 1);
                    nodeLoader.execute();
                } else {
                    this.canceled = true;
                    File cacheFile = ResourceLoader.getSearchCacheFile(LibraryTreePanel.this.pathToRoot);
                    XMLControlElement control = new XMLControlElement(LibraryTreePanel.this.rootNode.record);
                    control.setValue("real_path", LibraryTreePanel.this.pathToRoot);
                    control.write(cacheFile.getAbsolutePath());
                    LibraryTreePanel.this.setSelectionPath(this.treePath);
                    Enumeration<TreeNode> en = LibraryTreePanel.this.rootNode.preorderEnumeration();
                    while (en.hasMoreElements()) {
                        LibraryTreeNode node = (LibraryTreeNode)en.nextElement();
                        if (!(node.record instanceof LibraryCollection)) continue;
                        node.record.setDescription(null);
                        htmlPanesByNode.remove(node);
                    }
                    if (LibraryTreePanel.this.browser.libraryManager != null) {
                        LibraryTreePanel.this.browser.libraryManager.refreshSearchTab();
                    }
                    LibraryTreePanel.this.showInfo(LibraryTreePanel.this.getSelectedNode(), "LibraryTreePanel.propChange " + propName);
                    if (LibraryTreePanel.this.browser.metadataLoaderListener != null) {
                        PropertyChangeEvent event = new PropertyChangeEvent(LibraryTreePanel.this.browser, LibraryTreePanel.this.pathToRoot, null, cacheFile);
                        LibraryTreePanel.this.browser.metadataLoaderListener.propertyChange(event);
                    }
                }
            }
        }
    }

    class NodeLoader
    extends SwingWorker<Void, Void> {
        LibraryTreeNode node;
        boolean hasNewChildren = false;

        NodeLoader(LibraryTreeNode treeNode) {
            this.node = treeNode;
        }

        @Override
        public Void doInBackground() {
            this.loadNodeAsync(this.node);
            return null;
        }

        public void loadNodeAsync(LibraryTreeNode node) {
            boolean isZip;
            String htmlPath = node.getHTMLPath();
            String target = node.getAbsoluteTarget();
            boolean bl = isZip = target != null && (target.toLowerCase().endsWith(".zip") || target.toLowerCase().endsWith(".trz"));
            if (isZip) {
                boolean loadzip;
                if (node.record != null && node.record.hasExternalHTML()) {
                    this.loadPathAsync(htmlPath, target);
                    return;
                }
                boolean bl2 = loadzip = ResourceLoader.isWebConnected() || !ResourceLoader.isHTTP(target);
                if (loadzip && node.getTargetURL() != null) {
                    String base = node.getBasePath();
                    this.loadZipPathAsync(htmlPath, target, node.getTargetURL().toExternalForm(), base);
                }
            } else {
                this.loadPathAsync(htmlPath, target);
            }
        }

        private void loadZipPathAsync(String htmlPath, String target, String targetURLPath, String base) {
            ResourceLoader.getZipContentsAsync(targetURLPath, files -> {
                if (files == null) {
                    return null;
                }
                String target_urlPath = XML.forwardSlash(targetURLPath);
                if (target_urlPath.startsWith("file:/")) {
                    target_urlPath = target_urlPath.substring(6, target_urlPath.length());
                } else if (target_urlPath.startsWith("file::/")) {
                    target_urlPath = target_urlPath.substring(7, target_urlPath.length());
                }
                String targetRelativePath = XML.getPathRelativeTo(target_urlPath, base);
                String targetName = XML.stripExtension(targetRelativePath);
                String htmlRelativePath = LibraryTreePanel.getRelativePath(files, targetName);
                if (htmlRelativePath == null) {
                    this.loadPathAsync(htmlPath, target);
                    return null;
                }
                String htmlCodePath = String.valueOf(targetURLPath) + "!/" + htmlRelativePath;
                String targetPath = String.valueOf(targetName) + "." + XML.getExtension(target) + "!/" + htmlRelativePath;
                ResourceLoader.getHTMLCodeAsync(htmlCodePath, htmlCode -> {
                    this.loadNodeFromMetadata(htmlCodePath, (String)htmlCode, target, targetPath);
                    return null;
                });
                return null;
            });
        }

        protected void loadNodeFromMetadata(String htmlCodePath, String htmlCode, String target, String targetPath) {
            this.node.metadataSource = htmlCode;
            String redirect = LibraryBrowser.getRedirectFromHTMLCode(htmlCode);
            if (redirect != null) {
                this.node.record.setHTMLPath(redirect);
            } else {
                this.node.record.setHTMLPath(targetPath);
            }
            String title = ResourceLoader.getTitleFromHTMLCode(htmlCode);
            if (title != null) {
                this.node.record.setName(title);
            }
            this.loadPathAsync(htmlCodePath, target);
        }

        private void loadPathAsync(final String htmlPath, String target) {
            String reloadUrlPath = this.node.record.getProperty("reload_url");
            if (reloadUrlPath != null) {
                target = reloadUrlPath;
            }
            if (!LibraryComPADRE.isComPADREPath(target)) {
                this.processNode(htmlPath);
                return;
            }
            if (this.node.record instanceof LibraryCollection) {
                this.hasNewChildren = false;
                final LibraryTreeNode n = this.node;
                Runnable onSuccess = new Runnable(){

                    @Override
                    public void run() {
                        NodeLoader.this.hasNewChildren = true;
                        NodeLoader.this.processNode(htmlPath);
                        String s = "\"" + n.getName() + "\"";
                        System.out.println("OK - LTP " + s);
                    }
                };
                Runnable onFailure = new Runnable(){

                    @Override
                    public void run() {
                        ((NodeLoader)NodeLoader.this).LibraryTreePanel.this.browser.setCursor(Cursor.getDefaultCursor());
                        String s = "\"" + n.getName() + "\"";
                        NodeLoader.this.warnNoResource(s);
                    }
                };
                LibraryComPADRE.loadResources(n, onSuccess, onFailure);
            } else if ("".equals(this.node.record.getDescription()) && reloadUrlPath != null) {
                LibraryComPADRE.reloadResource(this.node, reloadUrlPath, () -> this.processNode(htmlPath));
            }
        }

        protected void warnNoResource(String s) {
            System.out.println("WARN - LibraryTreePanel " + s);
        }

        protected void processNode(String htmlPath) {
            if (htmlPath != null) {
                File cachedFile;
                boolean foundInCache;
                boolean requiresCache = htmlPath.contains("!/");
                if (requiresCache && !(foundInCache = (cachedFile = ResourceLoader.getOSPCacheFile(htmlPath)).exists())) {
                    ResourceLoader.copyHTMLToOSPCache(htmlPath);
                }
            } else if (this.node.record.getProperty("reload_url") == null) {
                this.node.record.setDescription(null);
            }
            htmlPanesByNode.remove(this.node);
            LibraryTreeNode.htmlURLs.remove(htmlPath);
            this.node.getMetadata();
            this.doneAsync();
        }

        protected void doneAsync() {
            SwingUtilities.invokeLater(() -> {
                htmlPanesByNode.remove(this.node);
                htmlPanesByURL.remove(this.node.getHTMLURL());
                if (this.hasNewChildren) {
                    this.node.createChildNodes();
                    LibraryTreePanel.this.treeModel.nodeStructureChanged(this.node);
                } else {
                    LibraryTreePanel.this.treeModel.nodeChanged(this.node);
                }
                if (this.node == LibraryTreePanel.this.getSelectedNode()) {
                    LibraryTreePanel.this.showInfo(this.node, "LibraryTreePanel.NodeLoader.run");
                }
                if (this.node == LibraryTreePanel.this.rootNode) {
                    LibraryTreePanel.this.browser.refreshTabTitle(LibraryTreePanel.this.pathToRoot, LibraryTreePanel.this.rootResource);
                }
            });
        }

        @Override
        protected void done() {
        }
    }
}

