/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.util.ArrayList;
import java.util.BitSet;
import javax.swing.JCheckBox;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;

public class ParamEditor
extends FunctionEditor {
    protected double[] paramValues = new double[0];
    private DatasetManager data;
    private FunctionEditor[] functionEditors;
    protected String[] paramDescriptions = new String[0];
    protected JCheckBox syncedCheckbox;
    protected boolean syncing = false;

    public ParamEditor() {
        this.paramEditor = this;
    }

    public ParamEditor(DatasetManager input) {
        this();
        this.data = input;
        this.loadParametersFromData();
    }

    @Override
    protected void createGUI() {
        super.createGUI();
        if (this.syncedCheckbox == null) {
            this.syncedCheckbox = new JCheckBox();
            this.syncedCheckbox.addActionListener(e -> this.doSyncAction());
        }
    }

    @Override
    public void refreshGUI() {
        super.refreshGUI();
        if (this.syncedCheckbox != null) {
            this.syncedCheckbox.setText(ToolsRes.getString("ParamEditor.Checkbox.Synced.Text"));
        }
    }

    @Override
    protected void enableMenuButtons() {
        super.enableMenuButtons();
        if (this.syncedCheckbox != null) {
            Parameter param = (Parameter)this.getSelectedObject();
            this.syncedCheckbox.setEnabled(param != null && param.isNameEditable());
            this.syncedCheckbox.setSelected(param != null && param.isSynced());
            String tooltip = ToolsRes.getString("ParamEditor.Checkbox.Synced.Tooltip");
            if (param != null && param.isNameEditable()) {
                tooltip = String.valueOf(tooltip) + " \"" + param.getName() + "\"";
            }
            this.syncedCheckbox.setToolTipText(tooltip);
        }
    }

    protected void doSyncAction() {
        boolean sync = this.syncedCheckbox.isSelected();
        Parameter param = (Parameter)this.getSelectedObject();
        if (param == null || !param.isNameEditable() || sync == param.isSynced()) {
            return;
        }
        param.setSynced(sync);
        this.firePropertyChange("synced", null, param);
    }

    public Parameter[] getParameters() {
        Parameter[] params = new Parameter[this.objects.size()];
        int i = 0;
        while (i < this.objects.size()) {
            Parameter next = (Parameter)this.objects.get(i);
            params[i] = new Parameter(next.paramName, next.expression);
            params[i].setExpressionEditable(next.isExpressionEditable());
            params[i].setNameEditable(next.isNameEditable());
            params[i].setDescription(next.getDescription());
            params[i].value = next.value;
            params[i].synced = next.synced;
            ++i;
        }
        return params;
    }

    public void setParameters(Parameter[] params) {
        ArrayList<FunctionEditor.FObject> list = new ArrayList<FunctionEditor.FObject>();
        int i = 0;
        while (i < params.length) {
            list.add(params[i]);
            ++i;
        }
        this.setObjects(list);
        if (this.haveGUI()) {
            this.updateTable();
        }
    }

    public void setFunctionEditors(FunctionEditor[] editors) {
        this.functionEditors = editors;
        if (this.functionEditors == null) {
            this.paramEditor = null;
        }
    }

    public double[] getValues() {
        return this.paramValues;
    }

    public String[] getDescriptions() {
        return this.paramDescriptions;
    }

    @Override
    public String getName(FunctionEditor.FObject obj) {
        return obj == null ? null : ((Parameter)obj).paramName;
    }

    @Override
    public String getExpression(FunctionEditor.FObject obj) {
        return obj == null ? null : ((Parameter)obj).expression;
    }

    @Override
    public String getDescription(FunctionEditor.FObject obj) {
        return obj == null ? null : ((Parameter)obj).getDescription();
    }

    @Override
    public void setDescription(FunctionEditor.FObject obj, String desc) {
        if (obj != null) {
            Parameter p = (Parameter)obj;
            if (desc != null && desc.trim().equals("")) {
                desc = null;
            }
            p.setDescription(desc);
            super.setDescription(obj, desc);
        }
    }

    public void setDescription(String name, String description) {
        for (FunctionEditor.FObject obj : this.objects) {
            Parameter param = (Parameter)obj;
            if (!param.getName().equals(name)) continue;
            this.setDescription(obj, description);
            break;
        }
    }

    public void setSyncing(boolean sync) {
        this.syncing = sync;
        if (this.getButtonPanel() == null) {
            return;
        }
        if (this.syncing) {
            this.getButtonPanel().add(this.syncedCheckbox);
        } else {
            this.getButtonPanel().remove(this.syncedCheckbox);
        }
    }

    @Override
    public String getTooltip(FunctionEditor.FObject obj) {
        String s = ((Parameter)obj).getDescription();
        if (s == null) {
            s = ToolsRes.getString("ParamEditor.Table.Cell.Name.Tooltip");
            s = String.valueOf(s) + " (" + ToolsRes.getString("FunctionEditor.Tooltip.HowToEdit") + ")";
        }
        return s;
    }

    @Override
    public boolean isNameEditable(FunctionEditor.FObject obj) {
        return ((Parameter)obj).isNameEditable();
    }

    @Override
    public boolean isExpressionEditable(FunctionEditor.FObject obj) {
        return ((Parameter)obj).isExpressionEditable();
    }

    protected void evaluateObject(FunctionEditor.FObject obj) {
        Parameter p = (Parameter)obj;
        p.evaluate(this.objects);
    }

    public ArrayList<Parameter> evaluateDependents(Parameter seed) {
        ArrayList<Parameter> temp = new ArrayList<Parameter>();
        int i = this.evaluate.size();
        while (--i >= 0) {
            Parameter p;
            Parameter param = (Parameter)this.evaluate.get(i);
            if (!param.paramName.equals(seed.paramName)) continue;
            temp.add(seed);
            int j = i + 1;
            while (j < this.evaluate.size()) {
                p = (Parameter)this.evaluate.get(j);
                temp.add(new Parameter(p.paramName, p.expression));
                ++j;
            }
            j = temp.size();
            while (--j >= 0) {
                p = temp.get(j);
                p.evaluate(temp);
                this.referencesChecked.clear();
                if (this.references(p.getName(), this.referencesChecked)) continue;
                temp.remove(j);
            }
            temp.remove(seed);
            return temp;
        }
        return temp;
    }

    @Override
    public void evaluateAll() {
        Parameter p;
        this.setArrays();
        if (this.getClass() != ParamEditor.class) {
            return;
        }
        if (this.paramValues.length != this.objects.size()) {
            this.paramValues = new double[this.objects.size()];
        }
        int i = 0;
        while (i < this.evaluate.size()) {
            p = (Parameter)this.evaluate.get(i);
            p.evaluate(this.objects);
            ++i;
        }
        if (this.paramDescriptions.length != this.objects.size()) {
            this.paramDescriptions = new String[this.objects.size()];
        }
        i = 0;
        while (i < this.objects.size()) {
            p = (Parameter)this.objects.get(i);
            this.paramValues[i] = p.getValue();
            this.paramDescriptions[i] = p.getDescription();
            ++i;
        }
    }

    @Override
    protected boolean isDisallowedName(FunctionEditor.FObject obj, String name) {
        boolean disallowed = super.isDisallowedName(obj, name);
        if (!disallowed && obj != null && this.getName(obj).equals(name)) {
            return false;
        }
        if (this.functionEditors != null) {
            int i = 0;
            while (i < this.functionEditors.length) {
                disallowed = disallowed || this.functionEditors[i].isDisallowedName(null, name);
                ++i;
            }
        }
        return disallowed;
    }

    @Override
    protected void pasteAction() {
        this.getClipboardContentsAsync(controls -> {
            if (controls == null) {
                return;
            }
            int i = 0;
            while (i < ((XMLControl[])controls).length) {
                Parameter param = (Parameter)controls[i].loadObject(null);
                param.setNameEditable(true);
                param.setExpressionEditable(true);
                this.addObject(param, true);
                ++i;
            }
            this.evaluateAll();
        });
    }

    @Override
    protected boolean isInvalidExpression(FunctionEditor.FObject obj) {
        return Double.isNaN(((Parameter)obj).getValue());
    }

    @Override
    protected FunctionEditor.FObject createObject(String name, String expression, FunctionEditor.FObject obj) {
        Parameter original = (Parameter)obj;
        if (original != null && original.paramName.equals(name) && original.expression.equals(expression)) {
            return original;
        }
        Parameter p = new Parameter(name, expression);
        if (original != null) {
            p.setExpressionEditable(original.isExpressionEditable());
            p.setNameEditable(original.isNameEditable());
            p.setDescription(original.getDescription());
            p.setSynced(original.isSynced());
        }
        return p;
    }

    @Override
    protected void setTitles() {
        this.newButtonTipText = ToolsRes.getString("ParamEditor.Button.New.Tooltip");
        this.titledBorderText = ToolsRes.getString("ParamEditor.Border.Title");
    }

    public void loadParametersFromData() {
        if (this.data == null) {
            return;
        }
        for (String name : this.data.getConstantNames()) {
            String expression = this.data.getConstantExpression(name);
            Parameter p = (Parameter)this.getObject(name);
            if (p == null) {
                p = new Parameter(name, expression);
                p.setDescription(this.data.getConstantDescription(name));
                this.addObject(p, false);
                continue;
            }
            this.setExpression(name, expression, false);
        }
    }

    protected void refreshParametersFromFunction(UserFunction f) {
        int i = 0;
        while (i < f.getParameterCount()) {
            String name = f.getParameterName(i);
            String val = String.valueOf(f.getParameterValue(i));
            Parameter p = (Parameter)this.getObject(name);
            if (p == null) {
                p = new Parameter(name, val);
                p.setNameEditable(false);
                p.setExpressionEditable(false);
                this.addObject(p, false);
            } else {
                this.setExpression(name, val, false);
            }
            ++i;
        }
    }

    @Override
    protected String getDefaultName() {
        return ToolsRes.getString("ParamEditor.New.Name.Default");
    }

    @Override
    protected boolean isImportant(FunctionEditor.FObject obj) {
        return false;
    }

    @Override
    protected void setReferences(FunctionEditor.FObject obj, BitSet directReferences) {
    }
}

