/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.util.List;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.numerics.ParsedMultiVarFunction;
import org.opensourcephysics.numerics.ParserException;
import org.opensourcephysics.tools.FunctionEditor;

public class Parameter
implements FunctionEditor.FObject {
    public static final String PROPERTY_PARAMETER_SYNCED = "synced";
    final String paramName;
    final String expression;
    String description;
    double value = Double.NaN;
    boolean expressionEditable = true;
    boolean nameEditable = true;
    boolean synced = false;

    public Parameter(String name, String function) {
        this.paramName = name;
        this.expression = function;
    }

    public Parameter(String name, String function, String desc) {
        this(name, function);
        this.setDescription(desc);
    }

    public String getName() {
        return this.paramName;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public double getValue() {
        return this.value;
    }

    public boolean isExpressionEditable() {
        return this.expressionEditable;
    }

    public void setExpressionEditable(boolean edit) {
        this.expressionEditable = edit;
    }

    public boolean isNameEditable() {
        return this.nameEditable;
    }

    public void setNameEditable(boolean edit) {
        this.nameEditable = edit;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public void setSynced(boolean sync) {
        this.synced = sync;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Parameter) {
            Parameter p = (Parameter)obj;
            return p.getName().equals(this.paramName) && p.getExpression().equals(this.expression) && p.isExpressionEditable() == this.expressionEditable && p.isNameEditable() == this.nameEditable;
        }
        return false;
    }

    protected double evaluate(List<?> parameters) {
        int n = parameters.contains(this) ? parameters.size() - 1 : parameters.size();
        Parameter[] array = new Parameter[n];
        int j = 0;
        int i = 0;
        while (i < parameters.size()) {
            Parameter next = (Parameter)parameters.get(i);
            if (next != this) {
                array[j++] = next;
            }
            ++i;
        }
        return this.evaluate(array);
    }

    public double evaluate(Parameter[] parameters) {
        int n = parameters.length;
        String[] names = new String[n];
        double[] values = new double[n];
        int i = 0;
        while (i < n) {
            names[i] = parameters[i].paramName;
            values[i] = parameters[i].value;
            ++i;
        }
        try {
            String express = this.expression;
            String[] temp = new String[]{"if", "atan2", "min", "max", "mod"};
            boolean replace = true;
            int i2 = 0;
            while (i2 < temp.length) {
                replace = replace && express.indexOf(temp[i2]) == -1;
                ++i2;
            }
            if (replace) {
                express = express.replaceAll(",", ".");
            }
            ParsedMultiVarFunction f = new ParsedMultiVarFunction(express, names, false);
            this.value = f.evaluate(values);
        }
        catch (ParserException ex) {
            this.value = Double.NaN;
        }
        return this.value;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public String toString() {
        return "[Parameter " + this.paramName + "=" + this.expression + " = " + this.value + "]";
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            Parameter p = (Parameter)obj;
            control.setValue("name", p.getName());
            control.setValue("function", p.getExpression());
            control.setValue("editable", p.isExpressionEditable());
            control.setValue("name_editable", p.isNameEditable());
            control.setValue("description", p.getDescription());
            control.setValue(Parameter.PROPERTY_PARAMETER_SYNCED, p.isSynced());
        }

        @Override
        public Object createObject(XMLControl control) {
            String name = control.getString("name");
            String f = control.getString("function");
            return new Parameter(name, f);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            Parameter p = (Parameter)obj;
            if (control.getPropertyNamesRaw().contains("editable")) {
                p.setExpressionEditable(control.getBoolean("editable"));
            }
            if (control.getPropertyNamesRaw().contains("name_editable")) {
                p.setNameEditable(control.getBoolean("name_editable"));
            }
            if (control.getPropertyNamesRaw().contains(Parameter.PROPERTY_PARAMETER_SYNCED)) {
                p.setSynced(control.getBoolean(Parameter.PROPERTY_PARAMETER_SYNCED));
            }
            p.setDescription(control.getString("description"));
            return obj;
        }
    }
}

