/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.applet.AudioClip;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.tools.ResourceLoader;

public class Resource {
    private URL url;
    private File file;
    private boolean isAnImage = true;
    private ImageIcon icon;
    private String string;
    private AudioClip clip;
    private BufferedImage image;
    private URL contentURL;
    private boolean isBytes;
    private String shortClassName;

    public static Charset getCharset() {
        return ResourceLoader.defaultCharset;
    }

    public Resource(URL url) {
        this.url = url;
    }

    public Resource(File file) {
        if (file.toString().indexOf("!/") >= 0) {
            this.url = ResourceLoader.getJarURLForFile(file.getAbsolutePath());
        } else {
            this.file = file;
        }
    }

    protected Resource(URL zipURL, String content) {
        this.url = zipURL;
        if (content != null) {
            try {
                String path = String.valueOf(zipURL.toExternalForm()) + "!/" + content;
                this.contentURL = new URL(path);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public String getAbsolutePath() {
        if (this.getFile() != null) {
            try {
                return XML.forwardSlash(this.getFile().getCanonicalPath());
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return this.getFile().getAbsolutePath();
            }
        }
        if (this.getURL() != null) {
            String path = this.getURL().toExternalForm();
            return path;
        }
        return null;
    }

    public URL getURL() {
        if (this.url == null && this.file != null) {
            String path = this.getAbsolutePath();
            try {
                this.url = path.startsWith("/") ? new URL("file:" + path) : new URL("file:/" + path);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        if (this.contentURL != null) {
            return this.contentURL;
        }
        return this.url;
    }

    public File getFile() {
        return this.file;
    }

    public Object getObject(Class<?> type) {
        if (ImageIcon.class.equals(type)) {
            return this.getResizableIcon();
        }
        if (String.class.equals(type)) {
            return this.getString();
        }
        return null;
    }

    public InputStream openInputStream() {
        if (this.getFile() != null) {
            try {
                return new FileInputStream(this.getFile());
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        if (this.url != null) {
            try {
                if (this.contentURL != null) {
                    return ResourceLoader.openZipEntryStream(this.contentURL, this.url);
                }
                return ResourceLoader.openStream(this.url);
            }
            catch (IOException ex) {
                OSPLog.fine("Resource file not found " + this.url);
            }
        }
        return null;
    }

    public BufferedReader openReader() {
        return this.openReader(null);
    }

    private BufferedReader openReader(String encoding) {
        return ResourceLoader.readerForStream(this.openInputStream(), encoding);
    }

    public ImageIcon getImageIcon() {
        if (this.icon == null && this.isAnImage) {
            this.icon = new ImageIcon(this.getURL());
            if (this.icon.getIconWidth() < 1) {
                this.icon = null;
                this.isAnImage = false;
                return null;
            }
        }
        return this.icon;
    }

    public ResizableIcon getResizableIcon() {
        ImageIcon icon = this.getImageIcon();
        return icon == null ? null : new ResizableIcon(icon);
    }

    public Image getImage() {
        if (this.isBytes) {
            return this.icon.getImage();
        }
        ImageIcon icon = this.getImageIcon();
        return icon == null ? null : icon.getImage();
    }

    public BufferedImage getBufferedImage() {
        return this.getBufferedImage(1);
    }

    public BufferedImage getBufferedImage(int bufferedImageType) {
        if (this.isAnImage && (this.image == null || this.image.getType() != bufferedImageType)) {
            Image im = this.getImage();
            if (im == null) {
                this.isAnImage = false;
            } else {
                this.image = new BufferedImage(im.getWidth(null), im.getHeight(null), bufferedImageType);
                Graphics2D g2 = this.image.createGraphics();
                g2.drawImage(im, 0, 0, null);
                g2.dispose();
            }
        }
        return this.image;
    }

    public String getString() {
        if (this.string == null) {
            StringBuffer buffer = new StringBuffer();
            try {
                BufferedReader in = this.openReader();
                String line = in.readLine();
                while (line != null) {
                    buffer.append(String.valueOf(line) + XML.NEW_LINE);
                    line = in.readLine();
                }
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.string = buffer.toString();
        }
        return this.string;
    }

    public String getString(String encoding) {
        if (this.string == null) {
            StringBuffer buffer = new StringBuffer();
            try {
                BufferedReader in = new BufferedReader(this.openReader(encoding));
                String line = in.readLine();
                while (line != null) {
                    buffer.append(String.valueOf(line) + XML.NEW_LINE);
                    line = in.readLine();
                }
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.string = buffer.toString();
        }
        return this.string;
    }

    public String getXMLClassName() {
        if (this.shortClassName != null) {
            return this.shortClassName;
        }
        try {
            String name = XMLControlElement.getClassName(new String(ResourceLoader.getLimitedStreamBytes(this.openInputStream(), 300L, null, true)));
            this.shortClassName = name.substring(name.lastIndexOf(46) + 1);
            return this.shortClassName;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public AudioClip getAudioClip() {
        if (this.clip == null && this.getURL() != null) {
            this.clip = JApplet.newAudioClip(this.getURL());
        }
        return this.clip;
    }

    public String toString() {
        return "[resource " + (this.file != null ? this.file.toString() : (this.url != null ? this.url.toString() : null)) + "]";
    }

    public static Resource newImageResource(byte[] bytes) {
        Resource res = new Resource(null);
        res.icon = new ImageIcon(bytes);
        res.isBytes = true;
        return res;
    }
}

