/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javajs.async.Assets;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.LibraryBrowser;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ToolsRes;

public class ResourceLoader {
    public static File tempDirFile = new File(OSPRuntime.tempDir);
    private static final String encoding = "UTF-8";
    static final Charset defaultCharset = Charset.forName("UTF-8");
    protected static final String WIN_XP_DEFAULT_CACHE = "/Local Settings/Application Data/OSP/Cache";
    protected static final String WINDOWS_DEFAULT_CACHE = "/AppData/Local/OSP/Cache";
    protected static final String OSX_DEFAULT_CACHE = "/Library/Caches/OSP";
    protected static final String LINUX_DEFAULT_CACHE = "/.config/OSP/Cache";
    protected static final String SEARCH_CACHE_SUBDIRECTORY = "Search";
    protected static final int WEB_CONNECTION_RETRY = 1;
    protected static ArrayList<String> searchPaths = new ArrayList();
    protected static ArrayList<String> appletSearchPaths = new ArrayList();
    protected static int maxPaths = 20;
    protected static Hashtable<String, Resource> resources = new Hashtable();
    protected static boolean cacheEnabled = OSPRuntime.resCacheEnabled;
    protected static boolean canceled = false;
    protected static Map<String, URLClassLoader> zipLoaders = OSPRuntime.checkZipLoaders ? new TreeMap() : null;
    protected static URLClassLoader xsetZipLoader;
    protected static Set<String> extractExtensions;
    protected static ArrayList<String> pathsNotFound;
    protected static File ospCache;
    public static boolean warningShown;
    public static final FileFilter OSP_CACHE_FILTER;
    protected static boolean webConnected;
    public static boolean ignoreMissingWebConnection;
    protected static String downloadURL;
    private static Boolean webTestOK;
    private static File defaultOSPCache;
    private static Map<String, Map<String, ZipEntry>> htZipContents;
    private static List<String> openPDFs;
    private static final Map<String, Bundle> bundleCache;
    private static final String latinChars = "\u00e1\u00e1\u00c1\u00c1\u00e9\u00e9\u00c9\u00c9\u00ed\u00ed\u00cd\u00cd\u00f3\u00f3\u00d3\u00d3\u00fa\u00fa\u00da\u00da\u00f1\u00f1\u00d1\u00d1\u00fc\u00fc\u00dc\u00dc\u00a1\u00a1\u00bf\u00bf";
    private static Map<String, String> langMap;
    private static Locale myLocale;
    private static String localeChars;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int YES_TO_ALL = 2;
    public static final int NO_TO_ALL = 3;
    public static final int CANCEL = 4;

    static {
        extractExtensions = new TreeSet<String>();
        pathsNotFound = new ArrayList();
        warningShown = false;
        OSP_CACHE_FILTER = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && file.getName().startsWith("osp-");
            }
        };
        ignoreMissingWebConnection = false;
        downloadURL = "";
        new Thread(() -> {
            webConnected = OSPRuntime.isJS ? true : ResourceLoader.isWebConnected();
        }, "ResourceLoader.isWebConnected").start();
        htZipContents = new HashMap<String, Map<String, ZipEntry>>();
        openPDFs = new ArrayList<String>();
        bundleCache = new Hashtable<String, Bundle>();
        myLocale = null;
    }

    static void clearWebTest() {
        webTestOK = null;
    }

    private ResourceLoader() {
    }

    public static Resource getResource(String name) {
        return ResourceLoader.getResource(name, true, false);
    }

    public static Resource getResourceZipURLsOK(String name) {
        return ResourceLoader.getResource(name, true, true);
    }

    public static Resource getResource(String name, Class<?> type) {
        return ResourceLoader.findResource(name, type, false, false);
    }

    public static URL getTextURL(String name, Class<?> type) {
        Resource res = ResourceLoader.getResource(name, type, true, false);
        return res == null ? null : res.getURL();
    }

    private static Resource getResource(String name, boolean searchFiles, boolean zipURLsOK) {
        return ResourceLoader.getResource(name, Resource.class, searchFiles, zipURLsOK);
    }

    private static Resource getResource(String name, Class<?> type, boolean searchFiles, boolean zipURLsOK) {
        if (name == null || name.equals("")) {
            return null;
        }
        pathsNotFound.clear();
        if (name.startsWith("\"")) {
            name = name.substring(1);
        }
        if (name.endsWith("\"")) {
            name = name.substring(0, name.length() - 1);
        }
        while (name.startsWith("./")) {
            name = name.substring(2);
        }
        Resource res = ResourceLoader.findResource(name, type, searchFiles, zipURLsOK);
        if (res != null) {
            return res;
        }
        pathsNotFound.add(name);
        StringBuffer err = new StringBuffer("Not found: " + name);
        err.append(" [searched " + name);
        for (String next : searchPaths) {
            String path = ResourceLoader.getPath(next, name);
            if (pathsNotFound.contains(path)) continue;
            res = ResourceLoader.findResource(path, type, searchFiles, zipURLsOK);
            if (res != null) {
                return res;
            }
            pathsNotFound.add(path);
            err.append(";" + path);
        }
        err.append("]");
        OSPLog.fine(err.toString());
        return null;
    }

    public static String getText(String basePath, String name, Class<Resource> type, boolean searchFiles) {
        if (name.startsWith("./")) {
            name = name.substring(2);
        }
        pathsNotFound.clear();
        String path = ResourceLoader.getPath(basePath, name);
        Resource res = ResourceLoader.findResource(path, type, searchFiles, false);
        if (res != null) {
            return res.toString();
        }
        if (basePath.startsWith("/") || basePath.indexOf(":/") > -1) {
            return null;
        }
        pathsNotFound.add(path);
        StringBuffer err = new StringBuffer("Not found: " + path);
        err.append(" [searched " + path);
        Iterator<String> it = searchPaths.iterator();
        while (it.hasNext()) {
            path = ResourceLoader.getPath(ResourceLoader.getPath(it.next(), basePath), name);
            if (pathsNotFound.contains(path)) continue;
            res = ResourceLoader.findResource(path, type, searchFiles, false);
            if (res != null) {
                return res.toString();
            }
            pathsNotFound.add(path);
            err.append(";" + path);
        }
        err.append("]");
        OSPLog.fine(err.toString());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSearchPath(String base) {
        if (base == null || base.equals("") || maxPaths < 1) {
            return;
        }
        ArrayList<String> arrayList = searchPaths;
        synchronized (arrayList) {
            if (searchPaths.contains(base)) {
                searchPaths.remove(base);
            } else {
                OSPLog.fine("Added path: " + base);
            }
            searchPaths.add(0, base);
            while (searchPaths.size() > Math.max(maxPaths, 0)) {
                base = searchPaths.get(searchPaths.size() - 1);
                OSPLog.fine("Removed path: " + base);
                searchPaths.remove(base);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSearchPath(String base) {
        if (base == null || base.equals("")) {
            return;
        }
        ArrayList<String> arrayList = searchPaths;
        synchronized (arrayList) {
            if (searchPaths.contains(base)) {
                OSPLog.fine("Removed path: " + base);
                searchPaths.remove(base);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAppletSearchPath(String base) {
        if (base == null || maxPaths < 1) {
            return;
        }
        if (!(base = base.trim()).endsWith("/")) {
            base = String.valueOf(base) + "/";
        }
        ArrayList<String> arrayList = appletSearchPaths;
        synchronized (arrayList) {
            if (appletSearchPaths.contains(base)) {
                appletSearchPaths.remove(base);
            } else {
                OSPLog.fine("Applet search path added: " + base);
            }
            appletSearchPaths.add(0, base);
            while (appletSearchPaths.size() > Math.max(maxPaths, 0)) {
                base = appletSearchPaths.get(appletSearchPaths.size() - 1);
                OSPLog.fine("Removed path: " + base);
                appletSearchPaths.remove(base);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAppletSearchPath(String base) {
        if (base == null || base.equals("")) {
            return;
        }
        ArrayList<String> arrayList = appletSearchPaths;
        synchronized (arrayList) {
            if (appletSearchPaths.contains(base)) {
                OSPLog.fine("Applet search path removed: " + base);
                appletSearchPaths.remove(base);
            }
        }
    }

    public static void setCacheEnabled(boolean enabled) {
        cacheEnabled = enabled;
    }

    public static boolean isCacheEnabled() {
        return cacheEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExtractExtension(String extension) {
        if (extension == null || extension.equals("")) {
            return;
        }
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        Set<String> set = extractExtensions;
        synchronized (set) {
            extractExtensions.add(extension);
        }
    }

    public static void setCanceled(boolean cancel) {
        canceled = cancel;
    }

    public static boolean isCanceled() {
        return canceled;
    }

    public static InputStream openInputStream(String path) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.openInputStream();
    }

    public static Reader openReader(String path) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.openReader();
    }

    public static String getString(String path) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.getString();
    }

    @Deprecated
    public static ImageIcon getIcon(String path) {
        return ResourceLoader.getImageIcon(path);
    }

    public static ImageIcon getImageIcon(String path) {
        ImageIcon icon = null;
        URL url = ResourceLoader.getAssetURL(path);
        try {
            icon = url == null ? new ImageIcon(path) : new ImageIcon(url);
            return icon.getIconWidth() > 0 ? icon : null;
        }
        catch (Exception e) {
            OSPLog.warning("ResourceLoader could not find " + url + "\nEclipse not pointing to correct project?");
            return null;
        }
    }

    public static ResizableIcon getResizableIcon(String path) {
        ImageIcon icon = ResourceLoader.getImageIcon(path);
        return icon == null ? null : new ResizableIcon(icon);
    }

    public static BufferedImage getBufferedImage(String path) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.getBufferedImage();
    }

    public static BufferedImage getBufferedImage(String path, int bufferedImageType) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.getBufferedImage(bufferedImageType);
    }

    public static AudioClip getAudioClip(String path) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.getAudioClip();
    }

    public static void setOSPCache(String cachePath) {
        ResourceLoader.setOSPCache(cachePath == null || cachePath.trim().equals("") ? ResourceLoader.getDefaultOSPCache() : new File(cachePath));
    }

    public static void setOSPCache(File newCache) {
        if (newCache != null && !newCache.equals(ospCache)) {
            if (ospCache != null && newCache.getAbsolutePath().contains(ospCache.getAbsolutePath())) {
                Toolkit.getDefaultToolkit().beep();
                OSPLog.finer("cache cannot be a subfolder of " + ospCache.getAbsolutePath());
                return;
            }
            if (!(newCache.exists() && newCache.isDirectory() || newCache.mkdirs())) {
                Toolkit.getDefaultToolkit().beep();
                OSPLog.finer("unable to create cache at " + newCache);
                return;
            }
            if (!newCache.canWrite()) {
                Toolkit.getDefaultToolkit().beep();
                OSPLog.finer("unable to write to cache at " + newCache);
                return;
            }
            if (ospCache != null) {
                File[] hostDirectories;
                File[] fileArray = hostDirectories = ospCache.listFiles(OSP_CACHE_FILTER);
                int n = hostDirectories.length;
                int n2 = 0;
                while (n2 < n) {
                    File host = fileArray[n2];
                    String hostname = host.getName();
                    File newHost = new File(newCache, hostname);
                    ResourceLoader.copyAllFiles(host, newHost);
                    ++n2;
                }
                File searchCache = new File(ospCache, SEARCH_CACHE_SUBDIRECTORY);
                File newSearchCache = new File(newCache, SEARCH_CACHE_SUBDIRECTORY);
                ResourceLoader.copyAllFiles(searchCache, newSearchCache);
                ResourceLoader.clearOSPCache(ospCache, true);
                File[] files = ospCache.listFiles();
                if (files != null && files.length == 0) {
                    ospCache.delete();
                }
            }
            ospCache = newCache;
        }
    }

    public static File getOSPCache() {
        return ospCache;
    }

    public static File getDefaultOSPCache() {
        if (defaultOSPCache == null) {
            String userHome;
            String cacheDir = null;
            String string = userHome = OSPRuntime.isJS ? null : OSPRuntime.getUserHome();
            if (userHome != null) {
                userHome = String.valueOf(userHome) + "/";
                if (OSPRuntime.isMac()) {
                    cacheDir = String.valueOf(userHome) + OSX_DEFAULT_CACHE;
                } else if (OSPRuntime.isLinux()) {
                    cacheDir = String.valueOf(userHome) + LINUX_DEFAULT_CACHE;
                } else if (OSPRuntime.isWindows()) {
                    String os = System.getProperty("os.name", "").toLowerCase();
                    cacheDir = os.indexOf("xp") > -1 ? String.valueOf(userHome) + WIN_XP_DEFAULT_CACHE : String.valueOf(userHome) + WINDOWS_DEFAULT_CACHE;
                }
            }
            defaultOSPCache = new File(cacheDir == null ? OSPRuntime.tempDir : cacheDir);
        }
        return defaultOSPCache;
    }

    public static File chooseOSPCache(Component parent) {
        JFileChooser chooser = new JFileChooser(ospCache);
        if (OSPRuntime.isMac()) {
            chooser.setFileSelectionMode(2);
        } else {
            chooser.setFileSelectionMode(1);
        }
        javax.swing.filechooser.FileFilter folderFilter = new javax.swing.filechooser.FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return ToolsRes.getString("LibraryTreePanel.FolderFileFilter.Description");
            }
        };
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(folderFilter);
        String text = ToolsRes.getString("ResourceLoader.FileChooser.Cache");
        chooser.setDialogTitle(text);
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        int result = chooser.showDialog(parent, text);
        if (result == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private static boolean isOSPCachePath(String path) {
        File dir = ospCache == null ? tempDirFile : ospCache;
        String cachePath = String.valueOf(XML.forwardSlash(dir.getAbsolutePath())) + "/osp-";
        return XML.forwardSlash(path).contains(cachePath);
    }

    public static File getOSPCacheFile(String urlPath) {
        return ResourceLoader.getOSPCacheFile(urlPath, null);
    }

    public static File getOSPCacheFile(String urlPath, String name) {
        File cacheDir = ResourceLoader.getOSPCache();
        return ResourceLoader.getCacheFile(cacheDir == null ? tempDirFile : cacheDir, urlPath, name);
    }

    public static boolean isSearchPath(String path) {
        File spath = ResourceLoader.getSearchCache();
        return spath != null && XML.forwardSlash(path).startsWith(XML.forwardSlash(spath.getPath()));
    }

    public static List<File> getSearchFileList() {
        return ResourceLoader.getFiles(ResourceLoader.getSearchCache(), new LibraryBrowser.XMLFilter());
    }

    private static File getSearchCache() {
        File ospCache = ResourceLoader.getOSPCache();
        if (ospCache == null && (ospCache = ResourceLoader.getDefaultOSPCache()) == null) {
            return null;
        }
        File searchCache = new File(ospCache, SEARCH_CACHE_SUBDIRECTORY);
        searchCache.mkdirs();
        return searchCache;
    }

    public static File getSearchCacheFile(String urlPath) {
        String filename = XML.getName(urlPath);
        String basename = XML.stripExtension(filename);
        String ext = XML.getExtension(filename);
        if (ext != null) {
            basename = String.valueOf(basename) + "_" + ext;
        }
        filename = String.valueOf(ResourceLoader.getNonURIPath(basename).replace('=', '_')) + ".xml";
        return ResourceLoader.getCacheFile(ResourceLoader.getSearchCache(), urlPath, filename);
    }

    private static File getCacheFile(File cacheFile, String urlPath, String name) {
        String cachePath = cacheFile == null ? "./" : XML.forwardSlash(cacheFile.getAbsolutePath());
        urlPath = ResourceLoader.getURIPath(urlPath);
        String host = "";
        String path = "";
        String filename = "";
        try {
            URL url = new URL(urlPath);
            host = url.getHost().replace('.', '_');
            path = ResourceLoader.getNonURIPath(url.getPath());
            int n = path.indexOf(cachePath);
            if (n >= 0) {
                if (OSPRuntime.isJS && path.indexOf("!/") < 0) {
                    return new File(path);
                }
                path = path.substring(n + cachePath.length());
            }
            if ((n = path.lastIndexOf(":")) >= 0) {
                path = path.substring(n + 1);
            }
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            String pathname = XML.getName(path);
            if (!"".equals(pathname)) {
                path = XML.getDirectoryPath(path);
            }
            path = path.replace('.', '_').replace("!", "");
            filename = name == null ? pathname : name;
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if ("".equals(host)) {
            host = "local_machine";
        }
        if (!path.startsWith("osp-")) {
            cacheFile = new File(cacheFile, "osp-" + host);
        }
        if (!"".equals(path)) {
            cacheFile = new File(cacheFile, path);
        }
        if (!"".equals(filename)) {
            cacheFile = new File(cacheFile, filename);
        }
        return cacheFile;
    }

    public static File downloadToOSPCache(String urlPath, String fileName, boolean alwaysOverwrite) {
        if (fileName == null) {
            return null;
        }
        File target = ResourceLoader.getOSPCacheFile(urlPath, fileName);
        File file = ResourceLoader.download(urlPath, target, alwaysOverwrite);
        if (file == null && webConnected) {
            ResourceLoader.clearWebTest();
            webConnected = ResourceLoader.isWebConnected();
            if (!webConnected) {
                if (ResourceLoader.showWebConnectionDialog() == 1) {
                    return ResourceLoader.downloadToOSPCache(urlPath, fileName, alwaysOverwrite);
                }
            } else if (!warningShown) {
                warningShown = true;
                String message = String.valueOf(ToolsRes.getString("ResourceLoader.Dialog.FailedToDownload.Message1")) + "\n" + ToolsRes.getString("ResourceLoader.Dialog.FailedToDownload.Message2") + "\n" + ToolsRes.getString("ResourceLoader.Dialog.FailedToDownload.Message3");
                message = String.valueOf(message) + "\n\n" + ToolsRes.getString("LibraryResource.Description.Resource") + ": " + urlPath;
                JOptionPane.showMessageDialog(null, message, ToolsRes.getString("ResourceLoader.Dialog.FailedToDownload.Title"), 0);
            }
        }
        return file;
    }

    public static String getHTMLCode(String path) {
        Resource res = ResourceLoader.getResourceZipURLsOK(path);
        if (res == null) {
            return null;
        }
        String html = res.getString();
        if (html != null && html.trim().startsWith("<!DOCTYPE html")) {
            return html;
        }
        return null;
    }

    public static void getHTMLCodeAsync(String path, final Function<String, Void> whenDone) {
        ResourceLoader.getResourceZipURLsOKAsync(path, new Function<Resource, Void>(){

            @Override
            public Void apply(Resource res) {
                if (res == null) {
                    whenDone.apply(null);
                } else {
                    String html = res.getString();
                    whenDone.apply(html != null && html.trim().startsWith("<!DOCTYPE html") ? html : null);
                }
                return null;
            }
        });
    }

    private static void getResourceZipURLsOKAsync(String path, Function<Resource, Void> whenDone) {
        whenDone.apply(ResourceLoader.getResourceZipURLsOK(path));
    }

    public static String getTitleFromHTMLCode(String code) {
        if (code == null) {
            return null;
        }
        String[] parts = code.split("<title>");
        if (parts.length > 1 && (parts = parts[1].split("</title>")).length > 1) {
            return parts[0].trim();
        }
        return null;
    }

    public static String getStyleSheetFromHTMLCode(String code) {
        if (code == null) {
            return null;
        }
        String[] parts = code.split("<head>");
        if (parts.length > 1 && (parts = parts[1].split("</head>")).length > 1 && (parts = parts[0].split("<link")).length > 1) {
            int i = 1;
            while (i < parts.length) {
                if (parts[i].contains("\"stylesheet\"") && (parts = parts[i].split("href")).length > 1 && (parts = parts[1].split("\"")).length > 1) {
                    return parts[1];
                }
                ++i;
            }
        }
        return null;
    }

    public static File copyHTMLToOSPCache(String htmlPath) {
        if (htmlPath == null) {
            return null;
        }
        String htmlCode = null;
        Resource res = ResourceLoader.getResourceZipURLsOK(htmlPath);
        if (res != null) {
            if (res.getFile() != null && ResourceLoader.isOSPCachePath(htmlPath)) {
                return res.getFile();
            }
            htmlCode = res.getString();
        }
        if (htmlCode != null) {
            String htmlBasePath = XML.getDirectoryPath(htmlPath);
            File htmlTarget = ResourceLoader.getOSPCacheFile(htmlPath);
            File targetDirectory = htmlTarget.getParentFile();
            targetDirectory.mkdirs();
            File imageDir = new File(targetDirectory, "images");
            String img = "<img ";
            String pre = "src=\"";
            String post = "\"";
            String temp = htmlCode;
            int j = temp.indexOf(img);
            if (j > -1) {
                imageDir.mkdirs();
            }
            while (j > -1) {
                String filename;
                File imageTarget;
                String next;
                String path;
                temp = temp.substring(j + img.length());
                j = temp.indexOf(pre);
                if ((j = (temp = temp.substring(j + pre.length())).indexOf(post)) > -1 && (res = ResourceLoader.getResourceZipURLsOK(path = XML.getResolvedPath(next = temp.substring(0, j), htmlBasePath))) != null && (imageTarget = ResourceLoader.download(path, new File(imageDir, filename = XML.getName(next)), false)) != null && !next.equals(path = XML.getPathRelativeTo(imageTarget.getAbsolutePath(), targetDirectory.getAbsolutePath()))) {
                    htmlCode = htmlCode.replace(String.valueOf(pre) + next + post, String.valueOf(pre) + path + post);
                }
                j = temp.indexOf(img);
            }
            String css = ResourceLoader.getStyleSheetFromHTMLCode(htmlCode);
            if (css != null && !ResourceLoader.isHTTP(css) && (res = ResourceLoader.getResourceZipURLsOK(XML.getResolvedPath(css, htmlBasePath))) != null) {
                String cssName = XML.getName(css);
                File cssTarget = new File(targetDirectory, cssName);
                cssTarget = ResourceLoader.download(res.getAbsolutePath(), cssTarget, false);
                if (cssTarget != null && !cssName.equals(css)) {
                    htmlCode = htmlCode.replace(css, cssName);
                }
            }
            try {
                FileWriter fout = new FileWriter(htmlTarget);
                fout.write(htmlCode);
                fout.close();
                return htmlTarget;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static boolean copyAllFiles(File inFile, Object fileOrZipStream) {
        File outFile;
        ZipOutputStream zos = fileOrZipStream instanceof ZipOutputStream ? (ZipOutputStream)fileOrZipStream : null;
        File file = outFile = zos == null ? (File)fileOrZipStream : null;
        if (inFile.isDirectory()) {
            if (outFile != null) {
                outFile.mkdir();
            }
            boolean success = true;
            File[] fileArray = inFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File in = fileArray[n2];
                success = ResourceLoader.copyAllFiles(in, zos == null ? new File(outFile, in.getName()) : zos);
                if (!success) {
                    return false;
                }
                ++n2;
            }
            return success;
        }
        String path = ResourceLoader.toUnix(inFile.getPath());
        if (ResourceLoader.isZipEntry(path, false) >= 0) {
            try {
                if (zos != null) {
                    byte[] bytes = ResourceLoader.getZipEntryBytes(path, null);
                    ZipEntry e = new ZipEntry(inFile.getName());
                    zos.putNextEntry(e);
                    zos.write(bytes);
                    zos.closeEntry();
                    zos.close();
                } else if (outFile != null) {
                    if (OSPRuntime.isJS) {
                        ResourceLoader.copyURLtoFile(path, outFile.getAbsolutePath());
                    } else {
                        ResourceLoader.getZipEntryBytes(path, outFile);
                    }
                }
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }
        if (zos != null) {
            try {
                zos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ResourceLoader.copyFile(inFile, outFile);
    }

    private static String toUnix(String path) {
        return path.replace('\\', '/');
    }

    public static boolean clearOSPCache(File cache, boolean clearSearchCache) {
        if (cache == null) {
            cache = ospCache;
        }
        if (cache == null || !cache.canWrite()) {
            return false;
        }
        boolean success = true;
        File[] files = cache.listFiles(OSP_CACHE_FILTER);
        if (files == null) {
            return true;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File next = fileArray[n2];
            success = success && ResourceLoader.deleteFile(next);
            ++n2;
        }
        if (clearSearchCache) {
            boolean bl = success = success && ResourceLoader.deleteFile(new File(cache, SEARCH_CACHE_SUBDIRECTORY));
        }
        if (!success) {
            JOptionPane.showMessageDialog(null, String.valueOf(ToolsRes.getString("ResourceLoader.Dialog.UnableToClearCache.Message1")) + "\n" + ToolsRes.getString("ResourceLoader.Dialog.UnableToClearCache.Message2"), ToolsRes.getString("ResourceLoader.Dialog.UnableToClearCache.Title"), 2);
        }
        return success;
    }

    public static boolean clearOSPCacheHost(File hostDir) {
        if (hostDir == null || !hostDir.canWrite()) {
            return true;
        }
        if (!OSP_CACHE_FILTER.accept(hostDir)) {
            return false;
        }
        boolean success = ResourceLoader.deleteFile(hostDir);
        if (!success) {
            JOptionPane.showMessageDialog(null, String.valueOf(ToolsRes.getString("ResourceLoader.Dialog.UnableToClearCache.Message1")) + "\n" + ToolsRes.getString("ResourceLoader.Dialog.UnableToClearCache.Message2"), ToolsRes.getString("ResourceLoader.Dialog.UnableToClearCache.Title"), 2);
        }
        return success;
    }

    public static boolean deleteFile(File file) {
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File next = fileArray[n2];
                ResourceLoader.deleteFile(next);
                ++n2;
            }
        }
        return file.delete();
    }

    public static List<File> getFiles(File directory, FileFilter filter) {
        File[] contents;
        ArrayList<File> results = new ArrayList<File>();
        if (directory == null) {
            return results;
        }
        if (directory.isFile()) {
            results.add(directory);
            return results;
        }
        File[] fileArray = contents = directory.listFiles(filter);
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                List<File> deeperList = ResourceLoader.getFiles(file, filter);
                results.addAll(deeperList);
            } else {
                results.add(file);
            }
            ++n2;
        }
        return results;
    }

    public static void clearZipCache() {
        htZipContents.clear();
    }

    public static void removeFromZipCache(String zipPath) {
        URL url = ResourceLoader.getURLWithCachedBytes(zipPath);
        htZipContents.remove(url.toString());
    }

    public static boolean checkExists(String path) {
        String[] parts = ResourceLoader.getJarURLParts(path);
        if (parts != null) {
            Map<String, ZipEntry> map = ResourceLoader.getZipContents(parts[0], true);
            return map != null && map.containsKey(parts[1]);
        }
        return ResourceLoader.getResource(path) != null;
    }

    private static ZipEntry findZipEntry(String zipFile, String fileName, boolean isContains) {
        Map<String, ZipEntry> contents = ResourceLoader.getZipContents(zipFile, true);
        if (contents == null) {
            return null;
        }
        if (!isContains) {
            if (fileName.indexOf("!/") >= 0) {
                fileName = ResourceLoader.getJarURLParts(fileName)[1];
            }
            return contents.get(fileName);
        }
        boolean isLCExt = fileName.startsWith(".");
        for (Map.Entry<String, ZipEntry> entry : contents.entrySet()) {
            String key = entry.getKey();
            if ((isLCExt ? key.toLowerCase() : key).indexOf(fileName) < 0) continue;
            return entry.getValue();
        }
        return null;
    }

    private static void findZipEntryAsync(String zipFile, final String fileName, final boolean isContains, final Function<ZipEntry, Void> whenDone) {
        ResourceLoader.getZipContentsAsync(zipFile, new Function<Map<String, ZipEntry>, Void>(){

            @Override
            public Void apply(Map<String, ZipEntry> map) {
                if (!isContains) {
                    whenDone.apply(map.get(fileName));
                } else {
                    for (Map.Entry<String, ZipEntry> entry : map.entrySet()) {
                        if (entry.getKey().indexOf(fileName) < 0) continue;
                        whenDone.apply(entry.getValue());
                        return null;
                    }
                    whenDone.apply(null);
                }
                return null;
            }
        });
    }

    public static void getZipContentsAsync(String zipPath, Function<Map<String, ZipEntry>, Void> whenDone) {
        URL url = ResourceLoader.getURLWithCachedBytes(zipPath);
        Map<String, ZipEntry> fnames = htZipContents.get(url.toString());
        if (fnames != null) {
            whenDone.apply(fnames);
            return;
        }
        ResourceLoader.getURLContentsAsync(url, bytes -> {
            Map<String, ZipEntry> contents = null;
            try {
                contents = ResourceLoader.readZipContents(new ByteArrayInputStream((byte[])bytes), url);
            }
            catch (Exception exception) {
                // empty catch block
            }
            whenDone.apply(contents);
            return null;
        });
    }

    public static Map<String, ZipEntry> getZipContents(String zipPath, boolean useCached) {
        Map<String, ZipEntry> fileNames;
        URL url = ResourceLoader.getURLWithCachedBytes(zipPath);
        if (useCached && (fileNames = htZipContents.get(url.toString())) != null) {
            return fileNames;
        }
        try {
            boolean cacheConnection = ResourceLoader.isHTTP(url.getPath());
            return ResourceLoader.readZipContents(ResourceLoader.openInputStreamAndCache(url, cacheConnection), url);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static InputStream openInputStreamAndCache(URL url, boolean cacheConnection) throws IOException {
        URLConnection c = url.openConnection();
        c.setUseCaches(cacheConnection);
        return c.getInputStream();
    }

    private static Map<String, ZipEntry> readZipContents(InputStream is, URL url) throws IOException {
        LinkedHashMap<String, ZipEntry> fileNames = new LinkedHashMap<String, ZipEntry>();
        if (OSPRuntime.doCacheZipContents) {
            htZipContents.put(url.toString(), fileNames);
        }
        ZipInputStream input = new ZipInputStream(is);
        ZipEntry zipEntry = null;
        int n = 0;
        while ((zipEntry = input.getNextEntry()) != null) {
            if (zipEntry.isDirectory() || zipEntry.getSize() == 0L) continue;
            ++n;
            String fileName = zipEntry.getName();
            fileNames.put(fileName, zipEntry);
        }
        input.close();
        OSPLog.finest("ResourceLoader: " + n + " zip entries found in " + url);
        return fileNames;
    }

    private static URL getURLWithCachedBytes(String path) {
        URL url = null;
        try {
            url = new URL(ResourceLoader.getURIPath(path));
            OSPRuntime.addJSCachedBytes(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return url;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<File> unzip(String zipPath) {
        File targetDir = tempDirFile;
        boolean alwaysOverwrite = true;
        if (targetDir == null) {
            targetDir = tempDirFile;
        }
        OSPLog.finer("unzipping " + zipPath + " to " + targetDir);
        try {
            URL url = ResourceLoader.getURLWithCachedBytes(zipPath);
            ZipInputStream input = new ZipInputStream(ResourceLoader.openStream(url));
            ZipEntry zipEntry = null;
            HashSet<File> fileSet = new HashSet<File>();
            byte[] buffer = new byte[1024];
            ResourceLoader.setCanceled(false);
            while (true) {
                File file;
                block21: {
                    if ((zipEntry = input.getNextEntry()) == null) {
                        input.close();
                        return fileSet;
                    }
                    if (zipEntry.isDirectory()) continue;
                    if (ResourceLoader.isCanceled()) {
                        input.close();
                        return null;
                    }
                    String filename = zipEntry.getName();
                    file = new File(targetDir, filename);
                    String fullName = null;
                    if (!alwaysOverwrite && file.exists()) {
                        fileSet.add(file);
                        continue;
                    }
                    file.getParentFile().mkdirs();
                    boolean isPDF = filename.endsWith(".pdf");
                    if (isPDF) {
                        fullName = file.toURL().toString();
                        openPDFs.remove(fullName);
                    }
                    try {
                        try {
                            if (OSPRuntime.isJS) {
                                OSPRuntime.jsutil.streamToFile((InputStream)input, file);
                                break block21;
                            }
                            FileOutputStream output = new FileOutputStream(file);
                            while (true) {
                                int bytesRead;
                                if ((bytesRead = input.read(buffer)) == -1) {
                                    output.close();
                                    break;
                                }
                                output.write(buffer, 0, bytesRead);
                            }
                        }
                        catch (Throwable e) {
                            if (isPDF) {
                                if (openPDFs.indexOf(fullName) < 0) {
                                    openPDFs.add(fullName);
                                }
                            } else {
                                OSPLog.debug("ResourceLoader.unzip could not open for write " + filename);
                                file = null;
                            }
                            if (file != null) {
                                fileSet.add(file);
                            }
                            input.closeEntry();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        if (file != null) {
                            fileSet.add(file);
                        }
                        input.closeEntry();
                        throw throwable;
                    }
                }
                if (file != null) {
                    fileSet.add(file);
                }
                input.closeEntry();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean wasPDFOpen(String filename) {
        return openPDFs.contains(filename);
    }

    public static File downloadResourceFromDialog(String urlPath, File file) {
        String filePath = file.getAbsolutePath();
        try {
            file = ResourceLoader.copyURLtoFile(urlPath, filePath);
        }
        catch (IOException e1) {
            urlPath = String.valueOf(urlPath) + " " + e1.getMessage();
        }
        if (file == null) {
            OSPLog.warning("Failed to download " + urlPath + " to " + filePath);
        }
        return file;
    }

    public static File download(String urlPath, File target, boolean alwaysOverwrite) {
        if (target == null) {
            target = ResourceLoader.getOSPCacheFile(urlPath);
        }
        if (target.getParentFile() == null) {
            return null;
        }
        if (target.exists() && !alwaysOverwrite) {
            return target;
        }
        if (!webConnected || downloadURL.equals(urlPath)) {
            if (webConnected) {
                return null;
            }
            ResourceLoader.clearWebTest();
            webConnected = ResourceLoader.isWebConnected();
        }
        if (!webConnected) {
            if (ResourceLoader.showWebConnectionDialog() == 1) {
                ResourceLoader.clearWebTest();
                return ResourceLoader.download(urlPath, target, alwaysOverwrite);
            }
            return null;
        }
        urlPath = ResourceLoader.getURIPath(urlPath);
        target.getParentFile().mkdirs();
        if (alwaysOverwrite || !target.exists()) {
            OSPLog.finer("downloading " + urlPath + " to " + target);
            downloadURL = urlPath;
            InputStream is = null;
            try {
                Resource res = ResourceLoader.getResourceZipURLsOK(urlPath);
                InputStream inputStream = is = res == null ? ResourceLoader.openStream(new URL(urlPath)) : res.openInputStream();
                if (OSPRuntime.isJS) {
                    OSPRuntime.jsutil.streamToFile(is, target);
                    if (res != null && cacheEnabled) {
                        resources.put(ResourceLoader.getNonURIPath(target.toString()), res);
                    }
                } else {
                    Files.copy(is, target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (Exception ex) {
                target = null;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            downloadURL = "";
        }
        if (target != null && target.exists()) {
            return target;
        }
        return null;
    }

    public static File extractFileFromZIP(String source, File target, boolean alwaysOverwrite) {
        return ResourceLoader.extractFileFromZIP(source, target, alwaysOverwrite, true);
    }

    public static File extractFileFromZIP(String source, File target, boolean alwaysOverwrite, boolean forceFileCreation) {
        if (!alwaysOverwrite && target.exists()) {
            return target;
        }
        try {
            ResourceLoader.getZipEntryBytes(source, target);
            return target;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static byte[] getZipEntryBytes(String jarSource, File target) throws IOException {
        String[] parts = ResourceLoader.getJarURLParts(jarSource);
        return parts == null ? null : ResourceLoader.getZipEntryBytes(parts[0], parts[1], target);
    }

    public static void getZipEntryBytesAsync(String source, File target, Function<byte[], Void> whenDone) {
        String[] parts = ResourceLoader.getJarURLParts(source);
        if (parts == null) {
            whenDone.apply(null);
        } else if (OSPRuntime.isJS) {
            ResourceLoader.getZipEntryBytesJSAsync(parts[0], parts[1], target, whenDone);
        } else {
            try {
                whenDone.apply(ResourceLoader.getZipEntryBytes(parts[0], parts[1], target));
            }
            catch (IOException e) {
                whenDone.apply(null);
            }
        }
    }

    private static void getZipEntryBytesJSAsync(String zipFile, String entryPath, File target, Function<byte[], Void> whenDone) {
        boolean isContains = entryPath.startsWith("*");
        if (isContains) {
            entryPath = entryPath.substring(1);
        }
        ResourceLoader.findZipEntryAsync(zipFile, entryPath, isContains, ze -> {
            if (ze == null) {
                whenDone.apply(null);
            } else {
                byte[] bytes = OSPRuntime.jsutil.getZipBytes(ze);
                if (bytes != null && target != null) {
                    OSPRuntime.jsutil.setFileBytes(target, (Object)bytes);
                }
                whenDone.apply(bytes);
            }
            return null;
        });
    }

    public static byte[] getZipEntryBytes(String zipFile, String entryPath, File target) throws IOException {
        byte[] bytes = null;
        boolean isContains = entryPath.startsWith("*");
        if (isContains) {
            entryPath = entryPath.substring(1);
        }
        if (OSPRuntime.isJS) {
            ZipEntry ze = ResourceLoader.findZipEntry(zipFile, entryPath, isContains);
            if (ze == null) {
                return null;
            }
            bytes = OSPRuntime.jsutil.getZipBytes(ze);
            if (bytes != null && target != null) {
                OSPRuntime.jsutil.setFileBytes(target, (Object)bytes);
            }
        } else {
            URL url = ResourceLoader.getURLWithCachedBytes(zipFile);
            ZipInputStream input = new ZipInputStream(ResourceLoader.openStream(url));
            ZipEntry zipEntry = null;
            while ((zipEntry = input.getNextEntry()) != null) {
                if (!zipEntry.isDirectory() && (!isContains ? entryPath.contains(zipEntry.getName()) : zipEntry.getName().contains(entryPath))) break;
            }
            if (zipEntry != null) {
                int bytesRead;
                if (target != null) {
                    target.getParentFile().mkdirs();
                }
                bytes = new byte[1024];
                OutputStream output = target == null ? new ByteArrayOutputStream() : new FileOutputStream(target);
                while ((bytesRead = input.read(bytes)) != -1) {
                    output.write(bytes, 0, bytesRead);
                }
                output.close();
                input.closeEntry();
                if (target == null) {
                    bytes = ((ByteArrayOutputStream)output).toByteArray();
                }
            }
            input.close();
        }
        if (bytes == null) {
            throw new IOException("No bytes were found for " + zipFile + "!/" + entryPath);
        }
        return bytes;
    }

    public static String[] getJarURLParts(String source) {
        int n = source.indexOf("!/");
        if (n < 0) {
            return null;
        }
        String jarfile = source.substring(0, n).replace("jar:", "").replace("file:", "");
        while (jarfile.startsWith("//")) {
            jarfile = jarfile.substring(1);
        }
        return new String[]{jarfile, n == source.length() - 2 ? null : source.substring(n + 2)};
    }

    public static boolean isWebConnected() {
        if (OSPRuntime.isJS) {
            String onlineStr = "not set";
            return onlineStr.toString().equalsIgnoreCase("true");
        }
        return ResourceLoader.isURLAvailable("https://opensourcephysics.github.io/tracker-website/css/library.css");
    }

    public static boolean isURLAvailable(String urlPath) {
        boolean isWebTest;
        boolean bl = isWebTest = urlPath == "https://opensourcephysics.github.io/tracker-website/css/library.css";
        if (webTestOK == Boolean.FALSE || isWebTest && webTestOK == Boolean.TRUE) {
            return webTestOK;
        }
        URL url = null;
        HttpURLConnection urlConnect = null;
        try {
            url = new URL(urlPath);
            urlConnect = (HttpURLConnection)url.openConnection();
            urlConnect.setConnectTimeout(1000);
            urlConnect.getContent();
            if (isWebTest) {
                webTestOK = Boolean.TRUE;
            }
            urlConnect.disconnect();
            return true;
        }
        catch (Exception ex) {
            OSPLog.debug("ResourceLoader failed to read " + url + " " + ex);
            if (isWebTest) {
                webTestOK = Boolean.FALSE;
            }
            if (urlConnect != null) {
                urlConnect.disconnect();
            }
            return false;
        }
    }

    static int showWebConnectionDialog() {
        if (ignoreMissingWebConnection) {
            return 0;
        }
        Object[] buttonTitles = new Object[]{ToolsRes.getString("Button.OK"), ToolsRes.getString("LibraryBrowser.WebConnectionDialog.Button.Retry"), ToolsRes.getString("LibraryBrowser.WebConnectionDialog.Button.Ignore")};
        int ret = JOptionPane.showOptionDialog(null, ToolsRes.getString("LibraryBrowser.Dialog.ServerUnavailable.Message"), ToolsRes.getString("LibraryBrowser.Dialog.ServerUnavailable.Title"), 1, 2, null, buttonTitles, buttonTitles[0]);
        if (ret == 2) {
            ignoreMissingWebConnection = true;
        }
        return ret;
    }

    public static String getNonURIPath(String uriPath) {
        if (uriPath == null) {
            return null;
        }
        String path = uriPath;
        if (path.startsWith("jar:")) {
            path = path.substring(4);
        }
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        if (path.startsWith("/") && path.indexOf(":") > -1) {
            path = path.substring(1);
        }
        return path.replaceAll("%20", " ").replace('&', '_').replace('?', '_');
    }

    public static String getURIPath(String path) {
        if (path == null) {
            return null;
        }
        if (!(path = XML.forwardSlash(path.trim())).equals("") && XML.getExtension(path) == null && !path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        if (ResourceLoader.isHTTP(path) && path.indexOf(" ") >= 0) {
            path = path.replaceAll(" ", "%20");
        }
        if (path.startsWith("/")) {
            return "file:" + path;
        }
        if (!(path.equals("") || ResourceLoader.isHTTP(path) || path.startsWith("jar:") || path.startsWith("file:/"))) {
            String protocol = OSPRuntime.isWindows() ? "file:/" : "file://";
            path = String.valueOf(protocol) + path;
        }
        return path;
    }

    private static Resource createFileResource(String path) {
        return ResourceLoader.isHTTP(path) || ResourceLoader.isJarZipTrz(path, true) ? null : ResourceLoader.createFileResource(new File(path));
    }

    private static Resource createFileResource(File file) {
        try {
            if (file.exists() && file.canRead()) {
                Resource res = new Resource(file);
                if (file.getName().endsWith("xset")) {
                    xsetZipLoader = null;
                }
                return res;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Resource createURLResource(String path, boolean zipURLsOK) {
        if (!zipURLsOK && ResourceLoader.isJarZipTrz(path, true)) {
            return null;
        }
        Resource res = null;
        if (path.indexOf(":/") > -1) {
            try {
                URL url = ResourceLoader.getURLWithCachedBytes(path);
                res = ResourceLoader.createResource(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (res != null && path.endsWith(".xset")) {
            xsetZipLoader = null;
        }
        return res;
    }

    private static Resource createZipResource(String path) {
        URLClassLoader zipLoader;
        String launchJarPath;
        String zipFileName;
        File zipFile;
        boolean deleteOnExit;
        path = ResourceLoader.getNonURIPath(path);
        String base = null;
        String fileName = path;
        int i = ResourceLoader.isZipEntry(path, true);
        if (i >= 0) {
            base = path.substring(0, i);
            fileName = path.substring(i + 2);
        }
        if (base == null) {
            if (ResourceLoader.isZipEntry(String.valueOf(path) + "!/", true) >= 0) {
                base = path;
                fileName = String.valueOf(XML.stripExtension(XML.getName(path))) + ".xset";
            } else if (path.endsWith(".xset")) {
                base = String.valueOf(path.substring(0, path.length() - 4)) + "zip";
            }
        }
        boolean isZip = base != null && ResourceLoader.isJarZipTrz(base, false);
        boolean bl = deleteOnExit = ospCache == null;
        if (isZip && ResourceLoader.isHTTP(path) && (zipFile = ResourceLoader.downloadToOSPCache(base, zipFileName = XML.getName(base), false)) != null) {
            if (deleteOnExit) {
                zipFile.deleteOnExit();
            }
            base = zipFile.getAbsolutePath();
            path = String.valueOf(base) + "!/" + fileName;
        }
        URL url = null;
        ZipEntry ze = null;
        if (base != null) {
            ze = ResourceLoader.findZipEntry(base, fileName, false);
            if (ze != null) {
                url = ResourceLoader.getJarURLForFile(path);
            }
            if (url == null && zipLoaders != null) {
                URLClassLoader zipLoader2 = zipLoaders.get(base);
                url = zipLoader2 != null ? zipLoader2.findResource(fileName) : ResourceLoader.findInJarPath(base, fileName);
            }
        }
        if (url == null && zipLoaders != null && xsetZipLoader != null && (url = xsetZipLoader.findResource(fileName)) != null) {
            for (String key : zipLoaders.keySet()) {
                if (zipLoaders.get(key) != xsetZipLoader) continue;
                base = key;
                break;
            }
        }
        if (url == null && zipLoaders != null && (launchJarPath = OSPRuntime.getLaunchJarPath()) != null && (url = (zipLoader = zipLoaders.get(launchJarPath)) != null ? zipLoader.findResource(fileName) : ResourceLoader.findInJarPath(launchJarPath, fileName)) != null) {
            base = launchJarPath;
        }
        if (url != null) {
            Resource res;
            block23: {
                String ext = "." + XML.getExtension(url.toString());
                if (extractExtensions.contains(ext.toLowerCase())) {
                    File target;
                    String targetPath = fileName;
                    File zip = new File(base);
                    String parent = zip.getParent();
                    if (parent != null && !targetPath.startsWith("/") && fileName.indexOf(":/") == -1) {
                        targetPath = XML.getResolvedPath(fileName, parent);
                    }
                    if (!(target = new File(targetPath)).exists()) {
                        if (OSPRuntime.isJS && ze != null) {
                            OSPRuntime.jsutil.setFileBytes(target, (Object)OSPRuntime.jsutil.getZipBytes(ze));
                        } else {
                            target = ResourceLoader.extract2(zip, fileName, target);
                            if (deleteOnExit) {
                                target.deleteOnExit();
                            }
                        }
                    }
                    return ResourceLoader.createFileResource(target);
                }
                res = ResourceLoader.createResource(url);
                if (res != null && res.getAbsolutePath().indexOf(path) != -1) break block23;
                return null;
            }
            try {
                return res;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static URL getJarURLForFile(String fileName) {
        try {
            return new URL("jar", null, new URL("file", null, fileName).toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static URL findInJarPath(String launchJarPath, String fileName) {
        try {
            URL classURL;
            URL[] urls = new URL[]{new URL("file", null, launchJarPath)};
            URLClassLoader zipLoader = new URLClassLoader(urls);
            URL url = zipLoader.findResource(fileName);
            if (url == null && (classURL = Resource.class.getResource("/" + launchJarPath)) != null) {
                urls = new URL[]{classURL};
                zipLoader = new URLClassLoader(urls);
                url = zipLoader.findResource(fileName);
            }
            if (url != null) {
                zipLoaders.put(launchJarPath, zipLoader);
                if (fileName.endsWith("xset")) {
                    xsetZipLoader = zipLoader;
                }
            }
            return url;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static Resource createClassResource(String name, Class<?> type) {
        URL url3;
        if (name.indexOf(":/") != -1) {
            return null;
        }
        String originalName = name;
        int i = name.indexOf("jar!/");
        if (i == -1) {
            i = name.indexOf("exe!/");
        }
        if (i != -1) {
            name = name.substring(i + 5);
        }
        Resource res = null;
        if (!name.startsWith("/")) {
            try {
                url3 = ResourceLoader.getTypeResource(type, "/" + name);
                res = ResourceLoader.createResource(url3);
            }
            catch (Exception url2) {
                // empty catch block
            }
        }
        if (res == null) {
            try {
                url3 = ResourceLoader.getTypeResource(type, name);
                res = ResourceLoader.createResource(url3);
            }
            catch (Exception url3) {
                // empty catch block
            }
        }
        if (res != null) {
            String path = ResourceLoader.getNonURIPath(XML.forwardSlash(res.getAbsolutePath()));
            if (path.indexOf("/jre") > -1 && path.indexOf("/lib") > -1) {
                return null;
            }
            if (!path.contains(originalName)) {
                return null;
            }
            if (name.endsWith("xset")) {
                xsetZipLoader = null;
            }
            OSPRuntime.setLaunchJarPath(path);
        }
        return res;
    }

    private static URL getTypeResource(Class<?> type, String path) {
        byte[] bytes = OSPRuntime.getCachedBytes(path);
        if (bytes != null) {
            return ResourceLoader.getURLWithCachedBytes(path);
        }
        return type.getResource(path);
    }

    private static Resource createResource(URL url) throws IOException {
        int n;
        if (url == null) {
            return null;
        }
        URL working = url;
        String path = url.toExternalForm();
        String entryPath = null;
        if (ResourceLoader.isHTTP(path) && (n = ResourceLoader.isZipEntry(path, true)) >= 0) {
            entryPath = path.substring(n + 2);
            working = new URL(path.substring(0, n));
        }
        return ResourceLoader.streamExists(working) ? new Resource(working, entryPath) : null;
    }

    private static boolean streamExists(URL working) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream stream = ResourceLoader.openStream(working);){
                boolean bl = stream.read() > -1;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    private static Resource findResource(String path, Class<?> type, boolean searchFiles, boolean zipURLsOK) {
        boolean isHTTP = ResourceLoader.isHTTP(path);
        if (!isHTTP) {
            path = path.replaceAll("/\\./", "/");
        }
        if (type == null) {
            type = Resource.class;
        }
        Resource res = null;
        if (cacheEnabled) {
            res = resources.get(path);
            if (res == null && !isHTTP) {
                res = resources.get(ResourceLoader.getNonURIPath(path));
            }
            if (res != null && (searchFiles || res.getFile() == null)) {
                OSPLog.finest("Found in cache: " + path);
                return res;
            }
        }
        if (!(searchFiles && (res = ResourceLoader.createFileResource(path)) != null || (res = ResourceLoader.createURLResource(path, zipURLsOK)) != null || (res = ResourceLoader.createZipResource(path)) != null)) {
            res = ResourceLoader.createClassResource(path, type);
        }
        if (res != null && cacheEnabled) {
            resources.put(path, res);
        }
        return res;
    }

    private static String getPath(String base, String name) {
        if (base == null) {
            base = "";
        }
        if (ResourceLoader.isJarZipTrz(base, false)) {
            base = String.valueOf(base) + "!";
        }
        String path = XML.getResolvedPath(name, base);
        if (OSPRuntime.isMac() && path.startsWith("file:/") && !path.startsWith("file:///")) {
            path = path.substring(6);
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            path = "file:///" + path;
        }
        return path;
    }

    public static boolean isJarZipTrz(String path, boolean asEntry) {
        return path == null ? false : (asEntry ? path.indexOf("!/") >= 0 : path.endsWith(".jar") || path.endsWith(".zip") || path.endsWith(".trz"));
    }

    public static String fixHTTPS(String htmlStr, URL url) {
        if (url != null) {
            String dir = url.getPath();
            dir = dir.substring(0, dir.lastIndexOf("/") + 1);
            String base = "https://" + url.getHost() + "/" + dir;
            htmlStr = htmlStr.replace("src=\"http", "#SH#");
            htmlStr = htmlStr.replace("src=\"", "src=\"" + base);
            htmlStr = htmlStr.replace("#SH#", "src=\"http");
        }
        htmlStr = htmlStr.replace("http://physlets", "https://physlets");
        return htmlStr;
    }

    /*
     * Exception decompiling
     */
    public static String extractFiles(String modelPath, File sourceDir, List<Object> finalList, File destinationDirectory) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[SWITCH], 3[CASE]], but top level block is 4[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File extract2(File source, String fileName, File target) {
        String targetName = target.toString();
        int flen = fileName.endsWith("/") ? fileName.length() : 0;
        FileOutputStream fos = null;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                FileInputStream fis = new FileInputStream(source);
                try {
                    try (ZipInputStream zis = new ZipInputStream(fis);){
                        ZipEntry ze;
                        while ((ze = zis.getNextEntry()) != null && flen >= 0) {
                            String name = ze.getName();
                            if (flen == 0 && name.equals(fileName)) {
                                flen = -1;
                            } else {
                                if (flen <= 0 || !name.startsWith(fileName)) continue;
                                target = new File(String.valueOf(targetName) + name.substring(flen));
                            }
                            File parent = target.getParentFile();
                            if (parent != null) {
                                parent.mkdirs();
                            }
                            fos = new FileOutputStream(target);
                            ResourceLoader.getLimitedStreamBytes(zis, ze.getSize(), fos, false);
                            fos.close();
                            System.out.println("RL extracted " + targetName + " " + target.length());
                        }
                    }
                    if (fis == null) return target;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
                return target;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            return null;
        }
    }

    public static File extract(String filename, File target) {
        InputStream inputStream;
        block9: {
            Resource res;
            boolean isZip;
            if (filename == null || filename.trim().length() <= 0 || target == null) {
                return null;
            }
            inputStream = null;
            boolean bl = isZip = ResourceLoader.isZipEntry(filename, true) >= 0;
            if (OSPRuntime.isJS) {
                if (isZip) {
                    return ResourceLoader.extractFileFromZIP(filename, target, false, true);
                }
            } else if (ResourceLoader.isHTTP(filename)) {
                return isZip ? ResourceLoader.extractFileFromZIP(filename, target, false, true) : null;
            }
            InputStream inputStream2 = inputStream = (res = ResourceLoader.getResource(filename, false, false)) == null ? null : res.openInputStream();
            if (inputStream != null) break block9;
            return null;
        }
        try {
            int bytesRead;
            BufferedInputStream input = new BufferedInputStream(inputStream);
            target.getParentFile().mkdirs();
            byte[] buffer = new byte[1024];
            FileOutputStream output = new FileOutputStream(target);
            while ((bytesRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
            output.close();
            input.close();
            return target;
        }
        catch (Exception exc) {
            System.err.println("JarTool extract resource error.  Filename=" + filename);
            exc.printStackTrace();
            return null;
        }
    }

    private static int isZipEntry(String filename, boolean checkExt) {
        int n = filename.indexOf("!/");
        return n >= 4 && (!checkExt || filename.indexOf("_TrackerSet=") >= 0 || ".exe.zip.jar.trz".indexOf(filename.substring(n - 4, n)) >= 0) ? n : -1;
    }

    public static int confirmOverwrite(String filename) {
        return ResourceLoader.confirmOverwrite(filename, false);
    }

    public static Bundle getBundle(String bundleName, Locale resourceLocale) {
        String name;
        String key;
        Bundle b;
        if (bundleName == null) {
            bundleName = "org.opensourcephysics.resources.tools.tools";
        }
        if (resourceLocale == null) {
            resourceLocale = Locale.getDefault();
        }
        if ((b = bundleCache.get(key = String.valueOf(name = String.valueOf(bundleName.replaceAll("\\.", "/")) + ".properties") + "/" + resourceLocale)) != null) {
            return b;
        }
        if (resourceLocale.getLanguage() == "en" && !Assets.notFound(name)) {
            Properties p = new Properties();
            try {
                p.load(ResourceLoader.getAssetStream(name));
                OSPLog.debug("ResourceLoader found " + p.size() + " properties in\n" + ResourceLoader.getAssetURL(name).toString());
                b = new Bundle(p);
            }
            catch (Exception e) {
                OSPLog.debug("Asset not found for resource " + name);
                OSPLog.warning("Asset not found for resource " + name);
                Assets.setNotFound(name);
            }
        }
        if (b == null) {
            b = new Bundle(ResourceBundle.getBundle(bundleName, resourceLocale, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES)));
        }
        bundleCache.put(key, b);
        return b;
    }

    private static InputStream getAssetStream(String name) throws IOException {
        return OSPRuntime.useZipAssets ? Assets.getAssetStream(name) : ResourceLoader.openStream(ResourceLoader.getAssetURL(name));
    }

    public static String fixLang(String ret) {
        if (ret != null && localeChars != null) {
            String s;
            if (langMap == null) {
                langMap = new HashMap<String, String>();
            }
            if ((s = langMap.get(ret)) != null) {
                return s;
            }
            s = ret;
            int i = 0;
            int n = localeChars.length();
            while (i < n) {
                ret = ret.replace(localeChars.charAt(i), localeChars.charAt(++i));
                ++i;
            }
            langMap.put(s, ret);
        }
        return ret;
    }

    public static void setLocale(Locale locale) {
        localeChars = locale.toString().indexOf("es") == 0 ? latinChars : null;
        myLocale = locale;
        langMap = null;
    }

    public static int confirmOverwrite(String filename, boolean canCancel) {
        final JDialog dialog = new JDialog();
        final OverwriteValue returnValue = new OverwriteValue(1);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AbstractButton button = (AbstractButton)evt.getSource();
                String aCmd = button.getActionCommand();
                if (aCmd.equals("yes")) {
                    returnValue.value = 0;
                } else if (aCmd.equals("no")) {
                    returnValue.value = 1;
                } else if (aCmd.equals("yesToAll")) {
                    returnValue.value = 2;
                } else if (aCmd.equals("noToAll")) {
                    returnValue.value = 3;
                } else if (aCmd.equals("cancel")) {
                    returnValue.value = 4;
                }
                dialog.setVisible(false);
            }
        };
        Bundle bundle = ResourceLoader.getBundle(null, myLocale);
        JButton yesButton = new JButton(bundle.getString("JarTool.Yes"));
        yesButton.setActionCommand("yes");
        yesButton.addMouseListener(mouseListener);
        JButton noButton = new JButton(bundle.getString("JarTool.No"));
        noButton.setActionCommand("no");
        noButton.addMouseListener(mouseListener);
        JButton yesToAllButton = new JButton(bundle.getString("JarTool.YesToAll"));
        yesToAllButton.setActionCommand("yesToAll");
        yesToAllButton.addMouseListener(mouseListener);
        JButton noToAllButton = new JButton(bundle.getString("JarTool.NoToAll"));
        noToAllButton.setActionCommand("noToAll");
        noToAllButton.addMouseListener(mouseListener);
        JButton cancelButton = new JButton(bundle.getString("JarTreeDialog.Button.Cancel"));
        cancelButton.setActionCommand("cancel");
        cancelButton.addMouseListener(mouseListener);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(yesButton);
        buttonPanel.add(yesToAllButton);
        buttonPanel.add(noButton);
        buttonPanel.add(noToAllButton);
        if (canCancel) {
            buttonPanel.add(cancelButton);
        }
        JLabel label = new JLabel(String.valueOf(DisplayRes.getString("DrawingFrame.ReplaceExisting_message")) + " " + filename + DisplayRes.getString("DrawingFrame.QuestionMark"));
        label.setHorizontalAlignment(0);
        label.setBorder(new EmptyBorder(10, 10, 10, 10));
        dialog.setTitle(DisplayRes.getString("DrawingFrame.ReplaceFile_option_title"));
        dialog.getContentPane().setLayout(new BorderLayout(5, 0));
        dialog.getContentPane().add((Component)label, "Center");
        dialog.getContentPane().add((Component)buttonPanel, "South");
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                returnValue.value = 1;
            }
        });
        dialog.validate();
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setModal(true);
        dialog.setVisible(true);
        return returnValue.value;
    }

    public static boolean isHTTP(String path) {
        boolean tf = path.startsWith("http:") || path.startsWith("https:");
        return tf;
    }

    public static InputStream openZipEntryStream(URL url, URL zipURL) throws IOException {
        String entryPath;
        int n;
        if (OSPRuntime.isJS) {
            byte[] bytes = OSPRuntime.jsutil.getURLBytes(url);
            if (bytes == null) {
                bytes = ResourceLoader.getZipEntryBytes(url.toString(), null);
                OSPRuntime.jsutil.setURLBytes(url, (Object)bytes);
            }
            return bytes == null ? null : new ByteArrayInputStream(bytes);
        }
        if (url.getProtocol() != "jar") {
            url = new URL("jar", null, url.toString());
        }
        if ((n = (entryPath = url.toString()).indexOf("!/")) > -1) {
            URL toOpen = zipURL == null ? new URL(entryPath.substring(4, n)) : zipURL;
            entryPath = entryPath.substring(n + 2);
            ZipInputStream input = new ZipInputStream(ResourceLoader.openStream(toOpen));
            ZipEntry zipEntry = null;
            while ((zipEntry = input.getNextEntry()) != null) {
                String filename;
                if (zipEntry.isDirectory() || !entryPath.contains(filename = zipEntry.getName())) continue;
                return input;
            }
        }
        return null;
    }

    public static InputStream openStream(URL url) throws IOException {
        boolean cacheConnection = ResourceLoader.isHTTP(url.getPath());
        return ResourceLoader.openInputStreamAndCache(url, cacheConnection);
    }

    public static Image getImage(String path) {
        ImageIcon icon = ResourceLoader.getImageIcon(path);
        if (icon != null) {
            return icon.getImage();
        }
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.getImage();
    }

    private static URL getAssetURL(String path) {
        if (path.indexOf("resources") == 0) {
            path = "org/opensourcephysics/" + path;
        }
        if (path.startsWith("/org")) {
            path = path.substring(1);
        }
        return OSPRuntime.useZipAssets || path.indexOf("/resources/") < 0 ? Assets.getURLFromPath(path) : ResourceLoader.class.getClassLoader().getResource(path);
    }

    public static byte[] getURLContents(URL url) {
        return ResourceLoader.getURLContents(url, true);
    }

    public static byte[] getURLContents(URL url, boolean showErr) {
        try {
            if (OSPRuntime.isJS) {
                return OSPRuntime.jsutil.readAllBytes(ResourceLoader.openStream(url));
            }
            return ResourceLoader.getLimitedStreamBytes(ResourceLoader.openStream(url), -1L, null, true);
        }
        catch (IOException e) {
            if (showErr) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static byte[] getURLBytes(String url) throws IOException {
        return url.indexOf("!/") >= 0 ? ResourceLoader.getZipEntryBytes(url, null) : OSPRuntime.getCachedBytes(url);
    }

    public static void getURLContentsAsync(URL url, Function<byte[], Void> whenDone) {
        try {
            if (OSPRuntime.isJS) {
                OSPRuntime.getURLBytesAsync(url, whenDone);
                return;
            }
            whenDone.apply(ResourceLoader.getLimitedStreamBytes(ResourceLoader.openStream(url), -1L, null, true));
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            whenDone.apply(null);
            return;
        }
    }

    public static String readAllAsString(InputStream is) throws IOException {
        return new String(ResourceLoader.getLimitedStreamBytes(is, -1L, null, true));
    }

    public static byte[] getLimitedStreamBytes(InputStream is, long n, OutputStream out, boolean andCloseInput) throws IOException {
        boolean toOut = out != null;
        int buflen = n > 0L && n < 1024L ? (int)n : 1024;
        byte[] buf = new byte[buflen];
        byte[] bytes = out == null ? new byte[n < 0L ? 4096 : (int)n] : null;
        int len = 0;
        int totalLen = 0;
        if (n < 0L) {
            n = Integer.MAX_VALUE;
        }
        while ((long)totalLen < n && (len = is.read(buf, 0, buflen)) > 0) {
            totalLen += len;
            if (toOut) {
                out.write(buf, 0, len);
                continue;
            }
            if (bytes != null && totalLen > bytes.length) {
                bytes = Arrays.copyOf(bytes, totalLen * 2);
            }
            System.arraycopy(buf, 0, bytes, totalLen - len, len);
            if (bytes == null || n == Integer.MAX_VALUE || totalLen + buflen <= bytes.length) continue;
            buflen = bytes.length - totalLen;
        }
        if (andCloseInput) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (toOut) {
            return null;
        }
        if (bytes != null && totalLen == bytes.length) {
            return bytes;
        }
        buf = new byte[totalLen];
        System.arraycopy(bytes, 0, buf, 0, totalLen);
        return buf;
    }

    public static File copyURLtoFile(String urlPath, String filePath) throws IOException {
        File f = new File(filePath);
        InputStream is = null;
        if (OSPRuntime.isJS) {
            byte[] bytes;
            boolean isjar = ResourceLoader.isJarZipTrz(urlPath, true);
            byte[] byArray = bytes = isjar ? ResourceLoader.getZipEntryBytes(urlPath, null) : null;
            is = isjar ? new ByteArrayInputStream(bytes) : (ResourceLoader.isHTTP(urlPath) ? ResourceLoader.openStream(new URL(urlPath)) : new FileInputStream(urlPath));
            FileOutputStream fos = new FileOutputStream(f);
            OSPRuntime.jsutil.transferTo(is, (OutputStream)fos);
            fos.close();
        } else {
            try {
                is = ResourceLoader.openStream(new URL(urlPath));
                Path path = f.toPath();
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.copy(is, new File(filePath).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                f = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return f;
    }

    public static void copyURLtoFileAsync(String webPath, String filePath, Function<File, Void> whenDone) {
        File f = new File(filePath);
        try {
            if (OSPRuntime.isJS) {
                ResourceLoader.getURLContentsAsync(new URL(webPath), bytes -> {
                    try {
                        FileOutputStream fos = new FileOutputStream(f);
                        OSPRuntime.jsutil.transferTo((InputStream)new ByteArrayInputStream((byte[])bytes), (OutputStream)fos);
                        fos.close();
                        whenDone.apply(f);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return null;
                });
                return;
            }
            Path path = f.toPath();
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            byte[] bytes2 = ResourceLoader.getURLContents(new URL(ResourceLoader.getURIPath(webPath)), false);
            if (bytes2 == null) {
                return;
            }
            Files.write(path, bytes2, new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        whenDone.apply(f);
    }

    public static BufferedReader readerForStream(InputStream stream, String encoding) {
        if (encoding == null) {
            encoding = encoding;
        }
        try {
            return stream == null ? null : new BufferedReader(new InputStreamReader(stream, encoding));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static Image getVideoImage(String path) {
        Resource res = null;
        if (OSPRuntime.isJS && ResourceLoader.isZipEntry(path, false) >= 0 && (res = resources.get(path)) == null) {
            try {
                byte[] bytes = ResourceLoader.getZipEntryBytes(path, null);
                if (bytes != null) {
                    res = Resource.newImageResource(bytes);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (res != null) {
                resources.put(path, res);
            }
        }
        return res == null ? ResourceLoader.getImage(path) : res.getImage();
    }

    public static URL getClassResource(String path, Class<?> cl) {
        URL url = ResourceLoader.getAssetURL(path);
        return url == null ? cl.getClassLoader().getResource(path) : url;
    }

    public static boolean copyFile(File inFile, File outFile) {
        return ResourceLoader.copyFile(inFile, outFile, 16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean copyFile(File inFile, File outFile, int bufLen) {
        try {
            FileOutputStream out = new FileOutputStream(outFile);
            if (OSPRuntime.isJS) {
                inFile.exists();
                byte[] buffer = OSPRuntime.jsutil.getBytes(inFile);
                ((OutputStream)out).write(buffer, 0, buffer.length);
            } else {
                byte[] buffer = new byte[bufLen];
                FileInputStream in = new FileInputStream(inFile);
                while (true) {
                    byte[] byArray = buffer;
                    // MONITORENTER : buffer
                    int amountRead = ((InputStream)in).read(buffer);
                    if (amountRead == -1) {
                        // MONITOREXIT : byArray
                        break;
                    }
                    ((OutputStream)out).write(buffer, 0, amountRead);
                    // MONITOREXIT : byArray
                }
                ((InputStream)in).close();
            }
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        outFile.setLastModified(inFile.lastModified());
        return true;
    }

    public static class Bundle {
        private ResourceBundle res;
        private Properties props;

        Bundle(ResourceBundle res) {
            this.res = res;
        }

        Bundle(Properties props) {
            this.props = props;
        }

        public String getString(String key) throws MissingResourceException {
            String ret;
            String string = ret = this.props == null ? this.res.getString(key) : this.props.getProperty(key);
            if (ret == null) {
                String cname = (this.res == null ? this.props : this.res).getClass().getName();
                throw new MissingResourceException("Can't find resource for bundle " + cname + ", key " + key, cname, key);
            }
            return ret;
        }
    }

    private static class OverwriteValue {
        int value = 1;

        OverwriteValue(int val) {
            this.value = val;
        }
    }

    public static class RemoteFile
    extends File {
        private String remotePath;

        public RemoteFile(String path) {
            super(path);
            this.remotePath = ResourceLoader.isHTTP(path) ? path : null;
        }

        @Override
        public String getAbsolutePath() {
            return this.remotePath == null ? super.getAbsolutePath() : this.remotePath;
        }
    }
}

