/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.jibble.epsgraphics.EpsGraphics2D;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.media.gif.GIFEncoder;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;

public class SnapshotTool
implements Tool {
    private static ResourceLoader.Bundle res;
    private static SnapshotTool TOOL;
    private static JFileChooser chooser;

    static {
        SnapshotTool.setLocale(null);
        TOOL = new SnapshotTool();
    }

    public static void setLocale(Locale locale) {
        res = ResourceLoader.getBundle(null, locale);
    }

    public static String getString(String key) {
        try {
            return res.getString(key);
        }
        catch (MissingResourceException e) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static SnapshotTool getTool() {
        if (TOOL == null) {
            TOOL = new SnapshotTool();
        }
        return TOOL;
    }

    protected static void createChooser() {
        String[] names = ImageIO.getWriterFormatNames();
        String[] allNames = new String[names.length + 2];
        allNames[0] = "gif";
        allNames[1] = "eps";
        int i = 0;
        while (i < names.length) {
            allNames[i + 2] = names[i];
            ++i;
        }
        chooser = OSPRuntime.createChooser(res.getString("SnapshotTool.ImageFiles"), allNames);
    }

    private SnapshotTool() {
        String name = "SnapshotTool";
        SnapshotTool.createChooser();
        Toolbox.addTool(name, this);
    }

    @Override
    public void send(Job job, Tool replyTo) {
    }

    public boolean saveImage(String filename, Component component) {
        return this.saveImage(filename, component, null);
    }

    public boolean saveImage(String filename, Component component, OutputStream output) {
        return this.saveImage(filename, component, output, 1.0);
    }

    public boolean saveImage(String filename, Component component, OutputStream output, double scale) {
        if (component == null) {
            return false;
        }
        Component originalComponent = component;
        if (component instanceof JFrame) {
            component = ((JFrame)component).getContentPane();
        } else if (component instanceof JDialog) {
            component = ((JDialog)component).getContentPane();
        }
        BufferedImage bi = new BufferedImage(component.getWidth(), component.getHeight(), 5);
        if (component instanceof Renderable) {
            bi = ((Renderable)((Object)component)).render(bi);
        } else {
            Graphics g = bi.getGraphics();
            component.paint(g);
            g.dispose();
        }
        if (output == null && filename == null) {
            JLabel label = new JLabel();
            label.setIcon(new ImageIcon(bi));
            JLabel labelScale = new JLabel(res.getString("SnapshotTool.Scale"));
            labelScale.setBorder(new EmptyBorder(0, 5, 0, 5));
            JTextField scaleField = new JTextField(Double.toString(scale));
            JPanel scalePanel = new JPanel(new BorderLayout());
            scalePanel.add((Component)labelScale, "West");
            scalePanel.add((Component)scaleField, "Center");
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)label, "Center");
            panel.add((Component)scalePanel, "South");
            chooser.setAccessory(panel);
            chooser.setSelectedFile(new File("default.jpg"));
            filename = OSPRuntime.chooseFilename(chooser);
            scale = Double.parseDouble(scaleField.getText());
        }
        if (filename == null) {
            return false;
        }
        String format = "jpg";
        int index = filename.lastIndexOf(46);
        if (index >= 0) {
            format = filename.substring(index + 1).toLowerCase();
        } else {
            filename = String.valueOf(filename) + "." + format;
        }
        boolean supported = SnapshotTool.isImageFormatSupported(format);
        if (!(supported || "gif".equalsIgnoreCase(format) || "eps".equalsIgnoreCase(format))) {
            String[] message = new String[]{res.getString("SnapshotTool.FormatNotSupported"), res.getString("SnapshotTool.PreferredFormats")};
            JOptionPane.showMessageDialog(null, message, res.getString("SnapshotTool.Error"), 2);
            return false;
        }
        Dimension originalSize = null;
        Component componentResized = null;
        int finalWidth = component.getWidth();
        int finalHeight = component.getHeight();
        if (scale <= 0.0) {
            scale = 1.0;
        }
        if (scale != 1.0) {
            originalSize = originalComponent.getSize();
            finalWidth = (int)((double)originalSize.width * scale);
            finalHeight = (int)((double)originalSize.height * scale);
            if (component instanceof Renderable) {
                bi = new BufferedImage(finalWidth, finalHeight, 5);
                bi = ((Renderable)((Object)component)).render(bi);
                component.invalidate();
            } else {
                componentResized = originalComponent;
                componentResized.setSize(finalWidth, finalHeight);
                componentResized.validate();
                bi = new BufferedImage(component.getWidth(), component.getHeight(), 5);
                Graphics g = bi.getGraphics();
                component.paint(g);
                g.dispose();
                finalWidth = component.getWidth();
                finalHeight = component.getHeight();
            }
        }
        boolean result = true;
        try {
            if (output == null) {
                output = new FileOutputStream(filename);
            }
            if (supported) {
                result = ImageIO.write((RenderedImage)bi, format, output);
            } else if ("eps".equalsIgnoreCase(format)) {
                EpsGraphics2D g = new EpsGraphics2D("", output, 0, 0, finalWidth, finalHeight);
                g.drawImage(bi, new AffineTransform(), null);
                g.scale(0.24, 0.24);
                g.close();
            } else {
                try {
                    GIFEncoder encoder = new GIFEncoder(bi);
                    encoder.Write(output);
                }
                catch (Exception exc) {
                    result = false;
                    exc.printStackTrace();
                }
            }
            output.close();
        }
        catch (Exception _exc) {
            _exc.printStackTrace();
            result = false;
        }
        if (componentResized != null && originalSize != null) {
            componentResized.setSize(originalSize.width, originalSize.height);
            componentResized.validate();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isImageFormatSupported(String format) {
        try {
            String[] names = ImageIO.getWriterFormatNames();
            int i = 0;
            while (true) {
                if (i >= names.length) {
                    return false;
                }
                if (names[i].equalsIgnoreCase(format)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void copyImage(Image image) {
        TransferImage transfer = new TransferImage(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transfer, null);
    }

    public Image getClipboardImage() {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null && t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                Image image = (Image)t.getTransferData(DataFlavor.imageFlavor);
                return image;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public void copyImage(Component component) {
        new ComponentImage(component).copyToClipboard();
    }

    public void printImage(Component component) {
        new ComponentImage(component).print();
    }

    class ComponentImage
    implements Printable {
        private BufferedImage image;
        Component c;

        public ComponentImage(Component comp) {
            this.c = comp;
            if (comp instanceof JFrame) {
                comp = ((JFrame)comp).getContentPane();
            } else if (comp instanceof JDialog) {
                comp = ((JDialog)comp).getContentPane();
            }
            this.image = new BufferedImage(comp.getWidth(), comp.getHeight(), 5);
            if (comp instanceof Renderable) {
                this.image = ((Renderable)((Object)comp)).render(this.image);
            } else {
                Graphics g = this.image.getGraphics();
                comp.paint(g);
                g.dispose();
            }
        }

        public Image getImage() {
            return this.image;
        }

        public void copyToClipboard() {
            SnapshotTool.this.copyImage(this.image);
        }

        public void print() {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat format = new PageFormat();
            Book book = new Book();
            book.append(this, format);
            printerJob.setPageable(book);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (PrinterException printerException) {
                    // empty catch block
                }
            }
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
            if (pageIndex >= 1) {
                return 1;
            }
            if (g == null) {
                return 1;
            }
            Graphics2D g2 = (Graphics2D)g;
            double scalex = pageFormat.getImageableWidth() / (double)this.image.getWidth();
            double scaley = pageFormat.getImageableHeight() / (double)this.image.getHeight();
            double scale = Math.min(scalex, scaley);
            scale = Math.min(scale, 1.0);
            g2.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
            g2.scale(scale, scale);
            g2.drawImage((Image)this.image, 0, 0, null);
            return 0;
        }
    }

    class TransferImage
    implements Transferable {
        private Image image;

        public TransferImage(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

