/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.lang.reflect.Method;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.LocalJob;

public interface Tool {
    public void send(Job var1, Tool var2);

    public static boolean setSendAction(JMenuItem item, String toolName, Object data, Tool replyTo, boolean andDisplay) {
        try {
            Class<?> toolClass = Class.forName("org.opensourcephysics.tools." + toolName);
            item.addActionListener(e -> {
                try {
                    Method m = toolClass.getMethod("getTool", null);
                    Tool tool2 = (Tool)m.invoke(null, null);
                    tool2.send(new LocalJob(data), replyTo);
                    if (andDisplay) {
                        if (tool2 instanceof OSPFrame) {
                            ((OSPFrame)((Object)tool2)).setKeepHidden(false);
                        }
                        ((JFrame)((Object)tool2)).setVisible(true);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            OSPLog.finest("Cannot instantiate " + toolName + ":\n" + ex.getMessage());
            return false;
        }
    }

    public static void reply(Tool replyTo, Job job, Tool from, Data reply) {
        job.setXML(new XMLControlElement(reply).toXML());
        replyTo.send(job, from);
    }
}

