/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.dialogs.DialogsRes;
import org.opensourcephysics.tools.ResourceLoader;

public class ToolsRes {
    public static final String OSP_PROPERTY_LOCALE = "locale";
    static Locale resourceLocale = Locale.getDefault();
    static ResourceLoader.Bundle res = ResourceLoader.getBundle(null, resourceLocale);
    static Object resObj = new ToolsRes();
    static PropertyChangeSupport support = new SwingPropertyChangeSupport(resObj);

    private ToolsRes() {
    }

    public static String getString(String key) {
        try {
            return res.getString(key);
        }
        catch (MissingResourceException ex) {
            return "!" + key + "!";
        }
    }

    public static String getLanguage() {
        return resourceLocale.getLanguage();
    }

    public static void setLocale(Locale loc) {
        if (resourceLocale == loc) {
            return;
        }
        Locale prev = resourceLocale;
        resourceLocale = loc;
        res = ResourceLoader.getBundle(null, resourceLocale);
        ControlsRes.setLocale(resourceLocale);
        DisplayRes.setLocale(resourceLocale);
        DialogsRes.setLocale(resourceLocale);
        String className = "org.opensourcephysics.ejs.EjsRes";
        try {
            Class<?> resClass = Class.forName(className);
            Method method = resClass.getMethod("setLocale", Locale.class);
            method.invoke(null, resourceLocale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        support.firePropertyChange(OSP_PROPERTY_LOCALE, prev, resourceLocale);
    }

    public static void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        if (property.equals(OSP_PROPERTY_LOCALE)) {
            support.addPropertyChangeListener(property, listener);
        }
    }

    public static void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        support.removePropertyChangeListener(property, listener);
    }
}

