/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.TableModelEvent;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTable;
import org.opensourcephysics.controls.XMLTableModel;
import org.opensourcephysics.display.Hidable;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.Translator;

public class TranslatorTool
extends JFrame
implements Tool,
Hidable,
Translator {
    private static TranslatorTool TOOL;
    private static Map<Class<?>, Map<String, String>> defaultProps;
    private static Map<Class<?>, Map<String, Map<String, String>>> classes;
    private static Map<Object, Class<?>> associates;
    private static Set<Map<String, String>> changed;
    private static Locale locale;
    private static Set<Class<?>> searched;
    private static Map<Class<?>, String> paths;
    private static Class<?> classType;
    private static boolean haveGUI;
    private boolean keepHidden = false;
    private XMLControl control = new XMLControlElement();
    private XMLTable table;
    private Dimension dim = new Dimension(320, 240);
    private String helpURL = "https://www.compadre.org/online_help/tools/translator_tool_help.html";
    private String fileExtension;
    private String preferredTitle = null;
    private JLabel descriptionLabel;
    private JComboBox<LocaleItem> localeDropDown;
    private Icon saveIcon;
    private JButton saveButton;
    private JButton closeButton;
    private JButton helpButton;

    static {
        defaultProps = new HashMap();
        classes = new HashMap();
        associates = new HashMap();
        changed = new HashSet<Map<String, String>>();
        locale = Locale.getDefault();
        searched = new HashSet();
        paths = new HashMap();
    }

    public static TranslatorTool getTool() {
        return TOOL == null ? (TOOL = new TranslatorTool()) : TOOL;
    }

    @Override
    @Deprecated
    public void show() {
        if (!this.keepHidden) {
            super.show();
        }
    }

    @Override
    public void dispose() {
        this.keepHidden = true;
        super.dispose();
    }

    @Override
    public void setVisible(boolean b) {
        if (!this.keepHidden) {
            super.setVisible(b);
        }
    }

    @Override
    public void setKeepHidden(boolean _keepHidden) {
        this.keepHidden = _keepHidden;
        if (this.keepHidden) {
            super.setVisible(false);
        }
    }

    @Override
    public boolean isKeepHidden() {
        return this.keepHidden;
    }

    private TranslatorTool() {
        if (OSPRuntime.appletMode) {
            this.keepHidden = true;
        }
        String name = "TranslatorTool";
        this.setName(name);
        this.setLocale(ToolsRes.resourceLocale);
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Locale locale = (Locale)e.getNewValue();
                if (locale != null) {
                    TranslatorTool.this.setLocale(locale);
                }
            }
        });
        Toolbox.addTool(name, this);
    }

    @Override
    public void send(Job job, Tool replyTo) {
    }

    @Override
    public String getProperty(Class<?> type, String key) {
        return TranslatorTool.getProperty(type, key, key, ToolsRes.resourceLocale);
    }

    @Override
    public String getProperty(Class<?> type, String key, String defaultValue) {
        return TranslatorTool.getProperty(type, key, defaultValue, ToolsRes.resourceLocale);
    }

    @Override
    public String getProperty(Object obj, String key) {
        return this.getProperty(obj, key, key);
    }

    @Override
    public String getProperty(Object obj, String key, String defaultValue) {
        if (obj == null) {
            return defaultValue == null ? key : defaultValue;
        }
        Class<?> type = associates.get(obj);
        return TranslatorTool.getProperty(type, key, defaultValue, ToolsRes.resourceLocale);
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == TranslatorTool.locale) {
            return;
        }
        TranslatorTool.locale = locale;
        if (!haveGUI) {
            return;
        }
        this.showPropertiesImpl(classType);
        LocaleItem item = null;
        if (this.localeDropDown != null) {
            int i = 0;
            while (i < this.localeDropDown.getItemCount()) {
                item = this.localeDropDown.getItemAt(i);
                if (item.loc.getLanguage().equals(locale.getLanguage())) break;
                item = null;
                ++i;
            }
            if (item == null) {
                item = new LocaleItem(locale);
                this.addDropDownItem(item);
            }
            this.localeDropDown.setSelectedItem(item);
            Map<String, String> properties = TranslatorTool.getProperties(classType, locale);
            this.saveButton.setEnabled(changed.contains(properties));
            TranslatorTool.refreshAssociates(classType);
        }
    }

    @Override
    public void showProperties(Class<?> type) {
        if (type == null) {
            return;
        }
        this.createGUI();
        this.showPropertiesImpl(type);
        this.setKeepHidden(false);
        this.setVisible(true);
    }

    private void showPropertiesImpl(Class<?> type) {
        if (type == null) {
            return;
        }
        classType = type;
        this.control.clearValues();
        this.fileExtension = "";
        String addon = locale.getLanguage();
        if (!addon.equals("")) {
            this.fileExtension = String.valueOf(this.fileExtension) + "_" + addon;
        }
        this.fileExtension = String.valueOf(this.fileExtension) + ".properties";
        Collection<String> names = this.control.getPropertyNamesRaw();
        for (String next : names) {
            this.control.setValue(next, next);
        }
        Map<String, String> properties = TranslatorTool.getProperties(type, locale);
        for (String key : properties.keySet()) {
            this.control.setValue(key, properties.get(key));
        }
        Set<String> keys = TranslatorTool.getDefaults(type).keySet();
        for (String key : properties.keySet()) {
            if (keys.contains(key)) continue;
            this.table.setBackgroundColor(key, Color.PINK);
        }
        this.table.refresh();
        this.refreshGUI();
    }

    public void setPreferredTitle(String title) {
        this.preferredTitle = title;
        if (haveGUI) {
            this.refreshGUI();
        }
    }

    private void addDropDownItem(LocaleItem item) {
        LocaleItem defaultItem;
        TreeMap<String, LocaleItem> items = new TreeMap<String, LocaleItem>();
        LocaleItem localeItem = defaultItem = item.isDefault() ? item : null;
        if (!item.isDefault()) {
            items.put(item.language.toLowerCase(), item);
        }
        int i = 0;
        while (i < this.localeDropDown.getItemCount()) {
            LocaleItem next = this.localeDropDown.getItemAt(i);
            if (next.isDefault()) {
                defaultItem = next;
            } else {
                items.put(next.language.toLowerCase(), next);
            }
            ++i;
        }
        this.localeDropDown.removeAllItems();
        if (defaultItem != null) {
            this.localeDropDown.addItem(defaultItem);
        }
        Iterator it = items.keySet().iterator();
        while (it.hasNext()) {
            this.localeDropDown.addItem((LocaleItem)items.get(it.next()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String save(String fileName) {
        block13: {
            File file;
            StringBuffer content;
            block12: {
                if (fileName == null || fileName.equals("")) {
                    return null;
                }
                int n = fileName.lastIndexOf("/");
                if (n < 0) {
                    n = fileName.lastIndexOf("\\");
                }
                if (n > 0) {
                    String dir = fileName.substring(0, n + 1);
                    File file2 = new File(dir);
                    if (!file2.exists()) {
                        XML.createFolders(dir);
                    }
                    if (!file2.exists()) {
                        return null;
                    }
                }
                content = new StringBuffer();
                String s = XML.stripExtension(fileName);
                content.append("# This is the " + s + ".properties file" + XML.NEW_LINE + XML.NEW_LINE);
                for (String key : this.control.getPropertyNamesRaw()) {
                    String alias = this.control.getString(key);
                    content.append(String.valueOf(key) + "=" + alias + XML.NEW_LINE);
                }
                file = new File(fileName);
                if (!file.exists() || file.canWrite()) break block12;
                JOptionPane.showMessageDialog(null, ControlsRes.getString("Dialog.ReadOnly.Message"), ControlsRes.getString("Dialog.ReadOnly.Title"), -1);
                return null;
            }
            try {
                FileOutputStream stream = new FileOutputStream(file);
                Charset charset = Charset.forName("UTF-8");
                Writer out = new OutputStreamWriter((OutputStream)stream, charset);
                out = new BufferedWriter(out);
                out.write(content.toString());
                out.flush();
                out.close();
                if (!file.exists()) break block13;
                OSPLog.finest(file.getAbsolutePath());
                Set<Map<String, String>> set = changed;
                synchronized (set) {
                    changed.remove(TranslatorTool.getProperties(classType, locale));
                }
                this.saveButton.setEnabled(false);
                return file.getAbsolutePath();
            }
            catch (IOException ex) {
                OSPLog.warning(ex.getMessage());
            }
        }
        return null;
    }

    private void createGUI() {
        if (haveGUI) {
            return;
        }
        XMLTableModel model = new XMLTableModel(this.control){

            @Override
            public String getColumnName(int column) {
                return column == 0 ? ToolsRes.getString("TranslatorTool.ColumnTitle.Property") : ToolsRes.getString("TranslatorTool.ColumnTitle.PropValue");
            }
        };
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setPreferredSize(this.dim);
        this.setContentPane(contentPane);
        this.setDefaultCloseOperation(1);
        this.table = new XMLTable(model);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (OSPRuntime.isPopupTrigger(e)) {
                    int i = 0;
                    while (i < TranslatorTool.this.table.getRowCount()) {
                        Rectangle rect = TranslatorTool.this.table.getCellRect(i, 0, true);
                        if (rect.contains(e.getX(), e.getY())) {
                            TranslatorTool.this.table.setRowSelectionInterval(i, i);
                            final String name = (String)TranslatorTool.this.table.getValueAt(i, 0);
                            JPopupMenu popup = new JPopupMenu();
                            JMenuItem removeItem = new JMenuItem(String.valueOf(ToolsRes.getString("TranslatorTool.Popup.MenuItem.Remove")) + " \"" + name + "\"");
                            popup.add(removeItem);
                            removeItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent ae) {
                                    TranslatorTool.removeProperty(classType, name);
                                }
                            });
                            popup.show(TranslatorTool.this.table, e.getX(), e.getY() + 8);
                        }
                        ++i;
                    }
                }
            }
        });
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        contentPane.add((Component)toolbar, "North");
        JScrollPane tableScroller = new JScrollPane(this.table);
        contentPane.add((Component)tableScroller, "Center");
        JToolBar buttonbar = new JToolBar();
        buttonbar.setFloatable(false);
        contentPane.add((Component)buttonbar, "South");
        this.descriptionLabel = new JLabel();
        this.descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 6));
        toolbar.add(this.descriptionLabel);
        this.localeDropDown = new JComboBox();
        LocaleItem selectedItem = new LocaleItem(locale);
        this.localeDropDown.addItem(selectedItem);
        Locale[] locales = OSPRuntime.getInstalledLocales();
        int i = 0;
        while (i < locales.length) {
            if (!locales[i].getDisplayLanguage().equals(locale.getDisplayLanguage())) {
                this.addDropDownItem(new LocaleItem(locales[i]));
            }
            ++i;
        }
        this.localeDropDown.setSelectedItem(selectedItem);
        this.localeDropDown.setEditable(true);
        this.localeDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object next = TranslatorTool.this.localeDropDown.getSelectedItem();
                if (next == null) {
                    return;
                }
                if (next instanceof LocaleItem) {
                    ToolsRes.setLocale(((LocaleItem)next).loc);
                } else if (TranslatorTool.isLanguage(next.toString())) {
                    String lang = new Locale(next.toString()).getLanguage();
                    Locale locale = null;
                    LocaleItem item = null;
                    int i = 0;
                    while (i < TranslatorTool.this.localeDropDown.getItemCount()) {
                        item = (LocaleItem)TranslatorTool.this.localeDropDown.getItemAt(i);
                        if (lang.equals(item.loc.getLanguage())) {
                            locale = item.loc;
                            break;
                        }
                        item = null;
                        ++i;
                    }
                    if (locale == null) {
                        locale = new Locale(next.toString());
                        Map properties = TranslatorTool.getProperties(classType, locale);
                        TranslatorTool.flagChange(properties);
                    }
                    ToolsRes.setLocale(locale);
                    if (item != null) {
                        TranslatorTool.this.localeDropDown.setSelectedItem(item);
                    }
                    TranslatorTool.this.localeDropDown.getEditor().selectAll();
                } else {
                    TranslatorTool.this.localeDropDown.setSelectedIndex(0);
                    TranslatorTool.this.localeDropDown.getEditor().selectAll();
                }
            }
        });
        toolbar.add(this.localeDropDown);
        this.helpButton = new JButton();
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextFrame frame;
                if (ResourceLoader.getResource(TranslatorTool.this.helpURL) != null) {
                    frame = new TextFrame(TranslatorTool.this.helpURL);
                } else {
                    String htmlFile = "/org/opensourcephysics/resources/tools/html/translator_tool_help.html";
                    frame = new TextFrame(htmlFile);
                }
                frame.setSize(800, 600);
                frame.setVisible(true);
            }
        });
        buttonbar.add(this.helpButton);
        String imageFile = "/org/opensourcephysics/resources/tools/images/save.gif";
        this.saveIcon = ResourceLoader.getImageIcon(imageFile);
        this.saveButton = new JButton(this.saveIcon);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TranslatorTool.this.save(String.valueOf(TranslatorTool.getPath(classType)) + TranslatorTool.this.fileExtension);
            }
        });
        this.saveButton.setEnabled(false);
        buttonbar.add(Box.createHorizontalGlue());
        buttonbar.add(this.saveButton);
        this.closeButton = new JButton();
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TranslatorTool.this.setVisible(false);
            }
        });
        buttonbar.add(this.closeButton);
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        this.setLocation(x, y);
        this.table.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Object val = e.getNewValue();
                if (val instanceof TableModelEvent) {
                    TableModelEvent event = (TableModelEvent)val;
                    int row = event.getFirstRow();
                    if (row < 0) {
                        return;
                    }
                    Map properties = TranslatorTool.getProperties(classType, locale);
                    String key = (String)TranslatorTool.this.table.getValueAt(row, 0);
                    String alias = (String)TranslatorTool.this.table.getValueAt(row, 1);
                    if (alias != null && !alias.equals("")) {
                        properties.put(key, alias);
                    } else {
                        TranslatorTool.this.table.setValueAt(key, row, 1);
                        properties.put(key, key);
                    }
                    TranslatorTool.refreshAssociates(classType);
                    TranslatorTool.flagChange(properties);
                    TranslatorTool.this.saveButton.setEnabled(true);
                }
            }
        });
        haveGUI = true;
    }

    protected void refreshGUI() {
        this.createGUI();
        String fileName = XML.getName(TranslatorTool.getPath(classType));
        if (this.preferredTitle == null) {
            String title = ToolsRes.getString("TranslatorTool.Title");
            title = String.valueOf(title) + " " + fileName;
            this.setTitle(title);
        } else {
            this.setTitle(this.preferredTitle);
        }
        fileName = String.valueOf(fileName) + this.fileExtension;
        if (classType != null) {
            Map<String, String> properties = TranslatorTool.getProperties(classType, locale);
            this.saveButton.setEnabled(changed.contains(properties));
        }
        this.helpButton.setText(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
        this.saveButton.setText(ToolsRes.getString("TranslatorTool.Button.Save"));
        this.saveButton.setToolTipText(String.valueOf(ToolsRes.getString("TranslatorTool.Button.Save.ToolTip")) + fileName);
        this.closeButton.setText(ToolsRes.getString("Tool.Button.Close"));
        this.closeButton.setToolTipText(ToolsRes.getString("Tool.Button.Close.ToolTip"));
        this.descriptionLabel.setText(ToolsRes.getString("TranslatorTool.Label.Description"));
        this.table.refresh();
    }

    private static synchronized String getProperty(Class<?> type, String key, String defaultValue, Locale locale) {
        if (defaultValue == null) {
            defaultValue = key;
        }
        if (type == null) {
            return defaultValue;
        }
        if (!TranslatorTool.getDefaults(type).keySet().contains(key)) {
            TranslatorTool.addProperty(type, key, defaultValue);
        }
        return TranslatorTool.getProperties(type, locale).get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getDefaults(Class<?> type) {
        Map<String, String> defaults = defaultProps.get(type);
        if (defaults == null) {
            defaults = new TreeMap<String, String>();
            Map<Class<?>, Map<String, String>> map = defaultProps;
            synchronized (map) {
                defaultProps.put(type, defaults);
            }
        }
        return defaults;
    }

    public static void addProperty(Class<?> type, String key, String defaultValue) {
        Map<String, Map<String, String>> locales;
        if (type == null || key == null) {
            return;
        }
        if (defaultValue == null) {
            defaultValue = key;
        }
        TranslatorTool.getDefaults(type).put(key, defaultValue);
        Map<String, String> properties = TranslatorTool.getProperties(type, locale);
        if (properties.get(key) == null) {
            properties.put(key, defaultValue);
            TranslatorTool.flagChange(properties);
        }
        if ((locales = classes.get(type)) != null) {
            Iterator<String> it = locales.keySet().iterator();
            while (it.hasNext()) {
                properties = locales.get(it.next());
                if (properties.get(key) != null) continue;
                properties.put(key, defaultValue);
                TranslatorTool.flagChange(properties);
            }
        }
        if (haveGUI) {
            TranslatorTool.getTool().showPropertiesImpl(classType);
        }
        TranslatorTool.refreshAssociates(classType);
    }

    public static void removeProperty(Class<?> type, String key) {
        if (type == null) {
            return;
        }
        TranslatorTool.getDefaults(type).remove(key);
        Map<String, Map<String, String>> locales = classes.get(type);
        if (locales != null) {
            Iterator<String> it = locales.keySet().iterator();
            while (it.hasNext()) {
                Map<String, String> properties = locales.get(it.next());
                properties.remove(key);
                TranslatorTool.flagChange(properties);
            }
        }
        if (haveGUI) {
            TranslatorTool.getTool().showPropertiesImpl(classType);
        }
        TranslatorTool.refreshAssociates(classType);
    }

    public static void removeProperty(Object obj, String key) {
        Class<?> type = associates.get(obj);
        TranslatorTool.removeProperty(type, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void flagChange(Map<String, String> properties) {
        Set<Map<String, String>> set = changed;
        synchronized (set) {
            changed.add(properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getProperties(Class<?> type, Locale locale) {
        Map<String, String> properties;
        Map<String, Map<String, String>> locales = classes.get(type);
        if (locales == null) {
            locales = new HashMap<String, Map<String, String>>();
            Map<Class<?>, Map<String, Map<String, String>>> map = classes;
            synchronized (map) {
                classes.put(type, locales);
            }
        }
        if ((properties = locales.get(locale.getLanguage())) == null) {
            properties = new TreeMap<String, String>();
            locales.put(locale.getLanguage(), properties);
            String path = TranslatorTool.getPath(type);
            Resource res = null;
            String lang = locale.getLanguage();
            if (!lang.equals("")) {
                res = ResourceLoader.getResource(String.valueOf(path) + "_" + lang + ".properties");
            }
            if (res == null) {
                res = ResourceLoader.getResource(String.valueOf(path) + ".properties");
            }
            if (res != null) {
                TranslatorTool.readProperties(res.openReader(), properties);
            } else {
                Map<String, String> defaults = TranslatorTool.getDefaults(type);
                for (String key : defaults.keySet()) {
                    String val = defaults.get(key);
                    properties.put(key, val);
                }
                TranslatorTool.flagChange(properties);
            }
        }
        return properties;
    }

    private static void readProperties(BufferedReader input, Map<String, String> map) {
        try {
            String next = input.readLine();
            while (next != null) {
                int i = next.indexOf("=");
                if (i > -1) {
                    String key = next.substring(0, i);
                    String val = next.substring(i + 1);
                    map.put(key, val);
                }
                next = input.readLine();
            }
        }
        catch (IOException ex) {
            return;
        }
    }

    public static Collection<Object> getAssociates(Class<?> type) {
        ArrayList<Object> c = new ArrayList<Object>();
        for (Object obj : associates.keySet()) {
            if (!associates.get(obj).equals(type)) continue;
            c.add(obj);
        }
        return c;
    }

    protected static void refreshAssociates(Class<?> type) {
        for (Object obj : TranslatorTool.getAssociates(type)) {
            if (obj instanceof XMLTable) {
                ((XMLTable)obj).refresh();
                continue;
            }
            if (!(obj instanceof PropertyChangeListener)) continue;
            ((PropertyChangeListener)obj).propertyChange(new PropertyChangeEvent(TranslatorTool.getTool(), "translation", null, null));
        }
    }

    @Override
    public synchronized void associate(Object obj, Class<?> type) {
        if (obj == null) {
            return;
        }
        associates.put(obj, type);
    }

    public static void setPath(Class<?> type, String directory) {
        if (!(directory = XML.forwardSlash(directory)).endsWith("/")) {
            directory = String.valueOf(directory) + "/";
        }
        paths.put(type, directory);
    }

    public static String getPath(Class<?> type) {
        if (type == null) {
            return null;
        }
        String path = paths.get(type);
        if (path != null) {
            return String.valueOf(path) + type.getSimpleName();
        }
        path = type.getName();
        int i = path.indexOf(".");
        while (i != -1) {
            path = String.valueOf(path.substring(0, i)) + "/" + path.substring(i + 1);
            i = path.indexOf(".");
        }
        return path;
    }

    protected static boolean isLanguage(String lang) {
        String[] languages = Locale.getISOLanguages();
        int i = 0;
        while (i < languages.length) {
            if (languages[i].equals(lang)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locale[] getTranslatedLocales(Class<?> type) {
        if (!searched.contains(type)) {
            Set<Class<?>> set = searched;
            synchronized (set) {
                searched.add(type);
            }
            Map<String, Map<String, String>> locales = classes.get(type);
            if (locales == null) {
                locales = new HashMap<String, Map<String, String>>();
                Map<Class<?>, Map<String, Map<String, String>>> map = classes;
                synchronized (map) {
                    classes.put(type, locales);
                }
            }
            if (!OSPRuntime.isApplet) {
                Set<String> langs = locales.keySet();
                String path = TranslatorTool.getPath(type);
                Resource res = null;
                String[] languages = Locale.getISOLanguages();
                int i = 0;
                while (i < languages.length) {
                    if (!langs.contains(languages[i]) && (res = ResourceLoader.getResource(String.valueOf(path) + "_" + languages[i] + ".properties")) != null) {
                        TreeMap<String, String> properties = new TreeMap<String, String>();
                        locales.put(languages[i], properties);
                        TranslatorTool.readProperties(res.openReader(), properties);
                    }
                    ++i;
                }
            }
        }
        TreeSet<String> languages = new TreeSet<String>();
        languages.addAll(classes.get(type).keySet());
        ArrayList<Locale> locales = new ArrayList<Locale>();
        Iterator it = languages.iterator();
        while (it.hasNext()) {
            locales.add(new Locale(((String)it.next()).toString()));
        }
        return locales.toArray(new Locale[0]);
    }

    private class LocaleItem {
        Locale loc;
        String language;

        LocaleItem(Locale locale) {
            this.loc = locale;
            this.language = OSPRuntime.getDisplayLanguage(this.loc);
            if (this.isDefault()) {
                this.language = String.valueOf(this.language) + " (" + ToolsRes.getString("TranslatorTool.Language.Default") + ")";
            }
        }

        public String toString() {
            return this.language;
        }

        public boolean isDefault() {
            return this.loc.getDisplayLanguage(this.loc).equals(Locale.getDefault().getDisplayLanguage(this.loc));
        }
    }
}

